Since our work contains GPT-3.5-turbo and mistral-7B, we need some GPU resource.

Our evaluation needs **Single A100 80G GPU Inference** .

Since our Mistral-7b is trained based on OpenAI's GPT-3.5, we do not require an Azure API key. Please use our API key. 

Thanks for your help.

## Environment

1. prepare python environment

```shell
conda create -n evolsql python=3.10
conda activate evolsql
pip install -r requirements.txt 
```

2. prepare API key

Please refrain from replacing the following API key if it is an Azure API key instead of an OpenAI API key, as our bias eliminator is trained using OpenAI's GPT-3.5 and not Azure's GPT-3.5 training.

```
export OPENAI_API_BASE="https://sapi.onechat.fun/v1"
export OPENAI_API_KEY="sk-boc2ckKMXbGtniJvF2A17233E20b4e9d9519C86427Eb0948"
```

## Run code without schema link

1. modify the data path in **run_for_bird.sh**

```shell
tables=".../tables.json" # the path of tables.json
dev_path=".../dev.json" # the path of dev.json
db_path=".../database" # the database dir path
cache_dir="./LMs" # the dir to save the models (mistral-7B)
PROCESS_NUM=1 # the number of supported processes related to processing data sets
API_CALL_NUM=100 # the number of supported simultaneous API requests, you can set 100 when use our api-key, it is suggested to set 1 or 2 when called offical API
GPU_NUM=1 # the number of GPUs to be used for inference
```

2. execute **run_for_bird.sh**

```shell
bash run_for_bird.sh
```

## Evaluate without schema link

1. modify the data path in **evaluate.sh**

```shell
db_root_path='.../dev_databases/' # the database dir path
diff_json_path='.../dev/dev.json' # the path of dev.json
ground_truth_path='.../dev/' # the gold SQL dir path
```

2. execute **evaluate.sh**

```shell
bash evaluate_mistral_fix_DL.sh
```

## Run code with schema link

1. modify the data path in **run_for_bird_with_schema.sh**

```shell
tables=".../tables.json" # the path of tables.json
dev_path=".../dev.json" # the path of dev.json
db_path=".../database" # the database dir path
cache_dir="./LMs" # the dir to save the models (mistral-7B)
PROCESS_NUM=1 # the number of supported processes related to processing data sets
API_CALL_NUM=100 # the number of supported simultaneous API requests, you can set 100 when use our api-key, it is suggested to set 1 or 2 when called offical API
GPU_NUM=1 # the number of GPUs to be used for inference
```

2. execute **run_for_bird_with_schema.sh**

```shell
bash run_for_bird_with_schema.sh
```

## Evaluate with schema link

1. modify the data path in **evaluate.sh**

```shell
db_root_path='.../dev_databases/' # the database dir path
diff_json_path='.../dev/dev.json' # the path of dev.json
ground_truth_path='.../dev/' # the gold SQL dir path
```

2. execute **evaluate_with_schema.sh**

```shell
bash evaluate_mistral_fix_DL.sh
```