SELECT MAX(frpm."percent (%) eligible free (k-12)")  FROM frpm  JOIN schools ON frpm.cdscode = schools.cdscode  WHERE schools.county = 'Alameda'
SELECT frpm.`percent (%) eligible free (ages 5-17)` FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.`eilname` = 'Continuation School' ORDER BY frpm.`percent (%) eligible free (ages 5-17)` LIMIT 3;
SELECT schools.zip  FROM schools  JOIN frpm ON frpm.cdscode = schools.cdscode  WHERE frpm."charter school (y/n)" = 1  AND schools.district = 'Fresno County Office of Education'
SELECT schools.mailstreet, schools.mailcity, schools.mailstate, schools.mailzip  FROM schools  JOIN frpm ON frpm.cdscode = schools.cdscode  WHERE frpm."enrollment (k-12)" = 'K-12'  ORDER BY frpm."frpm count (k-12)" DESC  LIMIT 1;
SELECT schools.phone  FROM schools  JOIN frpm ON frpm.cdscode = schools.cdscode  WHERE schools.opendate > '2000-01-01'  AND frpm."charter school (y/n)" = 1  AND frpm."charter funding type" = 'Directly funded'
SELECT COUNT(*)  FROM schools  JOIN satscores ON schools.cdscode = satscores.cds  WHERE satscores.avgscrmath < 400  AND schools.virtual = 'F'
SELECT schools.school FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.numtsttakr > 500 AND schools.magnet = 1
SELECT schools.phone FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.numtsttakr > 1500 ORDER BY satscores.numtsttakr DESC LIMIT 1;
SELECT satscores.numtsttakr  FROM satscores  JOIN frpm ON satscores.cds = frpm.cdscode  ORDER BY frpm."enrollment (k-12)" DESC  LIMIT 1;
SELECT COUNT(*)  FROM schools  WHERE schools.cdscode IN (     SELECT satscores.cds      FROM satscores      WHERE satscores.avgscrmath > 560 ) AND schools.fundingtype = 'Charter funded'
SELECT frpm."frpm count (ages 5-17)" FROM frpm JOIN satscores ON frpm.cdscode = satscores.cds WHERE satscores.avgscrread = (SELECT MAX(avgscrread) FROM satscores)
SELECT schools.cdscode  FROM schools  JOIN frpm ON frpm.cdscode = schools.cdscode  WHERE frpm."enrollment (k-12)" + frpm."enrollment (ages 5-17)" > 500
SELECT MAX("percent (%) eligible free (ages 5-17)") FROM satscores WHERE ("numge1500" / "numtsttakr") > 0.3
SELECT schools.phone FROM schools JOIN satscores ON schools.cdscode = satscores.cds ORDER BY satscores.numge1500 / satscores.numtsttakr DESC LIMIT 3;
SELECT schools.ncesschool  FROM schools  ORDER BY schools.gsserved DESC  LIMIT 5;
SELECT schools.district FROM schools JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.statustype = 'Active' ORDER BY satscores.avgscrread DESC LIMIT 1;
SELECT COUNT(*)  FROM schools  WHERE county = 'Alameda'  AND statustype = 'Merged'  AND cdscode IN (SELECT cdscode FROM satscores WHERE numtsttakr < 100)
SELECT schools.charternum FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE satscores.avgscrwrite = 499
SELECT COUNT(*)  FROM schools  JOIN frpm ON frpm.cdscode = schools.cdscode  JOIN satscores ON satscores.cds = schools.cdscode  WHERE schools.county = 'Contra Costa'  AND schools.fundingtype = 'Directly funded'  AND satscores.numtsttakr <= 250;
SELECT schools.phone FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.avgscrmath = (SELECT MAX(avgscrmath) FROM satscores)
SELECT COUNT(*) FROM schools WHERE county = 'Amador' AND "low grade" = '9' AND "high grade" = '12'
SELECT COUNT(*)  FROM schools  INNER JOIN frpm ON frpm.cdscode = schools.cdscode  WHERE frpm.`free meal count (k-12)` > 500 AND frpm.`free meal count (k-12)` < 700 AND schools.county = 'Los Angeles'
SELECT satscores.sname FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE schools.county = 'Contra Costa' ORDER BY satscores.numtsttakr DESC LIMIT 1;
SELECT schools.school, schools.street  FROM schools  JOIN frpm ON frpm.cdscode = schools.cdscode  JOIN satscores ON satscores.cds = schools.cdscode  WHERE (frpm."enrollment (k-12)" - frpm."enrollment (ages 5-17)") > 30
SELECT schools.school FROM frpm INNER JOIN schools ON frpm.cdscode = schools.cdscode INNER JOIN satscores ON satscores.cds = schools.cdscode WHERE frpm.`percent (%) eligible free (k-12)` > 0.1  AND satscores.numge1500 >= 1500
SELECT schools.school, schools.fundingtype FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.county = 'Riverside' AND (satscores.avgscrmath / satscores.numtsttakr) > 400;
SELECT schools.school, schools.street, schools.city, schools.zip, schools.state FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode WHERE schools.county = 'Monterey' AND schools.school LIKE '%High School%' AND frpm."free meal count (ages 5-17)" > 800
SELECT satscores.avgscrwrite, schools.school, schools.phone FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE schools.opendate > '1991-01-01' OR schools.closeddate < '2000-01-01'
SELECT schools.school, schools.doctype  FROM schools  JOIN frpm ON frpm.cdscode = schools.cdscode  JOIN satscores ON satscores.cds = schools.cdscode  WHERE schools.fundingtype = 'Locally funded'  AND (frpm."enrollment (k-12)" - frpm."enrollment (ages 5-17)") >  (SELECT AVG(frpm."enrollment (k-12)" - frpm."enrollment (ages 5-17)")  FROM frpm  JOIN schools ON frpm.cdscode = schools.cdscode  WHERE schools.fundingtype = 'Locally funded')
SELECT schools.opendate  FROM schools  WHERE schools.gsoffered = 'K-12'  ORDER BY schools.gsserved DESC  LIMIT 1;
SELECT schools.city FROM schools ORDER BY schools.enroll12 ASC LIMIT 5;
SELECT schools.school, frpm.`percent (%) eligible free (k-12)`  FROM schools  JOIN frpm ON schools.cdscode = frpm.cdscode  WHERE schools.gsserved LIKE '%10%' OR schools.gsserved LIKE '%11%'  ORDER BY frpm.`percent (%) eligible free (k-12)` DESC  LIMIT 10
SELECT frpm.`percent (%) eligible frpm (k-12)` FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.soc = 66 ORDER BY frpm.`frpm count (k-12)` DESC LIMIT 5
SELECT schools.website  FROM schools  WHERE schools.cdscode IN (     SELECT frpm.cdscode      FROM frpm      WHERE frpm."free meal count (ages 5-17)" BETWEEN 1900 AND 2000 )
SELECT schools.mailcity, schools.mailzip, schools.mailstate FROM schools WHERE schools.admfname1 = 'Kacey' AND schools.admlname1 = 'Gibson'
SELECT schools.admemail1  FROM schools  JOIN frpm ON frpm.cdscode = schools.cdscode  WHERE frpm."charter school (y/n)" = 1  ORDER BY frpm."enrollment (k-12)"  LIMIT 1;
SELECT schools.admfname1 || ' ' || schools.admlname1 AS full_name FROM schools JOIN satscores ON satscores.cds = schools.cdscode WHERE satscores.numge1500 = (SELECT MAX(numge1500) FROM satscores)
SELECT schools.street, schools.city, schools.zip, schools.state FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.numtsttakr > 0 ORDER BY satscores.numge1500 / satscores.numtsttakr ASC LIMIT 1;
SELECT schools.website FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.county = 'Los Angeles' AND satscores.numtsttakr BETWEEN 2000 AND 3000;
SELECT AVG(satscores.numtsttakr) FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE schools.opendate >= '1980-01-01' AND schools.opendate <= '1980-12-31' AND schools.county = 'Fresno'
SELECT schools.phone FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.district = 'Fresno Unified' ORDER BY satscores.avgscrread ASC LIMIT 1;
SELECT schools.school, satscores.avgscrread FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.virtual = 'F' ORDER BY satscores.avgscrread DESC LIMIT 5;
SELECT schools.edopsname FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.avgscrmath = (SELECT MAX(avgscrmath) FROM satscores)
SELECT satscores.avgscrmath, schools.county FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE (satscores.avgscrmath + satscores.avgscrread + satscores.avgscrwrite) = (     SELECT MIN(avgscrmath + avgscrread + avgscrwrite)     FROM satscores )
SELECT satscores.avgscrwrite, schools.city FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE satscores.numge1500 = (SELECT MAX(numge1500) FROM satscores) ORDER BY satscores.numtsttakr DESC LIMIT 1;
SELECT schools.school, satscores.avgscrwrite FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.admfname1 = 'Ricci' AND schools.admlname1 = 'Ulrich'
SELECT schools.state, schools.doc, SUM(schools.gsserved) as total_enrollment FROM schools WHERE schools.doc = '31' AND schools.gsoffered = 'K-12' GROUP BY schools.state ORDER BY total_enrollment DESC LIMIT 1;
SELECT COUNT(schools.school) / 12 FROM schools WHERE schools.county = 'Alameda' AND schools.doc = '52' AND schools.opendate LIKE '1980-%'
SELECT COUNT(*) / COUNT(*) FROM schools WHERE statustype = 'Merged' AND doctype = 'Unified School District' AND county = 'Orange' / (SELECT COUNT(*) FROM schools WHERE statustype = 'Merged' AND doctype = 'Elementary School District' AND county = 'Orange')
SELECT schools.county, schools.school, schools.closeddate FROM schools WHERE schools.statustype = 'Closed' GROUP BY schools.county ORDER BY COUNT(schools.school) DESC LIMIT 1;
SELECT schools.street FROM satscores JOIN schools ON satscores.cds = schools.cdscode ORDER BY satscores.avgscrmath DESC LIMIT 1 OFFSET 5;
SELECT schools.mailstreet, schools.school FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.avgscrread = (SELECT MIN(avgscrread) FROM satscores)
SELECT COUNT(*)  FROM schools  JOIN satscores ON schools.cdscode = satscores.cds  WHERE (satscores.avgscrread + satscores.avgscrmath + satscores.avgscrwrite) >= 1500  AND schools.mailcity = 'Lakeport'
SELECT COUNT(satscores.numtsttakr) FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE schools.mailcity = 'Fresno'
SELECT schools.school, schools.mailzip FROM schools WHERE schools.admfname2 = 'Avetik' AND schools.admlname2 = 'Atoian'
SELECT COUNT(*) FROM schools WHERE mailstate = 'CA' AND county = 'Colusa' / (SELECT COUNT(*) FROM schools WHERE mailstate = 'CA' AND county = 'Humboldt')
SELECT COUNT(*)  FROM schools  WHERE state = 'CA' AND county = 'San Joaquin' AND statustype = 'Active'
SELECT schools.phone, schools.ext FROM satscores JOIN schools ON satscores.cds = schools.cdscode ORDER BY satscores.avgscrwrite DESC LIMIT 1 OFFSET 332;
SELECT schools.phone, schools.ext, schools.school FROM schools WHERE schools.zip = '95203-3704'
SELECT schools.website FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE (schools.admfname1 = 'Mike' AND schools.admlname1 = 'Larson') OR (schools.admfname1 = 'Dante' AND schools.admlname1 = 'Alvarez')
SELECT schools.website FROM schools WHERE schools.virtual = 'P' AND schools.charter = 1 AND schools.county = 'San Joaquin'
SELECT COUNT(*)  FROM schools  WHERE city = 'Hickman'  AND doc = '52'  AND charter = '1'
SELECT COUNT(*)  FROM schools WHERE charter = 0 AND county = 'Los Angeles' AND "Free Meal Count (K-12)" * 100 / "Enrollment (K-12)" < 0.18
SELECT schools.school, schools.city, schools.admfname1 || ' ' || schools.admlname1 AS administrator1, schools.admfname2 || ' ' || schools.admlname2 AS administrator2, schools.admfname3 || ' ' || schools.admlname3 AS administrator3 FROM schools WHERE schools.charter = 1 AND schools.charternum = '00D2'
SELECT COUNT(*)  FROM schools  WHERE mailcity = 'Hickman' AND charternum = '00D4'
SELECT (COUNT(DISTINCT CASE WHEN fundingtype = 'Locally funded' THEN cdscode END) / COUNT(DISTINCT cdscode) * 100) AS ratio_percentage FROM schools WHERE county = 'Santa Clara'
SELECT COUNT(*)  FROM schools  WHERE opendate BETWEEN '2000-01-01' AND '2005-12-31'  AND county = 'Stanislaus'  AND fundingtype = 'Directly funded'
SELECT COUNT(*)  FROM schools  WHERE closeddate LIKE '1989%'  AND city = 'San Francisco'  AND doctype = 'Community College District'
SELECT schools.county FROM schools WHERE schools.soc = '11' AND schools.closeddate BETWEEN '1980-01-01' AND '1989-12-31' GROUP BY schools.county ORDER BY COUNT(*) DESC LIMIT 1;
SELECT schools.doc FROM schools WHERE schools.soctype = 'State Special Schools'
SELECT COUNT(*)  FROM schools  WHERE county = 'Alpine'  AND statustype IN ('Active', 'Closed')  AND soctype = 'District Community Day Schools'
SELECT schools.district code FROM schools WHERE schools.city = 'Fresno' AND schools.magnet = 0;
SELECT COUNT(frpm."enrollment (ages 5-17)") FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.school = 'California School for the Deaf-Fremont' AND schools.edopscode = 'SSS' AND frpm."academic year" = '2014-2015' AND frpm."enrollment (ages 5-17)" IS NOT NULL
SELECT frpm."free meal count (ages 5-17)" FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools."edopsname" = 'Youth Authority School' AND schools.mailstreet = 'PO Box 1040'
SELECT MIN(frpm."low grade")  FROM frpm  JOIN schools ON frpm.cdscode = schools.cdscode  WHERE schools.ncesdist = '613360'  AND schools.edopscode = 'SPECON'
SELECT schools.eilname, schools.school  FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE frpm.countycode = '37' AND frpm.nslpprovisionstatus = 'Breakfast Provision 2';
SELECT schools.city FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE frpm.low_grade = 9 AND frpm.high_grade = 12 AND frpm.nslp_provision_status = 'Lunch Provision 2' AND schools.county = 'Merced' AND schools.eilcode = 'HS'
SELECT schools.school, frpm.`percent (%) eligible frpm (ages 5-17)` FROM schools INNER JOIN frpm ON schools.cdscode = frpm.cdscode WHERE schools.gsserved = 'K-9' AND schools.county = 'Los Angeles'
SELECT schools.gsoffered FROM schools WHERE schools.city = 'Adelanto' GROUP BY schools.gsoffered ORDER BY COUNT(*) DESC LIMIT 1;
SELECT county, COUNT(*) as num_schools FROM schools WHERE (county = 'San Diego' OR county = 'Santa Barbara') AND virtual = 'F' GROUP BY county ORDER BY num_schools DESC LIMIT 1;
SELECT schools.school, schools.latitude FROM schools ORDER BY schools.latitude DESC LIMIT 1;
SELECT schools.city, schools.eilname, schools.school FROM schools WHERE schools.state = 'CA' ORDER BY schools.latitude ASC LIMIT 1;
SELECT schools.gsoffered FROM schools WHERE schools.longitude = (SELECT MAX(schools.longitude) FROM schools)
SELECT COUNT(DISTINCT schools.city) as city_count FROM schools WHERE schools.gsserved = 'K-8' AND schools.magnet = 1 AND schools.doc = 'Multiple Provision Types' GROUP BY schools.city
SELECT admfname1, COUNT(*) as count FROM schools GROUP BY admfname1 ORDER BY count DESC LIMIT 2
SELECT frpm.`percent (%) eligible free (k-12)`, frpm.`district code` FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.admfname1 = 'Alusine'
SELECT schools.admlname1 FROM schools WHERE schools.charternum = '40'
SELECT schools.admemail1 FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode WHERE schools.county = 'San Bernardino' AND schools.district = 'San Bernardino City Unified' AND schools.opendate BETWEEN '2009-01-01' AND '2010-12-31' AND schools.soctype = 'Intermediate/Middle Schools (Public)' AND schools.doctype = 'Unified School District'
SELECT schools.admemail1, schools.admemail2, schools.admemail3, schools.school FROM schools JOIN satscores ON satscores.cds = schools.cdscode WHERE satscores.numge1500 = (SELECT MAX(numge1500) FROM satscores)
SELECT COUNT(account.account_id) FROM account JOIN card ON account.account_id = card.disp_id JOIN disp ON card.disp_id = disp.disp_id JOIN client ON disp.client_id = client.client_id JOIN district ON account.district_id = district.district_id JOIN trans ON account.account_id = trans.account_id WHERE district.a3 = 'east Bohemia' AND card.issued > trans.date AND account.frequency = 'POPLATEK PO OBRATU'
SELECT COUNT(*)  FROM account  JOIN district ON account.district_id = district.district_id  WHERE district.a3 = 'Prague'
SELECT AVG(a12) AS avg_unemployment_1995, AVG(a13) AS avg_unemployment_1996 FROM district WHERE a12 IS NOT NULL AND a13 IS NOT NULL;
SELECT COUNT(DISTINCT district.district_id) FROM client JOIN account ON client.district_id = account.district_id JOIN district ON account.district_id = district.district_id WHERE gender = 'F' AND district.a11 > 6000 AND district.a11 < 10000
SELECT COUNT(DISTINCT client.client_id) FROM client JOIN district ON client.district_id = district.district_id WHERE client.gender = 'M' AND district.a3 = 'north Bohemia' AND district.a11 > 8000;
SELECT account.account_id FROM account JOIN client ON account.client_id = client.client_id JOIN district ON client.district_id = district.district_id GROUP BY account.account_id HAVING client.gender = 'F' AND client.birth_date = (     SELECT MIN(c.birth_date)     FROM client c     JOIN district d ON c.district_id = d.district_id     WHERE c.gender = 'F' ) AND district.a11 = (     SELECT MIN(d2.a11)     FROM district d2     JOIN client c2 ON c2.district_id = d2.district_id     WHERE c2.gender = 'F' ) AND district.a11 != (     SELECT MAX(d3.a11)     FROM district d3     JOIN client c3 ON c3.district_id = d3.district_id     WHERE c3.gender = 'F' )
SELECT account.account_id FROM account JOIN client ON account.district_id = client.district_id JOIN disp ON disp.account_id = account.account_id JOIN card ON card.disp_id = disp.disp_id GROUP BY account.account_id HAVING client.birth_date = (SELECT MIN(birth_date) FROM client) AND AVG(card.issued) = (SELECT MAX(A11) FROM district)
SELECT COUNT(*)  FROM account  JOIN disp ON account.account_id = disp.account_id  JOIN card ON disp.disp_id = card.disp_id  WHERE account.frequency = 'POPLATEK TYDNE' AND disp.type = 'OWNER'
SELECT client.client_id, client.gender, client.birth_date FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id JOIN card ON disp.disp_id = card.disp_id WHERE card.type = 'DISPONENT' AND account.frequency = 'POPLATEK PO OBRATU'
SELECT account.account_id FROM account JOIN loan ON account.account_id = loan.account_id WHERE loan.date LIKE '1997%' AND loan.status = 'A' AND loan.amount = ( SELECT MIN(amount) FROM loan WHERE loan.date LIKE '1997%' AND loan.status = 'A' ) AND account.frequency = 'POPLATEK TYDNE'
SELECT account.account_id FROM loan JOIN account ON loan.account_id = account.account_id WHERE loan.duration > 12 AND loan.amount = (SELECT MAX(loan.amount) FROM loan WHERE loan.duration > 12) AND account.date LIKE '1993-%'
SELECT COUNT(DISTINCT client.client_id) FROM client JOIN district ON client.district_id = district.district_id WHERE client.gender = 'F' AND client.birth_date < '1950-01-01' AND district.a2 = 'Slokolov'
SELECT account_id FROM account WHERE date = '1995-01-01'
SELECT account_id FROM account WHERE date < '1997-01-01' AND account_id IN (     SELECT account_id     FROM trans     WHERE amount > 3000 )
SELECT client.client_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id WHERE card.issued = '1994-03-03'
SELECT account.date FROM account JOIN trans ON account.account_id = trans.account_id WHERE trans.amount = 840 AND trans.date = '1998-10-14'
SELECT district_id FROM account WHERE account_id IN (     SELECT account_id     FROM loan     WHERE date = '1994-08-25' )
SELECT MAX(trans.amount) FROM trans JOIN card ON trans.account_id = card.disp_id WHERE card.issued = '1996-10-21'
SELECT client.gender  FROM client  JOIN disp ON client.client_id = disp.client_id  JOIN account ON disp.account_id = account.account_id  JOIN district ON account.district_id = district.district_id  WHERE district.a11 = (SELECT MAX(a11) FROM district)  ORDER BY client.birth_date ASC  LIMIT 1;
SELECT trans.amount FROM trans JOIN account ON trans.account_id = account.account_id JOIN loan ON loan.account_id = account.account_id WHERE loan.amount = (SELECT MAX(amount) FROM loan) AND trans.date > account.date ORDER BY trans.date ASC LIMIT 1;
SELECT COUNT(client.client_id)  FROM client  JOIN disp ON client.client_id = disp.client_id  JOIN account ON disp.account_id = account.account_id  JOIN district ON account.district_id = district.district_id  WHERE district.a2 = 'Jesenik' AND client.gender = 'F'
SELECT disp.disp_id FROM trans JOIN disp ON trans.account_id = disp.account_id WHERE trans.amount = 5100 AND trans.date = '1998-09-02'
SELECT COUNT(account_id) FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Litomerice' AND account.date LIKE '1996-%'
SELECT district.a2  FROM district JOIN client ON client.district_id = district.district_id JOIN account ON account.district_id = district.district_id WHERE client.gender = 'F' AND client.birth_date = '1976-01-29'
SELECT client.birth_date  FROM client  JOIN disp ON client.client_id = disp.client_id  JOIN account ON disp.account_id = account.account_id  JOIN loan ON account.account_id = loan.account_id  WHERE loan.amount = 98832 AND loan.date = '1996-01-03'
SELECT account.account_id  FROM account  JOIN disp ON account.account_id = disp.account_id  JOIN client ON disp.client_id = client.client_id  JOIN district ON client.district_id = district.district_id  WHERE district.a3 = 'Prague'  ORDER BY account.date  LIMIT 1;
SELECT (COUNT(client_id) * 100) / (SELECT COUNT(client_id) FROM client WHERE district_id IN (SELECT district_id FROM district WHERE a3 = 'south Bohemia')) FROM client WHERE gender = 'M' AND district_id IN (SELECT district_id FROM district WHERE a3 = 'south Bohemia')
SELECT ((trans.balance - t.balance) / t.balance) * 100 FROM trans JOIN (     SELECT balance     FROM trans     WHERE account_id = (         SELECT account_id         FROM loan         WHERE date = '1993-07-05'         LIMIT 1     ) AND date = '1993-03-22'     LIMIT 1 ) AS t WHERE trans.account_id = (     SELECT account_id     FROM loan     WHERE date = '1993-07-05'     LIMIT 1 ) AND trans.date = '1998-12-27' LIMIT 1
SELECT (COUNT(amount) * 100) / (SELECT COUNT(*) FROM loan WHERE status = 'A') FROM loan WHERE status = 'A'
SELECT ((COUNT(DISTINCT account.account_id) - COUNT(DISTINCT loan.account_id)) / COUNT(DISTINCT account.account_id)) * 100 FROM account LEFT JOIN loan ON account.account_id = loan.account_id WHERE loan.amount < 100000 AND loan.status = 'C'
SELECT account.account_id, district.a2, district.a3  FROM account  JOIN card ON account.account_id = card.disp_id  JOIN disp ON card.disp_id = disp.disp_id  JOIN client ON disp.client_id = client.client_id  JOIN district ON account.district_id = district.district_id  WHERE account.date > card.issued  AND account.frequency = 'POPLATEK PO OBRATU'  AND account.date LIKE '1993-%'
SELECT account.account_id, account.frequency FROM account JOIN district ON account.district_id = district.district_id WHERE district.a3 = 'east Bohemia' AND account.date BETWEEN '1995-01-01' AND '2000-12-31'
SELECT account_id, date FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Prachatice'
SELECT district.a2, district.a3 FROM loan JOIN account ON loan.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE loan.loan_id = '4990'
SELECT account.account_id, district.a2, district.a3 FROM account JOIN district ON account.district_id = district.district_id JOIN loan ON account.account_id = loan.account_id WHERE loan.amount > 300000;
SELECT loan.loan_id, district.a3, district.a11 FROM loan JOIN account ON loan.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE loan.duration = 60
SELECT district.a2, ((district.a13 - district.a12) / district.a12) * 100 AS unemployment_rate_increment FROM district JOIN account ON account.district_id = district.district_id JOIN loan ON loan.account_id = account.account_id WHERE loan.status = 'D' AND loan.date >= '1995-01-01' AND loan.date <= '1996-12-31'
SELECT COUNT(*) * 100 / (SELECT COUNT(*) FROM account WHERE date LIKE '1993%')  FROM account  JOIN district ON account.district_id = district.district_id  WHERE district.a2 = 'Decin' AND account.date LIKE '1993%'
SELECT account_id FROM account WHERE frequency = 'POPLATEK MESICNE'
SELECT district.a2, COUNT(client.client_id) AS female_account_holders FROM district JOIN client ON district.district_id = client.district_id WHERE client.gender = 'F' GROUP BY district.a2 ORDER BY female_account_holders DESC LIMIT 10;
SELECT district.a2, SUM(trans.amount) as total_withdrawals FROM trans JOIN account ON trans.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE trans.type = 'VYDAJ' AND trans.date LIKE '1996-01%' GROUP BY district.a2 ORDER BY total_withdrawals DESC LIMIT 10;
SELECT COUNT(DISTINCT client.client_id) FROM client JOIN district ON client.district_id = district.district_id LEFT JOIN disp ON client.client_id = disp.client_id LEFT JOIN card ON disp.disp_id = card.disp_id WHERE district.a3 = 'South Bohemia' AND card.card_id IS NULL
SELECT district.a3 FROM district JOIN account ON account.district_id = district.district_id JOIN loan ON loan.account_id = account.account_id WHERE loan.status = 'C' GROUP BY district.a3 ORDER BY COUNT(*) DESC LIMIT 1;
SELECT AVG(amount)  FROM loan  WHERE account_id IN (     SELECT account_id      FROM client      WHERE gender = 'M' )
SELECT district.a2, district.a3 FROM district WHERE district.a13 = (     SELECT MAX(district.a13)     FROM district     WHERE district.a13 IS NOT NULL )
SELECT COUNT(account_id) FROM account WHERE district_id = (     SELECT district_id     FROM district     WHERE a16 = (         SELECT MAX(a16)         FROM district     ) )
SELECT COUNT(DISTINCT account.account_id) FROM account JOIN trans ON account.account_id = trans.account_id JOIN card ON account.account_id = card.disp_id WHERE trans.operation = 'VYBER KARTOU' AND account.frequency = 'POPLATEK MESICNE' AND trans.balance < 0;
SELECT COUNT(DISTINCT loan.account_id) FROM loan JOIN account ON loan.account_id = account.account_id WHERE loan.date BETWEEN '1995-01-01' AND '1997-12-31' AND loan.amount >= 250000 AND account.frequency = 'POPLATEK MESICNE' AND loan.status = 'A'
SELECT COUNT(*) FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Branch location 1'
SELECT COUNT(client_id) FROM client WHERE district_id = (     SELECT district_id     FROM district     WHERE a15 = (         SELECT MAX(a15)         FROM district         WHERE a15 < (             SELECT MAX(a15)             FROM district         )     ) ) AND gender = 'M'
SELECT COUNT(card.card_id) FROM card JOIN disp ON card.disp_id = disp.disp_id WHERE disp.type = 'DISPONENT' AND card.type = 'gold'
SELECT COUNT(*)  FROM account  JOIN district ON account.district_id = district.district_id  WHERE district.a2 = 'Pisek'
SELECT district.a2 FROM district JOIN account ON account.district_id = district.district_id JOIN trans ON trans.account_id = account.account_id WHERE trans.amount > 10000 AND trans.date LIKE '1997-%'
SELECT account.account_id FROM account JOIN district ON account.district_id = district.district_id JOIN "order" ON account.account_id = "order".account_id WHERE district.a2 = 'Pisek' AND "order".k_symbol = 'SIPO'
SELECT account_id FROM account WHERE account_id IN (     SELECT account_id     FROM card     WHERE type = 'gold' ) AND account_id IN (     SELECT account_id     FROM card     WHERE type = 'junior' )
SELECT AVG(trans.amount) FROM trans JOIN account ON trans.account_id = account.account_id JOIN card ON account.account_id = card.disp_id WHERE trans.operation = 'VYBER KARTOU' AND strftime('%Y', trans.date) = '2021'
SELECT account.account_id FROM account JOIN disp ON account.account_id = disp.account_id JOIN card ON disp.disp_id = card.disp_id JOIN trans ON account.account_id = trans.account_id WHERE trans.operation = 'VYBER KARTOU' AND strftime('%Y', trans.date) = '1998' GROUP BY account.account_id HAVING SUM(trans.amount) < (SELECT AVG(trans.amount) FROM trans WHERE strftime('%Y', trans.date) = '1998')
SELECT client.client_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id JOIN card ON disp.disp_id = card.disp_id JOIN loan ON account.account_id = loan.account_id WHERE client.gender = 'F'
SELECT COUNT(DISTINCT client.client_id) FROM client JOIN district ON client.district_id = district.district_id WHERE client.gender = 'F' AND district.a3 = 'south Bohemia';
SELECT account.account_id FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Tabor' AND account.account_id IN (     SELECT account_id     FROM disp     WHERE type = 'OWNER' )
SELECT account.frequency FROM account JOIN district ON account.district_id = district.district_id WHERE account.frequency != 'OWNER' AND district.a11 > 8000 AND district.a11 <= 9000
SELECT COUNT(DISTINCT account.account_id) FROM account JOIN district ON account.district_id = district.district_id JOIN trans ON account.account_id = trans.account_id WHERE district.a3 = 'North Bohemia' AND trans.bank = 'AB'
SELECT district.a2 FROM district JOIN account ON account.district_id = district.district_id JOIN trans ON trans.account_id = account.account_id WHERE trans.type = 'VYDAJ'
SELECT AVG(district.a15) FROM district JOIN account ON account.district_id = district.district_id WHERE district.a15 > 4000 AND account.date >= '1997-01-01'
SELECT COUNT(*) FROM card INNER JOIN disp ON card.card_id = disp.disp_id INNER JOIN account ON disp.account_id = account.account_id WHERE card.type = 'classic' AND disp.type = 'OWNER'
SELECT COUNT(client.client_id) FROM client JOIN district ON client.district_id = district.district_id WHERE district.a2 = 'Hl.m. Praha' AND client.gender = 'M'
SELECT (COUNT(*) * 100) / (SELECT COUNT(*) FROM card WHERE type = 'gold' AND issued < '1998-01-01') FROM card WHERE type = 'gold' AND issued < '1998-01-01'
SELECT client.client_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id JOIN loan ON account.account_id = loan.account_id WHERE loan.amount = (SELECT MAX(amount) FROM loan)
SELECT COUNT(a15)  FROM district  WHERE district_id = 532
SELECT account.district_id FROM account JOIN `order` ON account.account_id = `order`.account_id WHERE `order`.order_id = 33333
SELECT trans_id, account_id, date, type, operation, amount, balance, k_symbol, bank, account FROM trans WHERE account_id IN (     SELECT account_id     FROM disp     WHERE client_id = 3356 ) AND operation = 'VYBER'
SELECT COUNT(account.account_id) FROM account JOIN loan ON account.account_id = loan.account_id WHERE account.frequency = 'POPLATEK TYDNE' AND loan.amount < 200000;
SELECT card.type FROM card JOIN disp ON card.disp_id = disp.disp_id JOIN client ON disp.client_id = client.client_id WHERE client.client_id = 13539;
SELECT district.a3 FROM client JOIN district ON client.district_id = district.district_id WHERE client.client_id = 3541;
SELECT district.a2 FROM district JOIN account ON account.district_id = district.district_id JOIN loan ON loan.account_id = account.account_id WHERE loan.status = 'A' GROUP BY district.a2 ORDER BY COUNT(*) DESC LIMIT 1;
SELECT client.client_id FROM client JOIN account ON client.district_id = account.district_id JOIN "order" ON account.account_id = "order".account_id WHERE "order".order_id = 32423;
SELECT trans.* FROM trans JOIN account ON trans.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE district.a4 = '5'
SELECT COUNT(*) FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Jesenik'
SELECT client.client_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id WHERE card.type = 'junior' AND card.issued >= '1997-01-01'
SELECT (SELECT COUNT(DISTINCT client_id)  FROM account  JOIN client ON account.district_id = client.district_id  JOIN district ON account.district_id = district.district_id  WHERE district.a11 > 10000) /  (SELECT COUNT(DISTINCT client_id)  FROM account  JOIN client ON account.district_id=client.district_id  JOIN district ON account.district_id=district.district_id  WHERE district.a11 > 10000  AND client.gender = 'F') * 100;
SELECT ((SUM(CASE WHEN loan.date BETWEEN '1996-01-01' AND '1996-12-31' THEN loan.amount ELSE 0 END) - SUM(CASE WHEN loan.date BETWEEN '1997-01-01' AND '1997-12-31' THEN loan.amount ELSE 0 END)) / SUM(CASE WHEN loan.date BETWEEN '1996-01-01' AND '1996-12-31' THEN loan.amount ELSE 0 END)) * 100 FROM loan JOIN account ON loan.account_id = account.account_id JOIN client ON account.account_id = client.client_id WHERE client.gender = 'M'
SELECT COUNT(*) FROM trans WHERE operation = 'VYBER KARTOU' AND date > '1995-01-01'
SELECT (SELECT district.a16 FROM district WHERE district.a3 = 'north Bohemia' AND district.a2 = '1996') - (SELECT district.a16 FROM district WHERE district.a3 = 'east Bohemia' AND district.a2 = '1996')
SELECT COUNT(*)  FROM disp  WHERE account_id = 1 AND type IN ('OWNER', 'DISPONENT')
SELECT COUNT(*) FROM trans WHERE account_id = 3 AND operation = 'VYBER' AND k_symbol = 'VYBER'
SELECT strftime('%Y', client.birth_date) AS birth_year FROM client JOIN disp ON client.client_id = disp.client_id WHERE disp.type = 'OWNER' AND disp.account_id = 130
SELECT COUNT(*)  FROM account  JOIN disp ON account.account_id = disp.account_id  WHERE disp.type = 'OWNER' AND account.frequency = 'POPLATEK PO OBRATU'
SELECT loan.amount, loan.status FROM loan JOIN account ON loan.account_id = account.account_id JOIN client ON account.account_id = client.client_id WHERE client.client_id = 992;
SELECT SUM(trans.amount), client.gender FROM trans JOIN account ON trans.account_id = account.account_id JOIN disp ON disp.account_id = account.account_id JOIN client ON disp.client_id = client.client_id WHERE client.client_id = 4 AND trans.trans_id = 851
SELECT card.type FROM card JOIN disp ON card.disp_id = disp.disp_id JOIN client ON disp.client_id = client.client_id WHERE client.client_id = 9;
SELECT SUM(trans.amount)  FROM trans  JOIN account ON trans.account_id = account.account_id  JOIN client ON account.account_id = client.client_id  WHERE client.client_id = 617 AND trans.date LIKE '1998-%'
SELECT client.client_id FROM client JOIN district ON client.district_id = district.district_id WHERE client.birth_date BETWEEN '1983-01-01' AND '1987-12-31' AND district.a3 = 'east Bohemia'
SELECT client.client_id FROM client JOIN loan ON client.client_id = loan.account_id WHERE client.gender = 'F' ORDER BY loan.amount DESC LIMIT 3;
SELECT COUNT(DISTINCT client.client_id) FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id JOIN trans ON account.account_id = trans.account_id WHERE client.gender = 'M' AND client.birth_date BETWEEN '1974-01-01' AND '1976-12-31' AND trans.type = 'PRIJEM' AND trans.k_symbol = 'SIPO' AND trans.amount > 4000;
SELECT COUNT(*)  FROM account  JOIN district ON account.district_id = district.district_id  WHERE district.a2 = 'Beroun' AND account.date > '1996-01-01'
SELECT COUNT(*)  FROM client  JOIN disp ON client.client_id = disp.client_id  JOIN card ON disp.disp_id = card.disp_id  WHERE client.gender = 'F' AND card.type = 'junior'
SELECT COUNT(client_id) * 100 / (SELECT COUNT(client_id) FROM client WHERE district_id IN (SELECT district_id FROM district WHERE a3 = 'Prague'))  FROM client  WHERE district_id IN (SELECT district_id FROM district WHERE a3 = 'Prague') AND gender = 'F'
SELECT (COUNT(DISTINCT client.client_id) * 100) / COUNT(DISTINCT CASE WHEN client.gender = 'M' AND account.frequency = 'POPLATEK TYDNE' THEN client.client_id END) FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id WHERE account.frequency = 'POPLATEK TYDNE'
SELECT COUNT(DISTINCT client.client_id) FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id WHERE account.frequency = 'POPLATEK TYDNE' AND client.gender = 'F'
SELECT account.account_id FROM loan JOIN account ON loan.account_id = account.account_id WHERE loan.duration > 24 AND loan.amount = ( SELECT MIN(amount) FROM loan WHERE duration > 24 ) AND account.date < '1997-01-01'
SELECT account.account_id FROM account JOIN disp ON account.account_id = disp.account_id JOIN client ON disp.client_id = client.client_id JOIN district ON client.district_id = district.district_id WHERE client.gender = 'F' ORDER BY client.birth_date ASC, district.a11 ASC LIMIT 1
SELECT COUNT(client_id) FROM client JOIN district ON client.district_id = district.district_id WHERE birth_date LIKE '1920-%' AND a3 = 'east Bohemia'
SELECT COUNT(*)  FROM loan  JOIN account ON loan.account_id = account.account_id  WHERE loan.duration = 24 AND account.frequency = 'POPLATEK TYDNE'
SELECT AVG(loan.amount) FROM loan WHERE loan.status = 'C' AND loan.date > (SELECT MAX(trans.date) FROM trans WHERE trans.k_symbol = 'POPLATEK PO OBRATU')
SELECT client.client_id, district.district_id FROM client JOIN district ON client.district_id = district.district_id WHERE client.client_id IN (     SELECT disp.client_id     FROM disp     JOIN account ON disp.account_id = account.account_id     WHERE disp.type = 'OWNER' )
SELECT client.client_id, (strftime('%Y', 'now') - strftime('%Y', client.birth_date)) AS age FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id WHERE card.type = 'gold'
SELECT bond_type FROM bond GROUP BY bond_type ORDER BY COUNT(*) DESC LIMIT 1;
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '-' AND atom.element = 'cl'
SELECT AVG(element = 'o') FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '-'
SELECT AVG(CASE WHEN molecule.label = '+' AND bond.bond_type = '-' THEN 1 ELSE 0 END) FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.bond_id = bond.bond_id AND connected.atom_id2 = atom.atom_id AND connected.atom_id = atom.atom_id;
SELECT COUNT(*) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'na' AND molecule.label = '-'
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '#' AND molecule.label = '+';
SELECT SUM(element = 'c') * 100.0 / COUNT(atom_id) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = ' = '
SELECT COUNT(*) FROM bond WHERE bond_type = '#';
SELECT COUNT(DISTINCT atom_id) FROM atom WHERE element != 'br'
SELECT COUNT(*)  FROM molecule  WHERE molecule_id BETWEEN 'TR000' AND 'TR099'  AND label = '+';
SELECT molecule.molecule_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'si'
SELECT atom.element FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE bond.bond_id = 'TR004_8_9'
SELECT element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '='
SELECT molecule.label FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'h' GROUP BY molecule.label ORDER BY COUNT(molecule.label) DESC LIMIT 1;
SELECT bond.bond_type FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element = 'te'
SELECT atom_id, atom_id2 FROM connected JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '-';
SELECT atom.atom_id, connected.atom_id2 FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '-'
SELECT element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '-' GROUP BY element ORDER BY COUNT(*) ASC LIMIT 1;
SELECT bond.bond_type FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id2 = atom.atom_id WHERE atom.atom_id = 'TR004_8' AND connected.atom_id = 'TR004_20'
SELECT DISTINCT molecule.label FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE atom.element != 'sn'
SELECT COUNT(DISTINCT atom.atom_id) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id WHERE (atom.element = 'i' OR atom.element = 's') AND bond.bond_type = '-';
SELECT connected.atom_id, connected.atom_id2 FROM connected JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '#'
SELECT atom.atom_id FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN molecule ON molecule.molecule_id = atom.molecule_id WHERE molecule.molecule_id = 'TR181'
SELECT SUM(atom.element = 'f') * 100.0 / COUNT(atom.molecule_id) as percent FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+' AND atom.element != 'f'
SELECT (SUM(bond_type = '#') * 100) / COUNT(bond_id) as percent FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond_type = '#' AND label = '+'
SELECT element FROM atom WHERE molecule_id = 'TR000' ORDER BY element LIMIT 3;
SELECT atom.atom_id FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR001' AND bond.bond_id = 'TR001_2_6'
SELECT (SUM(CASE WHEN molecule.label = '+' THEN 1 ELSE 0 END) - SUM(CASE WHEN molecule.label = '-' THEN 1 ELSE 0 END)) AS difference FROM molecule
SELECT atom_id FROM connected WHERE bond_id = 'TR_000_2_5'
SELECT connected.bond_id FROM connected WHERE connected.atom_id2 = 'TR000_2'
SELECT molecule.label FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = ' = ' ORDER BY molecule.label ASC LIMIT 5;
SELECT (SUM(bond_type = ' = ') / COUNT(bond_id)) * 100 as percent FROM bond WHERE molecule_id = 'TR008'
SELECT SUM(label = '+') * 100.0 / COUNT(molecule_id) as percent FROM molecule WHERE label = '+';
SELECT (SUM(element = 'h') * 100) / COUNT(atom_id) as percent FROM atom WHERE molecule_id = 'TR206'
SELECT bond.bond_type FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR000'
SELECT atom.element, molecule.label FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR060'
SELECT bond_type FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.label = '+' AND molecule.molecule_id = 'TR018' GROUP BY bond_type ORDER BY COUNT(*) DESC LIMIT 1;
SELECT molecule.label, molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id WHERE bond.bond_type = '-' AND molecule.label = '-' GROUP BY molecule.molecule_id ORDER BY molecule.molecule_id ASC LIMIT 3;
SELECT bond.bond_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR006' ORDER BY bond.bond_id LIMIT 2;
SELECT COUNT(*)  FROM bond  JOIN connected ON bond.bond_id = connected.bond_id  JOIN atom ON connected.atom_id = atom.atom_id OR connected.atom_id2 = atom.atom_id  JOIN molecule ON bond.molecule_id = molecule.molecule_id  WHERE molecule.molecule_id = 'TR009'  AND (atom.atom_id = 'TR009_12' OR connected.atom_id2 = 'TR009_12')
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+' AND atom.element = 'br'
SELECT bond.bond_type, connected.atom_id, connected.atom_id2 FROM bond JOIN connected ON bond.bond_id = connected.bond_id WHERE bond.bond_id = 'TR001_6_9'
SELECT molecule.label FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.atom_id = 'TR001_10'
SELECT COUNT(DISTINCT molecule_id) FROM bond WHERE bond_type = '#';
SELECT COUNT(*)  FROM connected  WHERE atom_id LIKE 'TR%_19' OR atom_id2 LIKE 'TR%_19'
SELECT atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR004'
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule WHERE molecule.label = '-'
SELECT molecule.label FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE SUBSTR(atom.atom_id, 7, 2) BETWEEN '21' AND '25' AND molecule.label = '+'
SELECT bond.bond_id FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id JOIN atom AS atom2 ON connected.atom_id2 = atom2.atom_id WHERE atom.element = 'p' AND atom2.element = 'n'
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = ' = ' GROUP BY molecule.molecule_id HAVING COUNT(*) = (     SELECT MAX(count)     FROM (         SELECT molecule.molecule_id, COUNT(*) as count         FROM molecule         JOIN bond ON molecule.molecule_id = bond.molecule_id         WHERE bond.bond_type = ' = '         GROUP BY molecule.molecule_id     ) )
SELECT AVG(COUNT(bond_id)/COUNT(atom_id)) FROM atom  INNER JOIN connected ON atom.atom_id = connected.atom_id INNER JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element = 'i'
SELECT bond.bond_type, bond.bond_id FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE SUBSTR(atom.atom_id, 7, 2) + 0 = 45
SELECT atom.element FROM atom WHERE atom.atom_id NOT IN (SELECT connected.atom_id FROM connected)
SELECT atom.atom_id FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id JOIN molecule ON molecule.molecule_id = atom.molecule_id WHERE molecule.molecule_id = 'TR447' AND bond.bond_type = '#';
SELECT atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR144_8_19'
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE molecule.label = '+' AND bond.bond_type = '=' GROUP BY molecule.molecule_id ORDER BY COUNT(*) DESC LIMIT 1;
SELECT element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+' GROUP BY element ORDER BY COUNT(*) ASC LIMIT 1;
SELECT atom_id FROM atom WHERE atom_id IN (     SELECT atom_id2     FROM connected     WHERE atom_id IN (         SELECT atom_id         FROM atom         WHERE element = 'pb'     ) )
SELECT atom.element FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE bond.bond_type = '#'
SELECT (COUNT(bond_id) * 100) / (SELECT COUNT(atom_id) FROM atom GROUP BY element ORDER BY COUNT(atom_id) DESC LIMIT 1) FROM connected GROUP BY bond_id ORDER BY COUNT(bond_id) DESC LIMIT 1;
SELECT SUM(label = '+') / COUNT(bond_id) FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond_type = '-'
SELECT COUNT(DISTINCT atom.atom_id) FROM atom WHERE atom.element IN ('c', 'h')
SELECT connected.atom_id2 FROM atom JOIN connected ON atom.atom_id = connected.atom_id WHERE atom.element = 's'
SELECT bond.bond_type FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element = 'sn'
SELECT COUNT(DISTINCT atom.element) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '-';
SELECT COUNT(DISTINCT atom.atom_id) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '#' AND (atom.element = 'p' OR atom.element = 'br')
SELECT bond.bond_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.label = '+'
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '-' AND molecule.label = '-'
SELECT SUM(atom.element = 'cl') * 100 / COUNT(atom.atom_id) as percent FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id JOIN molecule ON molecule.molecule_id = atom.molecule_id WHERE bond.bond_type = '-'
SELECT molecule.label FROM molecule WHERE molecule.molecule_id IN ('TR000', 'TR001', 'TR002')
SELECT molecule_id FROM molecule WHERE label = '-'
SELECT COUNT(DISTINCT molecule.molecule_id) AS total_carcinogenic_molecules FROM molecule WHERE molecule.molecule_id BETWEEN 'TR000' AND 'TR030' AND molecule.label = '+';
SELECT bond.bond_type FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.molecule_id BETWEEN 'TR000' AND 'TR050'
SELECT atom.element FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE bond.bond_id = 'TR001_10_11'
SELECT COUNT(DISTINCT bond.bond_id) FROM bond JOIN atom ON bond.molecule_id = atom.molecule_id WHERE atom.element = 'i'
SELECT molecule.label FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'ca' GROUP BY molecule.label ORDER BY COUNT(*) DESC LIMIT 1;
SELECT COUNT(*)  FROM bond  JOIN connected ON bond.bond_id = connected.bond_id  JOIN atom ON connected.atom_id2 = atom.atom_id  WHERE bond.bond_id = 'TR001_1_8'  AND (atom.element = 'cl' OR atom.element = 'c')
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id JOIN atom ON molecule.molecule_id = atom.molecule_id JOIN connected ON atom.atom_id = connected.atom_id WHERE bond.bond_type = '#' AND atom.element = 'c' AND molecule.label = '-'
SELECT (SUM(atom.element = 'cl') * 100 / COUNT(molecule.molecule_id)) as percentage FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+'
SELECT atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR001'
SELECT molecule_id FROM bond WHERE bond_type = '=';
SELECT atom_id, atom_id2 FROM connected JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '#'
SELECT atom.element FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE bond.bond_id = 'TR005_16_26'
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '-' AND molecule.label = '-'
SELECT molecule.label FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_id = 'TR001_10_11'
SELECT bond.bond_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '#' AND molecule.label = '+';
SELECT element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+' AND substr(atom.atom_id, 7, 1) = '4'
SELECT label, SUM(element = 'h') / COUNT(element) AS hydrogen_ratio FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR006'
SELECT m.label FROM atom a JOIN molecule m ON a.molecule_id = m.molecule_id WHERE a.element = 'ca'
SELECT bond.bond_type FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element = 'te'
SELECT atom.element FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE bond.bond_id = 'TR001_10_11'
SELECT COUNT(DISTINCT molecule_id) * 100.0 / (SELECT COUNT(DISTINCT molecule_id) FROM bond WHERE bond_type = '#') FROM bond WHERE bond_type = '#'
SELECT (SUM(CASE WHEN bond_type = ' = ' THEN 1 ELSE 0 END) * 100) / COUNT(bond_id) as percent FROM bond WHERE molecule_id = 'TR047'
SELECT m.label FROM atom a JOIN molecule m ON a.molecule_id = m.molecule_id WHERE a.atom_id = 'TR001_1'
SELECT molecule.label FROM molecule WHERE molecule.molecule_id = 'TR151'
SELECT element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = 'TR151'
SELECT COUNT(DISTINCT molecule_id) FROM molecule WHERE label = '+';
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'c' AND substr(molecule.molecule_id, 3, 3) > 10 AND substr(molecule.molecule_id, 3, 3) < 50;
SELECT COUNT(atom.atom_id) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+';
SELECT bond.bond_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '=' AND molecule.label = '+';
SELECT COUNT(atom.atom_id) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'h' AND molecule.label = '+'
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id WHERE bond.bond_id = 'TR00_1_2' AND atom.atom_id = 'TR00_1'
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'c' AND molecule.label = '-'
SELECT (SUM(label = '+' AND element = 'h') / COUNT(molecule.molecule_id) * 100.0) AS percentage FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'h' AND molecule.label = '+';
SELECT m.label FROM molecule m WHERE m.molecule_id = 'TR124'
SELECT atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR186'
SELECT bond_type FROM bond WHERE bond_id = 'TR007_4_19'
SELECT atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR001_2_4'
SELECT COUNT(*)  FROM bond  WHERE molecule_id = 'TR006' AND bond_type = '=';
SELECT molecule.molecule_id, atom.element FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+'
SELECT bond.bond_id, atom.atom_id, connected.atom_id2 FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id WHERE bond.bond_type = '-';
SELECT molecule.molecule_id, atom.element FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '#';
SELECT atom.element FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE bond.bond_id = 'TR000_2_3'
SELECT COUNT(*)  FROM bond  JOIN connected ON bond.bond_id = connected.bond_id  JOIN atom ON connected.atom_id = atom.atom_id  WHERE atom.element = 'cl'
SELECT atom.atom_id, COUNT(DISTINCT bond.bond_type) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR346' GROUP BY atom.atom_id;
SELECT COUNT(DISTINCT molecule.molecule_id) FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '=' AND molecule.label = '+';
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule LEFT JOIN atom ON atom.molecule_id = molecule.molecule_id LEFT JOIN bond ON bond.molecule_id = molecule.molecule_id LEFT JOIN connected ON connected.atom_id = atom.atom_id WHERE atom.element != 's' AND bond.bond_type != '=';
SELECT molecule.label FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_id = 'TR001_2_4'
SELECT COUNT(*) FROM atom WHERE molecule_id = 'TR005';
SELECT COUNT(*) FROM bond WHERE bond_type = '-';
SELECT molecule.molecule_id FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'cl' AND molecule.label = '+';
SELECT molecule.molecule_id FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'c' AND molecule.label = '-'
SELECT SUM(label = '+' AND element = 'cl') * 100 / COUNT(molecule.molecule_id) as percentage FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+'
SELECT molecule_id FROM bond WHERE bond_id = 'TR001_1_7'
SELECT COUNT(DISTINCT element) FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR001_3_4'
SELECT bond.bond_type FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id JOIN atom AS atom2 ON connected.atom_id2 = atom2.atom_id WHERE atom.atom_id = 'TR000_1' AND atom2.atom_id = 'TR000_2'
SELECT molecule.label FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.atom_id = "TR000_2" UNION SELECT molecule.label FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.atom_id = "TR000_4"
SELECT atom.element FROM atom WHERE atom.atom_id = 'TR000_1'
SELECT m.label FROM molecule m WHERE m.molecule_id = 'TR000'
SELECT (CAST(SUM(bond_type = '-') AS FLOAT) / COUNT(bond_id)) * 100 AS percentage FROM bond
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'n' AND molecule.label = '+';
SELECT molecule.molecule_id FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE atom.element = 's' AND bond.bond_type = '=';
SELECT molecule.molecule_id FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id GROUP BY molecule.molecule_id HAVING COUNT(atom.atom_id) > 5 AND molecule.label = '-'
SELECT atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id WHERE molecule.label = 'TR024' AND bond.bond_type = '=';
SELECT molecule.molecule_id FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+' GROUP BY molecule.molecule_id ORDER BY COUNT(atom.molecule_id) DESC LIMIT 1;
SELECT (SUM(molecule.label = '+') * 100.0 / COUNT(molecule.molecule_id)) AS percentage FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.bond_id = bond.bond_id WHERE atom.element = 'h' AND bond.bond_type = '#';
SELECT COUNT(DISTINCT molecule_id) FROM molecule WHERE label = '+';
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN bond ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '-' AND molecule.molecule_id BETWEEN 'TR004' AND 'TR010';
SELECT COUNT(*)  FROM atom  WHERE molecule_id = 'TR008' AND element = 'c'
SELECT atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.atom_id = 'TR004_7' AND molecule.label = '-'
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE atom.element = 'o' AND bond.bond_type = '=';
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '#' AND molecule.label = '-'
SELECT atom.element, bond.bond_type FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR016'
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id WHERE molecule.label = 'TR012' AND atom.element = 'c' AND bond.bond_type = '=';
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+' AND atom.element = 'o'
SELECT cards.name FROM cards WHERE cards.cardkingdomfoilid = cards.cardkingdomid AND cards.cardkingdomid IS NOT NULL
SELECT cards.name FROM cards WHERE cards.bordercolor = 'borderless' AND cards.cardkingdomfoilid IS NULL AND cards.cardkingdomid IS NULL
SELECT cards.name FROM cards WHERE cards.faceconvertedmanacost = (     SELECT MAX(faceconvertedmanacost)     FROM cards )
SELECT cards.name FROM cards WHERE cards.frameversion = '2015' AND cards.edhrecrank < 100
SELECT cards.name FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.rarity = 'mythic' AND legalities.format = 'gladiator' AND legalities.status = 'Banned'
SELECT legalities.status FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.types = 'Artifact' AND cards.side IS NULL AND legalities.format = 'vintage'
SELECT cards.id, cards.artist FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.power = '*' OR cards.power IS NULL AND legalities.format = 'commander' AND legalities.status = 'Legal'
SELECT cards.name, rulings.text FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.artist = 'Stephen Daniele'
SELECT rulings.text FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.name = 'Sublime Epiphany' AND cards.number = '74s'
SELECT cards.name, cards.artist, cards.ispromo FROM cards JOIN rulings ON cards.uuid = rulings.uuid GROUP BY cards.name, cards.artist, cards.ispromo HAVING COUNT(rulings.uuid) = (SELECT MAX(count) FROM (SELECT COUNT(rulings.uuid) AS count FROM cards JOIN rulings ON cards.uuid = rulings.uuid GROUP BY cards.name) AS counts) AND cards.ispromo = 1;
SELECT foreign_data.language FROM foreign_data JOIN cards ON foreign_data.uuid = cards.uuid WHERE cards.name = 'Annul' AND cards.number = '29'
SELECT cards.name FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Japanese'
SELECT (COUNT(cards.id) * 100) / (SELECT COUNT(*) FROM cards)  FROM cards  JOIN foreign_data ON cards.uuid = foreign_data.uuid  WHERE foreign_data.language = 'Chinese Simplified'
SELECT sets.name, sets.totalsetsize FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language = 'Italian'
SELECT COUNT(DISTINCT cards.type)  FROM cards  WHERE cards.artist = 'Aaron Boyd'
SELECT keywords FROM cards WHERE name = 'Angel of Mercy'
SELECT COUNT(*) FROM cards WHERE power = '*';
SELECT promotypes FROM cards WHERE name = 'Duress'
SELECT cards.bordercolor FROM cards WHERE cards.name = "Ancestor's Chosen"
SELECT cards.originaltype FROM cards WHERE cards.name = "Ancestor's Chosen"
SELECT foreign_data.language FROM foreign_data JOIN sets ON foreign_data.uuid = sets.id JOIN cards ON cards.setcode = sets.code WHERE cards.name = 'Angel of Mercy'
SELECT COUNT(*)  FROM cards  JOIN legalities ON cards.uuid = legalities.uuid  WHERE legalities.status = 'restricted' AND cards.istextless = 0;
SELECT rulings.text FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.name = "Condemn"
SELECT COUNT(*)  FROM cards  JOIN legalities ON cards.uuid = legalities.uuid  WHERE legalities.status = 'restricted'  AND cards.isstarter = 1
SELECT legalities.status FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.name = "Cloudchaser Eagle"
SELECT cards.type FROM cards WHERE cards.name = 'Benalish Knight'
SELECT legalities.status FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.name = 'Benalish Knight'
SELECT cards.artist FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Phyrexian'
SELECT (COUNT(id) * 100) / (SELECT COUNT(id) FROM cards) FROM cards WHERE bordercolor = 'borderless'
SELECT COUNT(*)  FROM cards  JOIN foreign_data ON cards.uuid = foreign_data.uuid  WHERE foreign_data.language = 'German' AND cards.isreprint = 1
SELECT COUNT(*)  FROM cards  JOIN foreign_data ON cards.uuid = foreign_data.uuid  WHERE bordercolor = 'borderless' AND language = 'Russian'
SELECT (COUNT(cards.uuid) * 100) / (SELECT COUNT(cards.uuid) FROM cards WHERE cards.isstoryspotlight = 1) FROM cards WHERE cards.isstoryspotlight = 1 AND cards.uuid IN (SELECT cards.uuid FROM foreign_data WHERE foreign_data.language = 'French')
SELECT COUNT(*) FROM cards WHERE toughness = 99;
SELECT cards.name FROM cards WHERE cards.artist = 'Aaron Boyd'
SELECT COUNT(*)  FROM cards  WHERE bordercolor = 'black' AND availability = 'mtgo'
SELECT cards.id FROM cards WHERE cards.convertedmanacost = 0;
SELECT cards.layout FROM cards WHERE cards.keywords LIKE '%Flying%'
SELECT COUNT(*)  FROM cards  WHERE originaltype = 'Summon - Angel'  AND subtypes != 'Angel';
SELECT cards.id FROM cards WHERE cards.cardkingdomfoilid IS NOT NULL AND cards.cardkingdomid IS NOT NULL
SELECT cards.id FROM cards WHERE cards.dueldeck = 'a'
SELECT cards.edhrecrank FROM cards WHERE cards.frameversion = '2015'
SELECT cards.artist FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Chinese Simplified'
SELECT cards.name FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.availability = 'paper' AND foreign_data.language = 'Japanese'
SELECT COUNT(*)  FROM cards  WHERE borderColor = 'white'  AND id IN (SELECT uuid FROM legalities WHERE status = 'Banned')
SELECT cards.uuid, foreign_data.language FROM cards JOIN legalities ON cards.uuid = legalities.uuid JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE legalities.format = 'legacy'
SELECT rulings.text FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.name = 'Beacon of Immortality'
SELECT COUNT(*) AS card_count, legalities.status FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.frameversion = 'future' GROUP BY legalities.status;
SELECT cards.name, cards.colors FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.code = 'OGW'
SELECT cards.name, set_translations.language FROM cards JOIN set_translations ON cards.uuid = set_translations.setcode WHERE cards.convertedmanacost = 5 AND set_translations.setcode = '10E'
SELECT cards.name, rulings.date FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.originaltype = 'Creature - Elf'
SELECT cards.colors, legalities.format FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.id BETWEEN 1 AND 20
SELECT cards.name FROM cards JOIN foreign_data ON foreign_data.uuid = cards.uuid WHERE cards.colors = 'B' AND foreign_data.language != 'English'
SELECT cards.name  FROM cards  JOIN rulings ON rulings.uuid = cards.uuid  WHERE cards.rarity = 'uncommon'  ORDER BY rulings.date ASC  LIMIT 3;
SELECT COUNT(DISTINCT cards.id) FROM cards WHERE cards.artist = 'John Avon' AND cards.cardkingdomid IS NULL AND cards.cardkingdomfoilid IS NULL;
SELECT COUNT(*)  FROM cards  WHERE bordercolor = 'white'  AND cardkingdomfoilid = cardkingdomid  AND cardkingdomid IS NOT NULL
SELECT COUNT(*)  FROM cards  WHERE artist = 'UDON'  AND availability = 'mtgo'  AND hand = -1
SELECT COUNT(*)  FROM cards  WHERE frameversion = '1993'  AND availability = 'paper'  AND hascontentwarning = 1;
SELECT cards.manacost FROM cards WHERE cards.layout = 'normal' AND cards.frameversion = '2003' AND cards.bordercolor = 'black' AND (cards.availability = 'paper' OR cards.availability = 'mtgo')
SELECT SUM(cards.convertedmanacost)  FROM cards  WHERE cards.artist = 'Rob Alexander'
SELECT DISTINCT types FROM cards WHERE availability = 'arena'
SELECT sets.code FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE set_translations.language = 'Spanish'
SELECT (COUNT(hand = '+3') * 100) / COUNT(id) FROM cards WHERE frameEffects = 'legendary'
SELECT cards.id FROM cards WHERE cards.isstoryspotlight = 1 AND cards.text IS NOT NULL;
SELECT cards.name FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Spanish'
SELECT set_translations.language  FROM sets  JOIN set_translations ON sets.code = set_translations.setcode  JOIN cards ON sets.code = cards.setcode WHERE sets.basesetsize = 309
SELECT COUNT(*)  FROM set_translations  JOIN sets ON set_translations.setcode = sets.code  WHERE sets.block = 'Commander'  AND set_translations.language = 'Portuguese (Brazil)';
SELECT cards.id FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.types LIKE '%Creature%' AND legalities.status = 'Legal'
SELECT DISTINCT type FROM cards WHERE subtypes IS NOT NULL AND supertypes IS NOT NULL AND EXISTS (     SELECT *     FROM foreign_data     WHERE foreign_data.uuid = cards.uuid     AND language = 'German' )
SELECT COUNT(*)  FROM cards  WHERE power IS NULL  AND originaltext LIKE '%triggered ability%';
SELECT COUNT(*)  FROM cards  JOIN legalities ON cards.uuid = legalities.uuid  JOIN rulings ON cards.uuid = rulings.uuid  WHERE legalities.format = 'pre-modern'  AND rulings.text = 'This is a triggered mana ability'  AND cards.side IS NULL
SELECT cards.id FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.artist = 'Erica Yang' AND legalities.format = 'pauper' AND cards.availability = 'paper'
SELECT cards.artist FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.flavortext = "Das perfekte Gegenmittel zu einer dichten Formation"
SELECT foreign_data.name FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.artist = 'Matthew D. Wilson' AND cards.layout = 'normal' AND cards.bordercolor = 'black' AND foreign_data.language = 'French'
SELECT COUNT(*)  FROM cards  JOIN rulings ON cards.uuid = rulings.uuid  WHERE cards.rarity = 'rare'  AND rulings.date = '2009-01-10'
SELECT set_translations.language FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.block = 'Ravnica' AND sets.basesetsize = 180
SELECT (COUNT(cards.hasContentWarning = 0) * 100) / COUNT(cards.ID)  FROM cards  JOIN legalities ON cards.uuid = legalities.uuid  WHERE legalities.format = 'commander' AND legalities.status = 'legal'
SELECT (COUNT(CASE WHEN foreign_data.language = 'French' AND (cards.power IS NULL OR cards.power = '*') THEN 1 END) / COUNT(CASE WHEN cards.power IS NULL OR cards.power = '*' THEN 1 END)) * 100 AS percentage FROM cards, foreign_data WHERE foreign_data.uuid = cards.uuid
SELECT (COUNT(language = 'Japanese' AND type = 'expansion') / COUNT(language = 'Japanese')) * 100 FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE language = 'Japanese'
SELECT cards.availability FROM cards WHERE cards.artist = 'Daren Bader'
SELECT COUNT(*)  FROM cards  WHERE borderColor = 'borderless' AND edhrecRank > 12000
SELECT COUNT(*) FROM cards WHERE isoversized = 1 AND isreprint = 1 AND ispromo = 1;
SELECT cards.name FROM cards JOIN sets ON cards.setcode = sets.code WHERE (cards.power IS NULL OR cards.power = '*') AND cards.promotypes LIKE '%arenaleague%' ORDER BY cards.name ASC LIMIT 3;
SELECT foreign_data.language FROM foreign_data WHERE foreign_data.multiverseid = 149934;
SELECT cards.cardkingdomfoilid, cards.cardkingdomid FROM cards WHERE cards.cardkingdomfoilid IS NOT NULL AND cards.cardkingdomid IS NOT NULL ORDER BY cards.cardkingdomfoilid ASC LIMIT 3
SELECT (COUNT(CASE WHEN cards.istextless = 1 AND cards.layout = 'normal' THEN 1 END) / COUNT(cards.istextless)) * 100 FROM cards
SELECT cards.number FROM cards WHERE cards.side IS NULL AND cards.subtypes LIKE '%Angel%' AND cards.subtypes LIKE '%Wizard%'
SELECT sets.name FROM sets WHERE sets.mtgoCode IS NULL OR sets.mtgoCode = '' ORDER BY sets.name ASC LIMIT 3;
SELECT foreign_data.language FROM foreign_data JOIN sets ON foreign_data.uuid = sets.id WHERE sets.mcmname = 'Archenemy' AND sets.code = 'ARC'
SELECT sets.name, set_translations.translation FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.id = 5;
SELECT set_translations.language, sets.type FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.id = 206;
SELECT sets.id, sets.name FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language = 'Italian' AND sets.block = 'Shadowmoor' ORDER BY sets.name ASC LIMIT 2;
SELECT sets.id FROM sets WHERE sets.isforeignonly = 1 AND sets.isfoilonly = 1 AND sets.id IN (     SELECT set_translations.id     FROM set_translations     WHERE set_translations.language = 'Japanese' )
SELECT set_translations.translation FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE set_translations.language = 'Russian' ORDER BY sets.basesetsize DESC LIMIT 1;
SELECT (COUNT(*) * 100) / (SELECT COUNT(*) FROM cards)  FROM cards  JOIN foreign_data ON cards.uuid = foreign_data.uuid  WHERE foreign_data.language = 'Chinese Simplified'  AND cards.isonlineonly = 1
SELECT COUNT(DISTINCT sets.id)  FROM sets  LEFT JOIN set_translations ON sets.code = set_translations.setcode  WHERE set_translations.language = 'Japanese'  AND (sets.mtgoCode IS NULL OR sets.mtgoCode = '')
SELECT cards.id FROM cards WHERE cards.bordercolor = 'black'
SELECT cards.id FROM cards WHERE cards.frameeffects = 'extendedart'
SELECT cards.name FROM cards WHERE cards.bordercolor = 'black' AND cards.isfullart = 1;
SELECT language FROM set_translations WHERE setcode = "174"
SELECT sets.name FROM sets WHERE sets.code = "ALL"
SELECT foreign_data.language FROM foreign_data JOIN cards ON foreign_data.uuid = cards.uuid WHERE cards.name = 'A Pedra Fellwar'
SELECT sets.code FROM sets WHERE sets.releasedate = '2007-07-13'
SELECT sets.basesetsize, sets.code FROM sets WHERE sets.block = "Masques" AND sets.name = "Mirage"
SELECT sets.code FROM sets WHERE sets.type = 'expansion'
SELECT foreign_data.name, cards.type FROM cards JOIN foreign_data ON foreign_data.uuid = cards.uuid WHERE cards.watermark = 'boros'
SELECT foreign_data.language, foreign_data.flavortext, cards.type FROM cards JOIN foreign_data ON foreign_data.uuid = cards.uuid WHERE cards.watermark = 'colorpie'
SELECT (COUNT(*) * 100) / (SELECT COUNT(*) FROM cards WHERE name = 'Abyssal Horror') FROM cards WHERE convertedmanacost = 10 AND name = 'Abyssal Horror'
SELECT sets.code FROM sets WHERE sets.type = 'expansion' AND sets.block = 'Commander'
SELECT foreign_data.name, cards.type FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.watermark = 'abzan'
SELECT set_translations.language, cards.type  FROM cards  JOIN sets ON cards.setcode = sets.code  JOIN set_translations ON sets.code = set_translations.setcode  WHERE cards.watermark = 'azorius'
SELECT COUNT(*)  FROM cards  WHERE artist = 'Aaron Miller'  AND cardkingdomfoilid = cardkingdomid  AND cardkingdomid IS NOT NULL
SELECT COUNT(*)  FROM cards  WHERE availability LIKE '%paper%'  AND hand LIKE '+%';
SELECT cards.name FROM cards WHERE cards.istextless = 0
SELECT convertedmanacost FROM cards WHERE name = 'Ancestor`s Chosen'
SELECT COUNT(*)  FROM cards  WHERE bordercolor = 'white'  AND (power = '*' OR power IS NULL)
SELECT cards.name FROM cards WHERE cards.ispromo = 1 AND cards.side IS NOT NULL
SELECT types FROM cards WHERE name = 'Molimo, Maro-Sorcerer'
SELECT purchaseurls FROM cards WHERE promotypes = 'bundle'
SELECT COUNT(DISTINCT artist)  FROM cards  WHERE bordercolor = 'black'  AND availability LIKE '%arena,mtgo%'
SELECT CASE      WHEN (SELECT convertedmanacost FROM cards WHERE name = 'Serra Angel') > (SELECT convertedmanacost FROM cards WHERE name = 'Shrine Keeper') THEN 'Serra Angel'     ELSE 'Shrine Keeper' END;
SELECT cards.artist FROM cards WHERE cards.flavorname = 'Battra, Dark Destroyer'
SELECT cards.name FROM cards WHERE cards.frameversion = '2003' ORDER BY cards.convertedmanacost DESC LIMIT 3;
SELECT set_translations.translation FROM set_translations JOIN sets ON set_translations.setcode = sets.code JOIN cards ON set_translations.setcode = cards.setcode WHERE cards.name = "Ancestor's Chosen" AND set_translations.language = 'Italian'
SELECT COUNT(*)  FROM set_translations  WHERE setcode IN (     SELECT code      FROM sets      WHERE id IN (         SELECT id          FROM cards          WHERE name = 'Angel of Mercy'     ) )
SELECT cards.name FROM cards JOIN set_translations ON cards.setcode = set_translations.setcode WHERE set_translations.translation = 'Hauptset Zehnte Edition'
SELECT COUNT(*) FROM cards WHERE name = "Ancestor's Chosen" AND EXISTS (     SELECT *     FROM foreign_data     WHERE foreign_data.uuid = cards.uuid     AND language = 'Korean' )
SELECT COUNT(*)  FROM cards  JOIN set_translations ON cards.setcode = set_translations.setcode  WHERE set_translations.translation = 'Hauptset Zehnte Edition'  AND cards.artist = 'Adam Rex'
SELECT COUNT(*)  FROM cards  JOIN set_translations ON cards.setcode = set_translations.setcode  JOIN sets ON sets.code = cards.setcode  WHERE set_translations.translation = 'Hauptset Zehnte Edition'
SELECT set_translations.translation FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.name = 'Eighth Edition' AND set_translations.language = 'Chinese Simplified';
SELECT cards.name FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.name = 'Angel of Mercy' AND sets.mtgocode IS NOT NULL
SELECT sets.releasedate FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.name = "Ancestor's Chosen"
SELECT sets.type FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Hauptset Zehnte Edition'
SELECT COUNT(*)  FROM sets  JOIN set_translations ON sets.code = set_translations.setcode  WHERE sets.block = 'Ice Age'  AND set_translations.language = 'Italian'
SELECT cards.name FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.name = 'Adarkar Valkyrie' AND sets.isforeignonly = 1;
SELECT COUNT(DISTINCT sets.id) FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language = 'Italian' AND sets.basesetsize < 10;
SELECT COUNT(*)  FROM cards  JOIN sets ON cards.setcode = sets.code  WHERE sets.name = 'Coldsnap'  AND cards.bordercolor = 'black'
SELECT cards.name FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.name = 'Coldsnap' ORDER BY cards.convertedmanacost DESC;
SELECT artist FROM cards WHERE name = 'Coldsnap' AND artist IN ('Jeremy Jarvis', 'Aaron Miller', 'Chippy');
SELECT * FROM cards WHERE number = 4 AND setcode = 'Coldsnap'
SELECT COUNT(*)  FROM cards  JOIN sets ON cards.setcode = sets.code  WHERE sets.name = 'Coldsnap'  AND (cards.power = '*' OR cards.power IS NULL)  AND cards.convertedmanacost > 5
SELECT foreign_data.flavortext FROM foreign_data JOIN cards ON foreign_data.uuid = cards.uuid WHERE cards.name = 'Ancestor''s Chosen' AND foreign_data.language = 'Italian'
SELECT foreign_data.language FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.name = 'Ancestor''s Chosen' AND foreign_data.flavortext IS NOT NULL
SELECT foreign_data.type FROM foreign_data JOIN cards ON foreign_data.uuid = cards.uuid WHERE foreign_data.language = 'German' AND cards.name = 'Ancestor''s Chosen'
SELECT foreign_data.text FROM cards JOIN sets ON cards.setcode = sets.code JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE sets.name = 'Coldsnap' AND foreign_data.language = 'Italian'
SELECT foreign_data.name FROM cards JOIN sets ON cards.setcode = sets.code JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE sets.name = 'Coldsnap' AND foreign_data.language = 'Italian' ORDER BY cards.convertedmanacost DESC;
SELECT rulings.date FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.name = 'Reminisce'
SELECT (CAST(COUNT(*) FILTER (WHERE convertedmanacost = 7 AND sets.name = 'Coldsnap') AS FLOAT) / CAST(COUNT(*) FILTER (WHERE sets.name = 'Coldsnap') AS FLOAT)) * 100 AS percentage FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.name = 'Coldsnap'
SELECT (SUM(cards.cardkingdomfoilid = cards.cardkingdomid AND cards.cardkingdomid IS NOT NULL) / SUM(sets.name = 'Coldsnap')) * 100 FROM cards JOIN sets ON sets.code = cards.setcode WHERE sets.name = 'Coldsnap'
SELECT sets.code FROM sets WHERE sets.releasedate = '2017-07-14'
SELECT sets.keyrunecode FROM sets WHERE sets.code = 'PKHC'
SELECT sets.mcmid FROM sets WHERE sets.code = 'SS2'
SELECT sets.mcmname FROM sets WHERE sets.releasedate = '2017/6/9'
SELECT sets.type FROM sets WHERE sets.name = 'From the Vault: Lore'
SELECT sets.parentcode FROM sets WHERE sets.name = 'Commander 2014 Oversized';
SELECT rulings.text FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.artist = 'Jim Pavelec'
SELECT sets.releasedate FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.name = 'Evacuation'
SELECT sets.basesetsize FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Rinascita di Alara'
SELECT sets.type FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Huitième édition'
SELECT set_translations.translation FROM cards JOIN set_translations ON cards.setcode = set_translations.setcode WHERE cards.name = 'Tendo Ice Bridge' AND set_translations.language = 'French'
SELECT COUNT(*) FROM set_translations WHERE setcode = (SELECT code FROM sets WHERE name = 'Salvat 2011') AND translation IS NOT NULL;
SELECT set_translations.translation FROM set_translations JOIN sets ON set_translations.setcode = sets.code JOIN cards ON set_translations.setcode = cards.setcode WHERE cards.name = 'Fellwar Stone' AND set_translations.language = 'Japanese'
SELECT cards.name FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.name = "Journey into Nyx Hero's Path" ORDER BY cards.convertedmanacost DESC LIMIT 1;
SELECT sets.releasedate FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Ola de frío'
SELECT sets.type FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.name = 'Samite Pilgrim'
SELECT COUNT(*)  FROM cards  JOIN sets ON cards.setcode = sets.code  WHERE sets.name = 'World Championship Decks 2004'  AND cards.convertedmanacost = 3;
SELECT set_translations.translation FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.name = 'Mirrodin' AND set_translations.language = 'Chinese Simplified'
SELECT (((SELECT COUNT(*) FROM sets WHERE sets.code IN (SELECT setcode FROM set_translations WHERE language = 'Japanese')) / (SELECT COUNT(*) FROM sets WHERE sets.code IN (SELECT setcode FROM set_translations WHERE language = 'Japanese'))) * 100)
SELECT (SUM(isOnlineOnly = 1) * 100) / SUM(foreign_data.language = 'Portuguese (Brazil)') FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Portuguese (Brazil)';
SELECT DISTINCT cards.availability FROM cards WHERE cards.artist = 'Aleksi Briclot' AND cards.istextless = 1;
SELECT sets.id FROM sets WHERE sets.basesetsize = (     SELECT MAX(sets.basesetsize)     FROM sets )
SELECT cards.artist FROM cards WHERE cards.side IS NULL ORDER BY cards.convertedmanacost DESC LIMIT 1;
SELECT MAX(frameeffects)  FROM cards  WHERE hasfoil = 1  AND cardkingdomfoilid IS NOT NULL  AND cardkingdomid IS NOT NULL
SELECT COUNT(*)  FROM cards  WHERE power IS NULL OR power = '*'  AND hasFoil = 0  AND duelDeck = 'a'
SELECT sets.id FROM sets WHERE sets.type = 'expansion' AND sets.totalsetsize = (     SELECT MAX(totalsetsize)     FROM sets     WHERE sets.type = 'expansion'     AND sets.code NOT LIKE '%AL%'     AND sets.code NOT LIKE '%C21%'     AND sets.code NOT LIKE '%C20%'     AND sets.code NOT LIKE '%C19%'     AND sets.code NOT LIKE '%C18%'     AND sets.code NOT LIKE '%C17%'     AND sets.code NOT LIKE '%C16%'     AND sets.code NOT LIKE '%C15%'     AND sets.code NOT LIKE '%C14%'     AND sets.code NOT LIKE '%C13%'     AND sets.code NOT LIKE '%C12%'     AND sets.code NOT LIKE '%C11%'     AND sets.code NOT LIKE '%C10%'     AND sets.code NOT LIKE '%C09%'     AND sets.code NOT LIKE '%C08%'     AND sets.code NOT LIKE '%C07%'     AND sets.code NOT LIKE '%C06%'     AND sets.code NOT LIKE '%C05%'     AND sets.code NOT LIKE '%C04%'     AND sets.code NOT LIKE '%C03%'     AND sets.code NOT LIKE '%C02%'     AND sets.code NOT LIKE '%C01%'     AND sets.code NOT LIKE '%C00%'     AND sets.code NOT LIKE '%C99%'     AND sets.code NOT LIKE '%C98%'     AND sets.code NOT LIKE '%C97%'     AND sets.code NOT LIKE '%C96%'     AND sets.code NOT LIKE '%C95%'     AND sets.code NOT LIKE '%C94%'     AND sets.code NOT LIKE '%C93%'     AND sets.code NOT LIKE '%C92%'     AND sets.code NOT LIKE '%C91%'     AND sets.code NOT LIKE '%C90%'     AND sets.code NOT LIKE '%C89%'     AND sets.code NOT LIKE '%C88%'     AND sets.code NOT LIKE '%C87%'     AND sets.code NOT LIKE '%C86%'     AND sets.code NOT LIKE '%C85%'     AND sets.code NOT LIKE '%C84%'     AND sets.code NOT LIKE '%C83%'     AND sets.code NOT LIKE '%C82%'     AND sets.code NOT LIKE '%C81%'     AND sets.code NOT LIKE '%C80%'     AND sets.code NOT LIKE '%C79%'     AND sets.code NOT LIKE '%C78%'     AND sets.code NOT LIKE '%C77%'     AND sets.code NOT LIKE '%C76%'     AND sets.code NOT LIKE '%C75%'     AND sets.code NOT LIKE '%C74%'     AND sets.code NOT LIKE '%C73%'     AND sets.code NOT LIKE '%C72%'     AND sets.code NOT LIKE '%C71%'     AND sets.code NOT LIKE '%C70%'     AND sets.code NOT LIKE '%C69%'     AND sets.code NOT LIKE '%C68%'     AND sets.code NOT LIKE '%C67%'     AND sets.code NOT LIKE '%C66%'     AND sets.code NOT LIKE '%C65%'     AND sets.code NOT LIKE '%C64%'     AND sets.code NOT LIKE '%C63%'     AND sets.code NOT LIKE '%C62%'     AND sets.code NOT LIKE '%C61%'     AND sets.code NOT LIKE '%C60%'     AND sets.code NOT LIKE '%C59%'     AND sets.code NOT LIKE '%C58%'     AND sets.code NOT LIKE '%C57%'     AND sets.code NOT LIKE '%C56%'     AND sets.code NOT LIKE '%C55%'     AND sets.code NOT LIKE '%C54%'     AND sets.code NOT LIKE '%C53%'     AND sets.code NOT LIKE '%C52%'     AND sets.code NOT LIKE '%C51%'     AND sets.code NOT LIKE '%C50%'     AND sets.code NOT LIKE '%C49%'     AND sets.code NOT LIKE '%C48%'     AND sets.code NOT LIKE '%C47%'     AND sets.code NOT LIKE '%C46%'     AND sets.code NOT LIKE '%C45%'     AND sets.code NOT LIKE '%C44%'     AND sets.code NOT LIKE '%C43%'     AND sets.code NOT LIKE '%C42%'     AND sets.code NOT LIKE '%C41%'     AND sets.code NOT LIKE '%C40%'     AND sets.code NOT LIKE '%C39%'     AND sets.code NOT LIKE '%C38%'     AND sets.code NOT LIKE '%C37%'     AND sets.code NOT LIKE '%C36%'     AND sets.code NOT LIKE '%C35%'     AND sets.code NOT LIKE '%C34%'     AND sets.code NOT LIKE '%C33%'     AND sets.code NOT LIKE '%C32%'     AND sets.code NOT LIKE '%C31%'     AND sets.code NOT LIKE '%C30%'     AND sets.code NOT LIKE '%C29%'     AND sets.code NOT LIKE '%C28%'     AND sets.code NOT LIKE '%C27%'     AND sets.code NOT LIKE '%C26%'     AND sets.code NOT LIKE '%C25%'     AND sets.code NOT LIKE '%C24%'     AND sets.code NOT LIKE '%C23%'     AND sets.code NOT LIKE '%C22%'     AND sets.code NOT LIKE '%C21%'     AND sets.code NOT LIKE '%C20%'     AND sets.code NOT LIKE '%C19%'     AND sets.code NOT LIKE '%C18%'     AND sets.code NOT LIKE '%C17%'     AND sets.code NOT LIKE '%C16%'     AND sets.code NOT LIKE '%C15%'     AND sets.code NOT LIKE '%C14%'     AND sets.code NOT LIKE '%C13%'     AND sets.code NOT LIKE '%C12%'     AND sets.code NOT LIKE '%C11%'     AND sets.code NOT LIKE '%C10%'     AND sets.code NOT LIKE '%C09%'     AND sets.code NOT LIKE '%C08%'     AND sets.code NOT LIKE '%C07%'     AND sets.code NOT LIKE '%C06%'     AND sets.code NOT LIKE '%C05%'     AND sets.code NOT LIKE '%C04%'     AND sets.code NOT LIKE '%C03%'     AND sets.code NOT LIKE '%C02%'     AND sets.code NOT LIKE '%C01%'     AND sets.code NOT LIKE '%C00%'     AND sets.code NOT LIKE '%C99%'     AND sets.code NOT LIKE '%C98%'     AND sets.code NOT LIKE '%C97%'     AND sets.code NOT LIKE '%C96%'     AND sets.code NOT LIKE '%C95%'     AND sets.code NOT LIKE '%C94%'     AND sets.code NOT LIKE '%C93%'     AND sets.code NOT LIKE '%C92%'     AND
SELECT cards.name FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE legalities.format = 'duel' ORDER BY cards.convertedmanacost DESC LIMIT 10;
SELECT MIN(cards.originalreleasedate) AS oldest_release_date, legalities.format FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.rarity = 'mythic' AND legalities.status = 'Legal'
SELECT COUNT(*)  FROM cards  JOIN foreign_data ON cards.uuid = foreign_data.uuid  WHERE artist = 'Volkan Baga' AND language = 'French'
SELECT COUNT(*)  FROM cards  JOIN legalities ON cards.uuid = legalities.uuid  WHERE rarity = 'rare'  AND types = 'Enchantment'  AND name = 'Abundance'  AND status = 'Legal'
SELECT legalities.format, cards.name FROM legalities JOIN cards ON legalities.uuid = cards.uuid WHERE legalities.status = 'Banned' GROUP BY legalities.format HAVING COUNT(legalities.status) = (     SELECT MAX(banned_count)     FROM (         SELECT COUNT(*) as banned_count         FROM legalities         WHERE status = 'Banned'         GROUP BY format     ) )
SELECT sets.name, set_translations.language FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.name = 'Battlebond'
SELECT cards.artist, legalities.format FROM cards JOIN legalities ON cards.uuid = legalities.uuid GROUP BY cards.artist HAVING COUNT(cards.id) = (     SELECT MIN(card_count)     FROM (         SELECT COUNT(cards.id) as card_count         FROM cards         GROUP BY cards.artist     ) AS counts )
SELECT legalities.status FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.frameversion = '1997' AND cards.artist = 'D. Alexander Gregory' AND cards.hascontentwarning = 1 AND legalities.format = 'legacy'
SELECT cards.name, legalities.format FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.edhrecrank = 1 AND legalities.status = 'Banned'
SELECT AVG(sets.id), COUNT(foreign_data.language)  FROM sets  JOIN cards ON sets.code = cards.setcode  JOIN foreign_data ON cards.uuid = foreign_data.uuid  WHERE sets.releasedate BETWEEN '2012-01-01' AND '2015-12-31'  GROUP BY sets.id
SELECT cards.artist FROM cards WHERE cards.bordercolor = 'black' AND cards.availability = 'arena'
SELECT cards.uuid FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE legalities.format = 'oldschool' AND (legalities.status = 'banned' OR legalities.status = 'restricted')
SELECT COUNT(*)  FROM cards  WHERE artist = 'Matthew D. Wilson' AND availability = 'paper'
SELECT rulings.text FROM rulings JOIN cards ON rulings.uuid = cards.uuid WHERE cards.artist = 'Kev Walker' ORDER BY rulings.date DESC;
SELECT cards.name, legalities.format FROM cards JOIN sets ON cards.setcode = sets.code JOIN legalities ON cards.uuid = legalities.uuid WHERE sets.name = 'Hour of Devastation'
SELECT sets.name FROM sets LEFT JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language != 'Japanese' AND set_translations.language = 'Korean'
SELECT cards.frameversion, cards.name, legalities.status FROM cards LEFT JOIN legalities ON legalities.uuid = cards.uuid WHERE cards.artist = 'Allen Williams' AND legalities.status = 'Banned'
SELECT CASE      WHEN MAX(reputation) = (SELECT reputation FROM users WHERE displayname = 'Harlan') THEN 'Harlan'     WHEN MAX(reputation) = (SELECT reputation FROM users WHERE displayname = 'Jarrod Dixon') THEN 'Jarrod Dixon' END AS higher_reputation_user FROM users WHERE displayname IN ('Harlan', 'Jarrod Dixon')
SELECT users.displayname FROM users WHERE strftime('%Y', creationdate) = '2014'
SELECT COUNT(*) FROM users WHERE LastAccessDate > '2014-09-01 00:00:00'
SELECT users.displayname FROM users WHERE users.views = (SELECT MAX(views) FROM users)
SELECT COUNT(*)  FROM users  WHERE upvotes > 100 AND downvotes > 1
SELECT COUNT(DISTINCT users.id) FROM users JOIN posts ON users.id = posts.owneruserid WHERE posts.viewcount > 10 AND strftime('%Y', users.creationdate) > '2013'
SELECT COUNT(*)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = 'csgillespie'
SELECT posts.title FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie'
SELECT users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = "Eliciting priors from experts"
SELECT posts.title FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie' ORDER BY posts.viewcount DESC LIMIT 1;
SELECT users.displayname FROM users JOIN posts ON users.id = posts.owneruserid WHERE posts.favoritecount = (SELECT MAX(favoritecount) FROM posts)
SELECT SUM(posts.commentcount) FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie'
SELECT MAX(posts.answercount) FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie'
SELECT users.displayname FROM posts JOIN users ON posts.lasteditoruserid = users.id WHERE posts.title = "Examples for teaching: Correlation does not mean causation"
SELECT COUNT(*)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = 'csgillespie'  AND posts.parentid IS NULL
SELECT users.displayname FROM users JOIN posts ON posts.owneruserid = users.id WHERE posts.closeddate IS NOT NULL
SELECT COUNT(*)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.age > 65 AND posts.score >= 20
SELECT users.location FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = 'Eliciting priors from experts'
SELECT posts.body FROM posts JOIN tags ON tags.excerptpostid = posts.id WHERE tags.tagname = "bayesian"
SELECT posts.body FROM posts JOIN tags ON tags.excerptpostid = posts.id WHERE tags.count = (     SELECT MAX(count)     FROM tags )
SELECT COUNT(*)  FROM badges  JOIN users ON badges.userid = users.id  WHERE users.displayname = "csgillespie"
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = 'csgillespie'
SELECT COUNT(*)  FROM badges  JOIN users ON badges.userid = users.id  WHERE users.displayname = 'csgillespie'  AND strftime('%Y', badges.date) = '2011'
SELECT users.displayname FROM users JOIN badges ON users.id = badges.userid GROUP BY users.id ORDER BY COUNT(badges.id) DESC LIMIT 1;
SELECT AVG(posts.score)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = 'csgillespie'
SELECT AVG(badges.id)  FROM badges  JOIN users ON badges.userid = users.id  WHERE users.views > 200
SELECT (COUNT(posts.id) FILTER (WHERE posts.score > 20 AND users.age > 65) / COUNT(posts.id)) * 100 FROM posts JOIN users ON posts.owneruserid = users.id
SELECT COUNT(*)  FROM votes  WHERE userid = 58 AND creationdate LIKE '2010-07-19%'
SELECT CreationDate  FROM votes  GROUP BY CreationDate  HAVING Count(Id) = (SELECT Max(cnt) FROM (SELECT Count(Id) as cnt FROM votes GROUP BY CreationDate))
SELECT COUNT(*) FROM badges WHERE name = 'Revival'
SELECT posts.title FROM posts JOIN comments ON comments.postid = posts.id WHERE comments.score = (SELECT MAX(score) FROM comments)
SELECT COUNT(*) FROM comments WHERE postid = 1910
SELECT posts.favoritecount FROM comments JOIN posts ON comments.postid = posts.id WHERE comments.userid = 3025 AND comments.creationdate = '2014-04-23 20:29:39.0'
SELECT comments.text FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.parentid = 107829 LIMIT 1;
SELECT CASE      WHEN posts.closeddate IS NULL THEN 'well-finished'     ELSE 'not well-finished' END AS post_status FROM comments JOIN posts ON comments.postid = posts.id WHERE comments.userid = 23853 AND comments.creationdate = '2013-07-12 09:08:18.0'
SELECT users.reputation FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.id = '65041'
SELECT COUNT(*)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = "Tiago Pasqualini"
SELECT users.displayname FROM users JOIN votes ON users.id = votes.userid WHERE votes.id = 6347;
SELECT COUNT(*)  FROM votes  JOIN posts ON votes.postid = posts.id  WHERE posts.title LIKE '%data visualization%'
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = "DatEpicCoderGuyWhoPrograms"
SELECT COUNT(posts.id) / COUNT(votes.id) FROM posts JOIN users ON posts.owneruserid = users.id JOIN votes ON votes.userid = users.id WHERE users.id = 24
SELECT posts.viewcount FROM posts WHERE posts.title = 'Integration of Weka and/or RapidMiner into Informatica PowerCenter/Developer'
SELECT comments.text FROM comments WHERE comments.score = 17;
SELECT users.displayname FROM users WHERE users.websiteurl = 'http://stackoverflow.com'
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = 'SilentGhost'
SELECT users.displayname FROM comments JOIN users ON comments.userid = users.id WHERE comments.text = 'thank you user93!'
SELECT comments.text FROM comments JOIN users ON comments.userid = users.id WHERE users.displayname = 'A Lion'
SELECT users.displayname, users.reputation FROM users JOIN posts ON posts.owneruserid = users.id WHERE posts.title = 'Understanding what Dassault iSight is doing?'
SELECT comments.text FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.title = 'How does gentle boosting differ from AdaBoost?'
SELECT users.displayname FROM users JOIN badges ON users.id = badges.userid WHERE badges.name = 'Necromancer' LIMIT 10;
SELECT users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = 'Open source tools for visualizing multi-dimensional data?'
SELECT posts.title FROM posts JOIN users ON posts.lasteditoruserid = users.id WHERE users.displayname = "Vebjorn Ljosa"
SELECT SUM(posts.score), users.websiteurl FROM posts JOIN users ON posts.lasteditoruserid = users.id WHERE users.displayname = 'Yevgeny'
SELECT comments.text FROM comments JOIN posts ON comments.postid = posts.id JOIN posthistory ON posthistory.postid = posts.id JOIN users ON posthistory.userid = users.id WHERE posts.title = 'Why square the difference instead of taking the absolute value in standard deviation?'
SELECT SUM(votes.bountyamount) FROM posts JOIN votes ON posts.id = votes.postid WHERE posts.title LIKE '%data%'
SELECT users.displayname FROM users JOIN votes ON users.id = votes.userid JOIN posts ON votes.postid = posts.id WHERE posts.title LIKE '%variance%' AND votes.bountyamount = 50
SELECT AVG(posts.viewcount) AS average_view_count, posts.title, comments.text, comments.score FROM posts JOIN postlinks ON posts.id = postlinks.postid JOIN tags ON postlinks.relatedpostid = tags.id JOIN comments ON posts.id = comments.postid WHERE tags.tagname = 'humor' GROUP BY posts.title, comments.text, comments.score
SELECT COUNT(*) FROM comments WHERE userid = 13;
SELECT users.id FROM users ORDER BY reputation DESC LIMIT 1;
SELECT users.id FROM users ORDER BY views ASC LIMIT 1;
SELECT COUNT(DISTINCT badges.userid) FROM badges WHERE badges.name = 'Supporter' AND strftime('%Y', badges.date) = '2011'
SELECT COUNT(userid) FROM badges GROUP BY userid HAVING COUNT(name) > 5;
SELECT COUNT(DISTINCT users.id) FROM users JOIN badges ON badges.userid = users.id WHERE users.location = 'New York' AND badges.name IN ('Teacher', 'Supporter')
SELECT users.id, users.reputation FROM users JOIN posts ON users.id = posts.owneruserid WHERE posts.id = 1;
SELECT users.id FROM users JOIN posts ON users.id = posts.owneruserid JOIN posthistory ON posts.id = posthistory.postid GROUP BY users.id, posts.id HAVING COUNT(posthistory.id) = 1 AND posts.viewcount >= 1000;
SELECT users.displayname, badges.name FROM users JOIN comments ON users.id = comments.userid JOIN badges ON users.id = badges.userid GROUP BY users.id ORDER BY COUNT(comments.id) DESC LIMIT 1
SELECT COUNT(DISTINCT users.id) FROM users JOIN badges ON users.id = badges.userid WHERE users.location = 'India' AND badges.name = 'Teacher'
SELECT ((COUNT(Name) FILTER (WHERE strftime('%Y', date) = '2010') * 100 / COUNT(Name)) - (COUNT(Name) FILTER (WHERE strftime('%Y', date) = '2011') * 100 / COUNT(Name))) AS percentage_difference FROM badges WHERE Name = 'Student'
SELECT posthistorytypeid, COUNT(DISTINCT comments.userid) FROM posthistory JOIN comments ON posthistory.postid = comments.postid WHERE posthistory.postid = 3720 GROUP BY posthistorytypeid
SELECT posts.id, posts.title, posts.viewcount FROM posts WHERE posts.id = 61217;
SELECT posts.score, postlinks.linktypeid  FROM posts  JOIN postlinks ON posts.id = postlinks.postid  WHERE posts.id = 395;
SELECT posts.id, posts.owneruserid FROM posts WHERE posts.score > 60
SELECT SUM(posts.favoritecount)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.id = 686  AND posts.creaiondate LIKE '2011-%'
SELECT AVG(users.upvotes) AS average_upvotes, AVG(users.age) AS average_age FROM users JOIN posts ON users.id = posts.owneruserid GROUP BY users.id HAVING COUNT(posts.id) > 10
SELECT COUNT(DISTINCT badges.userid) FROM badges WHERE badges.name = "Announcer"
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE badges.date = '2010-07-19 19:39:08'
SELECT COUNT(*)  FROM comments  WHERE score > 60
SELECT comments.text FROM comments WHERE comments.creationdate = '2010-07-19 19:25:47.0'
SELECT COUNT(*) FROM posts WHERE score = 10
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.reputation = (SELECT MAX(reputation) FROM users)
SELECT users.reputation FROM users JOIN badges ON users.id = badges.userid WHERE badges.date = '2010-07-19 19:39:08.0'
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = "Pierre"
SELECT badges.date FROM badges JOIN users ON badges.userid = users.id WHERE users.location = 'Rochester, NY'
SELECT (COUNT(DISTINCT badges.userid) * 100) / COUNT(DISTINCT users.id) FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = 'Teacher'
SELECT (COUNT(DISTINCT users.id) * 100) / COUNT(DISTINCT badges.userid) FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = 'Organizer' AND users.age BETWEEN 13 AND 18
SELECT comments.score  FROM comments  JOIN posts ON comments.postid = posts.id  WHERE posts.creaiondate = '2010-07-19 19:19:56.0'
SELECT comments.text  FROM comments  JOIN posts ON comments.postid = posts.id  WHERE posts.creaiondate = '2010-07-19 19:37:33.0'
SELECT users.age FROM users WHERE users.location = 'Vienna, Austria' AND users.id IN (SELECT badges.userid FROM badges)
SELECT COUNT(DISTINCT users.id) FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = 'Supporter' AND users.age BETWEEN 19 AND 65
SELECT SUM(posts.viewcount) FROM posts JOIN badges ON posts.owneruserid = badges.userid WHERE badges.date = '2010-07-19 19:39:08.0'
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.reputation = (SELECT MIN(reputation) FROM users)
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = "Sharpie"
SELECT COUNT(DISTINCT users.id) FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = "Supporter" AND users.age > 65
SELECT users.displayname FROM users WHERE users.id = 30;
SELECT COUNT(DISTINCT users.id) FROM users WHERE users.location = 'New York'
SELECT COUNT(*) FROM votes WHERE strftime('%Y', creationdate) = '2010';
SELECT COUNT(*) FROM users WHERE age BETWEEN 19 AND 65;
SELECT users.displayname FROM users WHERE users.views = (SELECT MAX(views) FROM users)
SELECT COUNT(CASE WHEN strftime('%Y', creationdate) = '2010' THEN id END) / COUNT(CASE WHEN strftime('%Y', creationdate) = '2011' THEN id END) FROM votes;
SELECT tags.tagname FROM tags JOIN posts ON tags.excerptpostid = posts.id JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'John Stauffer'
SELECT COUNT(*)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = 'Daniel Vassallo';
SELECT COUNT(*)  FROM votes  JOIN users ON votes.userid = users.id  WHERE users.displayname = 'Harlan'
SELECT posts.id FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'slashnick' ORDER BY posts.answercount DESC LIMIT 1;
SELECT MAX(posts.viewcount)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = 'Harvey Motulsky' OR users.displayname = 'Noah Snyder'
SELECT COUNT(*)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = 'Matt Parker' AND posts.id > 4 AND posts.score > 4;
SELECT COUNT(*)  FROM comments  JOIN users ON comments.userid = users.id  JOIN posts ON comments.postid = posts.id  WHERE users.displayname = 'Neil McGuigan'  AND comments.score < 60
SELECT tags.tagname FROM users JOIN posts ON users.id = posts.owneruserid JOIN tags ON tags.excerptpostid = posts.id WHERE users.displayname = 'Mark Meckes' AND posts.id NOT IN (SELECT postid FROM comments)
SELECT users.displayname FROM users JOIN badges ON users.id = badges.userid WHERE badges.name = 'Organizer'
SELECT (COUNT(posts.id) / COUNT(posts.id)) as percentage  FROM posts  JOIN tags ON tags.excerptpostid = posts.id  JOIN users ON posts.owneruserid = users.id  WHERE tags.tagname = 'r' AND users.displayname = 'Community'
SELECT SUM(posts.viewcount) FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'mornington' - (SELECT SUM(posts.viewcount) FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'Amos');
SELECT COUNT(DISTINCT badges.userid) FROM badges WHERE badges.name = 'Commentator' AND strftime('%Y', badges.date) = '2014'
SELECT COUNT(*) FROM posts WHERE creaiondate BETWEEN '2010-07-21 00:00:00' AND '2010-07-21 23:59:59';
SELECT users.displayname, users.age FROM users JOIN posts ON users.id = posts.owneruserid WHERE posts.viewcount = (SELECT MAX(viewcount) FROM posts)
SELECT posts.lasteditdate, posts.lasteditoruserid FROM posts WHERE posts.title = 'Detecting a given face in a database of facial images'
SELECT COUNT(*)  FROM comments  WHERE userid = 13 AND score < 60;
SELECT posts.title, comments.userdisplayname FROM posts JOIN comments ON comments.postid = posts.id WHERE comments.score > 60
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.location = 'North Pole' AND strftime('%Y', badges.date) = '2011'
SELECT users.displayname, users.websiteurl FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.favoritecount > 150
SELECT COUNT(*) AS post_history_counts, MAX(lasteditdate) AS last_edit_date FROM posts WHERE title = "What is the best introductory Bayesian statistics textbook?"
SELECT users.lastaccessdate, users.location FROM users JOIN badges ON badges.userid = users.id WHERE badges.name = 'outliers'
SELECT posts.title FROM posts JOIN postlinks ON postlinks.relatedpostid = posts.id JOIN posts AS p ON p.id = postlinks.postid WHERE p.title = "How to tell if something happened in a data set which monitors a value over time"
SELECT posts.id, badges.name  FROM posts  JOIN users ON posts.owneruserid = users.id  JOIN badges ON badges.userid = users.id  WHERE users.displayname = 'Samuel'  AND strftime('%Y', posts.creaiondate) = '2013'  AND strftime('%Y', badges.date) = '2013'
SELECT users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.viewcount = (SELECT MAX(viewcount) FROM posts)
SELECT users.displayname, users.location FROM users JOIN posts ON users.id = posts.owneruserid JOIN tags ON tags.excerptpostid = posts.id WHERE tags.tagname = 'hypothesis-testing'
SELECT posts.title, postlinks.linktypeid FROM posts JOIN postlinks ON posts.id = postlinks.relatedpostid WHERE posts.title = 'What are principal component scores?';
SELECT posts.ownerdisplayname FROM posts WHERE posts.id = ( SELECT parentid FROM posts WHERE id = ( SELECT postid FROM comments WHERE score = ( SELECT MAX(score) FROM comments ) ) )
SELECT users.displayname, users.websiteurl FROM users JOIN votes ON users.id = votes.userid WHERE votes.votetypeid = 8 AND votes.bountyamount = (SELECT MAX(bountyamount) FROM votes WHERE votetypeid = 8)
SELECT posts.title FROM posts ORDER BY viewcount DESC LIMIT 5;
SELECT COUNT(*) FROM tags WHERE count BETWEEN 5000 AND 7000;
SELECT posts.owneruserid FROM posts WHERE favoritecount = (SELECT MAX(favoritecount) FROM posts)
SELECT MAX(age) FROM users WHERE reputation = (SELECT MAX(reputation) FROM users)
SELECT COUNT(*)  FROM posts  JOIN votes ON posts.id = votes.postid  WHERE strftime('%Y', posts.creaiondate) = '2011'  AND votes.bountyamount = 50
SELECT MIN(id) FROM users WHERE age = (SELECT MIN(age) FROM users)
SELECT posts.score FROM posts JOIN tags ON tags.excerptpostid = posts.id WHERE tags.count = (SELECT MAX(count) FROM tags)
SELECT COUNT(postlinks.id)/12  FROM postlinks  JOIN posts ON postlinks.postid = posts.id  WHERE strftime('%Y', posts.creaiondate) = '2010'  AND posts.answercount <= 2;
SELECT posts.id FROM posts JOIN votes ON posts.id = votes.postid WHERE votes.userid = 1465 ORDER BY posts.favoritecount DESC LIMIT 1;
SELECT posts.title FROM postlinks JOIN posts ON postlinks.postid = posts.id ORDER BY postlinks.creationdate ASC LIMIT 1;
SELECT users.displayname FROM users JOIN badges ON users.id = badges.userid GROUP BY users.displayname ORDER BY COUNT(badges.name) DESC LIMIT 1;
SELECT MIN(votes.creationdate) FROM votes JOIN users ON votes.userid = users.id WHERE users.displayname = 'chl'
SELECT MIN(users.creationdate) AS "Date" FROM users WHERE users.age = (SELECT MIN(age) FROM users)
SELECT users.displayname FROM users JOIN badges ON users.id = badges.userid WHERE badges.name = 'Autobiographer' ORDER BY badges.date ASC LIMIT 1;
SELECT COUNT(DISTINCT users.id) FROM users JOIN posts ON users.id = posts.owneruserid WHERE users.location = 'United Kingdom' AND posts.favoritecount >= 4
SELECT AVG(PostId) FROM votes WHERE userid IN (SELECT id FROM users WHERE age = (SELECT MAX(age) FROM users))
SELECT users.displayname FROM users WHERE reputation = (SELECT MAX(reputation) FROM users)
SELECT COUNT(*)  FROM users  WHERE reputation > 2000 AND views > 1000;
SELECT users.displayname FROM users WHERE users.age BETWEEN 19 AND 65;
SELECT COUNT(*)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = 'Jay Stevens'  AND strftime('%Y', posts.creaiondate) = '2010'
SELECT posts.id, posts.title FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'Harvey Motulsky' ORDER BY posts.viewcount DESC LIMIT 1;
SELECT posts.id, posts.title FROM posts ORDER BY posts.score DESC LIMIT 1;
SELECT AVG(posts.score)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = 'Stephen Turner'
SELECT users.displayname  FROM users  JOIN posts ON posts.owneruserid = users.id  WHERE posts.viewcount > 20000 AND strftime('%Y', posts.creaiondate) = '2011'
SELECT posts.id, users.displayname  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE strftime('%Y', posts.creaiondate) = '2010'  ORDER BY posts.favoritecount DESC  LIMIT 1;
SELECT (COUNT(posts.id) * 100) / (SELECT COUNT(id) FROM users WHERE reputation > 1000 AND creationdate LIKE '2011%') FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.reputation > 1000 AND users.creationdate LIKE '2011%'
SELECT (COUNT(id) * 100) / COUNT(id) AS percentage FROM users WHERE age BETWEEN 13 AND 18;
SELECT posts.viewcount, users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = 'Computer Game Datasets'
SELECT COUNT(*) FROM posts WHERE ViewCount > (SELECT AVG(ViewCount) FROM posts)
SELECT COUNT(*)  FROM comments  WHERE postid = (SELECT id FROM posts ORDER BY score DESC LIMIT 1)
SELECT COUNT(*)  FROM posts  WHERE ViewCount > 35000 AND CommentCount = 0
SELECT users.displayname, users.location FROM users JOIN posts ON users.id = posts.lasteditoruserid WHERE posts.id = 183 ORDER BY posts.lasteditdate DESC LIMIT 1;
SELECT b.name FROM badges b JOIN users u ON b.userid = u.id WHERE u.displayname = 'Emmett' ORDER BY b.date DESC LIMIT 1;
SELECT COUNT(*)  FROM users  WHERE age BETWEEN 19 AND 65 AND upvotes > 5000
SELECT strftime('%s', b.date) - strftime('%s', u.creationdate) FROM badges b JOIN users u ON b.userid = u.id WHERE u.displayname = 'Zolomon'
SELECT COUNT(DISTINCT posts.id) AS num_posts, COUNT(DISTINCT comments.id) AS num_comments FROM users JOIN posts ON posts.owneruserid = users.id JOIN comments ON comments.userid = users.id WHERE users.creationdate = (SELECT MAX(creationdate) FROM users)
SELECT comments.text, users.displayname FROM comments JOIN posts ON comments.postid = posts.id JOIN users ON comments.userid = users.id WHERE posts.title = 'Analysing wind data with R' ORDER BY comments.creationdate DESC LIMIT 1;
SELECT COUNT(DISTINCT badges.userid) FROM badges WHERE badges.name = 'Citizen Patrol'
SELECT COUNT(*)  FROM posts  JOIN tags ON tags.excerptpostid = posts.id  WHERE tags.tagname = 'careers'
SELECT users.reputation, users.views FROM users WHERE users.displayname = 'Jarrod Dixon'
SELECT COUNT(comments.id) AS comment_count, COUNT(posts.id) AS answer_count FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.title = 'Clustering 1D data'
SELECT users.creationdate FROM users WHERE users.displayname = 'IrishStat'
SELECT COUNT(*) FROM votes WHERE bountyamount >= 30;
SELECT CAST(COUNT(posts.id) * 100 / (SELECT COUNT(posts.id) FROM posts INNER JOIN users ON posts.owneruserid = users.id WHERE users.reputation = (SELECT MAX(reputation) FROM users)) AS FLOAT) AS percentage FROM posts  INNER JOIN users ON posts.owneruserid = users.id WHERE users.reputation = (SELECT MAX(reputation) FROM users) AND posts.score > 50;
SELECT COUNT(*) FROM posts WHERE score < 20;
SELECT COUNT(*)  FROM tags  WHERE id < 15 AND count <= 20;
SELECT tags.excerptpostid, tags.wikipostid FROM tags WHERE tags.tagname = 'sample'
SELECT users.reputation, users.upvotes FROM users JOIN comments ON comments.userid = users.id WHERE comments.text = 'fine, you win :)';
SELECT comments.text FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.title = 'How can I adapt ANOVA for binary data?';
SELECT comments.text FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.viewcount BETWEEN 100 AND 150 ORDER BY comments.score DESC LIMIT 1;
SELECT comments.creationdate, users.age FROM comments JOIN users ON comments.userid = users.id WHERE comments.text LIKE '%http://%'
SELECT COUNT(DISTINCT comments.postid) FROM comments JOIN posts ON comments.postid = posts.id WHERE comments.score = 0 AND posts.viewcount < 5;
SELECT COUNT(*)  FROM comments  WHERE score = 0  AND postid IN (SELECT id FROM posts WHERE commentcount = 1)
SELECT COUNT(DISTINCT users.id) FROM comments JOIN users ON comments.userid = users.id WHERE comments.score = 0 AND users.age = 40
SELECT posts.id, comments.id FROM posts JOIN comments ON comments.postid = posts.id WHERE posts.title = 'Group differences on a five point Likert item'
SELECT users.upvotes FROM users JOIN comments ON users.id = comments.userid WHERE comments.text = "R is also lazy evaluated."
SELECT comments.text FROM comments JOIN users ON comments.userid = users.id WHERE users.displayname = 'Harvey Motulsky'
SELECT users.displayname FROM comments JOIN users ON comments.userid = users.id WHERE comments.score BETWEEN 1 AND 5 AND users.downvotes = 0
SELECT (COUNT(userid) * 1.0 / COUNT(userid)) as percentage FROM comments WHERE score = 0 AND score BETWEEN 5 AND 10;
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = '3-D Man'
SELECT COUNT(*) FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Super Strength'
SELECT COUNT(DISTINCT superhero.id) FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Super Strength' AND superhero.height_cm > 200;
SELECT superhero.full_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id GROUP BY superhero.id HAVING COUNT(superhero.full_name) > 15
SELECT COUNT(*) FROM superhero WHERE eye_colour_id = (SELECT id FROM colour WHERE colour = 'Blue')
SELECT colour.colour FROM superhero JOIN colour ON superhero.skin_colour_id = colour.id WHERE superhero.superhero_name = 'Apocalypse'
SELECT COUNT(*)  FROM superhero  JOIN colour ON superhero.eye_colour_id = colour.id  JOIN hero_power ON superhero.id = hero_power.hero_id  JOIN superpower ON hero_power.power_id = superpower.id  WHERE colour.colour = 'Blue'  AND superpower.power_name = 'Agility'
SELECT superhero.superhero_name  FROM superhero  JOIN colour AS eye_colour ON superhero.eye_colour_id = eye_colour.id  JOIN colour AS hair_colour ON superhero.hair_colour_id = hair_colour.id  WHERE eye_colour.colour = 'Blue' AND hair_colour.colour = 'Blond'
SELECT COUNT(*) FROM superhero WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'Marvel Comics')
SELECT superhero.full_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Marvel Comics' ORDER BY superhero.height_cm DESC LIMIT 1;
SELECT publisher.publisher_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.superhero_name = 'Sauron'
SELECT COUNT(*)  FROM superhero  JOIN publisher ON superhero.publisher_id = publisher.id  JOIN colour ON superhero.eye_colour_id = colour.id  WHERE publisher.publisher_name = 'Marvel Comics'  AND colour.colour = 'Blue'
SELECT AVG(height_cm)  FROM superhero  JOIN publisher ON superhero.publisher_id = publisher.id  WHERE publisher.publisher_name = 'Marvel Comics'
SELECT (COUNT(DISTINCT superhero.id) * 100) / COUNT(DISTINCT superhero.id) FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE publisher.publisher_name = 'Marvel Comics' AND superpower.power_name = 'Super Strength'
SELECT COUNT(*) FROM superhero WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'DC Comics')
SELECT publisher.publisher_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE attribute.attribute_name = 'Speed' ORDER BY hero_attribute.attribute_value LIMIT 1;
SELECT COUNT(*)  FROM superhero  JOIN colour ON superhero.eye_colour_id = colour.id  JOIN publisher ON superhero.publisher_id = publisher.id  WHERE colour = 'Gold' AND publisher_name = 'Marvel Comics'
SELECT publisher.publisher_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.superhero_name = 'Blue Beetle II'
SELECT COUNT(*) FROM superhero WHERE hair_colour_id = (SELECT id FROM colour WHERE colour = 'Blond')
SELECT superhero.superhero_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Intelligence' ORDER BY hero_attribute.attribute_value LIMIT 1;
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.superhero_name = 'Copycat'
SELECT COUNT(DISTINCT superhero.id) FROM superhero JOIN hero_attribute ON hero_attribute.hero_id = superhero.id JOIN attribute ON attribute.id = hero_attribute.attribute_id WHERE attribute.attribute_name = 'Durability' AND hero_attribute.attribute_value < 50;
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Death Touch'
SELECT COUNT(*)  FROM superhero  JOIN gender ON superhero.gender_id = gender.id  JOIN hero_attribute ON hero_attribute.hero_id = superhero.id  JOIN attribute ON hero_attribute.attribute_id = attribute.id  WHERE gender.gender = 'Female'  AND attribute.attribute_name = 'Strength'  AND hero_attribute.attribute_value = 100
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id GROUP BY superhero.superhero_name ORDER BY COUNT(hero_power.power_id) DESC LIMIT 1;
SELECT COUNT(*) FROM superhero WHERE race_id = (SELECT id FROM race WHERE race = 'Vampire')
SELECT (COUNT(id) * 100) / (SELECT COUNT(id) FROM superhero)  FROM superhero  WHERE alignment_id = (SELECT id FROM alignment WHERE alignment = 'Bad')  AND publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'Marvel Comics')
SELECT (SUM(CASE WHEN publisher_name = 'Marvel Comics' THEN 1 ELSE 0 END) - SUM(CASE WHEN publisher_name = 'DC Comics' THEN 1 ELSE 0 END)) AS difference FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id;
SELECT publisher.id FROM publisher WHERE publisher.publisher_name = 'Star Trek'
SELECT AVG(attribute_value) FROM hero_attribute
SELECT COUNT(*) FROM superhero WHERE full_name IS NULL;
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.id = 75;
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Deathlok'
SELECT AVG(weight_kg)  FROM superhero  WHERE gender_id = 2
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id JOIN gender ON superhero.gender_id = gender.id WHERE gender.gender = 'Male' LIMIT 5;
SELECT superhero_name FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Alien'
SELECT superhero_name FROM superhero WHERE height_cm BETWEEN 170 AND 190 AND eye_colour_id = 1;
SELECT superpower.power_name FROM superpower JOIN hero_power ON superpower.id = hero_power.power_id WHERE hero_power.hero_id = 56;
SELECT superhero.full_name FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Demi-God' LIMIT 5;
SELECT COUNT(*) FROM superhero WHERE alignment_id = 'Bad'
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.weight_kg = 169;
SELECT colour.colour FROM superhero JOIN colour ON superhero.hair_colour_id = colour.id JOIN race ON superhero.race_id = race.id WHERE superhero.height_cm = 185 AND race.race = 'Human'
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.weight_kg = (SELECT MAX(weight_kg) FROM superhero)
SELECT (COUNT(superhero.id) * 100) / (SELECT COUNT(superhero.id) FROM superhero WHERE height_cm BETWEEN 150 AND 180) FROM superhero WHERE height_cm BETWEEN 150 AND 180 AND publisher_id = 13;
SELECT superhero.full_name FROM superhero JOIN gender ON superhero.gender_id = gender.id WHERE gender.gender = 'Male' AND superhero.weight_kg > (SELECT AVG(weight_kg) * 0.79 FROM superhero)
SELECT superpower.power_name FROM superpower JOIN hero_power ON superpower.id = hero_power.power_id GROUP BY superpower.power_name ORDER BY COUNT(*) DESC LIMIT 1;
SELECT hero_attribute.attribute_value FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id WHERE superhero.superhero_name = 'Abomination'
SELECT superpower.power_name FROM superpower JOIN hero_power ON superpower.id = hero_power.power_id WHERE hero_power.hero_id = 1;
SELECT COUNT(DISTINCT hero_id) FROM hero_power JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Stealth';
SELECT superhero.full_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Strength' AND hero_attribute.attribute_value = (     SELECT MAX(attribute_value)     FROM hero_attribute     JOIN attribute ON hero_attribute.attribute_id = attribute.id     WHERE attribute.attribute_name = 'Strength' )
SELECT AVG(superhero.id) FROM superhero WHERE skin_colour_id = 1;
SELECT COUNT(*) FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Dark Horse Comics'
SELECT superhero.superhero_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Durability' AND publisher.publisher_name = 'Dark Horse Comics' GROUP BY superhero.superhero_name HAVING MAX(hero_attribute.attribute_value)
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.full_name = 'Abraham Sapien'
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Flight'
SELECT colour.colour AS eyes, colour.colour AS hair, colour.colour AS skin_colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.gender_id = (SELECT id FROM gender WHERE gender = 'Female') AND publisher.publisher_name = 'Dark Horse Comics'
SELECT superhero.superhero_name, publisher.publisher_name FROM superhero JOIN colour ON superhero.hair_colour_id = colour.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.hair_colour_id = superhero.skin_colour_id AND superhero.hair_colour_id = superhero.eye_colour_id
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.superhero_name = 'A-Bomb'
SELECT ((SUM(colour.colour = 'Blue') / COUNT(gender.gender = 'Female')) * 100)  FROM superhero  JOIN colour ON superhero.skin_colour_id = colour.id JOIN gender ON superhero.gender_id = gender.id WHERE gender.gender = 'Female' AND colour.colour = 'Blue';
SELECT superhero.superhero_name, race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.full_name = 'Charles Chandler'
SELECT gender.gender FROM superhero JOIN gender ON superhero.gender_id = gender.id WHERE superhero.superhero_name = 'Agent 13'
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Adaptation';
SELECT COUNT(*)  FROM hero_power  JOIN superhero ON hero_power.hero_id = superhero.id  WHERE superhero.superhero_name = 'Amazo'
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.full_name = 'Hunter Zolomon'
SELECT superhero.height_cm FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE colour.colour = 'Amber'
SELECT superhero_name FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id AND superhero.hair_colour_id = colour.id WHERE colour.colour = 'Black'
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.skin_colour_id = (SELECT id FROM colour WHERE colour = 'Gold')
SELECT superhero.full_name FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Vampire'
SELECT superhero.superhero_name FROM superhero JOIN alignment ON superhero.alignment_id = alignment.id WHERE alignment.alignment = 'Neutral'
SELECT COUNT(*)  FROM superhero  JOIN hero_attribute ON superhero.id = hero_attribute.hero_id  JOIN attribute ON hero_attribute.attribute_id = attribute.id  WHERE attribute_name = 'Strength'  AND attribute_value = (SELECT MAX(attribute_value) FROM hero_attribute WHERE attribute_id = (SELECT id FROM attribute WHERE attribute_name = 'Strength'))
SELECT race.race, alignment.alignment FROM superhero JOIN race ON superhero.race_id = race.id JOIN alignment ON superhero.alignment_id = alignment.id WHERE superhero.superhero_name = 'Cameron Hicks';
SELECT ROUND((CAST(SUM(CASE WHEN gender.gender = 'Female' THEN 1 ELSE 0 END) AS REAL) / CAST(COUNT(*) AS REAL)) * 100, 2) AS percentage_female_heroes_published_by_marvel FROM superhero JOIN gender ON superhero.gender_id = gender.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Marvel Comics'; 
SELECT AVG(weight_kg)  FROM superhero  WHERE race_id = (SELECT id FROM race WHERE race = 'Alien')
SELECT SUM(s1.weight_kg) - SUM(s2.weight_kg) FROM superhero s1, superhero s2 WHERE s1.full_name = 'Emil Blonsky' AND s2.full_name = 'Charles Chandler'
SELECT AVG(height_cm) FROM superhero;
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Abomination'
SELECT COUNT(*)  FROM superhero  WHERE race_id = 21 AND gender_id = 1
SELECT superhero.superhero_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Speed' ORDER BY hero_attribute.attribute_value DESC LIMIT 1;
SELECT COUNT(*) FROM superhero WHERE alignment_id = 3;
SELECT attribute.attribute_name, hero_attribute.attribute_value FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE superhero.superhero_name = '3-D Man'
SELECT superhero_name FROM superhero WHERE eye_colour_id = 7 AND hair_colour_id = 9;
SELECT publisher.publisher_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.superhero_name IN ('Hawkman', 'Karate Kid', 'Speedy')
SELECT COUNT(*) FROM superhero WHERE publisher_id = 1;
SELECT (SUM(CASE WHEN eye_colour_id = 7 THEN 1 ELSE 0 END) * 100.0 / COUNT(superhero_name)) FROM superhero;
SELECT SUM(gender_id = 1) / SUM(gender_id = 2) AS ratio FROM superhero WHERE gender_id IN (1, 2)
SELECT superhero_name FROM superhero WHERE height_cm = (     SELECT MAX(height_cm)     FROM superhero )
SELECT superpower.id FROM superpower WHERE power_name = 'cryokinesis'
SELECT superhero_name FROM superhero WHERE id = 294;
SELECT superhero.full_name FROM superhero WHERE superhero.weight_kg = 0 OR superhero.weight_kg IS NULL;
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.full_name = 'Karen Beecher-Duncan'
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.full_name = 'Helen Parr'
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.weight_kg = 108 AND superhero.height_cm = 188;
SELECT publisher.publisher_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.id = 38;
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id JOIN hero_attribute ON superhero.id = hero_attribute.hero_id WHERE hero_attribute.attribute_value = (     SELECT MAX(attribute_value)     FROM hero_attribute )
SELECT alignment.alignment, superpower.power_name FROM superhero JOIN alignment ON superhero.alignment_id = alignment.id JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Atom IV';
SELECT superhero.full_name FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE colour.colour = 'Blue' LIMIT 5;
SELECT AVG(attribute_value)  FROM hero_attribute  WHERE hero_id IN (     SELECT id      FROM superhero      WHERE alignment_id = 3 )
SELECT colour.colour FROM superhero JOIN colour ON superhero.skin_colour_id = colour.id JOIN hero_attribute ON hero_attribute.hero_id = superhero.id WHERE hero_attribute.attribute_value = 100
SELECT COUNT(*) FROM superhero WHERE alignment_id = 1 AND gender_id = 2
SELECT superhero.superhero_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id WHERE hero_attribute.attribute_value BETWEEN 75 AND 80;
SELECT race.race FROM superhero JOIN colour ON superhero.hair_colour_id = colour.id JOIN gender ON superhero.gender_id = gender.id JOIN race ON superhero.race_id = race.id WHERE colour.colour = 'Blue' AND gender.gender = 'Male'
SELECT (SUM(CASE WHEN gender_id = 2 THEN 1 ELSE 0 END) * 100.0 / COUNT(CASE WHEN alignment_id = 2 THEN 1 END)) FROM superhero WHERE alignment_id = 2;
SELECT COUNT(*) - (SELECT COUNT(*) FROM superhero WHERE weight_kg = 0 OR weight_kg IS NULL) - (SELECT COUNT(*) FROM superhero WHERE eye_colour_id = (SELECT id FROM colour WHERE colour = 'Blue')) - (SELECT COUNT(*) FROM superhero WHERE eye_colour_id = (SELECT id FROM colour WHERE colour = 'No eye color')) FROM superhero;
SELECT hero_attribute.attribute_value FROM hero_attribute JOIN attribute ON hero_attribute.attribute_id = attribute.id JOIN superhero ON hero_attribute.hero_id = superhero.id WHERE superhero.superhero_name = 'Hulk' AND attribute.attribute_name = 'Strength'
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Ajax'
SELECT COUNT(*)  FROM superhero  JOIN colour ON superhero.skin_colour_id = colour.id  JOIN alignment ON superhero.alignment_id = alignment.id  WHERE colour.colour = 'Green' AND alignment.alignment = 'Bad'
SELECT COUNT(*)  FROM superhero  JOIN gender ON superhero.gender_id = gender.id  JOIN publisher ON superhero.publisher_id = publisher.id  WHERE gender.gender = 'Female' AND publisher.publisher_name = 'Marvel Comics'
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Wind Control' ORDER BY superhero.superhero_name ASC;
SELECT gender.gender FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id JOIN gender ON superhero.gender_id = gender.id WHERE superpower.power_name = 'Phoenix Force'
SELECT superhero_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher_name = 'DC Comics' ORDER BY weight_kg DESC LIMIT 1;
SELECT AVG(height_cm)  FROM superhero  JOIN race ON superhero.race_id = race.id  JOIN publisher ON superhero.publisher_id = publisher.id  WHERE race.race <> 'Human'  AND publisher.publisher_name = 'Dark Horse Comics'
SELECT COUNT(*)  FROM superhero  JOIN hero_attribute ON superhero.id = hero_attribute.hero_id  JOIN attribute ON hero_attribute.attribute_id = attribute.id  WHERE attribute.attribute_name = 'Speed' AND hero_attribute.attribute_value = 100
SELECT (SUM(CASE WHEN publisher_name = 'DC Comics' THEN 1 ELSE 0 END) - SUM(CASE WHEN publisher_name = 'Marvel Comics' THEN 1 ELSE 0 END)) AS difference FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id;
SELECT attribute.attribute_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE superhero.superhero_name = 'Black Panther' ORDER BY hero_attribute.attribute_value LIMIT 1;
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.superhero_name = 'Abomination';
SELECT superhero_name FROM superhero WHERE height_cm = (     SELECT MAX(height_cm)     FROM superhero )
SELECT superhero_name FROM superhero WHERE full_name = 'Charles Chandler'
SELECT (SUM(CASE WHEN gender_id = (SELECT id FROM gender WHERE gender = 'Female') THEN 1 ELSE 0 END) * 100.0 / COUNT(*)) FROM superhero WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'George Lucas')
SELECT (SUM(CASE WHEN alignment.alignment = 'Good' AND publisher.publisher_name = 'Marvel Comics' THEN 1 ELSE 0 END) * 100.0 / COUNT(CASE WHEN publisher.publisher_name = 'Marvel Comics' THEN 1 ELSE NULL END)) AS percentage_of_good_superheroes FROM superhero JOIN alignment ON superhero.alignment_id = alignment.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Marvel Comics'
SELECT COUNT(*) FROM superhero WHERE full_name LIKE 'John%';
SELECT hero_id FROM hero_attribute WHERE attribute_value = (     SELECT MIN(attribute_value)     FROM hero_attribute )
SELECT superhero.full_name FROM superhero WHERE superhero.superhero_name = 'Alien'
SELECT superhero.full_name FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.weight_kg < 100 AND colour.colour = 'Brown'
SELECT hero_attribute.attribute_value FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id WHERE superhero.superhero_name = 'Aquababy'
SELECT superhero.weight_kg, race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.id = 40;
SELECT AVG(height_cm) FROM superhero WHERE alignment_id = (SELECT id FROM alignment WHERE alignment = 'Neutral')
SELECT superhero.id FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Intelligence'
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.superhero_name = 'Blackwulf';
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.height_cm > (SELECT AVG(height_cm) * 0.8 FROM superhero)
SELECT drivers.driverref FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid WHERE qualifying.raceid = 18 AND qualifying.position <= 15 ORDER BY qualifying.q1 DESC LIMIT 5;
SELECT drivers.surname FROM drivers JOIN qualifying ON drivers.driverid = qualifying.driverid WHERE qualifying.raceid = 19 AND qualifying.q2 = (SELECT MIN(q2) FROM qualifying WHERE raceid = 19)
SELECT races.year FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.location = 'Shanghai'
SELECT circuits.url FROM circuits WHERE circuits.name = 'Circuit de Barcelona-Catalunya'
SELECT races.name FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.country = 'Germany'
SELECT circuits.name, constructorstandings.position FROM circuits JOIN races ON circuits.circuitid = races.circuitid JOIN constructorstandings ON races.raceid = constructorstandings.raceid JOIN constructors ON constructorstandings.constructorid = constructors.constructorid WHERE constructors.name = 'Renault'
SELECT COUNT(races.raceid)  FROM races  JOIN circuits ON races.circuitid = circuits.circuitid  JOIN seasons ON races.year = seasons.year  WHERE races.year = 2010  AND circuits.country NOT IN ('Asia', 'Europe')
SELECT races.name FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.country = 'Spain'
SELECT circuits.lat, circuits.lng FROM circuits JOIN races ON races.circuitid = circuits.circuitid WHERE races.name = 'Australian Grand Prix'
SELECT races.url FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Sepang International Circuit'
SELECT races.time FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Sepang International Circuit'
SELECT circuits.lat, circuits.lng FROM circuits JOIN races ON races.circuitid = circuits.circuitid WHERE races.name = 'Abu Dhabi Grand Prix'
SELECT c.nationality FROM constructors AS c JOIN constructorresults AS cr ON c.constructorid = cr.constructorid WHERE cr.raceid = 24 AND cr.points = 1;
SELECT qualifying.q1 FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid WHERE drivers.forename = 'Bruno' AND drivers.surname = 'Senna' AND qualifying.raceid = 354;
SELECT drivers.nationality FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid WHERE qualifying.q2 = '0:01:40' AND qualifying.raceid = 355;
SELECT qualifying.number FROM qualifying WHERE qualifying.raceid = 903 AND qualifying.q3 = '0:01:54'
SELECT COUNT(*)  FROM results  WHERE raceid = (SELECT raceid FROM races WHERE name = 'Bahrain Grand Prix' AND year = 2007)  AND time IS NULL
SELECT seasons.url FROM races JOIN seasons ON races.year = seasons.year WHERE races.raceid = 901;
SELECT COUNT(*)  FROM results  WHERE raceid = (SELECT raceid FROM races WHERE date = '2015-11-29')  AND positiontext != 'R'
SELECT drivers.forename, drivers.surname FROM drivers JOIN results ON drivers.driverid = results.driverid WHERE results.raceid = 592 AND results.time IS NOT NULL ORDER BY drivers.dob ASC LIMIT 1;
SELECT drivers.forename, drivers.surname, drivers.url FROM drivers JOIN laptimes ON drivers.driverid = laptimes.driverid WHERE laptimes.time = '0:01:27' AND laptimes.raceid = 161;
SELECT drivers.nationality FROM drivers JOIN results ON drivers.driverid = results.driverid WHERE results.raceid = 933 AND results.fastestlapspeed = (     SELECT MAX(fastestlapspeed)     FROM results     WHERE raceid = 933 )
SELECT circuits.lat, circuits.lng FROM circuits JOIN races ON races.circuitid = circuits.circuitid WHERE races.name = 'Malaysian Grand Prix'
SELECT constructors.url FROM constructorstandings JOIN constructors ON constructorstandings.constructorid = constructors.constructorid WHERE constructorstandings.raceid = 9 ORDER BY constructorstandings.points DESC LIMIT 1;
SELECT qualifying.q1 FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid JOIN races ON qualifying.raceid = races.raceid WHERE drivers.forename = 'Lucas' AND drivers.surname = 'di Grassi' AND races.raceid = 345;
SELECT drivers.nationality FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid WHERE qualifying.q2 = '0:01:15' AND qualifying.raceid = 347;
SELECT drivers.code FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid WHERE qualifying.raceid = 45 AND qualifying.q3 = '0:01:33'
SELECT results.time FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE races.raceid = 743 AND drivers.forename = 'Bruce' AND drivers.surname = 'McLaren'
SELECT drivers.forename, drivers.surname FROM drivers JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid WHERE races.name = 'San Marino Grand Prix' AND races.year = 2006 AND results.position = 2
SELECT seasons.url FROM races JOIN seasons ON races.year = seasons.year WHERE races.raceid = 901;
SELECT COUNT(*) FROM results JOIN races ON results.raceid = races.raceid WHERE races.date = '2015-11-29' AND results.positiontext != 'R'
SELECT drivers.forename, drivers.surname FROM drivers JOIN results ON drivers.driverid = results.driverid WHERE results.raceid = 872 AND results.time IS NOT NULL ORDER BY drivers.dob DESC LIMIT 1;
SELECT drivers.forename || ' ' || drivers.surname AS driver_name FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid WHERE laptimes.raceid = 348 ORDER BY laptimes.time ASC LIMIT 1;
SELECT drivers.nationality FROM drivers JOIN results ON drivers.driverid = results.driverid WHERE results.raceid = 348 AND results.fastestlapspeed = (     SELECT MAX(fastestlapspeed)     FROM results     WHERE raceid = 348 )
SELECT ( (results.fastestlapspeed / (SELECT results.fastestlapspeed FROM results WHERE raceid = 854)) - 1 ) * 100  FROM results  WHERE raceid = 853  AND driverid = (SELECT driverid FROM drivers WHERE forename = 'Paul' AND surname = 'di Resta')
SELECT COUNT(resultid) * 100 / (SELECT COUNT(driverid) FROM results INNER JOIN races ON results.raceid = races.raceid WHERE races.date = '1983-07-16')  FROM results  INNER JOIN races ON results.raceid = races.raceid  WHERE results.time != '' AND races.date = '1983-07-16'
SELECT MIN(year) FROM races WHERE name = 'Singapore Grand Prix';
SELECT races.name FROM races WHERE races.year = 2005 ORDER BY races.name DESC;
SELECT races.name FROM races WHERE races.date = (     SELECT MIN(date)     FROM races ) UNION SELECT races.name FROM races WHERE strftime('%Y-%m', races.date) = (     SELECT strftime('%Y-%m', MIN(date))     FROM races ) AND races.date != (     SELECT MIN(date)     FROM races )
SELECT races.name, races.date FROM races WHERE races.year = 1999 AND races.round = (SELECT MAX(round) FROM races WHERE year = 1999)
SELECT races.year FROM races GROUP BY races.year HAVING COUNT(races.round) = (     SELECT MAX(round)     FROM races )
SELECT races.name FROM races WHERE races.year = 2017 AND races.name NOT IN (     SELECT races.name     FROM races     WHERE races.year = 2000 )
SELECT circuits.country, circuits.name, circuits.location FROM circuits JOIN races ON circuits.circuitid = races.circuitid WHERE races.name = 'European Grand Prix' ORDER BY races.year ASC LIMIT 1;
SELECT MAX(year) FROM seasons WHERE url LIKE '%Brands_Hatch%'
SELECT COUNT(DISTINCT seasons.year) FROM circuits JOIN races ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE circuits.name = 'Silverstone Circuit' AND races.name = 'British Grand Prix'
SELECT drivers.forename, drivers.surname FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE races.name = 'Singapore Grand Prix' AND races.year = 2010 ORDER BY driverstandings.position
SELECT drivers.forename || ' ' || drivers.surname AS full_name FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid WHERE driverstandings.points = (SELECT MAX(points) FROM driverstandings)
SELECT drivers.forename, drivers.surname, driverstandings.points FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE races.name = 'Chinese Grand Prix' AND races.year = 2017 ORDER BY driverstandings.points DESC LIMIT 3;
SELECT laptimes.time, drivers.forename, drivers.surname, races.name FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid JOIN races ON laptimes.raceid = races.raceid WHERE laptimes.time = (SELECT MIN(time) FROM laptimes)
SELECT AVG(laptimes.time)  FROM laptimes  JOIN drivers ON laptimes.driverid = drivers.driverid  JOIN races ON laptimes.raceid = races.raceid  WHERE drivers.forename = 'Sebastian'  AND drivers.surname = 'Vettel'  AND races.year = 2009  AND races.name = 'Chinese Grand Prix';
SELECT (COUNT(races.raceid) - COUNT(CASE WHEN drivers.surname = 'Hamilton' AND races.year >= 2010 AND results.position = 1 THEN races.raceid ELSE NULL END)) * 100.0 / COUNT(CASE WHEN drivers.surname = 'Hamilton' AND races.year >= 2010 THEN races.raceid ELSE NULL END) FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year JOIN results ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.surname = 'Hamilton' AND races.year >= 2010;
SELECT drivers.forename, drivers.surname, drivers.nationality, AVG(driverstandings.points) as average_point_scores FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid GROUP BY drivers.driverid ORDER BY COUNT(driverstandings.wins) DESC LIMIT 1;
SELECT MIN(2022 - strftime('%Y', dob) + 1) AS age, forename || ' ' || surname AS name FROM drivers WHERE nationality = 'Japanese'
SELECT circuits.name FROM circuits JOIN races ON circuits.circuitid = races.circuitid WHERE races.year BETWEEN 1990 AND 2000 GROUP BY circuits.circuitid HAVING COUNT(races.raceid) = 4;
SELECT circuits.name, circuits.location, races.name FROM circuits JOIN races ON circuits.circuitid = races.circuitid JOIN seasons ON races.year = seasons.year WHERE circuits.country = 'USA' AND seasons.year = 2006
SELECT races.name, circuits.name, circuits.location FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE strftime('%m', races.date) = '09' AND races.year = 2005
SELECT races.name FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Alex' AND drivers.surname = 'Yoong' AND results.position < 10
SELECT COUNT(*)  FROM driverstandings ds  JOIN drivers d ON ds.driverid = d.driverid  JOIN races r ON ds.raceid = r.raceid  JOIN circuits c ON r.circuitid = c.circuitid  WHERE d.forename = 'Michael'  AND d.surname = 'Schumacher'  AND c.name = 'Sepang International Circuit'  AND ds.position = 1
SELECT races.name, races.year FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Michael' AND drivers.surname = 'Schumacher' ORDER BY results.milliseconds ASC LIMIT 1;
SELECT AVG(points)  FROM driverstandings  JOIN drivers ON driverstandings.driverid = drivers.driverid  JOIN races ON driverstandings.raceid = races.raceid  WHERE drivers.forename = 'Eddie' AND drivers.surname = 'Irvine' AND races.year = 2000
SELECT races.name, results.points FROM drivers JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' ORDER BY races.year ASC LIMIT 1;
SELECT races.name, circuits.country FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE seasons.year = 2017 ORDER BY races.date ASC;
SELECT races.name, races.year, circuits.location FROM races JOIN circuits ON races.circuitid = circuits.circuitid ORDER BY races.laps DESC LIMIT 1;
SELECT (COUNT(races.circuitid IN (SELECT circuitid FROM circuits WHERE country = 'Germany') AND races.name = 'European Grand Prix') / COUNT(races.name = 'European Grand Prix')) * 100 FROM races
SELECT circuits.lat, circuits.lng FROM circuits WHERE circuits.name = 'Silverstone Circuit'
SELECT name FROM circuits WHERE lat = (SELECT MAX(lat) FROM circuits)
SELECT circuits.circuitref FROM circuits WHERE circuits.name = 'Marina Bay Street Circuit'
SELECT circuits.country FROM circuits WHERE circuits.alt = (SELECT MAX(alt) FROM circuits)
SELECT COUNT(*) FROM drivers WHERE code IS NULL
SELECT drivers.nationality FROM drivers WHERE drivers.dob = (SELECT MIN(dob) FROM drivers)
SELECT drivers.surname FROM drivers WHERE drivers.nationality = 'Italian'
SELECT drivers.url FROM drivers WHERE drivers.forename = 'Anthony' AND drivers.surname = 'Davidson'
SELECT driverref FROM drivers WHERE forename = 'Lewis' AND surname = 'Hamilton'
SELECT circuits.name FROM circuits JOIN races ON circuits.circuitid = races.circuitid WHERE races.year = 2009 AND races.name = 'Spanish Grand Prix'
SELECT races.year FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Silverstone Circuit'
SELECT races.name, races.date, races.time, races.url FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Silverstone Circuit'
SELECT races.time FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE seasons.year >= 2010 AND seasons.year <= 2019 AND circuits.name = 'Abu Dhabi Circuit'
SELECT COUNT(*)  FROM races  JOIN circuits ON races.circuitid = circuits.circuitid  WHERE circuits.country = 'Italy'
SELECT races.date FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Circuit de Barcelona-Catalunya'
SELECT circuits.url FROM circuits JOIN races ON circuits.circuitid = races.circuitid JOIN seasons ON races.year = seasons.year WHERE races.name = 'Spanish Grand Prix' AND seasons.year = 2009;
SELECT MIN(results.fastestlaptime) FROM results JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'
SELECT drivers.forename, drivers.surname FROM drivers JOIN laptimes ON drivers.driverid = laptimes.driverid JOIN races ON laptimes.raceid = races.raceid JOIN results ON laptimes.raceid = results.raceid AND laptimes.driverid = results.driverid WHERE results.fastestlapspeed = (SELECT MAX(fastestlapspeed) FROM results)
SELECT drivers.driverref FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND driverstandings.position = 1;
SELECT races.name FROM races JOIN drivers ON races.raceid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'
SELECT races.name FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' ORDER BY results.positionorder ASC LIMIT 1;
SELECT MAX(fastestlapspeed) FROM results WHERE raceid = (SELECT raceid FROM races WHERE name = 'Spanish Grand Prix' AND year = 2009)
SELECT races.year FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'
SELECT results.positionorder FROM results JOIN drivers ON results.driverid = drivers.driverid JOIN races ON results.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND races.year = 2008 AND races.name = 'Australian Grand Prix'
SELECT drivers.forename, drivers.surname FROM drivers JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND results.grid = 4
SELECT COUNT(*)  FROM results  WHERE raceid = 1 AND time IS NOT NULL
SELECT laptimes.time FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid JOIN races ON laptimes.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND races.year = 2008 AND races.name = 'Australian Grand Prix' ORDER BY laptimes.milliseconds ASC LIMIT 1;
SELECT results.time FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND results.positionorder = 2;
SELECT drivers.forename, drivers.surname, drivers.url FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND driverstandings.position = 1;
SELECT COUNT(*)  FROM drivers  JOIN driverstandings ON drivers.driverid = driverstandings.driverid  JOIN races ON driverstandings.raceid = races.raceid  WHERE races.year = 2008  AND drivers.nationality = 'American'  AND races.name = 'Australian Grand Prix'
SELECT COUNT(DISTINCT drivers.driverid) FROM drivers JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND results.time IS NOT NULL
SELECT SUM(points) FROM driverstandings WHERE driverid = (SELECT driverid FROM drivers WHERE driverref = 'hamilton')
SELECT AVG(strftime('%s', fastestlaptime)) FROM results JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'
SELECT COUNT(raceid) FROM results WHERE raceid = 1 AND laps = (SELECT COUNT(lap) FROM laptimes WHERE raceid = 1) AND time IS NOT NULL;
SELECT ((results.time - (SELECT MIN(results.time) FROM results WHERE results.raceid = races.raceid AND results.position = 1)) / (results.time + (SELECT MIN(results.time) FROM results WHERE results.raceid = races.raceid AND results.position = (SELECT MAX(results.position) FROM results WHERE results.raceid = races.raceid)))) * 100 FROM results JOIN races ON results.raceid = races.raceid WHERE races.year = 2008 AND races.name = 'Australian Grand Prix' AND results.time IS NOT NULL AND results.position = (SELECT MAX(results.position) FROM results WHERE results.raceid = races.raceid)
SELECT COUNT(*)  FROM circuits  WHERE location = 'Melbourne' AND country = 'Australia'
SELECT circuits.lat, circuits.lng FROM circuits WHERE circuits.country = 'USA'
SELECT COUNT(*)  FROM drivers  WHERE nationality = 'British' AND dob > '1980-01-01'
SELECT AVG(constructorresults.points)  FROM constructorresults  JOIN constructors ON constructorresults.constructorid = constructors.constructorid  WHERE constructors.nationality = 'British'
SELECT constructors.name FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid ORDER BY constructorstandings.points DESC LIMIT 1;
SELECT constructors.name FROM constructors LEFT JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid WHERE constructorstandings.points = 0 AND constructorstandings.raceid = 291
SELECT COUNT(DISTINCT constructors.constructorid)  FROM constructors  LEFT JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid  LEFT JOIN races ON constructorstandings.raceid = races.raceid  WHERE constructors.nationality = 'Japanese'  AND races.year IN (SELECT year FROM races GROUP BY year HAVING COUNT(raceid) = 2)  AND constructorstandings.points = 0;
SELECT constructors.name FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid WHERE constructorstandings.position = 1
SELECT COUNT(DISTINCT constructors.constructorid)  FROM constructors  JOIN constructorresults ON constructors.constructorid = constructorresults.constructorid  JOIN races ON constructorresults.raceid = races.raceid  JOIN circuits ON races.circuitid = circuits.circuitid  JOIN laptimes ON laptimes.raceid = races.raceid  JOIN drivers ON drivers.driverid = laptimes.driverid  WHERE constructors.nationality = 'French' AND laptimes.lap > 50;
SELECT (COUNT(DISTINCT drivers.driverid) * 100) / (SELECT COUNT(DISTINCT drivers.driverid) FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE races.year BETWEEN 2007 AND 2009 AND drivers.nationality = 'Japanese') FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE races.year BETWEEN 2007 AND 2009 AND drivers.nationality = 'Japanese' AND results.time IS NOT NULL;
SELECT races.year, AVG(strftime('%s', results.time)) as average_time FROM races JOIN results ON races.raceid = results.raceid JOIN driverstandings ON races.raceid = driverstandings.raceid AND results.driverid = driverstandings.driverid WHERE driverstandings.position = 1 AND results.time IS NOT NULL GROUP BY races.year;
SELECT drivers.forename, drivers.surname FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid WHERE drivers.dob > '1975-01-01' AND driverstandings.position = 2
SELECT COUNT(*)  FROM drivers  WHERE nationality = 'Italian'  AND driverid NOT IN (     SELECT driverid      FROM results      WHERE time IS NOT NULL )
SELECT drivers.forename, drivers.surname FROM drivers JOIN laptimes ON drivers.driverid = laptimes.driverid WHERE laptimes.time = (SELECT MIN(time) FROM laptimes)
SELECT MAX(laptimes.lap) FROM laptimes JOIN driverstandings ON laptimes.driverid = driverstandings.driverid JOIN races ON laptimes.raceid = races.raceid JOIN seasons ON races.year = seasons.year WHERE driverstandings.position = 1 AND seasons.year = 2009
SELECT AVG(results.fastestlapspeed)  FROM results  JOIN races ON results.raceid = races.raceid  WHERE races.name = 'Spanish Grand Prix' AND races.year = 2009
SELECT races.name, races.year FROM races WHERE races.time IS NOT NULL ORDER BY races.time ASC LIMIT 1;
SELECT (COUNT(DISTINCT drivers.driverid) * 100) / (SELECT COUNT(DISTINCT drivers.driverid) FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE strftime('%Y', drivers.dob) < '1985' AND races.year BETWEEN '2000' AND '2005') FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE strftime('%Y', drivers.dob) < '1985' AND races.year BETWEEN '2000' AND '2005' AND driverstandings.positiontext > '50' AND driverstandings.positiontext != 'R'
SELECT COUNT(*)  FROM drivers  JOIN laptimes ON drivers.driverid = laptimes.driverid  WHERE drivers.nationality = 'French' AND laptimes.time < '02:00.00';
SELECT drivers.driverid, drivers.driverref, drivers.number, drivers.code, drivers.forename, drivers.surname, drivers.dob, drivers.nationality, drivers.url FROM drivers WHERE drivers.nationality = 'American'
SELECT races.raceid FROM races WHERE races.year = 2009
SELECT COUNT(DISTINCT driverid) FROM results WHERE raceid = 18;
SELECT drivers.code FROM drivers ORDER BY strftime('%Y', drivers.dob) DESC LIMIT 3;
SELECT drivers.driverref FROM drivers WHERE drivers.forename = 'Robert' AND drivers.surname = 'Kubica'
SELECT COUNT(*)  FROM drivers  WHERE nationality = 'Australian' AND dob LIKE '1980-%'
SELECT drivers.forename, drivers.surname  FROM drivers  JOIN laptimes ON drivers.driverid = laptimes.driverid WHERE drivers.nationality = 'German'  AND drivers.dob BETWEEN '1980-01-01' AND '1990-12-31'  ORDER BY laptimes.time ASC  LIMIT 3;
SELECT drivers.driverref  FROM drivers  WHERE drivers.nationality = 'German'  AND drivers.dob = (SELECT MIN(strftime('%Y', drivers.dob)) FROM drivers WHERE drivers.nationality = 'German')
SELECT drivers.driverid, drivers.code FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid JOIN results ON driverstandings.raceid = results.raceid AND driverstandings.driverid = results.driverid WHERE drivers.dob = '1971' AND results.fastestlaptime IS NOT NULL
SELECT drivers.forename, drivers.surname FROM drivers WHERE drivers.nationality = 'Spanish' AND drivers.dob < '1982' ORDER BY (SELECT MAX(laptimes.time) FROM laptimes WHERE laptimes.driverid = drivers.driverid) LIMIT 10;
SELECT races.year FROM races INNER JOIN results ON races.raceid = results.raceid WHERE results.fastestlaptime IS NOT NULL ORDER BY results.fastestlaptime ASC LIMIT 1;
SELECT races.year FROM laptimes JOIN races ON laptimes.raceid = races.raceid WHERE laptimes.time = (     SELECT MAX(time)     FROM laptimes )
SELECT driverid FROM laptimes WHERE lap = 1 ORDER BY time ASC LIMIT 5
SELECT COUNT(*)  FROM results  WHERE raceid > 50 AND raceid < 100 AND positiontext = 'D' AND statusid = 2;
SELECT circuits.location, circuits.lat, circuits.lng FROM circuits WHERE circuits.country = 'Austria'
SELECT races.round FROM races JOIN results ON races.raceid = results.raceid WHERE results.time IS NOT NULL GROUP BY races.round ORDER BY COUNT(*) DESC LIMIT 1;
SELECT drivers.driverref, drivers.nationality, drivers.dob FROM drivers JOIN qualifying ON drivers.driverid = qualifying.driverid WHERE qualifying.raceid = 23 AND qualifying.q2 IS NOT NULL
SELECT races.year, races.name, races.date, races.time FROM races JOIN qualifying ON races.raceid = qualifying.raceid JOIN drivers ON qualifying.driverid = drivers.driverid WHERE drivers.dob = (SELECT MIN(dob) FROM drivers)
SELECT COUNT(*)  FROM drivers  JOIN results ON drivers.driverid = results.driverid  JOIN status ON results.statusid = status.statusid  WHERE drivers.nationality = 'American' AND status.status = 'Disqualified'
SELECT constructors.name, constructors.url FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid WHERE constructors.nationality = 'Italian' ORDER BY constructorstandings.points DESC LIMIT 1;
SELECT constructors.url FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid GROUP BY constructors.constructorid ORDER BY COUNT(constructorstandings.wins) DESC LIMIT 1;
SELECT drivers.forename, drivers.surname FROM drivers JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid JOIN laptimes ON races.raceid = laptimes.raceid AND results.driverid = laptimes.driverid WHERE races.name = 'French Grand Prix' AND laptimes.lap = 3 ORDER BY laptimes.time DESC LIMIT 1;
SELECT races.name, laptimes.time, laptimes.milliseconds FROM races JOIN laptimes ON races.raceid = laptimes.raceid WHERE laptimes.lap = 1 ORDER BY laptimes.milliseconds ASC LIMIT 1;
SELECT AVG(results.fastestlaptime) FROM results JOIN races ON results.raceid = races.raceid WHERE races.name = 'United States Grand Prix' AND races.year = 2006 AND results.rank < 11;
SELECT drivers.forename, drivers.surname FROM drivers JOIN pitstops ON drivers.driverid = pitstops.driverid WHERE drivers.nationality = 'German' AND drivers.dob BETWEEN '1980-01-01' AND '1985-12-31' GROUP BY drivers.driverid ORDER BY AVG(pitstops.duration) ASC LIMIT 5;
SELECT drivers.forename, drivers.surname, results.time  FROM drivers  JOIN driverstandings ON drivers.driverid = driverstandings.driverid  JOIN results ON driverstandings.raceid = results.raceid  JOIN races ON results.raceid = races.raceid  WHERE results.position = 1 AND races.year = 2008 AND races.name = 'Canadian Grand Prix'
SELECT constructors.constructorref, constructors.url FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid JOIN races ON constructorstandings.raceid = races.raceid WHERE races.name = 'Singapore Grand Prix' AND races.year = 2009 AND constructorstandings.position = 1;
SELECT drivers.forename || ' ' || drivers.surname, drivers.dob FROM drivers WHERE drivers.nationality = 'Austrian' AND strftime('%Y', drivers.dob) BETWEEN '1981' AND '1991'
SELECT drivers.forename || ' ' || drivers.surname AS full_name, drivers.url, drivers.dob FROM drivers WHERE drivers.nationality = 'German' AND strftime('%Y', drivers.dob) BETWEEN '1971' AND '1985' ORDER BY drivers.dob DESC;
SELECT circuits.location, circuits.country, circuits.lat, circuits.lng FROM circuits WHERE circuits.name = 'Hungaroring'
SELECT constructorstandings.points, constructors.name, constructors.nationality FROM constructorstandings JOIN constructors ON constructorstandings.constructorid = constructors.constructorid JOIN races ON constructorstandings.raceid = races.raceid WHERE races.name = 'Monaco Grand Prix' AND races.year BETWEEN 1980 AND 2010 ORDER BY constructorstandings.points DESC LIMIT 1;
SELECT AVG(points) FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND races.name = 'Turkish Grand Prix'
SELECT AVG(race_count) FROM (SELECT COUNT(raceid) as race_count FROM races WHERE date BETWEEN '2000-01-01' AND '2010-12-31' GROUP BY year);
SELECT nationality FROM drivers GROUP BY nationality ORDER BY COUNT(*) DESC LIMIT 1;
SELECT COUNT(driverstandings.wins) FROM driverstandings WHERE driverstandings.position = 91
SELECT races.name FROM races INNER JOIN results ON races.raceid = results.raceid WHERE results.fastestlapspeed = (     SELECT MIN(fastestlapspeed)     FROM results )
SELECT circuits.location || ', ' || circuits.country AS full_location FROM circuits JOIN races ON races.circuitid = circuits.circuitid WHERE races.date = (SELECT MAX(date) FROM races)
SELECT drivers.forename || ' ' || drivers.surname AS full_name FROM drivers JOIN qualifying ON drivers.driverid = qualifying.driverid JOIN races ON qualifying.raceid = races.raceid JOIN circuits ON races.circuitid = circuits.circuitid WHERE races.year = 2008 AND races.round = 3 AND circuits.name = 'Marina Bay Street Circuit' AND qualifying.position = 1;
SELECT drivers.forename || ' ' || drivers.surname AS full_name, drivers.nationality, races.name FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE drivers.dob = (SELECT MAX(dob) FROM drivers)
SELECT COUNT(*)  FROM results  JOIN races ON results.raceid = races.raceid  JOIN drivers ON results.driverid = drivers.driverid  WHERE races.name = 'Canadian Grand Prix'  AND results.statusid = 3  AND results.driverid = (     SELECT driverid      FROM (         SELECT driverid, COUNT(*) as num_accidents          FROM results          WHERE statusid = 3          GROUP BY driverid          ORDER BY num_accidents DESC          LIMIT 1     ) )
SELECT drivers.forename || ' ' || drivers.surname AS full_name, COUNT(driverstandings.wins) AS wins FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid WHERE drivers.dob = (SELECT MIN(dob) FROM drivers)
SELECT MAX(duration) FROM pitstops
SELECT MIN(time) FROM laptimes
SELECT MAX(duration) FROM pitstops WHERE driverid = (SELECT driverid FROM drivers WHERE forename = 'Lewis' AND surname = 'Hamilton')
SELECT pitstops.lap FROM pitstops JOIN drivers ON pitstops.driverid = drivers.driverid JOIN races ON pitstops.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND races.year = 2011 AND races.name = 'Australian Grand Prix'
SELECT pitstops.time FROM pitstops JOIN races ON pitstops.raceid = races.raceid JOIN drivers ON pitstops.driverid = drivers.driverid WHERE races.year = 2011 AND races.name = 'Australian Grand Prix'
SELECT laptimes.time FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' ORDER BY laptimes.time ASC LIMIT 1;
SELECT drivers.forename || ' ' || drivers.surname AS driver_name FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid WHERE time = (SELECT MIN(time) FROM laptimes)
SELECT circuits.name, results.position FROM circuits JOIN races ON races.circuitid = circuits.circuitid JOIN results ON results.raceid = races.raceid JOIN drivers ON drivers.driverid = results.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND results.fastestlap = 1
SELECT laptimes.time FROM laptimes JOIN races ON laptimes.raceid = races.raceid JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Austrian Grand Prix Circuit' ORDER BY laptimes.time ASC LIMIT 1;
SELECT circuits.name, laptimes.time FROM circuits JOIN races ON circuits.circuitid = races.circuitid JOIN laptimes ON races.raceid = laptimes.raceid WHERE circuits.country = 'Italy'
SELECT races.name FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN laptimes ON races.raceid = laptimes.raceid WHERE circuits.name = 'Austrian Grand Prix Circuit' ORDER BY laptimes.time ASC LIMIT 1;
SELECT pitstops.duration FROM pitstops JOIN races ON pitstops.raceid = races.raceid JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Austrian Grand Prix' AND pitstops.driverid = (SELECT driverid FROM laptimes WHERE raceid = races.raceid ORDER BY milliseconds ASC LIMIT 1)
SELECT circuits.lat, circuits.lng FROM circuits WHERE circuits.circuitid IN (     SELECT races.circuitid     FROM races     INNER JOIN results ON races.raceid = results.raceid     WHERE results.fastestlaptime = '1:29.488' )
SELECT AVG(pitstops.duration)  FROM pitstops  JOIN drivers ON pitstops.driverid = drivers.driverid  WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'
SELECT AVG(laptimes.milliseconds) FROM laptimes JOIN races ON laptimes.raceid = races.raceid JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.country = 'Italy'
SELECT player_api_id FROM player_attributes WHERE overall_rating = (     SELECT MAX(overall_rating)     FROM player_attributes )
SELECT MAX(height) FROM player;
SELECT player_attributes.preferred_foot  FROM player_attributes  JOIN player ON player_attributes.player_api_id = player.player_api_id  WHERE player_attributes.potential = (SELECT MIN(potential) FROM player_attributes)
SELECT COUNT(*)  FROM player_attributes  WHERE overall_rating >= 60 AND overall_rating < 65  AND defensive_work_rate = 'low'
SELECT player_api_id FROM player_attributes ORDER BY crossing DESC LIMIT 5;
SELECT league.name FROM league JOIN match ON league.id = match.league_id WHERE match.season = '2015/2016' GROUP BY league.name ORDER BY SUM(match.home_team_goal + match.away_team_goal) DESC LIMIT 1;
SELECT team.team_long_name FROM match JOIN team ON match.home_team_api_id = team.team_api_id WHERE season = '2015/2016' AND (home_team_goal - away_team_goal) < 0 GROUP BY match.home_team_api_id ORDER BY COUNT(*) ASC LIMIT 1;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id ORDER BY player_attributes.penalties DESC LIMIT 10;
SELECT team.team_long_name FROM match JOIN league ON match.league_id = league.id JOIN team ON match.away_team_api_id = team.team_api_id WHERE league.name = 'Scotland Premier League' AND match.season = '2009/2010' AND (match.away_team_goal - match.home_team_goal) > 0 GROUP BY match.away_team_api_id ORDER BY COUNT(*) DESC LIMIT 1;
SELECT team.team_long_name, team_attributes.buildupplayspeed FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildupplayspeed = (SELECT MAX(buildupplayspeed) FROM team_attributes) ORDER BY team_attributes.buildupplayspeed DESC LIMIT 4;
SELECT league.name  FROM match  JOIN league ON match.league_id = league.id  WHERE match.season = '2015/2016'  GROUP BY match.league_id  HAVING SUM(match.home_team_goal = match.away_team_goal) = (SELECT MAX(draws) FROM (SELECT COUNT(*) AS draws FROM match WHERE season = '2015/2016' AND home_team_goal = away_team_goal GROUP BY league_id))
SELECT player.player_name, (strftime('%Y', 'now') - strftime('%Y', player.birthday)) - (strftime('%m-%d', 'now') < strftime('%m-%d', player.birthday)) AS age FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.sprint_speed >= 97 AND player_attributes.date >= '2013-01-01 00:00:00' AND player_attributes.date <= '2015-12-31 00:00:00'
SELECT league.name, COUNT(match.id) as total_matches FROM league JOIN match ON league.id = match.league_id GROUP BY league.name ORDER BY total_matches DESC LIMIT 1;
SELECT AVG(height)  FROM player  WHERE birthday >= '1990-01-01 00:00:00' AND birthday < '1996-01-01 00:00:00';
SELECT player_api_id FROM player_attributes WHERE substr(date,1,4) = '2010' AND overall_rating > (SELECT AVG(overall_rating) FROM player_attributes WHERE substr(date,1,4) = '2010')
SELECT team_fifa_api_id FROM team_attributes WHERE buildupplayspeed BETWEEN 51 AND 59
SELECT team.team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildUpPlayPassing > (SELECT AVG(buildUpPlayPassing) FROM team_attributes WHERE buildUpPlayPassing IS NOT NULL) AND strftime('%Y', team_attributes.date) = '2012'
SELECT (SUM(CASE WHEN player_attributes.preferred_foot = 'left' THEN 1 ELSE 0 END) * 100) / COUNT(player_attributes.player_fifa_api_id) FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id AND player_attributes.player_fifa_api_id = player.player_fifa_api_id WHERE player.birthday BETWEEN '1987-01-01 00:00:00' AND '1992-12-31 00:00:00'
SELECT league.name FROM league JOIN match ON match.league_id = league.id GROUP BY league.name ORDER BY SUM(match.home_team_goal + match.away_team_goal) ASC LIMIT 5;
SELECT AVG(long_shots)  FROM player_attributes  WHERE player_fifa_api_id = (SELECT player_fifa_api_id FROM player WHERE player_name = 'Ahmed Samir Farag');
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.height > 180 GROUP BY player.player_fifa_api_id ORDER BY AVG(player_attributes.heading_accuracy) DESC LIMIT 10;
SELECT team.team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildupplaydribblingclass = 'Normal' AND team_attributes.date >= '2014-01-01 00:00:00' AND team_attributes.date <= '2014-01-31 00:00:00' AND team_attributes.chancecreationpassing < (SELECT AVG(chancecreationpassing) FROM team_attributes) ORDER BY team_attributes.chancecreationpassing DESC;
SELECT league.name FROM league JOIN match ON league.id = match.league_id WHERE match.season = '2009/2010' GROUP BY league.name HAVING AVG(match.home_team_goal) > AVG(match.away_team_goal)
SELECT team_short_name FROM team WHERE team_long_name = 'Queens Park Rangers';
SELECT player.player_name FROM player WHERE substr(player.birthday, 1, 4) = '1970' AND substr(player.birthday, 6, 2) = '10';
SELECT player_attributes.attacking_work_rate FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Franco Zennaro'
SELECT team_attributes.buildupplaypositioningclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'ADO Den Haag'
SELECT player_attributes.heading_accuracy FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Francois Affolter' AND player_attributes.date = '2014-09-18 00:00:00'
SELECT player_attributes.overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Gabriel Tamas' AND strftime('%Y', player_attributes.date) = '2011'
SELECT COUNT(*)  FROM match  JOIN league ON match.league_id = league.id  WHERE league.name = 'Scotland Premier League' AND match.season = '2015/2016';
SELECT player.preferred_foot FROM player ORDER BY player.birthday DESC LIMIT 1;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.potential = (SELECT MAX(potential) FROM player_attributes)
SELECT COUNT(*)  FROM player  WHERE weight < 130 AND preferred_foot = 'left'
SELECT team.team_short_name FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_attributes.chancecreationpassingclass = 'Risky'
SELECT player_attributes.defensive_work_rate  FROM player_attributes  JOIN player ON player_attributes.player_api_id = player.player_api_id  WHERE player.player_name = 'David Wilson'
SELECT player.birthday FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.overall_rating = (SELECT MAX(overall_rating) FROM player_attributes)
SELECT league.name FROM league JOIN country ON league.country_id = country.id WHERE country.name = 'Netherlands'
SELECT AVG(home_team_goal)  FROM match  JOIN league ON match.league_id = league.id  JOIN country ON league.country_id = country.id  WHERE country.name = 'Poland' AND match.season = '2010/2011';
SELECT player.player_name  FROM player  JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id  WHERE player.height = (SELECT MAX(height) FROM player)  GROUP BY player.player_name  HAVING AVG(player_attributes.finishing) = (SELECT MAX(avg_finishing) FROM (SELECT AVG(finishing) as avg_finishing FROM player_attributes GROUP BY player_api_id) as subquery)   UNION   SELECT player.player_name  FROM player  JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id  WHERE player.height = (SELECT MIN(height) FROM player)  GROUP BY player.player_name  HAVING AVG(player_attributes.finishing) = (SELECT MAX(avg_finishing) FROM (SELECT AVG(finishing) as avg_finishing FROM player_attributes GROUP BY player_api_id) as subquery)
SELECT player.player_name FROM player WHERE player.height > 180;
SELECT COUNT(*) FROM player WHERE strftime('%Y', birthday) > '1990';
SELECT COUNT(*)  FROM player  WHERE player_name LIKE 'Adam%'  AND weight > 170;
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.overall_rating > 80 AND strftime('%Y', player_attributes.date) BETWEEN '2008' AND '2010'
SELECT player_attributes.potential FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.player_name = 'Aaron Doran'
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.preferred_foot = 'left';
SELECT team.team_long_name FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_attributes.buildupplayspeedclass = 'Fast'
SELECT team_attributes.buildupplaypassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_short_name = 'CLB'
SELECT team.team_short_name FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE buildupplaypassing > 70
SELECT AVG(overall_rating)  FROM player_attributes  JOIN player ON player_attributes.player_api_id = player.player_api_id  WHERE strftime('%Y', player_attributes.date) BETWEEN '2010' AND '2015'  AND player.height > 170;
SELECT player_name FROM player ORDER BY height ASC LIMIT 1;
SELECT country.name FROM league JOIN country ON league.country_id = country.id WHERE league.name = 'Italy Serie A';
SELECT team.team_short_name  FROM team_attributes  JOIN team ON team_attributes.team_api_id = team.team_api_id  WHERE buildupplayspeed = 31  AND buildupplaydribbling = 53  AND buildupplaypassing = 32
SELECT AVG(overall_rating)  FROM player_attributes  WHERE player_api_id = (SELECT player_api_id FROM player WHERE player_name = 'Aaron Doran');
SELECT COUNT(*)  FROM match  JOIN league ON match.league_id = league.id  WHERE league.name = 'Germany 1. Bundesliga'  AND strftime('%Y-%m', match.date) BETWEEN '2008-08' AND '2008-10'
SELECT team_short_name FROM team JOIN match ON match.home_team_api_id = team.team_api_id WHERE match.home_team_goal = 10
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.balance = (SELECT MAX(balance) FROM player_attributes WHERE potential = 61) AND player_attributes.potential = 61;
SELECT (SELECT AVG(ball_control) FROM player_attributes WHERE player_api_id = (SELECT player_api_id FROM player WHERE player_name = 'Abdou Diallo')) - (SELECT AVG(ball_control) FROM player_attributes WHERE player_api_id = (SELECT player_api_id FROM player WHERE player_name = 'Aaron Appindangoye'));
SELECT team_long_name FROM team WHERE team_short_name = 'GEN'
SELECT player_name FROM player WHERE player_name = 'Aaron Lennon' OR player_name = 'Abdelaziz Barrada' ORDER BY birthday ASC LIMIT 1;
SELECT player_name FROM player ORDER BY height DESC LIMIT 1;
SELECT COUNT(*)  FROM player_attributes  WHERE preferred_foot = 'left'  AND attacking_work_rate = 'low'
SELECT country.name FROM league JOIN country ON league.country_id = country.id WHERE league.name = 'Belgium Jupiler League';
SELECT league.name FROM league JOIN country ON league.country_id = country.id WHERE country.name = 'Germany';
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.overall_rating = (     SELECT MAX(overall_rating)     FROM player_attributes )
SELECT COUNT(*)  FROM player  JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id  WHERE strftime('%Y', player.birthday)<'1986'  AND player_attributes.defensive_work_rate = 'high'
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.player_name IN ('Alexis', 'Ariel Borysiuk', 'Arouna Kone') ORDER BY player_attributes.crossing DESC LIMIT 1;
SELECT player_attributes.heading_accuracy FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Ariel Borysiuk';
SELECT COUNT(*)  FROM player  JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id  WHERE player.height > 180 AND player_attributes.volleys > 70
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.volleys > 70 AND player_attributes.dribbling > 70
SELECT COUNT(*)  FROM match  JOIN league ON match.league_id = league.id  JOIN country ON league.country_id = country.id  WHERE match.season = '2008/2009' AND country.name = 'Belgium';
SELECT player_attributes.long_passing FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id ORDER BY player.birthday ASC LIMIT 1;
SELECT COUNT(*)  FROM match  JOIN league ON match.league_id = league.id  WHERE league.name = 'Belgium Jupiler League'  AND strftime('%Y', match.date) = '2009'  AND strftime('%m', match.date) = '04';
SELECT league_id FROM match WHERE season = '2008/2009' GROUP BY league_id ORDER BY COUNT(*) DESC LIMIT 1;
SELECT AVG(overall_rating)  FROM player_attributes  JOIN player ON player_attributes.player_api_id = player.player_api_id  WHERE strftime('%Y', player.birthday) < '1986'
SELECT ((pa1.overall_rating - pa2.overall_rating) / pa2.overall_rating) * 100 FROM player_attributes AS pa1 JOIN player_attributes AS pa2 ON pa1.player_api_id = pa2.player_api_id JOIN player AS p1 ON pa1.player_api_id = p1.player_api_id JOIN player AS p2 ON pa2.player_api_id = p2.player_api_id WHERE p1.player_name = 'Ariel Borysiuk' AND p2.player_name = 'Paulin Puel';
SELECT AVG(buildupplayspeed)  FROM team_attributes  WHERE team_api_id = (SELECT team_api_id FROM team WHERE team_long_name = 'Heart of Midlothian')
SELECT AVG(T1.overall_rating) FROM player_attributes AS T1 JOIN player AS T2 ON T1.player_api_id = T2.player_api_id WHERE T2.player_name = 'Pietro Marino'
SELECT SUM(crossing) FROM player_attributes AS T1 JOIN player AS T2 ON T1.player_api_id = T2.player_api_id WHERE T2.player_name = 'Aaron Lennox'
SELECT MAX(chancecreationpassing) AS highest_chance_creation_passing_score, chancecreationpassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_long_name = 'Ajax'
SELECT preferred_foot FROM player WHERE player_name = 'Abdou Diallo'
SELECT MAX(overall_rating)  FROM player_attributes  JOIN player ON player_attributes.player_api_id = player.player_api_id  WHERE player.player_name = 'Dorlan Pabon'
SELECT AVG(away_team_goal) FROM match JOIN team ON match.away_team_api_id = team.team_api_id WHERE team.team_long_name = 'Parma' AND match.country_id IN (SELECT id FROM country WHERE name = 'Italy')
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.overall_rating = 77 AND player_attributes.date = '2016-06-23' ORDER BY player.birthday ASC LIMIT 1;
SELECT player_attributes.overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Aaron Mooy' AND player_attributes.date = '2016-02-04 00:00:00'
SELECT player_attributes.potential FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Francesco Parravicini' AND player_attributes.date = '2010-08-30 00:00:00'
SELECT player_attributes.attacking_work_rate FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Francesco Migliore' AND player_attributes.date = '2015-05-01 00:00:00'
SELECT player_attributes.defensive_work_rate FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Kevin Berigaud' AND player_attributes.date = '2013-02-22 00:00:00'
SELECT MIN(date) FROM player_attributes WHERE player_api_id = (SELECT player_api_id FROM player WHERE player_name = 'Kevin Constant') AND crossing = (SELECT MAX(crossing) FROM player_attributes WHERE player_api_id = (SELECT player_api_id FROM player WHERE player_name = 'Kevin Constant'))
SELECT team_attributes.buildupplayspeedclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Willem II' AND team_attributes.date = '2012-02-22 00:00:00'
SELECT team_attributes.buildupplaydribblingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_short_name = 'LEI' AND team_attributes.date = '2015-09-10 00:00:00'
SELECT team_attributes.buildupplaypassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'FC Lorient' AND team_attributes.date = '2010-02-22'
SELECT team_attributes.chancecreationpassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'PEC Zwolle' AND team_attributes.date = '2013-09-20 00:00:00'
SELECT team_attributes.chancecreationcrossingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Hull City' AND team_attributes.date = '2010-02-22 00:00:00'
SELECT team_attributes.defenceaggressionclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Hannover 96' AND team_attributes.date = '2015-09-10 00:00:00'
SELECT AVG(overall_rating)  FROM player_attributes  JOIN player ON player_attributes.player_api_id = player.player_api_id  WHERE player.player_name = 'Marko Arnautovic'  AND player_attributes.date BETWEEN '2007-02-22 00:00:00' AND '2016-04-21 00:00:00'
SELECT ((p1.overall_rating - p2.overall_rating) / p1.overall_rating) * 100 FROM player_attributes p1 JOIN player_attributes p2 ON p1.player_api_id = p2.player_api_id JOIN player pl1 ON p1.player_api_id = pl1.player_api_id JOIN player pl2 ON p2.player_api_id = pl2.player_api_id WHERE pl1.player_name = 'Landon Donovan' AND pl2.player_name = 'Jordan Bowery' AND p1.date = '2013-07-12' AND p2.date = '2013-07-12'
SELECT player.player_name FROM player ORDER BY player.height DESC LIMIT 5;
SELECT player_api_id FROM player ORDER BY weight DESC LIMIT 10;
SELECT player.player_name FROM player WHERE strftime('%Y', datetime(CURRENT_TIMESTAMP,'localtime')) - strftime('%Y', player.birthday) > 34
SELECT COUNT(match.home_team_goal) FROM match JOIN player ON match.home_player_1 = player.player_api_id WHERE player.player_name = 'Aaron Lennon'
SELECT SUM(match.away_team_goal) FROM match JOIN player_attributes ON match.away_player_1 = player_attributes.player_api_id OR match.away_player_1 = player_attributes.player_api_id JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Daan Smith' OR player.player_name = 'Filipe Ferreira'
SELECT SUM(home_team_goal) FROM match JOIN player ON match.home_player_1 = player.player_api_id OR match.home_player_2 = player.player_api_id OR match.home_player_3 = player.player_api_id OR match.home_player_4 = player.player_api_id OR match.home_player_5 = player.player_api_id OR match.home_player_6 = player.player_api_id OR match.home_player_7 = player.player_api_id OR match.home_player_8 = player.player_api_id OR match.home_player_9 = player.player_api_id OR match.home_player_10 = player.player_api_id OR match.home_player_11 = player.player_api_id WHERE (strftime('%Y', 'now') - strftime('%Y', player.birthday)) <= 30
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.overall_rating = (     SELECT MAX(overall_rating)     FROM player_attributes ) LIMIT 10;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.potential = (SELECT MAX(potential) FROM player_attributes)
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.attacking_work_rate = 'high'
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.finishing = 1 ORDER BY strftime('%Y', 'now') - strftime('%Y', player.birthday) DESC LIMIT 1;
SELECT player.player_name FROM player JOIN country ON player.country_id = country.id WHERE country.name = 'Belgium'
SELECT country.name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id JOIN country ON player.country_id = country.id WHERE player_attributes.vision > 89
SELECT country.name FROM country JOIN player ON country.id = player.country_id GROUP BY country.name HAVING AVG(player.weight) = (     SELECT MAX(avg_weight)     FROM (         SELECT AVG(weight) as avg_weight         FROM player         GROUP BY country_id     ) )
SELECT team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildupplayspeedclass = 'Slow'
SELECT team_short_name FROM team WHERE team_api_id IN (SELECT team_api_id FROM team_attributes WHERE chancecreationpassingclass = 'Safe')
SELECT AVG(player.height) FROM player JOIN country ON player.country_id = country.id WHERE country.name = 'Italy'
SELECT player_name FROM player WHERE height > 180 ORDER BY player_name LIMIT 3;
SELECT COUNT(*)  FROM player  WHERE player_name LIKE 'Aaron%'  AND birthday > '1990-01-01'
SELECT (player_attributes.jumping) - (SELECT jumping FROM player_attributes WHERE id = 23) FROM player_attributes WHERE id = 6
SELECT player_api_id FROM player_attributes WHERE potential = (SELECT MIN(potential) FROM player_attributes) AND preferred_foot = 'right' LIMIT 3;
SELECT COUNT(*)  FROM player_attributes  WHERE crossing = (SELECT MAX(crossing) FROM player_attributes)  AND preferred_foot = 'left'
SELECT COUNT(*) * 100.0 / (SELECT COUNT(*) FROM player_attributes)  FROM player_attributes  WHERE stamina > 80 AND strength > 80;
SELECT country.name FROM country JOIN league ON league.country_id = country.id WHERE league.name = 'Poland Ekstraklasa'
SELECT match.home_team_goal, match.away_team_goal FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Belgian Jupiler League' AND match.date LIKE '2008-09-24%';
SELECT player_attributes.sprint_speed, player_attributes.agility, player_attributes.acceleration FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Alexis Blin'
SELECT team_attributes.buildupplayspeedclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'KSV Cercle Brugge'
SELECT COUNT(*)  FROM match  JOIN league ON match.league_id = league.id  WHERE league.name = 'Italy Serie A' AND match.season = '2015/2016'
SELECT MAX(home_team_goal) FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Netherlands Eredivisie'
SELECT player_attributes.finishing, player_attributes.curve FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.weight = (SELECT MAX(weight) FROM player)
SELECT league.name FROM league JOIN match ON league.id = match.league_id WHERE match.season = '2015/2016' GROUP BY league.name ORDER BY COUNT(match.id) DESC LIMIT 1;
SELECT team.team_long_name FROM team JOIN match ON match.away_team_api_id = team.team_api_id WHERE match.away_team_goal = (     SELECT MAX(away_team_goal)     FROM match )
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.overall_rating = (     SELECT MAX(overall_rating)     FROM player_attributes )
SELECT (COUNT(*) * 100) / (SELECT COUNT(*) FROM player_attributes) FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.height < 180 AND player_attributes.overall_rating > 70;
SELECT (SELECT (SELECT COUNT(id) FROM patient WHERE sex = 'M' AND admission = '+') - (SELECT COUNT(id) FROM patient WHERE sex = 'M' AND admission = '-')) / (SELECT COUNT(id) FROM patient WHERE sex = 'M' AND (admission = '+' OR admission = '-')) * 100
SELECT (COUNT(id) * 100 / (SELECT COUNT(id) FROM patient WHERE sex = 'F' AND strftime('%Y', birthday) > '1930')) FROM patient WHERE sex = 'F' AND strftime('%Y', birthday) > '1930'
SELECT COUNT(*) * 100 / (SELECT COUNT(*) FROM patient WHERE birthday BETWEEN '1930-01-01' AND '1940-12-31') FROM patient WHERE birthday BETWEEN '1930-01-01' AND '1940-12-31' AND admission = '+';
SELECT COUNT(patient.id) / COUNT(patient.id) FROM patient WHERE patient.diagnosis = 'SLE' AND patient.admission = '+' OR patient.admission = '-'
SELECT examination.diagnosis, laboratory.date FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE patient.id = '30609'
SELECT patient.sex, patient.birthday, examination."examination date", examination.symptoms FROM patient JOIN examination ON examination.id = patient.id WHERE patient.id = '163109'
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.ldh > '500'
SELECT patient.id, strftime('%Y', 'now') - strftime('%Y', patient.birthday) AS age FROM patient JOIN examination ON examination.id = patient.id WHERE examination.rvvt = '+'
SELECT patient.id, patient.sex, patient.diagnosis FROM examination JOIN patient ON examination.id = patient.id WHERE examination.thrombosis = 2
SELECT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE strftime('%Y', patient.birthday) = '1937' AND laboratory."t-cho" >= '250'
SELECT patient.id, patient.sex, patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.alb < 3.5
SELECT (COUNT(DISTINCT patient.id) * 100) / (SELECT COUNT(DISTINCT patient.id) FROM patient WHERE patient.sex = 'F' AND (laboratory.tp < '6.0' OR laboratory.tp > '8.5')) FROM patient INNER JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'F' AND (laboratory.tp < '6.0' OR laboratory.tp > '8.5')
SELECT AVG(examination."acl igg")  FROM examination  INNER JOIN patient ON examination.id = patient.id  WHERE patient.admission = '+'  AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) >= 50;
SELECT COUNT(*)  FROM patient  WHERE sex = 'F' AND strftime('%Y', description) = '1997' AND admission = '-'
SELECT MIN(strftime('%Y', patient.birthday) - strftime('%Y', patient.`first date`)) AS age FROM patient
SELECT COUNT(DISTINCT patient.id)  FROM examination  JOIN patient ON examination.id = patient.id  WHERE examination.thrombosis = '1'  AND examination."examination date" LIKE '1997%'  AND patient.sex = 'F'
SELECT MAX(strftime('%Y', birthday)) - MIN(strftime('%Y', birthday))  FROM patient  WHERE id IN (     SELECT id      FROM laboratory      WHERE tg >= 200 )
SELECT examination.symptoms, patient.diagnosis FROM examination JOIN patient ON examination.id = patient.id WHERE patient.birthday = (SELECT MIN(birthday) FROM patient)
SELECT COUNT(patient.id)/12 FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.date BETWEEN '1998-01-01' AND '1998-12-31'
SELECT MAX(l.date) AS "Date of Medical Laboratory Work", (CAST(strftime('%Y', p."First Date") AS INTEGER) - CAST(strftime('%Y', p.birthday) AS INTEGER)) AS "Age at Initial Hospital Arrival"  FROM patient p  JOIN examination e ON e.id = p.id  JOIN laboratory l ON l.id = p.id  WHERE p.diagnosis = 'SJS'  GROUP BY p.birthday  ORDER BY p.birthday ASC  LIMIT 1;
SELECT COUNT(DISTINCT CASE WHEN patient.sex = 'M' AND laboratory.ua <= '8.0' THEN patient.id END) / COUNT(DISTINCT CASE WHEN patient.sex = 'F' AND laboratory.ua <= '6.5' THEN patient.id END) FROM patient JOIN laboratory ON patient.id = laboratory.id
SELECT COUNT(DISTINCT patient.id)  FROM patient  LEFT JOIN examination ON patient.id = examination.id  WHERE (strftime('%Y', examination.`examination date`) - strftime('%Y', patient.`first date`)) >= 1  AND examination.`examination date` IS NULL
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN examination ON examination.id = patient.id WHERE DATE(patient.birthday) BETWEEN '1990-01-01' AND '1993-12-31'
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory."t-bil" > 2.0
SELECT diagnosis FROM examination WHERE examination.id IN (     SELECT id     FROM patient     WHERE id IN (         SELECT id         FROM laboratory         WHERE date BETWEEN '1985-01-01' AND '1995-12-31'     ) ) GROUP BY diagnosis ORDER BY COUNT(diagnosis) DESC LIMIT 1;
SELECT AVG(strftime('%Y', '1991') - strftime('%Y', Birthday)) FROM patient WHERE "first date" BETWEEN '1991-10-01' AND '1991-10-30'
SELECT strftime('%Y', e.`examination date`) - strftime('%Y', p.birthday) AS age, p.diagnosis  FROM examination e  JOIN patient p ON e.id = p.id  JOIN laboratory l ON e.id = l.id  WHERE l.hgb = (SELECT MAX(hgb) FROM laboratory)
SELECT examination.ana FROM examination WHERE examination.id = '3605340' AND "examination date" = '1996-12-02'
SELECT l."t-cho" FROM laboratory l JOIN patient p ON l.id = p.id WHERE p.id = 2927464 AND l.date = '1995-09-04' AND l."t-cho" < 250;
SELECT patient.sex FROM patient INNER JOIN examination ON examination.id = patient.id WHERE patient.diagnosis = 'AORTITIS' ORDER BY patient.first_date ASC LIMIT 1;
SELECT examination.`acl igm` FROM examination JOIN patient ON examination.id = patient.id WHERE patient.diagnosis = 'SLE' AND patient.description = '1994-02-19' AND examination.`examination date` = '1993-11-12'
SELECT patient.sex FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.gpt = '9' AND laboratory.date = '1992-06-12'
SELECT strftime('%Y', '1992') - strftime('%Y', Birthday) AS age FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE ua = '8.4' AND date = '1991-10-21'
SELECT COUNT(laboratory.id)  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE patient."first date" = '1991-06-13'  AND patient.diagnosis = 'SJS'  AND laboratory.date LIKE '1995-%'
SELECT patient.diagnosis  FROM patient  JOIN examination ON examination.id = patient.id  WHERE examination.`examination date` = '1997-01-27'  AND patient.`first date` = examination.`examination date`  AND patient.diagnosis = 'SLE'
SELECT examination.symptoms FROM examination JOIN patient ON examination.id = patient.id WHERE patient.birthday = '1959-03-01' AND examination.date = '1993-09-27'
SELECT ((SUM(CASE WHEN patient.birthday = '1959-02-18' AND laboratory.date LIKE '1981-11-%' THEN laboratory."t-cho" ELSE 0 END) - SUM(CASE WHEN patient.birthday = '1959-02-18' AND laboratory.date LIKE '1981-12-%' THEN laboratory."t-cho" ELSE 0 END)) / SUM(CASE WHEN patient.birthday = '1959-02-18' AND laboratory.date LIKE '1981-11-%' THEN laboratory."t-cho" ELSE 0 END)) * 100 FROM patient JOIN laboratory ON patient.id = laboratory.id;
SELECT patient.id  FROM patient  JOIN examination ON examination.id = patient.id  WHERE patient.diagnosis = 'Behcet'  AND examination."examination date" >= '1997-01-01'  AND examination."examination date" < '1998-01-01'
SELECT patient.id  FROM examination  JOIN patient ON examination.id = patient.id  JOIN laboratory ON laboratory.id = patient.id  WHERE examination."examination date" BETWEEN '1987-07-06' AND '1996-01-31'  AND laboratory.gpt > 30  AND laboratory.alb < 4
SELECT patient.id FROM patient WHERE patient.sex = 'F' AND strftime('%Y', patient.birthday) = '1964' AND patient.admission = '+'
SELECT COUNT(*)  FROM examination  JOIN patient ON examination.id = patient.id  JOIN laboratory ON laboratory.id = patient.id  WHERE examination.thrombosis = 2  AND examination.`ana pattern` = 'S'  AND laboratory.igm > (SELECT AVG(igm) * 1.2 FROM laboratory)
SELECT (COUNT(*) * 100) / (SELECT COUNT(*) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.ua <= 6.5 AND laboratory.un > 0 AND laboratory.un < 30) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.un > 0 AND laboratory.un < 30;
SELECT (COUNT(*) * 100) / (SELECT COUNT(*) FROM patient WHERE sex = 'M' AND strftime('%Y', `patient`.`first date`) = '1981') FROM patient WHERE sex = 'M' AND strftime('%Y', `patient`.`description`) = '1981' AND diagnosis = 'BEHCET'
SELECT patient.id, patient.sex, patient.birthday, patient.description, laboratory.date, laboratory.t-bil FROM patient JOIN examination ON patient.id = examination.id JOIN laboratory ON patient.id = laboratory.id WHERE patient.admission = '-'  AND laboratory.date LIKE '1991-10%'  AND laboratory.t-bil < 2.0;
SELECT COUNT(*) FROM patient  WHERE ("ANA Pattern" != 'P') AND (Sex = 'F') AND (Birthday BETWEEN '1980-01-01' AND '1989-12-31')
SELECT patient.sex FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE examination.diagnosis = 'PSS' AND laboratory.crp = '2+' AND laboratory.cre = 1 AND laboratory.ldh = 123;
SELECT AVG(laboratory.alb) FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE patient.sex = 'F' AND laboratory.plt > 400 AND patient.diagnosis = 'SLE'
SELECT symptoms FROM examination WHERE diagnosis = 'SLE' GROUP BY symptoms ORDER BY COUNT(*) DESC LIMIT 1;
SELECT patient.description, patient.diagnosis FROM patient WHERE patient.id = '48473'
SELECT COUNT(*)  FROM patient  WHERE sex = 'F' AND diagnosis = 'APS'
SELECT COUNT(DISTINCT examination.id)  FROM examination  JOIN patient ON examination.id = patient.id  JOIN laboratory ON examination.id = laboratory.id  WHERE strftime('%Y', date) = '1997'  AND (laboratory.tp < 6 OR laboratory.tp > 8.5)
SELECT (COUNT(DISTINCT patient.id) * 100) / (SELECT COUNT(DISTINCT patient.id) FROM examination JOIN patient ON examination.id = patient.id WHERE examination.symptoms LIKE '%thrombocytopenia%') FROM examination JOIN patient ON examination.id = patient.id WHERE examination.symptoms LIKE '%thrombocytopenia%' AND patient.diagnosis LIKE '%SLE%'
SELECT (COUNT(*) * 100) / (SELECT COUNT(*) FROM patient WHERE strftime('%Y', birthday) = '1980' AND diagnosis = 'RA') FROM patient WHERE strftime('%Y', birthday) = '1980' AND diagnosis = 'RA' AND sex = 'F'
SELECT COUNT(DISTINCT patient.id)  FROM patient  JOIN examination ON examination.id = patient.id  WHERE patient.sex = 'M'  AND examination.`examination date` BETWEEN '1995-01-01' AND '1997-12-31'  AND patient.diagnosis = 'BEHCET'  AND patient.admission = '-'
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'F' AND laboratory.wbc < 3.5
SELECT DATEDIFF(examination.date, patient.first_date) FROM examination INNER JOIN patient ON examination.id = patient.id WHERE patient.id = '821298';
SELECT laboratory.ua FROM laboratory JOIN patient ON laboratory.id = patient.id WHERE patient.id = 57266
SELECT laboratory.date FROM laboratory WHERE laboratory.id = '48473' AND laboratory.got >= 60;
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.got < 60 AND strftime('%Y', laboratory.date) = '1994'
SELECT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.gpt >= 60
SELECT patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.gpt > 60 ORDER BY patient.birthday ASC
SELECT AVG(ldh) FROM laboratory WHERE ldh < 500
SELECT patient.id, (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) as age FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.ldh BETWEEN 600 AND 800
SELECT patient.admission FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.alp < 300
SELECT patient.id FROM patient WHERE patient.birthday = '1982-04-01' AND       (SELECT laboratory.alp FROM laboratory WHERE laboratory.id = patient.id) < 300;
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tp < 6.0
SELECT patient.id, patient.sex, laboratory.tp, laboratory.date FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'F' AND laboratory.tp > 8.5
SELECT patient.id, patient.sex, patient.birthday, patient.description, patient.admission, patient.diagnosis  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE patient.sex = 'M' AND (laboratory.alb <= 3.5 OR laboratory.alb >= 5.5)  ORDER BY patient.birthday DESC;
SELECT patient.id, patient.birthday, laboratory.alb FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE strftime('%Y', patient.birthday) = '1982' AND laboratory.alb >= 3.5 AND laboratory.alb <= 5.5
SELECT COUNT(DISTINCT patient.id) * 100.0 / (SELECT COUNT(DISTINCT patient.id) FROM patient WHERE patient.sex = 'F')  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE (patient.sex = 'F' AND laboratory.ua > 6.5)
SELECT AVG(ua) AS average_ua_index FROM laboratory JOIN patient ON laboratory.id = patient.id WHERE (ua < 8.0 AND patient.sex = 'M') OR (ua < 6.5 AND patient.sex = 'F')
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.un = 29
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.diagnosis = 'RA' AND laboratory.un < 30
SELECT COUNT(*)  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE patient.sex = 'M' AND laboratory.cre >= 1.5
SELECT CASE WHEN (SELECT COUNT(*) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE sex = 'M' AND laboratory.cre >= 1.5) > (SELECT COUNT(*) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE sex = 'F' AND laboratory.cre >= 1.5) THEN 'True' ELSE 'False' END;
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory."t-bil" = (SELECT MAX("t-bil") FROM laboratory)
SELECT patient.sex, COUNT(*) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory."t-bil" >= 2.0 GROUP BY patient.sex
SELECT patient.id, MAX(laboratory."t-cho") as "T-CHO index" FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.birthday = (SELECT MIN(birthday) FROM patient) GROUP BY patient.id;
SELECT AVG(strftime('%Y', 'now') - strftime('%Y', birthday))  FROM patient  WHERE sex = 'M'  AND id IN (SELECT id FROM laboratory WHERE "t-cho" >= 250)
SELECT patient.id, patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tg > 300
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tg >= 200 AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) > 50;
SELECT DISTINCT examination.id FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON examination.id = laboratory.id WHERE patient.admission = '-' AND laboratory.cpk < 250;
SELECT COUNT(*) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE strftime('%Y', patient.birthday) BETWEEN '1936' AND '1956' AND patient.sex = 'M' AND laboratory.cpk >= 250;
SELECT patient.id, patient.sex, (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) as age FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.glu >= 180 AND laboratory."t-cho" < 250
SELECT patient.id, laboratory.glu FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.glu < 180 AND strftime('%Y', patient.description) >= '1991'
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.wbc <= 3.5 OR laboratory.wbc >= 9.0 GROUP BY patient.sex, patient.birthday ORDER BY patient.birthday ASC
SELECT patient.id, strftime('%Y', 'now') - strftime('%Y', patient.birthday) AS age, patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.rbc < 3.5
SELECT patient.id, patient.admission FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE patient.sex = 'F' AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) >= 50 AND (laboratory.rbc <= 3.5 OR laboratory.rbc >= 6.0)
SELECT patient.id, patient.sex FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE patient.admission = '-' AND laboratory.hgb < 10;
SELECT patient.id, patient.sex FROM patient WHERE patient.diagnosis = 'SLE' AND patient.id IN (     SELECT examination.id     FROM examination     WHERE examination.diagnosis = 'SLE' AND examination.id = patient.id ) AND patient.birthday = (     SELECT MIN(patient.birthday)     FROM patient     WHERE patient.diagnosis = 'SLE' AND patient.id IN (         SELECT examination.id         FROM examination         WHERE examination.diagnosis = 'SLE' AND examination.id = patient.id     ) ) AND (     SELECT laboratory.hgb     FROM laboratory     WHERE laboratory.id = patient.id ) > 10 AND (     SELECT laboratory.hgb     FROM laboratory     WHERE laboratory.id = patient.id ) < 17
SELECT patient.id, (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) as age FROM patient JOIN laboratory ON patient.id = laboratory.id GROUP BY patient.id HAVING COUNT(patient.id) > 2 AND MAX(laboratory.hct) >= 52;
SELECT AVG(hct)  FROM laboratory  WHERE date LIKE '1991%' AND hct < 29;
SELECT COUNT(*) FROM examination WHERE examination.id IN (     SELECT patient.id FROM patient     WHERE patient.id IN (         SELECT laboratory.id FROM laboratory         WHERE plt < 100     ) )
SELECT patient.id FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE laboratory.date LIKE '1984%' AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) < 50 AND laboratory.plt BETWEEN 100 AND 400;
SELECT (SUM(CASE WHEN laboratory.pt >= 14 AND patient.sex = 'F' THEN 1 ELSE 0 END) * 100.0 / COUNT(*))  FROM patient  JOIN laboratory ON patient.id = laboratory.id WHERE (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) > 55
SELECT patient.id FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE strftime('%Y', patient.`First Date`) > '1992' AND laboratory.pt < 14;
SELECT COUNT(*) FROM examination WHERE `Examination Date` > '1997-01-01' AND aptt >= 45;
SELECT COUNT(DISTINCT examination.id)  FROM examination  JOIN patient ON examination.id = patient.id  JOIN laboratory ON examination.id = laboratory.id  WHERE laboratory.aptt > 45 AND examination.thrombosis = 3
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE patient.sex = 'M' AND laboratory.wbc >= 3.5 AND laboratory.wbc <= 9.0 AND (laboratory.fg < 150 OR laboratory.fg > 450)
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE patient.birthday > '1980-01-01' AND laboratory.fg NOT BETWEEN 150 AND 450;
SELECT patient.diagnosis FROM patient JOIN examination ON patient.id = examination.id JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.u_pro >= 30;
SELECT patient.id FROM patient INNER JOIN laboratory ON patient.id = laboratory.id WHERE patient.diagnosis = 'SLE' AND laboratory.u_pro > 0 AND laboratory.u_pro < 30;
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id WHERE examination."acl igg" < 900 AND examination.symptoms = 'abortion'
SELECT COUNT(*)  FROM examination  JOIN laboratory ON examination.id = laboratory.id  JOIN patient ON examination.id = patient.id  WHERE laboratory.igg BETWEEN 900 AND 2000  AND examination.symptoms IS NOT NULL;
SELECT examination.diagnosis FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE laboratory.iga BETWEEN 80 AND 500 ORDER BY laboratory.iga DESC LIMIT 1;
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE IGA BETWEEN 80 AND 500 AND strftime('%Y', patient.`First Date`) >= '1990';
SELECT examination.diagnosis  FROM examination  JOIN patient ON examination.id = patient.id  WHERE examination."acl igm" < 40 OR examination."acl igm" > 400  GROUP BY examination.diagnosis  ORDER BY COUNT(*) DESC  LIMIT 1;
SELECT COUNT(*) FROM patient LEFT JOIN laboratory ON patient.id = laboratory.id WHERE (crp < 1.0 OR crp LIKE '+' OR crp LIKE '-') AND description IS NULL
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE crp NOT IN('+-', '-') AND crp >= 1.0 AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) < 18;
SELECT COUNT(DISTINCT examination.id)  FROM examination  JOIN patient ON examination.id = patient.id  WHERE examination.diagnosis = 'Normal' AND examination.kct = '+';
SELECT patient.diagnosis  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE DATE(patient.birthday) >= '1995-01-01'  AND laboratory.rf IN ('-', '+-');
SELECT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE rf < 20 AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) > 60;
SELECT COUNT(DISTINCT patient.id) FROM patient WHERE patient.diagnosis <> 'thrombosis' AND EXISTS (   SELECT *   FROM laboratory   WHERE laboratory.id = patient.id AND laboratory.rf < 20 )
SELECT COUNT(DISTINCT patient.id)  FROM patient  JOIN examination ON examination.id = patient.id  JOIN laboratory ON laboratory.id = patient.id  WHERE examination."ana pattern" = 'P'  AND laboratory.c3 > 35
SELECT patient.id  FROM examination  JOIN patient ON examination.id = patient.id  JOIN laboratory ON laboratory.id = patient.id  WHERE laboratory.hct NOT BETWEEN 29 AND 52  ORDER BY laboratory.iga DESC  LIMIT 1;
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE examination.thrombosis > 0 AND laboratory.c4 > 10
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.admission = '+' AND laboratory.rnp IN ('-', '+-')
SELECT patient.birthday FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE laboratory.rnp NOT IN ('-', '+-') ORDER BY patient.birthday ASC LIMIT 1;
SELECT COUNT(*)  FROM examination  JOIN patient ON examination.id = patient.id  WHERE examination.diagnosis = 'Normal'  AND examination.ana = 'negative'  AND examination.thrombosis = '1'
SELECT patient.id FROM examination JOIN patient ON examination.id = patient.id WHERE examination.id IN (   SELECT patient.id   FROM laboratory   JOIN patient ON laboratory.id = patient.id   WHERE sm NOT IN ('-', '+-')   ORDER BY birthday DESC   LIMIT 3 )
SELECT patient.id FROM examination  JOIN patient ON examination.id = patient.id  WHERE "examination date" >= '1997-01-01'  AND "sc170" = 'negative'
SELECT COUNT(DISTINCT patient.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE examination.diagnosis = 'Normal' AND laboratory.sc170 IN ('-', '+-') AND patient.sex = 'M' AND examination.symptoms = 'vertigo'
SELECT COUNT(DISTINCT examination.id) FROM examination  INNER JOIN patient ON examination.id = patient.id INNER JOIN laboratory ON patient.id = laboratory.id WHERE examination.diagnosis = 'Normal' AND patient.admission IN ('-', '-+', '+(') AND laboratory.date < '1990-01-01' AND laboratory.ssa IN ('-', '+-')
SELECT patient.id FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE examination.id = (     SELECT MIN(`First Date`)     FROM patient ) AND laboratory.ssa NOT IN ('-', '+-')
SELECT COUNT(DISTINCT patient.id) FROM patient INNER JOIN examination ON examination.id = patient.id INNER JOIN laboratory ON laboratory.id = patient.id WHERE examination.diagnosis = 'SLE' AND laboratory.ssb IN ('negative', '0')
SELECT COUNT(DISTINCT examination.id)  FROM examination INNER JOIN patient ON examination.id = patient.id WHERE examination.id IN (     SELECT laboratory.id     FROM laboratory     WHERE laboratory.ssb = 'negative' ) AND examination.symptoms IS NOT NULL;
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE centromea IN ('-', '+-') AND ssb IN ('-', '+-') AND sex = 'M'
SELECT examination.diagnosis FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE laboratory.dna >= 8
SELECT COUNT(DISTINCT examination.id) FROM examination LEFT JOIN laboratory ON examination.id = laboratory.id LEFT JOIN patient ON examination.id = patient.id WHERE examination.diagnosis = 'Normal' AND laboratory.dna < 8 AND patient.description IS NULL;
SELECT COUNT(*) FROM patient WHERE id IN ( SELECT id FROM laboratory WHERE "dna-ii" > 8 ) AND admission = '+';
SELECT (SELECT (CAST(COUNT(DISTINCT examination.id) AS FLOAT) / CAST(COUNT(DISTINCT patient.id) AS FLOAT)) * 100  FROM examination  JOIN patient ON examination.id = patient.id  JOIN laboratory ON patient.id = laboratory.id  WHERE laboratory.got >= 60 AND patient.diagnosis = 'SLE') AS percentage
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.got < 60;
SELECT MIN(patient.birthday) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.got >= 60
SELECT patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.gpt < 60 ORDER BY laboratory.gpt DESC LIMIT 3;
SELECT COUNT(*)  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE got < 60 AND sex = 'M'
SELECT MIN(patient."first date") FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.ldh < 500
SELECT MAX("patient"."first date") FROM patient JOIN laboratory ON "patient"."id" = "laboratory"."id" WHERE "laboratory"."ldh" >= 500
SELECT COUNT(*)  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE alp >= 300 AND admission = '+';
SELECT COUNT(*)  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE patient.admission = '-' AND laboratory.alp < 300;
SELECT examination.diagnosis FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE laboratory.tp < 6.0
SELECT COUNT(*)  FROM patient  JOIN examination ON patient.id = examination.id  JOIN laboratory ON patient.id = laboratory.id  WHERE patient.diagnosis = 'SJS'  AND laboratory.tp > 6.0  AND laboratory.tp < 8.5;
SELECT examination.date FROM examination JOIN laboratory ON examination.id = laboratory.id WHERE laboratory.alb > 3.5 AND laboratory.alb < 5.5 ORDER BY laboratory.alb DESC LIMIT 1;
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.alb > 3.5 AND laboratory.alb < 5.5 AND laboratory.tp > 6.0 AND laboratory.tp < 8.5;
SELECT patient.id FROM patient INNER JOIN examination ON examination.id = patient.id INNER JOIN laboratory ON laboratory.id = patient.id WHERE patient.sex = 'F' AND laboratory.ua <= 6.50 ORDER BY laboratory.ua DESC LIMIT 1
SELECT MAX(ana)  FROM examination  WHERE id IN (SELECT id FROM laboratory WHERE cre < 1.5)
SELECT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.cre < 1.5 ORDER BY laboratory.iga DESC LIMIT 1;
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE laboratory."t-bil" >= 2.0 AND examination."ana pattern" LIKE '%P%';
SELECT examination.`ana` FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE laboratory.`t-bil` < 2.0 ORDER BY laboratory.`t-bil` DESC LIMIT 1;
SELECT COUNT(*)  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE laboratory.t_cho >= 250  AND laboratory.kct = '-';
SELECT COUNT(*)  FROM examination  INNER JOIN laboratory ON examination.id = laboratory.id  WHERE laboratory.`t-cho` < 250  AND examination.`ana pattern` = 'P';
SELECT COUNT(*)  FROM patient  JOIN laboratory ON patient.id = laboratory.id  JOIN examination ON patient.id = examination.id  WHERE tg < 200 AND symptoms IS NOT NULL
SELECT patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tg < 200 ORDER BY laboratory.tg DESC LIMIT 1;
SELECT patient.id FROM patient LEFT JOIN examination ON examination.id = patient.id LEFT JOIN laboratory ON laboratory.id = patient.id WHERE examination.thrombosis = 0 AND laboratory.cpk < 250;
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE laboratory.cpk < 250 AND (examination.kct = '+' OR examination.rvvt = '+' OR examination.lac = '+')
SELECT MIN(patient.birthday) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.glu > 180
SELECT COUNT(*)  FROM patient p  JOIN laboratory l ON p.id = l.id  JOIN examination e ON p.id = e.id  WHERE l.glu < 180  AND e.thrombosis = 0
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.admission = '+' AND laboratory.wbc >= 3.5 AND laboratory.wbc <= 9.0;
SELECT COUNT(*)  FROM patient  WHERE diagnosis = 'SLE'  AND EXISTS (     SELECT *      FROM laboratory      WHERE laboratory.id = patient.id      AND wbc >= 3.5      AND wbc <= 9.0 )
SELECT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE rbc < 3.5 OR rbc > 6.0 AND admission = '-'
SELECT COUNT(DISTINCT examination.id) FROM examination INNER JOIN laboratory ON examination.id = laboratory.id WHERE laboratory.plt > 100 AND laboratory.plt < 400 AND examination.diagnosis IS NOT NULL;
SELECT l.plt FROM patient p JOIN examination e ON p.id = e.id JOIN laboratory l ON p.id = l.id WHERE p.diagnosis = 'MCTD' AND l.plt > 100 AND l.plt < 400;
SELECT AVG(pt) FROM laboratory JOIN patient ON laboratory.id = patient.id WHERE patient.sex = 'M' AND laboratory.pt < 14;
SELECT COUNT(DISTINCT examination.id)  FROM examination  JOIN laboratory ON examination.id = laboratory.id  WHERE examination.thrombosis IN (1, 2) AND laboratory.pt < 14;
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Angela' AND member.last_name = 'Sanders'
SELECT COUNT(*)  FROM member  JOIN major ON member.link_to_major = major.major_id  WHERE major.college = 'College of Engineering'
SELECT member.first_name || ' ' || member.last_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.department = 'Art and Design Department'
SELECT COUNT(*)  FROM attendance  JOIN event ON attendance.link_to_event = event.event_id  JOIN member ON attendance.link_to_member = member.member_id  WHERE event.event_name = "Women's Soccer"
SELECT member.phone FROM member JOIN attendance ON attendance.link_to_member = member.member_id JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = "Women's Soccer"
SELECT COUNT(*)  FROM attendance  JOIN member ON attendance.link_to_member = member.member_id  JOIN event ON attendance.link_to_event = event.event_id  WHERE event.event_name = "Women's Soccer" AND member.t_shirt_size = 'Medium'
SELECT event.event_name FROM event JOIN attendance ON event.event_id = attendance.link_to_event GROUP BY event.event_id ORDER BY COUNT(attendance.link_to_member) DESC LIMIT 1;
SELECT college FROM member JOIN major ON member.link_to_major = major.major_id WHERE position = 'Vice President'
SELECT event.event_name FROM event JOIN attendance ON attendance.link_to_event = event.event_id JOIN member ON member.member_id = attendance.link_to_member WHERE member.first_name = 'Maya' AND member.last_name = 'Mclean';
SELECT COUNT(*)  FROM attendance  JOIN member ON attendance.link_to_member = member.member_id  JOIN event ON attendance.link_to_event = event.event_id  WHERE member.first_name = 'Sacha' AND member.last_name = 'Harrison' AND strftime('%Y', event.event_date) = '2019'
SELECT COUNT(event_id) FROM event WHERE type = 'Meeting' AND event_id IN (     SELECT link_to_event     FROM attendance     GROUP BY link_to_event     HAVING COUNT(link_to_member) > 10 )
SELECT event_name FROM event WHERE event_id IN ( SELECT link_to_event FROM attendance GROUP BY link_to_event HAVING COUNT(*) > 20 )
SELECT AVG(attendance_count / event_count) FROM (   SELECT COUNT(DISTINCT event_name) AS event_count, COUNT(event_id) AS attendance_count   FROM event   WHERE type = 'Meeting' AND strftime('%Y', event_date) = '2020' ) AS subquery
SELECT expense_description FROM expense WHERE cost = (     SELECT MAX(cost)     FROM expense )
SELECT COUNT(*)  FROM member  JOIN major ON member.link_to_major = major.major_id  WHERE major.major_name = 'Environmental Engineering'
SELECT member.first_name || ' ' || member.last_name FROM member JOIN attendance ON attendance.link_to_member = member.member_id JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'Laugh Out Loud'
SELECT member.last_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Law and Constitutional Studies'
SELECT county FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Sherri' AND member.last_name = 'Ramsey'
SELECT college FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Tyler' AND member.last_name = 'Hewitt'
SELECT SUM(income.amount) FROM member JOIN income ON member.member_id = income.link_to_member WHERE member.position = 'Vice President'
SELECT SUM(expense.cost)  FROM expense  JOIN member ON expense.link_to_member = member.member_id  JOIN budget ON expense.link_to_budget = budget.budget_id  JOIN event ON budget.link_to_event = event.event_id  WHERE event.event_name = 'September Meeting'  AND budget.category = 'Food'
SELECT zip_code.city, zip_code.state FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.position = 'President' AND member.first_name = 'Student_Club'
SELECT member.first_name || ' ' || member.last_name FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE zip_code.state = 'Illinois'
SELECT SUM(expense.cost)  FROM expense  JOIN member ON expense.link_to_member = member.member_id  JOIN budget ON expense.link_to_budget = budget.budget_id  JOIN event ON budget.link_to_event = event.event_id  WHERE event.event_name = 'September Meeting'  AND budget.category = 'Advertisement'
SELECT department FROM major JOIN member ON member.link_to_major = major.major_id WHERE member.first_name = 'Pierce' AND member.last_name = 'Guidi'
SELECT SUM(amount)  FROM budget  WHERE link_to_event = (SELECT event_id FROM event WHERE event_name = 'October Speaker')
SELECT expense.approved FROM expense JOIN event ON expense.link_to_budget = event.event_id WHERE event.event_name = 'October Meeting' AND event.event_date = '2019-10-08'
SELECT AVG(expense.cost) AS average_cost FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.first_name = 'Elijah' AND member.last_name = 'Allen' AND (strftime('%m', expense.expense_date) = '09' OR strftime('%m', expense.expense_date) = '10')
SELECT SUM(CASE WHEN strftime('%Y', event_date) = '2019' THEN spent ELSE 0 END) - SUM(CASE WHEN strftime('%Y', event_date) = '2020' THEN spent ELSE 0 END) AS difference FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE strftime('%Y', event_date) IN ('2019', '2020')
SELECT event.location FROM event WHERE event.event_name = 'Spring Budget Review'
SELECT expense.cost FROM expense WHERE expense.expense_description = 'Posters' AND expense.expense_date = '2019-09-04'
SELECT MAX(b.remaining) FROM budget b WHERE b.category = 'Food'
SELECT income.notes FROM income WHERE income.source = 'Fundraising' AND income.date_received = '2019-09-14'
SELECT COUNT(*) FROM major WHERE college = "College of Humanities and Social Sciences"
SELECT member.phone FROM member WHERE member.first_name = 'Carlo' AND member.last_name = 'Jacobs'
SELECT zip_code.county FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Adela' AND member.last_name = 'O''Gallagher'
SELECT COUNT(*)  FROM budget  WHERE link_to_event = (SELECT event_id FROM event WHERE event_name = 'November Meeting')  AND remaining < 0;
SELECT SUM(amount) FROM budget WHERE link_to_event = (SELECT event_id FROM event WHERE event_name = 'September Speaker')
SELECT event.status FROM event JOIN budget ON event.event_id = budget.link_to_event JOIN expense ON budget.budget_id = expense.link_to_budget WHERE expense.expense_description = 'Post Cards, Posters' AND expense.expense_date = '2019-08-20';
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Brent' AND member.last_name = 'Thomason'
SELECT COUNT(*)  FROM member  JOIN major ON member.link_to_major = major.major_id  WHERE major.major_name = 'Human Development and Family Studies'  AND member.t_shirt_size = 'Large'
SELECT zip_code.type FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Christof' AND member.last_name = 'Nielson'
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'Vice President'
SELECT zip_code.state FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Sacha' AND member.last_name = 'Harrison'
SELECT major.department FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'President'
SELECT income.date_received FROM income JOIN member ON income.link_to_member = member.member_id WHERE member.first_name = 'Connor' AND member.last_name = 'Hilton' AND income.source = 'Dues'
SELECT member.first_name || ' ' || member.last_name FROM income JOIN member ON income.link_to_member = member.member_id WHERE income.source = 'Dues' ORDER BY income.date_received LIMIT 1;
SELECT COUNT(*)  FROM budget  JOIN event ON budget.link_to_event = event.event_id  WHERE budget.category = 'Advertisement'  AND budget.event_status = 'Open'  AND event.event_name = 'Yearly Kickoff'  AND budget.amount > (      SELECT SUM(b.amount)      FROM budget b      JOIN event e ON b.link_to_event = e.event_id      WHERE b.category = 'Advertisement'      AND b.event_status = 'Open'      AND e.event_name = 'October Meeting'  )
SELECT (SUM(b.amount) * 100) / (SELECT SUM(b.amount) FROM budget b JOIN event e ON b.link_to_event = e.event_id WHERE e.event_name = 'November Speaker' AND b.category = 'Parking') FROM budget b JOIN event e ON b.link_to_event = e.event_id WHERE e.event_name = 'November Speaker' AND b.category = 'Parking'
SELECT SUM(cost)  FROM expense  WHERE expense_description = 'Pizza'
SELECT COUNT(DISTINCT city) FROM zip_code WHERE county = 'Orange County' AND state = 'Virginia'
SELECT major.department FROM major WHERE major.college = 'College of Humanities and Social Sciences'
SELECT zip_code.city, zip_code.county, zip_code.state FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Amy' AND member.last_name = 'Firth'
SELECT expense.expense_description FROM budget JOIN expense ON budget.budget_id = expense.link_to_budget WHERE budget.remaining = (SELECT MIN(remaining) FROM budget)
SELECT member.first_name, member.last_name FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'October Meeting'
SELECT major.college FROM member JOIN major ON member.link_to_major = major.major_id GROUP BY major.college ORDER BY COUNT(*) DESC LIMIT 1;
SELECT major.major_name FROM member JOIN zip_code ON member.zip = zip_code.zip_code JOIN major ON member.link_to_major = major.major_id WHERE member.phone = '809-555-3360'
SELECT event_name FROM event WHERE event_id = (     SELECT link_to_event     FROM budget     WHERE amount = (         SELECT MAX(amount)         FROM budget     ) )
SELECT expense.* FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.position = 'Vice President'
SELECT COUNT(*) FROM attendance JOIN event ON attendance.link_to_event = event.event_id JOIN member ON attendance.link_to_member = member.member_id WHERE event.event_name = 'Women''s Soccer'
SELECT income.date_received FROM income JOIN member ON income.link_to_member = member.member_id WHERE member.first_name = 'Casey' AND member.last_name = 'Mason'
SELECT COUNT(*)  FROM member  JOIN zip_code ON member.zip = zip_code.zip_code  WHERE zip_code.state = 'Maryland'
SELECT COUNT(*)  FROM attendance  JOIN member ON attendance.link_to_member = member.member_id  WHERE member.phone = "954-555-6240"
SELECT member.first_name, member.last_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.department = 'School of Applied Sciences, Technology and Education'
SELECT event_id, event_name, MAX(spent/amount) as spend_to_budget_ratio FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE status = 'Closed' GROUP BY event_id, event_name ORDER BY spend_to_budget_ratio DESC LIMIT 1;
SELECT COUNT(*)  FROM member  WHERE position = 'President'
SELECT MAX(spent) FROM budget
SELECT COUNT(*)  FROM event  WHERE type = 'Meeting' AND strftime('%Y', event_date) = '2020'
SELECT SUM(spent)  FROM budget  WHERE category = 'Food'
SELECT member.first_name || ' ' || member.last_name AS full_name FROM member JOIN attendance ON attendance.link_to_member = member.member_id GROUP BY member.member_id HAVING COUNT(attendance.link_to_event) > 7
SELECT member.first_name, member.last_name FROM member JOIN major ON member.link_to_major = major.major_id JOIN attendance ON attendance.link_to_member = member.member_id JOIN event ON attendance.link_to_event = event.event_id WHERE major.major_name = 'Interior Design' AND event.event_name = 'Community Theater'
SELECT member.first_name, member.last_name FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE zip_code.city = 'Georgetown' AND zip_code.state = 'South Carolina'
SELECT COUNT(*)  FROM income  JOIN member ON income.link_to_member = member.member_id  WHERE member.first_name = 'Grant' AND member.last_name = 'Gilmour'
SELECT member.first_name, member.last_name FROM member JOIN income ON member.member_id = income.link_to_member WHERE income.amount > 40
SELECT SUM(cost)  FROM expense  WHERE link_to_budget IN (     SELECT budget_id      FROM budget      WHERE link_to_event IN (         SELECT event_id          FROM event          WHERE event_name = 'Yearly Kickoff'     ) )
SELECT member.first_name, member.last_name FROM member JOIN budget ON member.member_id = budget.link_to_event JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'Yearly Kickoff'
SELECT member.first_name || ' ' || member.last_name AS full_name, income.source FROM member JOIN income ON member.member_id = income.link_to_member WHERE income.amount = (SELECT MAX(amount) FROM income)
SELECT event_name  FROM event  WHERE event_id = (      SELECT link_to_event      FROM budget      WHERE amount = (          SELECT MIN(amount)          FROM budget      )  )
SELECT (SUM(e.cost) * 100 / (SELECT SUM(cost) FROM expense e)) as percentage FROM event ev  JOIN budget b ON ev.event_id = b.link_to_event JOIN expense e ON b.budget_id = e.link_to_budget WHERE ev.event_name = 'Yearly Kickoff'
SELECT CAST(SUM(CASE WHEN major_name = 'Finance' THEN 1 ELSE 0 END) AS FLOAT) / CAST(SUM(CASE WHEN major_name = 'Physics' THEN 1 ELSE 0 END) AS FLOAT) FROM member INNER JOIN major ON member.link_to_major = major.major_id
SELECT source FROM income WHERE date_received BETWEEN '2019-09-01' AND '2019-09-30' ORDER BY amount DESC LIMIT 1;
SELECT member.first_name || ' ' || member.last_name, member.email FROM member WHERE member.position = 'Secretary'
SELECT COUNT(*)  FROM member  JOIN major ON member.link_to_major = major.major_id  WHERE major.major_name = 'Physics Teaching'
SELECT COUNT(DISTINCT attendance.link_to_member) FROM attendance JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'Community Theater' AND strftime('%Y', event.event_date) = '2019'
SELECT COUNT(*) FROM attendance JOIN member ON attendance.link_to_member = member.member_id WHERE member.first_name = 'Luisa' AND member.last_name = 'Guidi';
SELECT AVG(spent)  FROM budget  WHERE category = 'Food'  AND link_to_event IN (SELECT event_id FROM event WHERE status = 'Closed')
SELECT event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.category = 'Advertisement' AND budget.spent = (SELECT MAX(spent) FROM budget WHERE category = 'Advertisement')
SELECT COUNT(*) FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id WHERE member.first_name = 'Maya' AND member.last_name = 'Mclean' AND event.event_name = "Women's Soccer"
SELECT (SUM(CASE WHEN type = 'Community Service' THEN 1 ELSE 0 END) * 100) / COUNT(event_id) AS percentage_share FROM event WHERE event_date BETWEEN '2019-01-01' AND '2019-12-31'
SELECT expense.cost FROM event JOIN expense ON event.event_id = expense.link_to_budget WHERE event.event_name = 'September Speaker' AND expense.expense_description = 'Posters'
SELECT t_shirt_size, COUNT(t_shirt_size) as count FROM member GROUP BY t_shirt_size ORDER BY count DESC LIMIT 1;
SELECT event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE event.status = 'Closed' AND budget.remaining < 0 ORDER BY budget.remaining LIMIT 1;
SELECT expense.expense_description, SUM(expense.cost) as total_value FROM expense JOIN event ON expense.link_to_budget = event.event_id WHERE event.event_name = 'October Meeting' AND expense.approved = 'true' GROUP BY expense.expense_description;
SELECT budget.amount FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'April Speaker' ORDER BY budget.amount ASC;
SELECT budget_id, MAX(amount) FROM budget WHERE category = 'Food'
SELECT budget_id, category, amount FROM budget WHERE category = 'Advertising' ORDER BY amount DESC LIMIT 3;
SELECT SUM(cost)  FROM expense  WHERE expense_description = 'Parking'
SELECT SUM(cost)  FROM expense  WHERE expense_date = '2019-08-20'
SELECT member.first_name || ' ' || member.last_name AS full_name, SUM(expense.cost) AS total_cost FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE member.member_id = 'rec4BLdZHS2Blfp4v'
SELECT expense_description FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.first_name = 'Sacha' AND member.last_name = 'Harrison'
SELECT expense_description FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.t_shirt_size = 'X-Large'
SELECT zip_code.zip_code FROM member JOIN expense ON member.member_id = expense.link_to_member JOIN zip_code ON member.zip = zip_code.zip_code WHERE expense.cost < 50;
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Phillip' AND member.last_name = 'Cullen'
SELECT member.position FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Business'
SELECT COUNT(*)  FROM member  JOIN major ON member.link_to_major = major.major_id  WHERE major.major_name = 'Business' AND member.t_shirt_size = 'Medium'
SELECT event.type FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.remaining > 30;
SELECT budget.category FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE event.location = 'MU 215'
SELECT event.type FROM event WHERE event.event_date = '2020-03-24T12:00:00'
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'Vice President'
SELECT (SUM(member.position = 'Member' and major.major_name = 'Mathematics') * 100) / COUNT(member.member_id) AS percentage_of_mathematics_majors FROM member JOIN major ON member.link_to_major = major.major_id
SELECT event.type FROM event WHERE event.location = 'MU 215'
SELECT COUNT(*) FROM income WHERE amount = 50;
SELECT COUNT(*)  FROM member  WHERE position = 'Member' AND t_shirt_size = 'X-Large'
SELECT COUNT(*)  FROM major  WHERE department = 'School of Applied Sciences, Technology and Education'  AND college = 'College of Agriculture and Applied Sciences'
SELECT member.last_name, major.department, major.college FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Environmental Engineering'
SELECT budget.category FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.location = 'MU 215' AND event.type = 'Guest Speaker' AND budget.spent = 0;
SELECT zip_code.city, zip_code.state FROM member JOIN zip_code ON member.zip = zip_code.zip_code JOIN major ON member.link_to_major = major.major_id WHERE major.department = 'Electrical and Computer Engineering Department' AND member.position = 'Member'
SELECT event.event_name FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id WHERE event.type = 'Social' AND member.position = 'Vice President' AND event.location = '900 E. Washington St.';
SELECT member.last_name, member.position FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE expense.expense_description = 'Pizza' AND expense.expense_date = '2019-09-10'
SELECT member.last_name FROM member JOIN attendance ON attendance.link_to_member = member.member_id JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'Women''s Soccer' AND member.position = 'Member'
SELECT (COUNT(income.amount = 50) / COUNT(member.member_id)) * 100 AS percentage  FROM member  JOIN income ON member.member_id = income.link_to_member  WHERE member.t_shirt_size = 'Medium'  AND member.position = 'Member'
SELECT zip_code.state FROM zip_code WHERE zip_code.type = 'PO Box'
SELECT zip_code FROM zip_code WHERE type = 'PO Box' AND county = 'San Juan Municipio' AND state = 'Puerto Rico'
SELECT event_name FROM event WHERE type = 'Game' AND status = 'Closed' AND event_date BETWEEN '2019-03-15' AND '2020-03-20'
SELECT event.event_id FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id JOIN expense ON member.member_id = expense.link_to_member WHERE expense.cost > 50
SELECT member.first_name, member.last_name, attendance.link_to_event FROM member JOIN expense ON member.member_id = expense.link_to_member JOIN attendance ON member.member_id = attendance.link_to_member WHERE expense.approved = 'true' AND expense.expense_date BETWEEN '2019-01-10' AND '2019-11-19'
SELECT college FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Katy' AND major.major_id = 'rec1N0upiVLy5esTO'
SELECT member.phone FROM member JOIN major ON member.link_to_major = major.major_id JOIN college ON major.college = college.college WHERE major.major_name = 'Business' AND college.college_name = 'College of Agriculture and Applied Sciences'
SELECT member.email FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE expense_date BETWEEN '2019-09-10' AND '2019-11-19' AND cost > 20;
SELECT COUNT(*)  FROM member  JOIN major ON member.link_to_major = major.major_id  WHERE major.major_name = 'Education' AND major.college = 'College of Education & Human Services' AND member.position = 'Member'
SELECT (CAST(SUM(CASE WHEN budget.remaining < 0 THEN 1 ELSE 0 END) AS FLOAT) / COUNT(event.event_id)) * 100 FROM event JOIN budget ON event.event_id = budget.link_to_event
SELECT event_id, location, status FROM event WHERE event_date BETWEEN '2019-11-01' AND '2020-03-31'
SELECT expense_id, expense_description, cost FROM expense GROUP BY expense_id HAVING AVG(cost) > 50;
SELECT member.first_name || ' ' || member.last_name AS full_name FROM member WHERE member.t_shirt_size = 'X-Large'
SELECT (SUM(CASE WHEN type = 'PO Box' THEN 1 ELSE 0 END) * 100) / COUNT(zip_code) AS percentage_of_po_boxes FROM zip_code
SELECT event_name, location FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.remaining > 0
SELECT event_name, event_date  FROM event  WHERE event_id IN (      SELECT link_to_event      FROM budget      WHERE budget_id IN (         SELECT link_to_budget          FROM expense          WHERE expense_description = 'Pizza'          AND cost > 50          AND cost < 100      ) )
SELECT member.first_name, member.last_name, major.major_name FROM member JOIN expense ON member.member_id = expense.link_to_member JOIN major ON member.link_to_major = major.major_id WHERE expense.cost > 100
SELECT zip_code.city, zip_code.county FROM event JOIN income ON event.event_id = income.link_to_event JOIN zip_code ON event.location = zip_code.zip_code GROUP BY event.event_id HAVING COUNT(income.income_id) > 40;
SELECT member.first_name, member.last_name, MAX(expense.cost)  FROM member  JOIN expense ON member.member_id = expense.link_to_member  GROUP BY member.member_id  HAVING COUNT(DISTINCT expense.link_to_budget) > 1
SELECT AVG(cost)  FROM expense  JOIN member ON expense.link_to_member = member.member_id  WHERE member.position != 'Member'
SELECT event_name  FROM event  WHERE event_id IN (      SELECT link_to_event      FROM budget      WHERE category = 'Parking'      AND link_to_event IN (         SELECT link_to_event          FROM expense          WHERE cost < (              SELECT SUM(cost) / COUNT(expense_id)              FROM expense              WHERE expense_description = 'Parking'          )      )  )
SELECT (SUM(expense.cost) / COUNT(event.event_id) * 100) AS percentage_cost  FROM event  JOIN expense ON expense.link_to_budget = budget.budget_id  JOIN budget ON budget.link_to_event = event.event_id  WHERE event.type = 'Game'
SELECT budget_id FROM budget JOIN expense ON budget.budget_id = expense.link_to_budget WHERE expense.expense_description = 'Water, chips, cookies' ORDER BY expense.cost DESC LIMIT 1;
SELECT member.first_name || ' ' || member.last_name AS full_name FROM member JOIN expense ON member.member_id = expense.link_to_member GROUP BY member.member_id ORDER BY MAX(expense.cost) DESC LIMIT 5;
SELECT member.first_name || ' ' || member.last_name, member.phone FROM member JOIN expense ON expense.link_to_member = member.member_id WHERE expense.cost > (SELECT AVG(cost) FROM expense)
SELECT (SUM(CASE WHEN zip_code.state = 'Maine' THEN 1 ELSE 0 END) / COUNT(CASE WHEN member.position = 'Member' THEN 1 ELSE 0 END)) - (SUM(CASE WHEN zip_code.state = 'Vermont' THEN 1 ELSE 0 END) / COUNT(CASE WHEN member.position = 'Member' THEN 1 ELSE 0 END)) FROM member JOIN zip_code ON member.zip = zip_code.zip_code
SELECT major.major_name, major.department FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Garrett' AND member.last_name = 'Gerke';
SELECT member.first_name || ' ' || member.last_name AS full_name, expense.cost FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE expense.expense_description = 'Water, Veggie tray, supplies'
SELECT member.last_name, member.phone FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Elementary Education'
SELECT budget.category, budget.amount FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'January Speaker'
SELECT event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.category = 'Food'
SELECT member.first_name || ' ' || member.last_name AS full_name, income.amount FROM member JOIN income ON member.member_id = income.link_to_member WHERE income.date_received = '2019-09-09'
SELECT budget.category FROM expense JOIN budget ON expense.link_to_budget = budget.budget_id WHERE expense.expense_description = 'Posters'
SELECT member.first_name || ' ' || member.last_name AS full_name, major.college FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'Secretary'
SELECT budget.category, event.event_name, SUM(budget.spent) AS total_amount_spent FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE budget.category = 'Speaker Gifts' GROUP BY budget.category, event.event_name
SELECT zip_code.city FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Garrett' AND member.last_name = 'Girke'
SELECT member.first_name, member.last_name, member.position FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE zip_code.city = 'Lincolnton' AND zip_code.state = 'North Carolina' AND zip_code.zip_code = '28092'
SELECT COUNT(*)  FROM gasstations  WHERE country = 'CZE' AND segment = 'Premium'
SELECT COUNT(*) FROM customers WHERE currency = 'EUR' / (SELECT COUNT(*) FROM customers WHERE currency = 'CZK')
SELECT customers.customerid FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE yearmonth.date BETWEEN 201201 AND 201212 AND customers.segment = 'LAM' ORDER BY yearmonth.consumption ASC LIMIT 1;
SELECT AVG(consumption) / 12 FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE customers.segment = 'SME' AND yearmonth.date BETWEEN '201301' AND '201312'
SELECT customers.customerid FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.currency = 'CZK' AND yearmonth.date BETWEEN '201101' AND '201112' ORDER BY yearmonth.consumption DESC LIMIT 1
SELECT COUNT(*)  FROM customers  JOIN yearmonth ON customers.customerid = yearmonth.customerid  WHERE segment = 'KAM' AND consumption < 30000 AND date BETWEEN 201201 AND 201212
SELECT SUM(CASE WHEN customers.currency = 'CZK' THEN yearmonth.consumption ELSE 0 END) - SUM(CASE WHEN customers.currency = 'EUR' THEN yearmonth.consumption ELSE 0 END) AS difference_in_consumption FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE yearmonth.date BETWEEN '201201' AND '201212'
SELECT strftime('%Y', date) AS year, SUM(price) AS total_paid  FROM transactions_1k  JOIN products ON transactions_1k.productid = products.productid  JOIN customers ON transactions_1k.customerid = customers.customerid WHERE products.description = 'Liber-t fee use'  AND customers.currency = 'EUR'  GROUP BY year  ORDER BY total_paid DESC  LIMIT 1;
SELECT segment FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid GROUP BY segment ORDER BY SUM(consumption) LIMIT 1;
SELECT SUBSTR(yearmonth.date, 1, 4) AS year  FROM yearmonth  JOIN transactions_1k ON yearmonth.customerid = transactions_1k.customerid  JOIN products ON transactions_1k.productid = products.productid  JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid  JOIN customers ON transactions_1k.customerid = customers.customerid  WHERE customers.currency = 'CZK'  GROUP BY year  ORDER BY SUM(transactions_1k.amount) DESC  LIMIT 1;
SELECT yearmonth.date FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE customers.segment = 'SME' AND yearmonth.date LIKE '2013%' ORDER BY yearmonth.consumption DESC LIMIT 1;
SELECT (SUM(CASE WHEN customers.segment = 'SME' THEN yearmonth.consumption ELSE 0 END) / COUNT(DISTINCT CASE WHEN customers.segment = 'SME' THEN yearmonth.customerid END) - SUM(CASE WHEN customers.segment = 'LAM' THEN yearmonth.consumption ELSE 0 END) / COUNT(DISTINCT CASE WHEN customers.segment = 'LAM' THEN yearmonth.customerid END)) AS difference_SME_LAM,  (SUM(CASE WHEN customers.segment = 'LAM' THEN yearmonth.consumption ELSE 0 END) / COUNT(DISTINCT CASE WHEN customers.segment = 'LAM' THEN yearmonth.customerid END) - SUM(CASE WHEN customers.segment = 'KAM' THEN yearmonth.consumption ELSE 0 END) / COUNT(DISTINCT CASE WHEN customers.segment = 'KAM' THEN yearmonth.customerid END)) AS difference_LAM_KAM,  (SUM(CASE WHEN customers.segment = 'KAM' THEN yearmonth.consumption ELSE 0 END) / COUNT(DISTINCT CASE WHEN customers.segment = 'KAM' THEN yearmonth.customerid END) - SUM(CASE WHEN customers.segment = 'SME' THEN yearmonth.consumption ELSE 0 END) / COUNT(DISTINCT CASE WHEN customers.segment = 'SME' THEN yearmonth.customerid END)) AS difference_KAM_SME  FROM yearmonth  JOIN customers ON yearmonth.customerid = customers.customerid  WHERE yearmonth.date BETWEEN '201301' AND '201312'
SELECT segment,  ROUND(((SUM(CASE WHEN currency = 'EUR' AND SUBSTR(date, 1, 4) = '2013' THEN consumption ELSE 0 END) - SUM(CASE WHEN currency = 'EUR' AND SUBSTR(date, 1, 4) = '2012' THEN consumption ELSE 0 END)) / SUM(CASE WHEN currency = 'EUR' AND SUBSTR(date, 1, 4) = '2013' THEN consumption ELSE 0 END)) * 100, 2) AS percentage_increase  FROM customers  JOIN yearmonth ON customers.customerid = yearmonth.customerid  WHERE segment = 'SME' OR segment = 'LAM' OR segment = 'KAM'  AND SUBSTR(date, 1, 4) BETWEEN '201201' AND '201312'  GROUP BY segment  ORDER BY percentage_increase DESC, segment ASC  LIMIT 1;
SELECT SUM(consumption) FROM yearmonth WHERE customerid = 6 AND date >= '201308' AND date <= '201311'
SELECT COUNT(*) FROM gasstations WHERE segment = 'Discount' AND country = 'CZE' EXCEPT SELECT COUNT(*) FROM gasstations WHERE segment = 'Discount' AND country = 'SVK'
SELECT SUM(y1.consumption) - SUM(y2.consumption) FROM yearmonth y1 JOIN yearmonth y2 ON y1.customerid = y2.customerid WHERE y1.customerid = 7 AND y1.date = 201304 AND y2.customerid = 5 AND y2.date = 201304;
SELECT (SELECT COUNT(*) FROM customers WHERE segment = 'SME' AND currency = 'CZK') - (SELECT COUNT(*) FROM customers WHERE segment = 'SME' AND currency = 'EUR') AS difference;
SELECT customers.customerid FROM customers JOIN yearmonth ON yearmonth.customerid = customers.customerid WHERE customers.segment = 'LAM' AND customers.currency = 'EUR' AND yearmonth.date = '201310' ORDER BY yearmonth.consumption DESC LIMIT 1;
SELECT customers.customerid, SUM(yearmonth.consumption) AS total_consumption FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.segment = 'KAM' GROUP BY customers.customerid ORDER BY total_consumption DESC LIMIT 1;
SELECT SUM(consumption) FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE segment = 'KAM' AND date = '201305'
SELECT (COUNT(*) * 100) / (SELECT COUNT(*) FROM customers WHERE segment = 'LAM')  FROM transactions_1k  WHERE customerid IN (SELECT customerid FROM customers WHERE segment = 'LAM')  AND amount > 46.73;
SELECT gasstations.country, COUNT(*) as total_gasstations FROM gasstations WHERE gasstations.segment = "Value for money" GROUP BY gasstations.country;
SELECT (COUNT(*) * 100) / (SELECT COUNT(*) FROM customers WHERE segment = 'KAM')  FROM customers  WHERE segment = 'KAM' AND currency = 'EUR'
SELECT COUNT(*) * 100.0 / (SELECT COUNT(*) FROM yearmonth WHERE date = '201202')  FROM yearmonth  WHERE date = '201202' AND consumption > 528.3
SELECT (COUNT(*) * 100) / (SELECT COUNT(*) FROM gasstations WHERE country = 'SVK') FROM gasstations WHERE country = 'SVK' AND segment = 'Premium'
SELECT yearmonth.customerid FROM yearmonth WHERE yearmonth.date = '201309' ORDER BY yearmonth.consumption DESC LIMIT 1;
SELECT customers.segment FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE yearmonth.date = '201309' ORDER BY yearmonth.consumption LIMIT 1;
SELECT customers.customerid FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.segment = 'SME' AND yearmonth.date = '201206' ORDER BY yearmonth.consumption LIMIT 1;
SELECT MAX(consumption) FROM yearmonth WHERE date LIKE '2012%'
SELECT MAX(consumption/12)  FROM yearmonth  JOIN customers ON yearmonth.customerid = customers.customerid  WHERE customers.currency = 'EUR'
SELECT products.description FROM products JOIN transactions_1k ON products.productid = transactions_1k.productid WHERE transactions_1k.date LIKE '201309%'
SELECT DISTINCT country FROM gasstations WHERE gasstationid IN (     SELECT gasstationid     FROM transactions_1k     WHERE date LIKE '201306%' )
SELECT gasstations.chainid FROM gasstations JOIN transactions_1k ON gasstations.gasstationid = transactions_1k.gasstationid JOIN customers ON transactions_1k.customerid = customers.customerid WHERE customers.currency = 'EUR'
SELECT products.description FROM transactions_1k JOIN products ON transactions_1k.productid = products.productid JOIN customers ON transactions_1k.customerid = customers.customerid WHERE customers.currency = 'EUR'
SELECT AVG(price)  FROM transactions_1k  WHERE date LIKE '2012-01%'
SELECT COUNT(*)  FROM customers  JOIN yearmonth ON customers.customerid = yearmonth.customerid  WHERE customers.currency = 'EUR' AND yearmonth.consumption > 1000
SELECT products.description FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid JOIN products ON transactions_1k.productid = products.productid WHERE gasstations.country = 'CZE'
SELECT transactions_1k.time FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE gasstations.chainid = 11;
SELECT COUNT(*) FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE gasstations.country = 'CZE' AND transactions_1k.price > 1000;
SELECT COUNT(*) FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE gasstations.country = 'CZE' AND transactions_1k.date > '2012-01-01'
SELECT AVG(price)  FROM transactions_1k  JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid  WHERE gasstations.country = 'CZE'
SELECT AVG(transactions_1k.price)  FROM transactions_1k  JOIN customers ON transactions_1k.customerid = customers.customerid  WHERE customers.currency = 'EUR'
SELECT customers.customerid FROM customers JOIN transactions_1k ON customers.customerid = transactions_1k.customerid WHERE transactions_1k.date = '2012-08-25' ORDER BY transactions_1k.price DESC LIMIT 1;
SELECT gasstations.country FROM transactions_1k JOIN customers ON transactions_1k.customerid = customers.customerid JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE transactions_1k.date = '2012-08-25' ORDER BY transactions_1k.time ASC LIMIT 1;
SELECT customers.currency FROM customers JOIN transactions_1k ON customers.customerid = transactions_1k.customerid WHERE transactions_1k.time = '16:25:00' AND transactions_1k.date = '2012-08-24'
SELECT customers.segment FROM customers JOIN transactions_1k T1 ON customers.customerid = T1.customerid WHERE T1.date = '2012-08-23' AND T1.time = '21:20:00'
SELECT COUNT(*) FROM transactions_1k WHERE date = '2012-08-26' AND time < '13:00:00' AND amount = 'EUR'
SELECT customers.segment FROM customers WHERE customers.customerid = (     SELECT MIN(customers.customerid)     FROM customers )
SELECT gasstations.country FROM transactions_1k AS T1 JOIN gasstations ON T1.gasstationid = gasstations.gasstationid WHERE T1.date = '2012-08-24' AND T1.time = '12:42:00'
SELECT productid FROM transactions_1k WHERE date = '2012-08-23' AND time = '21:20:00'
SELECT SUM(transactions_1k.price) AS expenses, yearmonth.date AS date FROM transactions_1k JOIN yearmonth ON transactions_1k.customerid = yearmonth.customerid WHERE transactions_1k.price = 124.05 AND transactions_1k.date = '2012-08-24' AND yearmonth.date LIKE '201201%' GROUP BY yearmonth.date
SELECT COUNT(*) FROM transactions_1k WHERE time >= '08:00:00' AND time <= '09:00:00' AND date = '2012-08-26' AND gasstationid IN (SELECT gasstationid FROM gasstations WHERE country = 'CZE')
SELECT customers.currency FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE yearmonth.date = '201306' AND yearmonth.consumption = 214582.17;
SELECT gasstations.country FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE transactions_1k.cardid = '667467'
SELECT customers.currency  FROM customers  JOIN transactions_1k ON customers.customerid = transactions_1k.customerid  WHERE transactions_1k.date = '2012-08-24' AND transactions_1k.amount = 548.4
SELECT COUNT(*) * 100 / (SELECT COUNT(*) FROM customers WHERE currency = 'EUR') FROM customers WHERE currency = 'EUR' AND customerid IN (SELECT customerid FROM yearmonth WHERE date = '201208')
SELECT ((ym1.consumption - ym2.consumption) / ym1.consumption) AS consumption_decrease_rate FROM yearmonth AS ym1 JOIN yearmonth AS ym2 ON ym1.customerid = ym2.customerid WHERE ym1.date = '2012' AND ym2.date = '2013' AND ym1.customerid = (     SELECT t.customerid     FROM transactions_1k AS t     WHERE t.price = 634.8 AND t.date = '2012-08-25' )
SELECT gasstationid, SUM(amount*price) as revenue FROM transactions_1k GROUP BY gasstationid ORDER BY revenue DESC LIMIT 1;
SELECT ROUND((COUNT(*) * 100.0) / (SELECT COUNT(*) FROM gasstations WHERE segment = 'Premium' AND country = 'SVK'), 2) AS percentage FROM gasstations WHERE segment = 'Premium' AND country = 'SVK'
SELECT SUM(amount)  FROM transactions_1k  WHERE customerid = '38508'  AND date LIKE '201201%'
SELECT products.description FROM products JOIN transactions_1k ON products.productid = transactions_1k.productid GROUP BY products.description ORDER BY SUM(transactions_1k.amount) DESC LIMIT 5;
SELECT customers.customerid, AVG(transactions_1k.price/transactions_1k.amount) as average_price, customers.currency FROM customers JOIN transactions_1k ON customers.customerid = transactions_1k.customerid GROUP BY customers.customerid ORDER BY SUM(transactions_1k.price) DESC LIMIT 1;
SELECT gasstations.country FROM gasstations JOIN transactions_1k ON gasstations.gasstationid = transactions_1k.gasstationid WHERE transactions_1k.productid = 2 ORDER BY transactions_1k.price DESC LIMIT 1;
SELECT yearmonth.consumption FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid JOIN transactions_1k ON customers.customerid = transactions_1k.customerid JOIN products ON transactions_1k.productid = products.productid WHERE products.productid = 5 AND transactions_1k.price / transactions_1k.amount > 29.00 AND yearmonth.date LIKE '%201208%'
