SELECT customers.customerid FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE yearmonth.date BETWEEN 201201 AND 201212 AND customers.segment = 'LAM' ORDER BY yearmonth.consumption ASC LIMIT 1;
SELECT AVG(consumption) / 12 FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE customers.segment = 'SME' AND yearmonth.date BETWEEN '201301' AND '201312'
SELECT customers.customerid FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.currency = 'CZK' AND yearmonth.date BETWEEN '201101' AND '201112' ORDER BY yearmonth.consumption DESC LIMIT 1
SELECT COUNT(*)  FROM customers  JOIN yearmonth ON customers.customerid = yearmonth.customerid  WHERE segment = 'KAM' AND consumption < 30000 AND date BETWEEN 201201 AND 201212
SELECT SUM(CASE WHEN customers.currency = 'CZK' THEN yearmonth.consumption ELSE 0 END) - SUM(CASE WHEN customers.currency = 'EUR' THEN yearmonth.consumption ELSE 0 END) AS difference FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE yearmonth.date BETWEEN '201201' AND '201212'
SELECT STRFTIME('%Y', T2.Date) FROM customers AS T1 INNER JOIN transactions_1k AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Currency = 'EUR' GROUP BY STRFTIME('%Y', T2.Date) ORDER BY SUM(T2.Amount) DESC LIMIT 1
SELECT MIN(segment) AS segment_with_least_consumption FROM     (SELECT         segment,         SUM(consumption) AS total_consumption     FROM         customers     JOIN yearmonth ON customers.customerid = yearmonth.customerid     GROUP BY         segment) AS consumption_summary WHERE     total_consumption = (SELECT MIN(total_consumption) FROM (SELECT         segment,         SUM(consumption) AS total_consumption     FROM         customers     JOIN yearmonth ON customers.customerid = yearmonth.customerid     GROUP BY         segment));
SELECT MAX(SUBSTR(date, 1, 4)) FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid JOIN gasstations ON yearmonth.customerid = gasstations.chainid WHERE customers.currency = 'CZK';
SELECT yearmonth.date FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE customers.segment = 'SME' AND yearmonth.date LIKE '2013%' ORDER BY yearmonth.consumption DESC LIMIT 1;
SELECT SUM(CASE WHEN T2.Segment = 'SME' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'SME' THEN T1.CustomerID ELSE NULL END) - SUM(CASE WHEN T2.Segment = 'LAM' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'LAM' THEN T1.CustomerID ELSE NULL END) AS SME_LAM , SUM(CASE WHEN T2.Segment = 'LAM' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'LAM' THEN T1.CustomerID ELSE NULL END) - SUM(CASE WHEN T2.Segment = 'KAM' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'KAM' THEN T1.CustomerID ELSE NULL END) AS LAM_KAM , SUM(CASE WHEN T2.Segment = 'KAM' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'KAM' THEN T1.CustomerID ELSE NULL END) - SUM(CASE WHEN T2.Segment = 'SME' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'SME' THEN T1.CustomerID ELSE NULL END) AS KAM_SME FROM yearmonth AS T1 INNER JOIN customers AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Date LIKE '2013%' AND T2.Currency = 'CZK'
