SELECT AVG(SUBTRACT(YEAR('now'), YEAR(birthday))) FROM patient WHERE sex = 'M' AND id IN (     SELECT id     FROM laboratory     WHERE t_cho >= 250 );
SELECT patient.id, patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tg > 300
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tg >= 200 AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) > 50;
SELECT DISTINCT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.admission = '-' AND laboratory.cpk < 250;
SELECT COUNT(T1.id) FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.sex = 'M' AND T1.birthday BETWEEN '1936-01-01' AND '1956-12-31' AND T2.cpk > 100
SELECT T1.ID, T1.SEX, T1.BIRTHDAY FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.ID = T2.ID WHERE T2.GLU > 6.1 AND T2.GLU < 11.1 AND T2.T-CHO > 1.7 AND T2.T-CHO < 5.2
SELECT patient.id, laboratory.glu FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.glu < 180 AND strftime('%Y', patient.description) >= '1991'
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.wbc <= 3.5 OR laboratory.wbc >= 9.0 GROUP BY patient.sex, patient.birthday ORDER BY patient.birthday ASC
SELECT T1.diagnosis, T1.ID, T1.birthday FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.ID = T2.ID WHERE T2.rbc < 3.5
SELECT patient.id, patient.admission FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE patient.sex = 'F' AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) >= 50 AND (laboratory.rbc <= 3.5 OR laboratory.rbc >= 6.0)
SELECT patient.id, patient.sex FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE patient.admission = '-' AND laboratory.hgb < 10;
