SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id ORDER BY player_attributes.penalties DESC LIMIT 10;
SELECT team.team_long_name FROM match JOIN league ON match.league_id = league.id JOIN team ON match.away_team_api_id = team.team_api_id WHERE league.name = 'Scotland Premier League' AND match.season = '2009/2010' AND (match.away_team_goal - match.home_team_goal) > 0 GROUP BY match.away_team_api_id ORDER BY COUNT(*) DESC LIMIT 1;
SELECT team.team_long_name, team_attributes.buildupplayspeed FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildupplayspeed = (SELECT MAX(buildupplayspeed) FROM team_attributes) ORDER BY team_attributes.buildupplayspeed DESC LIMIT 4;
SELECT league.name FROM     match JOIN     league ON match.league_id = league.id WHERE     match.season = '2015/2016' GROUP BY     match.league_id ORDER BY     SUM(CASE WHEN match.home_team_goal = match.away_team_goal THEN 1 ELSE 0 END) DESC LIMIT 1;
SELECT player.player_name, (strftime('%Y', 'now') - strftime('%Y', player.birthday)) - (strftime('%m-%d', 'now') < strftime('%m-%d', player.birthday)) AS age FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.sprint_speed >= 97 AND player_attributes.date >= '2013-01-01 00:00:00' AND player_attributes.date <= '2015-12-31 00:00:00'
SELECT league.name, COUNT(match.id) as total_matches FROM league JOIN match ON league.id = match.league_id GROUP BY league.name ORDER BY total_matches DESC LIMIT 1;
SELECT AVG(height)  FROM player  WHERE birthday >= '1990-01-01 00:00:00' AND birthday < '1996-01-01 00:00:00';
SELECT player_api_id FROM player_attributes WHERE substr(date,1,4) = '2010' AND overall_rating > (SELECT AVG(overall_rating) FROM player_attributes WHERE substr(date,1,4) = '2010')
SELECT team_fifa_api_id FROM team_attributes WHERE buildupplayspeed BETWEEN 51 AND 59
SELECT team.team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildUpPlayPassing > (SELECT AVG(buildUpPlayPassing) FROM team_attributes WHERE buildUpPlayPassing IS NOT NULL) AND strftime('%Y', team_attributes.date) = '2012'
SELECT 100.0 * (     SELECT COUNT(*)      FROM player_attributes      JOIN player ON player_attributes.player_api_id = player.player_api_id      WHERE preferred_foot = 'left'      AND birthday BETWEEN '1987-01-01 00:00:00' AND '1992-12-31 00:00:00' ) / (     SELECT COUNT(*)      FROM player_attributes      JOIN player ON player_attributes.player_api_id = player.player_api_id      WHERE birthday BETWEEN '1987-01-01 00:00:00' AND '1992-12-31 00:00:00' );
SELECT league.name, SUM(match.home_team_goal + match.away_team_goal) AS total_goals FROM league JOIN match ON league.id = match.league_id GROUP BY league.name ORDER BY total_goals ASC LIMIT 5;
SELECT AVG(long_shots)  FROM player_attributes  WHERE player_fifa_api_id = (SELECT player_fifa_api_id FROM player WHERE player_name = 'Ahmed Samir Farag');
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.height > 180 GROUP BY player.player_fifa_api_id ORDER BY AVG(player_attributes.heading_accuracy) DESC LIMIT 10;
SELECT team.team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildupplaydribblingclass = 'Normal' AND team_attributes.date >= '2014-01-01 00:00:00' AND team_attributes.date <= '2014-01-31 00:00:00' AND team_attributes.chancecreationpassing < (SELECT AVG(chancecreationpassing) FROM team_attributes) ORDER BY team_attributes.chancecreationpassing DESC;
SELECT league.name FROM league JOIN match ON league.id = match.league_id WHERE match.season = '2009/2010' GROUP BY league.name HAVING AVG(match.home_team_goal) > AVG(match.away_team_goal)
