SELECT COUNT(*)  FROM cards  WHERE borderColor = 'white' AND id IN (SELECT uuid FROM legalities WHERE status = 'Banned')
SELECT cards.uuid, foreign_data.language FROM cards JOIN legalities ON cards.uuid = legalities.uuid JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE legalities.format = 'legacy'
SELECT rulings.text FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.name = 'Beacon of Immortality'
SELECT COUNT(*) AS card_count, legalities.status FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.frameversion = 'future' GROUP BY legalities.status;
SELECT cards.name, cards.colors FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.code = 'OGW'
SELECT T1.Translation, T1.Language FROM set_translations AS T1 INNER JOIN cards AS T2 ON T1.SetCode = T2.SetCode WHERE T2.ConvertedManaCost = 5 AND T1.SetCode = '10E'
SELECT cards.name, rulings.date FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.originaltype = 'Creature - Elf'
SELECT cards.colors, legalities.format FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.id BETWEEN 1 AND 20
SELECT T1.name FROM cards AS T1 INNER JOIN set_translations AS T2 ON T1.uuid = T2.id WHERE T1.colors = 'B' AND T2.language = 'French'
SELECT T1.name FROM cards AS T1 INNER JOIN rulings AS T2 ON T1.uuid = T2.uuid WHERE T1.rarity = 'uncommon' ORDER BY T2.date ASC LIMIT 3
SELECT COUNT(DISTINCT cards.id) FROM cards WHERE cards.artist = 'John Avon' AND cards.cardkingdomid IS NULL AND cards.cardkingdomfoilid IS NULL;
SELECT COUNT(*)  FROM cards  WHERE bordercolor = 'white'  AND cardkingdomfoilid = cardkingdomid  AND cardkingdomid IS NOT NULL
SELECT COUNT(*)  FROM cards  WHERE artist = 'UDON'  AND availability = 'mtgo'  AND hand = -1
SELECT COUNT(*)  FROM cards  WHERE frameversion = '1993'  AND availability = 'paper'  AND hascontentwarning = 1;
SELECT cards.manacost FROM cards WHERE cards.layout = 'normal' AND cards.frameversion = '2003' AND cards.bordercolor = 'black' AND cards.availability IN ('paper', 'mtgo')
