SELECT MAX(frpm."percent (%) eligible free (k-12)")  FROM frpm  JOIN schools ON frpm.cdscode = schools.cdscode  WHERE schools.county = 'Alameda'
SELECT T1.`Percent (%) eligible free (ages 5-17)` FROM frpm AS T1 INNER JOIN schools AS T2 ON T1.CDSCode = T2.CDSCode WHERE T2.eilname = 'Continuation School' ORDER BY T1.`Percent (%) eligible free (ages 5-17)` LIMIT 3
SELECT zip FROM schools WHERE district = 'Fresno County Office of Education' AND charter = 1
SELECT T2.mailstreet, T2.mailstrabr, T2.mailcity, T2.mailzip, T2.mailstate FROM frpm AS T1 INNER JOIN schools AS T2 ON T1.CDSCode = T2.CDSCode WHERE T1.`FRPM Count (K-12)` = ( SELECT MAX(`FRPM Count (K-12)`) FROM frpm )
SELECT phone FROM schools WHERE charter = 1 AND openDate > '2000-01-01'
SELECT COUNT(T1.cdscode) FROM schools AS T1 INNER JOIN satscores AS T2 ON T1.CDSCode = T2.CDS WHERE T2.avgscrmath < 400 AND T1.virtual = 'Y'
SELECT schools.school FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.numtsttakr > 500 AND schools.magnet = 1
SELECT schools.phone FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.numtsttakr > 1500 ORDER BY satscores.numtsttakr DESC LIMIT 1;
SELECT satscores.numtsttakr FROM satscores JOIN frpm ON satscores.cds = frpm.cdscode ORDER BY frpm.enrollment_k_12 DESC LIMIT 1;
SELECT COUNT(T1.cdscode) FROM schools AS T1 INNER JOIN satscores AS T2 ON T1.CDSCode = T2.CDS WHERE T2.avgscrmath > 560 AND T1.fundingtype = 'Charter funded'
SELECT T2."frpm count (ages 5-17)" FROM satscores AS T1 INNER JOIN frpm AS T2 ON T1.CDS = T2.CDSCode WHERE T1.rtype = 'S' ORDER BY T1.avgscrread DESC LIMIT 1
SELECT cdscode FROM schools WHERE "enrollment (k-12)" + "enrollment (ages 5-17)" > 500
SELECT T2.`Percent (%) eligible free (ages 5-17)` FROM satscores AS T1 INNER JOIN frpm AS T2 ON T1.CDS = T2.CDSCode WHERE T1.`NumGE1500` > 0.3
SELECT schools.phone FROM schools JOIN satscores ON schools.cdscode = satscores.cds ORDER BY satscores.numge1500 / satscores.numtsttakr DESC LIMIT 3;
SELECT schools.ncesschool  FROM schools  ORDER BY schools.gsserved DESC  LIMIT 5;
SELECT schools.district FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.statustype = 'Active' ORDER BY satscores.avgscrread DESC LIMIT 1;
SELECT COUNT(*)  FROM schools  WHERE county = 'Alameda'  AND statustype = 'Merged'  AND cdscode IN (SELECT cdscode FROM satscores WHERE numtsttakr < 100)
SELECT schools.charternum FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE satscores.avgscrwrite = 499
SELECT COUNT(*)  FROM schools  WHERE county = 'Contra Costa'  AND fundingtype = 'Directly funded'  AND (     SELECT numtsttakr      FROM satscores      WHERE satscores.cds = schools.cdscode ) <= 250
SELECT T1.phone FROM schools AS T1 INNER JOIN satscores AS T2 ON T1.CDSCode = T2.CDS WHERE T2.avgscrmath = ( SELECT MAX(avgscrmath) FROM satscores )
SELECT COUNT(*) FROM frpm WHERE "County Name" = 'Amador' AND "Low Grade" = 9 AND "High Grade" = 12
SELECT COUNT(T1.cdscode)  FROM frpm AS T1  INNER JOIN schools AS T2 ON T1.cdscode = T2.cdscode  WHERE T2.county = 'Los Angeles'  AND T1."free meal count (k-12)" > 500  AND T1."free meal count (k-12)" < 700
SELECT satscores.sname FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE schools.county = 'Contra Costa' ORDER BY satscores.numtsttakr DESC LIMIT 1;
SELECT T1.school, T1.street FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T2.`Enrollment (K-12)` - T2.`Enrollment (ages 5-17)` > 30
SELECT T1.sname FROM satscores AS T1 INNER JOIN frpm AS T2 ON T1.CDS = T2.CDSCode WHERE T1.numge1500 >= 1500 AND T2.`Percent (%) eligible free (K-12)` > 0.1
SELECT T1.FundingType FROM schools AS T1 INNER JOIN satscores AS T2 ON T1.CDSCode = T2.CDS WHERE T1.County = 'Riverside' AND T2.avgscrmath > 400
SELECT T1.school, T1.street, T1.city, T1.state, T1.zip FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T1.county = 'Monterey' AND T2.`Free Meal Count (ages 5-17)` > 800
SELECT T1.avgscrwrite, T1.sname, T2.doc FROM satscores AS T1 INNER JOIN schools AS T2 ON T1.cds = T2.cdscode WHERE T2.opendate > '1991-01-01' OR T2.closeddate < '2000-01-01'
SELECT T1.school, T1.DOCTYPE  FROM schools AS T1  INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode  WHERE T1.fundingType = 'Locally funded'  AND T2.`enrollment (k-12)` - T2.`enrollment (ages 5-17)` > (      SELECT AVG(T2.`enrollment (k-12)` - T2.`enrollment (ages 5-17)`)      FROM frpm AS T2      INNER JOIN schools AS T1 ON T1.CDSCode = T2.CDSCode      WHERE T1.fundingType = 'Locally funded'  )
SELECT schools.opendate FROM schools WHERE schools.gsserved = 'K-12' ORDER BY schools.enroll12 DESC LIMIT 1;
SELECT schools.city  FROM schools ORDER BY schools.gsserved ASC LIMIT 5
SELECT frpm."school name", frpm."percent (%) eligible free (k-12)"  FROM frpm INNER JOIN schools ON frpm."cdscode" = schools."cdscode" WHERE schools."gsserved" = '1-12' -- Select schools with grades 1 through 12 ORDER BY frpm."enrollment (k-12)" DESC LIMIT 11, 1 -- Select the 10th and 11th schools with highest enrollment 
SELECT frpm."percent (%) eligible frpm (k-12)" FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools."gsoffered" = "K-12" AND schools."charter" = 1 ORDER BY frpm."free meal count (k-12)" DESC LIMIT 5
SELECT T1.website, T1.school FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T2.`Free Meal Count (ages 5-17)` BETWEEN 1900 AND 2000
SELECT schools.school, frpm.`percent (%) eligible free (ages 5-17)` FROM schools JOIN frpm ON schools.cdscode = frpm.cdscode WHERE schools.admfname1 = 'Kacey' AND schools.admlname1 = 'Gibson'
SELECT T1.admemail1  FROM schools AS T1  INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode  WHERE T1.charter = 1  ORDER BY T2."enrollment (k-12)" ASC  LIMIT 1
SELECT T1.admfname1, T1.admlname1 FROM schools AS T1 INNER JOIN satscores AS T2 ON T1.CDSCode = T2.CDS WHERE T2.numge1500 = ( SELECT MAX(numge1500) FROM satscores )
SELECT schools.street, schools.city, schools.zip, schools.state FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.numtsttakr > 0 ORDER BY satscores.numge1500 / satscores.numtsttakr ASC LIMIT 1;
SELECT schools.website FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.county = 'Los Angeles' AND satscores.numtsttakr BETWEEN 2000 AND 3000;
SELECT AVG(satscores.numtsttakr) FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE schools.opendate >= '1980-01-01' AND schools.opendate <= '1980-12-31' AND schools.county = 'Fresno'
SELECT schools.phone FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.district = 'Fresno Unified' ORDER BY satscores.avgscrread ASC LIMIT 1;
SELECT T1.school FROM schools AS T1 INNER JOIN satscores AS T2 ON T1.CDSCode = T2.CDS WHERE T1.virtual = 'P' ORDER BY T2.avgscrread DESC LIMIT 5
SELECT T2.eilname FROM satscores AS T1 INNER JOIN schools AS T2 ON T1.cds = T2.cdscode ORDER BY T1.avgscrmath DESC LIMIT 1
SELECT T2.avgscrmath, T1.county FROM schools AS T1 INNER JOIN satscores AS T2 ON T1.CDSCode = T2.CDS ORDER BY T2.avgscrread + T2.avgscrmath + T2.avgscrwrite LIMIT 1
SELECT satscores.avgscrwrite, schools.city FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE satscores.numge1500 = (SELECT MAX(numge1500) FROM satscores) ORDER BY satscores.numtsttakr DESC LIMIT 1;
SELECT schools.school, satscores.avgscrwrite FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.admfname1 = 'Ricci' AND schools.admlname1 = 'Ulrich'
SELECT schools.state, schools.doc, SUM(schools.gsserved) AS total_enrollees FROM schools WHERE schools.doc = 31 GROUP BY schools.state ORDER BY total_enrollees DESC;
SELECT COUNT(schools.school) / 12 FROM schools WHERE schools.county = 'Alameda' AND schools.doc = '52' AND schools.opendate LIKE '1980-%'
SELECT CAST(SUM(CASE WHEN T2.doctype = 'Unified School District' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN T2.doctype = 'Elementary School District' THEN 1 ELSE 0 END) FROM frpm AS T1 INNER JOIN schools AS T2 ON T1.CDSCode = T2.CDSCode WHERE T2.county = 'Orange' AND T2.statustype = 'Merged'
SELECT schools.county, schools.school, schools.closeddate FROM schools WHERE schools.statustype = 'Closed' GROUP BY schools.county ORDER BY COUNT(schools.school) DESC LIMIT 1;
SELECT schools.street FROM satscores JOIN schools ON satscores.cds = schools.cdscode ORDER BY satscores.avgscrmath DESC LIMIT 1 OFFSET 5;
SELECT T1.mailstreet, T1.school FROM schools AS T1 INNER JOIN satscores AS T2 ON T1.CDSCode = T2.CDS ORDER BY T2.avgscrread LIMIT 1
SELECT COUNT(*)  FROM schools  JOIN satscores ON schools.cdscode = satscores.cds  WHERE (satscores.avgscrread + satscores.avgscrmath + satscores.avgscrwrite) >= 1500  AND schools.mailcity = 'Lakeport'
SELECT COUNT(satscores.numtsttakr) FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE schools.mailcity = 'Fresno'
SELECT schools.school, schools.mailzip FROM schools WHERE schools.admfname2 = 'Avetik' AND schools.admlname2 = 'Atoian'
SELECT CAST(SUM(CASE WHEN county = 'Colusa' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN county = 'Humboldt' THEN 1 ELSE 0 END) FROM schools WHERE mailstate = 'CA'
SELECT COUNT(*)  FROM schools  WHERE state = 'CA' AND county = 'San Joaquin' AND statustype = 'Active'
SELECT schools.phone, schools.ext FROM satscores JOIN schools ON satscores.cds = schools.cdscode ORDER BY satscores.avgscrwrite DESC LIMIT 1 OFFSET 332;
SELECT schools.phone, schools.ext, schools.school FROM schools WHERE schools.zip = '95203-3704'
SELECT schools.website FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE (schools.admfname1 = 'Mike' AND schools.admlname1 = 'Larson') OR (schools.admfname1 = 'Dante' AND schools.admlname1 = 'Alvarez')
SELECT schools.website FROM schools WHERE schools.virtual = 'P' AND schools.charter = 1 AND schools.county = 'San Joaquin'
SELECT COUNT(*)  FROM schools  WHERE city = 'Hickman'  AND doc = '52'  AND charter = '1'
SELECT COUNT(*)  FROM schools  WHERE county = 'Los Angeles'  AND charter = 0  AND ("Free Meal Count (K-12)" * 100 / "Enrollment (K-12)") < 0.18
SELECT schools.school, schools.city, schools.admfname1 || ' ' || schools.admlname1 AS administrator1, schools.admfname2 || ' ' || schools.admlname2 AS administrator2, schools.admfname3 || ' ' || schools.admlname3 AS administrator3 FROM schools WHERE schools.charter = 1 AND schools.charternum = '00D2'
SELECT COUNT(*)  FROM schools  WHERE mailcity = 'Hickman' AND charternum = '00D4'
SELECT CAST(SUM(CASE WHEN fundingtype = 'Locally funded' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(cdscode) FROM schools WHERE county = 'Santa Clara'
SELECT COUNT(*)  FROM schools  WHERE opendate BETWEEN '2000-01-01' AND '2005-12-31'  AND county = 'Stanislaus'  AND fundingtype = 'Directly funded'
SELECT COUNT(*)  FROM schools  WHERE closeddate LIKE '1989%'  AND city = 'San Francisco'  AND doctype = 'Community College District'
SELECT T1.county FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T1.SOCTYPE = 'Youth Authority Facilities' AND T1.closedDate BETWEEN '1980-01-01' AND '1989-12-31' GROUP BY T1.county ORDER BY COUNT(T1.CDSCode) DESC LIMIT 1
SELECT ncesdist FROM schools WHERE soctype = 'State Special Schools'
SELECT COUNT(*)  FROM schools  WHERE county = 'Alpine'  AND statustype IN ('Active', 'Closed')  AND soctype = 'District Community Day Schools'
SELECT schools.district code FROM schools WHERE schools.city = 'Fresno' AND schools.magnet = 0;
SELECT SUM(T2.`enrollment (ages 5-17)`) FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDSCode = T2.CDSCode WHERE T1.school = 'California School for the Deaf-Fremont (State Special Schl)' AND T2.`academic year` = '2014-2015' AND T1.edopsname = 'State Special School'
SELECT frpm."free meal count (ages 5-17)" FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools."edopsname" = 'Youth Authority School' AND schools.mailstreet = 'PO Box 1040'
SELECT schools.gsoffered FROM schools WHERE schools.edopscode = 'SPECON' AND schools.ncesdist = '613360'
SELECT T1.`educational option type`, T2.school  FROM frpm AS T1  INNER JOIN schools AS T2  ON T1.cdscode = T2.cdscode  WHERE T1.`county code` = 37  AND T1.`nslp provision status` = 'Breakfast Provision 2'
SELECT schools.city FROM schools INNER JOIN frpm ON frpm.cdscode = schools.cdscode WHERE frpm.nslp_provision_status = 'Lunch Provision 2' AND frpm.low_grade = 9 AND frpm.high_grade = 12 AND schools.county = 'Merced' AND schools.eilcode = 'HS'
SELECT T2.school, T1.`Percent (%) Eligible FRPM (Ages 5-17)` FROM frpm AS T1 INNER JOIN schools AS T2 ON T1.CDSCode = T2.CDSCode WHERE T2.county = 'Los Angeles' AND T2.gsserved = 'K-9'
SELECT schools.gsoffered FROM schools WHERE schools.city = 'Adelanto' GROUP BY schools.gsoffered ORDER BY COUNT(*) DESC LIMIT 1;
SELECT county, COUNT(*) as num_schools FROM schools WHERE (county = 'San Diego' OR county = 'Santa Barbara') AND virtual = 'F' GROUP BY county ORDER BY num_schools DESC LIMIT 1;
SELECT school, latitude FROM schools ORDER BY latitude DESC LIMIT 1
SELECT schools.city, schools.eilname, schools.school FROM schools WHERE schools.state = 'CA' ORDER BY schools.latitude ASC LIMIT 1;
SELECT schools.gsoffered FROM schools WHERE schools.longitude = (SELECT MAX(schools.longitude) FROM schools)
SELECT count(DISTINCT schools.city) AS city_count, count(*) AS school_count FROM schools WHERE schools.gsoffered = 'K-8' AND schools.magnet = 1 AND schools.soc = 'Multiple Provision Types'
SELECT admfname1 , district FROM schools GROUP BY admfname1 ORDER BY COUNT ( * ) DESC LIMIT 2
SELECT T1.`Percent (%) Eligible Free (K-12)`, T2.district FROM frpm AS T1 INNER JOIN schools AS T2 ON T1.CDSCode = T2.CDSCode WHERE T2.admfname1 = 'Alusine'
SELECT T1.admlname1, T1.district, T1.county, T1.school FROM schools AS T1 INNER JOIN frpm AS T2 ON T1.CDscode = T2.CDscode WHERE T1.charternum = 40
SELECT schools.admemail1 FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode WHERE schools.county = 'San Bernardino' AND schools.district = 'San Bernardino City Unified' AND schools.opendate BETWEEN '2009-01-01' AND '2010-12-31' AND schools.soctype = 'Intermediate/Middle Schools (Public)' AND schools.doctype = 'Unified School District'
SELECT T1.admemail1, T1.school FROM schools AS T1 INNER JOIN satscores AS T2 ON T1.CDSCode = T2.CDS WHERE T2.numge1500 = ( SELECT MAX(numge1500) FROM satscores )
SELECT COUNT(T1.account_id) FROM account AS T1 INNER JOIN trans AS T2 ON T1.account_id = T2.account_id INNER JOIN district AS T3 ON T1.district_id = T3.district_id WHERE T3.a3 = 'east Bohemia'
SELECT COUNT(*)  FROM account  JOIN district ON account.district_id = district.district_id  WHERE district.a3 = 'Prague'
SELECT CASE     WHEN AVG(a12) > AVG(a13) THEN '1995'     ELSE '1996' END AS higher_percentage FROM district
SELECT COUNT(T1.district_id) FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T1.gender = 'F' AND T2.a11 BETWEEN 6000 AND 10000
SELECT COUNT(T1.client_id)  FROM client AS T1  INNER JOIN district AS T2 ON T1.district_id = T2.district_id  WHERE T1.gender = 'M'  AND T2.a3 = 'north Bohemia'  AND T1.client_id IN (      SELECT T1.client_id      FROM disp AS T4      INNER JOIN account AS T5 ON T4.account_id = T5.account_id      INNER JOIN loan AS T6 ON T5.account_id = T6.account_id      WHERE T4.client_id = T1.client_id      AND T6.amount / T6.duration > 8000  )
SELECT account.account_id, (SELECT AVG(T2.amount) FROM trans AS T2 INNER JOIN account AS T3 ON T2.account_id = T3.account_id WHERE T3.account_id = account.account_id) - (SELECT AVG(T2.amount) FROM trans AS T2 INNER JOIN account AS T3 ON T2.account_id = T3.account_id WHERE T3.account_id = account.account_id) AS gap  FROM account  INNER JOIN client ON account.account_id = client.client_id  WHERE client.gender = 'F'  ORDER BY client.birth_date DESC  LIMIT 1
SELECT account.account_id FROM account JOIN client ON account.district_id = client.district_id JOIN disp ON disp.account_id = account.account_id JOIN card ON card.disp_id = disp.disp_id GROUP BY account.account_id HAVING client.birth_date = (SELECT MIN(birth_date) FROM client) AND AVG(card.issued) = (SELECT MAX(A11) FROM district)
SELECT COUNT(*)  FROM account  JOIN disp ON account.account_id = disp.account_id  JOIN card ON disp.disp_id = card.disp_id  WHERE account.frequency = 'POPLATEK TYDNE' AND disp.type = 'OWNER'
SELECT T1.client_id FROM client AS T1 INNER JOIN disp AS T2 ON T1.client_id = T2.client_id INNER JOIN trans AS T3 ON T2.account_id = T3.account_id WHERE T2.type = 'DISPONENT' AND T3.operation = 'VYBER'
SELECT T1.account_id FROM account AS T1 INNER JOIN loan AS T2 ON T1.account_id = T2.account_id WHERE T2.date LIKE '1997%' ORDER BY T2.amount LIMIT 1
SELECT loan.account_id FROM loan JOIN account ON loan.account_id = account.account_id WHERE loan.duration > 12 AND account.date LIKE '1993-%' ORDER BY loan.amount DESC LIMIT 1;
SELECT COUNT(DISTINCT client.client_id) FROM client JOIN district ON client.district_id = district.district_id WHERE client.gender = 'F' AND client.birth_date < '1950-01-01' AND district.a2 = 'Slokolov'
SELECT account_id FROM account WHERE date = '1995-01-01'
SELECT account_id FROM account WHERE date < '1997-01-01' AND account_id IN (     SELECT account_id     FROM trans     WHERE amount > 3000 )
SELECT client.client_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id WHERE card.issued = '1994-03-03'
SELECT account.date FROM account JOIN trans ON account.account_id = trans.account_id WHERE trans.amount = 840 AND trans.date = '1998-10-14'
SELECT district_id FROM account WHERE account_id IN (     SELECT account_id     FROM loan     WHERE date = '1994-08-25' )
SELECT MAX(trans.amount) FROM trans JOIN card ON trans.account_id = card.disp_id WHERE card.issued = '1996-10-21'
SELECT T1.gender  FROM client AS T1  INNER JOIN disp AS T2 ON T1.client_id = T2.client_id  INNER JOIN account AS T3 ON T2.account_id = T3.account_id  INNER JOIN district AS T4 ON T3.district_id = T4.district_id  ORDER BY T4.a11 DESC, T1.birth_date DESC  LIMIT 1
SELECT T2.amount FROM loan AS T1 INNER JOIN trans AS T2 ON T1.account_id = T2.account_id ORDER BY T1.amount DESC LIMIT 1
SELECT COUNT(T1.client_id)  FROM client AS T1  INNER JOIN disp AS T2 ON T1.client_id = T2.client_id  INNER JOIN account AS T3 ON T3.account_id = T2.account_id  INNER JOIN district AS T4 ON T4.district_id = T3.district_id  WHERE T4.a2 = 'Jesenik' AND T1.gender = 'F'
SELECT disp.disp_id FROM trans JOIN disp ON trans.account_id = disp.account_id WHERE trans.amount = 5100 AND trans.date = '1998-09-02'
SELECT COUNT(account_id) FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Litomerice' AND account.date LIKE '1996-%'
SELECT district.a2  FROM client  INNER JOIN account ON client.client_id = account.client_id  INNER JOIN district ON account.district_id = district.district_id  WHERE client.gender = 'F' AND client.birth_date = '1976-01-29'
SELECT T1.birth_date FROM client AS T1 INNER JOIN disp AS T2 ON T1.client_id = T2.client_id INNER JOIN account AS T3 ON T2.account_id = T3.account_id INNER JOIN loan AS T4 ON T3.account_id = T4.account_id WHERE T4.amount = 98832 AND T4.date = '1996-01-03'
SELECT T1.account_id  FROM account AS T1  INNER JOIN client AS T2 ON T1.account_id = T2.client_id  INNER JOIN district AS T3 ON T2.district_id = T3.district_id  WHERE T3.a3 = 'Prague'  ORDER BY T1.date  LIMIT 1
SELECT CAST(SUM(CASE WHEN T1.gender = 'M' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.client_id) FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T2.a3 = 'south Bohemia' ORDER BY T2.a11 DESC LIMIT 1
SELECT CAST(SUM(T2.balance) - SUM(T1.balance) AS REAL) * 100 / SUM(T1.balance) FROM trans AS T1 INNER JOIN trans AS T2 ON T1.account_id = T2.account_id WHERE T1.date = '1993-03-22' AND T2.date = '1998-12-27'
SELECT CAST(SUM(CASE WHEN status = 'A' THEN amount ELSE 0 END) AS REAL) * 100 / SUM(amount) FROM loan
SELECT CAST(SUM(CASE WHEN T2.amount < 100000 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.account_id) FROM account AS T1 INNER JOIN loan AS T2 ON T1.account_id = T2.account_id WHERE T2.status = 'B'
SELECT account.account_id, district.a2, district.a3 FROM account JOIN card ON account.account_id = card.disp_id JOIN disp ON card.disp_id = disp.disp_id JOIN client ON disp.client_id = client.client_id JOIN district ON account.district_id = district.district_id WHERE account.frequency = 'POPLATEK MESICNE' AND card.issued > (SELECT MIN(date) FROM trans WHERE account_id = account.account_id) AND account.account_id = '1993'
SELECT account.account_id, account.frequency FROM account JOIN district ON account.district_id = district.district_id WHERE district.a3 = 'east Bohemia' AND account.date BETWEEN '1995-01-01' AND '2000-12-31'
SELECT account_id, date FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Prachatice'
SELECT district.a2, district.a3 FROM loan JOIN account ON loan.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE loan.loan_id = '4990'
SELECT account.account_id, district.a2, district.a3 FROM account JOIN district ON account.district_id = district.district_id JOIN loan ON account.account_id = loan.account_id WHERE loan.amount > 300000;
SELECT loan.loan_id, district.a3, district.a11 FROM loan JOIN account ON loan.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE loan.duration = 60
SELECT T1.a2, T1.a13 - T1.a12 FROM district AS T1 INNER JOIN account AS T2 ON T1.district_id = T2.district_id INNER JOIN loan AS T3 ON T2.account_id = T3.account_id WHERE T3.status = 'D' AND T3.date BETWEEN '1995-01-01' AND '1996-12-31'
SELECT CAST(SUM(CASE WHEN T2.a2 = 'Decin' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.account_id) FROM account AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T1.date LIKE '1993%'
SELECT account_id FROM account WHERE frequency = 'POPLATEK MESICNE'
SELECT district.a2 FROM client join district on client.district_id = district.district_id WHERE client.gender = 'F' GROUP BY district.a2 ORDER BY COUNT ( * ) DESC LIMIT 10
SELECT T2.a2 FROM account AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id INNER JOIN trans AS T3 ON T1.account_id = T3.account_id WHERE T3.type = 'VYDAJ' AND T3.date LIKE '1996-01%' ORDER BY T3.amount DESC LIMIT 10
SELECT COUNT(DISTINCT client.client_id) FROM client JOIN district ON client.district_id = district.district_id LEFT JOIN disp ON client.client_id = disp.client_id LEFT JOIN card ON disp.disp_id = card.disp_id WHERE district.a3 = 'South Bohemia' AND card.card_id IS NULL
SELECT district.a3 FROM district JOIN account ON account.district_id = district.district_id JOIN loan ON loan.account_id = account.account_id WHERE loan.status = 'C' GROUP BY district.a3 ORDER BY COUNT(*) DESC LIMIT 1;
SELECT AVG(amount)  FROM loan  WHERE account_id IN (     SELECT account_id      FROM client      WHERE gender = 'M' )
SELECT district.a2, district.a3 FROM district WHERE district.a13 = (     SELECT MAX(district.a13)     FROM district     WHERE district.a13 IS NOT NULL )
SELECT COUNT(account_id) FROM account WHERE district_id = (     SELECT district_id     FROM district     WHERE a16 = (         SELECT MAX(a16)         FROM district     ) )
SELECT COUNT(DISTINCT account.account_id) FROM account JOIN trans ON account.account_id = trans.account_id JOIN card ON account.account_id = card.disp_id WHERE trans.operation = 'VYBER KARTOU' AND account.frequency = 'POPLATEK MESICNE' AND trans.balance < 0;
SELECT COUNT(DISTINCT loan.account_id) FROM loan JOIN account ON loan.account_id = account.account_id WHERE loan.date BETWEEN '1995-01-01' AND '1997-12-31' AND loan.amount >= 250000 AND account.frequency = 'POPLATEK MESICNE' AND loan.status = 'A'
SELECT COUNT(T1.account_id) FROM account AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T2.district_id = '1'
SELECT COUNT(T1.client_id) FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T1.gender = 'M' AND T2.a15 = ( SELECT a15 FROM district ORDER BY a15 DESC LIMIT 1, 1 )
SELECT COUNT(T1.card_id) FROM card AS T1 INNER JOIN disp AS T2 ON T1.disp_id = T2.disp_id WHERE T2.type = 'DISPONENT'
SELECT COUNT(*)  FROM account  JOIN district ON account.district_id = district.district_id  WHERE district.a2 = 'Pisek'
SELECT district.a2 FROM district JOIN account ON account.district_id = district.district_id JOIN trans ON trans.account_id = account.account_id WHERE trans.amount > 10000 AND trans.date LIKE '1997-%'
SELECT T1.account_id FROM account AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id INNER JOIN `order` AS T3 ON T1.account_id = T3.account_id WHERE T2.a2 = 'Pisek' AND T3.k_symbol = 'SIPO'
SELECT a.account_id FROM account a JOIN disp d on d.account_id = a.account_id JOIN card c on c.disp_id = d.disp_id WHERE c.type = 'gold' AND a.account_id IN (     SELECT a.account_id     FROM account a     JOIN disp d on d.account_id = a.account_id     JOIN card c on c.disp_id = d.disp_id     WHERE c.type = 'junior' )
SELECT AVG(trans.amount) FROM trans JOIN account ON trans.account_id = account.account_id JOIN card ON account.account_id = card.disp_id WHERE trans.operation = 'VYBER KARTOU' AND strftime('%Y', trans.date) = '2021'
SELECT account.account_id FROM account JOIN disp ON account.account_id = disp.account_id JOIN card ON disp.disp_id = card.disp_id JOIN trans ON account.account_id = trans.account_id WHERE trans.operation = 'VYBER KARTOU' AND strftime('%Y', trans.date) = '1998' GROUP BY account.account_id HAVING SUM(trans.amount) < (SELECT AVG(trans.amount) FROM trans WHERE strftime('%Y', trans.date) = '1998')
SELECT client.client_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id JOIN card ON disp.disp_id = card.disp_id JOIN loan ON account.account_id = loan.account_id WHERE client.gender = 'F'
SELECT COUNT(T1.client_id)  FROM client AS T1  INNER JOIN disp AS T2 ON T1.client_id = T2.client_id  INNER JOIN account AS T3 ON T3.account_id = T2.account_id  INNER JOIN district AS T4 ON T4.district_id = T3.district_id  WHERE T1.gender = 'F' AND T4.a3 = 'south Bohemia'
SELECT account.account_id FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Tabor' AND account.account_id IN (     SELECT account_id     FROM disp     WHERE type = 'OWNER' )
SELECT T2.type FROM account AS T1 INNER JOIN disp AS T2 ON T1.account_id = T2.account_id INNER JOIN district AS T3 ON T3.district_id = T1.district_id WHERE T3.a11 BETWEEN 8000 AND 9000
SELECT COUNT(DISTINCT account.account_id) FROM account JOIN district ON account.district_id = district.district_id JOIN trans ON account.account_id = trans.account_id WHERE district.a3 = 'North Bohemia' AND trans.bank = 'AB'
SELECT district.a2 FROM district JOIN account ON account.district_id = district.district_id JOIN trans ON trans.account_id = account.account_id WHERE trans.type = 'VYDAJ'
SELECT AVG(district.a15) FROM district JOIN account ON account.district_id = district.district_id WHERE district.a15 > 4000 AND account.date >= '1997-01-01'
SELECT COUNT(*) FROM card WHERE type = 'classic'
SELECT COUNT(client.client_id) FROM client JOIN district ON client.district_id = district.district_id WHERE district.a2 = 'Hl.m. Praha' AND client.gender = 'M'
SELECT CAST(SUM(CASE WHEN issued < '1998-01-01' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM card WHERE type = 'gold'
SELECT client.client_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id JOIN loan ON account.account_id = loan.account_id WHERE loan.amount = (SELECT MAX(amount) FROM loan)
SELECT COUNT(a15)  FROM district  WHERE district_id = 532
SELECT T2.district_id FROM "order" AS T1 INNER JOIN account AS T2 ON T1.account_id = T2.account_id WHERE T1.order_id = 33333
SELECT trans_id, account_id, date, type, operation, amount, balance, k_symbol, bank, account FROM trans WHERE account_id IN (     SELECT account_id     FROM disp     WHERE client_id = 3356 ) AND operation = 'VYBER'
SELECT COUNT(account.account_id) FROM account JOIN loan ON account.account_id = loan.account_id WHERE account.frequency = 'POPLATEK TYDNE' AND loan.amount < 200000;
SELECT card.type FROM card JOIN disp ON card.disp_id = disp.disp_id JOIN client ON disp.client_id = client.client_id WHERE client.client_id = 13539;
SELECT district.a3 FROM client JOIN district ON client.district_id = district.district_id WHERE client.client_id = 3541;
SELECT district.a2 FROM district JOIN account ON account.district_id = district.district_id JOIN loan ON loan.account_id = account.account_id WHERE loan.status = 'A' GROUP BY district.a2 ORDER BY COUNT(*) DESC LIMIT 1;
SELECT client.client_id FROM client JOIN account ON client.district_id = account.district_id JOIN "order" ON account.account_id = "order".account_id WHERE "order".order_id = 32423;
SELECT trans.* FROM trans JOIN account ON trans.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE district.a4 = '5'
SELECT COUNT(*) FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Jesenik'
SELECT client.client_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id WHERE card.type = 'junior' AND card.issued >= '1997-01-01'
SELECT CAST(SUM(CASE WHEN T1.gender = 'F' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.client_id)  FROM client AS T1  INNER JOIN disp AS T2 ON T1.client_id = T2.client_id  INNER JOIN account AS T3 ON T3.account_id = T2.account_id  INNER JOIN district AS T4 ON T4.district_id = T3.district_id  WHERE T4.a11 > 10000
SELECT SUM(T2.amount) / SUM(T2.amount) - 1  FROM client AS T1  INNER JOIN loan AS T2 ON T1.client_id = T2.account_id  WHERE T1.gender = 'M'  AND T2.date BETWEEN '1996-01-01' AND '1997-12-31'
SELECT COUNT(*) FROM trans WHERE operation = 'VYBER KARTOU' AND date > '1995-01-01'
SELECT SUM(CASE WHEN district.a3 = 'north Bohemia' THEN district.a16 ELSE 0 END) - SUM(CASE WHEN district.a3 = 'east Bohemia' THEN district.a16 ELSE 0 END) AS difference FROM district WHERE district.a3 IN ('north Bohemia', 'east Bohemia')
SELECT COUNT(*)  FROM disp  WHERE account_id = 1 AND type IN ('OWNER', 'DISPONENT')
SELECT COUNT(*) FROM trans WHERE account_id = 3 AND operation = 'VYBER' AND k_symbol = 'VYBER'
SELECT birth_date FROM client WHERE client_id = 130
SELECT COUNT(*)  FROM account  JOIN disp ON account.account_id = disp.account_id  WHERE disp.type = 'OWNER' AND account.frequency = 'POPLATEK PO OBRATU'
SELECT loan.amount, loan.status FROM loan JOIN account ON loan.account_id = account.account_id JOIN client ON account.account_id = client.client_id WHERE client.client_id = 992;
SELECT SUM(trans.amount), client.gender FROM trans JOIN account ON trans.account_id = account.account_id JOIN disp ON disp.account_id = account.account_id JOIN client ON client.client_id = disp.client_id WHERE client.client_id = 4 AND trans.trans_id = 851
SELECT card.type FROM card JOIN disp ON card.disp_id = disp.disp_id JOIN client ON disp.client_id = client.client_id WHERE client.client_id = 9;
SELECT SUM(trans.amount)  FROM trans  JOIN account ON trans.account_id = account.account_id  JOIN client ON account.account_id = client.client_id  WHERE client.client_id = 617 AND trans.date LIKE '1998-%'
SELECT client.client_id FROM client JOIN district ON client.district_id = district.district_id WHERE client.birth_date BETWEEN '1983-01-01' AND '1987-12-31' AND district.a3 = 'east Bohemia'
SELECT client.client_id FROM client JOIN loan ON client.client_id = loan.account_id WHERE client.gender = 'F' ORDER BY loan.amount DESC LIMIT 3;
SELECT COUNT(T1.client_id) FROM client AS T1 INNER JOIN trans AS T2 ON T1.client_id = T2.account_id WHERE T1.gender = 'M' AND T1.birth_date BETWEEN '1974-01-01' AND '1976-12-31' AND T2.amount > 4000
SELECT COUNT(*)  FROM account  JOIN district ON account.district_id = district.district_id  WHERE district.a2 = 'Beroun' AND account.date > '1996-01-01'
SELECT COUNT(*)  FROM client  JOIN disp ON client.client_id = disp.client_id  JOIN card ON disp.disp_id = card.disp_id  WHERE client.gender = 'F' AND card.type = 'junior'
SELECT CAST(SUM(CASE WHEN gender = 'F' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(client_id) FROM client WHERE district_id = ( SELECT district_id FROM district WHERE a2 = 'Prague' )
SELECT CAST(SUM(CASE WHEN T1.gender = 'M' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.client_id) FROM client AS T1 INNER JOIN disp AS T2 ON T1.client_id = T2.client_id INNER JOIN account AS T3 ON T2.account_id = T3.account_id WHERE T3.frequency = 'POPLATEK TYDNE'
SELECT COUNT(T1.client_id) FROM client AS T1 INNER JOIN disp AS T2 ON T1.client_id = T2.client_id INNER JOIN account AS T3 ON T2.account_id = T3.account_id WHERE T3.frequency = 'POPLATEK TYDNE' AND T2.type = 'USER'
SELECT account.account_id FROM loan JOIN account ON loan.account_id = account.account_id WHERE loan.duration > 24 AND loan.amount = ( SELECT MIN(amount) FROM loan WHERE duration > 24 ) AND account.date < '1997-01-01'
SELECT account.account_id FROM account JOIN disp ON account.account_id = disp.account_id JOIN client ON disp.client_id = client.client_id JOIN district ON client.district_id = district.district_id WHERE client.gender = 'F' ORDER BY client.birth_date ASC, district.a11 ASC LIMIT 1
SELECT COUNT(client_id) FROM client JOIN district ON client.district_id = district.district_id WHERE birth_date LIKE '1920-%' AND a3 = 'east Bohemia'
SELECT COUNT(*)  FROM loan  JOIN account ON loan.account_id = account.account_id  WHERE loan.duration = 24 AND account.frequency = 'POPLATEK TYDNE'
SELECT AVG ( amount ) FROM loan WHERE status = 'C'
SELECT client.client_id, district.district_id FROM client JOIN district ON client.district_id = district.district_id WHERE client.client_id IN (     SELECT disp.client_id     FROM disp     JOIN account ON disp.account_id = account.account_id     WHERE disp.type = 'OWNER' )
SELECT client.client_id, (strftime('%Y', 'now') - strftime('%Y', client.birth_date)) AS age FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id WHERE card.type = 'gold'
SELECT bond_type FROM bond GROUP BY bond_type ORDER BY COUNT(bond_type) DESC LIMIT 1;
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '-' AND atom.element = 'cl'
SELECT AVG(element = 'o') FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '-'
SELECT COUNT(*) / (SELECT COUNT(*) FROM molecule WHERE label = '+') AS average FROM bond WHERE bond_type = '-' AND molecule_id IN (SELECT molecule_id FROM molecule WHERE label = '+')
SELECT COUNT(*) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'na' AND molecule.label = '-'
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '#' AND molecule.label = '+';
SELECT CAST(SUM(CASE WHEN T1.element = 'c' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.atom_id) FROM atom AS T1 INNER JOIN connected AS T2 ON T1.atom_id = T2.atom_id INNER JOIN bond AS T3 ON T3.bond_id = T2.bond_id WHERE T3.bond_type = '='
SELECT COUNT(*) FROM bond WHERE bond_type = '#';
SELECT COUNT(DISTINCT atom_id) FROM atom WHERE element != 'br'
SELECT COUNT(*)  FROM molecule  WHERE molecule_id BETWEEN 'TR000' AND 'TR099'  AND label = '+';
SELECT molecule.molecule_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'si'
SELECT atom.element FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE bond.bond_id = 'TR004_8_9'
SELECT atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '='
SELECT molecule.label FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'h' GROUP BY molecule.label ORDER BY COUNT(molecule.label) DESC LIMIT 1;
SELECT bond.bond_type FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element = 'te'
SELECT atom_id, atom_id2 FROM connected JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '-';
SELECT atom.atom_id, connected.atom_id2 FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '-'
SELECT element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '-' GROUP BY element ORDER BY COUNT(*) ASC LIMIT 1;
SELECT bond.bond_type FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id2 = atom.atom_id WHERE atom.atom_id = 'TR004_8' AND connected.atom_id = 'TR004_20'
SELECT DISTINCT molecule.label FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE atom.element != 'sn'
SELECT COUNT(DISTINCT atom.atom_id) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id WHERE (atom.element = 'i' OR atom.element = 's') AND bond.bond_type = '-';
SELECT connected.atom_id, connected.atom_id2 FROM connected JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '#'
SELECT atom.atom_id FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN molecule ON molecule.molecule_id = atom.molecule_id WHERE molecule.molecule_id = 'TR181'
SELECT CAST(SUM(CASE WHEN T2.element = 'f' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.molecule_id) FROM molecule AS T1 INNER JOIN atom AS T2 ON T1.molecule_id = T2.molecule_id WHERE T1.label = 'carcinogenic'
SELECT CAST(SUM(CASE WHEN T2.label = '+' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.molecule_id) FROM bond AS T1 INNER JOIN molecule AS T2 ON T1.molecule_id = T2.molecule_id WHERE T1.bond_type = '#'
SELECT element FROM atom WHERE molecule_id = 'TR000' ORDER BY element LIMIT 3;
SELECT atom.atom_id FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id JOIN molecule ON molecule.molecule_id = atom.molecule_id WHERE molecule.molecule_id = 'TR001' AND bond.bond_id = 'TR001_2_6'
SELECT SUM ( CASE WHEN label = '+' THEN 1 ELSE 0 END ) - SUM ( CASE WHEN label = '-' THEN 1 ELSE 0 END ) FROM molecule
SELECT atom_id FROM connected WHERE bond_id = 'TR_000_2_5'
SELECT connected.bond_id FROM connected WHERE connected.atom_id2 = 'TR000_2'
SELECT molecule.label FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = ' = ' ORDER BY molecule.label ASC LIMIT 5;
SELECT CAST(SUM(CASE WHEN bond_type = '=' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(bond_id) FROM bond WHERE molecule_id = 'TR008'
SELECT CAST(SUM(CASE WHEN label = '+' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(molecule_id) FROM molecule
SELECT CAST(SUM(CASE WHEN element = 'h' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(atom_id) FROM atom WHERE molecule_id = 'TR206'
SELECT bond.bond_type FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR000'
SELECT atom.element, molecule.label FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR060'
SELECT bond_type FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.label = '+' AND molecule.molecule_id = 'TR018' GROUP BY bond_type ORDER BY COUNT(*) DESC LIMIT 1;
SELECT molecule.label, molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id WHERE bond.bond_type = '-' AND molecule.label = '-' GROUP BY molecule.molecule_id ORDER BY molecule.molecule_id ASC LIMIT 3;
SELECT bond.bond_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR006' ORDER BY bond.bond_id LIMIT 2;
SELECT COUNT(*)  FROM bond  JOIN connected ON bond.bond_id = connected.bond_id  JOIN atom ON connected.atom_id = atom.atom_id OR connected.atom_id2 = atom.atom_id  JOIN molecule ON bond.molecule_id = molecule.molecule_id  WHERE molecule.molecule_id = 'TR009'  AND (atom.atom_id = 'TR009_12' OR connected.atom_id2 = 'TR009_12')
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+' AND atom.element = 'br'
SELECT bond.bond_type, connected.atom_id, connected.atom_id2 FROM bond JOIN connected ON bond.bond_id = connected.bond_id WHERE bond.bond_id = 'TR001_6_9'
SELECT molecule.label FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.atom_id = 'TR001_10'
SELECT COUNT(DISTINCT molecule_id) FROM bond WHERE bond_type = '#';
SELECT COUNT(*)  FROM connected  WHERE atom_id LIKE 'TR%_19' OR atom_id2 LIKE 'TR%_19'
SELECT atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR004'
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule WHERE molecule.label = '-'
SELECT molecule.molecule_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE SUBSTRING(atom.atom_id, 7, 2) BETWEEN '21' AND '25' AND molecule.label = '+'
SELECT bond.bond_id FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id JOIN atom AS atom2 ON connected.atom_id2 = atom2.atom_id WHERE atom.element = 'p' AND atom2.element = 'n'
SELECT T1.label FROM molecule AS T1 INNER JOIN bond AS T2 ON T1.molecule_id = T2.molecule_id WHERE T2.bond_type = '=' GROUP BY T1.label ORDER BY COUNT(T2.bond_type) DESC LIMIT 1
SELECT AVG(COUNT(bond_id))/COUNT(atom_id) FROM atom WHERE element = 'i'
SELECT bond.bond_type, bond.bond_id FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE SUBSTR(atom.atom_id, 7, 2) + 0 = 45
SELECT atom.element FROM atom WHERE atom.atom_id NOT IN (SELECT connected.atom_id FROM connected)
SELECT atom.atom_id FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id JOIN molecule ON molecule.molecule_id = atom.molecule_id WHERE molecule.molecule_id = 'TR447' AND bond.bond_type = '#';
SELECT atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR144_8_19'
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE molecule.label = '+' AND bond.bond_type = '=' GROUP BY molecule.molecule_id ORDER BY COUNT(*) DESC LIMIT 1;
SELECT element FROM atom WHERE molecule_id IN (     SELECT molecule_id     FROM molecule     WHERE label = '+' ) GROUP BY element ORDER BY COUNT(*) ASC LIMIT 1;
SELECT atom_id FROM atom WHERE atom_id IN (     SELECT atom_id2     FROM connected     WHERE atom_id IN (         SELECT atom_id         FROM atom         WHERE element = 'pb'     ) )
SELECT atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '#'
SELECT CAST(SUM(CASE WHEN T2.element = 'c' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.bond_id) FROM bond AS T1 INNER JOIN atom AS T2 ON T1.molecule_id = T2.molecule_id
SELECT CAST(SUM(CASE WHEN T2.bond_type = '=' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.molecule_id) FROM molecule AS T1 INNER JOIN bond AS T2 ON T1.molecule_id = T2.molecule_id
SELECT COUNT(DISTINCT atom.atom_id) FROM atom WHERE atom.element IN ('c', 'h')
SELECT connected.atom_id2 FROM atom JOIN connected ON connected.atom_id = atom.atom_id WHERE atom.element = 's'
SELECT bond.bond_type FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element = 'sn'
SELECT COUNT(DISTINCT atom.element) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '-';
SELECT COUNT(DISTINCT atom.atom_id) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '#' AND (atom.element = 'p' OR atom.element = 'br')
SELECT bond.bond_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.label = '+'
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '-' AND molecule.label = '-'
SELECT CAST(SUM(CASE WHEN T1.element = 'cl' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.atom_id) FROM atom AS T1 INNER JOIN connected AS T2 ON T1.atom_id = T2.atom_id INNER JOIN bond AS T3 ON T3.bond_id = T2.bond_id WHERE T3.bond_type = 'single'
SELECT molecule.label FROM molecule WHERE molecule.molecule_id IN ('TR000', 'TR001', 'TR002')
SELECT molecule_id FROM molecule WHERE label = '-'
SELECT COUNT(DISTINCT molecule.molecule_id) AS total_carcinogenic_molecules FROM molecule WHERE molecule.molecule_id BETWEEN 'TR000' AND 'TR030' AND molecule.label = '+';
SELECT bond.bond_type FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.molecule_id BETWEEN 'TR000' AND 'TR050'
SELECT atom.element FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE bond.bond_id = 'TR001_10_11'
SELECT COUNT(DISTINCT bond.bond_id) FROM bond JOIN atom ON bond.molecule_id = atom.molecule_id WHERE atom.element = 'i'
SELECT molecule.label FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'ca' GROUP BY molecule.label ORDER BY COUNT(*) DESC LIMIT 1;
SELECT COUNT(*)  FROM bond  JOIN connected ON bond.bond_id = connected.bond_id  JOIN atom ON connected.atom_id = atom.atom_id  WHERE bond.bond_id = 'TR001_1_8'  AND (atom.element = 'cl' OR atom.element = 'c')
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id JOIN atom ON molecule.molecule_id = atom.molecule_id JOIN connected ON bond.bond_id = connected.bond_id WHERE bond.bond_type = '#' AND atom.element = 'c' AND molecule.label = '-'
SELECT CAST(SUM(CASE WHEN T1.element = 'cl' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.molecule_id) FROM atom AS T1 INNER JOIN molecule AS T2 ON T1.molecule_id = T2.molecule_id WHERE T2.label = '+'
SELECT atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR001'
SELECT molecule_id FROM bond WHERE bond_type = '=';
SELECT atom_id, atom_id2 FROM connected JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '#'
SELECT atom.element FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE bond.bond_id = 'TR005_16_26'
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '-' AND molecule.label = '-'
SELECT molecule.label FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_id = 'TR001_10_11'
SELECT bond.bond_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '#' AND molecule.label = '+';
SELECT atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+' AND substr(atom.atom_id, 7, 1) = '4'
SELECT CAST(SUM(CASE WHEN T1.element = 'h' THEN 1 ELSE 0 END) AS REAL) / COUNT(T1.atom_id), T2.label FROM atom AS T1 INNER JOIN molecule AS T2 ON T1.molecule_id = T2.molecule_id WHERE T2.molecule_id = 'TR006'
SELECT m.label FROM atom a JOIN molecule m ON a.molecule_id = m.molecule_id WHERE a.element = 'ca'
SELECT bond.bond_type FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element = 'te'
SELECT atom.element FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE bond.bond_id = 'TR001_10_11'
SELECT CAST(SUM(CASE WHEN bond_type = '=' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(bond_id) FROM bond
SELECT CAST(SUM(CASE WHEN bond_type = '=' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(bond_id) FROM bond WHERE molecule_id = 'TR047'
SELECT m.label FROM atom a JOIN molecule m ON a.molecule_id = m.molecule_id WHERE a.atom_id = 'TR001_1'
SELECT molecule.label FROM molecule WHERE molecule.molecule_id = 'TR151'
SELECT element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = 'TR151'
SELECT COUNT(DISTINCT molecule_id) FROM molecule WHERE label = '+';
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'c' AND substr(molecule.molecule_id, 3, 3) > 10 AND substr(molecule.molecule_id, 3, 3) < 50;
SELECT COUNT(atom.atom_id) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+';
SELECT bond.bond_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '=' AND molecule.label = '+';
SELECT COUNT(atom.atom_id) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'h' AND molecule.label = '+';
SELECT molecule.molecule_id FROM molecule JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.bond_id = bond.bond_id JOIN atom ON atom.atom_id = connected.atom_id WHERE bond.bond_id = 'TR00_1_2' AND atom.atom_id = 'TR00_1'
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'c' AND molecule.label = '-'
SELECT CAST(SUM(CASE WHEN T1.element = 'h' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.molecule_id) FROM atom AS T1 INNER JOIN molecule AS T2 ON T1.molecule_id = T2.molecule_id WHERE T2.label = '+'
SELECT m.label FROM molecule m WHERE m.molecule_id = 'TR124'
SELECT atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR186'
SELECT bond_type FROM bond WHERE bond_id = 'TR007_4_19'
SELECT atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR001_2_4'
SELECT COUNT(*)  FROM bond  WHERE molecule_id = 'TR006' AND bond_type = '=';
SELECT molecule.molecule_id, atom.element FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+'
SELECT bond.bond_id, atom.atom_id, connected.atom_id2 FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id WHERE bond.bond_type = '-';
SELECT molecule.molecule_id, atom.element FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '#';
SELECT atom.element FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE bond.bond_id = 'TR000_2_3'
SELECT COUNT(*)  FROM bond  JOIN connected ON bond.bond_id = connected.bond_id  JOIN atom ON connected.atom_id = atom.atom_id  WHERE atom.element = 'cl'
SELECT atom.atom_id, COUNT(DISTINCT bond.bond_type) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR346' GROUP BY atom.atom_id;
SELECT COUNT(DISTINCT molecule.molecule_id) FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '=' AND molecule.label = '+';
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule LEFT JOIN atom ON atom.molecule_id = molecule.molecule_id LEFT JOIN bond ON bond.molecule_id = molecule.molecule_id LEFT JOIN connected ON connected.atom_id = atom.atom_id WHERE atom.element != 's' AND bond.bond_type != '=';
SELECT molecule.label FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_id = 'TR001_2_4'
SELECT COUNT(*) FROM atom WHERE molecule_id = 'TR005';
SELECT COUNT(*) FROM bond WHERE bond_type = '-';
SELECT molecule.molecule_id FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'cl' AND molecule.label = '+';
SELECT molecule.molecule_id FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'c' AND molecule.label = '-'
SELECT CAST(SUM(CASE WHEN T1.element = 'Cl' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.molecule_id) FROM atom AS T1 INNER JOIN molecule AS T2 ON T1.molecule_id = T2.molecule_id WHERE T2.label = 'carcinogenic'
SELECT molecule_id FROM bond WHERE bond_id = 'TR001_1_7'
SELECT COUNT(DISTINCT element) FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR001_3_4'
SELECT bond.bond_type FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id JOIN atom AS atom2 ON connected.atom_id2 = atom2.atom_id WHERE atom.atom_id = 'TR000_1' AND atom2.atom_id = 'TR000_2'
SELECT molecule.label FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.atom_id = "TR000_2" OR atom.atom_id = "TR000_4"
SELECT atom.element FROM atom WHERE atom.atom_id = 'TR000_1'
SELECT m.label FROM molecule m WHERE m.molecule_id = 'TR000'
SELECT CAST(SUM(CASE WHEN bond_type = 'single' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(bond_id) FROM bond
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'n' AND molecule.label = '+';
SELECT molecule.molecule_id FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON bond.bond_id = connected.bond_id WHERE atom.element = 's' AND bond.bond_type = '=';
SELECT molecule.molecule_id FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id GROUP BY molecule.molecule_id HAVING COUNT(atom.atom_id) > 5 AND molecule.label = '-'
SELECT atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id WHERE molecule.label = 'TR024' AND bond.bond_type = '=';
SELECT molecule.molecule_id FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+' GROUP BY molecule.molecule_id ORDER BY COUNT(atom.molecule_id) DESC LIMIT 1;
SELECT CAST(SUM(CASE WHEN T1.label = '+' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.molecule_id) FROM molecule AS T1 INNER JOIN atom AS T2 ON T1.molecule_id = T2.molecule_id INNER JOIN bond AS T3 ON T1.molecule_id = T3.molecule_id WHERE T2.element = 'h' AND T3.bond_type = '#'
SELECT COUNT(DISTINCT molecule_id) FROM molecule WHERE label = '+';
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN bond ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '-' AND molecule.molecule_id BETWEEN 'TR004' AND 'TR010';
SELECT COUNT(*)  FROM atom  WHERE molecule_id = 'TR008' AND element = 'c'
SELECT atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.atom_id = 'TR004_7' AND molecule.label = '-'
SELECT COUNT(DISTINCT molecule.molecule_id)  FROM bond  JOIN atom ON bond.molecule_id = atom.molecule_id  JOIN connected ON connected.bond_id = bond.bond_id  JOIN molecule ON molecule.molecule_id = atom.molecule_id  WHERE bond.bond_type = '='  AND atom.element = 'o'
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '#' AND molecule.label = '-'
SELECT atom.element, bond.bond_type FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR016'
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id WHERE molecule.label = 'TR012' AND atom.element = 'c' AND bond.bond_type = '=';
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+' AND atom.element = 'o'
SELECT cards.name FROM cards WHERE cards.cardkingdomfoilid = cards.cardkingdomid AND cards.cardkingdomid IS NOT NULL
SELECT cards.name FROM cards WHERE cards.bordercolor = 'borderless' AND cards.cardkingdomfoilid IS NULL AND cards.cardkingdomid IS NULL;
SELECT name FROM cards WHERE faceConvertedManaCost > convertedManaCost
SELECT cards.name FROM cards WHERE cards.frameversion = '2015' AND cards.edhrecrank < 100
SELECT cards.name FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.rarity = 'mythic' AND legalities.format = 'gladiator' AND legalities.status = 'Banned'
SELECT legalities.status FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.types = 'Artifact' AND cards.side IS NULL AND legalities.format = 'vintage'
SELECT cards.id, cards.artist FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.power = '*' OR cards.power IS NULL AND legalities.format = 'commander' AND legalities.status = 'Legal'
SELECT cards.name, rulings.text FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.artist = 'Stephen Daniele'
SELECT rulings.text FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.name = 'Sublime Epiphany' AND cards.number = '74s'
SELECT T1.name, T1.artist, T1.ispromo  FROM cards AS T1  INNER JOIN rulings AS T2 ON T1.uuid = T2.uuid  GROUP BY T1.name, T1.artist, T1.ispromo  ORDER BY COUNT(T2.uuid) DESC  LIMIT 1
SELECT foreign_data.language FROM foreign_data JOIN cards ON foreign_data.uuid = cards.uuid WHERE cards.name = 'Annul' AND cards.number = '29'
SELECT cards.name FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Japanese'
SELECT CAST(COUNT(T2.id) AS REAL) * 100 / COUNT(T1.id) FROM cards AS T1 INNER JOIN foreign_data AS T2 ON T1.uuid = T2.uuid WHERE T2.language = 'Chinese Simplified'
SELECT sets.name, sets.totalsetsize FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language = 'Italian'
SELECT COUNT(DISTINCT cards.type)  FROM cards  WHERE cards.artist = 'Aaron Boyd'
SELECT keywords FROM cards WHERE name = 'Angel of Mercy'
SELECT COUNT(*) FROM cards WHERE power = '*';
SELECT promotypes FROM cards WHERE name = 'Duress'
SELECT cards.bordercolor FROM cards WHERE cards.name = "Ancestor's Chosen"
SELECT cards.originaltype FROM cards WHERE cards.name = "Ancestor's Chosen"
SELECT foreign_data.language FROM foreign_data JOIN sets ON foreign_data.uuid = sets.id JOIN cards ON cards.setcode = sets.code WHERE cards.name = 'Angel of Mercy'
SELECT COUNT(*)  FROM cards  JOIN legalities ON cards.uuid = legalities.uuid  WHERE legalities.status = 'restricted' AND cards.istextless = 0;
SELECT rulings.text FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.name = "Condemn"
SELECT COUNT(*)  FROM cards  JOIN legalities ON cards.uuid = legalities.uuid  WHERE legalities.status = 'restricted'  AND cards.isstarter = 1
SELECT legalities.status FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.name = "Cloudchaser Eagle"
SELECT cards.type FROM cards WHERE cards.name = 'Benalish Knight'
SELECT T2.Status FROM cards AS T1 INNER JOIN legalities AS T2 ON T1.uuid = T2.uuid WHERE T1.name = 'Benalish Knight'
SELECT cards.artist FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Phyrexian'
SELECT CAST(SUM(CASE WHEN bordercolor = 'borderless' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(id) FROM cards
SELECT COUNT(*)  FROM cards  JOIN foreign_data ON cards.uuid = foreign_data.uuid  WHERE foreign_data.language = 'German' AND cards.isreprint = 1
SELECT COUNT(*)  FROM cards  JOIN foreign_data ON cards.uuid = foreign_data.uuid  WHERE bordercolor = 'borderless' AND language = 'Russian'
SELECT CAST(COUNT(CASE WHEN T2.language = 'French' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T1.id) FROM cards AS T1 INNER JOIN foreign_data AS T2 ON T1.uuid = T2.uuid WHERE T1.isStorySpotlight = 1
SELECT COUNT(*) FROM cards WHERE toughness = 99;
SELECT cards.name FROM cards WHERE cards.artist = 'Aaron Boyd'
SELECT COUNT(*)  FROM cards  WHERE bordercolor = 'black' AND availability = 'mtgo'
SELECT cards.id FROM cards WHERE cards.convertedmanacost = 0;
SELECT cards.layout FROM cards WHERE cards.keywords LIKE '%Flying%'
SELECT COUNT(*)  FROM cards  WHERE originaltype = 'Summon - Angel'  AND subtypes != 'Angel';
SELECT cards.id FROM cards WHERE cards.cardkingdomfoilid IS NOT NULL AND cards.cardkingdomid IS NOT NULL
SELECT cards.id FROM cards WHERE cards.dueldeck = 'a'
SELECT cards.edhrecrank FROM cards WHERE cards.frameversion = '2015'
SELECT cards.artist FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Chinese Simplified'
SELECT cards.name FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.availability = 'paper' AND foreign_data.language = 'Japanese'
SELECT COUNT(*)  FROM cards  WHERE borderColor = 'white' AND id IN (SELECT uuid FROM legalities WHERE status = 'Banned')
SELECT cards.uuid, foreign_data.language FROM cards JOIN legalities ON cards.uuid = legalities.uuid JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE legalities.format = 'legacy'
SELECT rulings.text FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.name = 'Beacon of Immortality'
SELECT COUNT(*) AS card_count, legalities.status FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.frameversion = 'future' GROUP BY legalities.status;
SELECT cards.name, cards.colors FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.code = 'OGW'
SELECT T1.Translation, T1.Language FROM set_translations AS T1 INNER JOIN cards AS T2 ON T1.SetCode = T2.SetCode WHERE T2.ConvertedManaCost = 5 AND T1.SetCode = '10E'
SELECT cards.name, rulings.date FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.originaltype = 'Creature - Elf'
SELECT cards.colors, legalities.format FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.id BETWEEN 1 AND 20
SELECT T1.name FROM cards AS T1 INNER JOIN set_translations AS T2 ON T1.uuid = T2.id WHERE T1.colors = 'B' AND T2.language = 'French'
SELECT T1.name FROM cards AS T1 INNER JOIN rulings AS T2 ON T1.uuid = T2.uuid WHERE T1.rarity = 'uncommon' ORDER BY T2.date ASC LIMIT 3
SELECT COUNT(DISTINCT cards.id) FROM cards WHERE cards.artist = 'John Avon' AND cards.cardkingdomid IS NULL AND cards.cardkingdomfoilid IS NULL;
SELECT COUNT(*)  FROM cards  WHERE bordercolor = 'white'  AND cardkingdomfoilid = cardkingdomid  AND cardkingdomid IS NOT NULL
SELECT COUNT(*)  FROM cards  WHERE artist = 'UDON'  AND availability = 'mtgo'  AND hand = -1
SELECT COUNT(*)  FROM cards  WHERE frameversion = '1993'  AND availability = 'paper'  AND hascontentwarning = 1;
SELECT cards.manacost FROM cards WHERE cards.layout = 'normal' AND cards.frameversion = '2003' AND cards.bordercolor = 'black' AND cards.availability IN ('paper', 'mtgo')
SELECT SUM(cards.convertedmanacost)  FROM cards  WHERE cards.artist = 'Rob Alexander'
SELECT DISTINCT types FROM cards WHERE availability = 'arena'
SELECT sets.code FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE set_translations.language = 'Spanish'
SELECT CAST(SUM(CASE WHEN T1.hand = 3 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM cards AS T1 INNER JOIN rulings AS T2 ON T1.uuid = T2.uuid WHERE T1.frameEffects = 'legendary'
SELECT CAST(SUM(CASE WHEN T1.text = '' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM cards AS T1 INNER JOIN legalities AS T2 ON T1.uuid = T2.uuid WHERE T1.isstoryspotlight = 1
SELECT CAST(COUNT(T2.id) AS REAL) * 100 / ( SELECT COUNT(id) FROM cards ) FROM foreign_data AS T1 INNER JOIN cards AS T2 ON T1.uuid = T2.uuid WHERE T1.language = 'Spanish'
SELECT set_translations.language FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.basesetsize = 309
SELECT COUNT(*)  FROM set_translations  JOIN sets ON set_translations.setcode = sets.code  WHERE sets.block = 'Commander'  AND set_translations.language = 'Portuguese (Brazil)';
SELECT cards.id FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.types LIKE '%Creature%' AND legalities.status = 'Legal'
SELECT DISTINCT T2.type FROM cards AS T1 INNER JOIN foreign_data AS T2 ON T1.uuid = T2.uuid WHERE T2.language = 'German'
SELECT COUNT(*)  FROM cards  WHERE power IS NULL  AND originaltext LIKE '%triggered ability%';
SELECT COUNT(*)  FROM cards  JOIN legalities ON cards.uuid = legalities.uuid  JOIN rulings ON cards.uuid = rulings.uuid  WHERE legalities.format = 'pre-modern'  AND rulings.text = 'This is a triggered mana ability'  AND cards.side IS NULL
SELECT cards.id FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.artist = 'Erica Yang' AND legalities.format = 'pauper' AND cards.availability = 'paper'
SELECT cards.artist FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.flavortext = "Das perfekte Gegenmittel zu einer dichten Formation"
SELECT foreign_data.name FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.artist = 'Matthew D. Wilson' AND cards.layout = 'normal' AND cards.bordercolor = 'black' AND foreign_data.language = 'French'
SELECT COUNT(*)  FROM cards  JOIN rulings ON cards.uuid = rulings.uuid  WHERE cards.rarity = 'rare'  AND rulings.date = '2009-01-10'
SELECT set_translations.language FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.block = 'Ravnica' AND sets.basesetsize = 180
SELECT CAST(SUM(CASE WHEN T2.hasContentWarning = 0 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.id) FROM legalities AS T1 INNER JOIN cards AS T2 ON T1.uuid = T2.uuid WHERE T1.format = 'commander'
SELECT CAST(COUNT(CASE WHEN T2.language = 'French' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T1.power) FROM cards AS T1 INNER JOIN foreign_data AS T2 ON T1.uuid = T2.uuid WHERE T1.power = 0
SELECT CAST(SUM(CASE WHEN T2.type = 'expansion' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM set_translations AS T1 INNER JOIN sets AS T2 ON T1.setcode = T2.code WHERE T1.language = 'Japanese'
SELECT cards.availability FROM cards WHERE cards.artist = 'Daren Bader'
SELECT COUNT(*)  FROM cards  WHERE borderColor = 'borderless' AND edhrecRank > 12000
SELECT COUNT(*) FROM cards WHERE isoversized = 1 AND isreprint = 1 AND ispromo = 1;
SELECT cards.name FROM cards JOIN sets ON cards.setcode = sets.code WHERE (cards.power IS NULL OR cards.power = '*') AND cards.promotypes LIKE '%arenaleague%' ORDER BY cards.name ASC LIMIT 3;
SELECT foreign_data.language FROM foreign_data WHERE foreign_data.multiverseid = 149934;
SELECT T1.id, T2.id FROM cards AS T1 INNER JOIN cards AS T2 ON T1.cardkingdomfoilid = T2.cardkingdomfoilid ORDER BY T1.cardkingdomfoilid LIMIT 3
SELECT CAST(SUM(CASE WHEN layout = 'normal' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(id) FROM cards
SELECT cards.number FROM cards WHERE cards.side IS NULL AND cards.subtypes LIKE '%Angel%' AND cards.subtypes LIKE '%Wizard%'
SELECT sets.name FROM sets WHERE sets.mtgoCode IS NULL OR sets.mtgoCode = '' ORDER BY sets.name ASC LIMIT 3;
SELECT foreign_data.language FROM foreign_data JOIN sets ON foreign_data.uuid = sets.id WHERE sets.mcmname = 'Archenemy' AND sets.code = 'ARC'
SELECT sets.name, set_translations.translation FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.id = 5;
SELECT set_translations.language, sets.type FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.id = 206;
SELECT sets.id, sets.name FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language = 'Italian' AND sets.block = 'Shadowmoor' ORDER BY sets.name ASC LIMIT 2;
SELECT sets.id FROM sets WHERE sets.isforeignonly = 1 AND sets.isfoilonly = 1 AND sets.id IN (     SELECT set_translations.id     FROM set_translations     WHERE set_translations.language = 'Japanese' )
SELECT T1.Translation FROM set_translations AS T1 INNER JOIN sets AS T2 ON T1.SetCode = T2.Code WHERE T1.Language = 'Russian' ORDER BY T2.TotalSetSize DESC LIMIT 1
SELECT CAST(SUM(CASE WHEN T2.language = 'Chinese Simplified' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.uuid) FROM cards AS T1 INNER JOIN foreign_data AS T2 ON T1.uuid = T2.uuid WHERE T1.isonlineonly = 1
SELECT COUNT(DISTINCT sets.id)  FROM sets  LEFT JOIN set_translations ON sets.code = set_translations.setcode  WHERE set_translations.language = 'Japanese'  AND (sets.mtgoCode IS NULL OR sets.mtgoCode = '')
SELECT cards.id FROM cards WHERE cards.bordercolor = 'black'
SELECT COUNT(id) FROM cards WHERE frameeffects = 'extendedart'
SELECT cards.name FROM cards WHERE cards.bordercolor = 'black' AND cards.isfullart = 1;
SELECT language FROM set_translations WHERE setcode = "174"
SELECT sets.name FROM sets WHERE sets.code = "ALL"
SELECT foreign_data.language FROM foreign_data JOIN cards ON foreign_data.uuid = cards.uuid WHERE cards.name = 'A Pedra Fellwar'
SELECT sets.code FROM sets WHERE sets.releasedate = '2007-07-13'
SELECT sets.basesetsize, sets.code FROM sets WHERE sets.block = "Masques" AND sets.name = "Mirage"
SELECT sets.code FROM sets WHERE sets.type = 'expansion'
SELECT foreign_data.name, cards.type FROM cards JOIN foreign_data ON foreign_data.uuid = cards.uuid WHERE cards.watermark = 'boros'
SELECT foreign_data.language, foreign_data.flavortext, cards.type FROM cards JOIN foreign_data ON foreign_data.uuid = cards.uuid WHERE cards.watermark = 'colorpie'
SELECT CAST(SUM(CASE WHEN T1.convertedManaCost = 10 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.name) FROM cards AS T1 INNER JOIN set_translations AS T2 ON T1.uuid = T2.id WHERE T1.name = 'Abyssal Horror'
SELECT sets.code FROM sets WHERE sets.type = 'expansion' AND sets.block = 'Commander'
SELECT foreign_data.name, cards.type FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.watermark = 'abzan'
SELECT T1.language, T1.type FROM foreign_data AS T1 INNER JOIN cards AS T2 ON T1.uuid = T2.uuid WHERE T2.watermark = 'azorius'
SELECT COUNT(*)  FROM cards  WHERE artist = 'Aaron Miller'  AND cardkingdomfoilid = cardkingdomid  AND cardkingdomid IS NOT NULL
SELECT COUNT(*)  FROM cards  WHERE availability LIKE '%paper%'  AND hand LIKE '+%';
SELECT cards.name FROM cards WHERE cards.istextless = 0;
SELECT convertedmanacost FROM cards WHERE name = 'Ancestor`s Chosen'
SELECT COUNT(*)  FROM cards  WHERE bordercolor = 'white'  AND (power = '*' OR power IS NULL)
SELECT cards.name FROM cards WHERE cards.ispromo = 1 AND cards.side IS NOT NULL
SELECT types FROM cards WHERE name = 'Molimo, Maro-Sorcerer'
SELECT purchaseurls FROM cards WHERE promotypes = 'bundle'
SELECT COUNT(DISTINCT artist)  FROM cards  WHERE bordercolor = 'black'  AND availability LIKE '%arena,mtgo%'
SELECT CASE      WHEN (SELECT convertedmanacost FROM cards WHERE name = 'Serra Angel') > (SELECT convertedmanacost FROM cards WHERE name = 'Shrine Keeper') THEN 'Serra Angel'     ELSE 'Shrine Keeper' END;
SELECT cards.artist FROM cards WHERE cards.flavorname = 'Battra, Dark Destroyer'
SELECT cards.name FROM cards WHERE cards.frameversion = '2003' ORDER BY cards.convertedmanacost DESC LIMIT 3;
SELECT set_translations.translation FROM set_translations JOIN sets ON set_translations.setcode = sets.code JOIN cards ON set_translations.setcode = cards.setcode WHERE cards.name = "Ancestor's Chosen" AND set_translations.language = 'Italian'
SELECT COUNT(*)  FROM set_translations  WHERE setcode IN (     SELECT code      FROM sets      WHERE id IN (         SELECT id          FROM cards          WHERE name = 'Angel of Mercy'     ) )
SELECT cards.name FROM cards JOIN set_translations ON cards.setcode = set_translations.setcode WHERE set_translations.translation = 'Hauptset Zehnte Edition'
SELECT T2.translation FROM cards AS T1 INNER JOIN set_translations AS T2 ON T1.uuid = T2.id WHERE T1.name = 'Ancestor''s Chosen' AND T2.language = 'Korean'
SELECT COUNT(*)  FROM cards  JOIN set_translations ON cards.setcode = set_translations.setcode  WHERE set_translations.translation = 'Hauptset Zehnte Edition'  AND cards.artist = 'Adam Rex'
SELECT COUNT(*)  FROM cards  JOIN set_translations ON cards.setcode = set_translations.setcode  JOIN sets ON sets.code = cards.setcode  WHERE set_translations.translation = 'Hauptset Zehnte Edition'
SELECT set_translations.translation FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.name = 'Eighth Edition' AND set_translations.language = 'Chinese Simplified';
SELECT COUNT(*) FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.name = 'Angel of Mercy' AND sets.mtgoCode IS NOT NULL
SELECT sets.releasedate FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.name = "Ancestor's Chosen"
SELECT sets.type FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Hauptset Zehnte Edition'
SELECT COUNT(*)  FROM sets  JOIN set_translations ON sets.code = set_translations.setcode  WHERE sets.block = 'Ice Age'  AND set_translations.language = 'Italian'
SELECT T2.IsForeignOnly FROM cards AS T1 INNER JOIN sets AS T2 ON T1.setcode = T2.code WHERE T1.name = 'Adarkar Valkyrie'
SELECT COUNT(DISTINCT sets.id) FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language = 'Italian' AND sets.basesetsize < 10;
SELECT COUNT(*)  FROM cards  JOIN sets ON cards.setcode = sets.code  WHERE sets.name = 'Coldsnap'  AND cards.bordercolor = 'black'
SELECT cards.name FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.name = 'Coldsnap' ORDER BY cards.convertedmanacost DESC;
SELECT artist FROM cards WHERE name = 'Coldsnap' AND artist IN ('Jeremy Jarvis', 'Aaron Miller', 'Chippy');
SELECT * FROM cards WHERE number = 4 AND setcode = 'Coldsnap'
SELECT COUNT(*)  FROM cards  JOIN sets ON cards.setcode = sets.code  WHERE sets.name = 'Coldsnap'  AND (cards.power = '*' OR cards.power IS NULL)  AND cards.convertedmanacost > 5
SELECT foreign_data.flavortext FROM foreign_data JOIN cards ON foreign_data.uuid = cards.uuid WHERE cards.name = 'Ancestor''s Chosen' AND foreign_data.language = 'Italian'
SELECT foreign_data.language FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.name = 'Ancestor''s Chosen' AND foreign_data.flavortext IS NOT NULL
SELECT foreign_data.type FROM foreign_data JOIN cards ON foreign_data.uuid = cards.uuid WHERE foreign_data.language = 'German' AND cards.name = 'Ancestor''s Chosen'
SELECT foreign_data.text FROM cards JOIN sets ON cards.setcode = sets.code JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE sets.name = 'Coldsnap' AND foreign_data.language = 'Italian'
SELECT foreign_data.name FROM cards JOIN sets ON cards.setcode = sets.code JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE sets.name = 'Coldsnap' AND foreign_data.language = 'Italian' ORDER BY cards.convertedmanacost DESC;
SELECT rulings.date FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.name = 'Reminisce'
SELECT CAST(COUNT(CASE WHEN T1.convertedManaCost = 7 THEN T1.name ELSE NULL END) AS REAL) * 100 / COUNT(T1.name) FROM cards AS T1 INNER JOIN sets AS T2 ON T1.setCode = T2.code WHERE T2.name = 'Coldsnap'
SELECT CAST(SUM(CASE WHEN T2.name = 'Coldsnap' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM cards AS T1 INNER JOIN sets AS T2 ON T1.setcode = T2.code
SELECT sets.code FROM sets WHERE sets.releasedate = '2017-07-14'
SELECT sets.keyrunecode FROM sets WHERE sets.code = 'PKHC'
SELECT sets.mcmid FROM sets WHERE sets.code = 'SS2'
SELECT sets.mcmname FROM sets WHERE sets.releasedate = '2017/6/9'
SELECT sets.type FROM sets WHERE sets.name = 'From the Vault: Lore'
SELECT sets.parentcode FROM sets WHERE sets.name = 'Commander 2014 Oversized';
SELECT rulings.text, cards.hascontentwarning FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.artist = 'Jim Pavelec'
SELECT sets.releasedate FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.name = 'Evacuation'
SELECT sets.basesetsize FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Rinascita di Alara'
SELECT sets.type FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Huitième édition'
SELECT set_translations.translation FROM set_translations JOIN sets ON set_translations.setcode = sets.code JOIN cards ON set_translations.id = cards.uuid WHERE cards.name = 'Tendo Ice Bridge' AND set_translations.language = 'French'
SELECT COUNT(*) FROM set_translations WHERE setcode = (SELECT code FROM sets WHERE name = 'Salvat 2011') AND translation IS NOT NULL;
SELECT set_translations.translation FROM set_translations JOIN sets ON set_translations.setcode = sets.code JOIN cards ON set_translations.setcode = cards.setcode WHERE cards.name = 'Fellwar Stone' AND set_translations.language = 'Japanese'
SELECT cards.name FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.name = "Journey into Nyx Hero's Path" ORDER BY cards.convertedmanacost DESC LIMIT 1;
SELECT sets.releasedate FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Ola de frío'
SELECT sets.type FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.name = 'Samite Pilgrim'
SELECT COUNT(*)  FROM cards  JOIN sets ON cards.setcode = sets.code  WHERE sets.name = 'World Championship Decks 2004'  AND cards.convertedmanacost = 3;
SELECT set_translations.translation FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.name = 'Mirrodin' AND set_translations.language = 'Chinese Simplified'
SELECT CAST(SUM(CASE WHEN T2.isNonFoilOnly = 1 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*)  FROM cards AS T1  INNER JOIN sets AS T2 ON T1.setcode = T2.code  INNER JOIN set_translations AS T3 ON T2.code = T3.setcode  WHERE T3.language = 'Japanese'
SELECT CAST(SUM(CASE WHEN T2.isOnlineOnly = 1 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM set_translations AS T1 INNER JOIN cards AS T2 ON T1.id = T2.uuid WHERE T1.language = 'Portuguese (Brazil)'
SELECT DISTINCT cards.availability FROM cards WHERE cards.artist = 'Aleksi Briclot' AND cards.istextless = 1;
SELECT sets.id FROM sets WHERE sets.basesetsize = (     SELECT MAX(sets.basesetsize)     FROM sets )
SELECT cards.artist FROM cards WHERE cards.side IS NULL ORDER BY cards.convertedmanacost DESC LIMIT 1;
SELECT MAX(frameeffects)  FROM cards  WHERE hasfoil = 1  AND cardkingdomfoilid IS NOT NULL  AND cardkingdomid IS NOT NULL
SELECT COUNT(*)  FROM cards  WHERE power IS NULL OR power = '*'  AND hasFoil = 0  AND duelDeck = 'a'
SELECT sets.id  FROM sets  WHERE sets.type = 'expansion'  AND sets.totalsetsize = (      SELECT MAX(totalsetsize)      FROM sets      WHERE sets.type = 'expansion'      AND sets.code NOT LIKE '%AL%'      AND sets.code NOT LIKE '%C21%'      AND sets.code NOT LIKE '%C20%'      AND sets.code NOT LIKE '%C19%'      AND sets.code NOT LIKE '%C18%'      AND sets.code NOT LIKE '%C17%'      AND sets.code NOT LIKE '%C16%'      AND sets.code NOT LIKE '%C15%'      AND sets.code NOT LIKE '%C14%'      AND sets.code NOT LIKE '%C13%'      AND sets.code NOT LIKE '%C12%'      AND sets.code NOT LIKE '%C11%'      AND sets.code NOT LIKE '%C10%'      AND sets.code NOT LIKE '%C09%'      AND sets.code NOT LIKE '%C08%'      AND sets.code NOT LIKE '%C07%'      AND sets.code NOT LIKE '%C06%'      AND sets.code NOT LIKE '%C05%'      AND sets.code NOT LIKE '%C04%'      AND sets.code NOT LIKE '%C03%'      AND sets.code NOT LIKE '%C02%'      AND sets.code NOT LIKE '%C01%'      AND sets.code NOT LIKE '%C00%'      AND sets.code NOT LIKE '%C99%'      AND sets.code NOT LIKE '%C98%'      AND sets.code NOT LIKE '%C97%'      AND sets.code NOT LIKE '%C96%'      AND sets.code NOT LIKE '%C95%'      AND sets.code NOT LIKE '%C94%'      AND sets.code NOT LIKE '%C93%'      AND sets.code NOT LIKE '%C92%'      AND sets.code NOT LIKE '%C91%'      AND sets.code NOT LIKE '%C90%'      AND sets.code NOT LIKE '%C89%'      AND sets.code NOT LIKE '%C88%'      AND sets.code NOT LIKE '%C87%'      AND sets.code NOT LIKE '%C86%'      AND sets.code NOT LIKE '%C85%'      AND sets.code NOT LIKE '%C84%'      AND sets.code NOT LIKE '%C83%'      AND sets.code NOT LIKE '%C82%'      AND sets.code NOT LIKE '%C81%'      AND sets.code NOT LIKE '%C80%'      AND sets.code NOT LIKE '%C79%'      AND sets.code NOT LIKE '%C78%'      AND sets.code NOT LIKE '%C77%'      AND sets.code NOT LIKE '%C76%'      AND sets.code NOT LIKE '%C75%'      AND sets.code NOT LIKE '%C74%'      AND sets.code NOT LIKE '%C73%'      AND sets.code NOT LIKE '%C72%'      AND sets.code NOT LIKE '%C71%'      AND sets.code NOT LIKE '%C70%'      AND sets.code NOT LIKE '%C69%'      AND sets.code NOT LIKE '%C68%'      AND sets.code NOT LIKE '%C67%'      AND sets.code NOT LIKE '%C66%'      AND sets.code NOT LIKE '%C65%'      AND sets.code NOT LIKE '%C64%'      AND sets.code NOT LIKE '%C63%'      AND sets.code NOT LIKE '%C62%'      AND sets.code NOT LIKE '%C61%'      AND sets.code NOT LIKE '%C60%'      AND sets.code NOT LIKE '%C59%'      AND sets.code NOT LIKE '%C58%'      AND sets.code NOT LIKE '%C57%'      AND sets.code NOT LIKE '%C56%'      AND sets.code NOT LIKE '%C55%'      AND sets.code NOT LIKE '%C54%'      AND sets.code NOT LIKE '%C53%'      AND sets.code NOT LIKE '%C52%'      AND sets.code NOT LIKE '%C51%'      AND sets.code NOT LIKE '%C50%'      AND sets.code NOT LIKE '%C49%'      AND sets.code NOT LIKE '%C48%'      AND sets.code NOT LIKE '%C47%'      AND sets.code NOT LIKE '%C46%'      AND sets.code NOT LIKE '%C45%'      AND sets.code NOT LIKE '%C44%'      AND sets.code NOT LIKE '%C43%'      AND sets.code NOT LIKE '%C42%'      AND sets.code NOT LIKE '%C41%'  )
SELECT name FROM cards WHERE convertedmanacost = ( SELECT MAX(convertedmanacost) FROM cards ) LIMIT 10
SELECT MIN(cards.originalreleasedate) AS oldest_release_date, legalities.format FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.rarity = 'mythic' AND legalities.status = 'Legal'
SELECT COUNT(*)  FROM cards  JOIN foreign_data ON cards.uuid = foreign_data.uuid  WHERE artist = 'Volkan Baga' AND language = 'French'
SELECT COUNT(*)  FROM cards  JOIN legalities ON cards.uuid = legalities.uuid  WHERE rarity = 'rare'  AND types = 'Enchantment'  AND name = 'Abundance'  AND status = 'Legal'
SELECT T1.format, T2.name FROM legalities AS T1 INNER JOIN cards AS T2 ON T1.uuid = T2.uuid WHERE T1.status = 'Banned' GROUP BY T1.format ORDER BY COUNT(T1.status) DESC LIMIT 1
SELECT sets.name, set_translations.language FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.name = 'Battlebond'
SELECT T1.artist, T2.format  FROM cards AS T1  INNER JOIN legalities AS T2 ON T1.uuid = T2.uuid  WHERE T1.scryfallillustrationid = (      SELECT scryfallillustrationid      FROM cards      GROUP BY scryfallillustrationid      ORDER BY COUNT(id)      LIMIT 1  )
SELECT T2.Status FROM cards AS T1 INNER JOIN legalities AS T2 ON T1.uuid = T2.uuid WHERE T1.frameVersion = 1997 AND T1.artist = 'D. Alexander Gregory' AND (T1.hasContentWarning = 1 OR T1.isReserved = 1) AND T2.format = 'legacy'
SELECT cards.name, legalities.format FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.edhrecrank = 1 AND legalities.status = 'Banned'
SELECT AVG(T2.id), T1.language FROM set_translations AS T1 INNER JOIN sets AS T2 ON T1.setcode = T2.code WHERE T2.releasedate BETWEEN '2012-01-01' AND '2015-12-31' GROUP BY T1.language
SELECT cards.artist FROM cards WHERE cards.bordercolor = 'black' AND cards.availability = 'arena'
SELECT cards.uuid FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE legalities.format = 'oldschool' AND (legalities.status = 'banned' OR legalities.status = 'restricted')
SELECT COUNT(*)  FROM cards  WHERE artist = 'Matthew D. Wilson' AND availability = 'paper'
SELECT rulings.text FROM rulings JOIN cards ON rulings.uuid = cards.uuid WHERE cards.artist = 'Kev Walker' ORDER BY rulings.date DESC;
SELECT cards.name, legalities.format FROM cards JOIN sets ON cards.setcode = sets.code JOIN legalities ON cards.uuid = legalities.uuid WHERE sets.name = 'Hour of Devastation'
SELECT sets.name FROM sets LEFT JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language != 'Japanese' AND set_translations.language = 'Korean'
SELECT frameversion, cards.name FROM cards WHERE artist = 'Allen Williams' AND EXISTS (SELECT 1 from legalities WHERE legalities.status = 'Banned' AND legalities.uuid = cards.uuid)
SELECT CASE WHEN Reputation > ( SELECT Reputation FROM Users WHERE DisplayName = 'Jarrod Dixon' ) THEN 'Harlan' ELSE 'Jarrod Dixon' END FROM Users WHERE DisplayName = 'Harlan'
SELECT users.displayname FROM users WHERE strftime('%Y', creationdate) = '2014'
SELECT COUNT(*) FROM users WHERE LastAccessDate > '2014-09-01 00:00:00'
SELECT users.displayname FROM users WHERE users.views = (SELECT MAX(views) FROM users)
SELECT COUNT(*)  FROM users  WHERE upvotes > 100 AND downvotes > 1
SELECT COUNT(DISTINCT users.id) FROM users JOIN posts ON users.id = posts.owneruserid WHERE posts.viewcount > 10 AND strftime('%Y', users.creationdate) > '2013'
SELECT COUNT(*)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = 'csgillespie'
SELECT posts.title FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie'
SELECT users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = "Eliciting priors from experts"
SELECT posts.title FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie' ORDER BY posts.viewcount DESC LIMIT 1;
SELECT users.displayname FROM users JOIN posts ON users.id = posts.owneruserid WHERE posts.favoritecount = (SELECT MAX(favoritecount) FROM posts)
SELECT SUM(posts.commentcount) FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie'
SELECT MAX(posts.answercount) FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie'
SELECT users.displayname FROM posts JOIN users ON posts.lasteditoruserid = users.id WHERE posts.title = "Examples for teaching: Correlation does not mean causation"
SELECT COUNT(*)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = 'csgillespie'  AND posts.parentid IS NULL
SELECT users.displayname FROM users JOIN posts ON posts.owneruserid = users.id WHERE posts.closeddate IS NOT NULL
SELECT COUNT(*)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.age > 65 AND posts.score >= 20
SELECT users.location FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = 'Eliciting priors from experts'
SELECT posts.body FROM posts JOIN tags ON tags.excerptpostid = posts.id WHERE tags.tagname = "bayesian"
SELECT posts.body FROM posts JOIN tags ON tags.excerptpostid = posts.id ORDER BY tags.count DESC LIMIT 1;
SELECT COUNT(*)  FROM badges  JOIN users ON badges.userid = users.id  WHERE users.displayname = "csgillespie"
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = 'csgillespie'
SELECT COUNT(*)  FROM badges  JOIN users ON badges.userid = users.id  WHERE users.displayname = 'csgillespie'  AND strftime('%Y', badges.date) = '2011'
SELECT users.displayname FROM users JOIN badges ON users.id = badges.userid GROUP BY users.id ORDER BY COUNT(badges.id) DESC LIMIT 1;
SELECT AVG(posts.score)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = 'csgillespie'
SELECT AVG(badges.id)  FROM badges  JOIN users ON badges.userid = users.id  WHERE users.views > 200
SELECT CAST(SUM(CASE WHEN T2.Age > 65 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM posts AS T1 INNER JOIN users AS T2 ON T1.owneruserid = T2.id WHERE T1.score > 20
SELECT COUNT(*)  FROM votes  WHERE userid = 58 AND creationdate LIKE '2010-07-19%'
SELECT CreationDate FROM votes GROUP BY CreationDate ORDER BY COUNT(Id) DESC LIMIT 1
SELECT COUNT(*) FROM badges WHERE name = 'Revival'
SELECT posts.title FROM posts JOIN comments ON comments.postid = posts.id WHERE comments.score = (SELECT MAX(score) FROM comments)
SELECT COUNT(*) FROM comments WHERE postid = 1910
SELECT posts.favoritecount FROM comments JOIN posts ON comments.postid = posts.id WHERE comments.userid = 3025 AND comments.creationdate = '2014-04-23 20:29:39.0'
SELECT comments.text FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.parentid = 107829 LIMIT 1;
SELECT CASE WHEN T2.PostTypeId = 1 THEN 'well-finished' ELSE 'not well-finished' END FROM comments AS T1 INNER JOIN posts AS T2 ON T1.PostId = T2.Id WHERE T1.UserID = 23853 AND T1.CreationDate = '2013-07-12 09:08:18.0'
SELECT users.reputation FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.id = '65041'
SELECT COUNT(*)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = "Tiago Pasqualini"
SELECT users.displayname FROM users JOIN votes ON users.id = votes.userid WHERE votes.id = 6347;
SELECT COUNT(*)  FROM votes  JOIN posts ON votes.postid = posts.id  WHERE posts.title LIKE '%data visualization%'
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = "DatEpicCoderGuyWhoPrograms"
SELECT CAST(SUM(T2.PostId) AS REAL) / COUNT(T1.Id) FROM Users AS T1 INNER JOIN Votes AS T2 ON T1.Id = T2.UserID WHERE T1.Id = 24
SELECT posts.viewcount FROM posts WHERE posts.title = 'Integration of Weka and/or RapidMiner into Informatica PowerCenter/Developer'
SELECT comments.text FROM comments WHERE comments.score = 17;
SELECT users.displayname FROM users WHERE users.websiteurl = 'http://stackoverflow.com'
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = 'SilentGhost'
SELECT users.displayname FROM comments JOIN users ON comments.userid = users.id WHERE comments.text = 'thank you user93!'
SELECT comments.text FROM comments JOIN users ON comments.userid = users.id WHERE users.displayname = 'A Lion'
SELECT users.displayname, users.reputation FROM users JOIN posts ON posts.owneruserid = users.id WHERE posts.title = 'Understanding what Dassault iSight is doing?'
SELECT comments.text FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.title = 'How does gentle boosting differ from AdaBoost?'
SELECT users.displayname FROM users JOIN badges ON users.id = badges.userid WHERE badges.name = 'Necromancer' LIMIT 10;
SELECT users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = 'Open source tools for visualizing multi-dimensional data?'
SELECT posts.title FROM posts JOIN users ON posts.lasteditoruserid = users.id WHERE users.displayname = "Vebjorn Ljosa"
SELECT SUM(posts.score), users.websiteurl FROM posts JOIN users ON posts.lasteditoruserid = users.id WHERE users.displayname = 'Yevgeny'
SELECT T2.UserID FROM posts AS T1 INNER JOIN comments AS T2 ON T1.Id = T2.PostID WHERE T1.Title = 'Why square the difference instead of taking the absolute value in standard deviation?'
SELECT SUM(votes.bountyamount) FROM posts JOIN votes ON posts.id = votes.postid WHERE posts.title LIKE '%data%'
SELECT users.displayname FROM users JOIN votes ON users.id = votes.userid JOIN posts ON votes.postid = posts.id WHERE posts.title LIKE '%variance%' AND votes.bountyamount = 50
SELECT AVG(posts.viewcount) AS average_view_count, posts.title, comments.text, comments.score FROM posts JOIN postlinks ON posts.id = postlinks.postid JOIN tags ON postlinks.relatedpostid = tags.id JOIN comments ON posts.id = comments.postid WHERE tags.tagname = 'humor'
SELECT COUNT(*) FROM comments WHERE userid = 13;
SELECT users.id FROM users ORDER BY reputation DESC LIMIT 1;
SELECT users.id FROM users ORDER BY views ASC LIMIT 1;
SELECT COUNT(DISTINCT badges.userid) FROM badges WHERE badges.name = 'Supporter' AND strftime('%Y', badges.date) = '2011'
SELECT COUNT(userid) FROM badges GROUP BY userid HAVING COUNT(name) > 5;
SELECT COUNT(DISTINCT users.id) FROM users JOIN badges ON badges.userid = users.id WHERE users.location = 'New York' AND badges.name IN ('Teacher', 'Supporter')
SELECT users.id, users.reputation FROM users JOIN posts ON posts.owneruserid = users.id WHERE posts.id = 1;
SELECT T1.DisplayName FROM Users AS T1 INNER JOIN Posts AS T2 ON T1.Id = T2.OwnerUserId INNER JOIN PostHistory AS T3 ON T3.PostId = T2.Id WHERE T1.Views = 1000 GROUP BY T1.DisplayName HAVING COUNT(T3.PostId) = 1
SELECT users.displayname, badges.name FROM users JOIN comments ON users.id = comments.userid JOIN badges ON users.id = badges.userid GROUP BY users.id ORDER BY COUNT(comments.id) DESC LIMIT 1
SELECT COUNT(DISTINCT users.id) FROM users JOIN badges ON users.id = badges.userid WHERE users.location = 'India' AND badges.name = 'Teacher'
SELECT CAST(SUM(CASE WHEN strftime('%Y', date) = '2010' THEN 1 ELSE 0 END) AS REAL) * 100 / SUM(CASE WHEN strftime('%Y', date) = '2011' THEN 1 ELSE 0 END) FROM badges WHERE name = 'Student'
SELECT posthistorytypeid, COUNT(DISTINCT comments.userid) FROM posthistory JOIN comments ON posthistory.postid = comments.postid WHERE posthistory.postid = 3720 GROUP BY posthistorytypeid
SELECT T1.Id, T1.ViewCount FROM Posts AS T1 INNER JOIN postlinks AS T2 ON T1.Id = T2.PostId WHERE T2.RelatedPostId = 61217
SELECT posts.score, postlinks.linktypeid FROM posts  JOIN postlinks ON posts.id = postlinks.postid WHERE posts.id = 395
SELECT posts.id, posts.owneruserid FROM posts WHERE posts.score > 60
SELECT SUM(T2.FavoriteCount)  FROM users AS T1  INNER JOIN posts AS T2 ON T1.id = T2.owneruserid  WHERE T1.id = 686 AND T2.creaiondate LIKE '2011%'
SELECT AVG(T1.UpVotes), AVG(T1.Age) FROM Users AS T1 INNER JOIN Posts AS T2 ON T1.Id = T2.OwnerUserId WHERE T2.PostTypeId = 1 GROUP BY T1.Id HAVING COUNT(T2.Id) > 10
SELECT COUNT(DISTINCT badges.userid) FROM badges WHERE badges.name = "Announcer"
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE badges.date = '2010-07-19 19:39:08'
SELECT COUNT(*)  FROM comments  WHERE score > 60
SELECT comments.text FROM comments WHERE comments.creationdate = '2010-07-19 19:25:47.0'
SELECT COUNT(*) FROM posts WHERE score = 10
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.reputation = (SELECT MAX(reputation) FROM users)
SELECT users.reputation FROM users JOIN badges ON users.id = badges.userid WHERE badges.date = '2010-07-19 19:39:08.0'
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = "Pierre"
SELECT badges.date FROM badges JOIN users ON badges.userid = users.id WHERE users.location = 'Rochester, NY'
SELECT CAST(COUNT(T1.UserID) AS REAL) * 100 / ( SELECT COUNT(UserID) FROM Users ) FROM Badges AS T1 INNER JOIN Users AS T2 ON T1.UserID = T2.ID WHERE T1.Name = 'Teacher'
SELECT CAST(SUM(CASE WHEN T2.age BETWEEN 13 AND 18 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.userid) FROM badges AS T1 INNER JOIN users AS T2 ON T1.userid = T2.id WHERE T1.name = 'Organizer'
SELECT T2.Score  FROM posts AS T1  INNER JOIN comments AS T2 ON T1.Id = T2.PostId  WHERE T1.creaiondate = '2010-07-19 19:19:56.0'
SELECT T2.Comment FROM posts AS T1 INNER JOIN posthistory AS T2 ON T1.Id = T2.PostId WHERE T2.CreationDate = '2010-07-19 19:37:33'
SELECT users.age FROM users WHERE users.location = 'Vienna, Austria' AND users.id IN (SELECT badges.userid FROM badges)
SELECT COUNT(DISTINCT users.id) FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = 'Supporter' AND users.age BETWEEN 19 AND 65
SELECT SUM(posts.viewcount) FROM posts JOIN badges ON posts.owneruserid = badges.userid WHERE badges.date = '2010-07-19 19:39:08.0'
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.reputation = (SELECT MIN(reputation) FROM users)
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = "Sharpie"
SELECT COUNT(DISTINCT users.id) FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = "Supporter" AND users.age > 65
SELECT users.displayname FROM users WHERE users.id = 30;
SELECT COUNT(DISTINCT users.id) FROM users WHERE users.location = 'New York'
SELECT COUNT(Id) FROM Votes WHERE CreationDate LIKE '2010%'
SELECT COUNT(*) FROM users WHERE age BETWEEN 19 AND 65;
SELECT users.displayname FROM users ORDER BY users.views DESC LIMIT 10;
SELECT CAST(SUM(CASE WHEN CreationDate LIKE '2010%' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN CreationDate LIKE '2011%' THEN 1 ELSE 0 END) FROM votes
SELECT tags.tagname FROM tags JOIN posts ON tags.excerptpostid = posts.id JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'John Stauffer'
SELECT COUNT(*)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = 'Daniel Vassallo';
SELECT COUNT(*)  FROM votes  JOIN users ON votes.userid = users.id  WHERE users.displayname = 'Harlan'
SELECT posts.id FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'slashnick' ORDER BY posts.answercount DESC LIMIT 1;
SELECT CASE WHEN SUM(CASE WHEN T2.DisplayName = 'Harvey Motulsky' THEN 1 ELSE 0 END) > SUM(CASE WHEN T2.DisplayName = 'Noah Snyder' THEN 1 ELSE 0 END) THEN 'Harvey Motulsky' ELSE 'Noah Snyder' END FROM Posts AS T1 INNER JOIN Users AS T2 ON T1.OwnerUserId = T2.Id
SELECT COUNT(*)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = 'Matt Parker' AND posts.id > 4 AND posts.score > 4;
SELECT COUNT(*)  FROM comments  JOIN users ON comments.userid = users.id  JOIN posts ON comments.postid = posts.id  WHERE users.displayname = 'Neil McGuigan'  AND comments.score < 60
SELECT T1.TagName FROM tags AS T1 INNER JOIN posts AS T2 ON T2.Id = T1.ExcerptPostId INNER JOIN comments AS T3 ON T3.PostId = T2.Id WHERE T3.UserDisplayName = 'Mark Meckes' AND T3.Text = ''
SELECT users.displayname FROM users JOIN badges ON users.id = badges.userid WHERE badges.name = 'Organizer'
SELECT CAST(SUM(CASE WHEN T2.TagName = 'r' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.Id) FROM Posts AS T1 INNER JOIN Tags AS T2 ON T1.Id = T2.ExcerptPostId WHERE T1.OwnerDisplayName = 'Community'
SELECT SUM(T1.ViewCount) - ( SELECT SUM(T1.ViewCount) FROM posts AS T1 INNER JOIN tags AS T2 ON T1.Id = T2.ExcerptPostId WHERE T2.TagName = 'amos' ) AS diff FROM posts AS T1 INNER JOIN tags AS T2 ON T1.Id = T2.ExcerptPostId WHERE T2.TagName = 'mornington'
SELECT COUNT(DISTINCT badges.userid) FROM badges WHERE badges.name = 'Commentator' AND strftime('%Y', badges.date) = '2014'
SELECT COUNT(*) FROM posts WHERE creaiondate BETWEEN '2010-07-21 00:00:00' AND '2010-07-21 23:59:59'
SELECT users.displayname, users.age FROM users JOIN posts ON users.id = posts.owneruserid WHERE posts.viewcount = (SELECT MAX(viewcount) FROM posts)
SELECT posts.lasteditdate, posts.lasteditoruserid FROM posts WHERE posts.title = 'Detecting a given face in a database of facial images'
SELECT COUNT(*)  FROM comments  WHERE userid = 13 AND score < 60;
SELECT posts.title, comments.userdisplayname FROM posts JOIN comments ON comments.postid = posts.id WHERE comments.score > 60
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.location = 'North Pole' AND strftime('%Y', badges.date) = '2011'
SELECT users.displayname, users.websiteurl FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.favoritecount > 150
SELECT COUNT(*) AS post_history_counts, MAX(lasteditdate) AS last_edit_date FROM posts WHERE title = "What is the best introductory Bayesian statistics textbook?"
SELECT users.lastaccessdate, users.location FROM users JOIN badges ON badges.userid = users.id WHERE badges.name = 'outliers'
SELECT posts.title FROM posts JOIN postlinks ON postlinks.relatedpostid = posts.id JOIN posts AS p ON p.id = postlinks.postid WHERE p.title = "How to tell if something happened in a data set which monitors a value over time"
SELECT T1.id, T2.name  FROM posts AS T1  INNER JOIN badges AS T2 ON T1.OwnerUserId = T2.UserID  INNER JOIN users AS T3 ON T1.OwnerUserId = T3.Id  WHERE T3.DisplayName = 'Samuel' AND strftime('%Y', T1.creaiondate) = '2013'
SELECT users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.viewcount = (SELECT MAX(viewcount) FROM posts)
SELECT users.displayname, users.location FROM users JOIN posts ON users.id = posts.owneruserid JOIN tags ON tags.excerptpostid = posts.id WHERE tags.tagname = 'hypothesis-testing'
SELECT posts.title, postlinks.linktypeid FROM posts JOIN postlinks ON posts.id = postlinks.relatedpostid WHERE posts.title = 'What are principal component scores?';
SELECT T1.OwnerDisplayName FROM Posts AS T1 INNER JOIN Comments AS T2 ON T1.Id = T2.PostId ORDER BY T2.Score DESC LIMIT 1
SELECT users.displayname, users.websiteurl FROM users JOIN votes ON users.id = votes.userid WHERE votes.votetypeid = 8 AND votes.bountyamount = (SELECT MAX(bountyamount) FROM votes WHERE votetypeid = 8)
SELECT posts.title FROM posts ORDER BY viewcount DESC LIMIT 5;
SELECT COUNT(*) FROM tags WHERE count BETWEEN 5000 AND 7000;
SELECT posts.owneruserid FROM posts WHERE favoritecount = (SELECT MAX(favoritecount) FROM posts)
SELECT MAX(age) FROM users WHERE reputation = (SELECT MAX(reputation) FROM users)
SELECT COUNT(T1.PostId)  FROM votes AS T1  INNER JOIN posts AS T2 ON T1.PostId = T2.Id  WHERE T1.BountyAmount = 50  AND strftime('%Y', T2.creaiondate) = '2011'
SELECT id FROM users ORDER BY age DESC LIMIT 1
SELECT posts.score FROM posts JOIN tags ON tags.excerptpostid = posts.id WHERE tags.count = (SELECT MAX(count) FROM tags)
SELECT AVG(links_per_month) FROM (     SELECT COUNT(*) AS links_per_month     FROM postlinks     INNER JOIN posts ON postlinks.postid = posts.id     WHERE strftime('%Y', postlinks.creationdate) = '2010'     AND posts.answercount <= 2     GROUP BY strftime('%m', postlinks.creationdate) )
SELECT posts.id FROM posts JOIN votes ON posts.id = votes.postid WHERE votes.userid = 1465 ORDER BY posts.favoritecount DESC LIMIT 1;
SELECT posts.title FROM postlinks JOIN posts ON postlinks.postid = posts.id ORDER BY postlinks.creationdate ASC LIMIT 1;
SELECT users.displayname FROM users JOIN badges ON users.id = badges.userid GROUP BY users.displayname ORDER BY COUNT(badges.name) DESC LIMIT 1;
SELECT MIN(votes.creationdate) FROM votes JOIN users ON votes.userid = users.id WHERE users.displayname = 'chl'
SELECT MIN(users.creationdate) AS "Date" FROM users WHERE users.age = (SELECT MIN(age) FROM users)
SELECT users.displayname FROM users JOIN badges ON users.id = badges.userid WHERE badges.name = 'Autobiographer' ORDER BY badges.date ASC LIMIT 1;
SELECT COUNT(DISTINCT users.id) FROM users JOIN posts ON users.id = posts.owneruserid WHERE users.location = 'United Kingdom' AND posts.favoritecount >= 4
SELECT AVG(PostId) FROM votes WHERE userid IN (SELECT id FROM users WHERE age = (SELECT MAX(age) FROM users))
SELECT users.displayname FROM users WHERE reputation = (SELECT MAX(reputation) FROM users)
SELECT COUNT(*)  FROM users  WHERE reputation > 2000 AND views > 1000;
SELECT users.displayname FROM users WHERE users.age BETWEEN 19 AND 65;
SELECT COUNT(T1.id)  FROM posts AS T1  INNER JOIN users AS T2 ON T1.owneruserid = T2.id  WHERE T2.displayname = 'Jay Stevens'  AND strftime('%Y', T1.creaiondate) = '2010'
SELECT posts.id, posts.title FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'Harvey Motulsky' ORDER BY posts.viewcount DESC LIMIT 1;
SELECT posts.id, posts.title FROM posts ORDER BY posts.score DESC LIMIT 1;
SELECT AVG(posts.score)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = 'Stephen Turner'
SELECT users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.viewcount > 20000 AND strftime('%Y', posts.creaiondate) = '2011'
SELECT T1.Id, T2.DisplayName  FROM posts AS T1  INNER JOIN users AS T2 ON T1.OwnerUserId = T2.Id  WHERE strftime('%Y', T1.creaiondate) = '2010'  ORDER BY T1.FavoriteCount DESC  LIMIT 1
SELECT CAST(SUM(CASE WHEN T2.Reputation > 1000 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id)  FROM posts AS T1  INNER JOIN users AS T2 ON T1.OwnerUserId = T2.Id  WHERE T1.creaiondate LIKE '2011%'
SELECT CAST(SUM(IIF(age BETWEEN 13 AND 18, 1, 0)) AS REAL) * 100 / COUNT(id) FROM Users
SELECT posts.viewcount, users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = 'Computer Game Datasets'
SELECT COUNT(*) FROM posts WHERE ViewCount > (SELECT AVG(ViewCount) FROM posts)
SELECT COUNT(*)  FROM comments  WHERE postid = (SELECT id FROM posts ORDER BY score DESC LIMIT 1)
SELECT COUNT(*)  FROM posts  WHERE ViewCount > 35000 AND CommentCount = 0
SELECT users.displayname, users.location FROM users JOIN posts ON users.id = posts.lasteditoruserid WHERE posts.id = 183 ORDER BY posts.lasteditdate DESC LIMIT 1;
SELECT b.name FROM badges b JOIN users u ON b.userid = u.id WHERE u.displayname = 'Emmett' ORDER BY b.date DESC LIMIT 1;
SELECT COUNT(*)  FROM users  WHERE age BETWEEN 19 AND 65 AND upvotes > 5000
SELECT T2.Date - T1.CreationDate FROM Users AS T1 INNER JOIN Badges AS T2 ON T1.Id = T2.UserID WHERE T1.DisplayName = 'Zolomon'
SELECT COUNT(T1.id), COUNT(T2.id)  FROM posts AS T1  INNER JOIN comments AS T2 ON T1.id = T2.postid  INNER JOIN users AS T3 ON T3.id = T1.owneruserid  ORDER BY T3.creationdate DESC  LIMIT 1
SELECT comments.text, users.displayname FROM comments JOIN posts ON comments.postid = posts.id JOIN users ON comments.userid = users.id WHERE posts.title = 'Analysing wind data with R' ORDER BY comments.creationdate DESC LIMIT 1;
SELECT COUNT(DISTINCT badges.userid) FROM badges WHERE badges.name = 'Citizen Patrol'
SELECT COUNT(*)  FROM posts  JOIN tags ON tags.excerptpostid = posts.id  WHERE tags.tagname = 'careers'
SELECT users.reputation, users.views FROM users WHERE users.displayname = 'Jarrod Dixon'
SELECT COUNT(comments.id) AS comment_count, COUNT(posts.id) AS answer_count FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.title = 'Clustering 1D data'
SELECT users.creationdate FROM users WHERE users.displayname = 'IrishStat'
SELECT COUNT(*) FROM votes WHERE bountyamount >= 30;
SELECT CAST(COUNT(CASE WHEN T2.Score > 50 THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T2.id) FROM Users AS T1 INNER JOIN Posts AS T2 ON T1.Id = T2.OwnerUserId WHERE T1.Reputation = ( SELECT MAX(Reputation) FROM Users )
SELECT COUNT(*) FROM posts WHERE score < 20;
SELECT COUNT(*)  FROM tags  WHERE id < 15 AND count <= 20;
SELECT tags.excerptpostid, tags.wikipostid FROM tags WHERE tags.tagname = 'sample'
SELECT users.reputation, users.upvotes FROM users JOIN comments ON comments.userid = users.id WHERE comments.text = 'fine, you win :)';
SELECT T2.Text FROM posts AS T1 INNER JOIN posthistory AS T2 ON T1.Id = T2.PostId WHERE T1.Title = 'Linear regression'
SELECT comments.text FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.viewcount BETWEEN 100 AND 150 ORDER BY comments.score DESC LIMIT 1;
SELECT comments.creationdate, users.age FROM comments JOIN users ON comments.userid = users.id WHERE comments.text LIKE '%http://%'
SELECT COUNT(DISTINCT comments.postid) FROM comments JOIN posts ON comments.postid = posts.id WHERE comments.score = 0 AND posts.viewcount < 5;
SELECT COUNT(*)  FROM comments  WHERE score = 0  AND postid IN (SELECT id FROM posts WHERE commentcount = 1)
SELECT COUNT(DISTINCT users.id) FROM comments JOIN users ON comments.userid = users.id WHERE comments.score = 0 AND users.age = 40
SELECT posts.id, comments.id FROM posts JOIN comments ON posts.id = comments.postid WHERE posts.title = 'Group differences on a five point Likert item'
SELECT users.upvotes FROM users JOIN comments ON users.id = comments.userid WHERE comments.text = "R is also lazy evaluated."
SELECT comments.text FROM comments JOIN users ON comments.userid = users.id WHERE users.displayname = 'Harvey Motulsky'
SELECT users.displayname FROM comments JOIN users ON comments.userid = users.id WHERE comments.score BETWEEN 1 AND 5 AND users.downvotes = 0
SELECT CAST(SUM(CASE WHEN T2.UpVotes = 0 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.PostId) FROM Comments AS T1 INNER JOIN Users AS T2 ON T1.UserID = T2.Id WHERE T1.Score BETWEEN 5 AND 10
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = '3-D Man'
SELECT COUNT(DISTINCT hero_power.hero_id)  FROM hero_power  JOIN superpower ON hero_power.power_id = superpower.id  WHERE superpower.power_name = 'Super Strength'
SELECT COUNT(DISTINCT superhero.id) FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Super Strength' AND superhero.height_cm > 200;
SELECT superhero.full_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id GROUP BY superhero.id HAVING COUNT(superhero.full_name) > 15
SELECT COUNT(*) FROM superhero WHERE eye_colour_id = (SELECT id FROM colour WHERE colour = 'Blue')
SELECT colour.colour FROM superhero JOIN colour ON superhero.skin_colour_id = colour.id WHERE superhero.superhero_name = 'Apocalypse'
SELECT COUNT(*)  FROM superhero  JOIN colour ON superhero.eye_colour_id = colour.id  JOIN hero_power ON superhero.id = hero_power.hero_id  JOIN superpower ON hero_power.power_id = superpower.id  WHERE colour.colour = 'Blue'  AND superpower.power_name = 'Agility'
SELECT superhero.superhero_name  FROM superhero  JOIN colour AS eye_colour ON superhero.eye_colour_id = eye_colour.id  JOIN colour AS hair_colour ON superhero.hair_colour_id = hair_colour.id  WHERE eye_colour.colour = 'Blue' AND hair_colour.colour = 'Blond'
SELECT COUNT(*) FROM superhero WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'Marvel Comics')
SELECT superhero.full_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Marvel Comics' ORDER BY superhero.height_cm DESC LIMIT 1;
SELECT publisher.publisher_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.superhero_name = 'Sauron'
SELECT COUNT(*)  FROM superhero  JOIN publisher ON superhero.publisher_id = publisher.id  JOIN colour ON superhero.eye_colour_id = colour.id  WHERE publisher.publisher_name = 'Marvel Comics'  AND colour.colour = 'Blue'
SELECT AVG(height_cm)  FROM superhero  JOIN publisher ON superhero.publisher_id = publisher.id  WHERE publisher.publisher_name = 'Marvel Comics'
SELECT CAST(SUM(CASE WHEN T3.power_name = 'Super Strength' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM superhero AS T1 INNER JOIN hero_power AS T2 ON T1.id = T2.hero_id INNER JOIN superpower AS T3 ON T2.power_id = T3.id WHERE T1.publisher_id = ( SELECT id FROM publisher WHERE publisher_name = 'Marvel Comics' )
SELECT COUNT(*) FROM superhero WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'DC Comics')
SELECT publisher.publisher_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE attribute.attribute_name = 'Speed' ORDER BY hero_attribute.attribute_value LIMIT 1;
SELECT COUNT(*)  FROM superhero  JOIN colour ON superhero.eye_colour_id = colour.id  JOIN publisher ON superhero.publisher_id = publisher.id  WHERE colour = 'Gold' AND publisher_name = 'Marvel Comics'
SELECT publisher.publisher_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.superhero_name = 'Blue Beetle II'
SELECT COUNT(*) FROM superhero WHERE hair_colour_id = (SELECT id FROM colour WHERE colour = 'Blond')
SELECT superhero.superhero_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Intelligence' ORDER BY hero_attribute.attribute_value LIMIT 1;
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.superhero_name = 'Copycat'
SELECT COUNT(DISTINCT superhero.id) FROM superhero JOIN hero_attribute ON hero_attribute.hero_id = superhero.id JOIN attribute ON attribute.id = hero_attribute.attribute_id WHERE attribute.attribute_name = 'Durability' AND hero_attribute.attribute_value < 50;
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Death Touch'
SELECT COUNT(*)  FROM superhero  JOIN gender ON superhero.gender_id = gender.id  JOIN hero_attribute ON hero_attribute.hero_id = superhero.id  JOIN attribute ON hero_attribute.attribute_id = attribute.id  WHERE gender.gender = 'Female'  AND attribute.attribute_name = 'Strength'  AND hero_attribute.attribute_value = 100
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id GROUP BY superhero.superhero_name ORDER BY COUNT(hero_power.power_id) DESC LIMIT 1;
SELECT COUNT(*) FROM superhero WHERE race_id = (SELECT id FROM race WHERE race = 'Vampire')
SELECT CAST(SUM(CASE WHEN T2.alignment = 'Bad' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id), COUNT(CASE WHEN T3.publisher_name = 'Marvel Comics' THEN 1 ELSE NULL END) FROM superhero AS T1 INNER JOIN alignment AS T2 ON T1.alignment_id = T2.id INNER JOIN publisher AS T3 ON T1.publisher_id = T3.id
SELECT (SUM(CASE WHEN publisher_name = 'Marvel Comics' THEN 1 ELSE 0 END) - SUM(CASE WHEN publisher_name = 'DC Comics' THEN 1 ELSE 0 END)) AS difference FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id;
SELECT publisher.id FROM publisher WHERE publisher.publisher_name = 'Star Trek'
SELECT AVG(attribute_value) FROM hero_attribute
SELECT COUNT(*) FROM superhero WHERE full_name IS NULL;
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.id = 75;
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Deathlok'
SELECT AVG(weight_kg)  FROM superhero  WHERE gender_id = 2
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id JOIN gender ON superhero.gender_id = gender.id WHERE gender.gender = 'Male' LIMIT 5;
SELECT superhero_name FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Alien'
SELECT superhero_name FROM superhero WHERE height_cm BETWEEN 170 AND 190 AND eye_colour_id = 1;
SELECT superpower.power_name FROM superpower JOIN hero_power ON superpower.id = hero_power.power_id WHERE hero_power.hero_id = 56;
SELECT superhero.full_name FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Demi-God' LIMIT 5;
SELECT COUNT(*) FROM superhero WHERE alignment_id = 'Bad'
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.weight_kg = 169;
SELECT colour.colour FROM superhero JOIN colour ON superhero.hair_colour_id = colour.id JOIN race ON superhero.race_id = race.id WHERE superhero.height_cm = 185 AND race.race = 'Human'
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.weight_kg = (SELECT MAX(weight_kg) FROM superhero)
SELECT CAST(SUM(CASE WHEN T2.publisher_name = 'Marvel Comics' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM superhero AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id WHERE T1.height_cm BETWEEN 150 AND 180
SELECT superhero.full_name FROM superhero JOIN gender ON superhero.gender_id = gender.id WHERE gender.gender = 'Male' AND superhero.weight_kg > (SELECT AVG(weight_kg) * 0.79 FROM superhero)
SELECT superpower.power_name FROM superpower JOIN hero_power ON superpower.id = hero_power.power_id GROUP BY superpower.power_name ORDER BY COUNT(*) DESC LIMIT 1;
SELECT hero_attribute.attribute_value FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id WHERE superhero.superhero_name = 'Abomination'
SELECT superpower.power_name FROM superpower JOIN hero_power ON superpower.id = hero_power.power_id WHERE hero_power.hero_id = 1;
SELECT COUNT(DISTINCT hero_id) FROM hero_power JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Stealth';
SELECT superhero.full_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Strength' AND hero_attribute.attribute_value = (     SELECT MAX(attribute_value)     FROM hero_attribute     JOIN attribute ON hero_attribute.attribute_id = attribute.id     WHERE attribute.attribute_name = 'Strength' )
SELECT AVG(superhero.id) FROM superhero WHERE skin_colour_id = 1;
SELECT COUNT(*) FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Dark Horse Comics'
SELECT T1.superhero_name FROM superhero AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id INNER JOIN hero_attribute AS T3 ON T1.id = T3.hero_id INNER JOIN attribute AS T4 ON T3.attribute_id = T4.id WHERE T2.publisher_name = 'Dark Horse Comics' AND T4.attribute_name = 'Durability' ORDER BY T3.attribute_value DESC LIMIT 1
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.full_name = 'Abraham Sapien'
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Flight'
SELECT T1.eye_colour_id, T1.hair_colour_id, T1.skin_colour_id FROM superhero AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id INNER JOIN colour AS T3 ON T1.skin_colour_id = T3.id INNER JOIN gender AS T4 ON T1.gender_id = T4.id WHERE T2.publisher_name = 'Dark Horse Comics' AND T4.gender = 'Female'
SELECT superhero.superhero_name, publisher.publisher_name FROM superhero JOIN colour ON superhero.hair_colour_id = colour.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.hair_colour_id = superhero.skin_colour_id AND superhero.hair_colour_id = superhero.eye_colour_id
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.superhero_name = 'A-Bomb'
SELECT CAST(SUM(CASE WHEN T2.gender = 'Female' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM superhero AS T1 INNER JOIN gender AS T2 ON T1.gender_id = T2.id INNER JOIN colour AS T3 ON T1.skin_colour_id = T3.id WHERE T3.colour = 'Blue'
SELECT superhero.superhero_name, race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.full_name = 'Charles Chandler'
SELECT gender.gender FROM superhero JOIN gender ON superhero.gender_id = gender.id WHERE superhero.superhero_name = 'Agent 13';
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Adaptation';
SELECT COUNT(*)  FROM hero_power  JOIN superhero ON hero_power.hero_id = superhero.id  WHERE superhero.superhero_name = 'Amazo'
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.full_name = 'Hunter Zolomon'
SELECT superhero.height_cm FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE colour.colour = 'Amber'
SELECT superhero_name FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id AND superhero.hair_colour_id = colour.id WHERE colour.colour = 'Black'
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.skin_colour_id = (SELECT id FROM colour WHERE colour = 'Gold')
SELECT superhero.full_name FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Vampire'
SELECT superhero.superhero_name FROM superhero JOIN alignment ON superhero.alignment_id = alignment.id WHERE alignment.alignment = 'Neutral'
SELECT COUNT(*)  FROM superhero  JOIN hero_attribute ON superhero.id = hero_attribute.hero_id  JOIN attribute ON hero_attribute.attribute_id = attribute.id  WHERE attribute_name = 'Strength'  AND attribute_value = (SELECT MAX(attribute_value) FROM hero_attribute WHERE attribute_id = (SELECT id FROM attribute WHERE attribute_name = 'Strength'))
SELECT race.race, alignment.alignment FROM superhero JOIN race ON superhero.race_id = race.id JOIN alignment ON superhero.alignment_id = alignment.id WHERE superhero.superhero_name = 'Cameron Hicks';
SELECT CAST(SUM(CASE WHEN T2.publisher_name = 'Marvel Comics' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM superhero AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id WHERE T1.gender_id = ( SELECT id FROM gender WHERE gender = 'Female' )
SELECT AVG(weight_kg)  FROM superhero  WHERE race_id = (SELECT id FROM race WHERE race = 'Alien')
SELECT SUM(s1.weight_kg) - SUM(s2.weight_kg) FROM superhero s1, superhero s2 WHERE s1.full_name = 'Emil Blonsky' AND s2.full_name = 'Charles Chandler'
SELECT AVG(height_cm) FROM superhero;
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Abomination'
SELECT COUNT(*)  FROM superhero  WHERE race_id = 21 AND gender_id = 1
SELECT superhero.superhero_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Speed' ORDER BY hero_attribute.attribute_value DESC LIMIT 1;
SELECT COUNT(*) FROM superhero WHERE alignment_id = 3;
SELECT attribute.attribute_name, hero_attribute.attribute_value FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE superhero.superhero_name = '3-D Man'
SELECT superhero_name FROM superhero WHERE eye_colour_id = 7 AND hair_colour_id = 9;
SELECT publisher.publisher_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.superhero_name IN ('Hawkman', 'Karate Kid', 'Speedy')
SELECT COUNT(*) FROM superhero WHERE publisher_id = 1;
SELECT CAST(COUNT(CASE WHEN T2.id = 35 THEN T1.id ELSE NULL END) AS REAL) * 100 / COUNT(T1.id) FROM superhero AS T1 INNER JOIN colour AS T2 ON T1.eye_colour_id = T2.id
SELECT CAST(SUM(CASE WHEN gender_id = 1 THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN gender_id = 2 THEN 1 ELSE 0 END) FROM superhero
SELECT superhero_name FROM superhero WHERE height_cm = (     SELECT MAX(height_cm)     FROM superhero )
SELECT superpower.id FROM superpower WHERE power_name = 'cryokinesis'
SELECT superhero_name FROM superhero WHERE id = 294;
SELECT superhero.full_name FROM superhero WHERE superhero.weight_kg = 0 OR superhero.weight_kg IS NULL;
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.full_name = 'Karen Beecher-Duncan'
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.full_name = 'Helen Parr'
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.weight_kg = 108 AND superhero.height_cm = 188;
SELECT publisher.publisher_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.id = 38;
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id JOIN hero_attribute ON superhero.id = hero_attribute.hero_id WHERE hero_attribute.attribute_value = (     SELECT MAX(attribute_value)     FROM hero_attribute )
SELECT alignment.alignment, superpower.power_name FROM superhero JOIN alignment ON superhero.alignment_id = alignment.id JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Atom IV';
SELECT superhero.full_name FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE colour.colour = 'Blue' LIMIT 5;
SELECT AVG(attribute_value)  FROM hero_attribute  WHERE hero_id IN (     SELECT id      FROM superhero      WHERE alignment_id = 3 )
SELECT colour.colour FROM superhero JOIN colour ON superhero.skin_colour_id = colour.id JOIN hero_attribute ON hero_attribute.hero_id = superhero.id WHERE hero_attribute.attribute_value = 100
SELECT COUNT(*) FROM superhero WHERE alignment_id = 1 AND gender_id = 2
SELECT superhero.superhero_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id WHERE hero_attribute.attribute_value BETWEEN 75 AND 80;
SELECT race.race FROM superhero JOIN colour ON superhero.hair_colour_id = colour.id JOIN gender ON superhero.gender_id = gender.id JOIN race ON superhero.race_id = race.id WHERE colour.colour = 'Blue' AND gender.gender = 'Male'
SELECT CAST(SUM(CASE WHEN T1.gender_id = 2 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id)  FROM superhero AS T1  INNER JOIN gender AS T2 ON T1.gender_id = T2.id  INNER JOIN alignment AS T3 ON T1.alignment_id = T3.id  WHERE T3.alignment = 'Bad'
SELECT COUNT(*) - (SELECT COUNT(*) FROM superhero WHERE weight_kg = 0 OR weight_kg IS NULL) - (SELECT COUNT(*) FROM superhero WHERE eye_colour_id = (SELECT id FROM colour WHERE colour = 'Blue')) - (SELECT COUNT(*) FROM superhero WHERE eye_colour_id = (SELECT id FROM colour WHERE colour = 'No eye color')) FROM superhero;
SELECT hero_attribute.attribute_value FROM hero_attribute JOIN attribute ON hero_attribute.attribute_id = attribute.id JOIN superhero ON hero_attribute.hero_id = superhero.id WHERE superhero.superhero_name = 'Hulk' AND attribute.attribute_name = 'Strength'
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Ajax'
SELECT COUNT(*)  FROM superhero  JOIN colour ON superhero.skin_colour_id = colour.id  JOIN alignment ON superhero.alignment_id = alignment.id  WHERE colour.colour = 'Green' AND alignment.alignment = 'Bad'
SELECT COUNT(*)  FROM superhero  JOIN gender ON superhero.gender_id = gender.id  JOIN publisher ON superhero.publisher_id = publisher.id  WHERE gender.gender = 'Female' AND publisher.publisher_name = 'Marvel Comics'
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Wind Control' ORDER BY superhero.superhero_name ASC;
SELECT gender.gender FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id JOIN gender ON superhero.gender_id = gender.id WHERE superpower.power_name = 'Phoenix Force'
SELECT superhero_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher_name = 'DC Comics' ORDER BY weight_kg DESC LIMIT 1;
SELECT AVG(height_cm)  FROM superhero  JOIN race ON superhero.race_id = race.id  JOIN publisher ON superhero.publisher_id = publisher.id  WHERE race.race <> 'Human'  AND publisher.publisher_name = 'Dark Horse Comics'
SELECT COUNT(*)  FROM superhero  JOIN hero_attribute ON superhero.id = hero_attribute.hero_id  JOIN attribute ON hero_attribute.attribute_id = attribute.id  WHERE attribute.attribute_name = 'Speed' AND hero_attribute.attribute_value = 100
SELECT (SUM(CASE WHEN publisher_name = 'DC Comics' THEN 1 ELSE 0 END) - SUM(CASE WHEN publisher_name = 'Marvel Comics' THEN 1 ELSE 0 END)) AS difference FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id;
SELECT attribute.attribute_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE superhero.superhero_name = 'Black Panther' ORDER BY hero_attribute.attribute_value LIMIT 1;
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.superhero_name = 'Abomination';
SELECT superhero_name FROM superhero WHERE height_cm = (     SELECT MAX(height_cm)     FROM superhero )
SELECT superhero_name FROM superhero WHERE full_name = 'Charles Chandler'
SELECT CAST(SUM(CASE WHEN T2.gender = 'Female' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM superhero AS T1 INNER JOIN gender AS T2 ON T1.gender_id = T2.id INNER JOIN publisher AS T3 ON T1.publisher_id = T3.id WHERE T3.publisher_name = 'George Lucas'
SELECT CAST(SUM(CASE WHEN T2.alignment = 'Good' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM superhero AS T1 INNER JOIN alignment AS T2 ON T1.alignment_id = T2.id WHERE T1.publisher_id = ( SELECT id FROM publisher WHERE publisher_name = 'Marvel Comics' )
SELECT COUNT(*) FROM superhero WHERE full_name LIKE 'John%';
SELECT hero_id FROM hero_attribute WHERE attribute_value = (     SELECT MIN(attribute_value)     FROM hero_attribute )
SELECT superhero.full_name FROM superhero WHERE superhero.superhero_name = 'Alien'
SELECT superhero.full_name FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.weight_kg < 100 AND colour.colour = 'Brown'
SELECT hero_attribute.attribute_value FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id WHERE superhero.superhero_name = 'Aquababy'
SELECT superhero.weight_kg, race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.id = 40;
SELECT AVG(height_cm) FROM superhero JOIN alignment ON superhero.alignment_id = alignment.id WHERE alignment.alignment = 'Neutral'
SELECT superhero.id FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Intelligence'
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.superhero_name = 'Blackwulf';
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.height_cm > (SELECT AVG(height_cm) * 0.8 FROM superhero)
SELECT drivers.driverref FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid WHERE qualifying.raceid = 18 AND qualifying.position <= 15 ORDER BY qualifying.q1 DESC LIMIT 5;
SELECT drivers.surname FROM drivers JOIN qualifying ON drivers.driverid = qualifying.driverid WHERE qualifying.raceid = 19 AND qualifying.q2 = (SELECT MIN(q2) FROM qualifying WHERE raceid = 19)
SELECT races.year FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.location = 'Shanghai'
SELECT circuits.url FROM circuits WHERE circuits.name = 'Circuit de Barcelona-Catalunya'
SELECT races.name FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.country = 'Germany'
SELECT circuits.name, constructorstandings.position FROM circuits JOIN races ON circuits.circuitid = races.circuitid JOIN constructorstandings ON races.raceid = constructorstandings.raceid JOIN constructors ON constructorstandings.constructorid = constructors.constructorid WHERE constructors.name = 'Renault'
SELECT COUNT(*)  FROM races  JOIN circuits ON races.circuitid = circuits.circuitid  JOIN seasons ON races.year = seasons.year  WHERE races.year = 2010  AND circuits.country NOT IN ('Asia', 'Europe')
SELECT races.name FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.country = 'Spain'
SELECT circuits.lat, circuits.lng FROM circuits JOIN races ON races.circuitid = circuits.circuitid WHERE races.name = 'Australian Grand Prix'
SELECT races.url FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Sepang International Circuit'
SELECT races.time FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Sepang International Circuit'
SELECT circuits.lat, circuits.lng FROM circuits JOIN races ON races.circuitid = circuits.circuitid WHERE races.name = 'Abu Dhabi Grand Prix'
SELECT T1.nationality FROM constructors AS T1 INNER JOIN constructorresults AS T2 ON T1.constructorid = T2.constructorid WHERE T2.raceid = 24 AND T2.points = 1
SELECT qualifying.q1 FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid WHERE drivers.forename = 'Bruno' AND drivers.surname = 'Senna' AND qualifying.raceid = 354;
SELECT drivers.nationality FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid WHERE qualifying.q2 = '0:01:40' AND qualifying.raceid = 355;
SELECT qualifying.number FROM qualifying WHERE qualifying.raceid = 903 AND qualifying.q3 = '0:01:54'
SELECT COUNT(*)  FROM results  WHERE raceid = (SELECT raceid FROM races WHERE name = 'Bahrain Grand Prix' AND year = 2007)  AND time IS NULL
SELECT seasons.url FROM races JOIN seasons ON races.year = seasons.year WHERE races.raceid = 901;
SELECT COUNT(*)  FROM results  WHERE raceid = (SELECT raceid FROM races WHERE date = '2015-11-29')  AND positiontext != 'R'
SELECT drivers.forename, drivers.surname FROM drivers JOIN results ON drivers.driverid = results.driverid WHERE results.raceid = 592 AND results.time IS NOT NULL ORDER BY drivers.dob ASC LIMIT 1;
SELECT drivers.forename, drivers.surname, drivers.url FROM drivers JOIN laptimes ON drivers.driverid = laptimes.driverid WHERE laptimes.time = '0:01:27' AND laptimes.raceid = 161;
SELECT drivers.nationality FROM drivers JOIN results ON drivers.driverid = results.driverid WHERE results.raceid = 933 AND results.fastestlapspeed = (     SELECT MAX(fastestlapspeed)     FROM results     WHERE raceid = 933 )
SELECT circuits.lat, circuits.lng FROM circuits JOIN races ON races.circuitid = circuits.circuitid WHERE races.name = 'Malaysian Grand Prix'
SELECT constructors.url FROM constructorstandings JOIN constructors ON constructorstandings.constructorid = constructors.constructorid WHERE constructorstandings.raceid = 9 ORDER BY constructorstandings.points DESC LIMIT 1;
SELECT qualifying.q1 FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid JOIN races ON qualifying.raceid = races.raceid WHERE drivers.forename = 'Lucas' AND drivers.surname = 'di Grassi' AND races.raceid = 345;
SELECT drivers.nationality FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid WHERE qualifying.q2 = '0:01:15' AND qualifying.raceid = 347;
SELECT drivers.code FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid WHERE qualifying.raceid = 45 AND qualifying.q3 = '0:01:33'
SELECT results.time FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE races.raceid = 743 AND drivers.forename = 'Bruce' AND drivers.surname = 'McLaren'
SELECT drivers.forename, drivers.surname FROM drivers JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid WHERE races.name = 'San Marino Grand Prix' AND races.year = 2006 AND results.position = 2
SELECT seasons.url FROM races JOIN seasons ON races.year = seasons.year WHERE races.raceid = 901;
SELECT COUNT(*) FROM results JOIN races ON results.raceid = races.raceid WHERE races.date = '2015-11-29' AND results.positiontext != 'R'
SELECT drivers.forename, drivers.surname FROM drivers JOIN results ON drivers.driverid = results.driverid WHERE results.raceid = 872 AND results.time IS NOT NULL ORDER BY drivers.dob DESC LIMIT 1;
SELECT drivers.forename || ' ' || drivers.surname AS driver_name FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid WHERE laptimes.raceid = 348 ORDER BY laptimes.time ASC LIMIT 1;
SELECT drivers.nationality FROM drivers JOIN results ON drivers.driverid = results.driverid WHERE results.raceid = 348 AND results.fastestlapspeed = (     SELECT MAX(fastestlapspeed)     FROM results     WHERE raceid = 348 )
SELECT CAST(T1.FastestLap AS REAL) / T2.FastestLap FROM results AS T1 INNER JOIN results AS T2 ON T1.RaceID = T2.RaceID - 1 WHERE T1.DriverID = ( SELECT DriverID FROM drivers WHERE Forename = 'Paul' AND Surname = 'di Resta' )
SELECT CAST(COUNT(CASE WHEN T1.time IS NOT NULL THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T1.driverid) FROM results AS T1 INNER JOIN races AS T2 ON T1.raceid = T2.raceid WHERE T2.date = '1983-07-16'
SELECT MIN(year) FROM races WHERE name = 'Singapore Grand Prix';
SELECT COUNT(*), name  FROM races  WHERE year = 2005  GROUP BY name  ORDER BY name DESC
SELECT races.name FROM races WHERE races.date = (     SELECT MIN(date)     FROM races ) UNION SELECT races.name FROM races WHERE strftime('%Y-%m', races.date) = (     SELECT strftime('%Y-%m', MIN(date))     FROM races ) AND races.date != (     SELECT MIN(date)     FROM races )
SELECT races.name, races.date FROM races WHERE races.year = 1999 AND races.round = (SELECT MAX(round) FROM races WHERE year = 1999)
SELECT races.year FROM races GROUP BY races.year HAVING COUNT(races.round) = (     SELECT MAX(round)     FROM races )
SELECT races.name FROM races WHERE races.year = 2017 AND races.name NOT IN (     SELECT races.name     FROM races     WHERE races.year = 2000 )
SELECT circuits.country, circuits.name, circuits.location FROM circuits JOIN races ON circuits.circuitid = races.circuitid WHERE races.name = 'European Grand Prix' ORDER BY races.year ASC LIMIT 1;
SELECT T2.year FROM circuits AS T1 INNER JOIN races AS T2 ON T1.circuitid = T2.circuitid WHERE T1.name = 'Brands Hatch' AND T2.name = 'British Grand Prix' ORDER BY T2.year DESC LIMIT 1
SELECT COUNT(DISTINCT seasons.year) FROM circuits JOIN races ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE circuits.name = 'Silverstone Circuit' AND races.name = 'British Grand Prix'
SELECT drivers.forename, drivers.surname FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE races.name = 'Singapore Grand Prix' AND races.year = 2010 ORDER BY driverstandings.position
SELECT drivers.forename , drivers.surname FROM driverstandings join drivers on driverstandings.driverid = drivers.driverid ORDER BY driverstandings.points DESC LIMIT 1
SELECT drivers.forename, drivers.surname, driverstandings.points FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE races.name = 'Chinese Grand Prix' AND races.year = 2017 ORDER BY driverstandings.points DESC LIMIT 3;
SELECT laptimes.time, drivers.forename, drivers.surname, races.name FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid JOIN races ON laptimes.raceid = races.raceid WHERE laptimes.time = (SELECT MIN(time) FROM laptimes)
SELECT AVG(laptimes.time)  FROM laptimes  JOIN drivers ON laptimes.driverid = drivers.driverid  JOIN races ON laptimes.raceid = races.raceid  WHERE drivers.forename = 'Sebastian'  AND drivers.surname = 'Vettel'  AND races.year = 2009  AND races.name = 'Chinese Grand Prix';
SELECT CAST(SUM(CASE WHEN T1.position > 1 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.position) FROM results AS T1 INNER JOIN races AS T2 ON T1.raceid = T2.raceid INNER JOIN drivers AS T3 ON T1.driverid = T3.driverid WHERE T3.forename = 'Lewis' AND T3.surname = 'Hamilton' AND T2.year >= 2010
SELECT drivers.forename, drivers.surname, drivers.nationality, AVG(driverstandings.points) as average_point_scores FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid GROUP BY drivers.driverid ORDER BY COUNT(driverstandings.wins) DESC LIMIT 1;
SELECT MAX(strftime('%Y', 'now') - strftime('%Y', dob)) AS age, forename  FROM drivers  WHERE nationality = 'Japanese'
SELECT circuits.name FROM circuits JOIN races ON circuits.circuitid = races.circuitid WHERE races.year BETWEEN 1990 AND 2000 GROUP BY circuits.circuitid HAVING COUNT(races.raceid) = 4;
SELECT circuits.name, circuits.location, races.name FROM circuits JOIN races ON circuits.circuitid = races.circuitid JOIN seasons ON races.year = seasons.year WHERE circuits.country = 'USA' AND seasons.year = 2006
SELECT races.name, circuits.name, circuits.location FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE strftime('%m', races.date) = '09' AND races.year = 2005
SELECT races.name FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Alex' AND drivers.surname = 'Yoong' AND results.position < 10
SELECT COUNT(*)  FROM driverstandings ds  JOIN drivers d ON ds.driverid = d.driverid  JOIN races r ON ds.raceid = r.raceid  JOIN circuits c ON r.circuitid = c.circuitid  WHERE d.forename = 'Michael'  AND d.surname = 'Schumacher'  AND c.name = 'Sepang International Circuit'  AND ds.position = 1
SELECT races.name, races.year FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Michael' AND drivers.surname = 'Schumacher' ORDER BY results.milliseconds ASC LIMIT 1;
SELECT AVG(points)  FROM driverstandings  JOIN drivers ON driverstandings.driverid = drivers.driverid  JOIN races ON driverstandings.raceid = races.raceid  WHERE drivers.forename = 'Eddie' AND drivers.surname = 'Irvine' AND races.year = 2000
SELECT races.name, results.points FROM drivers JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' ORDER BY races.year ASC LIMIT 1;
SELECT races.name, circuits.country FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE seasons.year = 2017 ORDER BY races.date ASC;
SELECT races.name, races.year, circuits.location FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE races.laps = (SELECT MAX(laps) FROM races)
SELECT CAST(COUNT(CASE WHEN T1.country = 'Germany' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T1.country) FROM circuits AS T1 INNER JOIN races AS T2 ON T1.circuitid = T2.circuitid WHERE T2.name = 'European Grand Prix'
SELECT circuits.lat, circuits.lng FROM circuits WHERE circuits.name = 'Silverstone Circuit'
SELECT name FROM circuits WHERE lat = (SELECT MAX(lat) FROM circuits)
SELECT circuits.circuitref FROM circuits WHERE circuits.name = 'Marina Bay Street Circuit'
SELECT circuits.country FROM circuits WHERE circuits.alt = (SELECT MAX(alt) FROM circuits)
SELECT COUNT(*) FROM drivers WHERE code IS NULL;
SELECT drivers.nationality FROM drivers WHERE drivers.dob = (SELECT MIN(dob) FROM drivers)
SELECT drivers.surname FROM drivers WHERE drivers.nationality = 'Italian'
SELECT drivers.url FROM drivers WHERE drivers.forename = 'Anthony' AND drivers.surname = 'Davidson'
SELECT driverref FROM drivers WHERE forename = 'Lewis' AND surname = 'Hamilton'
SELECT circuits.name FROM circuits JOIN races ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE races.name = 'Spanish Grand Prix' AND seasons.year = 2009;
SELECT races.year FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Silverstone Circuit'
SELECT races.name, races.date, races.time, races.url FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Silverstone Circuit'
SELECT races.time FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE seasons.year >= 2010 AND seasons.year <= 2019 AND circuits.name = 'Abu Dhabi Circuit'
SELECT COUNT(*)  FROM races  JOIN circuits ON races.circuitid = circuits.circuitid  WHERE circuits.country = 'Italy'
SELECT races.date FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Circuit de Barcelona-Catalunya'
SELECT circuits.url FROM circuits JOIN races ON circuits.circuitid = races.circuitid JOIN seasons ON races.year = seasons.year WHERE races.name = 'Spanish Grand Prix' AND seasons.year = 2009;
SELECT MIN(results.fastestlaptime) FROM results JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'
SELECT drivers.forename, drivers.surname FROM drivers JOIN laptimes ON drivers.driverid = laptimes.driverid JOIN races ON laptimes.raceid = races.raceid JOIN results ON laptimes.raceid = results.raceid AND laptimes.driverid = results.driverid WHERE results.fastestlapspeed = (SELECT MAX(fastestlapspeed) FROM results)
SELECT drivers.driverref FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND driverstandings.position = 1;
SELECT races.name FROM races JOIN drivers ON races.raceid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'
SELECT races.name FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' ORDER BY results.rank ASC LIMIT 1;
SELECT MAX(fastestlapspeed) FROM results WHERE raceid = (SELECT raceid FROM races WHERE name = 'Spanish Grand Prix' AND year = 2009)
SELECT races.year FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'
SELECT results.positionorder FROM results JOIN drivers ON results.driverid = drivers.driverid JOIN races ON results.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND races.year = 2008 AND races.name = 'Australian Grand Prix'
SELECT drivers.forename, drivers.surname FROM drivers JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND results.grid = 4
SELECT COUNT(*)  FROM results  WHERE raceid = 1 AND time IS NOT NULL
SELECT laptimes.time FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid JOIN races ON laptimes.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND races.year = 2008 AND races.name = 'Australian Grand Prix' ORDER BY laptimes.milliseconds ASC LIMIT 1;
SELECT results.time FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND results.positionorder = 2;
SELECT drivers.forename, drivers.surname, drivers.url FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND driverstandings.position = 1;
SELECT COUNT(T1.driverid) FROM drivers AS T1 INNER JOIN results AS T2 ON T1.driverid = T2.driverid WHERE T1.nationality = 'USA' AND T2.raceid = ( SELECT raceid FROM races WHERE name = 'Australian Grand Prix' AND year = 2008 )
SELECT COUNT(DISTINCT drivers.driverid) FROM drivers JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND results.time IS NOT NULL
SELECT SUM(points) FROM driverstandings WHERE driverid = (SELECT driverid FROM drivers WHERE driverref = 'hamilton')
SELECT AVG(CAST(SUBSTR(T1.fastestlaptime, 4, LENGTH(T1.fastestlaptime) - 3) AS REAL)) FROM results AS T1 INNER JOIN drivers AS T2 ON T1.driverid = T2.driverid WHERE T2.forename = 'Lewis' AND T2.surname = 'Hamilton'
SELECT CAST(COUNT(CASE WHEN T1.time IS NOT NULL THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T2.driverid)  FROM laptimes AS T1  INNER JOIN results AS T2 ON T1.raceid = T2.raceid  INNER JOIN races AS R ON T2.raceid = R.raceid  INNER JOIN seasons AS S ON R.year = S.year  WHERE T2.raceid = 1 AND S.year = 2008
SELECT CAST(T1.Time AS REAL) * 100 / T2.Time FROM results AS T1 INNER JOIN races AS T2 ON T1.RaceID = T2.RaceID WHERE T2.Name = 'Australian Grand Prix' AND T2.Year = 2008 ORDER BY T1.Position LIMIT 1, 1
SELECT COUNT(*)  FROM circuits  WHERE location = 'Melbourne' AND country = 'Australia'
SELECT circuits.lat, circuits.lng FROM circuits WHERE circuits.country = 'USA'
SELECT COUNT(*)  FROM drivers  WHERE nationality = 'British' AND dob > '1980-01-01'
SELECT AVG(constructorresults.points)  FROM constructorresults  JOIN constructors ON constructorresults.constructorid = constructors.constructorid  WHERE constructors.nationality = 'British'
SELECT constructors.name FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid ORDER BY constructorstandings.points DESC LIMIT 1;
SELECT constructors.name FROM constructors LEFT JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid WHERE constructorstandings.points = 0 AND constructorstandings.raceid = 291
SELECT COUNT(DISTINCT constructors.constructorid)  FROM constructors  LEFT JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid  LEFT JOIN races ON constructorstandings.raceid = races.raceid  WHERE constructors.nationality = 'Japanese'  AND races.year IN (SELECT year FROM races GROUP BY year HAVING COUNT(raceid) = 2)  AND constructorstandings.points = 0;
SELECT constructors.name FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid WHERE constructorstandings.position = 1
SELECT COUNT(T1.ConstructorID)  FROM constructorresults AS T1  INNER JOIN constructors AS T2 ON T1.ConstructorID = T2.ConstructorID  INNER JOIN races AS T3 ON T1.RaceID = T3.RaceID  INNER JOIN circuits AS T4 ON T3.CircuitID = T4.CircuitID  WHERE T2.Nationality = 'French'  AND T3.round > 50
SELECT CAST(SUM(CASE WHEN T2.driverid IN ( SELECT driverid FROM drivers WHERE nationality = 'Japanese' ) THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.raceid) FROM races AS T1 INNER JOIN results AS T2 ON T1.raceid = T2.raceid WHERE T1.year BETWEEN 2007 AND 2009
SELECT AVG(CAST(SUBSTR(results.time, 1, INSTR(results.time, ':') - 1) AS REAL)), races.year  FROM results  JOIN races ON results.raceid = races.raceid  GROUP BY races.year
SELECT drivers.forename, drivers.surname FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid WHERE drivers.dob > '1975-01-01' AND driverstandings.position = 2
SELECT COUNT(*)  FROM drivers  WHERE nationality = 'Italian'  AND driverid NOT IN (     SELECT driverid      FROM results      WHERE time IS NOT NULL )
SELECT drivers.forename, drivers.surname FROM drivers JOIN laptimes ON drivers.driverid = laptimes.driverid WHERE laptimes.time = (SELECT MIN(time) FROM laptimes)
SELECT MAX(laptimes.lap) FROM laptimes JOIN driverstandings ON laptimes.driverid = driverstandings.driverid JOIN races ON laptimes.raceid = races.raceid JOIN seasons ON races.year = seasons.year WHERE driverstandings.position = 1 AND seasons.year = 2009
SELECT AVG(results.fastestlapspeed) FROM results JOIN races ON results.raceid = races.raceid WHERE races.name = 'Spanish Grand Prix' AND races.year = 2009
SELECT races.name, races.year FROM races WHERE races.time IS NOT NULL ORDER BY races.time ASC LIMIT 1;
SELECT CAST(COUNT(CASE WHEN T1.DOB < '1985' THEN T2.driverid END) AS REAL) * 100 / COUNT(T2.driverid) FROM drivers AS T1 INNER JOIN laptimes AS T2 ON T1.driverid = T2.driverid WHERE T2.lap > 50 AND T2.raceid BETWEEN 2000 AND 2005
SELECT COUNT(*)  FROM drivers  JOIN laptimes ON drivers.driverid = laptimes.driverid  WHERE drivers.nationality = 'French' AND laptimes.time < '02:00.00';
SELECT code FROM drivers WHERE nationality = 'American'
SELECT races.raceid FROM races WHERE races.year = 2009
SELECT COUNT(DISTINCT driverid) FROM results WHERE raceid = 18;
SELECT drivers.code FROM drivers ORDER BY strftime('%Y', drivers.dob) DESC LIMIT 3;
SELECT driverref FROM drivers WHERE forename = 'Robert' AND surname = 'Kubica';
SELECT COUNT(*)  FROM drivers  WHERE nationality = 'Australian' AND dob LIKE '1980-%'
SELECT T1.Forename, T1.Surname FROM drivers AS T1 INNER JOIN laptimes AS T2 ON T1.DriverID = T2.DriverID WHERE T1.Nationality = 'German' AND T1.DOB BETWEEN '1980-01-01' AND '1990-12-31' ORDER BY T2.Time LIMIT 3
SELECT drivers.driverref FROM drivers WHERE drivers.nationality = 'German' AND drivers.dob = (     SELECT MIN(dob)     FROM drivers     WHERE nationality = 'German' )
SELECT drivers.driverid, drivers.code FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid JOIN results ON driverstandings.raceid = results.raceid AND driverstandings.driverid = results.driverid WHERE drivers.dob = '1971' AND results.fastestlaptime IS NOT NULL
SELECT drivers.forename, drivers.surname FROM drivers WHERE drivers.nationality = 'Spanish' AND drivers.dob < '1982' ORDER BY (SELECT MAX(laptimes.time) FROM laptimes WHERE laptimes.driverid = drivers.driverid) LIMIT 10;
SELECT races.year FROM races INNER JOIN results ON races.raceid = results.raceid WHERE results.fastestlaptime IS NOT NULL ORDER BY results.fastestlaptime ASC LIMIT 1;
SELECT races.year FROM laptimes JOIN races ON laptimes.raceid = races.raceid WHERE laptimes.time = (     SELECT MAX(time)     FROM laptimes )
SELECT driverid FROM laptimes WHERE lap = 1 ORDER BY time ASC LIMIT 5
SELECT COUNT(*)  FROM results  WHERE raceid > 50 AND raceid < 100 AND positiontext = 'D' AND statusid = 2;
SELECT COUNT(circuitid) FROM races WHERE circuitid IN ( SELECT circuitid FROM circuits WHERE country = 'Austria' )
SELECT races.round FROM races JOIN results ON races.raceid = results.raceid WHERE results.time IS NOT NULL GROUP BY races.round ORDER BY COUNT(*) DESC LIMIT 1;
SELECT drivers.driverref, drivers.nationality, drivers.dob FROM drivers JOIN qualifying ON drivers.driverid = qualifying.driverid WHERE qualifying.raceid = 23 AND qualifying.q2 IS NOT NULL
SELECT races.year, races.name, races.date, races.time FROM races JOIN qualifying ON races.raceid = qualifying.raceid JOIN drivers ON qualifying.driverid = drivers.driverid WHERE drivers.dob = (SELECT MIN(dob) FROM drivers)
SELECT COUNT(*)  FROM drivers  JOIN results ON drivers.driverid = results.driverid  JOIN status ON results.statusid = status.statusid  WHERE drivers.nationality = 'American' AND status.status = 'Disqualified'
SELECT constructors.name, constructors.url FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid WHERE constructors.nationality = 'Italian' ORDER BY constructorstandings.points DESC LIMIT 1;
SELECT constructors.url FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid GROUP BY constructors.constructorid ORDER BY SUM(constructorstandings.wins) DESC LIMIT 1;
SELECT drivers.forename, drivers.surname FROM drivers JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid JOIN laptimes ON races.raceid = laptimes.raceid AND results.driverid = laptimes.driverid WHERE races.name = 'French Grand Prix' AND laptimes.lap = 3 ORDER BY laptimes.time DESC LIMIT 1;
SELECT races.name, laptimes.time, laptimes.milliseconds FROM races JOIN laptimes ON races.raceid = laptimes.raceid WHERE laptimes.lap = 1 ORDER BY laptimes.milliseconds ASC LIMIT 1;
SELECT AVG(results.fastestlaptime) FROM results JOIN races ON results.raceid = races.raceid WHERE races.name = 'United States Grand Prix' AND races.year = 2006 AND results.rank < 11;
SELECT T1.forename, T1.surname FROM drivers AS T1 INNER JOIN pitstops AS T2 ON T1.driverid = T2.driverid WHERE T1.nationality = 'German' AND T1.dob BETWEEN '1980-01-01' AND '1985-12-31' ORDER BY T2.duration ASC LIMIT 5
SELECT T1.Forename, T1.Surname, T3.Time FROM drivers AS T1 INNER JOIN driverstandings AS T2 ON T1.DriverID = T2.DriverID INNER JOIN results AS T3 ON T2.RaceID = T3.RaceID INNER JOIN races AS T4 ON T3.RaceID = T4.RaceID WHERE T4.name = 'Canadian Grand Prix' AND T4.Year = 2008 ORDER BY T2.Position DESC LIMIT 1
SELECT constructors.constructorref, constructors.url FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid JOIN races ON constructorstandings.raceid = races.raceid WHERE races.name = 'Singapore Grand Prix' AND races.year = 2009 AND constructorstandings.position = 1;
SELECT forename , surname , dob FROM drivers WHERE nationality = 'Austrian' AND dob BETWEEN '1981-01-01' AND '1991-12-31'
SELECT drivers.forename || ' ' || drivers.surname AS full_name, drivers.url, drivers.dob FROM drivers WHERE drivers.nationality = 'German' AND strftime('%Y', drivers.dob) BETWEEN '1971' AND '1985' ORDER BY drivers.dob DESC;
SELECT circuits.location, circuits.country, circuits.lat, circuits.lng FROM circuits WHERE circuits.name = 'Hungaroring'
SELECT constructorstandings.points, constructors.name, constructors.nationality FROM constructorstandings JOIN constructors ON constructorstandings.constructorid = constructors.constructorid JOIN races ON constructorstandings.raceid = races.raceid WHERE races.name = 'Monaco Grand Prix' AND races.year BETWEEN 1980 AND 2010 ORDER BY constructorstandings.points DESC LIMIT 1;
SELECT AVG(points) FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND races.name = 'Turkish Grand Prix'
SELECT CAST(COUNT(raceid) AS REAL) / 10 FROM races WHERE year BETWEEN 2001 AND 2010
SELECT nationality FROM drivers GROUP BY nationality ORDER BY COUNT(*) DESC LIMIT 1;
SELECT COUNT(driverstandings.wins) FROM driverstandings WHERE driverstandings.position = 91
SELECT races.name FROM races INNER JOIN results ON races.raceid = results.raceid WHERE results.fastestlapspeed = (     SELECT MIN(fastestlapspeed)     FROM results )
SELECT circuits.location || ', ' || circuits.country AS full_location FROM circuits JOIN races ON races.circuitid = circuits.circuitid WHERE races.date = (SELECT MAX(date) FROM races)
SELECT T1.Forename, T1.Surname FROM drivers AS T1 INNER JOIN qualifying AS T2 ON T1.DriverID = T2.DriverID WHERE T2.Position = 1 AND T2.RaceID = ( SELECT RaceID FROM races WHERE CircuitID = ( SELECT CircuitID FROM circuits WHERE Name = 'Marina Bay Street Circuit' ) AND Year = 2008 AND Round = 3 )
SELECT drivers.forename , drivers.surname , drivers.nationality , races.name  FROM races  JOIN results ON races.raceid = results.raceid  JOIN drivers ON results.driverid = drivers.driverid  WHERE races.year = 2017  ORDER BY drivers.dob DESC  LIMIT 1
SELECT COUNT(*)  FROM results  JOIN races ON results.raceid = races.raceid  JOIN drivers ON results.driverid = drivers.driverid  WHERE races.name = 'Canadian Grand Prix'  AND results.statusid = 3  AND results.driverid = (     SELECT driverid      FROM (         SELECT driverid, COUNT(*) as num_accidents          FROM results          WHERE statusid = 3          GROUP BY driverid          ORDER BY num_accidents DESC          LIMIT 1     ) )
SELECT COUNT(T1.wins), T2.forename, T2.surname FROM driverstandings AS T1 INNER JOIN drivers AS T2 ON T1.driverid = T2.driverid ORDER BY T2.DOB DESC LIMIT 1
SELECT MAX(duration) FROM pitstops
SELECT MIN(time) FROM laptimes
SELECT MAX(duration) FROM pitstops WHERE driverid = (SELECT driverid FROM drivers WHERE forename = 'Lewis' AND surname = 'Hamilton')
SELECT pitstops.lap FROM pitstops JOIN drivers ON pitstops.driverid = drivers.driverid JOIN races ON pitstops.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND races.year = 2011 AND races.name = 'Australian Grand Prix'
SELECT pitstops.time FROM pitstops JOIN races ON pitstops.raceid = races.raceid JOIN drivers ON pitstops.driverid = drivers.driverid WHERE races.year = 2011 AND races.name = 'Australian Grand Prix'
SELECT laptimes.time FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' ORDER BY laptimes.time ASC LIMIT 1;
SELECT drivers.forename || ' ' || drivers.surname AS driver_name FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid WHERE time = (SELECT MIN(time) FROM laptimes)
SELECT circuits.name, results.position FROM circuits JOIN races ON races.circuitid = circuits.circuitid JOIN results ON results.raceid = races.raceid JOIN drivers ON drivers.driverid = results.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND results.fastestlap = 1
SELECT laptimes.time FROM laptimes JOIN races ON laptimes.raceid = races.raceid JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Austrian Grand Prix Circuit' ORDER BY laptimes.time ASC LIMIT 1;
SELECT circuits.name, laptimes.time FROM circuits JOIN races ON circuits.circuitid = races.circuitid JOIN laptimes ON races.raceid = laptimes.raceid WHERE circuits.country = 'Italy'
SELECT races.name FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN laptimes ON races.raceid = laptimes.raceid WHERE circuits.name = 'Austrian Grand Prix Circuit' ORDER BY laptimes.time ASC LIMIT 1;
SELECT T2.Duration FROM races AS T1 INNER JOIN pitstops AS T2 ON T1.RaceID = T2.RaceID INNER JOIN circuits AS T3 ON T1.CircuitID = T3.CircuitID WHERE T3.name = 'Austrian Grand Prix'
SELECT circuits.lat, circuits.lng FROM circuits JOIN races ON races.circuitid = circuits.circuitid JOIN results ON results.raceid = races.raceid WHERE results.fastestlaptime = '1:29.488'
SELECT AVG(pitstops.duration)  FROM pitstops  JOIN drivers ON pitstops.driverid = drivers.driverid  WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'
SELECT AVG(laptimes.milliseconds) FROM laptimes JOIN races ON laptimes.raceid = races.raceid JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.country = 'Italy'
SELECT player_api_id FROM player_attributes WHERE overall_rating = (     SELECT MAX(overall_rating)     FROM player_attributes )
SELECT MAX(height) FROM player;
SELECT player_attributes.preferred_foot  FROM player_attributes  JOIN player ON player_attributes.player_api_id = player.player_api_id  WHERE player_attributes.potential = (SELECT MIN(potential) FROM player_attributes)
SELECT COUNT(*)  FROM player_attributes  WHERE overall_rating >= 60 AND overall_rating < 65  AND defensive_work_rate = 'low';
SELECT player_api_id FROM player_attributes ORDER BY crossing DESC LIMIT 5;
SELECT league.name FROM league JOIN match ON league.id = match.league_id WHERE match.season = '2015/2016' GROUP BY league.name ORDER BY SUM(match.home_team_goal + match.away_team_goal) DESC LIMIT 1;
SELECT team.team_long_name FROM match JOIN team ON match.home_team_api_id = team.team_api_id WHERE season = '2015/2016' AND (home_team_goal - away_team_goal) < 0 GROUP BY match.home_team_api_id ORDER BY COUNT(*) ASC LIMIT 1;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id ORDER BY player_attributes.penalties DESC LIMIT 10;
SELECT team.team_long_name FROM match JOIN league ON match.league_id = league.id JOIN team ON match.away_team_api_id = team.team_api_id WHERE league.name = 'Scotland Premier League' AND match.season = '2009/2010' AND (match.away_team_goal - match.home_team_goal) > 0 GROUP BY match.away_team_api_id ORDER BY COUNT(*) DESC LIMIT 1;
SELECT team.team_long_name, team_attributes.buildupplayspeed FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildupplayspeed = (SELECT MAX(buildupplayspeed) FROM team_attributes) ORDER BY team_attributes.buildupplayspeed DESC LIMIT 4;
SELECT league.name  FROM match  JOIN league ON match.league_id = league.id  WHERE match.season = '2015/2016'  GROUP BY league.name  HAVING SUM(home_team_goal = away_team_goal) = (SELECT MAX(draws) FROM (SELECT SUM(home_team_goal = away_team_goal) AS draws FROM match WHERE season = '2015/2016' GROUP BY league_id))
SELECT player.player_name, (strftime('%Y', 'now') - strftime('%Y', player.birthday)) - (strftime('%m-%d', 'now') < strftime('%m-%d', player.birthday)) AS age FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.sprint_speed >= 97 AND player_attributes.date >= '2013-01-01 00:00:00' AND player_attributes.date <= '2015-12-31 00:00:00'
SELECT league.name, COUNT(match.id) as total_matches FROM league JOIN match ON league.id = match.league_id GROUP BY league.name ORDER BY total_matches DESC LIMIT 1;
SELECT AVG(height)  FROM player  WHERE birthday >= '1990-01-01 00:00:00' AND birthday < '1996-01-01 00:00:00';
SELECT player_api_id FROM player_attributes WHERE substr(date,1,4) = '2010' AND overall_rating > (SELECT AVG(overall_rating) FROM player_attributes WHERE substr(date,1,4) = '2010')
SELECT team_fifa_api_id FROM team_attributes WHERE buildupplayspeed BETWEEN 51 AND 59
SELECT team.team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildUpPlayPassing > (SELECT AVG(buildUpPlayPassing) FROM team_attributes WHERE buildUpPlayPassing IS NOT NULL) AND strftime('%Y', team_attributes.date) = '2012'
SELECT (SUM(CASE WHEN player_attributes.preferred_foot = 'left' THEN 1 ELSE 0 END) * 100) / COUNT(player_attributes.player_fifa_api_id) FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id AND player_attributes.player_fifa_api_id = player.player_fifa_api_id WHERE player.birthday BETWEEN '1987-01-01 00:00:00' AND '1992-12-31 00:00:00'
SELECT league.name, SUM(match.home_team_goal + match.away_team_goal) AS total_goals FROM league JOIN match ON league.id = match.league_id GROUP BY league.name ORDER BY total_goals ASC LIMIT 5;
SELECT AVG(long_shots)  FROM player_attributes  WHERE player_fifa_api_id = (SELECT player_fifa_api_id FROM player WHERE player_name = 'Ahmed Samir Farag');
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.height > 180 GROUP BY player.player_fifa_api_id ORDER BY AVG(player_attributes.heading_accuracy) DESC LIMIT 10;
SELECT team.team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildupplaydribblingclass = 'Normal' AND team_attributes.date >= '2014-01-01 00:00:00' AND team_attributes.date <= '2014-01-31 00:00:00' AND team_attributes.chancecreationpassing < (SELECT AVG(chancecreationpassing) FROM team_attributes) ORDER BY team_attributes.chancecreationpassing DESC;
SELECT league.name FROM league JOIN match ON league.id = match.league_id WHERE match.season = '2009/2010' GROUP BY league.name HAVING AVG(match.home_team_goal) > AVG(match.away_team_goal)
SELECT team_short_name FROM team WHERE team_long_name = 'Queens Park Rangers';
SELECT player.player_name FROM player WHERE substr(player.birthday, 1, 4) = '1970' AND substr(player.birthday, 6, 2) = '10';
SELECT player_attributes.attacking_work_rate FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Franco Zennaro'
SELECT team_attributes.buildupplaypositioningclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'ADO Den Haag'
SELECT player_attributes.heading_accuracy FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Francois Affolter' AND player_attributes.date = '2014-09-18 00:00:00'
SELECT player_attributes.overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Gabriel Tamas' AND strftime('%Y', player_attributes.date) = '2011'
SELECT COUNT(*)  FROM match  JOIN league ON match.league_id = league.id  WHERE league.name = 'Scotland Premier League' AND match.season = '2015/2016';
SELECT player.preferred_foot FROM player ORDER BY player.birthday DESC LIMIT 1;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.potential = (SELECT MAX(potential) FROM player_attributes)
SELECT COUNT(*)  FROM player  WHERE weight < 130 AND preferred_foot = 'left'
SELECT team.team_short_name FROM team_attributes  JOIN team ON team_attributes.team_api_id = team.team_api_id  WHERE team_attributes.chancecreationpassingclass = 'Risky'
SELECT player_attributes.defensive_work_rate  FROM player_attributes  JOIN player ON player_attributes.player_api_id = player.player_api_id  WHERE player.player_name = 'David Wilson'
SELECT player.birthday FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.overall_rating = (SELECT MAX(overall_rating) FROM player_attributes)
SELECT league.name FROM league JOIN country ON league.country_id = country.id WHERE country.name = 'Netherlands'
SELECT AVG(home_team_goal)  FROM match  JOIN league ON match.league_id = league.id  JOIN country ON league.country_id = country.id  WHERE country.name = 'Poland' AND match.season = '2010/2011';
SELECT player.player_name  FROM player  JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id  WHERE player.height = (SELECT MAX(height) FROM player)  GROUP BY player.player_name  HAVING AVG(player_attributes.finishing) = (SELECT MAX(avg_finishing) FROM (SELECT AVG(finishing) as avg_finishing FROM player_attributes GROUP BY player_api_id) as subquery)   UNION   SELECT player.player_name  FROM player  JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id  WHERE player.height = (SELECT MIN(height) FROM player)  GROUP BY player.player_name  HAVING AVG(player_attributes.finishing) = (SELECT MAX(avg_finishing) FROM (SELECT AVG(finishing) as avg_finishing FROM player_attributes GROUP BY player_api_id) as subquery)
SELECT player.player_name FROM player WHERE player.height > 180;
SELECT COUNT(*) FROM player WHERE strftime('%Y', birthday) > '1990';
SELECT COUNT(*)  FROM player  WHERE player_name LIKE 'Adam%'  AND weight > 170;
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.overall_rating > 80 AND strftime('%Y', player_attributes.date) BETWEEN '2008' AND '2010'
SELECT player_attributes.potential FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.player_name = 'Aaron Doran'
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.preferred_foot = 'left';
SELECT team.team_long_name FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_attributes.buildupplayspeedclass = 'Fast'
SELECT team_attributes.buildupplaypassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_short_name = 'CLB'
SELECT team.team_short_name FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE buildupplaypassing > 70
SELECT AVG(overall_rating)  FROM player_attributes  JOIN player ON player_attributes.player_api_id = player.player_api_id  WHERE strftime('%Y', player_attributes.date) BETWEEN '2010' AND '2015'  AND player.height > 170;
SELECT player_name FROM player ORDER BY height ASC LIMIT 1;
SELECT country.name FROM league JOIN country ON league.country_id = country.id WHERE league.name = 'Italy Serie A';
SELECT team.team_short_name  FROM team_attributes  JOIN team ON team_attributes.team_api_id = team.team_api_id  WHERE buildupplayspeed = 31  AND buildupplaydribbling = 53  AND buildupplaypassing = 32
SELECT AVG(overall_rating)  FROM player_attributes  WHERE player_api_id = (SELECT player_api_id FROM player WHERE player_name = 'Aaron Doran');
SELECT COUNT(*)  FROM match  JOIN league ON match.league_id = league.id  WHERE league.name = 'Germany 1. Bundesliga'  AND strftime('%Y-%m', match.date) BETWEEN '2008-08' AND '2008-10'
SELECT team_short_name FROM team JOIN match ON match.home_team_api_id = team.team_api_id WHERE match.home_team_goal = 10
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.balance = (SELECT MAX(balance) FROM player_attributes WHERE potential = 61) AND player_attributes.potential = 61;
SELECT (SELECT AVG(ball_control) FROM player_attributes WHERE player_api_id = (SELECT player_api_id FROM player WHERE player_name = 'Abdou Diallo')) - (SELECT AVG(ball_control) FROM player_attributes WHERE player_api_id = (SELECT player_api_id FROM player WHERE player_name = 'Aaron Appindangoye'));
SELECT team_long_name FROM team WHERE team_short_name = 'GEN'
SELECT player_name FROM player WHERE player_name = 'Aaron Lennon' OR player_name = 'Abdelaziz Barrada' ORDER BY birthday ASC LIMIT 1;
SELECT player_name FROM player ORDER BY height DESC LIMIT 1;
SELECT COUNT(*)  FROM player_attributes  WHERE preferred_foot = 'left'  AND attacking_work_rate = 'low'
SELECT country.name FROM league JOIN country ON league.country_id = country.id WHERE league.name = 'Belgium Jupiler League';
SELECT league.name FROM league JOIN country ON league.country_id = country.id WHERE country.name = 'Germany';
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.overall_rating = (     SELECT MAX(overall_rating)     FROM player_attributes )
SELECT COUNT(*)  FROM player  JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id  WHERE strftime('%Y', player.birthday)<'1986'  AND player_attributes.defensive_work_rate = 'high'
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.player_name IN ('Alexis', 'Ariel Borysiuk', 'Arouna Kone') ORDER BY player_attributes.crossing DESC LIMIT 1;
SELECT player_attributes.heading_accuracy FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Ariel Borysiuk';
SELECT COUNT(*)  FROM player  JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id  WHERE player.height > 180 AND player_attributes.volleys > 70
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.volleys > 70 AND player_attributes.dribbling > 70
SELECT COUNT(*)  FROM match  JOIN league ON match.league_id = league.id  JOIN country ON league.country_id = country.id  WHERE match.season = '2008/2009' AND country.name = 'Belgium';
SELECT player_attributes.long_passing FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id ORDER BY player.birthday ASC LIMIT 1;
SELECT COUNT(*)  FROM match  JOIN league ON match.league_id = league.id  WHERE league.name = 'Belgium Jupiler League'  AND strftime('%Y', match.date) = '2009'  AND strftime('%m', match.date) = '04';
SELECT league_id FROM match WHERE season = '2008/2009' GROUP BY league_id ORDER BY COUNT(*) DESC LIMIT 1;
SELECT AVG(overall_rating)  FROM player_attributes  JOIN player ON player_attributes.player_api_id = player.player_api_id  WHERE strftime('%Y', player.birthday) < '1986'
SELECT ((pa1.overall_rating - pa2.overall_rating) / pa2.overall_rating) * 100 FROM player_attributes AS pa1 JOIN player_attributes AS pa2 ON pa1.player_api_id = pa2.player_api_id JOIN player AS p1 ON pa1.player_api_id = p1.player_api_id JOIN player AS p2 ON pa2.player_api_id = p2.player_api_id WHERE p1.player_name = 'Ariel Borysiuk' AND p2.player_name = 'Paulin Puel';
SELECT AVG(buildupplayspeed)  FROM team_attributes  WHERE team_api_id = (SELECT team_api_id FROM team WHERE team_long_name = 'Heart of Midlothian')
SELECT AVG(T1.overall_rating) FROM player_attributes AS T1 JOIN player AS T2 ON T1.player_api_id = T2.player_api_id WHERE T2.player_name = 'Pietro Marino'
SELECT SUM(crossing) FROM player_attributes AS T1 JOIN player AS T2 ON T1.player_api_id = T2.player_api_id WHERE T2.player_name = 'Aaron Lennox'
SELECT MAX(chancecreationpassing) AS highest_chance_creation_passing_score, chancecreationpassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_long_name = 'Ajax'
SELECT preferred_foot FROM player WHERE player_name = 'Abdou Diallo'
SELECT MAX(overall_rating)  FROM player_attributes  JOIN player ON player_attributes.player_api_id = player.player_api_id  WHERE player.player_name = 'Dorlan Pabon'
SELECT AVG(away_team_goal) FROM match JOIN team ON match.away_team_api_id = team.team_api_id WHERE team.team_long_name = 'Parma' AND match.country_id IN (SELECT id FROM country WHERE name = 'Italy')
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.overall_rating = 77 AND player_attributes.date = '2016-06-23' ORDER BY player.birthday ASC LIMIT 1;
SELECT player_attributes.overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Aaron Mooy' AND player_attributes.date = '2016-02-04 00:00:00'
SELECT player_attributes.potential FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Francesco Parravicini' AND player_attributes.date = '2010-08-30 00:00:00'
SELECT player_attributes.attacking_work_rate FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Francesco Migliore' AND player_attributes.date = '2015-05-01 00:00:00'
SELECT player_attributes.defensive_work_rate FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Kevin Berigaud' AND player_attributes.date = '2013-02-22 00:00:00'
SELECT MIN(date) FROM player_attributes WHERE player_api_id = (SELECT player_api_id FROM player WHERE player_name = 'Kevin Constant') AND crossing = (SELECT MAX(crossing) FROM player_attributes WHERE player_api_id = (SELECT player_api_id FROM player WHERE player_name = 'Kevin Constant'))
SELECT team_attributes.buildupplayspeedclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Willem II' AND team_attributes.date = '2012-02-22 00:00:00'
SELECT team_attributes.buildupplaydribblingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_short_name = 'LEI' AND team_attributes.date = '2015-09-10 00:00:00'
SELECT team_attributes.buildupplaypassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'FC Lorient' AND team_attributes.date = '2010-02-22'
SELECT team_attributes.chancecreationpassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'PEC Zwolle' AND team_attributes.date = '2013-09-20 00:00:00'
SELECT team_attributes.chancecreationcrossingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Hull City' AND team_attributes.date = '2010-02-22 00:00:00'
SELECT team_attributes.defenceaggressionclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Hannover 96' AND team_attributes.date = '2015-09-10 00:00:00'
SELECT AVG(overall_rating)  FROM player_attributes  JOIN player ON player_attributes.player_api_id = player.player_api_id  WHERE player.player_name = 'Marko Arnautovic'  AND player_attributes.date BETWEEN '2007-02-22 00:00:00' AND '2016-04-21 00:00:00'
SELECT ((p1.overall_rating - p2.overall_rating) / p1.overall_rating) * 100 FROM player_attributes p1 JOIN player_attributes p2 ON p1.player_api_id = p2.player_api_id JOIN player pl1 ON p1.player_api_id = pl1.player_api_id JOIN player pl2 ON p2.player_api_id = pl2.player_api_id WHERE pl1.player_name = 'Landon Donovan' AND pl2.player_name = 'Jordan Bowery' AND p1.date = '2013-07-12' AND p2.date = '2013-07-12'
SELECT player.player_name FROM player ORDER BY player.height DESC LIMIT 5;
SELECT player_api_id FROM player ORDER BY weight DESC LIMIT 10;
SELECT player.player_name FROM player WHERE strftime('%Y', datetime(CURRENT_TIMESTAMP,'localtime')) - strftime('%Y', player.birthday) > 34
SELECT COUNT(match.home_team_goal) FROM match JOIN player ON match.home_player_1 = player.player_api_id WHERE player.player_name = 'Aaron Lennon'
SELECT SUM(match.away_team_goal) FROM match JOIN player_attributes ON match.away_player_1 = player_attributes.player_api_id OR match.away_player_1 = player_attributes.player_api_id JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Daan Smith' OR player.player_name = 'Filipe Ferreira'
SELECT SUM(home_team_goal) FROM match JOIN player ON match.home_player_1 = player.player_api_id OR match.home_player_2 = player.player_api_id OR match.home_player_3 = player.player_api_id OR match.home_player_4 = player.player_api_id OR match.home_player_5 = player.player_api_id OR match.home_player_6 = player.player_api_id OR match.home_player_7 = player.player_api_id OR match.home_player_8 = player.player_api_id OR match.home_player_9 = player.player_api_id OR match.home_player_10 = player.player_api_id OR match.home_player_11 = player.player_api_id WHERE (strftime('%Y', 'now') - strftime('%Y', player.birthday)) <= 30
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.overall_rating = (     SELECT MAX(overall_rating)     FROM player_attributes ) LIMIT 10;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.potential = (SELECT MAX(potential) FROM player_attributes)
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.attacking_work_rate = 'high'
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.finishing = 1 ORDER BY strftime('%Y', 'now') - strftime('%Y', player.birthday) DESC LIMIT 1;
SELECT player.player_name FROM player JOIN country ON player.country_id = country.id WHERE country.name = 'Belgium'
SELECT country.name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id JOIN country ON player.country_id = country.id WHERE player_attributes.vision > 89
SELECT country.name FROM country JOIN player ON country.id = player.country_id GROUP BY country.name HAVING AVG(player.weight) = (     SELECT MAX(avg_weight)     FROM (         SELECT AVG(weight) as avg_weight         FROM player         GROUP BY country_id     ) )
SELECT team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildupplayspeedclass = 'Slow'
SELECT team_short_name FROM team WHERE team_api_id IN (SELECT team_api_id FROM team_attributes WHERE chancecreationpassingclass = 'Safe')
SELECT AVG(player.height) FROM player JOIN country ON player.country_id = country.id WHERE country.name = 'Italy'
SELECT player_name FROM player WHERE height > 180 ORDER BY player_name LIMIT 3;
SELECT COUNT(*)  FROM player  WHERE player_name LIKE 'Aaron%'  AND birthday > '1990-01-01'
SELECT (player_attributes.jumping) - (SELECT jumping FROM player_attributes WHERE id = 23) FROM player_attributes WHERE id = 6
SELECT player_api_id FROM player_attributes WHERE potential = (SELECT MIN(potential) FROM player_attributes) AND preferred_foot = 'right' LIMIT 3;
SELECT COUNT(*)  FROM player_attributes  WHERE crossing = (SELECT MAX(crossing) FROM player_attributes)  AND preferred_foot = 'left'
SELECT COUNT(*) * 100.0 / (SELECT COUNT(*) FROM player_attributes)  FROM player_attributes  WHERE stamina > 80 AND strength > 80;
SELECT country.name FROM country JOIN league ON league.country_id = country.id WHERE league.name = 'Poland Ekstraklasa'
SELECT match.home_team_goal, match.away_team_goal FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Belgian Jupiler League' AND match.date LIKE '2008-09-24%';
SELECT player_attributes.sprint_speed, player_attributes.agility, player_attributes.acceleration FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Alexis Blin'
SELECT team_attributes.buildupplayspeedclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'KSV Cercle Brugge'
SELECT COUNT(*)  FROM match  JOIN league ON match.league_id = league.id  WHERE league.name = 'Italy Serie A' AND match.season = '2015/2016'
SELECT MAX(home_team_goal) FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Netherlands Eredivisie'
SELECT player_attributes.finishing, player_attributes.curve FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.weight = (SELECT MAX(weight) FROM player)
SELECT league.name FROM league JOIN match ON league.id = match.league_id WHERE match.season = '2015/2016' GROUP BY league.name ORDER BY COUNT(match.id) DESC LIMIT 1;
SELECT team.team_long_name FROM team JOIN match ON match.away_team_api_id = team.team_api_id WHERE match.away_team_goal = (     SELECT MAX(away_team_goal)     FROM match )
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.overall_rating = (     SELECT MAX(overall_rating)     FROM player_attributes )
SELECT (COUNT(player_attributes.player_api_id) * 100) / (SELECT COUNT(id) FROM player_attributes) FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.height < 180 AND player_attributes.overall_rating > 70;
SELECT CAST(SUM(CASE WHEN sex = 'M' THEN 1 ELSE 0 END) - SUM(CASE WHEN sex = 'F' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(id) FROM patient
SELECT CAST(SUM(CASE WHEN strftime('%Y', birthday) > '1930' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(id) FROM patient WHERE sex = 'F'
SELECT CAST(SUM(CASE WHEN admission = '+' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(id) FROM patient WHERE birthday BETWEEN '1930-01-01' AND '1940-12-31'
SELECT CAST(SUM(CASE WHEN Admission = '+' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN Admission = '-' THEN 1 ELSE 0 END) FROM patient WHERE Diagnosis = 'SLE'
SELECT examination.diagnosis, laboratory.date FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE patient.id = '30609'
SELECT patient.sex, patient.birthday, examination."examination date", examination.symptoms  FROM patient  JOIN examination ON examination.id = patient.id  WHERE patient.id = '163109'
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.ldh > '500'
SELECT examination.id, (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) as age  FROM patient  JOIN examination ON examination.id = patient.id  WHERE examination.rvvt = '+'
SELECT patient.id, patient.sex, patient.diagnosis FROM examination JOIN patient ON examination.id = patient.id WHERE examination.thrombosis = 2
SELECT T1.id FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.birthday LIKE '1937%' AND T2."t-cho" >= 250
SELECT patient.id, patient.sex, patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.alb < 3.5
SELECT CAST(SUM(CASE WHEN T2.sex = 'F' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM laboratory AS T1 INNER JOIN patient AS T2 ON T1.id = T2.id WHERE T1.tp < 6 OR T1.tp > 8
SELECT AVG(T2.igg) FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.admission = '+' AND T1.birthday > '1969-12-31'
SELECT COUNT(*)  FROM patient  WHERE sex = 'F' AND strftime('%Y', description) = '1997' AND admission = '-'
SELECT MIN(strftime('%Y', patient.birthday) - strftime('%Y', patient.`first date`)) AS age FROM patient
SELECT COUNT(DISTINCT patient.id)  FROM examination  JOIN patient ON examination.id = patient.id  WHERE examination.thrombosis = '1'  AND examination."examination date" LIKE '1997%'  AND patient.sex = 'F'
SELECT MAX(strftime('%Y', birthday)) - MIN(strftime('%Y', birthday))  FROM patient  WHERE id IN (     SELECT id      FROM laboratory      WHERE tg >= 200 )
SELECT examination.symptoms, patient.diagnosis FROM examination JOIN patient ON examination.id = patient.id WHERE patient.birthday = (SELECT MIN(birthday) FROM patient)
SELECT CAST(COUNT(T1.id) AS REAL) / 12 FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.sex = 'M' AND T2.date LIKE '1998%'
SELECT T2.date, T1.birthday, T1.`First Date` - T1.birthday FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.diagnosis = 'SJS' ORDER BY T1.birthday DESC LIMIT 1
SELECT CAST(SUM(CASE WHEN T1.sex = 'M' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN T1.sex = 'F' THEN 1 ELSE 0 END) FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T2.ua > 8
SELECT COUNT(DISTINCT patient.id)  FROM patient  LEFT JOIN examination ON patient.id = examination.id  WHERE (strftime('%Y', examination.`examination date`) - strftime('%Y', patient.`first date`)) >= 1  AND examination.`examination date` IS NULL
SELECT COUNT(DISTINCT examination.id)  FROM examination JOIN patient ON examination.id = patient.id WHERE strftime('%Y', patient.birthday) < 18  AND examination."examination date" BETWEEN '1990-01-01' AND '1993-12-31'
SELECT COUNT(T1.id) FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.sex = 'M' AND T2."t-bil" > 2.0
SELECT diagnosis FROM examination JOIN patient ON examination.id = patient.id WHERE examination_date BETWEEN '1985-01-01' AND '1995-12-31' GROUP BY diagnosis ORDER BY COUNT(diagnosis) DESC LIMIT 1;
SELECT AVG(SUBSTR(T1.Birthday, 1, 4) - 1991) FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T2.`Date` LIKE '1991-10%'
SELECT MAX(HGB), (strftime('%Y', examination.date) - strftime('%Y', patient.birthday)) AS `Age` FROM examination JOIN patient ON examination.id = patient.id ORDER BY HGB DESC LIMIT 1
SELECT T2.ana FROM patient AS T1 INNER JOIN examination AS T2 ON T1.id = T2.id WHERE T1.id = 3605340 AND T2.`Examination Date` = '1996-12-02'
SELECT CASE WHEN `t-cho` < 200 THEN 'low' WHEN `t-cho` > 200 AND `t-cho` < 250 THEN 'normal' WHEN `t-cho` > 250 THEN 'high' END FROM laboratory WHERE id = 2927464 AND `date` = '1995-09-04'
SELECT sex FROM patient WHERE diagnosis = 'AORTITIS'
SELECT examination.`acl igm` FROM examination JOIN patient ON examination.id = patient.id WHERE patient.diagnosis = 'SLE' AND patient.description = '1994-02-19' AND examination.`examination date` = '1993-11-12'
SELECT patient.sex FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.gpt = '9' AND laboratory.date = '1992-06-12'
SELECT strftime('%Y', '1992') - strftime('%Y', T2.Birthday) AS age  FROM laboratory AS T1  INNER JOIN patient AS T2 ON T1.id = T2.id  WHERE T1.ua = '8.4' AND T1.date = '1991-10-21'
SELECT COUNT(laboratory.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.first_date = '1991-06-13' AND patient.diagnosis = 'SJS' AND strftime('%Y', laboratory.date) = '1995'
SELECT T1.diagnosis  FROM patient AS T1  INNER JOIN examination AS T2  ON T1.id = T2.id  WHERE T1.diagnosis = 'SLE'  AND T1.`first date` = '1997-01-27'
SELECT T2.symptoms FROM patient AS T1 INNER JOIN examination AS T2 ON T1.id = T2.id WHERE T1.birthday = '1959-03-01' AND T2.`examination date` = '1993-09-27'
SELECT CAST((SUM(CASE WHEN T2.birthday = '1959-02-18' AND T1.`date` LIKE '1981-11%' THEN T1.`t-cho` ELSE 0 END) - SUM(CASE WHEN T2.birthday = '1959-02-18' AND T1.`date` LIKE '1981-12%' THEN T1.`t-cho` ELSE 0 END)) AS REAL) * 100 / SUM(CASE WHEN T2.birthday = '1959-02-18' AND T1.`date` LIKE '1981-11%' THEN T1.`t-cho` ELSE 0 END) FROM laboratory AS T1 INNER JOIN patient AS T2 ON T1.id = T2.id
SELECT patient.id  FROM patient  JOIN examination ON examination.id = patient.id  WHERE patient.diagnosis = 'Behcet'  AND examination."examination date" >= '1997-01-01'  AND examination."examination date" < '1998-01-01'
SELECT T1.id  FROM patient AS T1  INNER JOIN laboratory AS T2 ON T1.id = T2.id  WHERE T2.gpt > 30 AND T2.alb < 4 AND T1.description BETWEEN '1987-07-06' AND '1996-01-31'
SELECT patient.id FROM patient WHERE patient.sex = 'F' AND strftime('%Y', patient.birthday) = '1964' AND patient.admission = '+'
SELECT COUNT(T1.id)  FROM examination AS T1  INNER JOIN patient AS T2 ON T1.id = T2.id  WHERE T1.thrombosis = 2  AND T1.`Ana pattern` = 'S'  AND T1.`acl igm` = T1.`acl igm` * 1.2
SELECT CAST(SUM(CASE WHEN T1.ua < 6.5 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM laboratory AS T1 INNER JOIN patient AS T2 ON T1.id = T2.id WHERE T2.diagnosis = 'Proteinuria'
SELECT (SELECT      (COUNT(DISTINCT patient.id) * 100) / (SELECT COUNT(DISTINCT patient.id) FROM patient WHERE strftime('%Y', patient.`first date`) = '1981' AND patient.sex = 'M') FROM examination INNER JOIN patient ON examination.id = patient.id WHERE strftime('%Y', patient.`first date`) = '1981' AND patient.diagnosis = 'BEHCET' AND patient.sex = 'M')
SELECT T1.id FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T2.`date` LIKE '1991-10%' AND T2.`t-bil` < 2.0
SELECT COUNT(T1.id) FROM patient AS T1 INNER JOIN examination AS T2 ON T1.id = T2.id WHERE T1.sex = 'F' AND T1.birthday BETWEEN '1980-01-01' AND '1989-12-31' AND T2.`ANA Pattern` != 'P'
SELECT patient.sex FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE examination.diagnosis = 'PSS' AND laboratory.crp = '2+' AND laboratory.cre = 1 AND laboratory.ldh = 123;
SELECT AVG(laboratory.alb) FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE patient.sex = 'F' AND laboratory.plt > 400 AND patient.diagnosis = 'SLE'
SELECT symptoms FROM examination WHERE diagnosis = 'SLE' GROUP BY symptoms ORDER BY COUNT(*) DESC LIMIT 1;
SELECT `first date`, diagnosis FROM patient WHERE id = 48473
SELECT COUNT(*)  FROM patient  WHERE sex = 'F' AND diagnosis = 'APS'
SELECT COUNT(DISTINCT examination.id)  FROM examination  JOIN patient ON examination.id = patient.id  JOIN laboratory ON examination.id = laboratory.id  WHERE strftime('%Y', date) = '1997'  AND (laboratory.tp < 6 OR laboratory.tp > 8.5)
SELECT CAST(SUM(CASE WHEN T1.diagnosis = 'SLE' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM patient AS T1 INNER JOIN examination AS T2 ON T1.id = T2.id WHERE T2.symptoms = 'thrombocytopenia'
SELECT CAST(SUM(CASE WHEN sex = 'F' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(id) FROM patient WHERE birthday LIKE '1980%' AND diagnosis = 'RA'
SELECT COUNT(DISTINCT patient.id)  FROM patient  JOIN examination ON examination.id = patient.id  WHERE patient.sex = 'M'  AND examination.`examination date` BETWEEN '1995-01-01' AND '1997-12-31'  AND patient.diagnosis = 'BEHCET'  AND patient.admission = '-'
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'F' AND laboratory.wbc < 3.5
SELECT examination.`examination date` - patient.`first date` FROM examination join patient on examination.id = patient.id WHERE patient.id = 821298
SELECT CASE WHEN T2.ua > 3.5 AND T2.ua < 7 THEN 'yes' ELSE 'no' END FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.id = 57266
SELECT laboratory.date FROM laboratory WHERE laboratory.id = '48473' AND laboratory.got >= 60;
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.got < 60 AND strftime('%Y', laboratory.date) = '1994'
SELECT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.gpt >= 60
SELECT patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.gpt > 60 ORDER BY patient.birthday ASC
SELECT AVG(ldh) FROM laboratory WHERE ldh < 500
SELECT patient.id, (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) as age FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.ldh BETWEEN 600 AND 800
SELECT patient.admission FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.alp < 300
SELECT patient.id FROM patient WHERE patient.birthday = '1982-04-01' AND       (SELECT laboratory.alp FROM laboratory WHERE laboratory.id = patient.id) < 300;
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tp < 6.0
SELECT T2.TP - 8.5 FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.sex = 'F' AND T2.TP > 8.5
SELECT patient.id, patient.sex, patient.birthday, patient.description, patient.admission, patient.diagnosis  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE patient.sex = 'M' AND (laboratory.alb <= 3.5 OR laboratory.alb >= 5.5)  ORDER BY patient.birthday DESC;
SELECT CASE WHEN T2.alb BETWEEN 3.5 AND 5.5 THEN 'yes' ELSE 'no' END FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.birthday LIKE '1982%'
SELECT CAST(SUM(CASE WHEN T1.UA > 6.5 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM laboratory AS T1 INNER JOIN patient AS T2 ON T1.id = T2.id WHERE T2.sex = 'F'
SELECT AVG(ua) AS average_ua_index FROM laboratory JOIN patient ON laboratory.id = patient.id WHERE (ua < 8.0 AND patient.sex = 'M') OR (ua < 6.5 AND patient.sex = 'F')
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.un = 29
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.diagnosis = 'RA' AND laboratory.un < 30
SELECT COUNT(*)  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE patient.sex = 'M' AND laboratory.cre >= 1.5
SELECT CASE WHEN SUM(CASE WHEN sex = 'M' THEN 1 ELSE 0 END) - SUM(CASE WHEN sex = 'F' THEN 1 ELSE 0 END) > 0 THEN 'TRUE' ELSE 'FALSE' END  FROM patient  WHERE id IN (SELECT id FROM laboratory WHERE cre > 1.5)
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory."t-bil" = (SELECT MAX("t-bil") FROM laboratory)
SELECT patient.sex, COUNT(*) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory."t-bil" >= 2.0 GROUP BY patient.sex
SELECT patient.id, MAX(laboratory."t-cho") as "T-CHO index" FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.birthday = (SELECT MIN(birthday) FROM patient) GROUP BY patient.id;
SELECT AVG(CAST(STRFTIME('%Y', T2.birthday) AS INT)) FROM laboratory AS T1 INNER JOIN patient AS T2 ON T1.id = T2.id WHERE T1."t-cho" >= 250 AND T2.sex = 'M'
SELECT patient.id, patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tg > 300
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tg >= 200 AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) > 50;
SELECT DISTINCT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.admission = '-' AND laboratory.cpk < 250;
SELECT COUNT(T1.id) FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.sex = 'M' AND T1.birthday BETWEEN '1936-01-01' AND '1956-12-31' AND T2.cpk > 100
SELECT T1.ID, T1.SEX, T1.BIRTHDAY FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.ID = T2.ID WHERE T2.GLU > 6.1 AND T2.GLU < 11.1 AND T2."T-CHO" > 1.7 AND T2."T-CHO" < 5.2
SELECT patient.id, laboratory.glu FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.glu < 180 AND strftime('%Y', patient.description) >= '1991'
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.wbc <= 3.5 OR laboratory.wbc >= 9.0 GROUP BY patient.sex, patient.birthday ORDER BY patient.birthday ASC
SELECT T1.diagnosis, T1.ID, T1.birthday FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.ID = T2.ID WHERE T2.rbc < 3.5
SELECT patient.id, patient.admission FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE patient.sex = 'F' AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) >= 50 AND (laboratory.rbc <= 3.5 OR laboratory.rbc >= 6.0)
SELECT patient.id, patient.sex FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE patient.admission = '-' AND laboratory.hgb < 10;
SELECT patient.id, patient.sex  FROM patient  JOIN examination ON examination.id = patient.id  WHERE patient.diagnosis = 'SLE' AND examination.id IN (     SELECT examination.id      FROM examination      JOIN laboratory ON laboratory.id = examination.id      WHERE laboratory.hgb > 10 AND laboratory.hgb < 17     )  ORDER BY patient.birthday ASC LIMIT 1;
SELECT patient.id, (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) as age  FROM patient JOIN laboratory on patient.id = laboratory.id GROUP BY patient.id, age HAVING COUNT(laboratory.id) > 2 AND MAX(laboratory.hct) >= 52;
SELECT AVG(hct)  FROM laboratory  WHERE date LIKE '1991%' AND hct < 29;
SELECT SUM(CASE WHEN T2.plt < 100 THEN 1 ELSE 0 END) , SUM(CASE WHEN T2.plt > 100 THEN 1 ELSE 0 END) FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id
SELECT T1.id FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T2.date LIKE '1984%' AND T1.birthday < '1984-01-01' AND T2.plt BETWEEN 100 AND 400
SELECT CAST(SUM(CASE WHEN T1.sex = 'F' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T1.birthday > '1955-01-01' AND T2.pt > 14
SELECT patient.id FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE strftime('%Y', patient.`First Date`) > '1992' AND laboratory.pt < 14;
SELECT COUNT(*)  FROM examination  WHERE `Examination Date` > '1997-01-01'  AND aptt = 'inactivated'
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN laboratory ON examination.id = laboratory.id WHERE aptt > 45 AND thrombosis = 3
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE patient.sex = 'M' AND laboratory.wbc >= 3.5 AND laboratory.wbc <= 9.0 AND (laboratory.fg < 150 OR laboratory.fg > 450)
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE patient.birthday > '1980-01-01' AND laboratory.fg NOT BETWEEN 150 AND 450;
SELECT examination.diagnosis  FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON examination.id = laboratory.id WHERE laboratory.u_pro >= 30;
SELECT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE u-pro > 0 AND u-pro < 30 AND diagnosis = 'SLE'
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id WHERE examination."acl igg" < 900 AND examination.symptoms = 'abortion'
SELECT COUNT(T1.id)  FROM examination AS T1  INNER JOIN patient AS T2 ON T1.id = T2.id  WHERE T1."acl igg" BETWEEN 900 AND 2000  AND T1.symptoms IS NOT NULL
SELECT examination.diagnosis FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE laboratory.iga BETWEEN 80 AND 500 ORDER BY laboratory.iga DESC LIMIT 1;
SELECT COUNT(*) FROM examination, patient, laboratory WHERE examination.id = patient.id AND laboratory.id = patient.id AND patient.diagnosis != 'Normal' AND patient.description >= '1990-01-01' AND laboratory.iga BETWEEN 80 AND 500;
SELECT examination.diagnosis  FROM examination  JOIN patient ON examination.id = patient.id  WHERE examination."acl igm" < 40 OR examination."acl igm" > 400  GROUP BY examination.diagnosis  ORDER BY COUNT(*) DESC  LIMIT 1;
SELECT COUNT(T1.id) FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T2.crp = 0 AND T1.description = ''
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE crp NOT IN('+-', '-') AND crp >= 1.0 AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) < 18;
SELECT COUNT(DISTINCT examination.id)  FROM examination  JOIN patient ON examination.id = patient.id  WHERE examination.diagnosis = 'Normal' AND examination.kct = '+';
SELECT T1.diagnosis  FROM patient AS T1  INNER JOIN laboratory AS T2 ON T1.id = T2.id  WHERE T1.birthday > '1995-01-01' AND T2.rf = '+-'
SELECT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE rf < 20 AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) > 60;
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE rf < 20 AND thrombosis = '0';
SELECT COUNT(DISTINCT patient.id)  FROM patient  JOIN examination ON examination.id = patient.id  JOIN laboratory ON laboratory.id = patient.id  WHERE examination."ana pattern" = 'P'  AND laboratory.c3 > 35
SELECT T1.id FROM patient AS T1 INNER JOIN examination AS T2 ON T1.id = T2.id WHERE T2."acl iga" != 'Normal' ORDER BY T2."acl iga" DESC LIMIT 1
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE examination.thrombosis > 0 AND laboratory.c4 > 10
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.admission = '+' AND laboratory.rnp IN ('-', '+-')
SELECT T1.birthday FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T2.rnp = 'abnormal' ORDER BY T1.birthday DESC LIMIT 1
SELECT COUNT(T1.id) FROM patient AS T1 INNER JOIN examination AS T2 ON T1.id = T2.id WHERE T2."ana pattern" = 'negative' AND T2.thrombosis = 3
SELECT examination.id FROM examination WHERE examination.id IN (     SELECT patient.id     FROM patient     WHERE patient.diagnosis = 'abnormal anti-SM'     ORDER BY patient.birthday ASC     LIMIT 3 )
SELECT patient.id  FROM examination  JOIN patient ON examination.id = patient.id  WHERE "examination date" >= '1997-01-01'  AND "sc170" = 'negative'
SELECT COUNT(DISTINCT patient.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE examination.diagnosis = 'Normal' AND laboratory.sc170 IN ('-', '+-') AND patient.sex = 'M' AND examination.symptoms = 'vertigo'
SELECT COUNT(DISTINCT patient.id)  FROM examination  JOIN patient ON examination.id = patient.id  WHERE examination.ssa IN ('-', '+-')  AND YEAR(patient.first_date) < 1990;
SELECT patient.id FROM patient JOIN examination ON patient.id = examination.id JOIN laboratory ON patient.id = laboratory.id WHERE patient.id IN      (SELECT id     FROM laboratory     WHERE ssa NOT IN ('-', '+-')     ORDER BY date ASC     LIMIT 1) ORDER BY patient.`first date` ASC LIMIT 1;
SELECT COUNT(DISTINCT examination.id)  FROM examination  JOIN patient ON examination.id = patient.id  JOIN laboratory ON laboratory.id = patient.id  WHERE examination.diagnosis = 'SLE'  AND laboratory.ssb IN ('negative', '0')
SELECT COUNT(DISTINCT examination.id) FROM examination INNER JOIN patient ON examination.id = patient.id WHERE examination.id IN  (SELECT laboratory.id FROM laboratory WHERE ssb = 'negative')  AND examination.symptoms IS NOT NULL;
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE centromea IN ('-', '+-') AND ssb IN ('-', '+-') AND sex = 'M'
SELECT examination.diagnosis FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE laboratory.dna >= 8
SELECT COUNT(DISTINCT examination.id) FROM examination LEFT JOIN laboratory ON examination.id = laboratory.id LEFT JOIN patient ON examination.id = patient.id WHERE examination.diagnosis = 'Normal' AND laboratory.dna < 8 AND patient.description IS NULL;
SELECT COUNT(T1.id) FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T2.`DNA-II` > 8 AND T1.admission = '+'
SELECT CAST(SUM(CASE WHEN T1.diagnosis = 'SLE' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.id) FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T2.got > 40
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.got < 60;
SELECT MIN(patient.birthday) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.got >= 60
SELECT patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.gpt < 60 ORDER BY laboratory.gpt DESC LIMIT 3;
SELECT COUNT(*)  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE got < 60 AND sex = 'M'
SELECT MIN(laboratory.date) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.ldh < 500 ORDER BY laboratory.ldh DESC LIMIT 1;
SELECT T2.date FROM patient AS T1 INNER JOIN laboratory AS T2 ON T1.id = T2.id WHERE T2.ldh > 500 ORDER BY T2.date DESC LIMIT 1
SELECT COUNT(*)  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE alp >= 300 AND admission = '+';
SELECT COUNT(*)  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE patient.admission = '-' AND laboratory.alp < 300;
SELECT patient.diagnosis FROM patient join laboratory on patient.id = laboratory.id WHERE laboratory.tp < 6.0
SELECT COUNT(*)  FROM patient  JOIN examination ON patient.id = examination.id  JOIN laboratory ON patient.id = laboratory.id  WHERE patient.diagnosis = 'SJS'  AND laboratory.tp > 6.0  AND laboratory.tp < 8.5;
SELECT examination."examination date"  FROM examination  JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE laboratory.alb > 3.5 AND laboratory.alb < 5.5  ORDER BY laboratory.alb DESC  LIMIT 1;
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.alb > 3.5 AND laboratory.alb < 5.5 AND laboratory.tp > 6.0 AND laboratory.tp < 8.5;
SELECT MAX(ua)  FROM laboratory  WHERE ua <= 6.50  AND id IN (SELECT id FROM patient WHERE sex = 'F')
SELECT MAX(ana)  FROM examination  JOIN laboratory ON examination.id = laboratory.id  JOIN patient ON examination.id = patient.id  WHERE cre < 1.5 AND ana IS NOT NULL;
SELECT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.cre < 1.5 ORDER BY laboratory.iga DESC LIMIT 1;
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE laboratory."t-bil" >= 2.0 AND examination."ana pattern" LIKE '%P%';
SELECT examination.`ana` FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE laboratory.`t-bil` < 2.0 ORDER BY laboratory.`t-bil` DESC LIMIT 1;
SELECT COUNT(DISTINCT examination.id) FROM examination INNER JOIN laboratory ON examination.id = laboratory.id WHERE laboratory."t-cho" >= 250 AND examination.kct = '-'
SELECT COUNT(T1.id)  FROM examination AS T1  INNER JOIN patient AS T2 ON T1.id = T2.id  WHERE T1."ANA pattern" = 'P'  AND T2.diagnosis = 'ANA'  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000  AND T1."ACL IGA" > 100  AND T1."ACL IGG" > 100  AND T1."ACL IGM" > 100  AND T1."ACL IGA" < 1000  AND T1."ACL IGG" < 1000  AND T1."ACL IGM" < 1000
SELECT COUNT(*)  FROM patient  JOIN laboratory ON patient.id = laboratory.id  JOIN examination ON patient.id = examination.id  WHERE tg < 200 AND symptoms IS NOT NULL
SELECT patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tg < 200 ORDER BY laboratory.tg DESC LIMIT 1;
SELECT patient.id FROM patient LEFT JOIN examination ON examination.id = patient.id LEFT JOIN laboratory ON laboratory.id = patient.id WHERE examination.thrombosis = 0 AND laboratory.cpk < 250;
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE laboratory.cpk < 250 AND (examination.kct = '+' OR examination.rvvt = '+' OR examination.lac = '+')
SELECT MIN(patient.birthday) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.glu > 180
SELECT COUNT(*)  FROM patient  JOIN laboratory ON patient.id = laboratory.id  JOIN examination ON patient.id = examination.id  WHERE glu < 180 AND thrombosis = 0
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.admission = '+' AND laboratory.wbc >= 3.5 AND laboratory.wbc <= 9.0;
SELECT COUNT(*)  FROM patient  WHERE diagnosis = 'SLE'  AND EXISTS (     SELECT *      FROM laboratory      WHERE laboratory.id = patient.id      AND wbc >= 3.5      AND wbc <= 9.0 )
SELECT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE (laboratory.rbc < 3.5 OR laboratory.rbc > 6.0) AND patient.admission = '-'
SELECT COUNT(T1.id) FROM patient AS T1 INNER JOIN examination AS T2 ON T1.id = T2.id INNER JOIN laboratory AS T3 ON T1.id = T3.id WHERE T3.plt > 100 AND T3.plt < 400 AND T1.diagnosis = 'Normal'
SELECT l.plt FROM patient p JOIN examination e ON p.id = e.id JOIN laboratory l ON p.id = l.id WHERE p.diagnosis = 'MCTD' AND l.plt > 100 AND l.plt < 400;
SELECT AVG(T1.pt) FROM laboratory AS T1 INNER JOIN patient AS T2 ON T1.id = T2.id WHERE T2.sex = 'M' AND T1.pt = 'Normal'
SELECT COUNT(*) FROM examination JOIN laboratory ON examination.id = laboratory.id WHERE thrombosis IN (1, 2) AND pt < 14
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Angela' AND member.last_name = 'Sanders'
SELECT COUNT(*)  FROM member  JOIN major ON member.link_to_major = major.major_id  WHERE major.college = 'College of Engineering'
SELECT member.first_name || ' ' || member.last_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.department = 'Art and Design Department'
SELECT COUNT(*)  FROM attendance  JOIN event ON attendance.link_to_event = event.event_id  JOIN member ON attendance.link_to_member = member.member_id  WHERE event.event_name = "Women's Soccer"
SELECT member.phone FROM member JOIN attendance ON attendance.link_to_member = member.member_id JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = "Women's Soccer"
SELECT COUNT(*)  FROM attendance  JOIN member ON attendance.link_to_member = member.member_id  JOIN event ON attendance.link_to_event = event.event_id  WHERE event.event_name = "Women's Soccer" AND member.t_shirt_size = 'Medium'
SELECT event.event_name FROM event JOIN attendance ON event.event_id = attendance.link_to_event GROUP BY event.event_id ORDER BY COUNT(attendance.link_to_member) DESC LIMIT 1;
SELECT college FROM member JOIN major ON member.link_to_major = major.major_id WHERE position = 'Vice President'
SELECT event.event_name FROM event JOIN attendance ON attendance.link_to_event = event.event_id JOIN member ON member.member_id = attendance.link_to_member WHERE member.first_name = 'Maya' AND member.last_name = 'Mclean';
SELECT COUNT(*)  FROM attendance  JOIN member ON attendance.link_to_member = member.member_id  JOIN event ON attendance.link_to_event = event.event_id  WHERE member.first_name = 'Sacha' AND member.last_name = 'Harrison' AND strftime('%Y', event.event_date) = '2019'
SELECT COUNT(event_id) FROM event WHERE type = 'Meeting' AND event_id IN (     SELECT link_to_event     FROM attendance     GROUP BY link_to_event     HAVING COUNT(link_to_member) > 10 )
SELECT event_name FROM event WHERE event_id IN ( SELECT link_to_event FROM attendance GROUP BY link_to_event HAVING COUNT(*) > 20 )
SELECT AVG(event_count / event_name_count) FROM (     SELECT COUNT(event_id) AS event_count, COUNT(DISTINCT event_name) AS event_name_count     FROM event     WHERE type = 'Meeting' AND strftime('%Y', event_date) = '2020' ) AS subquery
SELECT expense_description FROM expense WHERE cost = (     SELECT MAX(cost)     FROM expense )
SELECT COUNT(*)  FROM member  JOIN major ON member.link_to_major = major.major_id  WHERE major.major_name = 'Environmental Engineering'
SELECT member.first_name , member.last_name FROM attendance join member on attendance.link_to_member = member.member_id join event on attendance.link_to_event = event.event_id WHERE event.event_name = 'Laugh Out Loud'
SELECT member.last_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Law and Constitutional Studies'
SELECT county FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Sherri' AND member.last_name = 'Ramsey'
SELECT college FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Tyler' AND member.last_name = 'Hewitt'
SELECT SUM(income.amount) FROM member JOIN income ON member.member_id = income.link_to_member WHERE member.position = 'Vice President'
SELECT SUM(expense.cost)  FROM expense  JOIN member ON expense.link_to_member = member.member_id  JOIN budget ON expense.link_to_budget = budget.budget_id  JOIN event ON budget.link_to_event = event.event_id  WHERE event.event_name = 'September Meeting'  AND budget.category = 'Food'
SELECT T2.city, T2.state FROM member AS T1 INNER JOIN zip_code AS T2 ON T1.zip = T2.zip_code WHERE T1.position = 'President'
SELECT member.first_name || ' ' || member.last_name FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE zip_code.state = 'Illinois'
SELECT SUM(T2.cost) FROM event AS T1 INNER JOIN expense AS T2 ON T1.event_id = T2.link_to_budget WHERE T1.event_name = 'September Meeting' AND T2.expense_description = 'Advertisement'
SELECT department FROM major JOIN member ON member.link_to_major = major.major_id WHERE member.first_name = 'Pierce' AND member.last_name = 'Guidi'
SELECT SUM(amount)  FROM budget  WHERE link_to_event = (SELECT event_id FROM event WHERE event_name = 'October Speaker')
SELECT expense.approved FROM expense JOIN event ON expense.link_to_budget = event.event_id WHERE event.event_name = 'October Meeting' AND event.event_date = '2019-10-08'
SELECT AVG(expense.cost) AS average_cost FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.first_name = 'Elijah' AND member.last_name = 'Allen' AND (strftime('%m', expense.expense_date) = '09' OR strftime('%m', expense.expense_date) = '10')
SELECT SUM(CASE WHEN strftime('%Y', event_date) = '2019' THEN spent ELSE 0 END) - SUM(CASE WHEN strftime('%Y', event_date) = '2020' THEN spent ELSE 0 END) AS difference FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE strftime('%Y', event_date) IN ('2019', '2020')
SELECT event.location FROM event WHERE event.event_name = 'Spring Budget Review'
SELECT expense.cost FROM expense WHERE expense.expense_description = 'Posters' AND expense.expense_date = '2019-09-04'
SELECT MAX(b.remaining) FROM budget b WHERE b.category = 'Food'
SELECT income.notes FROM income WHERE income.source = 'Fundraising' AND income.date_received = '2019-09-14'
SELECT COUNT(*) FROM major WHERE college = "College of Humanities and Social Sciences"
SELECT member.phone FROM member WHERE member.first_name = 'Carlo' AND member.last_name = 'Jacobs'
SELECT T2.county FROM member AS T1 INNER JOIN zip_code AS T2 ON T1.zip = T2.zip_code WHERE T1.first_name = 'Adela' AND T1.last_name = 'O''Gallagher'
SELECT COUNT(*)  FROM budget  WHERE link_to_event = (SELECT event_id FROM event WHERE event_name = 'November Meeting')  AND remaining < 0;
SELECT SUM(amount) FROM budget WHERE link_to_event = (SELECT event_id FROM event WHERE event_name = 'September Speaker')
SELECT T1.status FROM event AS T1 INNER JOIN expense AS T2 ON T1.event_id = T2.link_to_budget WHERE T2.expense_description = 'Post Cards, Posters' AND T2.expense_date = '2019-08-20'
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Brent' AND member.last_name = 'Thomason'
SELECT COUNT(*)  FROM member  JOIN major ON member.link_to_major = major.major_id  WHERE major.major_name = 'Human Development and Family Studies'  AND member.t_shirt_size = 'Large'
SELECT zip_code.type FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Christof' AND member.last_name = 'Nielson'
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'Vice President'
SELECT zip_code.state FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Sacha' AND member.last_name = 'Harrison'
SELECT major.department FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'President'
SELECT income.date_received FROM income JOIN member ON income.link_to_member = member.member_id WHERE member.first_name = 'Connor' AND member.last_name = 'Hilton' AND income.source = 'Dues'
SELECT member.first_name || ' ' || member.last_name AS full_name FROM income JOIN member ON income.link_to_member = member.member_id WHERE income.source = 'Dues' ORDER BY income.date_received LIMIT 1;
SELECT COUNT(T1.event_name) FROM event AS T1 INNER JOIN budget AS T2 ON T1.event_id = T2.link_to_event WHERE T1.event_name = 'Yearly Kickoff' AND T2.category = 'Advertisement' AND T1.event_name != 'October Meeting'
SELECT CAST(SUM(CASE WHEN T2.category = 'Parking' THEN T2.amount ELSE 0 END) AS REAL) * 100 / SUM(T2.amount) FROM event AS T1 INNER JOIN budget AS T2 ON T1.event_id = T2.link_to_event WHERE T1.event_name = 'November Speaker'
SELECT SUM(cost)  FROM expense  WHERE expense_description = 'Pizza'
SELECT COUNT(DISTINCT city) FROM zip_code WHERE county = 'Orange County' AND state = 'Virginia'
SELECT major.department FROM major WHERE major.college = 'College of Humanities and Social Sciences'
SELECT zip_code.city, zip_code.county, zip_code.state FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Amy' AND member.last_name = 'Firth'
SELECT expense.expense_description FROM budget JOIN expense ON budget.budget_id = expense.link_to_budget WHERE budget.remaining = (SELECT MIN(remaining) FROM budget)
SELECT member.first_name, member.last_name FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'October Meeting'
SELECT major.college FROM member JOIN major ON member.link_to_major = major.major_id GROUP BY major.college ORDER BY COUNT(*) DESC LIMIT 1;
SELECT major.major_name FROM member JOIN zip_code ON member.zip = zip_code.zip_code JOIN major ON member.link_to_major = major.major_id WHERE member.phone = '809-555-3360'
SELECT event_name FROM event WHERE event_id = (     SELECT link_to_event     FROM budget     WHERE amount = (         SELECT MAX(amount)         FROM budget     ) )
SELECT expense.* FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.position = 'Vice President'
SELECT COUNT(*) FROM attendance WHERE link_to_event = ( SELECT event_id FROM event WHERE event_name = 'Women''s Soccer' )
SELECT income.date_received FROM income JOIN member ON income.link_to_member = member.member_id WHERE member.first_name = 'Casey' AND member.last_name = 'Mason'
SELECT COUNT(*)  FROM member  JOIN zip_code ON member.zip = zip_code.zip_code  WHERE zip_code.state = 'Maryland'
SELECT COUNT(*)  FROM attendance  JOIN member ON attendance.link_to_member = member.member_id  WHERE member.phone = "954-555-6240"
SELECT member.first_name, member.last_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.department = 'School of Applied Sciences, Technology and Education'
SELECT event_id, event_name, MAX(spent/amount) as spend_to_budget_ratio  FROM event  JOIN budget ON budget.link_to_event = event.event_id  WHERE status = 'Closed'  GROUP BY event_id, event_name  ORDER BY spend_to_budget_ratio DESC  LIMIT 1
SELECT COUNT(*)  FROM member  WHERE position = 'President'
SELECT MAX(spent) FROM budget
SELECT COUNT(*)  FROM event  WHERE type = 'Meeting' AND strftime('%Y', event_date) = '2020'
SELECT SUM(spent)  FROM budget  WHERE category = 'Food'
SELECT member.first_name , member.last_name FROM attendance join member on attendance.link_to_member = member.member_id GROUP BY attendance.link_to_member HAVING COUNT ( * ) > 7
SELECT member.first_name, member.last_name FROM member JOIN major ON member.link_to_major = major.major_id JOIN attendance ON attendance.link_to_member = member.member_id JOIN event ON attendance.link_to_event = event.event_id WHERE major.major_name = 'Interior Design' AND event.event_name = 'Community Theater'
SELECT member.first_name, member.last_name FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE zip_code.city = 'Georgetown' AND zip_code.state = 'South Carolina'
SELECT SUM ( amount ) FROM income WHERE link_to_member = ( SELECT member_id FROM member WHERE first_name = 'Grant' AND last_name = 'Gilmour' )
SELECT member.first_name, member.last_name FROM member JOIN income ON member.member_id = income.link_to_member WHERE income.amount > 40
SELECT SUM(cost)  FROM expense  WHERE link_to_budget IN (     SELECT budget_id      FROM budget      WHERE link_to_event IN (         SELECT event_id          FROM event          WHERE event_name = 'Yearly Kickoff'     ) )
SELECT member.first_name, member.last_name FROM member JOIN budget ON member.member_id = budget.link_to_event JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'Yearly Kickoff'
SELECT member.first_name , member.last_name , income.source FROM income join member on income.link_to_member = member.member_id ORDER BY income.amount DESC LIMIT 1
SELECT T1.event_name FROM event AS T1 INNER JOIN budget AS T2 ON T1.event_id = T2.link_to_event ORDER BY T2.spent LIMIT 1
SELECT CAST(SUM(CASE WHEN T1.event_name = 'Yearly Kickoff' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.event_name)  FROM event AS T1  INNER JOIN budget AS T2 ON T1.event_id = T2.link_to_event
SELECT CAST(SUM(CASE WHEN major_name = 'Finance' THEN 1 ELSE 0 END) AS FLOAT) / CAST(SUM(CASE WHEN major_name = 'Physics' THEN 1 ELSE 0 END) AS FLOAT) FROM member INNER JOIN major ON member.link_to_major = major.major_id
SELECT source FROM income WHERE date_received BETWEEN '2019-09-01' AND '2019-09-30' ORDER BY amount DESC LIMIT 1;
SELECT member.first_name || ' ' || member.last_name, member.email FROM member WHERE member.position = 'Secretary'
SELECT COUNT(*)  FROM member  JOIN major ON member.link_to_major = major.major_id  WHERE major.major_name = 'Physics Teaching'
SELECT COUNT(DISTINCT attendance.link_to_member) FROM attendance JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'Community Theater' AND strftime('%Y', event.event_date) = '2019'
SELECT COUNT(*) FROM attendance JOIN member ON attendance.link_to_member = member.member_id WHERE member.first_name = 'Luisa' AND member.last_name = 'Guidi';
SELECT CAST(SUM(T2.spent) AS REAL) / COUNT(T2.spent) FROM event AS T1 INNER JOIN budget AS T2 ON T1.event_id = T2.link_to_event WHERE T2.category = 'Food'
SELECT event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.category = 'Advertisement' AND budget.spent = (SELECT MAX(spent) FROM budget WHERE category = 'Advertisement')
SELECT COUNT(*) FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id WHERE member.first_name = 'Maya' AND member.last_name = 'Mclean' AND event.event_name = "Women's Soccer"
SELECT CAST(SUM(CASE WHEN type = 'Community Service' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(event_id) FROM event WHERE event_date LIKE '2019%'
SELECT T2.cost  FROM event AS T1  INNER JOIN expense AS T2 ON T1.event_id = T2.link_to_budget  WHERE T1.event_name = 'September Speaker'  AND T2.expense_description = 'Posters'
SELECT t_shirt_size FROM member GROUP BY t_shirt_size ORDER BY COUNT ( * ) DESC LIMIT 1
SELECT event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE event.status = 'Closed' AND budget.remaining < 0 ORDER BY budget.remaining LIMIT 1;
SELECT T2.expense_description, SUM(T2.cost) FROM event AS T1 INNER JOIN expense AS T2 ON T1.event_id = T2.link_to_budget WHERE T1.event_name = 'October Meeting' GROUP BY T2.expense_description
SELECT budget.amount FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'April Speaker' ORDER BY budget.amount ASC;
SELECT budget_id FROM budget WHERE category = 'Food' ORDER BY amount DESC LIMIT 1
SELECT budget_id, category, amount FROM budget WHERE category = 'Advertising' ORDER BY amount DESC LIMIT 3;
SELECT SUM(cost)  FROM expense  WHERE expense_description = 'Parking'
SELECT SUM(cost)  FROM expense  WHERE expense_date = '2019-08-20'
SELECT member.first_name || ' ' || member.last_name AS full_name, SUM(expense.cost) AS total_cost FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE member.member_id = 'rec4BLdZHS2Blfp4v'
SELECT expense_description FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.first_name = 'Sacha' AND member.last_name = 'Harrison'
SELECT expense_description FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.t_shirt_size = 'X-Large'
SELECT zip_code.zip_code FROM member JOIN expense ON member.member_id = expense.link_to_member JOIN zip_code ON member.zip = zip_code.zip_code WHERE expense.cost < 50;
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Phillip' AND member.last_name = 'Cullen'
SELECT member.position FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Business'
SELECT COUNT(*)  FROM member  JOIN major ON member.link_to_major = major.major_id  WHERE major.major_name = 'Business' AND member.t_shirt_size = 'Medium'
SELECT event.type FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.remaining > 30;
SELECT T2.category FROM event AS T1 INNER JOIN budget AS T2 ON T1.event_id = T2.link_to_event WHERE T1.location = 'MU 215'
SELECT event.type FROM event WHERE event.event_date = '2020-03-24T12:00:00'
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'Vice President'
SELECT CAST(COUNT(CASE WHEN T2.major_name = 'Mathematics' THEN T1.member_id ELSE NULL END) AS REAL) * 100 / COUNT(T1.member_id) FROM member AS T1 INNER JOIN major AS T2 ON T1.link_to_major = T2.major_id
SELECT T2.category FROM event AS T1 INNER JOIN budget AS T2 ON T1.event_id = T2.link_to_event WHERE T1.location = 'MU 215'
SELECT COUNT(*) FROM income WHERE amount = 50;
SELECT COUNT(*)  FROM member  WHERE position = 'Member' AND t_shirt_size = 'X-Large'
SELECT COUNT(*)  FROM major  WHERE department = 'School of Applied Sciences, Technology and Education'  AND college = 'College of Agriculture and Applied Sciences'
SELECT member.last_name, major.department, major.college FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Environmental Engineering'
SELECT budget.category FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.location = 'MU 215' AND event.type = 'Guest Speaker' AND budget.spent = 0;
SELECT zip_code.city, zip_code.state FROM member JOIN zip_code ON member.zip = zip_code.zip_code JOIN major ON member.link_to_major = major.major_id WHERE major.department = 'Electrical and Computer Engineering Department' AND member.position = 'Member'
SELECT event.event_name FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id WHERE event.type = 'Social' AND member.position = 'Vice President' AND event.location = '900 E. Washington St.';
SELECT member.last_name, member.position FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE expense.expense_description = 'Pizza' AND expense.expense_date = '2019-09-10'
SELECT T2.last_name FROM attendance AS T1 INNER JOIN member AS T2 ON T1.link_to_member = T2.member_id INNER JOIN event AS T3 ON T1.link_to_event = T3.event_id WHERE T3.event_name = 'Women''s Soccer'
SELECT CAST(SUM(CASE WHEN T2.amount = 50 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.member_id) FROM member AS T1 INNER JOIN income AS T2 ON T1.member_id = T2.link_to_member WHERE T1.t_shirt_size = 'Medium'
SELECT county FROM zip_code WHERE type = 'PO Box'
SELECT zip_code FROM zip_code WHERE type = 'PO Box' AND county = 'San Juan Municipio' AND state = 'Puerto Rico'
SELECT event_name FROM event WHERE type = 'Game' AND status = 'Closed' AND event_date BETWEEN '2019-03-15' AND '2020-03-20'
SELECT event.event_id FROM event JOIN attendance ON attendance.link_to_event = event.event_id JOIN member ON member.member_id = attendance.link_to_member JOIN expense ON expense.link_to_member = member.member_id WHERE expense.cost > 50
SELECT T1.first_name, T1.last_name, T2.link_to_event FROM member AS T1 INNER JOIN attendance AS T2 ON T1.member_id = T2.link_to_member WHERE T2.link_to_event IN ( SELECT link_to_event FROM expense WHERE expense_date BETWEEN '2019-01-10' AND '2019-11-19' )
SELECT college FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Katy' AND major.major_id = 'rec1N0upiVLy5esTO'
SELECT T1.phone FROM member AS T1 INNER JOIN major AS T2 ON T1.link_to_major = T2.major_id WHERE T2.major_name = 'Business' AND T2.department = 'School of Applied Sciences, Technology and Education'
SELECT member.email FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE expense_date BETWEEN '2019-09-10' AND '2019-11-19' AND cost > 20;
SELECT COUNT(*)  FROM member  JOIN major ON member.link_to_major = major.major_id  WHERE major.major_name = 'Education' AND major.college = 'College of Education & Human Services' AND member.position = 'Member'
SELECT CAST(SUM(CASE WHEN T2.remaining < 0 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.event_id) FROM event AS T1 INNER JOIN budget AS T2 ON T1.event_id = T2.link_to_event
SELECT event_id, location, status FROM event WHERE event_date BETWEEN '2019-11-01' AND '2020-03-31'
SELECT expense_id, expense_description, cost FROM expense GROUP BY expense_id HAVING AVG(cost) > 50;
SELECT first_name , last_name FROM member WHERE t_shirt_size = 'Extra Large'
SELECT CAST(SUM(CASE WHEN type = 'PO Box' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(zip_code) FROM zip_code
SELECT event_name, location FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.remaining > 0
SELECT T1.event_name, T1.event_date  FROM event AS T1  INNER JOIN expense AS T2 ON T2.link_to_budget = T1.event_id  WHERE T2.expense_description = 'Pizza' AND T2.cost > 50 AND T2.cost < 100
SELECT member.first_name, member.last_name, major.major_name FROM member JOIN expense ON member.member_id = expense.link_to_member JOIN major ON member.link_to_major = major.major_id WHERE expense.cost > 100
SELECT T1.location, T2.city, T2.county  FROM event AS T1  INNER JOIN zip_code AS T2 ON T2.zip_code = T1.location  WHERE T1.event_id IN (      SELECT T3.link_to_event      FROM attendance AS T3      GROUP BY T3.link_to_event      HAVING COUNT(T3.link_to_member) > 40  )
SELECT T1.first_name, T1.last_name  FROM member AS T1  INNER JOIN expense AS T2 ON T1.member_id = T2.link_to_member  GROUP BY T1.member_id  HAVING COUNT(T2.link_to_budget) > 1  ORDER BY SUM(T2.cost) DESC  LIMIT 1
SELECT AVG(cost)  FROM expense  JOIN member ON expense.link_to_member = member.member_id  WHERE member.position != 'Member'
SELECT event_name  FROM event  WHERE event_id IN (      SELECT link_to_event      FROM budget      WHERE category = 'Parking'      AND link_to_event IN (         SELECT link_to_event          FROM expense          WHERE cost < (              SELECT SUM(cost) / COUNT(expense_id)              FROM expense              WHERE expense_description = 'Parking'          )      )  )
SELECT CAST(SUM(T2.cost) AS REAL) * 100 / COUNT(T1.event_id) FROM event AS T1 INNER JOIN expense AS T2 ON T1.event_id = T2.link_to_budget WHERE T1.type = 'Game'
SELECT budget_id FROM budget JOIN expense ON budget.budget_id = expense.link_to_budget WHERE expense.expense_description = 'Water, chips, cookies' ORDER BY expense.cost DESC LIMIT 1;
SELECT T1.first_name, T1.last_name FROM member AS T1 INNER JOIN expense AS T2 ON T1.member_id = T2.link_to_member GROUP BY T1.member_id ORDER BY SUM(T2.cost) DESC LIMIT 5
SELECT member.first_name , member.last_name , member.phone FROM member join expense on member.member_id = expense.link_to_member GROUP BY expense.link_to_member HAVING AVG ( expense.cost )
SELECT CAST(SUM(CASE WHEN T2.state = 'Maine' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.zip_code) - CAST(SUM(CASE WHEN T2.state = 'Vermont' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.zip_code) FROM member AS T1 INNER JOIN zip_code AS T2 ON T1.zip = T2.zip_code
SELECT major.major_name, major.department FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Garrett' AND member.last_name = 'Gerke';
SELECT member.first_name || ' ' || member.last_name AS full_name, expense.cost FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE expense.expense_description = 'Water, Veggie tray, supplies'
SELECT member.last_name, member.phone FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Elementary Education'
SELECT budget.category, budget.amount FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'January Speaker'
SELECT event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.category = 'Food'
SELECT member.first_name || ' ' || member.last_name AS full_name, income.amount FROM member JOIN income ON member.member_id = income.link_to_member WHERE income.date_received = '2019-09-09'
SELECT budget.category FROM expense JOIN budget ON expense.link_to_budget = budget.budget_id WHERE expense.expense_description = 'Posters'
SELECT member.first_name || ' ' || member.last_name AS full_name, major.college FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'Secretary'
SELECT SUM ( spent ) , event.event_name FROM event join budget on event.event_id = budget.link_to_event WHERE category = 'Speaker Gifts' GROUP BY event.event_name
SELECT zip_code.city FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Garrett' AND member.last_name = 'Girke'
SELECT member.first_name, member.last_name, member.position FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE zip_code.city = 'Lincolnton' AND zip_code.state = 'North Carolina' AND zip_code.zip_code = '28092'
SELECT COUNT(*)  FROM gasstations  WHERE country = 'CZE' AND segment = 'Premium'
SELECT CAST(SUM(CASE WHEN Currency = 'EUR' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN Currency = 'CZK' THEN 1 ELSE 0 END) FROM customers
SELECT customers.customerid FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE yearmonth.date BETWEEN 201201 AND 201212 AND customers.segment = 'LAM' ORDER BY yearmonth.consumption ASC LIMIT 1;
SELECT AVG(consumption) / 12 FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE customers.segment = 'SME' AND yearmonth.date BETWEEN '201301' AND '201312'
SELECT customers.customerid FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.currency = 'CZK' AND yearmonth.date BETWEEN '201101' AND '201112' ORDER BY yearmonth.consumption DESC LIMIT 1
SELECT COUNT(*)  FROM customers  JOIN yearmonth ON customers.customerid = yearmonth.customerid  WHERE segment = 'KAM' AND consumption < 30000 AND date BETWEEN 201201 AND 201212
SELECT SUM(CASE WHEN customers.currency = 'CZK' THEN yearmonth.consumption ELSE 0 END) - SUM(CASE WHEN customers.currency = 'EUR' THEN yearmonth.consumption ELSE 0 END) AS difference FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE yearmonth.date BETWEEN '201201' AND '201212'
SELECT STRFTIME('%Y', T2.Date) FROM customers AS T1 INNER JOIN transactions_1k AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Currency = 'EUR' GROUP BY STRFTIME('%Y', T2.Date) ORDER BY SUM(T2.Amount) DESC LIMIT 1
SELECT segment  FROM customers  GROUP BY segment  ORDER BY segment ASC  LIMIT 1
SELECT SUBSTR(yearmonth.date, 1, 4) AS year  FROM yearmonth  JOIN transactions_1k ON yearmonth.customerid = transactions_1k.customerid  JOIN products ON transactions_1k.productid = products.productid  JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid  JOIN customers ON transactions_1k.customerid = customers.customerid  WHERE customers.currency = 'CZK'  GROUP BY year  ORDER BY SUM(transactions_1k.amount) DESC  LIMIT 1;
SELECT yearmonth.date FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE customers.segment = 'SME' AND yearmonth.date LIKE '2013%' ORDER BY yearmonth.consumption DESC LIMIT 1;
SELECT SUM(CASE WHEN T2.Segment = 'SME' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'SME' THEN T1.CustomerID ELSE NULL END) - SUM(CASE WHEN T2.Segment = 'LAM' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'LAM' THEN T1.CustomerID ELSE NULL END) AS SME_LAM , SUM(CASE WHEN T2.Segment = 'LAM' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'LAM' THEN T1.CustomerID ELSE NULL END) - SUM(CASE WHEN T2.Segment = 'KAM' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'KAM' THEN T1.CustomerID ELSE NULL END) AS LAM_KAM , SUM(CASE WHEN T2.Segment = 'KAM' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'KAM' THEN T1.CustomerID ELSE NULL END) - SUM(CASE WHEN T2.Segment = 'SME' THEN T1.Consumption ELSE 0 END) / COUNT(CASE WHEN T2.Segment = 'SME' THEN T1.CustomerID ELSE NULL END) AS KAM_SME FROM yearmonth AS T1 INNER JOIN customers AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Date LIKE '2013%' AND T2.Currency = 'CZK'
SELECT segment,  MAX(((ym2.consumption - ym1.consumption) / ym2.consumption) * 100) AS biggest_increase_percentage, MIN(((ym2.consumption - ym1.consumption) / ym2.consumption) * 100) AS lowest_increase_percentage FROM ( SELECT  substr(date, 1, 4) AS year, customerid, consumption FROM yearmonth WHERE year = "2012" ) ym1 JOIN ( SELECT  substr(date, 1, 4) AS year, customerid, consumption FROM yearmonth WHERE year = "2013" ) ym2 ON ym1.customerid = ym2.customerid JOIN customers c ON ym1.customerid = c.customerid WHERE c.currency = "EUR" GROUP BY segment;
SELECT SUM(consumption) FROM yearmonth WHERE customerid = 6 AND date >= '201308' AND date <= '201311'
SELECT SUM(CASE WHEN country = 'CZE' THEN 1 ELSE 0 END) - SUM(CASE WHEN country = 'SVK' THEN 1 ELSE 0 END) FROM gasstations WHERE segment = 'Discount'
SELECT SUM(y1.consumption) - SUM(y2.consumption) FROM yearmonth y1 JOIN yearmonth y2 ON y1.customerid = y2.customerid WHERE y1.customerid = 7 AND y1.date = 201304 AND y2.customerid = 5 AND y2.date = 201304;
SELECT SUM(CASE WHEN Currency = 'CZK' THEN 1 ELSE 0 END) - SUM(CASE WHEN Currency = 'EUR' THEN 1 ELSE 0 END) AS diff FROM customers WHERE Segment = 'SME'
SELECT customers.customerid FROM customers JOIN yearmonth ON yearmonth.customerid = customers.customerid WHERE customers.segment = 'LAM' AND customers.currency = 'EUR' AND yearmonth.date = '201310' ORDER BY yearmonth.consumption DESC LIMIT 1;
SELECT customers.customerid, SUM(yearmonth.consumption) AS total_consumption FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.segment = 'KAM' GROUP BY customers.customerid ORDER BY total_consumption DESC LIMIT 1;
SELECT SUM(consumption) FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE segment = 'KAM' AND date = '201305'
SELECT CAST(SUM(CASE WHEN T2.Consumption > 46.73 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.CustomerID) FROM customers AS T1 INNER JOIN yearmonth AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Segment = 'LAM'
SELECT gasstations.country, COUNT(*) as total_gasstations FROM gasstations WHERE gasstations.segment = "Value for money" GROUP BY gasstations.country;
SELECT CAST(SUM(CASE WHEN Currency = 'EUR' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(CustomerID) FROM Customers WHERE Segment = 'KAM'
SELECT CAST(SUM(CASE WHEN T2.Consumption > 528.3 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.CustomerID) FROM customers AS T1 INNER JOIN yearmonth AS T2 ON T1.CustomerID = T2.CustomerID WHERE T2.`Date` = '201202'
SELECT CAST(SUM(CASE WHEN Segment = 'Premium' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(GasStationID) FROM gasstations WHERE Country = 'SVK'
SELECT customerid FROM yearmonth WHERE date = '201309' ORDER BY consumption DESC LIMIT 1
SELECT customers.segment FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE yearmonth.date = '201309' ORDER BY yearmonth.consumption LIMIT 1;
SELECT customers.customerid FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.segment = 'SME' AND yearmonth.date = '201206' ORDER BY yearmonth.consumption LIMIT 1;
SELECT MAX(consumption) FROM yearmonth WHERE date LIKE '2012%'
SELECT MAX(T2.Consumption) FROM customers AS T1 INNER JOIN yearmonth AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Currency = 'EUR'
SELECT products.description FROM products JOIN transactions_1k ON products.productid = transactions_1k.productid WHERE transactions_1k.date LIKE '201309%'
SELECT DISTINCT country FROM gasstations WHERE gasstationid IN (     SELECT gasstationid     FROM transactions_1k     WHERE date LIKE '201306%' )
SELECT gasstations.chainid FROM gasstations JOIN transactions_1k ON gasstations.gasstationid = transactions_1k.gasstationid JOIN customers ON transactions_1k.customerid = customers.customerid WHERE customers.currency = 'EUR'
SELECT products.description FROM transactions_1k JOIN products ON transactions_1k.productid = products.productid JOIN customers ON transactions_1k.customerid = customers.customerid WHERE customers.currency = 'EUR'
SELECT AVG(price)  FROM transactions_1k  WHERE date LIKE '2012-01%'
SELECT COUNT(*)  FROM customers  JOIN yearmonth ON customers.customerid = yearmonth.customerid  WHERE customers.currency = 'EUR' AND yearmonth.consumption > 1000
SELECT products.description FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid JOIN products ON transactions_1k.productid = products.productid WHERE gasstations.country = 'CZE'
SELECT transactions_1k.time FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE gasstations.chainid = 11;
SELECT COUNT(*) FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE gasstations.country = 'CZE' AND transactions_1k.price > 1000;
SELECT COUNT(*) FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE gasstations.country = 'CZE' AND transactions_1k.date > '2012-01-01'
SELECT AVG(price)  FROM transactions_1k  JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid  WHERE gasstations.country = 'CZE'
SELECT AVG(transactions_1k.price)  FROM transactions_1k  JOIN customers ON transactions_1k.customerid = customers.customerid  WHERE customers.currency = 'EUR'
SELECT customers.customerid FROM customers JOIN transactions_1k ON customers.customerid = transactions_1k.customerid WHERE transactions_1k.date = '2012-08-25' ORDER BY transactions_1k.price DESC LIMIT 1;
SELECT gasstations.country FROM transactions_1k JOIN customers ON transactions_1k.customerid = customers.customerid JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE transactions_1k.date = '2012-08-25' ORDER BY transactions_1k.time ASC LIMIT 1;
SELECT customers.currency FROM customers JOIN transactions_1k ON customers.customerid = transactions_1k.customerid WHERE transactions_1k.time = '16:25:00' AND transactions_1k.date = '2012-08-24'
SELECT customers.segment FROM customers JOIN transactions_1k T1 ON customers.customerid = T1.customerid WHERE T1.date = '2012-08-23' AND T1.time = '21:20:00'
SELECT COUNT(*) FROM transactions_1k WHERE date = '2012-08-26' AND time < '13:00:00' AND amount = 'EUR'
SELECT customers.segment FROM customers WHERE customers.customerid = (     SELECT MIN(customers.customerid)     FROM customers )
SELECT gasstations.country FROM transactions_1k AS T1 JOIN gasstations ON T1.gasstationid = gasstations.gasstationid WHERE T1.date = '2012-08-24' AND T1.time = '12:42:00'
SELECT productid FROM transactions_1k WHERE date = '2012-08-23' AND time = '21:20:00'
SELECT SUM(transactions_1k.price) AS expenses, yearmonth.date AS date FROM transactions_1k JOIN yearmonth ON transactions_1k.customerid = yearmonth.customerid WHERE transactions_1k.price = 124.05 AND transactions_1k.date = '2012-08-24' AND yearmonth.date LIKE '201201%' GROUP BY yearmonth.date
SELECT COUNT(*) FROM transactions_1k WHERE time >= '08:00:00' AND time <= '09:00:00' AND date = '2012-08-26' AND gasstationid IN (SELECT gasstationid FROM gasstations WHERE country = 'CZE')
SELECT customers.currency FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE yearmonth.date = '201306' AND yearmonth.consumption = 214582.17;
SELECT gasstations.country FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE transactions_1k.cardid = '667467'
SELECT T2.Country FROM transactions_1k AS T1 INNER JOIN gasstations AS T2 ON T1.GasStationID = T2.GasStationID WHERE T1.Date = '2012-08-24' AND T1.Amount = 548.4
SELECT CAST(SUM(CASE WHEN T1.Currency = 'EUR' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.CustomerID) FROM Customers AS T1 INNER JOIN transactions_1k AS T2 ON T1.CustomerID = T2.CustomerID WHERE T2.Date = '2012-08-25'
SELECT CAST((SUM(T2.Consumption) - SUM(T1.Consumption)) AS REAL) * 100 / SUM(T1.Consumption) FROM yearmonth AS T1 INNER JOIN yearmonth AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Date = '2012' AND T2.Date = '2013' AND T1.CustomerID = ( SELECT CustomerID FROM transactions_1k WHERE Price = 634.8 AND `Date` = '2012-08-25' )
SELECT gasstationid FROM transactions_1k GROUP BY gasstationid ORDER BY SUM(amount * price) DESC LIMIT 1
SELECT CAST(SUM(CASE WHEN Segment = 'Premium' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(Segment) FROM gasstations WHERE Country = 'SVK'
SELECT SUM(amount)  FROM transactions_1k  WHERE customerid = '38508'  AND date LIKE '201201%'
SELECT products.description FROM products JOIN transactions_1k ON products.productid = transactions_1k.productid GROUP BY products.description ORDER BY SUM(transactions_1k.amount) DESC LIMIT 5;
SELECT T1.CustomerID, AVG(T1.Price) , T2.Currency FROM transactions_1k AS T1 INNER JOIN customers AS T2 ON T1.CustomerID = T2.CustomerID GROUP BY T1.CustomerID ORDER BY SUM(T1.Price) DESC LIMIT 1
SELECT gasstations.country FROM gasstations JOIN transactions_1k ON gasstations.gasstationid = transactions_1k.gasstationid WHERE transactions_1k.productid = 2 ORDER BY transactions_1k.price DESC LIMIT 1;
SELECT T2.Consumption FROM transactions_1k AS T1 INNER JOIN yearmonth AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.ProductID = 5 AND T1.Price > 29 AND T2.`Date` = '201208'
