SELECT drivers.forename, drivers.surname FROM     drivers INNER JOIN     laptimes ON drivers.driverid = laptimes.driverid INNER JOIN     races ON laptimes.raceid = races.raceid WHERE     laptimes.time = (         SELECT            MIN(time)         FROM             laptimes     );
SELECT MAX(results.fastestlap) FROM     results JOIN     driverstandings ON results.raceid = driverstandings.raceid AND results.driverid = driverstandings.driverid JOIN     races ON results.raceid = races.raceid WHERE     races.year = 2009 AND driverstandings.position = 1;
SELECT AVG(fastestlapspeed) FROM     results JOIN     races ON results.raceid = races.raceid WHERE     races.name = 'Spanish Grand Prix'     AND races.year = 2009;
SELECT races.name, races.year FROM races JOIN results ON races.raceid = results.raceid WHERE results.milliseconds IS NOT NULL ORDER BY results.milliseconds ASC LIMIT 1;
SELECT CAST(SUM(CASE WHEN T1.DOB < '1985' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.DOB) FROM drivers AS T1 INNER JOIN laptimes AS T2 ON T1.DriverID = T2.DriverID WHERE T2.Lap > 50 AND T2.raceid BETWEEN 2000 AND 2005
SELECT COUNT(DISTINCT drivers.driverid) FROM drivers JOIN laptimes ON drivers.driverid = laptimes.driverid JOIN races ON laptimes.raceid = races.raceid WHERE laptimes.time < '02:00.00' AND drivers.nationality = 'French';
SELECT code FROM drivers WHERE nationality = 'American'
SELECT raceid FROM races WHERE year = 2009;
SELECT COUNT(DISTINCT driverid) AS num_participants FROM results WHERE raceid = 18;
SELECT DISTINCT drivers.driverid, drivers.forename, drivers.surname, drivers.dob, drivers.nationality FROM drivers ORDER BY (2024 - strftime('%Y', drivers.dob)) ASC LIMIT 3;
SELECT `driverref` FROM drivers WHERE forename = 'Robert' AND surname = 'Kubica';
SELECT COUNT(*) FROM drivers WHERE nationality = 'Australian' AND strftime('%Y', dob) = '1980';
SELECT forename, surname FROM drivers WHERE nationality = 'German' AND dob BETWEEN '1980-01-01' AND '1990-12-31' ORDER BY time LIMIT 3
SELECT driverref FROM drivers WHERE nationality = 'German' AND dob = ( SELECT MAX(DOB) FROM drivers WHERE nationality = 'German' )
SELECT drivers.driverid, drivers.code FROM     drivers JOIN     driverstandings ON drivers.driverid = driverstandings.driverid JOIN     races ON driverstandings.raceid = races.raceid JOIN     results ON drivers.driverid = results.driverid AND races.raceid = results.raceid WHERE     drivers.dob = '1971' AND     results.fastestlaptime IS NOT NULL ORDER BY     results.fastestlaptime ASC;
SELECT drivers.forename, drivers.surname FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON races.raceid = driverstandings.raceid JOIN laptimes ON laptimes.driverid = drivers.driverid AND laptimes.raceid = races.raceid WHERE drivers.nationality = 'Spanish' AND drivers.dob < '1982-01-01' GROUP BY drivers.driverid ORDER BY MAX(laptimes.time) DESC LIMIT 10;
SELECT MAX(races.year) AS "Year with Fastest Lap Time" FROM races JOIN results ON races.raceid = results.raceid WHERE results.fastestlaptime IS NOT NULL;
SELECT MIN(substr(time, 1, 2) || substr(time, 4, 2) || substr(time, 7)) AS "Year with lowest lap time speed" FROM laptimes
SELECT driverid FROM laptimes ORDER BY time DESC LIMIT 5
SELECT COUNT(results.resultid) AS disqualified_finishers FROM     results JOIN races ON results.raceid = races.raceid WHERE     results.statusid = 2     AND races.raceid BETWEEN 50 AND 100
SELECT COUNT(T1.CircuitID), T1.Location, T1.Lat, T1.Lng FROM circuits AS T1 INNER JOIN races AS T2 ON T1.CircuitID = T2.CircuitID WHERE T1.Country = 'Austria' GROUP BY T1.CircuitID
SELECT raceid FROM results GROUP BY raceid ORDER BY COUNT ( * ) DESC LIMIT 1
SELECT drivers.driverref, drivers.nationality, drivers.dob FROM qualifying INNER JOIN drivers ON qualifying.driverid = drivers.driverid WHERE qualifying.raceid = 23 AND qualifying.q2 IS NOT NULL;
SELECT races.year AS year, races.name AS race_name, races.date AS race_date, races.time AS race_time FROM races JOIN qualifying ON races.raceid = qualifying.raceid JOIN drivers ON qualifying.driverid = drivers.driverid WHERE drivers.dob = (SELECT MIN(dob) FROM drivers)
SELECT COUNT(*) AS American_Disqualified FROM     drivers JOIN     results ON drivers.driverid = results.driverid JOIN     status ON results.statusid = status.statusid WHERE     drivers.nationality = 'American'     AND status.statusid = 2;
SELECT constructorref, MAX(points) AS highest_points, constructors.url AS introduction_website FROM constructorresults JOIN constructors ON constructorresults.constructorid = constructors.constructorid WHERE constructors.nationality = 'Italian';
SELECT constructors.url FROM constructorstandings join constructors on constructorstandings.constructorid = constructors.constructorid GROUP BY constructorstandings.constructorid ORDER BY SUM ( wins ) DESC LIMIT 1
SELECT drivers.forename,     drivers.surname,     laptimes.time FROM     drivers JOIN     races ON laptimes.raceid = races.raceid JOIN     circuits ON races.circuitid = circuits.circuitid JOIN     laptimes ON laptimes.driverid = drivers.driverid WHERE     races.name = 'French Grand Prix'     AND laptimes.lap = 3 ORDER BY     laptimes.time DESC LIMIT     1;
SELECT races.name AS race_name, races.year AS race_year, circuits.name AS circuit_name, MIN(laptimes.milliseconds) AS fastest_lap_time_milliseconds FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN laptimes ON races.raceid = laptimes.raceid AND laptimes.lap = 1 GROUP BY races.name ORDER BY fastest_lap_time_milliseconds ASC LIMIT 1;
SELECT AVG(results.fastestlaptime) AS average_fastest_lap_time FROM results JOIN races ON results.raceid = races.raceid WHERE races.name = 'United States Grand Prix' AND races.year = 2006 AND results.rank < 11;
SELECT T1.Forename, T1.Surname FROM drivers AS T1 INNER JOIN pitstops AS T2 ON T1.DriverID = T2.DriverID WHERE T1.Nationality = 'German' AND T1.DOB BETWEEN '1980-01-01' AND '1985-12-31' ORDER BY T2.Duration ASC LIMIT 5
SELECT drivers.forename || ' ' || drivers.surname AS champion, results.time AS finish_time FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE races.name = 'Canadian Grand Prix' AND races.year = 2008 AND results.position = 1;
SELECT constructors.constructorref, constructors.url FROM     constructors JOIN     constructorstandings ON constructors.constructorid = constructorstandings.constructorid JOIN     races ON constructorstandings.raceid = races.raceid WHERE     races.name = 'Singapore Grand Prix'     AND races.year = 2009     AND constructorstandings.position = 1;
SELECT forename , surname , dob FROM drivers WHERE nationality = 'Austrian' AND dob BETWEEN '1981-01-01' AND '1991-12-31'
SELECT forename, surname, url, dob FROM drivers WHERE nationality = 'German' AND dob BETWEEN '1971-01-01' AND '1985-12-31' ORDER BY dob DESC
SELECT location, country, lat, lng FROM circuits WHERE circuitref = 'hungaroring';
SELECT T2.ConstructorID, T2.Points, T1.Name, T1.Nationality FROM constructors AS T1 INNER JOIN constructorstandings AS T2 ON T1.ConstructorID = T2.ConstructorID INNER JOIN races AS T3 ON T2.RaceID = T3.RaceID WHERE T3.Name = 'Monaco Grand Prix' AND T3.Year BETWEEN 1980 AND 2010 ORDER BY T2.Points DESC LIMIT 1
SELECT AVG(results.points) FROM     results JOIN     races ON results.raceid = races.raceid JOIN     drivers ON results.driverid = drivers.driverid WHERE     drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'     AND races.name = 'Turkish Grand Prix';
SELECT AVG(COUNT(races.raceid)) FROM races JOIN seasons ON races.year = seasons.year WHERE seasons.year BETWEEN 2000 AND 2009;
SELECT MAX(nationality) FROM drivers;
SELECT COUNT(driverstandings.wins) FROM driverstandings WHERE driverstandings.position = 91
SELECT races.name FROM     races WHERE     races.fastestlapspeed = (         SELECT            MIN(results.fastestlapspeed)         FROM             results     );
SELECT circuits.name || ', ' || circuits.location || ', ' || circuits.country AS recent_race_location FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE races.date = (SELECT MAX(date) FROM races);
SELECT drivers.forename || ' ' || drivers.surname AS full_name FROM     drivers JOIN     qualifying ON drivers.driverid = qualifying.driverid JOIN     races ON qualifying.raceid = races.raceid JOIN     circuits ON races.circuitid = circuits.circuitid WHERE     circuits.name = 'Marina Bay Street Circuit'     AND races.year = 2008     AND qualifying.position = 1     AND qualifying.q3 = (SELECT MIN(q3) FROM qualifying WHERE raceid = races.raceid);
SELECT drivers.forename , drivers.surname , drivers.nationality , races.name FROM drivers join results on drivers.driverid = results.driverid join races on races.raceid = results.raceid ORDER BY drivers.dob ASC LIMIT 1
SELECT COUNT(T1.statusid) FROM results AS T1 INNER JOIN races AS T2 ON T1.raceid = T2.raceid WHERE T2.name = 'Canadian Grand Prix' ORDER BY T1.statusid DESC LIMIT 1
SELECT COUNT(driverstandings.wins), drivers.forename || ' ' || drivers.surname AS oldest_racer_name FROM driverstandings JOIN drivers ON driverstandings.driverid = drivers.driverid WHERE drivers.dob = (SELECT MIN(dob) FROM drivers)
SELECT MAX(duration) FROM pitstops;
SELECT MIN(time) AS fastest_lap_time FROM laptimes;
SELECT MAX(duration) FROM pitstops JOIN drivers ON pitstops.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton';
SELECT T2.Lap FROM drivers AS T1 INNER JOIN pitstops AS T2 ON T1.driverID = T2.driverID WHERE T1.forename = 'Lewis' AND T1.surname = 'Hamilton' AND T2.raceID = ( SELECT raceID FROM results WHERE year = 2011 AND name = 'Australian Grand Prix' )
SELECT pitstops.time FROM pitstops JOIN races ON pitstops.raceid = races.raceid JOIN drivers ON pitstops.driverid = drivers.driverid JOIN constructors ON pitstops.driverid = constructors.constructorid WHERE races.name = 'Australian Grand Prix' AND races.year = 2011;
SELECT MIN(laptimes.time) FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'
SELECT T1.Forename, T1.Surname FROM drivers AS T1 INNER JOIN laptimes AS T2 ON T1.DriverID = T2.DriverID ORDER BY T2.Time ASC LIMIT 1
SELECT T1.position FROM circuits AS T1 INNER JOIN results AS T2 ON T1.circuitid = T2.raceid INNER JOIN drivers AS T3 ON T2.driverid = T3.driverid WHERE T3.forename = 'Lewis' AND T3.surname = 'Hamilton' AND T2.fastestlap = 1
SELECT MIN(milliseconds) AS lap_record FROM laptimes JOIN circuits ON laptimes.circuitid = circuits.circuitid WHERE circuits.name = 'Austrian Grand Prix' GROUP BY circuits.name;
SELECT T1.Name FROM circuits AS T1 INNER JOIN laptimes AS T2 ON T1.CircuitId = T2.RaceId WHERE T1.Country = 'Italy' ORDER BY T2.Time ASC LIMIT 1
SELECT races.name AS race_name, races.date AS race_date, circuits.name AS circuit_name, MAX(laptimes.time) AS lap_record_time FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN laptimes ON races.raceid = laptimes.raceid WHERE circuits.name = 'Austrian Grand Prix Circuit' GROUP BY races.name;
SELECT T2.Duration FROM races AS T1 INNER JOIN pitstops AS T2 ON T1.RaceID = T2.RaceID INNER JOIN circuits AS T3 ON T1.CircuitID = T3.CircuitID WHERE T3.Name = 'Austrian Grand Prix' AND T2.DriverID = ( SELECT T1.DriverID FROM results AS T1 INNER JOIN races AS T2 ON T1.RaceID = T2.RaceID INNER JOIN circuits AS T3 ON T2.CircuitID = T3.CircuitID WHERE T3.Name = 'Austrian Grand Prix' AND T1.FastestLap = 1 )
SELECT circuits.lat, circuits.lng FROM     circuits JOIN races ON circuits.circuitid = races.circuitid JOIN results ON races.raceid = results.raceid WHERE     results.fastestlaptime = '1:29.488';
SELECT AVG(pitstops.duration) AS average_pitstop_time_milliseconds FROM pitstops JOIN drivers ON pitstops.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton';
SELECT AVG(laptimes.milliseconds) AS average_lap_time FROM     laptimes     JOIN races ON laptimes.raceid = races.raceid     JOIN circuits ON races.circuitid = circuits.circuitid WHERE     circuits.country = 'Italy';
SELECT player_api_id FROM player_attributes ORDER BY overall_rating DESC LIMIT 1;
SELECT MAX(player.height) AS tallest_height, player.player_name AS tallest_player_name FROM player;
SELECT preferred_foot FROM player_attributes WHERE potential = (     SELECT MIN(potential)     FROM player_attributes );
SELECT COUNT(DISTINCT player_attributes.player_api_id) FROM     player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE     player_attributes.overall_rating >= 60     AND player_attributes.overall_rating < 65     AND player_attributes.defensive_work_rate = 'low';
SELECT player_attributes.player_api_id, MAX(crossing) AS max_crossing FROM player_attributes GROUP BY player_attributes.player_api_id ORDER BY max_crossing DESC LIMIT 5;
SELECT league.name FROM     match JOIN     league ON match.league_id = league.id WHERE     match.season = '2015/2016' GROUP BY     match.league_id ORDER BY     SUM(match.home_team_goal + match.away_team_goal) DESC LIMIT 1;
SELECT team.team_long_name FROM     match JOIN     team ON match.home_team_api_id = team.team_api_id WHERE     match.season = '2015/2016' GROUP BY     match.home_team_api_id ORDER BY     COUNT(CASE WHEN match.home_team_goal < match.away_team_goal THEN 1 END) LIMIT 1;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id GROUP BY player.player_name ORDER BY MAX(player_attributes.penalties) DESC LIMIT 10;
SELECT team.team_long_name AS away_team_name, COUNT(*) AS num_wins FROM match JOIN team ON match.away_team_api_id = team.team_api_id JOIN league ON match.league_id = league.id WHERE league.name = 'Scotland Premier League' AND season = '2009/2010' AND (away_team_goal - home_team_goal) > 0 GROUP BY away_team_name ORDER BY num_wins DESC LIMIT 1;
SELECT team.team_long_name, team_attributes.buildupplayspeed AS build_up_play_speed FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id ORDER BY team_attributes.buildupplayspeed DESC LIMIT 4;
SELECT league.name FROM     match JOIN     league ON match.league_id = league.id WHERE     match.season = '2015/2016' GROUP BY     match.league_id ORDER BY     SUM(CASE WHEN match.home_team_goal = match.away_team_goal THEN 1 ELSE 0 END) DESC LIMIT 1;
SELECT strftime('%Y', 'now') - strftime('%Y', p.birthday) - (strftime('%m-%d', 'now') < strftime('%m-%d', p.birthday)) AS age FROM player AS p JOIN player_attributes AS pa ON p.player_api_id = pa.player_api_id WHERE pa.sprint_speed >= 97 AND pa.date BETWEEN '2013-01-01 00:00:00' AND '2015-12-31 00:00:00';
SELECT League.name, COUNT(match.id) AS matches_played FROM match JOIN league ON match.league_id = league.id GROUP BY league.name ORDER BY matches_played DESC LIMIT 1;
SELECT ROUND(AVG(player.height), 2) FROM player WHERE birthday >= '1990-01-01 00:00:00' AND birthday < '1996-01-01 00:00:00'; 
SELECT player_attributes.player_api_id FROM player_attributes WHERE substr(date,1,4) = '2010' AND overall_rating > (SELECT AVG(overall_rating) FROM player_attributes WHERE substr(date,1,4) = '2010')
SELECT team_fifa_api_id FROM team_attributes WHERE buildupplayspeed BETWEEN 51 AND 59; 
SELECT team.team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.date BETWEEN '2012-01-01 00:00:00' AND '2012-12-31 23:59:59' AND team_attributes.buildupplaypassing >   (SELECT AVG(buildupplaypassing)    FROM team_attributes    WHERE buildupplaypassing IS NOT NULL    AND strftime('%Y', date) = '2012'   ); 
SELECT ROUND((COUNT(CASE WHEN preferred_foot = 'left' THEN 1 END) * 100.0) / COUNT(player_fifa_api_id), 2) AS percentage_left_foot_players FROM player WHERE birthday BETWEEN '1987-01-01 00:00:00' AND '1992-12-31 00:00:00';
SELECT league.name AS league_name, COUNT(match.home_team_goal + match.away_team_goal) AS total_goals FROM match JOIN league ON match.league_id = league.id GROUP BY league_name ORDER BY total_goals ASC LIMIT 5; 
SELECT AVG(long_shots) AS avg_long_shots FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Ahmed Samir Farag';
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.height > 180 GROUP BY player.player_name ORDER BY AVG(player_attributes.heading_accuracy) DESC LIMIT 10; 
SELECT team.team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildupplaydribblingclass = 'Normal' AND team_attributes.date BETWEEN '2014-01-01 00:00:00' AND '2014-01-31 00:00:00' GROUP BY team.team_long_name HAVING AVG(team_attributes.chancecreationpassing) < (SELECT AVG(chanceCreationPassing) FROM team_attributes) ORDER BY AVG(team_attributes.chancecreationpassing) DESC; 
SELECT League.name FROM     match JOIN     league ON match.league_id = league.id GROUP BY     match.league_id HAVING     AVG(match.home_team_goal) > AVG(match.away_team_goal)     AND     match.season = '2009/2010';
SELECT team_short_name FROM team WHERE team_long_name = 'Queens Park Rangers';
SELECT player.player_name FROM player WHERE strftime('%Y', player.birthday) = '1970' AND strftime('%m', player.birthday) = '10';
SELECT player_attributes.attacking_work_rate FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Franco Zennaro';
SELECT buildupplaypositioningclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'ADO Den Haag';
SELECT player_attributes.heading_accuracy FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Francois Affolter' AND player.birthday = '1980-09-27 00:00:00' AND player_attributes.date = '2014-09-18 00:00:00'; 
SELECT player_attributes.overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Gabriel Tamas' AND strftime('%Y', player_attributes.date) = '2011';
SELECT COUNT(match.id) FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Scotland Premier League' AND match.season = '2015/2016';
SELECT preferred_foot FROM player ORDER BY birthday DESC LIMIT 1;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.potential = (     SELECT MAX(potential) FROM player_attributes );
SELECT COUNT(*)  FROM player_attributes  WHERE weight < 130 AND preferred_foot = 'left';
SELECT team.team_short_name FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_attributes.chancecreationpassingclass = 'Risky';
SELECT pa.defensive_work_rate FROM player_attributes AS pa JOIN player AS p ON pa.player_api_id = p.player_api_id WHERE p.player_name = 'David Wilson'; 
SELECT MAX(player.birthday) AS highest_rated_player_birthday FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.overall_rating = (     SELECT MAX(overall_rating) FROM player_attributes );
SELECT League.name FROM league JOIN country ON league.country_id = country.id WHERE country.name = 'Netherlands';
SELECT AVG(home_team_goal) AS average_home_team_goal FROM match JOIN league ON match.league_id = league.id JOIN country ON league.country_id = country.id WHERE country.name = 'Poland' AND match.season = '2010/2011';
SELECT MAX(finishing) AS highest_average_finishing_rate FROM player_attributes WHERE player_api_id IN (     SELECT player_api_id     FROM player     WHERE height = (         SELECT MAX(height)         FROM player     ) )
SELECT player.player_name FROM player WHERE player.height > 180;
SELECT COUNT(*) FROM player WHERE strftime('%Y', birthday) > '1990';
SELECT COUNT(player.id) FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.player_name LIKE 'Adam%' AND player_attributes.weight > 170;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.overall_rating > 80 AND strftime('%Y', player_attributes.date) BETWEEN '2008' AND '2010';
SELECT player_attributes.potential FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Aaron Doran';
SELECT player.player_name FROM player INNER JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.preferred_foot = 'left';
SELECT team.team_long_name FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_attributes.buildupplayspeedclass = 'Fast';
SELECT team_attributes.buildupplaypassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_short_name = 'CLB';
SELECT team.team_short_name FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_attributes.buildupplaypassing > 70;
SELECT AVG(overall_rating) AS average_overall_rating FROM player_attributes WHERE strftime('%Y', date) BETWEEN '2010' AND '2015' AND height > 170; 
SELECT player_name FROM player ORDER BY height LIMIT 1;
SELECT country.name FROM league JOIN country ON league.country_id = country.id WHERE league.name = 'Italy Serie A';
SELECT team.team_short_name FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_attributes.buildupplayspeed = 31 AND team_attributes.buildupplaydribbling = 53 AND team_attributes.buildupplaypassing = 32;
SELECT AVG(player_attributes.overall_rating) AS average_overall_rating FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.player_name = 'Aaron Doran';
SELECT COUNT(match.id) FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Germany 1. Bundesliga' AND strftime('%Y-%m', match.date) BETWEEN '2008-08' AND '2008-10';
SELECT team.team_short_name FROM match JOIN team ON match.home_team_api_id = team.team_api_id WHERE match.home_team_goal = 10;
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.balance = (SELECT MAX(balance) FROM player_attributes WHERE potential = 61) AND player_attributes.potential = 61; 
SELECT AVG(CASE WHEN player.player_name = 'Abdou Diallo' THEN player_attributes.ball_control ELSE 0 END) - AVG(CASE WHEN player.player_name = 'Aaron Appindangoye' THEN player_attributes.ball_control ELSE 0 END) FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id;
SELECT team_long_name FROM team WHERE team_short_name = 'GEN';
SELECT MIN(player.birthday) AS oldest_birthday FROM player WHERE player.player_name IN ('Aaron Lennon', 'Abdelaziz Barrada');
SELECT player.player_name FROM player ORDER BY player.height DESC LIMIT 1;
SELECT COUNT(*)  FROM player_attributes  WHERE preferred_foot = 'left'  AND attacking_work_rate = 'low';
SELECT country.name FROM league JOIN country ON league.country_id = country.id WHERE league.name = 'Belgium Jupiler League';
SELECT league.name FROM league JOIN country ON league.country_id = country.id WHERE country.name = 'Germany';
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.overall_rating = (     SELECT MAX(overall_rating)     FROM player_attributes )
SELECT COUNT(*)  FROM player_attributes  JOIN player ON player_attributes.player_api_id = player.player_api_id  WHERE strftime('%Y', player.birthday) < '1986'  AND player_attributes.defensive_work_rate = 'high';
SELECT MAX(player_attributes.crossing) AS max_crossing FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name IN ('Alexis', 'Ariel Borysiuk', 'Arouna Kone');
SELECT player_attributes.heading_accuracy FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Ariel Borysiuk'; 
SELECT COUNT(player_attributes.id) FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.height > 180 AND player_attributes.volleys > 70;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.volleys > 70 AND player_attributes.dribbling > 70;
SELECT COUNT(match.id) FROM match JOIN league ON match.league_id = league.id JOIN country ON league.country_id = country.id WHERE match.season = '2008/2009' AND country.name = 'Belgium';
SELECT MAX(long_passing) AS long_passing_score FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE birthday = (SELECT MIN(birthday) FROM player);
SELECT COUNT(*) FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Belgium Jupiler League' AND strftime('%Y', match.date) = '2009' AND strftime('%m', match.date) = '04';
SELECT MAX(league_id) AS league_id FROM match WHERE season = '2008/2009';
SELECT AVG(overall_rating) FROM player_attributes WHERE strftime('%Y', birthday) < '1986';
SELECT ((player_attributes.overall_rating  WHERE player.player_name = 'Ariel Borysiuk') -  (player_attributes.overall_rating  WHERE player.player_name = 'Paulin Puel')) / (player_attributes.overall_rating  WHERE player.player_name = 'Paulin Puel') * 100;
SELECT AVG(buildupplayspeed) AS average_build_up_play_speed FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Heart of Midlothian';
SELECT AVG(T1.overall_rating) AS average_overall_rating FROM player_attributes AS T1 JOIN player AS T2 ON T1.player_api_id = T2.player_api_id WHERE T2.player_name = 'Pietro Marino';
SELECT SUM(player_attributes.crossing) AS total_crossing_score FROM     player_attributes JOIN     player ON player_attributes.player_api_id = player.player_api_id WHERE     player.player_name = 'Aaron Lennox';
SELECT MAX(chancecreationpassing) AS highest_chance_creation_passing_score, chancecreationpassingclass AS chance_creation_passing_classification FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_long_name = 'Ajax';
SELECT preferred_foot FROM player WHERE player_name = 'Abdou Diallo';
SELECT MAX(overall_rating) AS highest_overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Dorlan Pabon';
SELECT AVG(away_team_goal) FROM match JOIN team ON match.away_team_api_id = team.team_api_id JOIN league ON match.country_id = league.country_id WHERE team.team_long_name = 'Parma' AND league.name LIKE '%Italy%';
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.overall_rating = 77 AND player_attributes.date = '2016-06-23' ORDER BY player.birthday ASC LIMIT 1;
SELECT player_attributes.overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Aaron Mooy' AND player_attributes.date = '2016-02-04 00:00:00';
SELECT potential FROM     player_attributes JOIN     player ON player_attributes.player_api_id = player.player_api_id WHERE     player.player_name = 'Francesco Parravicini'     AND player_attributes.date = '2010-08-30 00:00:00';
SELECT attacking_work_rate FROM     player_attributes JOIN     player ON player_attributes.player_api_id = player.player_api_id WHERE     player.player_name = 'Francesco Migliore'     AND player_attributes.date = '2015-05-01 00:00:00';
SELECT player_attributes.defensive_work_rate FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Kevin Berigaud' AND player_attributes.date = '2013-02-22 00:00:00';
SELECT MIN(date) FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_name = 'Kevin Constant' AND crossing = (SELECT MAX(crossing) FROM player_attributes WHERE player_name = 'Kevin Constant');
SELECT team_attributes.buildupplayspeedclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Willem II' AND team_attributes.date = '2012-02-22 00:00:00';
SELECT buildupplaydribblingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id JOIN match ON match.home_team_api_id = team.team_api_id JOIN league ON match.country_id = league.country_id WHERE team.team_short_name = 'LEI' AND match.date = '2015-09-10 00:00:00';
SELECT team_attributes.buildupplaypassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'FC Lorient' AND team_attributes.date = '2010-02-22';
SELECT chancecreationpassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id JOIN match ON (match.home_team_api_id = team.team_api_id OR match.away_team_api_id = team.team_api_id) WHERE team.team_long_name = 'PEC Zwolle' AND date = '2013-09-20 00:00:00';
SELECT team_attributes.chancecreationcrossingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Hull City' AND team_attributes.date = '2010-02-22 00:00:00'; 
SELECT team_attributes.defenceaggressionclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Hannover 96' AND team_attributes.date = '2015-09-10 00:00:00';
SELECT AVG(player_attributes.overall_rating) AS average_overall_rating FROM     player_attributes JOIN     player ON player_attributes.player_api_id = player.player_api_id WHERE     player.player_name = 'Marko Arnautovic'     AND player_attributes.date BETWEEN '2007-02-22 00:00:00' AND '2016-04-21 00:00:00';
SELECT ROUND(((SELECT overall_rating FROM player_attributes WHERE player_api_id = (SELECT player_api_id FROM player WHERE player_name = 'Landon Donovan') AND date = '2013-07-12') - (SELECT overall_rating FROM player_attributes WHERE player_api_id = (SELECT player_api_id FROM player WHERE player_name = 'Jordan Bowery') AND date = '2013-07-12')) / (SELECT overall_rating FROM player_attributes WHERE player_name = 'Landon Donovan' AND date = '2013-07-12') * 100, 2) AS rating_difference_percentage;
SELECT player.player_name FROM player ORDER BY player.height DESC LIMIT 5;
SELECT player_api_id FROM player ORDER BY weight DESC LIMIT 10;
SELECT player.player_name FROM player WHERE strftime('%Y', 'now') - strftime('%Y', player.birthday) > 34;
SELECT COUNT(match.home_team_goal) AS home_goals FROM     match JOIN     player AS p ON match.home_player_1 = p.player_api_id     OR match.home_player_2 = p.player_api_id     OR match.home_player_3 = p.player_api_id     OR match.home_player_4 = p.player_api_id     OR match.home_player_5 = p.player_api_id     OR match.home_player_6 = p.player_api_id     OR match.home_player_7 = p.player_api_id     OR match.home_player_8 = p.player_api_id     OR match.home_player_9 = p.player_api_id     OR match.home_player_10 = p.player_api_id     OR match.home_player_11 = p.player_api_id WHERE     p.player_name = 'Aaron Lennon';
SELECT SUM(match.away_team_goal) FROM match JOIN player ON match.away_player_1 = player.player_api_id OR match.away_player_2 = player.player_api_id OR match.away_player_3 = player.player_api_id OR match.away_player_4 = player.player_api_id OR match.away_player_5 = player.player_api_id OR match.away_player_6 = player.player_api_id OR match.away_player_7 = player.player_api_id OR match.away_player_8 = player.player_api_id OR match.away_player_9 = player.player_api_id OR match.away_player_10 = player.player_api_id OR match.away_player_11 = player.player_api_id WHERE player.player_name = 'Daan Smith' OR player.player_name = 'Filipe Ferreira';
SELECT SUM(home_team_goal) AS total_home_team_goals FROM match JOIN player AS home_players ON match.home_player_1 = home_players.player_api_id OR match.home_player_2 = home_players.player_api_id OR match.home_player_3 = home_players.player_api_id OR match.home_player_4 = home_players.player_api_id OR match.home_player_5 = home_players.player_api_id OR match.home_player_6 = home_players.player_api_id OR match.home_player_7 = home_players.player_api_id OR match.home_player_8 = home_players.player_api_id OR match.home_player_9 = home_players.player_api_id OR match.home_player_10 = home_players.player_api_id OR match.home_player_11 = home_players.player_api_id WHERE strftime('%Y', 'now') - strftime('%Y', home_players.birthday) <= 30;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.overall_rating = (     SELECT MAX(overall_rating)     FROM player_attributes ) LIMIT 10;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.potential = (     SELECT MAX(potential) FROM player_attributes )
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.attacking_work_rate = 'high';
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.finishing = 1 ORDER BY (date('now') - date(player.birthday)) DESC LIMIT 1;
SELECT T1.player_name FROM player AS T1 INNER JOIN country AS T2 ON T1.country_id = T2.id WHERE T2.name = 'Belgium'
SELECT player.player_name,     country.name AS country FROM     player     JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id     JOIN country ON player.player_fifa_api_id = country.id WHERE     player_attributes.vision > 89;
SELECT country.name FROM country JOIN player ON country.id = player.country_id GROUP BY country.name ORDER BY AVG(player.weight) DESC LIMIT 1;
SELECT team.team_long_name FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_attributes.buildupplayspeedclass = 'Slow';
SELECT team.team_short_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.chancecreationpassingclass = 'Safe';
SELECT AVG(T1.height) FROM player AS T1 INNER JOIN country AS T2 ON T1.country_id = T2.id WHERE T2.name = 'Italy'
SELECT player.player_name FROM player WHERE player.height > 180 ORDER BY player.player_name ASC LIMIT 3;
SELECT COUNT(*) FROM player WHERE player_name LIKE 'Aaron%' AND birthday > '1990-01-01';
SELECT ABS((SELECT jumping FROM player_attributes WHERE id = 6) - (SELECT jumping FROM player_attributes WHERE id = 23)) AS jumping_difference;
SELECT player_attributes.player_api_id FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.potential = (SELECT MIN(potential) FROM player_attributes) AND player_attributes.preferred_foot = 'right' LIMIT 3;
SELECT COUNT(*) AS num_players FROM player_attributes WHERE crossing = (SELECT MAX(crossing) FROM player_attributes) AND preferred_foot = 'left';
SELECT 100.0 * (     SELECT COUNT(*)      FROM player_attributes      WHERE stamina > 80 AND strength > 80 ) / (     SELECT COUNT(*)      FROM player_attributes );
SELECT country.name FROM country JOIN league ON country.id = league.country_id WHERE league.name = 'Poland Ekstraklasa';
SELECT home_team_goal, away_team_goal FROM match JOIN league ON match.league_id = league.id JOIN country ON league.country_id = country.id WHERE country.name = 'Belgium' AND league.name = 'Belgium Jupiler League' AND match.date LIKE '2008-09-24%' LIMIT 1;
SELECT player_attributes.sprint_speed, player_attributes.agility, player_attributes.acceleration FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Alexis Blin';
SELECT MAX(team_attributes.buildupplayspeedclass) AS speed_class FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'KSV Cercle Brugge';
SELECT COUNT(match.id) FROM     match JOIN     league ON match.league_id = league.id WHERE     league.name = 'Italy Serie A'     AND match.season = '2015/2016';
SELECT MAX(home_team_goal) FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Netherlands Eredivisie';
SELECT MAX(weight), finishing, curve FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE weight = (SELECT MAX(weight) FROM player);
SELECT league.name AS league_name, COUNT(match.id) AS num_games FROM match JOIN league ON match.league_id = league.id WHERE match.season = '2015/2016' GROUP BY league_name ORDER BY num_games DESC LIMIT 1;
SELECT team.team_long_name FROM     team JOIN     match ON match.away_team_api_id = team.team_api_id WHERE     match.away_team_goal = (         SELECT            MAX(away_team_goal)         FROM             match     );
SELECT player.player_name FROM player INNER JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.strength = (SELECT MAX(strength) FROM player_attributes);
SELECT (COUNT(*) * 100) / (     SELECT COUNT(*)     FROM player     WHERE height < 180 ) AS percentage FROM player_attributes WHERE overall_rating > 70;
SELECT CAST(SUM(CASE WHEN Admission = '+' THEN 1 ELSE 0 END) - SUM(CASE WHEN Admission = '-' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(Id) FROM patient WHERE Sex = 'M'
SELECT SUM(expense.cost) AS total_cost FROM     expense     JOIN budget ON expense.link_to_budget = budget.budget_id     JOIN event ON budget.link_to_event = event.event_id WHERE     expense.expense_description = 'Posters'     AND event.event_date = '2019-09-04' 
SELECT MAX(budget.remaining) FROM budget WHERE category = 'Food'
SELECT notes FROM income WHERE source = 'Fundraising' AND date_received = '2019-09-14';
SELECT COUNT(DISTINCT major_id)  FROM major  WHERE college = 'College of Humanities and Social Sciences'; 
SELECT member.phone FROM member WHERE member.first_name = 'Carlo' AND member.last_name = 'Jacobs'; 
SELECT county FROM     zip_code JOIN     member ON zip_code.zip_code = member.zip WHERE     member.first_name = 'Adela' AND member.last_name = 'O\'Gallagher';
SELECT COUNT(*)  FROM budget  JOIN event ON budget.link_to_event = event.event_id  WHERE event.event_name = 'November Meeting' AND budget.remaining < 0;
SELECT SUM(amount) FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event_name = 'September Speaker';
SELECT event.status FROM event JOIN expense ON event.event_id = expense.link_to_budget WHERE expense.expense_description = 'Post Cards, Posters' AND expense.expense_date = '2019-08-20';
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Brent' AND member.last_name = 'Thomason';
SELECT COUNT(member.member_id) FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Human Development and Family Studies' AND member.t_shirt_size = 'Large';
SELECT zip_code.type FROM     member JOIN     zip_code ON member.zip = zip_code.zip_code WHERE     member.first_name = 'Christof'     AND member.last_name = 'Nielson';
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'Vice President'
SELECT zip_code.short_state FROM     member JOIN     zip_code ON member.zip = zip_code.zip_code WHERE     member.first_name = 'Sacha' AND member.last_name = 'Harrison';
SELECT major.department FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'President';
SELECT income.date_received FROM income JOIN member ON income.link_to_member = member.member_id WHERE member.first_name = 'Connor' AND member.last_name = 'Hilton' AND income.source = 'Dues';
SELECT MIN(member.first_name || ' ' || member.last_name) FROM income JOIN member ON income.link_to_member = member.member_id WHERE income.source = 'Dues'
SELECT COUNT(b1.category)  FROM budget AS b1 JOIN event AS e1 ON b1.link_to_event = e1.event_id JOIN budget AS b2 ON b2.link_to_event = e1.event_id JOIN event AS e2 ON b2.link_to_event = e2.event_id WHERE e1.event_name = 'Yearly Kickoff' AND e2.event_name = 'October Meeting'  AND b1.category = 'Advertisement' AND b2.category = 'Advertisement'  AND b1.amount > b2.amount;
SELECT 100 * (SELECT SUM(b.amount) / (SELECT SUM(b2.amount) FROM budget b2 JOIN event e ON b2.link_to_event = e.event_id WHERE e.event_name = 'November Speaker') FROM budget b JOIN event e ON b.link_to_event = e.event_id WHERE b.category = 'Parking' AND e.event_name = 'November Speaker');
SELECT SUM(cost) AS total_pizza_cost FROM expense WHERE expense_description = 'Pizza';
SELECT COUNT(DISTINCT city) FROM zip_code WHERE county = 'Orange County' AND state = 'Virginia';
SELECT department FROM major WHERE college = 'College of Humanities and Social Sciences'; 
SELECT zip_code.city, zip_code.county, zip_code.state FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Amy' AND member.last_name = 'Firth';
SELECT expense.expense_description FROM   expense JOIN   budget ON expense.link_to_budget = budget.budget_id WHERE   budget.remaining = (     SELECT      MIN(remaining)     FROM       budget   );
SELECT member.first_name, member.last_name FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'October Meeting'; 
SELECT MAX(COUNT(major.college)) FROM member JOIN major ON member.link_to_major = major.major_id GROUP BY major.college
SELECT major.major_name FROM member JOIN zip_code ON member.zip = zip_code.zip_code JOIN major ON member.link_to_major = major.major_id WHERE member.phone = '809-555-3360';
SELECT event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event ORDER BY budget.amount DESC LIMIT 1;
SELECT expense.* FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.position = 'Vice President';
SELECT COUNT(DISTINCT member.member_id) AS attendance_count FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id WHERE event.event_name = 'Women\'s Soccer';
SELECT event_date FROM income JOIN member ON income.link_to_member = member.member_id WHERE member.first_name = 'Casey' AND member.last_name = 'Mason';
SELECT COUNT(DISTINCT member.member_id) FROM     member JOIN     zip_code ON member.zip = zip_code.zip_code WHERE     zip_code.state = 'Maryland';
SELECT COUNT(DISTINCT event.event_id) AS attended_events FROM attendance JOIN event ON attendance.link_to_event = event.event_id JOIN member ON attendance.link_to_member = member.member_id WHERE member.phone = '954-555-6240';
SELECT member.first_name || ' ' || member.last_name AS full_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.department = 'School of Applied Sciences, Technology and Education'; 
SELECT event.event_id, event.event_name, MAX(expense.cost / budget.amount) AS spend_to_budget_ratio FROM event INNER JOIN budget ON event.event_id = budget.link_to_event INNER JOIN expense ON budget.budget_id = expense.link_to_budget WHERE event.status = 'Closed' GROUP BY event.event_id ORDER BY spend_to_budget_ratio DESC LIMIT 1;
SELECT COUNT(member.member_id) FROM     member WHERE     member.position = 'President';
SELECT MAX(spent) AS highest_budget_spend FROM budget;
SELECT COUNT(*)  FROM event  WHERE type = 'Meeting' AND strftime('%Y', event_date) = '2020';
SELECT SUM(spent) AS total_food_spent FROM budget WHERE category = 'Food';
SELECT first_name || ' ' || last_name AS student_name FROM member JOIN attendance ON member.member_id = attendance.link_to_member GROUP BY member.member_id HAVING COUNT(attendance.link_to_event) > 7; 
SELECT member.first_name, member.last_name, member.email FROM member INNER JOIN attendance ON member.member_id = attendance.link_to_member INNER JOIN event ON attendance.link_to_event = event.event_id INNER JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Interior Design' AND event.event_name = 'Community Theater';
SELECT member.first_name, member.last_name FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE zip_code.city = 'Georgetown' AND zip_code.state = 'South Carolina';
SELECT COUNT(income.income_id) FROM     income JOIN     member ON income.link_to_member = member.member_id WHERE     member.first_name = 'Grant' AND member.last_name = 'Gilmour';
SELECT member.first_name || ' ' || member.last_name AS student_name FROM income JOIN member ON income.link_to_member = member.member_id WHERE income.amount > 40;
SELECT SUM(expense.cost) AS total_expense FROM expense JOIN event ON expense.link_to_budget = event.event_id WHERE event.event_name = 'Yearly Kickoff';
SELECT member.first_name, member.last_name FROM member JOIN budget ON member.member_id = budget.link_to_event JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'Yearly Kickoff';
SELECT member.first_name || ' ' || member.last_name AS student_name, income.source AS income_source FROM income JOIN member ON income.link_to_member = member.member_id WHERE income.amount = (SELECT MAX(amount) FROM income)
SELECT event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event GROUP BY event.event_name ORDER BY MIN(budget.amount) LIMIT 1;
SELECT (DIVIDE((SELECT SUM(expense.cost)  FROM expense  JOIN budget ON expense.link_to_budget = budget.budget_id  JOIN event ON budget.link_to_event = event.event_id  WHERE event.event_name = 'Yearly Kickoff'),  (SELECT SUM(expense.cost)  FROM expense  JOIN budget ON expense.link_to_budget = budget.budget_id))) * 100 as percentage_cost_yearly_kickoff;
SELECT CAST((SELECT COUNT(*) FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Finance') AS FLOAT) / CAST((SELECT COUNT(*) FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Physics') AS FLOAT); 
SELECT MAX(source) FROM income WHERE date_received BETWEEN '2019-09-01' AND '2019-09-30'
SELECT member.first_name || ' ' || member.last_name AS full_name, member.email FROM member WHERE member.position = 'Secretary';
SELECT COUNT(member.member_id) FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Physics Teaching';
SELECT COUNT(DISTINCT member.member_id) AS attended_members FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id WHERE event.event_name = 'Community Theater' AND strftime('%Y', event.event_date) = '2019';
SELECT COUNT(DISTINCT event.event_id) AS events_attended, major.major_name AS major FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Luisa' AND member.last_name = 'Guidi';
SELECT ROUND(DIVIDE(SUM(expense.cost), COUNT(DISTINCT event.event_id)), 2) AS average_food_expense FROM     expense JOIN     budget ON expense.link_to_budget = budget.budget_id JOIN     event ON budget.link_to_event = event.event_id WHERE     budget.category = 'Food'     AND event.status = 'Closed';
SELECT event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.category = 'Advertisement' ORDER BY budget.spent DESC LIMIT 1;
SELECT CASE      WHEN EXISTS (         SELECT 1         FROM member         JOIN attendance ON member.member_id = attendance.link_to_member         JOIN event ON attendance.link_to_event = event.event_id         WHERE member.first_name = 'Maya'          AND member.last_name = 'Mclean'          AND event.event_name = 'Women\'s Soccer'     )     THEN 'Yes'     ELSE 'No' END;
SELECT ((SELECT COUNT(*) FROM event WHERE type = 'Community Service' AND event_date BETWEEN '2019-01-01' AND '2019-12-31') * 100.0) / (SELECT COUNT(*) FROM event WHERE event_date BETWEEN '2019-01-01' AND '2019-12-31') AS percentage_share_community_service;
SELECT SUM(expense.cost) FROM     expense JOIN     event ON expense.link_to_event = event.event_id WHERE     event.event_name = 'September Speaker'     AND expense.expense_description = 'Posters';
SELECT MAX(t_shirt_size) AS most_popular_t_shirt_size FROM   member
SELECT event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE event.status = 'Closed' AND budget.remaining < 0 ORDER BY budget.remaining LIMIT 1;
SELECT expense.expense_description, SUM(expense.cost) AS total_approved_value FROM expense JOIN budget ON expense.link_to_budget = budget.budget_id JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'October Meeting' GROUP BY expense.expense_description; 
SELECT category, SUM(amount) AS total_budget FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'April Speaker' GROUP BY category ORDER BY total_budget ASC; 
SELECT MAX(amount) FROM budget WHERE category = 'Food'
SELECT budget_id, category, MAX(amount) AS max_budget_amount FROM budget WHERE category = 'Advertising' GROUP BY budget_id ORDER BY max_budget_amount DESC LIMIT 3;
SELECT SUM(cost) FROM expense WHERE expense_description = 'Parking';
SELECT SUM(cost) AS total_expense FROM expense WHERE expense_date = '2019-08-20';
SELECT member.first_name || ' ' || member.last_name AS full_name, SUM(expense.cost) AS total_cost FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE member.member_id = 'rec4BLdZHS2Blfp4v';
SELECT expense.expense_description FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.first_name = 'Sacha' AND member.last_name = 'Harrison';
SELECT expense.expense_description FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.t_shirt_size = 'X-Large';
SELECT member.zip FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE expense.cost < 50;
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Phillip' AND member.last_name = 'Cullen';
SELECT member.position FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Business';
SELECT COUNT(member.member_id) FROM     member JOIN     major ON member.link_to_major = major.major_id WHERE     major.major_name = 'Business'     AND member.t_shirt_size = 'Medium';
SELECT event.type FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.remaining > 30;
SELECT budget.category FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE event.location = 'MU 215';
SELECT budget.category FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE event.event_date = '2020-03-24T12:00:00';
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'Vice President';
SELECT DIVIDE(SUM(CASE WHEN member.position = 'Member' AND major.major_name = 'Mathematics' THEN 1 ELSE 0 END), COUNT(member.member_id)) * 100 AS percentage_mathematics_members
SELECT budget.category FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.location = 'MU 215';
SELECT COUNT(*) FROM income WHERE amount = 50;
SELECT COUNT(*) FROM     member WHERE     position = 'Member'     AND t_shirt_size = 'X-Large';
SELECT COUNT(major_id)  FROM major  WHERE department = 'School of Applied Sciences, Technology and Education'  AND college = 'College of Agriculture and Applied Sciences'; 
SELECT member.last_name, major.department, major.college FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Environmental Engineering';
SELECT budget.category FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE event.location = 'MU 215' AND event.type = 'Guest Speaker' AND budget.spent = 0;
SELECT zip_code.city, zip_code.state FROM member JOIN major ON member.link_to_major = major.major_id JOIN zip_code ON member.zip = zip_code.zip_code WHERE major.department = 'Electrical and Computer Engineering Department' AND member.position = 'Member'; 
SELECT event.event_name FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id WHERE event.type = 'Social' AND member.position = 'Vice President' AND event.location = '900 E. Washington St.';
SELECT member.last_name, member.position FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE expense.expense_description = 'Pizza' AND expense.expense_date = '2019-09-10';
SELECT member.last_name FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'Women\'s Soccer' AND member.position = 'Member';
SELECT 100 * COUNT(CASE WHEN m.t_shirt_size = 'Medium' AND i.amount = 50 THEN 1 END) / COUNT(m.member_id) FROM member m JOIN income i ON m.member_id = i.link_to_member WHERE m.position = 'Member';
SELECT DISTINCT state FROM zip_code WHERE type = 'PO Box';
SELECT zip_code FROM zip_code WHERE county = 'San Juan Municipio' AND state = 'Puerto Rico' AND type = 'PO Box';
SELECT event.event_name FROM event WHERE event.type = 'Game' AND event.status = 'Closed' AND event.event_date BETWEEN '2019-03-15' AND '2020-03-20';
SELECT event.event_id, event.event_name FROM expense JOIN member ON expense.link_to_member = member.member_id JOIN event ON expense.link_to_budget = event.event_id WHERE expense.cost > 50;
SELECT member.first_name, member.last_name, event.event_name AS attended_event, attendance.link_to_event AS event_link FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id JOIN expense ON member.member_id = expense.link_to_member WHERE expense.approved = 'true' AND expense.expense_date BETWEEN '2019-01-10' AND '2019-11-19'; 
SELECT major.college FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Katy' AND member.link_to_major = 'rec1N0upiVLy5esTO'; 
SELECT member.phone FROM member JOIN major ON member.link_to_major = major.major_id JOIN zip_code ON member.zip = zip_code.zip_code WHERE major.major_name = 'Business' AND major.college = 'College of Agriculture and Applied Sciences';
SELECT member.email FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE expense_date BETWEEN '2019-09-10' AND '2019-11-19' AND cost > 20;
SELECT COUNT(member.member_id) FROM member JOIN major ON member.link_to_major = major.major_id JOIN zip_code ON member.zip = zip_code.zip_code WHERE major.major_name = 'Education' AND major.college = 'College of Education & Human Services';
SELECT 100 * SUM(CASE WHEN budget.remaining < 0 THEN 1 ELSE 0 END) / COUNT(DISTINCT event.event_id) AS percentage_of_events_over_budget FROM budget JOIN event ON budget.link_to_event = event.event_id;
SELECT event.event_id, event.location, event.status FROM event WHERE event.event_date BETWEEN '2019-11-01' AND '2020-03-31';
SELECT expense_description FROM expense GROUP BY expense_description HAVING AVG(cost) > 50; 
SELECT member.first_name || ' ' || member.last_name AS full_name FROM member WHERE member.t_shirt_size = 'X-Large';
SELECT 100 * (SELECT COUNT(*) FROM zip_code WHERE type = 'PO Box') / (SELECT COUNT(*) FROM zip_code) AS percentage_of_po_boxes;
SELECT event.event_name, event.location FROM event INNER JOIN budget ON event.event_id = budget.link_to_event WHERE budget.remaining > 0;
SELECT event.event_name, event.event_date FROM event JOIN expense ON event.event_id = expense.link_to_budget WHERE expense.expense_description = 'Pizza' AND expense.cost > 50 AND expense.cost < 100;
SELECT member.first_name, member.last_name, major.major_name FROM member JOIN major ON member.link_to_major = major.major_id JOIN expense ON member.member_id = expense.link_to_member WHERE expense.cost > 100;
SELECT event.location, zip_code.city, zip_code.state, zip_code.country FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN income ON attendance.link_to_member = income.link_to_member JOIN zip_code ON event.location = zip_code.zip_code GROUP BY event.event_id HAVING COUNT(DISTINCT income.income_id) > 40;
SELECT member.first_name, member.last_name, MAX(expense.cost) AS max_expense_amount FROM member JOIN expense ON member.member_id = expense.link_to_member GROUP BY member.member_id HAVING COUNT(DISTINCT expense.link_to_event) > 1;
SELECT DIVIDE(SUM(expense.cost), COUNT(DISTINCT expense.link_to_event)) FROM     expense JOIN     member ON expense.link_to_member = member.member_id WHERE     member.position != 'Member';
SELECT event.event_name FROM event INNER JOIN budget ON event.event_id = budget.link_to_event INNER JOIN expense ON budget.budget_id = expense.link_to_budget WHERE expense.category = 'Parking' GROUP BY event.event_id HAVING expense.cost < (     SELECT        AVG(parking_cost)     FROM         (             SELECT                event.event_id,                 SUM(expense.cost) AS parking_cost             FROM                 event             INNER JOIN budget ON event.event_id = budget.link_to_event             INNER JOIN expense ON budget.budget_id = expense.link_to_budget             WHERE                 expense.category = 'Parking'             GROUP BY                 event.event_id         ) );
SELECT ROUND(   (     SUM(CASE WHEN event.type = 'Game' THEN expense.cost ELSE 0 END) /     COUNT(CASE WHEN event.type = 'Game' THEN event.event_id ELSE NULL END)   ) * 100,    2 ) AS percentage_cost_game_events
SELECT budget.budget_id, MAX(expense.cost) AS max_expense FROM budget JOIN expense ON budget.budget_id = expense.link_to_budget WHERE expense.expense_description = 'Water, chips, cookies' GROUP BY budget.budget_id;
SELECT member.first_name || ' ' || member.last_name AS full_name FROM     member JOIN     expense ON member.member_id = expense.link_to_member GROUP BY     member.member_id ORDER BY     MAX(expense.cost) DESC LIMIT 5;
SELECT member.first_name || ' ' || member.last_name AS full_name, member.phone AS contact_number FROM member INNER JOIN expense ON member.member_id = expense.link_to_member WHERE expense.cost > (SELECT AVG(cost) FROM expense)
SELECT 100 * (     (         (SELECT COUNT(*) FROM member WHERE zip IN (SELECT zip_code FROM zip_code WHERE state = 'Maine')) /         (SELECT COUNT(*) FROM member WHERE position = 'Member')     ) -     (         (SELECT COUNT(*) FROM member WHERE zip IN (SELECT zip_code FROM zip_code WHERE state = 'Vermont')) /         (SELECT COUNT(*) FROM member WHERE position = 'Member')     ) ) AS percentage_difference;
SELECT major.major_name, major.department FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Garrett' AND member.last_name = 'Gerke';
SELECT member.first_name || ' ' || member.last_name AS full_name, expense.cost AS spent_amount FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE expense.expense_description = 'Water, Veggie tray, supplies';
SELECT member.last_name, member.phone FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Elementary Education';
SELECT budget.category, budget.amount FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'January Speaker'; 
SELECT event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.category = 'Food'; 
SELECT member.first_name || ' ' || member.last_name AS full_name, income.amount AS received_funds FROM income JOIN member ON income.link_to_member = member.member_id WHERE income.date_received = '2019-09-09';
SELECT budget.category FROM expense JOIN budget ON expense.link_to_budget = budget.budget_id WHERE expense.expense_description = 'Posters';
SELECT member.first_name || ' ' || member.last_name AS full_name, major.college FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'Secretary';
SELECT event.event_name, SUM(budget.spent) AS total_amount_spent FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE budget.category = 'Speaker Gifts' GROUP BY event.event_name; 
SELECT city FROM     member JOIN     zip_code ON member.zip = zip_code.zip_code WHERE     member.first_name = 'Garrett' AND member.last_name = 'Girke';
SELECT member.first_name, member.last_name, member.position FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE zip_code.city = 'Lincolnton' AND zip_code.state = 'North Carolina' AND zip_code.zip_code = '28092';
SELECT COUNT(DISTINCT gasstationid) FROM gasstations WHERE country = 'CZE' AND segment = 'Premium';
SELECT COUNT(CASE WHEN currency = 'EUR' THEN customerid END) * 1.0 / COUNT(CASE WHEN currency = 'CZK' THEN customerid END) as ratio FROM customers;
SELECT customers.customerid, SUM(yearmonth.consumption) AS total_consumption FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.segment = 'LAM' AND yearmonth.date BETWEEN '201201' AND '201212' GROUP BY customers.customerid ORDER BY total_consumption ASC LIMIT 1;
SELECT AVG(consumption) / 12 AS average_monthly_consumption FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE segment = 'SME' AND date BETWEEN 201301 AND 201312;
SELECT customers.customerid, SUM(transactions_1k.amount) AS total_consumption FROM customers JOIN transactions_1k ON customers.customerid = transactions_1k.customerid JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE customers.currency = 'CZK' AND transactions_1k.date BETWEEN '201101' AND '201112' GROUP BY customers.customerid ORDER BY total_consumption DESC;
SELECT COUNT(DISTINCT customers.customerid) FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.segment = 'KAM' AND yearmonth.date BETWEEN 201201 AND 201212 AND yearmonth.consumption < 30000;
SELECT SUM(CASE WHEN customers.currency = 'CZK' THEN yearmonth.consumption ELSE 0 END) - SUM(CASE WHEN customers.currency = 'EUR' THEN yearmonth.consumption ELSE 0 END) AS consumption_difference FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE yearmonth.date BETWEEN '201201' AND '201212';
SELECT MAX(strftime('%Y', date)) AS year FROM transactions_1k WHERE currency = 'EUR'
SELECT segment, SUM(consumption) AS total_consumption FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid GROUP BY segment ORDER BY total_consumption ASC LIMIT 1; 
SELECT MAX(substr(date, 1, 4)) AS year FROM yearmonth JOIN transactions_1k ON yearmonth.customerid = transactions_1k.customerid JOIN customers ON transactions_1k.customerid = customers.customerid WHERE currency = 'CZK'
SELECT MAX(yearmonth.consumption) AS max_consumption, SUBSTR(yearmonth.date, 5, 2) AS month FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE customers.segment = 'SME' AND SUBSTR(yearmonth.date, 1, 4) = '2013' GROUP BY SUBSTR(yearmonth.date, 5, 2)
SELECT AVG((SELECT SUM(consumption) FROM yearmonth WHERE customerid IN (SELECT customerid FROM yearmonth WHERE substr(date, 1, 4) = '2013' GROUP BY segment ORDER BY MIN(consumption) LIMIT 1) AND substr(date, 1, 4) = '2013')) - AVG((SELECT SUM(consumption) FROM yearmonth WHERE customerid IN (SELECT customerid FROM yearmonth WHERE substr(date, 1, 4) = '2013' AND segment = 'LAM' GROUP BY segment ORDER BY MIN(consumption) LIMIT 1) AND substr(date, 1, 4) = '2013')),  AVG((SELECT SUM(consumption) FROM yearmonth WHERE customerid IN (SELECT customerid FROM yearmonth WHERE substr(date, 1, 4) = '2013' AND segment = 'LAM' GROUP BY segment ORDER BY MIN(consumption) LIMIT 1) AND substr(date, 1, 4) = '2013')) - AVG((SELECT SUM(consumption) FROM yearmonth WHERE customerid IN (SELECT customerid FROM yearmonth WHERE substr(date, 1, 4) = '2013' AND segment = 'KAM' GROUP BY segment ORDER BY MIN(consumption) LIMIT 1) AND substr(date, 1, 4) = '2013')),  AVG((SELECT SUM(consumption) FROM yearmonth WHERE customerid IN (SELECT customerid FROM yearmonth WHERE substr(date, 1, 4) = '2013' AND segment = 'KAM' GROUP BY segment ORDER BY MIN(consumption) LIMIT 1) AND substr(date, 1, 4) = '2013')) - AVG((SELECT SUM(consumption) FROM yearmonth WHERE customerid IN (SELECT customerid FROM yearmonth WHERE substr(date, 1, 4) = '2013' AND segment = 'SME' GROUP BY segment ORDER BY MIN(consumption) LIMIT 1) AND substr(date, 1, 4) = '2013'))   FROM yearmonth;
SELECT MAX((yearmonth_2013.consumption - yearmonth_2012.consumption) / yearmonth_2013.consumption * 100) AS max_increase_percentage, MIN((yearmonth_2013.consumption - yearmonth_2012.consumption) / yearmonth_2013.consumption * 100) AS min_increase_percentage, CASE     WHEN segment = 'SME' THEN 'SME'     WHEN segment = 'LAM' THEN 'LAM'     ELSE 'KAM' END AS segment FROM (     SELECT        customers.segment AS segment,         SUM(CASE WHEN yearmonth.date LIKE '2012%' THEN yearmonth.consumption ELSE 0 END) AS consumption_2012,         SUM(CASE WHEN yearmonth.date LIKE '2013%' THEN yearmonth.consumption ELSE 0 END) AS consumption_2013     FROM customers     JOIN yearmonth ON customers.customerid = yearmonth.customerid     WHERE customers.currency = 'EUR'     GROUP BY customers.segment ) AS segment_consumption JOIN yearmonth AS yearmonth_2012 ON yearmonth_2012.customerid = segment_consumption.customerid JOIN yearmonth AS yearmonth_2013 ON yearmonth_2013.customerid = segment_consumption.customerid WHERE yearmonth_2012.date LIKE '2012%' AND yearmonth_2013.date LIKE '2013%';
SELECT SUM(amount) FROM transactions_1k WHERE customerid = 6 AND date BETWEEN '201308' AND '201311';
SELECT COUNT(DISTINCT CASE     WHEN g.country = 'CZE' AND g.segment = 'Discount' THEN g.gasstationid     ELSE NULL END) - COUNT(DISTINCT CASE     WHEN g.country = 'SVK' AND g.segment = 'Discount' THEN g.gasstationid     ELSE NULL END) AS more_discount_gas_stations FROM gasstations g;
SELECT SUM(yearmonth.consumption) AS consumption_difference FROM     yearmonth JOIN     customers ON yearmonth.customerid = customers.customerid WHERE     customers.customerid = 7     AND yearmonth.date = 201304 UNION ALL SELECT    SUM(yearmonth.consumption) AS consumption_difference FROM     yearmonth JOIN     customers ON yearmonth.customerid = customers.customerid WHERE     customers.customerid = 5     AND yearmonth.date = 201304;
SELECT COUNT(DISTINCT CASE WHEN segment = 'SME' AND currency = 'CZK' THEN customerid END) - COUNT(DISTINCT CASE WHEN segment = 'SME' AND currency = 'EUR' THEN customerid END) AS difference FROM customers;
SELECT MAX(consumption) FROM     yearmonth JOIN     customers ON yearmonth.customerid = customers.customerid WHERE     segment = 'LAM'     AND currency = 'EUR'     AND date = '201310';
SELECT customers.customerid, SUM(yearmonth.consumption) AS total_consumption FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.segment = 'KAM' GROUP BY customers.customerid ORDER BY total_consumption DESC LIMIT 1; 
SELECT SUM(yearmonth.consumption) AS total_consumption FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE customers.segment = 'KAM' AND yearmonth.date = '201305'; 
SELECT 100.0 * (     SELECT COUNT(*)     FROM yearmonth     JOIN customers ON yearmonth.customerid = customers.customerid     WHERE customers.segment = 'LAM' AND yearmonth.consumption > 46.73 ) / (     SELECT COUNT(*)     FROM customers     WHERE segment = 'LAM' ) AS percentage;
SELECT gasstations.country, COUNT(gasstations.gasstationid) AS num_value_for_money_gas_stations FROM gasstations WHERE gasstations.segment = 'Value for money' GROUP BY gasstations.country; 
SELECT (CAST((SELECT COUNT(*) FROM customers WHERE segment = 'KAM' AND currency = 'EUR') AS REAL) / CAST((SELECT COUNT(*) FROM customers WHERE segment = 'KAM') AS REAL)) * 100 AS percentage_KAM_EUR;
SELECT ROUND(     (COUNT(DISTINCT yearmonth.customerid) * 1.0 / (SELECT COUNT(DISTINCT customerid) FROM yearmonth WHERE date LIKE '201202')) * 100, 2 ) AS percentage_consumers FROM yearmonth WHERE date = '201202' AND consumption > 528.3;
SELECT ROUND((COUNT(CASE WHEN gasstations.segment = 'Premium' AND gasstations.country = 'SVK' THEN 1 END) * 1.0 / COUNT(CASE WHEN gasstations.country = 'SVK' THEN 1 END)) * 100, 2) AS percentage_of_premium_gas_stations_in_Slovakia FROM gasstations WHERE gasstations.country = 'SVK';
SELECT customers.customerid FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE yearmonth.date = '201309' ORDER BY yearmonth.consumption DESC LIMIT 1;
SELECT segment, SUM(consumption) AS total_consumption FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE date = '201309' GROUP BY segment ORDER BY total_consumption LIMIT 1;
SELECT customers.customerid, MIN(yearmonth.consumption) AS min_consumption FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.segment = 'SME' AND yearmonth.date = '201206' GROUP BY customers.customerid ORDER BY min_consumption LIMIT 1;
SELECT MAX(consumption) AS highest_monthly_consumption FROM yearmonth WHERE date LIKE '2012%'
SELECT MAX(total_monthly_consumption) AS biggest_monthly_consumption FROM (     SELECT        SUM(y.consumption) / 12 AS total_monthly_consumption     FROM         yearmonth y     JOIN         customers c ON y.customerid = c.customerid     WHERE         c.currency = 'EUR'     GROUP BY         y.customerid ) AS monthly_consumptions;
SELECT products.description FROM transactions_1k JOIN products ON transactions_1k.productid = products.productid WHERE transactions_1k.date LIKE '201309%'
SELECT DISTINCT gasstations.country FROM     transactions_1k JOIN     gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE     substr(transactions_1k.date, 1, 6) = '201306';
SELECT DISTINCT gasstations.chainid FROM   gasstations JOIN   transactions_1k ON gasstations.gasstationid = transactions_1k.gasstationid JOIN   customers ON transactions_1k.customerid = customers.customerid WHERE   customers.currency = 'EUR'; 
SELECT products.description FROM transactions_1k JOIN products ON transactions_1k.productid = products.productid JOIN customers ON transactions_1k.customerid = customers.customerid WHERE customers.currency = 'EUR';
SELECT AVG(price * amount) AS average_total_price FROM transactions_1k WHERE date LIKE '2012-01%'
SELECT COUNT(DISTINCT customers.customerid) FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.currency = 'EUR' AND yearmonth.consumption > 1000;
SELECT products.description FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid JOIN products ON transactions_1k.productid = products.productid WHERE gasstations.country = 'CZE';
SELECT DISTINCT time FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE chainid = 11; 
SELECT COUNT(*) FROM     transactions_1k JOIN     gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE     gasstations.country = 'CZE' AND transactions_1k.price > 1000;
SELECT COUNT(*) FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE gasstations.country = 'CZE' AND date > '2012-01-01';
SELECT AVG(price * amount) AS average_total_price FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE gasstations.country = 'CZE';
SELECT AVG(total_price) AS average_total_price FROM (     SELECT SUM(price) AS total_price     FROM transactions_1k     WHERE customerid IN (SELECT customerid FROM customers WHERE currency = 'EUR')     GROUP BY customerid ) euro_transactions; 
SELECT customers.customerid FROM transactions_1k JOIN customers ON transactions_1k.customerid = customers.customerid WHERE transactions_1k.date = '2012-08-25' ORDER BY transactions_1k.price DESC LIMIT 1;
SELECT gasstations.country FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE transactions_1k.date = '2012-08-25' ORDER BY transactions_1k.time LIMIT 1;
SELECT currency FROM     customers     JOIN transactions_1k ON customers.customerid = transactions_1k.customerid WHERE     transactions_1k.date = '2012-08-24'     AND transactions_1k.time = '16:25:00';
SELECT customers.segment FROM customers JOIN transactions_1k AS T1 ON customers.customerid = T1.customerid WHERE T1.date = '2012-08-23' AND T1.time = '21:20:00';
SELECT COUNT(*) FROM transactions_1k WHERE date = '2012-08-26' AND time < '13:00:00' AND currency = 'EUR';
SELECT segment FROM customers ORDER BY customerid ASC LIMIT 1; 
SELECT gasstations.country FROM transactions_1k AS T1 INNER JOIN gasstations ON T1.gasstationid = gasstations.gasstationid WHERE T1.date = '2012-08-24' AND T1.time = '12:42:00';
SELECT products.productid FROM transactions_1k AS T1 JOIN products ON T1.productid = products.productid WHERE T1.date = '2012-08-23' AND T1.time = '21:20:00';
SELECT SUM(transactions_1k.amount) AS january_expense,     yearmonth.date AS date,     yearmonth.consumption AS expenses FROM     transactions_1k JOIN     yearmonth ON transactions_1k.customerid = yearmonth.customerid WHERE     transactions_1k.customerid = (         SELECT            customerid         FROM             transactions_1k         WHERE             date = '2012-08-24'             AND amount = 124.05         LIMIT 1     )     AND yearmonth.date LIKE '201201%' GROUP BY     transactions_1k.customerid;
SELECT COUNT(*) FROM transactions_1k AS t JOIN gasstations AS g ON t.gasstationid = g.gasstationid WHERE t.date = '2012-08-26' AND t.time BETWEEN '08:00:00' AND '09:00:00' AND g.country = 'CZE';
SELECT currency FROM     customers WHERE     customerid = (         SELECT            customerid         FROM             yearmonth         WHERE             date = '201306'             AND consumption = 214582.17     )
SELECT gasstations.country FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE transactions_1k.cardid = 667467 LIMIT 1;
SELECT customers.country FROM customers JOIN transactions_1k ON customers.customerid = transactions_1k.customerid WHERE transactions_1k.date = '2012-08-24' AND transactions_1k.amount = 548.4;
SELECT ROUND((COUNT(DISTINCT customers.customerid) * 100.0) / (SELECT COUNT(DISTINCT customers.customerid) FROM customers INNER JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE yearmonth.date = '201208'), 2) AS percentage FROM customers INNER JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE yearmonth.date = '201208' AND customers.currency = 'EUR';
SELECT ROUND((y2012.consumption - y2013.consumption) / y2012.consumption, 2) AS decrease_rate FROM (     SELECT        c.customerid,         y.consumption     FROM         yearmonth y     JOIN         customers c ON y.customerid = c.customerid     WHERE         y.date LIKE '2012%'         AND c.customerid = (             SELECT                customerid             FROM                 transactions_1k             WHERE                 date = '2012-08-25'                 AND price = 634.8             LIMIT 1         ) ) y2012 JOIN (     SELECT        c.customerid,         y.consumption     FROM         yearmonth y     JOIN         customers c ON y.customerid = c.customerid     WHERE         y.date LIKE '2013%'         AND c.customerid = (             SELECT                customerid             FROM                 transactions_1k             WHERE                 date = '2012-08-25'                 AND price = 634.8             LIMIT 1         ) ) y2013 ON y2012.customerid = y2013.customerid;
SELECT gasstationid, SUM(amount * price) AS revenue FROM transactions_1k GROUP BY gasstationid ORDER BY revenue DESC LIMIT 1; 
SELECT ROUND(     (SELECT COUNT(*)      FROM transactions_1k AS t     JOIN gasstations AS g ON t.gasstationid = g.gasstationid     WHERE g.segment = 'Premium' AND g.country = 'SVK'     ) * 100.0 /     (SELECT COUNT(*)      FROM transactions_1k AS t     JOIN gasstations AS g ON t.gasstationid = g.gasstationid     WHERE g.country = 'SVK') , 2) AS percentage; 
SELECT SUM(transactions_1k.amount) AS total_spent FROM transactions_1k JOIN customers ON transactions_1k.customerid = customers.customerid WHERE customers.customerid = '38508' AND transactions_1k.date LIKE '201201%'
SELECT products.description, SUM(transactions_1k.amount) AS total_amount_sold FROM transactions_1k INNER JOIN products ON transactions_1k.productid = products.productid GROUP BY transactions_1k.productid ORDER BY total_amount_sold DESC LIMIT 5; 
SELECT customers.customerid, SUM(transactions_1k.price) AS total_spending, AVG(transactions_1k.price / transactions_1k.amount) AS average_price_per_item, customers.currency FROM customers JOIN transactions_1k ON customers.customerid = transactions_1k.customerid GROUP BY customers.customerid ORDER BY total_spending DESC LIMIT 1; 
SELECT country FROM gasstations WHERE gasstationid = (     SELECT gasstationid     FROM transactions_1k     WHERE productid = 2     ORDER BY price DESC     LIMIT 1 ) 
SELECT yearmonth.consumption FROM     yearmonth JOIN     transactions_1k ON yearmonth.customerid = transactions_1k.customerid WHERE     transactions_1k.date LIKE '201208%'     AND transactions_1k.price / transactions_1k.amount > 29.00     AND transactions_1k.productid = 5;
