SELECT MAX(frpm."percent (%) eligible free (k-12)") FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.county = 'Alameda';
SELECT edopsname, enrollment, free meal count (ages 5-17), percent (%) eligible free (ages 5-17) FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE edopsname = 'Continuation School' ORDER BY percent (%) eligible free (ages 5-17) ASC LIMIT 3; 
SELECT schools.zip FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE frpm.charter_school = 1 AND schools.county = 'Fresno County Office of Education';
SELECT schools.mailstreet || ', ' || schools.city || ', ' || schools.state || ' ' || schools.zip AS "Unabbreviated Mailing Address" FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE frpm.frpm_count_k_12 = (     SELECT MAX(frpm_count_k_12) FROM frpm );
SELECT schools.phone FROM schools INNER JOIN frpm ON frpm.cdscode = schools.cdscode WHERE frpm.charter = 1 AND frpm.opendate > '2000-01-01';
SELECT COUNT(*) FROM     satscores INNER JOIN     schools ON satscores.cds = schools.cdscode WHERE     avgscrmath < 400     AND virtual = 'F';
SELECT schools.school FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE satscores.numtsttakr > 500 AND schools.magnet = 1; 
SELECT schools.phone FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.numge1500 = (     SELECT    MAX(numge1500)     FROM     satscores     WHERE     numge1500 > 0 );
SELECT COUNT(satscores.numtsttakr) AS num_test_takers FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode ORDER BY frpm.frpm_count_k_12 DESC LIMIT 1;
SELECT COUNT(*)  FROM schools  JOIN satscores ON schools.cdscode = satscores.cds  WHERE satscores.avgscrmath > 560 AND schools.fundingtype = 'Charter funded'; 
SELECT frpm."frpm count (ages 5-17)" FROM     frpm JOIN     schools ON frpm.cdscode = schools.cdscode JOIN     satscores ON satscores.cds = schools.cdscode ORDER BY     satscores.avgscrread DESC LIMIT     1; 
SELECT frpm.cdscode FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE (frpm.enrollment + frpm.enrollment_ages_5_17) > 500;
SELECT MAX(schools."percent (%) eligible free (ages 5-17)") FROM   satscores JOIN   schools ON satscores.cds = schools.cdscode WHERE   satscores.numge1500 / satscores.numtsttakr > 0.3;
SELECT schools.phone FROM (     SELECT        *,         CAST(numge1500 AS REAL) / CAST(numtsttakr AS REAL) AS excellence_rate     FROM         satscores ) AS sat_scores JOIN schools ON sat_scores.cds = schools.cdscode ORDER BY excellence_rate DESC LIMIT 3;
SELECT schools.ncesschool FROM schools ORDER BY schools.enrollment DESC LIMIT 5; 
SELECT DISTINCT schools.district FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.statustype = 'Active' ORDER BY satscores.avgscrread DESC LIMIT 1; 
SELECT COUNT(DISTINCT schools.cdscode) FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.county = 'Alameda' AND schools.statustype = 'Merged' AND satscores.numtsttakr < 100 
SELECT schools.charternum FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE satscores.avgscrwrite = 499; 
SELECT COUNT(DISTINCT schools.school) FROM schools JOIN frpm ON schools.cdscode = frpm.cdscode JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.county = 'Contra Costa' AND schools.fundingtype = 'Directly funded' AND satscores.numtsttakr <= 250;
SELECT schools.phone FROM satscores JOIN schools ON satscores.cds = schools.cdscode ORDER BY satscores.avgscrmath DESC LIMIT 1; 
SELECT COUNT(*) FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.county = 'Amador' AND frpm.low_grade = 9 AND frpm.high_grade = 12;
SELECT COUNT(DISTINCT schools.school) FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE frpm.free_meal_count_k_12 > 500 AND frpm.free_meal_count_k_12 < 700 AND schools.county = 'Los Angeles'
SELECT satscores.sname FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE schools.county = 'Contra Costa' ORDER BY satscores.numtsttakr DESC LIMIT 1; 
SELECT schools.school, schools.street || ', ' || schools.city || ', ' || schools.state || ' ' || schools.zip AS full_address FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE (schools.enrollment - frpm."enrollment (ages 5-17)") > 30;
SELECT satscores.sname FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE (schools.percent_eligible_free_k12 > 0.1) AND (satscores.numge1500 > 0); 
SELECT schools.school, schools.fundingtype FROM frpm INNER JOIN schools ON frpm.cdscode = schools.cdscode INNER JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.county = 'Riverside' GROUP BY schools.school HAVING AVG(satscores.avgscrmath) > 400;
SELECT schools.school AS school_name, schools.streetabr || ', ' || schools.city || ', ' || schools.state || ', ' || schools.zip AS full_address FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE frpm.percent_eligible_frpm_ages_5_17 > 0.8 AND frpm.enrollment_ages_5_17 > 800 AND schools.gsserved LIKE '%-12' AND schools.county = 'Monterey';
SELECT  s.school, s.avgscrwrite, s.phone AS communication_number FROM satscores AS s JOIN schools AS sch ON s.cds = sch.cdscode WHERE (sch.opendate > '1991-01-01' OR sch.closeddate < '2000-01-01') AND s.avgscrwrite IS NOT NULL; 
SELECT schools.school, schools.doctype FROM schools INNER JOIN frpm ON frpm.cdscode = schools.cdscode INNER JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.fundingtype = 'Locally funded' AND (frpm.enrollment - frpm.enrollment_ages_5_17) > (     SELECT AVG(frpm.enrollment - frpm.enrollment_ages_5_17)     FROM frpm     INNER JOIN schools ON frpm.cdscode = schools.cdscode     WHERE schools.fundingtype = 'Locally funded' );
SELECT MAX(schools.opendate) FROM schools WHERE schools.gsserved LIKE '%1-12%'
SELECT schools.city FROM schools ORDER BY schools.gsserved ASC LIMIT 5; 
SELECT ROUND(schools."free meal count (k-12)" / schools.enrollment * 100, 2) AS "Eligible Free Rate" FROM schools ORDER BY enrollment DESC LIMIT 11 OFFSET 9;
SELECT ROUND((frpm.frpm_count / frpm.enrollment) * 100, 2) AS eligible_frpm_rate FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.soctype = '66' ORDER BY frpm.frpm_count DESC LIMIT 5; 
SELECT schools.school, schools.website FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE frpm.free_meal_count_ages_5_17 BETWEEN 1900 AND 2000 
SELECT frpm."Free Meal Count (Ages 5-17)" / frpm."Enrollment (Ages 5-17)" AS "Free Rate" FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.admfname1 = 'Kacey' AND schools.admlname1 = 'Gibson'
SELECT schools.admemail1 FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode WHERE frpm.charter = 1 ORDER BY frpm.enrollment LIMIT 1;
SELECT MAX(satscores.numge1500) AS max_numge1500,     schools.admfname1 || ' ' || schools.admlname1 AS administrator1,     schools.admfname2 || ' ' || schools.admlname2 AS administrator2,     schools.admfname3 || ' ' || schools.admlname3 AS administrator3 FROM     satscores JOIN     schools ON satscores.cds = schools.cdscode GROUP BY     administrator1 ORDER BY     max_numge1500 DESC LIMIT 1;
SELECT schools.street, schools.city, schools.state, schools.zip FROM schools JOIN satscores ON schools.cdscode = satscores.cds ORDER BY (satscores.numge1500 / satscores.numtsttakr) ASC LIMIT 1;
SELECT schools.website FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.county = 'Los Angeles' AND satscores.numtsttakr BETWEEN 2000 AND 3000; 
SELECT AVG(satscores.numtsttakr) AS average_test_takers FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE schools.opendate BETWEEN '1980-01-01' AND '1980-12-31' AND schools.county = 'Fresno';
SELECT schools.phone FROM schools INNER JOIN frpm ON frpm.cdscode = schools.cdscode INNER JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.district = 'Fresno Unified' ORDER BY satscores.avgscrread LIMIT 1;
SELECT schools.school, satscores.avgscrread FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.virtual = 'F' ORDER BY satscores.avgscrread DESC LIMIT 5; 
SELECT schools.edopsname FROM (     SELECT        sname,         avgscrmath     FROM         satscores     ORDER BY         avgscrmath DESC     LIMIT 1 ) AS top_math_score JOIN schools ON satscores.sname = schools.school; 
SELECT AVG(satscores.avgscrmath) AS average_math_score, schools.county AS county FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE (satscores.avgscrmath + satscores.avgscrread + satscores.avgscrwrite) = (     SELECT MIN(avgscrmath + avgscrread + avgscrwrite)     FROM satscores ) GROUP BY schools.county;
SELECT AVG(satscores.avgscrwrite) AS avg_writing_score, schools.city AS school_city FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE satscores.numge1500 = (     SELECT MAX(numge1500)     FROM satscores ) 
SELECT schools.school AS School, AVG(satscores.avgscrwrite) AS Average_Writing_Score FROM schools JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.admfname1 = 'Ricci' AND schools.admlname1 = 'Ulrich' GROUP BY schools.school; 
SELECT schools.school, schools.state, SUM(schools.gsserved) AS total_enrollment FROM schools WHERE schools.doc = 31 GROUP BY schools.school, schools.state ORDER BY total_enrollment DESC;
SELECT COUNT(schools.school) / 12 AS monthly_avg_opened_schools FROM schools WHERE schools.county = 'Alameda' AND schools.opendate LIKE '1980%'  AND schools.doc = '52'
SELECT COUNT(CASE WHEN schools.county = 'Orange' AND schools.statustype = 'Merged' AND schools.doctype = 'Elementary School District' THEN 1 END) /  COUNT(CASE WHEN schools.county = 'Orange' AND schools.statustype = 'Merged' AND schools.doctype = 'Unified School District' THEN 1 END) FROM schools;
SELECT COUNT(schools.school) AS num_closed_schools, schools.county AS county_name, schools.school AS school_name, schools.closeddate AS closure_date FROM schools WHERE schools.statustype = 'Closed' GROUP BY schools.county ORDER BY num_closed_schools DESC LIMIT 1;
SELECT schools.street || ', ' || schools.city || ', ' || schools.state || ' ' || schools.zip AS "Postal Street Address", satscores.sname AS "School Name" FROM satscores JOIN schools ON satscores.cds = schools.cdscode ORDER BY satscores.avgscrmath DESC LIMIT 1 OFFSET 5; 
SELECT schools.mailstreet, schools.school FROM schools INNER JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.avgscrread = (SELECT MIN(avgscrread) FROM satscores); 
SELECT COUNT(DISTINCT schools.school) FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE (satscores.avgscrread + satscores.avgscrmath + satscores.avgscrwrite) >= 1500 AND schools.mailcity = 'Lakeport';
SELECT COUNT(satscores.numtsttakr) FROM     satscores INNER JOIN     schools ON satscores.cds = schools.cdscode WHERE     schools.mailcity = 'Fresno';
SELECT schools.school, schools.mailzip FROM schools WHERE (schools.admfname1 = 'Avetik' AND schools.admlname1 = 'Atoian') OR (schools.admfname2 = 'Avetik' AND schools.admlname2 = 'Atoian') OR (schools.admfname3 = 'Avetik' AND schools.admlname3 = 'Atoian');
SELECT COUNT(CASE WHEN schools.county = 'Colusa' THEN 1 END) * 1.0 / COUNT(CASE WHEN schools.county = 'Humboldt' THEN 1 END) AS ratio FROM schools WHERE schools.mailstate = 'CA';
SELECT COUNT(*) FROM schools WHERE state = 'CA' AND county = 'San Joaquin' AND statustype = 'Active';
SELECT schools.phone, schools.ext FROM schools JOIN (     SELECT     sname, avgscrwrite     FROM     satscores     ORDER BY      avgscrwrite DESC     LIMIT 1 OFFSET 332 ) AS t ON schools.school = t.sname; 
SELECT schools.school, schools.phone, schools.ext FROM schools WHERE schools.zip = '95203-3704'; 
SELECT schools.website FROM schools WHERE (schools.admfname1 = 'Mike' AND schools.admlname1 = 'Larson') OR (schools.admfname1 = 'Dante' AND schools.admlname1 = 'Alvarez') OR (schools.admfname2 = 'Mike' AND schools.admlname2 = 'Larson') OR (schools.admfname2 = 'Dante' AND schools.admlname2 = 'Alvarez') OR (schools.admfname3 = 'Mike' AND schools.admlname3 = 'Larson') OR (schools.admfname3 = 'Dante' AND schools.admlname3 = 'Alvarez'); 
SELECT schools.website FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.virtual = 'P' AND schools.charter = 1 AND schools.county = 'San Joaquin';
SELECT COUNT(*) FROM schools WHERE city = 'Hickman'  AND doctype = 'Elementary School District'  AND charter = 1;
SELECT COUNT(*) FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode WHERE schools.county = 'Los Angeles' AND schools.charter = 0 AND (frpm."Free Meal Count (K-12)" * 100 / frpm."Enrollment (K-12)") < 0.18;
SELECT schools.school, schools.city, schools.admfname1 || ' ' || schools.admlname1 AS administrator_1, schools.admfname2 || ' ' || schools.admlname2 AS administrator_2, schools.admfname3 || ' ' || schools.admlname3 AS administrator_3 FROM schools WHERE schools.charter = 1 AND schools.charternum = '00D2';
SELECT COUNT(*) FROM schools WHERE mailcity = 'Hickman' AND charternum = '00D4';
SELECT 100 * (     SELECT COUNT(*)      FROM schools      WHERE county = 'Santa Clara' AND fundingtype = 'Locally funded' ) / (     SELECT COUNT(*)      FROM schools      WHERE county = 'Santa Clara' ) AS "Locally Funded Schools Ratio"
SELECT COUNT(DISTINCT schools.school) FROM   schools INNER JOIN   frpm ON frpm.cdscode = schools.cdscode INNER JOIN   satscores ON satscores.cds = schools.cdscode WHERE   schools.opendate BETWEEN '2000-01-01' AND '2005-12-31'   AND schools.county = 'Stanislaus'   AND schools.fundingtype = 'Directly funded';
SELECT SUM(CASE     WHEN schools.doc = '98' AND schools.closeddate LIKE '1989%' AND schools.city = 'San Francisco' THEN 1     ELSE 0     END) AS total_community_college_district_closure_1989_sf FROM schools; 
SELECT COUNT(schools.cdscode) AS num_closures, schools.county FROM schools WHERE schools.closeddate BETWEEN '1980-01-01' AND '1989-12-31' AND schools.soctype = '11' GROUP BY schools.county ORDER BY num_closures DESC LIMIT 1;
SELECT schools.ncessdist FROM schools WHERE schools.soctype = 'State Special Schools' AND schools.soc = 31;
SELECT COUNT(*) FROM schools WHERE county = 'Alpine' AND district = 'District Community Day Schools' AND statustype IN ('Active', 'Closed')
SELECT frpm.district code FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.city = 'Fresno' AND schools.magnet = 0;
SELECT COUNT(schools.enrollment) AS enrolled_students_ages_5_to_17 FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.school = 'State Special School' AND schools.city = 'Fremont' AND frpm."academic year" = '2014-2015' AND schools.edopscode = 'SSS';
SELECT frpm.frpm_count_ages_5_17 FROM frpm INNER JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.edopsname = 'Youth Authority School' AND schools.mailstrabr = 'PO Box 1040';
SELECT MIN(schools.gsserved) AS lowest_grade FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.ncesdist = '613360' AND schools.edopscode = 'SPECON';
SELECT edopsname AS Educational_Level_Name, schools.school AS School_Name FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE frpm.nslp_provision_status = 'Breakfast Provision 2' AND frpm.county_code = '37'; 
SELECT schools.city FROM frpm INNER JOIN schools ON frpm.cdscode = schools.cdscode INNER JOIN satscores ON satscores.cds = schools.cdscode WHERE frpm.lowgrade = 9 AND frpm.highgrade = 12 AND frpm.nslpprovisionstatus = 'Lunch Provision 2' AND schools.county = 'Merced' AND schools.eilcode = 'HS';
SELECT schools.school, schools.`Percent (%) eligible frpm (ages 5-17)` FROM schools WHERE schools.gsserved = 'K-9' AND schools.county = 'Los Angeles'
SELECT schools.gsserved AS grade_span, COUNT(schools.gsserved) AS count FROM schools WHERE schools.city = 'Adelanto' GROUP BY schools.gsserved ORDER BY count DESC LIMIT 1; 
SELECT COUNT(*) FROM schools WHERE (county = 'San Diego' OR county = 'Santa Barbara') AND virtual = 'F';
SELECT schools.school_type AS School_Type, schools.school AS School_Name, schools.latitude AS Latitude FROM schools ORDER BY schools.latitude DESC LIMIT 1; 
SELECT schools.city, MIN(schools.latitude) AS min_latitude, schools.school, MIN(CAST(SUBSTR(gsserved, 1, INSTR(gsserved, '-') - 1) AS INTEGER)) AS lowest_grade FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.state = 'CA' GROUP BY schools.city, schools.school ORDER BY min_latitude LIMIT 1; 
SELECT gsoffered FROM schools ORDER BY longitude DESC LIMIT 1; 
SELECT COUNT(DISTINCT frpm.cdscode) AS num_schools_multiple_provision, COUNT(DISTINCT schools.city) AS num_cities, COUNT(DISTINCT schools.school) AS num_schools_per_city FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.gsserved LIKE '%K-8%' AND schools.magnet = 1 AND frpm.nslp_provision_status = 'Multiple Provision Types';
SELECT      admfname1 AS first_name,     admlname1 AS last_name,     dname AS district FROM      schools WHERE      admfname1 IS NOT NULL UNION ALL SELECT     admfname2 AS first_name,     admlname2 AS last_name,     dname AS district FROM      schools WHERE      admfname2 IS NOT NULL UNION ALL SELECT     admfname3 AS first_name,     admlname3 AS last_name,     dname AS district FROM      schools WHERE      admfname3 IS NOT NULL; 
SELECT schools.districtcode FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.admfname1 = 'Alusine' 
SELECT schools.admlname1, schools.admlname2, schools.admlname3, schools.dname, schools.county, schools.school FROM schools WHERE schools.charternum = '40';
SELECT schools.admemail1 FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.county = 'San Bernardino' AND schools.district = 'San Bernardino City Unified' AND schools.opendate BETWEEN '2009-01-01' AND '2010-12-31' AND schools.soctype = 'Intermediate/Middle Schools (Public)' AND schools.doctype = 'Unified School District'
SELECT schools.school, schools.admemail1 FROM schools JOIN satscores ON satscores.cds = schools.cdscode WHERE satscores.numge1500 = (     SELECT MAX(numge1500) FROM satscores ) 
SELECT COUNT(account.account_id) FROM account JOIN district ON account.district_id = district.district_id JOIN trans ON account.account_id = trans.account_id WHERE district.a3 = 'east Bohemia' AND account.frequency = 'POPLATEK PO OBRATU';
SELECT COUNT(DISTINCT account.account_id) FROM account JOIN district ON account.district_id = district.district_id WHERE district.a3 = 'Prague';
SELECT AVG(a12) AS avg_unemployment_1995, AVG(a13) AS avg_unemployment_1996 FROM district;
SELECT COUNT(DISTINCT district_id) FROM district JOIN client ON district.district_id = client.district_id JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id WHERE client.gender = 'F' AND district.a11 > 6000 AND district.a11 < 10000;
SELECT COUNT(DISTINCT client.client_id) FROM     client JOIN     district ON client.district_id = district.district_id WHERE     client.gender = 'M'     AND district.a3 = 'north Bohemia'     AND district.a11 > 8000;
SELECT account.account_id FROM     account JOIN     disp ON account.account_id = disp.account_id JOIN     client ON disp.client_id = client.client_id JOIN     district ON account.district_id = district.district_id WHERE     client.gender = 'F'     AND client.birth_date = (         SELECT            MIN(birth_date)         FROM             client         WHERE             gender = 'F'     )     AND district.a11 = (         SELECT            MIN(a11)         FROM             district             JOIN account ON account.district_id = district.district_id             JOIN client ON client.district_id = district.district_id         WHERE             client.gender = 'F'     )     AND district.a11 = (         SELECT            MAX(a11)         FROM             district             JOIN account ON account.district_id = district.district_id             JOIN client ON client.district_id = district.district_id         WHERE             client.gender = 'F'     );
SELECT account.account_id FROM (     SELECT        client_id,         MIN(birth_date) AS min_birth_date,         MAX(a11) AS max_avg_salary     FROM         client     JOIN         district ON client.district_id = district.district_id     GROUP BY         client_id     ORDER BY         min_birth_date DESC,         max_avg_salary DESC ) AS youngest_highest_salary JOIN     disp ON youngest_highest_salary.client_id = disp.client_id JOIN     account ON disp.account_id = account.account_id;
SELECT COUNT(DISTINCT client.client_id) FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id WHERE account.frequency = 'POPLATEK TYDNE' AND disp.type = 'OWNER';
SELECT client.client_id, client.gender, client.birth_date FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id WHERE disp.type = 'DISPONENT' AND account.frequency = 'POPLATEK PO OBRATU' 
SELECT MIN(loan.amount), account_id FROM loan JOIN account ON loan.account_id = account.account_id WHERE loan.date LIKE '1997%' AND account.frequency = 'POPLATEK TYDNE' GROUP BY account_id;
SELECT MAX(loan.amount) AS max_approved_amount FROM     loan JOIN     account ON loan.account_id = account.account_id WHERE     loan.duration > 12     AND account.date BETWEEN '1993-01-01' AND '1993-12-31';
SELECT COUNT(DISTINCT client.client_id) AS female_customers FROM client JOIN account ON client.client_id = disp.client_id JOIN district ON client.district_id = district.district_id WHERE client.gender = 'F' AND client.birth_date < '1950-01-01' AND district.a2 = 'Slokolov';
SELECT account_id FROM trans WHERE date = (SELECT MIN(date) FROM trans WHERE date LIKE '1995%'); 
SELECT DISTINCT account_id FROM account JOIN trans ON account.account_id = trans.account_id WHERE date < '1997-01-01' AND amount > 3000 
SELECT client.client_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id WHERE card.issued = '1994-03-03';
SELECT MIN(account.date) AS account_opening_date FROM trans JOIN account ON trans.account_id = account.account_id WHERE trans.amount = 840 AND trans.date = '1998-10-14';
SELECT district_id FROM     account WHERE     account_id IN (         SELECT            account_id         FROM             loan         WHERE             date = '1994-08-25'     ); 
SELECT MAX(trans.amount) FROM     trans JOIN     disp ON trans.account_id = disp.account_id JOIN     card ON disp.disp_id = card.disp_id WHERE     card.issued = '1996-10-21';
SELECT client.gender FROM client JOIN account ON client.client_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE account.date = (SELECT MIN(date) FROM account WHERE district_id = (SELECT district_id FROM district ORDER BY a11 DESC LIMIT 1))
SELECT MAX(amount) AS max_loan_amount FROM loan;
SELECT COUNT(client.client_id) FROM client JOIN account ON client.client_id = disp.client_id JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Jesenik' AND client.gender = 'F';
SELECT disp.disp_id FROM trans JOIN disp ON trans.account_id = disp.account_id WHERE trans.date = '1998-09-02' AND trans.amount = 5100 
SELECT COUNT(account.account_id) AS num_accounts_opened FROM     account JOIN     district ON account.district_id = district.district_id WHERE     district.a2 = 'Litomerice'     AND strftime('%Y', account.date) = '1996';
SELECT district.a2 FROM client JOIN account ON client.client_id = disp.client_id JOIN district ON account.district_id = district.district_id WHERE client.gender = 'F' AND client.birth_date = '1976-01-29';
SELECT client.birth_date FROM client JOIN loan ON client.client_id = (     SELECT disp.client_id     FROM disp     JOIN account ON disp.account_id = loan.account_id     WHERE loan.amount = 98832 AND loan.date = '1996-01-03' ) 
SELECT account.account_id FROM account JOIN client ON account.account_id = client.client_id JOIN district ON client.district_id = district.district_id WHERE district.a3 = 'Prague' LIMIT 1;
SELECT 100.0 * COUNT(client.gender) / COUNT(client.client_id) AS percentage_of_male_clients FROM client JOIN district ON client.district_id = district.district_id WHERE district.a3 = 'south Bohemia' AND district.a4 = (SELECT MAX(a4) FROM district WHERE a3 = 'south Bohemia') AND client.gender = 'M';
SELECT ( (MAX(trans.balance) - MIN(trans.balance)) / MIN(trans.balance) ) * 100 AS increase_rate FROM     trans JOIN     account ON trans.account_id = account.account_id JOIN     loan ON account.account_id = loan.account_id WHERE     loan.date = '1993-07-05' AND trans.date >= '1993-03-22' AND trans.date <= '1998-12-27';
SELECT ((SELECT SUM(amount) FROM loan WHERE status = 'A') / (SELECT SUM(amount) FROM loan)) * 100 AS percentage_paid_without_issue;
SELECT (CAST(COUNT(DISTINCT account.account_id) AS FLOAT) / (SELECT COUNT(*) FROM account JOIN loan ON account.account_id = loan.account_id WHERE loan.amount < 100000)) * 100 FROM account LEFT JOIN loan ON account.account_id = loan.account_id WHERE loan.status = 'C';
SELECT account.account_id, district.a2 AS district_name, district.a3 AS district_region FROM account JOIN district ON account.district_id = district.district_id JOIN card ON account.account_id = card.disp_id JOIN disp ON card.disp_id = disp.disp_id JOIN client ON disp.client_id = client.client_id JOIN loan ON account.account_id = loan.account_id JOIN order ON account.account_id = order.account_id JOIN trans ON account.account_id = trans.account_id WHERE account.account_id = 1993 AND card.issued > trans.date AND card.type = 'POPLATEK PO OBRATU';
SELECT account.account_id, account.frequency FROM account JOIN district ON account.district_id = district.district_id WHERE district.a3 = 'east Bohemia' AND account.date BETWEEN '1995-01-01' AND '2000-12-31';
SELECT account.account_id, account.date FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Prachatice';
SELECT district.a2 AS district, district.a3 AS region FROM loan JOIN account ON loan.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE loan.loan_id = '4990';
SELECT account.account_id, district.a2 AS district, district.a3 AS region FROM account JOIN loan ON account.account_id = loan.account_id JOIN district ON account.district_id = district.district_id WHERE loan.amount > 300000;
SELECT loan.loan_id, district.a3 AS district, district.a11 AS average_salary FROM loan JOIN account ON loan.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE loan.duration = 60; 
SELECT district.a3 AS district_state, ((district.a13 - district.a12) / district.a12) * 100 AS unemployment_rate_increment FROM loan JOIN account ON loan.account_id = account.account_id JOIN client ON account.account_id = client.client_id JOIN disp ON client.client_id = disp.client_id JOIN district ON client.district_id = district.district_id WHERE loan.status = 'D' 
SELECT 100.0 * COUNT(*) / (SELECT COUNT(*) FROM account WHERE strftime('%Y', date) = '1993') FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Decin' AND strftime('%Y', account.date) = '1993';
SELECT account_id FROM account WHERE frequency = 'POPLATEK MESICNE';
SELECT district.a2 AS district_name, COUNT(DISTINCT client.client_id) AS female_account_holders FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id JOIN district ON client.district_id = district.district_id WHERE client.gender = 'F' GROUP BY district_name ORDER BY female_account_holders DESC LIMIT 10; 
SELECT district.a2 AS district_name, SUM(trans.amount) AS total_withdrawals FROM trans JOIN account ON trans.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE trans.type = 'VYDAJ' AND trans.date LIKE '1996-01%' GROUP BY district.a2 ORDER BY total_withdrawals DESC LIMIT 10; 
SELECT COUNT(DISTINCT client_id) FROM client JOIN district ON client.district_id = district.district_id LEFT JOIN disp ON client.client_id = disp.client_id LEFT JOIN card ON disp.disp_id = card.disp_id WHERE district.a3 = 'south Bohemia' AND card.card_id IS NULL;
SELECT district.a3 AS district_name, COUNT(loan.loan_id) AS active_loans FROM district JOIN account ON account.district_id = district.district_id JOIN loan ON loan.account_id = account.account_id WHERE loan.status = 'C' GROUP BY district_name ORDER BY active_loans DESC LIMIT 1;
SELECT AVG(loan.amount) FROM loan JOIN (     SELECT client_id     FROM client     WHERE gender = 'M' ) AS male_clients ON loan.account_id IN (     SELECT account_id     FROM disp     WHERE client_id = male_clients.client_id )
SELECT DISTINCT district.a2 AS branch_location, district.a3 AS district_name FROM district WHERE district.a13 IN (SELECT MAX(a13) FROM district WHERE a13 IS NOT NULL AND a13 != '') AND district.a13 IS NOT NULL AND district.a13 != '';
SELECT COUNT(account.account_id) AS num_of_accounts_opened FROM     account JOIN     district ON account.district_id = district.district_id WHERE     district.a16 = (SELECT MAX(a16) FROM district)
SELECT COUNT(DISTINCT account.account_id) FROM trans JOIN account ON trans.account_id = account.account_id JOIN card ON trans.account_id = card.disp_id WHERE trans.balance < 0 AND trans.operation = 'VYBER KARTOU' AND account.frequency = 'POPLATEK MESICNE';
SELECT COUNT(DISTINCT loan.account_id) FROM loan JOIN account ON loan.account_id = account.account_id WHERE loan.date BETWEEN '1995-01-01' AND '1997-12-31' AND loan.amount >= 250000 AND account.frequency = 'POPLATEK MESICNE';
SELECT COUNT(DISTINCT account.account_id) FROM     account JOIN     loan ON account.account_id = loan.account_id WHERE     loan.status = 'C'     AND account.district_id = 1;
SELECT COUNT(DISTINCT client.client_id) FROM     client JOIN     disp ON client.client_id = disp.client_id JOIN     account ON disp.account_id = account.account_id JOIN     district ON account.district_id = district.district_id WHERE     district.district_id = (         SELECT            district_id         FROM             district         ORDER BY             a15 DESC         LIMIT 1 OFFSET 1     )     AND client.gender = 'M';
SELECT COUNT(*) FROM card JOIN disp ON card.card_id = disp.disp_id WHERE card.type = 'gold' AND disp.type = 'DISPONENT';
SELECT COUNT(account.account_id) FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Pisek';
SELECT DISTINCT district.a2 FROM     district JOIN     account ON district.district_id = account.district_id JOIN     trans ON account.account_id = trans.account_id WHERE     trans.date LIKE '1997%' AND trans.amount > 10000;
SELECT account.account_id FROM account JOIN order ON account.account_id = order.account_id JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Pisek' AND order.k_symbol = 'SIPO'; 
SELECT DISTINCT a.account_id FROM account AS a JOIN disp ON a.account_id = disp.account_id JOIN card AS c ON disp.disp_id = c.disp_id WHERE c.type IN ('gold', 'junior') GROUP BY a.account_id HAVING COUNT(DISTINCT c.type) = 2; 
SELECT AVG(amount) FROM trans JOIN card ON trans.account_id = card.disp_id WHERE strftime('%Y', date) = '2021' AND operation = 'VYBER KARTOU';
SELECT DISTINCT disp.client_id FROM   disp JOIN   card ON disp.disp_id = card.disp_id JOIN   trans ON card.card_id = trans.account WHERE   trans.operation = 'VYBER KARTOU'   AND strftime('%Y', trans.date) = '1998' GROUP BY   disp.client_id HAVING   SUM(trans.amount) / (SELECT COUNT(DISTINCT strftime('%m', date)) FROM trans WHERE strftime('%Y', date) = '1998') <   (SELECT AVG(amount) FROM trans WHERE strftime('%Y', date) = '1998');
SELECT client.client_id FROM client INNER JOIN disp ON client.client_id = disp.client_id INNER JOIN card ON disp.disp_id = card.disp_id INNER JOIN loan ON disp.account_id = loan.account_id WHERE client.gender = 'F' 
SELECT COUNT(DISTINCT client.client_id) FROM     client     JOIN account ON client.client_id = disp.client_id     JOIN district ON client.district_id = district.district_id WHERE     client.gender = 'F'     AND district.a3 = 'south Bohemia';
SELECT account.account_id FROM account JOIN district ON account.district_id = district.district_id JOIN disp ON disp.account_id = account.account_id JOIN client ON disp.client_id = client.client_id WHERE district.a2 = 'Tabor' AND disp.type = 'OWNER' 
SELECT DISTINCT frequency FROM account JOIN district ON account.district_id = district.district_id WHERE frequency NOT IN (     SELECT frequency     FROM account     JOIN disp ON disp.account_id = account.account_id     WHERE disp.type = 'OWNER' ) AND district.a11 > 8000 AND district.a11 <= 9000;
SELECT COUNT(DISTINCT account.account_id) FROM     account JOIN     trans ON account.account_id = trans.account_id JOIN     district ON account.district_id = district.district_id WHERE     district.a3 = 'north Bohemia'     AND trans.bank = 'AB';
SELECT district.a2 FROM district JOIN account ON account.district_id = district.district_id JOIN trans ON trans.account_id = account.account_id WHERE trans.type = 'VYDAJ' GROUP BY district.a2;
SELECT AVG(district.a15) AS average_crimes_1995 FROM district INNER JOIN account ON account.district_id = district.district_id WHERE district.a15 > 4000 AND account.date >= '1997-01-01'
SELECT COUNT(DISTINCT card.card_id) FROM card JOIN disp ON card.disp_id = disp.disp_id JOIN account ON disp.account_id = account.account_id WHERE card.type = 'classic' AND disp.type = 'OWNER';
SELECT COUNT(client.client_id) FROM client JOIN district ON client.district_id = district.district_id WHERE district.a2 = 'Hl.m. Praha' AND client.gender = 'M';
SELECT (CAST(COUNT(CASE WHEN card.type = 'gold' AND card.issued < '1998-01-01' THEN 1 END) AS FLOAT) / COUNT(*)) * 100 AS percentage_of_gold_cards_issued_prior_to_1998 FROM card;
SELECT client.client_id FROM loan JOIN account ON loan.account_id = account.account_id JOIN disp ON disp.account_id = account.account_id JOIN client ON disp.client_id = client.client_id WHERE loan.amount = (SELECT MAX(amount) FROM loan) LIMIT 1; 
SELECT COUNT(district.a15) AS num_committed_crimes_1995 FROM district JOIN account ON account.district_id = district.district_id WHERE account.account_id = 532;
SELECT district.district_id FROM     account JOIN     order ON account.account_id = order.account_id WHERE     order.order_id = 33333;
SELECT trans.amount, trans.date FROM trans JOIN disp ON trans.account_id = disp.account_id WHERE disp.client_id = 3356 AND trans.operation = 'VYBER';
SELECT COUNT(DISTINCT account.account_id) FROM account JOIN loan ON account.account_id = loan.account_id WHERE account.frequency = 'POPLATEK TYDNE' AND loan.amount < 200000;
SELECT card.type FROM card JOIN disp ON card.disp_id = disp.disp_id JOIN client ON disp.client_id = client.client_id WHERE client.client_id = 13539; 
SELECT district.a3 AS region FROM client JOIN district ON client.district_id = district.district_id WHERE client.client_id = 3541;
SELECT district.a2 AS district_name, COUNT(DISTINCT loan.account_id) AS loan_accounts FROM loan JOIN account ON loan.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE loan.status = 'A' GROUP BY district_name ORDER BY loan_accounts DESC LIMIT 1;
SELECT client.client_id, client.gender, client.birth_date FROM     `order` JOIN     account ON `order`.account_id = account.account_id JOIN     disp ON account.account_id = disp.account_id JOIN     client ON disp.client_id = client.client_id WHERE     `order`.order_id = 32423; 
SELECT trans.* FROM trans JOIN account ON trans.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE district.district_id = 5;
SELECT COUNT(account.account_id) FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Jesenik';
SELECT client.client_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id WHERE card.type = 'junior' AND card.issued > '1997-01-01';
SELECT ROUND(     (SELECT COUNT(DISTINCT client_id)     FROM client     JOIN account ON client.client_id = disp.client_id     JOIN district ON client.district_id = district.district_id     WHERE gender = 'F' AND a11 > 10000)     /     (SELECT COUNT(DISTINCT client_id)     FROM client     JOIN account ON client.client_id = disp.client_id     JOIN district ON client.district_id = district.district_id     WHERE a11 > 10000)     * 100, 2) AS percentage_female_clients;
SELECT ((SUM(loan.amount) FILTER (WHERE strftime('%Y', loan.date) = '1997') - SUM(loan.amount) FILTER (WHERE strftime('%Y', loan.date) = '1996')) / SUM(loan.amount) FILTER (WHERE strftime('%Y', loan.date) = '1996')) * 100 AS growth_rate FROM     loan     JOIN account ON loan.account_id = account.account_id     JOIN client ON account.account_id = client.client_id
SELECT COUNT(*) FROM trans JOIN card ON trans.account_id = card.disp_id WHERE trans.date > '1995-01-01' AND trans.operation = 'VYBER KARTOU';
SELECT SUM(CASE WHEN district.a3 = 'North Bohemia' THEN district.a16 ELSE 0 END) - SUM(CASE WHEN district.a3 = 'East Bohemia' THEN district.a16 ELSE 0 END) AS difference_in_crimes_1996 FROM district;
SELECT COUNT(*) AS disposition_count FROM disp WHERE account_id BETWEEN 1 AND 10
SELECT COUNT(*) AS account_statement_request_frequency, SUM(amount) AS total_debit_amount FROM trans WHERE account_id = 3 AND operation = 'VYBER' AND k_symbol = 'VYDAJ';
SELECT client.birth_date FROM client JOIN disp ON client.client_id = disp.client_id WHERE disp.type = 'OWNER' AND disp.account_id = 130 
SELECT COUNT(account.account_id) FROM account JOIN disp ON account.account_id = disp.account_id WHERE disp.type = 'OWNER' AND account.frequency = 'POPLATEK PO OBRATU';
SELECT SUM(amount) AS total_debt, CASE     WHEN SUM(amount) = 0 THEN 'No debt'     WHEN SUM(amount) < 0 THEN 'Overpaid'     ELSE 'Unpaid' END AS payment_status FROM loan WHERE account_id IN (     SELECT account_id FROM disp WHERE client_id = 992 ) 
SELECT SUM(amount) AS account_balance, client.gender FROM trans JOIN account ON trans.account_id = account.account_id JOIN disp ON disp.account_id = account.account_id JOIN client ON disp.client_id = client.client_id WHERE trans.trans_id <= 851 AND client.client_id = 4 
SELECT card.type FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id WHERE client.client_id = 9;
SELECT SUM(trans.amount) AS total_amount FROM trans JOIN account ON trans.account_id = account.account_id JOIN disp ON account.account_id = disp.account_id JOIN client ON disp.client_id = client.client_id WHERE client.client_id = 617 AND trans.date BETWEEN '1998-01-01' AND '1998-12-31';
SELECT client.client_id FROM client JOIN account ON client.client_id = disp.client_id JOIN district ON account.district_id = district.district_id WHERE client.birth_date BETWEEN '1983-01-01' AND '1987-12-31' AND district.a3 = 'east Bohemia'; 
SELECT client.client_id FROM client JOIN (     SELECT        account_id,         MAX(amount) AS max_loan     FROM         loan     GROUP BY         account_id     ORDER BY         max_loan DESC     LIMIT 3 ) AS max_loans ON client.account_id = max_loans.account_id WHERE client.gender = 'F';
SELECT COUNT(DISTINCT client.client_id) FROM client JOIN disp ON client.client_id = disp.client_id JOIN trans ON disp.account_id = trans.account_id WHERE client.gender = 'M' AND client.birth_date BETWEEN '1974-01-01' AND '1976-12-31' AND trans.amount > 4000 AND trans.k_symbol = 'SIPO';
SELECT COUNT(account.account_id) FROM     account JOIN     district ON account.district_id = district.district_id WHERE     district.a2 = 'Beroun'     AND account.date > '1996-01-01';
SELECT COUNT(DISTINCT client.client_id) AS female_customers_with_junior_card FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id WHERE client.gender = 'F' AND card.type = 'junior';
SELECT 100.0 * (     SELECT COUNT(*)      FROM client      WHERE gender = 'F' AND district_id IN (         SELECT district_id          FROM district          WHERE a3 = 'Prague'     ) ) / (     SELECT COUNT(*)      FROM client      WHERE district_id IN (         SELECT district_id          FROM district          WHERE a3 = 'Prague'     ) );
SELECT 100.0 * (     SELECT COUNT(client_id)     FROM client     JOIN disp ON client.client_id = disp.client_id     JOIN account ON disp.account_id = account.account_id     WHERE client.gender = 'M'     AND account.frequency = 'POPLATEK TYDNE' ) / (     SELECT COUNT(client_id)     FROM client     JOIN disp ON client.client_id = disp.client_id     JOIN account ON disp.account_id = account.account_id     WHERE account.frequency = 'POPLATEK TYDNE' );
SELECT COUNT(DISTINCT client.client_id) AS weekly_issuance_user_count FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id WHERE account.frequency = 'POPLATEK TYDNE' AND client.gender = 'U';
SELECT account_id FROM loan INNER JOIN account ON loan.account_id = account.account_id WHERE duration > 24 AND date < '1997-01-01' GROUP BY account_id HAVING amount = MIN(amount) 
SELECT account.account_id FROM     account JOIN     client ON account.account_id = client.account_id JOIN     (         SELECT            client_id,             MAX(birth_date) AS max_birth_date         FROM             client         WHERE             gender = 'F'         GROUP BY             client_id     ) AS oldest_female ON client.client_id = oldest_female.client_id AND client.birth_date = oldest_female.max_birth_date JOIN     district ON client.district_id = district.district_id JOIN     (         SELECT            district_id,             MIN(a11) AS min_avg_salary         FROM             district         GROUP BY             district_id     ) AS lowest_salary_district ON district.district_id = lowest_salary_district.district_id AND district.a11 = lowest_salary_district.min_avg_salary;
SELECT COUNT(DISTINCT client.client_id) AS clients_born_in_1920_in_east_bohemia FROM client JOIN district ON client.district_id = district.district_id WHERE client.birth_date BETWEEN '1920-01-01' AND '1920-12-31' AND district.a3 = 'east Bohemia';
SELECT COUNT(DISTINCT loan.account_id) AS pre_payment_loan_accounts FROM loan JOIN account ON loan.account_id = account.account_id WHERE loan.duration = 24 AND account.frequency = 'POPLATEK TYDNE';
SELECT AVG(loan.amount) FROM loan INNER JOIN account ON loan.account_id = account.account_id INNER JOIN trans ON account.account_id = trans.account_id WHERE loan.status = 'C' AND account.frequency = 'POPLATEK PO OBRATU'
SELECT DISTINCT client.client_id, district.a2 AS district_name FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id JOIN district ON client.district_id = district.district_id WHERE disp.type = 'OWNER' AND (NOT EXISTS (         SELECT 1         FROM disp AS d         JOIN account AS a ON d.account_id = a.account_id         JOIN loan AS l ON a.account_id = l.account_id         WHERE d.client_id = client.client_id     )     OR NOT EXISTS (         SELECT 1         FROM disp AS d         JOIN account AS a ON d.account_id = a.account_id         JOIN "order" AS o ON a.account_id = o.account_id         WHERE d.client_id = client.client_id         AND o.k_symbol = 'POJISTNE'     ) ) 
SELECT client.client_id,  strftime('%Y', 'now') - strftime('%Y', client.birth_date) - (strftime('%m-%d', 'now') < strftime('%m-%d', client.birth_date)) AS age FROM client INNER JOIN disp ON client.client_id = disp.client_id INNER JOIN card ON disp.disp_id = card.disp_id INNER JOIN account ON disp.account_id = account.account_id INNER JOIN loan ON account.account_id = loan.account_id WHERE card.type = 'gold'
SELECT bond_type FROM bond GROUP BY bond_type ORDER BY COUNT(*) DESC LIMIT 1; 
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id WHERE molecule.label = '-' AND atom.element = 'cl';
SELECT AVG(CASE WHEN bond_type = '-' AND element = 'o' THEN 1 ELSE 0 END) AS avg_oxygen_atoms FROM connected 
SELECT AVG(CASE WHEN molecule.label = '+' AND bond.bond_type = '-' THEN 1 ELSE 0 END) FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id;
SELECT COUNT(DISTINCT atom.atom_id) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'na' AND molecule.label = '-'
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '#' AND molecule.label = '+'; 
SELECT (SELECT (COUNT(DISTINCT atom_id) * 100.0 / (SELECT COUNT(DISTINCT atom_id) FROM atom WHERE atom_id IN (SELECT atom_id FROM connected WHERE bond_id IN (SELECT bond_id FROM bond WHERE bond_type = '='))))) AS percentage_of_carbon_in_double_bond_molecules FROM atom WHERE element = 'c' AND atom_id IN (SELECT atom_id FROM connected WHERE bond_id IN (SELECT bond_id FROM bond WHERE bond_type = '='))) 
SELECT COUNT(*) FROM     bond WHERE     bond_type = '#'
SELECT COUNT(DISTINCT atom.atom_id) FROM atom LEFT JOIN connected ON atom.atom_id = connected.atom_id WHERE atom.element != 'br' OR atom.element IS NULL;
SELECT COUNT(DISTINCT molecule_id) FROM molecule WHERE molecule_id BETWEEN 'TR000' AND 'TR099' AND label = '+';
SELECT DISTINCT molecule.molecule_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'si'; 
SELECT element FROM     connected JOIN atom ON connected.atom_id = atom.atom_id WHERE     connected.bond_id = 'TR004_8_9' 
SELECT DISTINCT atom.element FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '=' 
SELECT MAX(COUNT(molecule.label)) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'h';
SELECT bond.bond_type FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id2 = atom.atom_id WHERE atom.element = 'te';
SELECT DISTINCT connected.atom_id, connected.atom_id2 FROM connected JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '-'; 
SELECT atom.atom_id, connected.atom_id2 FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE molecule.label = '-'
SELECT element, COUNT(element) AS element_count FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '-' GROUP BY element ORDER BY element_count ASC LIMIT 1; 
SELECT bond.bond_type FROM connected JOIN atom ON connected.atom_id = atom.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.atom_id = 'TR004_8' AND connected.atom_id2 = 'TR004_20';
SELECT DISTINCT molecule.label FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE atom.element != 'sn' 
SELECT COUNT(DISTINCT atom.atom_id) FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE (atom.element = 'i' OR atom.element = 's') AND bond.bond_type = '-';
SELECT atom.atom_id FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '#' 
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE molecule.molecule_id = 'TR181' 
SELECT ROUND((COUNT(DISTINCT molecule.molecule_id) - COUNT(DISTINCT CASE WHEN atom.element = 'f' THEN molecule.molecule_id END)) * 100.0 / COUNT(DISTINCT molecule.molecule_id), 2) AS percent FROM molecule LEFT JOIN atom ON molecule.molecule_id = atom.molecule_id WHERE molecule.label = '+'; 
SELECT ROUND((COUNT(DISTINCT molecule.molecule_id) * 100.0) / (SELECT COUNT(*) FROM bond WHERE bond_type = '#'), 2) AS percent FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '#' AND molecule.label = '+'; 
SELECT element FROM atom WHERE molecule_id = 'TR000' GROUP BY element ORDER BY element LIMIT 3; 
SELECT atom.atom_id FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.molecule_id = 'TR001' AND bond.bond_id = 'TR001_2_6' 
SELECT ABS(SUM(CASE WHEN molecule.label = '+' THEN 1 ELSE 0 END) - SUM(CASE WHEN molecule.label = '-' THEN 1 ELSE 0 END)) AS difference FROM molecule; 
SELECT atom.atom_id FROM connected JOIN atom ON connected.atom_id = atom.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR_000_2_5'; 
SELECT bond_id  FROM connected  WHERE atom_id2 = 'TR000_2'; 
SELECT molecule.molecule_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '=' GROUP BY molecule.molecule_id ORDER BY molecule.molecule_id LIMIT 5; 
SELECT (SELECT     (COUNT(*) * 100.0) / (SELECT COUNT(*) FROM bond WHERE molecule_id = 'TR008')   FROM      bond   WHERE      molecule_id = 'TR008' AND bond_type = ' = ') 
SELECT DIVIDE(     (SELECT COUNT(*) FROM molecule WHERE label = '+'),     (SELECT COUNT(*) FROM molecule) ) AS percent; 
SELECT ROUND(     (CAST((SELECT COUNT(*) FROM atom WHERE molecule_id = 'TR206' AND element = 'h') AS FLOAT) /      CAST((SELECT COUNT(*) FROM atom WHERE molecule_id = 'TR206') AS FLOAT)) * 100 , 2) AS percent 
SELECT bond.bond_type FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR000';
SELECT atom.element, molecule.label FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR060'; 
SELECT MAX(bond_type) AS majority_bond_type,     CASE         WHEN m.label = '+' THEN 'Carcinogenic'         WHEN m.label = '-' THEN 'Non-carcinogenic'         ELSE 'Unknown'     END AS carcinogenicity FROM     molecule m JOIN     bond b ON m.molecule_id = b.molecule_id WHERE     m.molecule_id = 'TR018' GROUP BY     m.label;
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id WHERE bond.bond_type = '-' AND molecule.label = '-' GROUP BY molecule.molecule_id HAVING COUNT(DISTINCT bond.bond_id) = 1 ORDER BY molecule.molecule_id LIMIT 3; 
SELECT bond.bond_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR006' ORDER BY bond.bond_id LIMIT 2; 
SELECT COUNT(*) FROM     connected WHERE     (atom_id = 'TR009_12' OR atom_id2 = 'TR009_12')     AND bond_id LIKE 'TR009_%';
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id WHERE molecule.label = '+' AND atom.element = 'br';
SELECT bond.bond_type, connected.atom_id, connected.atom_id2 FROM bond JOIN connected ON bond.bond_id = connected.bond_id WHERE bond.bond_id = 'TR001_6_9';
SELECT molecule.molecule_id, molecule.label FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.atom_id = 'TR001_10';
SELECT COUNT(DISTINCT molecule.molecule_id) AS triple_bond_molecules FROM     molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE     bond.bond_type = '#'
SELECT COUNT(*) AS num_connections FROM connected WHERE atom_id = 'TR%_19' OR atom_id2 = 'TR%_19';
SELECT atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR004' 
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule WHERE molecule.label = '-'
SELECT DISTINCT molecule.molecule_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE SUBSTRING(atom.atom_id, 7, 2) BETWEEN '21' AND '25' AND molecule.label = '+'; 
SELECT bond.bond_id FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id JOIN atom AS atom2 ON connected.atom_id2 = atom2.atom_id WHERE atom.element = 'p' AND atom2.element = 'n';
SELECT COUNT(molecule.molecule_id) AS double_bond_count, molecule.label AS carcinogenic FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = ' = ' GROUP BY molecule.label ORDER BY double_bond_count DESC LIMIT 1;
SELECT AVG(bonds_per_atom) AS average_bonds_per_iodine_atom FROM (     SELECT COUNT(bond_id) AS bonds_per_atom     FROM connected     INNER JOIN atom ON connected.atom_id = atom.atom_id     WHERE atom.element = 'i'     GROUP BY connected.atom_id ) 
SELECT bond.bond_type, bond.bond_id FROM connected JOIN atom ON connected.atom_id = atom.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.atom_id LIKE '%_45' 
SELECT element FROM atom WHERE atom_id NOT IN (SELECT atom_id FROM connected) 
SELECT atom.atom_id FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '#' AND bond.molecule_id = 'TR447'; 
SELECT atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id2 JOIN bond ON bond.bond_id = connected.bond_id WHERE bond.bond_id = 'TR144_8_19'; 
SELECT molecule_id, COUNT(*) AS double_bonds FROM     molecule JOIN     bond ON molecule.molecule_id = bond.molecule_id WHERE     label = '+' AND     bond_type = '=' GROUP BY     molecule_id ORDER BY     double_bonds DESC LIMIT 1; 
SELECT element, COUNT(*) AS element_count FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+' GROUP BY element ORDER BY element_count ASC LIMIT 1; 
SELECT atom.atom_id FROM atom JOIN connected ON atom.atom_id = connected.atom_id2 JOIN atom AS lead_atom ON connected.atom_id = lead_atom.atom_id WHERE lead_atom.element = 'pb'; 
SELECT element FROM     atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE     bond.bond_type = '#' GROUP BY     atom.element HAVING     COUNT(*) = 3; 
SELECT (SELECT     COUNT(bond_id) * 100.0 / (         SELECT COUNT(atom_id)         FROM connected         GROUP BY atom_id         ORDER BY COUNT(atom_id) DESC         LIMIT 1     )  FROM connected GROUP BY atom_id, atom_id2 ORDER BY COUNT(*) DESC LIMIT 1); 
SELECT SUM(CASE WHEN bond.bond_type = '-' THEN (CASE WHEN molecule.label = '+' THEN 1 ELSE 0 END) ELSE 0 END) / COUNT(CASE WHEN bond.bond_type = '-' THEN bond.bond_id END) AS proportion_of_carcinogenic_single_bonds
SELECT COUNT(DISTINCT atom.atom_id) FROM atom WHERE atom.element IN ('c', 'h');
SELECT atom_id2 FROM connected JOIN atom ON connected.atom_id = atom.atom_id WHERE atom.element = 's' 
SELECT bond.bond_type FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element = 'sn';
SELECT COUNT(DISTINCT atom.element) FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '-';
SELECT COUNT(DISTINCT atom.atom_id) FROM     atom     JOIN molecule ON atom.molecule_id = molecule.molecule_id     JOIN connected ON connected.atom_id = atom.atom_id     JOIN bond ON connected.bond_id = bond.bond_id WHERE     (atom.element = 'p' OR atom.element = 'br')     AND bond.bond_type = '#'     AND molecule.label = '+' GROUP BY     molecule.molecule_id
SELECT connected.bond_id FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id WHERE molecule.label = '+'; 
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '-' AND molecule.label = '-'; 
SELECT SUM(CASE WHEN element = 'cl' THEN 1 ELSE 0 END) * 100.0 / COUNT(atom.atom_id) AS percent FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '-'
SELECT molecule.molecule_id, molecule.label FROM molecule WHERE molecule.molecule_id IN ('TR000', 'TR001', 'TR002'); 
SELECT molecule_id FROM molecule WHERE label = '-'; 
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule WHERE molecule.molecule_id BETWEEN 'TR000' AND 'TR030' AND molecule.label = '+';
SELECT bond.bond_type FROM     bond JOIN     molecule ON bond.molecule_id = molecule.molecule_id WHERE     molecule.molecule_id BETWEEN 'TR000' AND 'TR050';
SELECT atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id2 JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR001_10_11'; 
SELECT COUNT(DISTINCT bond.bond_id) AS iodine_bond_count FROM     bond JOIN     connected ON bond.bond_id = connected.bond_id JOIN     atom ON connected.atom_id2 = atom.atom_id WHERE     atom.element = 'i';
SELECT molecule.label, COUNT(*) AS molecule_count FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'ca' GROUP BY molecule.label; 
SELECT COUNT(*) AS count FROM connected JOIN atom ON connected.atom_id = atom.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR001_1_8' AND atom.element IN ('cl', 'c') 
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id JOIN atom AS a2 ON connected.atom_id2 = a2.atom_id WHERE bond.bond_type = '#' AND atom.element = 'c' AND a2.element = 'c' AND molecule.label = '-'; 
SELECT (CAST(COUNT(DISTINCT CASE WHEN element = 'cl' THEN molecule_id END) AS FLOAT) /      NULLIF(COUNT(DISTINCT CASE WHEN label = '+' THEN molecule_id END), 0)) * 100 AS percentage FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE label = '+'; 
SELECT element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR001';
SELECT DISTINCT molecule.molecule_id FROM   bond JOIN   molecule ON bond.molecule_id = molecule.molecule_id WHERE   bond.bond_type = '=' 
SELECT connected.atom_id AS first_atom_id, connected.atom_id2 AS second_atom_id FROM connected JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '#'; 
SELECT atom.element FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id2 = atom.atom_id WHERE bond.bond_id = 'TR005_16_26' 
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '#' AND molecule.label = '-'; 
SELECT molecule.label FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id2 = atom.atom_id JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE bond.bond_id = 'TR001_10_11'; 
SELECT bond.bond_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '#' AND molecule.label = '+'; 
SELECT COUNT(CASE WHEN molecule.label = '+' THEN atom.element END) AS carcinogenic_toxicology_tally FROM (SELECT atom.element, molecule.label FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id WHERE substr(atom.atom_id, 7, 1) = '4') AS subquery; 
SELECT molecule.label, CAST(SUM(CASE WHEN atom.element = 'h' THEN 1 ELSE 0 END) AS FLOAT) / COUNT(atom.element) AS hydrogen_ratio FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id WHERE molecule.molecule_id = 'TR006'; 
SELECT molecule.label FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'ca' AND molecule.label = '+'; 
SELECT bond.bond_type FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'te';
SELECT DISTINCT element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR001_10_11'; 
SELECT ROUND(     (         SELECT COUNT(DISTINCT molecule_id) * 100.0 / (             SELECT COUNT(DISTINCT molecule_id)             FROM molecule         )         FROM bond         WHERE bond_type = '#'     ),     2 ) AS percentage_of_triple_bond_compounds; 
SELECT ROUND((CAST(SUM(CASE WHEN bond_type = '=' THEN 1 ELSE 0 END) AS REAL) / COUNT(*)) * 100, 2) AS percent FROM bond WHERE molecule_id = 'TR047'; 
SELECT molecule.label FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE atom.atom_id = 'TR001_1'; 
SELECT label FROM molecule WHERE molecule_id = 'TR151'; 
SELECT element FROM atom WHERE molecule_id = 'TR151';
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule WHERE molecule.label = '+';
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id BETWEEN 'TR011' AND 'TR049' AND atom.element = 'c'; 
SELECT COUNT(atom.atom_id) FROM     atom JOIN     molecule ON atom.molecule_id = molecule.molecule_id WHERE     molecule.label = '+';
SELECT bond.bond_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '=' AND molecule.label = '+'; 
SELECT COUNT(atom.atom_id) AS num_atoms FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'h' AND molecule.label = '+'; 
SELECT molecule_id FROM connected JOIN atom ON connected.atom_id = atom.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR00_1_2' AND atom.atom_id = 'TR00_1' 
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'c' AND molecule.label = '-'
SELECT (SUM(CASE WHEN molecule.label = '+' AND atom.element = 'h' THEN 1 ELSE 0 END) * 100.0) / COUNT(DISTINCT molecule.molecule_id) AS percentage FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+' AND atom.element = 'h'; 
SELECT label FROM molecule WHERE molecule_id = 'TR124'; 
SELECT atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR186';
SELECT bond.bond_type FROM     bond JOIN     connected ON bond.bond_id = connected.bond_id WHERE     connected.atom_id2 = 'TR007_4_19';
SELECT atom.element FROM connected JOIN bond ON connected.bond_id = bond.bond_id JOIN atom ON connected.atom_id = atom.atom_id WHERE bond.bond_id = 'TR001_2_4'; 
SELECT COUNT(*) AS double_bonds, m.label AS carcinogenic FROM bond b JOIN molecule m ON b.molecule_id = m.molecule_id WHERE b.bond_type = '=' AND m.molecule_id = 'TR006'; 
SELECT molecule.molecule_id, atom.element FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id WHERE molecule.label = '+'; 
SELECT bond.bond_id, atom.atom_id, atom.element, molecule.label FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id WHERE bond.bond_type = '-'; 
SELECT molecule_id, GROUP_CONCAT(DISTINCT element) AS elements FROM (     SELECT    DISTINCT molecule.molecule_id,     atom.element     FROM     molecule     INNER JOIN bond ON molecule.molecule_id = bond.molecule_id     INNER JOIN connected ON bond.bond_id = connected.bond_id     INNER JOIN atom ON connected.atom_id2 = atom.atom_id     WHERE bond.bond_type = '#' ) AS molecules_with_triple_bonds GROUP BY molecule_id; 
SELECT atom.element FROM     atom JOIN     connected ON atom.atom_id = connected.atom_id JOIN     bond ON connected.bond_id = bond.bond_id WHERE     bond.bond_id = 'TR000_2_3' 
SELECT COUNT(bond.bond_id) FROM     bond JOIN     connected ON bond.bond_id = connected.bond_id JOIN     atom ON connected.atom_id = atom.atom_id WHERE     atom.element = 'cl';
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR346';  SELECT COUNT(DISTINCT bond.bond_type) FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR346'; 
SELECT COUNT(DISTINCT molecule.molecule_id) FROM     molecule JOIN     bond ON molecule.molecule_id = bond.molecule_id JOIN     connected ON bond.bond_id = connected.bond_id WHERE     bond.bond_type = ' = '     AND molecule.label = '+';
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule LEFT JOIN atom ON molecule.molecule_id = atom.molecule_id LEFT JOIN connected ON atom.atom_id = connected.atom_id LEFT JOIN bond ON connected.bond_id = bond.bond_id WHERE element != 's' AND (bond.bond_type IS NULL OR bond.bond_type != '=')
SELECT `molecule`.`label` FROM `bond` JOIN `molecule` ON `bond`.`molecule_id` = `molecule`.`molecule_id` WHERE `bond`.`bond_id` = 'TR001_2_4';
SELECT COUNT(atom.atom_id) FROM atom WHERE atom.molecule_id = 'TR005';
SELECT COUNT(*) FROM bond WHERE bond_type = '-';
SELECT DISTINCT molecule_id FROM molecule WHERE molecule_id IN (     SELECT DISTINCT atom.molecule_id     FROM atom     WHERE element = 'cl' ) AND label = '+'; 
SELECT DISTINCT molecule.molecule_id FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'c' AND molecule.label = '-' 
SELECT ROUND((CAST(SUM(CASE WHEN molecule.label = '+' AND atom.element = 'cl' THEN 1 ELSE 0 END) AS FLOAT) / COUNT(DISTINCT molecule.molecule_id)) * 100, 2) AS percentage FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id WHERE atom.element = 'cl'; 
SELECT molecule_id FROM bond WHERE bond_id = 'TR001_1_7'; 
SELECT COUNT(atom.element) FROM     connected JOIN     bond ON connected.bond_id = bond.bond_id JOIN     atom ON connected.atom_id2 = atom.atom_id WHERE     bond.bond_id = 'TR001_3_4';
SELECT bond.bond_type FROM     connected JOIN bond ON connected.bond_id = bond.bond_id WHERE     connected.atom_id = 'TR000_1'     AND connected.atom_id2 = 'TR000_2';
SELECT molecule.molecule_id FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.atom_id = 'TR000_2' AND connected.atom_id2 = 'TR000_4'; 
SELECT atom.element FROM atom WHERE atom.atom_id = 'TR000_1'; 
SELECT molecule.label FROM molecule WHERE molecule.molecule_id = 'TR000'; 
SELECT ROUND((CAST(SUM(CASE WHEN bond.bond_type = '-' THEN 1 ELSE 0 END) AS FLOAT) / COUNT(DISTINCT atom.atom_id)) * 100, 2) AS percentage FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id 
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id WHERE atom.element = 'n' AND molecule.label = '+';
SELECT molecule.molecule_id FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element = 's' AND bond.bond_type = '='; 
SELECT molecule_id FROM molecule WHERE label = '-'  GROUP BY molecule_id HAVING COUNT(atom_id) > 5; 
SELECT atom.element FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON connected.bond_id = bond.bond_id JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR024' AND bond.bond_type = '=' 
SELECT molecule_id FROM molecule WHERE label = '+' GROUP BY molecule_id ORDER BY COUNT(atom_id) DESC LIMIT 1; 
SELECT (SELECT (COUNT(DISTINCT molecule.molecule_id) * 100.0) / (SELECT COUNT(DISTINCT molecule_id) FROM atom WHERE element = 'h' AND atom_id IN (SELECT atom_id FROM connected WHERE bond_id IN (SELECT bond_id FROM bond WHERE bond_type = '#'))) FROM molecule WHERE label = '+'); 
SELECT COUNT(DISTINCT molecule_id) FROM molecule WHERE label = '+';
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE molecule.molecule_id BETWEEN 'TR004' AND 'TR010' AND bond.bond_type = '-'
SELECT COUNT(*) FROM     atom WHERE     molecule_id = 'TR008'     AND element = 'c';
SELECT atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id LEFT JOIN connected ON connected.atom_id = atom.atom_id LEFT JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.atom_id = 'TR004_7' AND molecule.label = '-' 
SELECT COUNT(DISTINCT molecule.molecule_id) FROM     atom     INNER JOIN molecule ON atom.molecule_id = molecule.molecule_id     INNER JOIN connected ON atom.atom_id = connected.atom_id     INNER JOIN bond ON connected.bond_id = bond.bond_id WHERE     atom.element = 'o' AND bond.bond_type = '=';
SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '#' AND molecule.label = '-'
SELECT atom.element, bond.bond_type FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id AND connected.atom_id2 = atom.atom_id AND connected.bond_id = bond.bond_id WHERE molecule.molecule_id = 'TR016'; 
SELECT atom.atom_id FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'c' AND bond.bond_type = '=' AND molecule.molecule_id = 'TR012';
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+' AND atom.element = 'o';
SELECT * FROM cards WHERE cardkingdomfoilid = cardkingdomid AND cardkingdomid IS NOT NULL; 
SELECT cards.name FROM cards LEFT JOIN sets ON cards.setcode = sets.code WHERE cards.bordercolor = 'borderless' AND (cards.cardkingdomfoilid IS NULL OR cards.cardkingdomid IS NULL)
SELECT cards.name, MAX(cards.faceconvertedmanacost) AS max_face_converted_mana_cost FROM cards GROUP BY cards.name 
SELECT name FROM cards WHERE frameversion = '2015' AND edhrecrank < 100; 
SELECT cards.name FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.rarity = 'mythic' AND legalities.format = 'gladiator' AND legalities.status = 'Banned'; 
SELECT legalities.status FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.type = 'Artifact' AND cards.side IS NULL AND legalities.format = 'vintage';
SELECT cards.id, cards.artist FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.power IS NULL OR cards.power = '*' AND legalities.format = 'commander' AND legalities.status = 'Legal'; 
SELECT cards.text, rulings.text FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.artist = 'Stephen Daniele'; 
SELECT rulings.text FROM   cards JOIN   rulings ON cards.uuid = rulings.uuid WHERE   cards.name = 'Sublime Epiphany' AND cards.number = '74s';
SELECT cards.name, cards.artist, MAX(COUNT(rulings.uuid)) AS max_rulings_count, CASE     WHEN cards.ispromo = 1 THEN 'Yes'     ELSE 'No' END AS is_promotional FROM cards JOIN rulings ON rulings.uuid = cards.uuid GROUP BY cards.name, cards.artist ORDER BY max_rulings_count DESC LIMIT 1;
SELECT foreign_data.language FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.name = 'Annul' AND cards.number = '29'; 
SELECT cards.name FROM cards INNER JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Japanese';
SELECT SUM(CASE WHEN foreign_data.language = 'Chinese Simplified' THEN 1 ELSE 0 END) * 100.0 / COUNT(cards.id) AS percentage_available_in_chinese_simplified FROM cards LEFT JOIN foreign_data ON cards.uuid = foreign_data.uuid;
SELECT sets.name AS set_name, sets.totalsetsize AS total_cards FROM sets INNER JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language = 'Italian';
SELECT COUNT(DISTINCT cards.type) AS num_card_types FROM cards WHERE cards.artist = 'Aaron Boyd';
SELECT keywords FROM cards WHERE name = 'Angel of Mercy';
SELECT COUNT(*) FROM     cards WHERE     power = '*';
SELECT `promotypes` FROM cards WHERE name = 'Duress';
SELECT bordercolor FROM cards WHERE name = 'Ancestor\'s Chosen';
SELECT `type` FROM cards WHERE name = 'Ancestor\'s Chosen';
SELECT language FROM     set_translations WHERE     setcode = (         SELECT            sets.code         FROM             cards             INNER JOIN sets ON cards.setcode = sets.code         WHERE             cards.name = 'Angel of Mercy'     );
SELECT COUNT(DISTINCT cards.id) FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE legalities.status = 'Restricted' AND cards.istextless = '0';
SELECT text FROM rulings WHERE rulings.uuid = (SELECT uuid FROM cards WHERE name = 'Condemn');
SELECT COUNT(cards.id) AS restricted_cards_in_starter_deck FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE legalities.status = 'Restricted' AND cards.isstarter = 1;
SELECT legalities.status FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.name = 'Cloudchaser Eagle'; 
SELECT type FROM cards WHERE name = 'Benalish Knight';
SELECT legalities.status FROM legalities JOIN cards ON legalities.uuid = cards.uuid WHERE cards.name = "Benalish Knight";
SELECT artist FROM cards INNER JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Phyrexian';
SELECT ROUND((COUNT(CASE WHEN bordercolor = 'borderless' THEN id END) * 100.0) / COUNT(id), 2) AS percentage_borderless FROM cards;
SELECT COUNT(cards.id) FROM   cards JOIN   foreign_data ON cards.uuid = foreign_data.uuid WHERE   foreign_data.language = 'German' AND   cards.isreprint = 1;
SELECT COUNT(*) AS borderless_cards_in_russian FROM   cards JOIN   foreign_data ON cards.uuid = foreign_data.uuid WHERE   cards.bordercolor = 'borderless'   AND foreign_data.language = 'Russian';
SELECT ROUND((COUNT(DISTINCT foreign_data.id) * 100.0) / (SELECT COUNT(DISTINCT cards.id) FROM cards WHERE cards.isstoryspotlight = 1), 2) FROM foreign_data JOIN cards ON foreign_data.uuid = cards.uuid WHERE foreign_data.language = 'French' AND cards.isstoryspotlight = 1;
SELECT COUNT(*) FROM cards WHERE toughness = '99';
SELECT name FROM cards WHERE artist = 'Aaron Boyd';
SELECT COUNT(*) FROM cards WHERE bordercolor = 'black' AND availability = 'mtgo';
SELECT id FROM cards WHERE convertedmanacost = 0; 
SELECT cards.layout FROM cards WHERE cards.keywords LIKE '%Flying%' 
SELECT COUNT(DISTINCT cards.id) FROM cards WHERE originaltype = 'Summon - Angel' AND subtypes NOT LIKE '%Angel%';
SELECT cards.id FROM cards WHERE cards.hasfoil = 1 AND cards.hasnonfoil = 1 AND cards.cardkingdomfoilid IS NOT NULL AND cards.cardkingdomid IS NOT NULL; 
SELECT cards.id FROM cards WHERE cards.dueldeck = 'a';
SELECT cards.edhrecrank FROM cards WHERE cards.frameversion = '2015';
SELECT cards.artist FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Chinese Simplified';
SELECT cards.name FROM cards INNER JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.availability = 'paper' AND foreign_data.language = 'Japanese'; 
SELECT COUNT(*) FROM     cards JOIN     legalities ON cards.uuid = legalities.uuid WHERE     legalities.status = 'Banned' AND     cards.bordercolor = 'white';
SELECT cards.uuid, foreign_data.language FROM cards JOIN legalities ON cards.uuid = legalities.uuid JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE legalities.format = 'legacy';
SELECT rulings.text FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.name = 'Beacon of Immortality';
SELECT COUNT(*) AS future_frame_cards_count, legalities.status AS legality_status FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.frameversion = 'future';
SELECT cards.name, cards.colors FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.code = 'OGW';
SELECT cards.name, set_translations.language FROM cards JOIN set_translations ON cards.uuid = set_translations.setcode WHERE cards.setcode = '10E' AND cards.convertedmanacost = 5;
SELECT cards.name, rulings.date FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.originaltype LIKE '%Creature - Elf%'
SELECT cards.colors, cards.layout FROM cards WHERE cards.id BETWEEN 1 AND 20;
SELECT cards.name FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.originaltype = 'Artifact' AND cards.colors LIKE '%B%' AND foreign_data.language <> 'English';
SELECT cards.name FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.rarity = 'uncommon' ORDER BY rulings.date ASC LIMIT 3; 
SELECT COUNT(DISTINCT cards.id) FROM     cards WHERE     cards.artist = 'John Avon'     AND cards.hasfoil = 1     AND cards.cardkingdomfoilid IS NOT NULL     AND cards.cardkingdomid IS NOT NULL;
SELECT COUNT(*) FROM     cards WHERE     bordercolor = 'white'     AND cardkingdomfoilid = cardkingdomid     AND cardkingdomid IS NOT NULL;
SELECT COUNT(*) FROM cards WHERE artist = 'UDON' AND availability LIKE '%mtgo%' AND hand = -1;
SELECT COUNT(*) FROM     cards WHERE     frameversion = '1993'     AND availability LIKE '%paper%'     AND hascontentwarning = 1;
SELECT manacost FROM cards WHERE layout = 'normal' AND frameversion = '2003' AND bordercolor = 'black' AND availability IN ('paper', 'mtgo');
SELECT SUM(cards.convertedmanacost) FROM cards WHERE cards.artist = 'Rob Alexander';
SELECT DISTINCT types FROM cards WHERE availability = 'arena';
SELECT sets.code FROM set_translations WHERE set_translations.language = 'Spanish';
SELECT 100.0 * SUM(CASE WHEN hand = '+3' THEN 1 ELSE 0 END) / COUNT(id) FROM cards WHERE frameeffects = 'legendary';
SELECT cards.id FROM cards WHERE cards.isstoryspotlight = 1 AND cards.istextless = 0  
SELECT (SUM(CASE WHEN foreign_data.language = 'Spanish' THEN 1 ELSE 0 END) * 100.0) / COUNT(cards.id) AS percentage_spanish, cards.name FROM cards INNER JOIN foreign_data ON cards.uuid = foreign_data.uuid GROUP BY cards.name;
SELECT DISTINCT foreign_data.language FROM   sets JOIN   set_translations ON sets.code = set_translations.setcode JOIN   foreign_data ON sets.id = foreign_data.id WHERE   sets.basesetsize = 309
SELECT COUNT(*) AS num_translated_sets FROM   set_translations JOIN   sets ON set_translations.setcode = sets.code WHERE   sets.block = 'Commander'   AND set_translations.language = 'Portuguese (Brazil)';
SELECT cards.id FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.types LIKE '%Creature%' AND legalities.status = 'Legal';
SELECT DISTINCT types FROM cards INNER JOIN set_translations ON cards.uuid = set_translations.uuid INNER JOIN sets ON set_translations.setcode = sets.code WHERE language = 'German'
SELECT COUNT(*) FROM cards WHERE power IS NULL AND originaltext LIKE '%triggered ability%';
SELECT COUNT(DISTINCT cards.id) FROM cards JOIN legalities ON cards.uuid = legalities.uuid LEFT JOIN rulings ON cards.uuid = rulings.uuid WHERE legalities.format = 'pre-modern' AND rulings.text = 'This is a triggered mana ability' AND cards.side IS NULL;
SELECT cards.id FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.artist = 'Erica Yang' AND legalities.format = 'pauper' AND cards.availability LIKE '%paper%';
SELECT cards.artist FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.text = "Das perfekte Gegenmittel zu einer dichten Formation";
SELECT foreign_data.name FROM   cards JOIN   foreign_data ON cards.uuid = foreign_data.uuid WHERE   cards.artist = 'Matthew D. Wilson'   AND cards.layout = 'normal'   AND cards.bordercolor = 'black'   AND cards.types LIKE '%Creature%'
SELECT COUNT(cards.id) FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.rarity = 'rare' AND rulings.date = '2009-01-10';
SELECT foreign_data.language FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.block = 'Ravnica' AND sets.basesetsize = 180; 
SELECT 100 * SUM(CASE WHEN cards.hasContentWarning = 0 THEN 1 ELSE 0 END) / COUNT(cards.id) FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE legalities.format = 'commander' AND legalities.status = 'legal';
SELECT ROUND((COUNT(CASE WHEN language = 'French' AND (power IS NULL OR power = '*') THEN 1 END) * 100.0) / COUNT(CASE WHEN power IS NULL OR power = '*' THEN 1 END), 2) AS percentage_of_cards_in_french_without_power
SELECT 100 * (     SELECT COUNT(DISTINCT set_translations.setcode)     FROM set_translations     WHERE set_translations.language = 'Japanese'     AND EXISTS (         SELECT *         FROM sets         WHERE sets.code = set_translations.setcode         AND sets.type = 'expansion'     ) ) / (     SELECT COUNT(DISTINCT set_translations.setcode)     FROM set_translations     WHERE set_translations.language = 'Japanese' ) AS percentage_expansion_sets;
SELECT availability FROM cards WHERE artist = 'Daren Bader';
SELECT COUNT(*) FROM cards WHERE bordercolor = 'borderless' AND edhrecrank > 12000;
SELECT COUNT(*) FROM cards WHERE isOversized = 1 OR isReprint = 1 OR isPromo = 1;
SELECT name FROM cards WHERE (power IS NULL OR power = '*') AND promotypes LIKE '%arenaleague%' ORDER BY name ASC LIMIT 3; 
SELECT language FROM   foreign_data WHERE   multiverseid = 149934;
SELECT cards.cardkingdomfoilid AS kingdom_foil_id, cards.cardkingdomid AS kingdom_card_id FROM cards WHERE cards.cardkingdomfoilid IS NOT NULL AND cards.cardkingdomid IS NOT NULL ORDER BY cards.cardkingdomfoilid ASC, cards.cardkingdomid ASC LIMIT 3;
SELECT 100 * COUNT(CASE WHEN isTextless = 1 AND layout = 'normal' THEN 1 END) / COUNT(isTextless) FROM cards;
SELECT cards.number FROM cards WHERE cards.side IS NULL AND cards.subtypes LIKE '%Angel%' AND cards.subtypes LIKE '%Wizard%'
SELECT sets.name FROM sets WHERE sets.mtgocode IS NULL OR sets.mtgocode = '' ORDER BY sets.name ASC LIMIT 3; 
SELECT language FROM   set_translations WHERE   setcode = 'ARC' AND   translation = 'Archenemy';
SELECT sets.name AS set_name, set_translations.translation AS set_translation FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.id = 5;
SELECT sets.language, sets.type FROM sets WHERE sets.id = 206;
SELECT sets.id, sets.name FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language = 'Italian' AND sets.block = 'Shadowmoor' ORDER BY sets.name LIMIT 2; 
SELECT sets.id FROM sets WHERE sets.isForeignOnly = 1 AND sets.isFoilOnly = 1 AND sets.id IN (     SELECT DISTINCT     sets.id     FROM     sets     INNER JOIN set_translations ON sets.code = set_translations.setcode     WHERE     set_translations.language = 'Japanese' );
SELECT sets.name FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language = 'Russian' ORDER BY sets.basesetsize DESC LIMIT 1;
SELECT COUNT(*) * 100.0 / (SELECT COUNT(*) FROM cards WHERE language = 'Chinese Simplified') AS percentage FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE language = 'Chinese Simplified' AND isOnlineOnly = 1;
SELECT COUNT(DISTINCT sets.id) AS japanese_sets_not_in_mtgo FROM   sets INNER JOIN   set_translations ON sets.code = set_translations.setcode WHERE   set_translations.language = 'Japanese'   AND (sets.mtgocode IS NULL OR sets.mtgocode = '');
SELECT COUNT(*) AS border_black_count, cards.id AS card_id FROM cards WHERE cards.bordercolor = 'black';
SELECT id FROM cards WHERE frameeffects = 'extendedart' 
SELECT name FROM cards WHERE bordercolor = 'black' AND isfullart = 1 
SELECT language FROM set_translations WHERE setcode = (     SELECT code     FROM sets     WHERE id = 174 ); 
SELECT sets.name FROM sets WHERE sets.code = "ALL";
SELECT language FROM foreign_data WHERE name = 'A Pedra Fellwar';
SELECT code FROM sets WHERE releasedate = '2007-07-13'; 
SELECT sets.basesetsize, sets.code FROM sets WHERE sets.block = "Masques" OR sets.block = "Mirage";
SELECT `code` FROM sets WHERE type = 'expansion';
SELECT foreign_data.name AS foreign_name, cards.type AS card_type FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.watermark = 'boros'; 
SELECT foreign_data.language, foreign_data.flavortext, cards.type FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.watermark = 'colorpie'; 
SELECT COUNT(cards.id) * 100.0 / (SELECT COUNT(cards.id) FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.convertedmanacost = 10 AND sets.name = 'Abyssal Horror') FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.convertedmanacost = 10 AND sets.name = 'Abyssal Horror';
SELECT `sets.code` FROM sets WHERE sets.type = 'commander';
SELECT foreign_data.name AS foreign_name, cards.type AS card_type FROM cards JOIN sets ON cards.setcode = sets.code JOIN foreign_data ON foreign_data.uuid = cards.uuid WHERE cards.watermark = 'abzan'; 
SELECT foreign_data.language, cards.type FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.watermark = 'azorius'; 
SELECT COUNT(*) FROM cards WHERE artist = 'Aaron Miller' AND cardkingdomfoilid = cardkingdomid AND cardkingdomid IS NOT NULL;
SELECT COUNT(*) FROM cards WHERE availability LIKE '%paper%' AND hand LIKE '+%';
SELECT name FROM cards WHERE istextless = 0; 
SELECT `convertedmanacost` FROM cards WHERE name = 'Ancestor`s Chosen';
SELECT COUNT(*) FROM cards WHERE bordercolor = 'white' AND (power = '*' OR power IS NULL);
SELECT cards.name FROM cards WHERE cards.ispromo = 1 AND cards.side IS NOT NULL;
SELECT types FROM cards WHERE name = 'Molimo, Maro-Sorcerer';
SELECT purchaseurls FROM cards WHERE promotypes = 'bundle';
SELECT COUNT(DISTINCT artist) FROM cards WHERE bordercolor = 'black' AND availability LIKE '%arena%' AND availability LIKE '%mtgo%';
SELECT MAX(convertedmanacost) AS max_converted_mana_cost FROM cards WHERE name = 'Serra Angel' OR name = 'Shrine Keeper';
SELECT cards.artist FROM cards WHERE cards.flavorname = 'Battra, Dark Destroyer';
SELECT name FROM cards WHERE frameversion = '2003' ORDER BY convertedmanacost DESC LIMIT 3;
SELECT sets.name AS italian_set_name FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid JOIN sets ON sets.code = foreign_data.setcode WHERE cards.name = 'Ancestor\'s Chosen' AND foreign_data.language = 'Italian';
SELECT COUNT(DISTINCT set_translations.language) AS translation_count FROM   cards JOIN   set_translations ON cards.name = 'Angel of Mercy' AND cards.uuid = set_translations.setcode;
SELECT name FROM cards JOIN set_translations ON cards.uuid = set_translations.uuid WHERE set_translations.translation = 'Hauptset Zehnte Edition';
SELECT cards.name, foreign_data.language FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.name = 'Ancestor\'s Chosen' AND foreign_data.language = 'Korean';
SELECT COUNT(cards.id) FROM cards JOIN sets ON cards.setcode = sets.code JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Hauptset Zehnte Edition' AND cards.artist = 'Adam Rex';
SELECT COUNT(cards.id) AS num_cards FROM     cards JOIN     set_translations ON cards.setcode = set_translations.setcode JOIN     sets ON cards.setcode = sets.code WHERE     set_translations.translation = 'Hauptset Zehnte Edition';
SELECT set_translations.translation FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.name = 'Eighth Edition' AND set_translations.language = 'Chinese Simplified';
SELECT COUNT(*)  FROM cards  INNER JOIN sets ON cards.setcode = sets.code  WHERE cards.name = 'Angel of Mercy' AND sets.mtgocode IS NOT NULL;
SELECT sets.releasedate FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.name = 'Ancestor''s Chosen'; 
SELECT sets.type FROM sets INNER JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Hauptset Zehnte Edition';
SELECT COUNT(DISTINCT sets.name) AS italian_translated_sets FROM sets INNER JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.block = 'Ice Age' AND set_translations.language = 'Italian';
SELECT cards.name, sets.isforeignonly FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.name = 'Adarkar Valkyrie';
SELECT COUNT(sets.id) FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language = 'Italian' AND sets.basesetsize < 10;
SELECT COUNT(*) FROM     cards WHERE     cards.setcode = (SELECT code FROM sets WHERE name = 'Coldsnap')     AND cards.bordercolor = 'black';
SELECT name FROM     cards WHERE     setcode = 'CSP'     AND convertedmanacost = (         SELECT MAX(convertedmanacost)         FROM cards         WHERE setcode = 'CSP'     );
SELECT artist FROM cards WHERE name = 'Coldsnap'  AND artist IN ('Jeremy Jarvis', 'Aaron Miller', 'Chippy');
SELECT `name` FROM     cards JOIN     sets ON cards.setcode = sets.code WHERE     sets.name = 'Coldsnap'     AND cards.number = '4';
SELECT COUNT(*) FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.name = 'Coldsnap' AND cards.convertedmanacost > 5 AND (cards.power = '*' OR cards.power IS NULL)
SELECT flavortext FROM   cards JOIN   foreign_data ON   cards.uuid = foreign_data.uuid WHERE   cards.name = 'Ancestor''s Chosen' AND   foreign_data.language = 'Italian';
SELECT foreign_data.language FROM foreign_data JOIN cards ON foreign_data.uuid = cards.uuid WHERE cards.name = 'Ancestor''s Chosen' AND foreign_data.flavortext IS NOT NULL;
SELECT type FROM foreign_data WHERE name = 'Ancestor''s Chosen' AND language = 'German';
SELECT foreign_data.text FROM cards JOIN sets ON cards.setcode = sets.code JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE sets.name = 'Coldsnap' AND foreign_data.language = 'Italian' 
SELECT foreign_data.name FROM   cards JOIN   sets ON cards.setcode = sets.code JOIN   foreign_data ON cards.uuid = foreign_data.uuid WHERE   sets.name = 'Coldsnap' AND   cards.convertedmanacost = (     SELECT      MAX(convertedmanacost)     FROM       cards     WHERE       sets.name = 'Coldsnap'   ) AND   foreign_data.language = 'Italian';
SELECT rulings.date FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.name = 'Reminisce';
SELECT (SELECT     (COUNT(*) * 100.0) /      (SELECT COUNT(*) FROM cards WHERE setcode = (SELECT code FROM sets WHERE name = 'Coldsnap'))  FROM      cards  WHERE      setcode = (SELECT code FROM sets WHERE name = 'Coldsnap') AND convertedmanacost = 7) 
SELECT 100 * SUM(CASE WHEN cards.setcode = 'CSP' AND cards.cardkingdomfoilid IS NOT NULL AND cards.cardkingdomid IS NOT NULL THEN 1 ELSE 0 END) / SUM(CASE WHEN cards.setcode = 'CSP' THEN 1 ELSE 0 END) AS percentage_incredibly_powerful FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.name = 'Coldsnap';
SELECT sets.code FROM sets WHERE sets.releasedate = '2017-07-14';
SELECT keyruneCode FROM sets WHERE code = 'PKHC';
SELECT sets.mcmid FROM sets WHERE sets.code = 'SS2';
SELECT sets.mcmname FROM sets WHERE sets.releasedate = '2017-06-09';
SELECT sets.type FROM sets INNER JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation LIKE 'From the Vault: Lore';
SELECT sets.parentcode FROM sets WHERE sets.name = 'Commander 2014 Oversized';
SELECT cards.id, cards.name, rulings.text,         CASE             WHEN cards.hasContentWarning = 1 THEN 'Yes'            ELSE 'No'        END AS missing_or_degraded_properties_values FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.artist = 'Jim Pavelec'; 
SELECT sets.releasedate FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.name = 'Evacuation';
SELECT COUNT(cards.id) AS num_cards_in_set FROM     cards JOIN     set_translations ON cards.uuid = set_translations.uuid JOIN     sets ON set_translations.setcode = sets.code WHERE     sets.name = 'Rinascita di Alara';
SELECT sets.type FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Huitième édition';
SELECT set_translations.translation FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid JOIN sets ON cards.setcode = sets.code JOIN set_translations ON sets.code = set_translations.setcode WHERE cards.name = 'Tendo Ice Bridge' AND foreign_data.language = 'French';
SELECT COUNT(set_translations.translation) FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.name = 'Salvat 2011';
SELECT sets.translation FROM sets JOIN set_translations ON sets.code = set_translations.setcode JOIN cards ON set_translations.language = 'Japanese' AND cards.name = 'Fellwar Stone';
SELECT MAX(cards.name) FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.name = "Journey into Nyx Hero's Path" AND cards.convertedmanacost = (     SELECT MAX(convertedmanacost)      FROM cards      JOIN sets ON cards.setcode = sets.code      WHERE sets.name = "Journey into Nyx Hero's Path" )
SELECT sets.releasedate FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Ola de frío';
SELECT sets.type FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.name = 'Samite Pilgrim';
SELECT COUNT(cards.id) AS num_cards FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.name = 'World Championship Decks 2004' AND cards.convertedmanacost = 3;
SELECT translation FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.name = 'Mirrodin' AND set_translations.language = 'Chinese Simplified';
SELECT ROUND((SUM(cards.isNonfoilOnly = 1) * 100.0) / SUM(foreign_data.language = 'Japanese'), 2) AS Percentage_of_Japanese_Nonfoil FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Japanese';
SELECT SUM(CASE WHEN foreign_data.language = 'Portuguese (Brazil)' THEN 1 ELSE 0 END) AS total_brazil_portuguese, SUM(CASE WHEN foreign_data.language = 'Portuguese (Brazil)' AND cards.isOnlineOnly = 1 THEN 1 ELSE 0 END) AS online_only_brazil_portuguese, ROUND((SUM(CASE WHEN foreign_data.language = 'Portuguese (Brazil)' AND cards.isOnlineOnly = 1 THEN 1 ELSE 0 END) / SUM(CASE WHEN foreign_data.language = 'Portuguese (Brazil)' THEN 1 ELSE 0 END)) * 100, 2) AS percentage_online_only_brazil_portuguese FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid;
SELECT cards.availability FROM cards LEFT JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.artist = 'Aleksi Briclot' AND cards.istextless = 1;
SELECT MAX(sets.id)  FROM sets  WHERE sets.basesetsize = (SELECT MAX(sets.basesetsize) FROM sets);
SELECT cards.artist FROM cards WHERE cards.faceconvertedmanacost IS NOT NULL AND cards.side IS NULL ORDER BY cards.convertedmanacost DESC LIMIT 1;
SELECT MAX(frameeffects) AS most_common_visual_frame_effects FROM     cards WHERE     hasfoil = 1     AND cardkingdomfoilid IS NOT NULL     AND cardkingdomid IS NOT NULL;
SELECT COUNT(*) FROM cards WHERE (power IS NULL OR power = '*') AND hasfoil = 0 AND dueldeck = 'a';
SELECT sets.id FROM sets WHERE sets.type = 'commander' ORDER BY sets.totalsetsize DESC LIMIT 1;
SELECT cards.name, MAX(cards.convertedmanacost) AS highest_unconverted_mana_cost FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE legalities.format = 'duel' GROUP BY cards.name ORDER BY highest_unconverted_mana_cost DESC LIMIT 10;
SELECT MIN(c.originalreleasedate) AS "Oldest Mythic Card Release Date", l.format AS "Legal Play Formats" FROM cards c JOIN legalities l ON c.uuid = l.uuid WHERE c.rarity = 'mythic' AND l.status = 'Legal' ORDER BY c.originalreleasedate LIMIT 1;
SELECT COUNT(*) FROM   cards JOIN   foreign_data ON cards.uuid = foreign_data.uuid WHERE   cards.artist = 'Volkan Baga'   AND foreign_data.language = 'French';
SELECT COUNT(*) AS count FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE rarity = 'rare' AND types LIKE '%Enchantment%' AND name = 'Abundance' AND status = 'Legal';
SELECT legalities.format, cards.name FROM legalities JOIN cards ON legalities.uuid = cards.uuid WHERE legalities.status = 'banned' GROUP BY legalities.format ORDER BY COUNT(legalities.status) DESC LIMIT 1;
SELECT sets.language FROM sets WHERE sets.name = 'Battlebond';
SELECT artist, GROUP_CONCAT(DISTINCT legalities.format) AS formats FROM cards LEFT JOIN legalities ON cards.uuid = legalities.uuid GROUP BY artist ORDER BY COUNT(*) ASC LIMIT 1;
SELECT status FROM cards INNER JOIN legalities ON cards.uuid = legalities.uuid WHERE frameversion = '1997' AND artist = 'D. Alexander Gregory' AND format = 'legacy' AND (hascontentwarning = 1 OR artist = 'Wizards of the Coast');
SELECT name, format FROM cards INNER JOIN legalities ON cards.uuid = legalities.uuid WHERE edhrecrank = 1 AND status = 'Banned'
SELECT AVG(sets.id) FROM sets WHERE releasedate BETWEEN '2012-01-01' AND '2015-12-31';
SELECT cards.artist FROM cards WHERE cards.bordercolor = 'black' AND cards.availability = 'arena';
SELECT cards.uuid FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE legalities.format = 'oldschool' AND (legalities.status = 'banned' OR legalities.status = 'restricted');
SELECT COUNT(*) FROM     cards WHERE     artist = 'Matthew D. Wilson'     AND availability = 'paper';
SELECT rulings.text FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.artist = 'Kev Walker' ORDER BY rulings.date DESC;
SELECT cards.name FROM cards JOIN sets ON cards.setcode = sets.code JOIN legalities ON cards.uuid = legalities.uuid WHERE sets.name = 'Hour of Devastation' AND legalities.status = 'Legal';
SELECT sets.name FROM sets LEFT JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language NOT LIKE '%Japanese%' AND set_translations.language = 'Korean'
SELECT frameversion, name FROM cards WHERE artist = 'Allen Williams' UNION SELECT format, name FROM legalities JOIN cards ON legalities.uuid = cards.uuid WHERE status = 'Banned';
SELECT MAX(reputation) AS highest_reputation FROM users WHERE displayname IN ('Harlan', 'Jarrod Dixon');
SELECT users.displayname FROM users WHERE strftime('%Y', CreationDate) = '2014';
SELECT COUNT(DISTINCT users.id) FROM     users WHERE     LastAccessDate > '2014-09-01 00:00:00';
SELECT users.displayname FROM users WHERE users.views = (SELECT MAX(views) FROM users);
SELECT COUNT(DISTINCT users.id) FROM users JOIN (     SELECT        userid,         SUM(CASE WHEN votetypeid = 2 THEN 1 ELSE 0 END) AS upvotes,         SUM(CASE WHEN votetypeid = 3 THEN 1 ELSE 0 END) AS downvotes     FROM votes     GROUP BY userid     HAVING upvotes > 100 ) AS user_votes ON users.id = user_votes.userid WHERE user_votes.downvotes > 1;
SELECT COUNT(DISTINCT users.id) FROM     users JOIN     posts ON users.id = posts.owneruserid WHERE     posts.viewcount > 10     AND strftime('%Y', users.creationdate) > '2013';
SELECT COUNT(*) AS "Number of Posts Owned by csgillespie" FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie';
SELECT posts.title FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie';
SELECT users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = "Eliciting priors from experts";
SELECT posts.title FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie' ORDER BY posts.viewcount DESC LIMIT 1;
SELECT users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.favoritecount = (     SELECT    MAX(favoritecount)     FROM     posts     WHERE     favoritecount IS NOT NULL )
SELECT SUM(posts.commentcount) AS "Total Number of Comments" FROM     posts JOIN     users ON posts.ownerdisplayname = 'csgillespie' AND posts.owneruserid = users.id;
SELECT MAX(posts.answercount) AS max_answer_count FROM     posts JOIN     users ON posts.ownerdisplayname = users.displayname WHERE     users.displayname = 'csgillespie';
SELECT users.displayname FROM posts JOIN users ON posts.lasteditoruserid = users.id WHERE posts.title = "Examples for teaching: Correlation does not mean causation";
SELECT COUNT(*) FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie' AND posts.parentid IS NULL;
SELECT users.displayname FROM users INNER JOIN posts ON users.id = posts.owneruserid WHERE posts.closeddate IS NOT NULL;
SELECT COUNT(DISTINCT posts.id) FROM     posts JOIN     users ON posts.owneruserid = users.id WHERE     users.age > 65     AND posts.score >= 20;
SELECT users.location FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = 'Eliciting priors from experts';
SELECT posts.body FROM posts JOIN tags ON posts.id = tags.excerptpostid WHERE tags.tagname = 'bayesian'; 
SELECT posts.body FROM posts JOIN tags ON tags.excerptpostid = posts.id ORDER BY tags.count DESC LIMIT 1; 
SELECT COUNT(*) FROM badges INNER JOIN users ON badges.userid = users.id WHERE users.displayname = 'csgillespie';
SELECT badges.name FROM badges INNER JOIN users ON badges.userid = users.id WHERE users.displayname = 'csgillespie';
SELECT COUNT(badges.id) FROM     badges JOIN users ON badges.userid = users.id WHERE     users.displayname = 'csgillespie'     AND strftime('%Y', badges.date) = '2011';
SELECT users.displayname FROM     users JOIN     badges ON badges.userid = users.id GROUP BY     badges.userid ORDER BY     COUNT(badges.id) DESC LIMIT 1;
SELECT AVG(posts.score) AS average_score FROM     posts JOIN     users ON posts.owneruserid = users.id WHERE     users.displayname = 'csgillespie';
SELECT AVG(badges.id) AS average_badges FROM badges JOIN users ON badges.userid = users.id WHERE users.views > 200;
SELECT 100 * COUNT(DISTINCT posts.id) FILTER (WHERE posts.score > 20 AND users.age > 65) / COUNT(DISTINCT posts.id) FROM posts JOIN users ON posts.owneruserid = users.id;
SELECT COUNT(*) AS total_votes FROM     votes WHERE     userid = 58     AND creationdate LIKE '2010-07-19%'
SELECT MAX(creationdate) AS "Creation Date of Maximum Votes" FROM votes
SELECT COUNT(*) FROM badges WHERE name = 'Revival';
SELECT posts.title FROM     posts JOIN     comments ON posts.id = comments.postid WHERE     comments.score = (SELECT MAX(score) FROM comments); 
SELECT COUNT(comments.id) FROM posts JOIN comments ON posts.id = comments.postid WHERE posts.viewcount = 1910;
SELECT COUNT(posts.favoritecount) AS favorite_count FROM     comments     JOIN posts ON comments.postid = posts.id WHERE     comments.userid = '3025'     AND comments.creationdate = '2014-04-23 20:29:39.0'
SELECT comments.text FROM     comments JOIN     posts ON comments.postid = posts.id WHERE     posts.parentid = 107829;
SELECT  CASE     WHEN EXISTS (         SELECT 1         FROM comments c         JOIN posts p ON c.postid = p.id         WHERE c.userid = 23853         AND p.creationdate = '2013-07-12 09:08:18.0'         AND p.closeddate IS NULL     )     THEN 'Well-finished'     ELSE 'Not well-finished' END;
SELECT users.reputation FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.id = '65041';
SELECT COUNT(DISTINCT posts.id) FROM     users JOIN     posts ON posts.owneruserid = users.id WHERE     users.displayname = "Tiago Pasqualini";
SELECT users.displayname FROM     votes JOIN     users ON votes.userid = users.id WHERE     votes.id = 6347;
SELECT COUNT(votes.id) AS num_votes FROM     posts JOIN     votes ON posts.id = votes.postid WHERE     posts.title LIKE '%data visualization%';
SELECT name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = "DatEpicCoderGuyWhoPrograms";
SELECT COUNT(DISTINCT posts.id) / COUNT(DISTINCT votes.id) AS post_to_vote_ratio FROM posts LEFT JOIN votes ON posts.id = votes.postid WHERE posts.owneruserid = 24;
SELECT SUM(posts.viewcount) FROM posts WHERE posts.title = 'Integration of Weka and/or RapidMiner into Informatica PowerCenter/Developer';
SELECT comments.text FROM comments WHERE comments.score = 17; 
SELECT users.displayname FROM users WHERE users.websiteurl = 'http://stackoverflow.com';
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = 'SilentGhost';
SELECT users.displayname FROM     comments JOIN     users ON comments.userid = users.id WHERE     comments.text = 'thank you user93!';
SELECT comments.text FROM     comments JOIN     users ON comments.userid = users.id WHERE     users.displayname = 'A Lion';
SELECT users.displayname, users.reputation FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = 'Understanding what Dassault iSight is doing?';
SELECT comments.text FROM     comments     JOIN posts ON comments.postid = posts.id WHERE     posts.title = 'How does gentle boosting differ from AdaBoost?';
SELECT users.displayname FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = 'Necromancer' LIMIT 10;
SELECT users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = 'Open source tools for visualizing multi-dimensional data?';
SELECT posts.title FROM posts JOIN users ON posts.lasteditoruserid = users.id WHERE users.displayname = 'Vebjorn Ljosa';
SELECT SUM(posts.score) AS total_score, users.websiteurl FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'Yevgeny'
SELECT comments.text FROM comments JOIN posts ON comments.postid = posts.id JOIN posthistory ON posthistory.postid = posts.id JOIN users ON comments.userid = users.id WHERE posts.title = 'Why square the difference instead of taking the absolute value in standard deviation?' AND posthistory.userid = users.id;
SELECT SUM(votes.bountyamount) FROM     posts JOIN     votes ON votes.postid = posts.id WHERE     posts.title LIKE '%data%'
SELECT users.displayname FROM users JOIN votes ON users.id = votes.userid JOIN posts ON votes.postid = posts.id WHERE posts.title LIKE '%variance%' AND votes.bountyamount = 50;
SELECT AVG(posts.viewcount) AS average_view_count, posts.title, comments.text AS post_comment, comments.score AS comment_score FROM posts JOIN posttags ON posts.id = posttags.postid JOIN tags ON posttags.tagid = tags.id LEFT JOIN comments ON posts.id = comments.postid WHERE tags.tagname = 'humor' GROUP BY posts.id;
SELECT COUNT(comments.id) FROM     comments WHERE     comments.userid = 13;
SELECT MAX(id) FROM users WHERE reputation = (SELECT MAX(reputation) FROM users);
SELECT MIN(users.id) AS lowest_view FROM users
SELECT COUNT(DISTINCT users.id) FROM     badges INNER JOIN users ON badges.userid = users.id WHERE     badges.name = 'Supporter'     AND strftime('%Y', badges.date) = '2011'
SELECT COUNT(DISTINCT badges.userid) FROM badges GROUP BY badges.userid HAVING COUNT(badges.name) > 5;
SELECT COUNT(DISTINCT users.id) FROM users JOIN badges ON badges.userid = users.id WHERE badges.name IN ('Teacher', 'Supporter') AND users.location = 'New York';
SELECT users.id, users.reputation FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.id = 1;
SELECT users.id FROM users JOIN posthistory ON users.id = posthistory.userid JOIN posts ON posthistory.postid = posts.id WHERE posts.viewcount >= 1000 GROUP BY users.id HAVING COUNT(DISTINCT posthistory.postid) = 1;
SELECT users.displayname, users.reputation, badges.name AS badge_name FROM (     SELECT    userid,     COUNT(id) AS comment_count     FROM comments     GROUP BY userid     ORDER BY comment_count DESC     LIMIT 1 ) AS top_commenter JOIN users ON users.id = top_commenter.userid LEFT JOIN badges ON badges.userid = top_commenter.userid 
SELECT COUNT(DISTINCT users.id) FROM     users JOIN     badges ON badges.userid = users.id WHERE     users.location = 'India'     AND badges.name = 'Teacher';
SELECT ((COUNT(CASE WHEN strftime('%Y', date) = '2010' THEN 1 END) - COUNT(CASE WHEN strftime('%Y', date) = '2011' THEN 1 END)) * 100.0) / COUNT(name) AS percentage_difference FROM badges WHERE name = 'Student';
SELECT posthistorytypeid, COUNT(DISTINCT comments.userid) AS unique_commenters FROM posthistory LEFT JOIN comments ON posthistory.postid = comments.postid WHERE posthistory.postid = 3720 GROUP BY posthistorytypeid; 
SELECT posts.id, posts.title, posts.viewcount AS popularity FROM posts JOIN postlinks ON postlinks.postid = posts.id WHERE postlinks.relatedpostid = 61217; 
SELECT posts.score, postlinks.linktypeid FROM posts LEFT JOIN postlinks ON posts.id = postlinks.postid WHERE posts.id = 395; 
SELECT posts.id AS post_id, posts.owneruserid AS user_id FROM posts WHERE posts.score > 60; 
SELECT SUM(posts.favoritecount) AS total_favorite_count FROM     posts WHERE     posts.owneruserid = 686     AND strftime('%Y', posts.creationdate) = '2011';
SELECT AVG(users.upvotes) AS average_upvotes, AVG(users.age) AS average_age FROM users JOIN posts ON users.id = posts.owneruserid GROUP BY users.id HAVING COUNT(posts.id) > 10;
SELECT COUNT(DISTINCT badges.userid) FROM badges WHERE badges.name = 'Announcer';
SELECT name FROM badges WHERE date = '2010-07-19 19:39:08';
SELECT COUNT(*) FROM     comments WHERE     score > 60;
SELECT comments.text FROM comments WHERE comments.creationdate = '2010-07-19 19:25:47.0';
SELECT COUNT(*) FROM posts WHERE score = 10;
SELECT name FROM badges JOIN users ON badges.userid = users.id WHERE users.reputation = (SELECT MAX(reputation) FROM users)
SELECT users.reputation FROM users JOIN badges ON users.id = badges.userid WHERE badges.date = '2010-07-19 19:39:08.0'; 
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = "Pierre";
SELECT badges.date FROM badges JOIN users ON badges.userid = users.id WHERE users.location = 'Rochester, NY'; 
SELECT COUNT(DISTINCT users.id) * 100.0 / (SELECT COUNT(DISTINCT users.id) FROM badges WHERE name = "Teacher") AS Percentage FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = "Teacher";
SELECT (CAST(COUNT(CASE WHEN age BETWEEN 13 AND 18 THEN users.id END) AS FLOAT) / COUNT(users.id)) * 100 AS percentage_of_teenagers FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = 'Organizer';
SELECT comments.score FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.creationdate = '2010-07-19 19:19:56.0'; 
SELECT comments.text FROM     comments JOIN     posts ON comments.postid = posts.id WHERE     posts.creationdate = '2010-07-19 19:37:33.0';
SELECT users.age FROM badges INNER JOIN users ON badges.userid = users.id WHERE users.location = 'Vienna, Austria';
SELECT COUNT(DISTINCT users.id) FROM     users     INNER JOIN badges ON users.id = badges.userid WHERE     badges.name = 'Supporter'     AND users.age BETWEEN 19 AND 65;
SELECT COUNT(DISTINCT users.views) FROM     badges JOIN     users ON badges.userid = users.id WHERE     badges.date = '2010-07-19 19:39:08.0'
SELECT name FROM badges INNER JOIN users ON badges.userid = users.id WHERE users.reputation = (SELECT MIN(reputation) FROM users);
SELECT name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = "Sharpie";
SELECT COUNT(DISTINCT users.id) FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = 'Supporter' AND users.age > 65;
SELECT users.displayname FROM users WHERE users.id = 30; 
SELECT COUNT(DISTINCT users.id) FROM users WHERE users.location = 'New York';
SELECT COUNT(*) FROM votes WHERE strftime('%Y', CreationDate) = '2010';
SELECT COUNT(DISTINCT users.id) FROM users WHERE age BETWEEN 19 AND 65;
SELECT users.displayname FROM users WHERE views = (SELECT MAX(views) FROM users);
SELECT COUNT(CASE WHEN strftime('%Y', CreationDate) = '2010' THEN id END) / COUNT(CASE WHEN strftime('%Y', CreationDate) = '2011' THEN id END) FROM votes;
SELECT tags.tagname FROM users JOIN posts ON users.id = posts.owneruserid JOIN tags ON posts.id = tags.excerptpostid WHERE users.displayname = 'John Stauffer';
SELECT COUNT(*) FROM     posts JOIN     users ON posts.owneruserid = users.id WHERE     users.displayname = 'Daniel Vassallo';
SELECT COUNT(*) AS "Total Votes" FROM     votes JOIN     users ON votes.userid = users.id WHERE     users.displayname = 'Harlan';
SELECT posts.id FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'slashnick' ORDER BY posts.answercount DESC LIMIT 1;
SELECT MAX(SUM(ViewCount)) AS Max_View_Count FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname IN ('Harvey Motulsky', 'Noah Snyder') GROUP BY users.displayname;
SELECT COUNT(DISTINCT posts.id) FROM     posts JOIN     users ON posts.owneruserid = users.id WHERE     users.displayname = 'Matt Parker'     AND posts.score > 4;
SELECT COUNT(comments.id) FROM     comments JOIN     users ON comments.userid = users.id JOIN     posts ON comments.postid = posts.id WHERE     users.displayname = 'Neil McGuigan'     AND comments.score < 60;
SELECT tags.tagname FROM posts JOIN users ON posts.owneruserid = users.id JOIN posttags ON posts.id = posttags.postid JOIN tags ON posttags.tagid = tags.id LEFT JOIN comments ON posts.id = comments.postid WHERE users.displayname = 'Mark Meckes' AND comments.id IS NULL;
SELECT users.displayname FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = 'Organizer';
SELECT (CAST(COUNT(posts.id) FILTER (WHERE tags.tagname = 'r') AS REAL) / COUNT(posts.id) FILTER (WHERE posts.ownerdisplayname = 'Community')) * 100 AS percentage FROM posts LEFT JOIN tags ON tags.excerptpostid = posts.id WHERE posts.ownerdisplayname = 'Community';
SELECT SUM(CASE WHEN users.displayname = 'mornington' THEN posts.viewcount ELSE 0 END) - SUM(CASE WHEN users.displayname = 'Amos' THEN posts.viewcount ELSE 0 END) FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname IN ('mornington', 'Amos');
SELECT COUNT(DISTINCT badges.userid) AS commentator_badge_users_2014 FROM     badges WHERE     badges.name = 'Commentator'     AND strftime('%Y', badges.date) = '2014';
SELECT COUNT(*) FROM     posts WHERE     CreationDate BETWEEN '2010-07-21 00:00:00' AND '2010-07-21 23:59:59';
SELECT users.displayname, users.age FROM users WHERE users.views = (SELECT MAX(views) FROM users); 
SELECT MAX(posts.lasteditdate) AS last_edit_date, posts.lasteditoruserid AS last_editor_user_id FROM posts WHERE posts.title = 'Detecting a given face in a database of facial images';
SELECT COUNT(comments.id) FROM     comments WHERE     comments.userid = 13     AND comments.score < 60;
SELECT posts.title, comments.userdisplayname FROM posts JOIN comments ON posts.id = comments.postid WHERE comments.score > 60; 
SELECT badges.name FROM badges JOIN users ON badges.userid = users.id WHERE badges.date BETWEEN '2011-01-01 00:00:00.0' AND '2011-12-31 23:59:59.999' AND users.location = 'North Pole'; 
SELECT users.displayname, users.websiteurl FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.favoritecount > 150;
SELECT COUNT(posthistory.id) AS post_history_count, MAX(posthistory.creationdate) AS last_edit_date FROM posts LEFT JOIN posthistory ON posts.id = posthistory.postid WHERE posts.title = "What is the best introductory Bayesian statistics textbook?";
SELECT users.lastaccessdate, users.location FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = 'outliers';
SELECT posts.title FROM posts JOIN postlinks ON posts.id = postlinks.relatedpostid WHERE postlinks.postid = (     SELECT id FROM posts WHERE title = 'How to tell if something happened in a data set which monitors a value over time' ) 
SELECT posts.id AS post_id, badges.name AS badge_name FROM posts JOIN users ON posts.owneruserid = users.id JOIN badges ON badges.userid = users.id WHERE users.displayname = 'Samuel' AND strftime('%Y', posts.creationdate) = '2013' AND strftime('%Y', badges.date) = '2013'; 
SELECT `posts.ownerdisplayname` FROM posts WHERE posts.viewcount = (SELECT MAX(viewcount) FROM posts);
SELECT users.displayname, users.location FROM users JOIN posts ON users.id = posts.owneruserid JOIN tags ON tags.excerptpostid = posts.id WHERE tags.tagname = 'hypothesis-testing';
SELECT posts.title, postlinks.linktypeid FROM posts JOIN postlinks ON posts.id = postlinks.relatedpostid WHERE posts.title = 'What are principal component scores?'; 
SELECT MAX(posts.score) AS highest_score,     posts.parentid AS parent_id,     parent.displayname AS parent_displayname FROM     posts JOIN     users AS parent ON posts.parentid = parent.id WHERE     posts.parentid IS NOT NULL;
SELECT users.displayname, users.websiteurl FROM votes JOIN users ON votes.userid = users.id WHERE votes.votetypeid = 8 AND votes.bountyamount = (SELECT MAX(bountyamount) FROM votes WHERE votetypeid = 8); 
SELECT title FROM posts ORDER BY viewcount DESC LIMIT 5; 
SELECT COUNT(DISTINCT tagname) FROM tags WHERE count BETWEEN 5000 AND 7000;
SELECT posts.owneruserid FROM posts WHERE posts.favoritecount = (SELECT MAX(FavoriteCount) FROM posts); 
SELECT MAX(age) AS "Oldest age" FROM users WHERE reputation = (     SELECT MAX(reputation) FROM users );
SELECT COUNT(DISTINCT posts.id) FROM     posts JOIN     votes ON posts.id = votes.postid WHERE     YEAR(posts.creationdate) = 2011     AND votes.bountyamount = 50;
SELECT MIN(users.age) AS youngest_user_id FROM users;
SELECT MAX(posts.score) FROM     posts JOIN     tags ON posts.id = tags.excerptpostid;
SELECT AVG(     (         SELECT COUNT(pl.id)         FROM postlinks pl         JOIN posts p ON pl.postid = p.id         WHERE strftime('%Y', pl.creationdate) = '2010'         AND p.answercount <= 2     ) / 12 ) AS average_monthly_links_created_2010_with_max_2_answers;
SELECT MAX(posts.favoritecount) AS most_valuable_post_id FROM     posts JOIN     votes ON posts.id = votes.postid WHERE     votes.userid = 1465;
SELECT posts.title FROM postlinks JOIN posts ON postlinks.relatedpostid = posts.id WHERE postlinks.creationdate = (SELECT MIN(creationdate) FROM postlinks);
SELECT users.displayname FROM badges JOIN users ON badges.userid = users.id GROUP BY badges.userid ORDER BY COUNT(badges.name) DESC LIMIT 1;
SELECT MIN(votes.creationdate) AS "First Vote Date" FROM     votes JOIN     users ON votes.userid = users.id WHERE     users.displayname = 'chl';
SELECT MIN(posts.creationdate) AS "First Post Date" FROM     posts JOIN     users ON posts.owneruserid = users.id WHERE     users.age = (SELECT MIN(age) FROM users);
SELECT users.displayname FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = 'Autobiographer' ORDER BY badges.date ASC LIMIT 1;
SELECT COUNT(DISTINCT users.id) FROM     users JOIN     posts ON posts.owneruserid = users.id WHERE     users.location = 'United Kingdom'     AND posts.favoritecount >= 4;
SELECT AVG(posts.id)  FROM votes JOIN posts ON votes.postid = posts.id JOIN users ON votes.userid = users.id WHERE users.age = (SELECT MAX(age) FROM users)
SELECT MAX(users.reputation) AS highest_reputation FROM users;
SELECT COUNT(DISTINCT users.id) FROM users JOIN posts ON posts.owneruserid = users.id WHERE users.reputation > 2000 AND users.views > 1000;
SELECT users.displayname FROM users WHERE users.age BETWEEN 19 AND 65;
SELECT COUNT(*) AS "Number of Posts" FROM     posts JOIN     users ON posts.owneruserid = users.id WHERE     users.displayname = 'Jay Stevens'     AND STRFTIME('%Y', posts.creationdate) = '2010';
SELECT posts.id, posts.title FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'Harvey Motulsky' ORDER BY posts.viewcount DESC LIMIT 1;
SELECT posts.id AS post_id, posts.title AS post_title FROM posts WHERE posts.score = (SELECT MAX(score) FROM posts);
SELECT AVG(posts.score) AS average_score FROM     posts JOIN     users ON posts.owneruserid = users.id WHERE     users.displayname = 'Stephen Turner';
SELECT users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.viewcount > 20000 AND strftime('%Y', posts.creationdate) = '2011';
SELECT MAX(posts.favoritecount), posts.id, users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE strftime('%Y', posts.creationdate) = '2010'
SELECT (COUNT(posts.id) * 100.0 / (   SELECT COUNT(posts.id)   FROM posts   JOIN users ON posts.owneruserid = users.id   WHERE strftime('%Y', posts.creationdate) = '2011' )) AS percentage FROM posts JOIN users ON posts.owneruserid = users.id WHERE strftime('%Y', posts.creationdate) = '2011' AND users.reputation > 1000;
SELECT COUNT(CASE WHEN users.age BETWEEN 13 AND 18 THEN users.id END) * 100.0 / COUNT(users.id) AS percentage FROM users;
SELECT SUM(posts.viewcount) AS total_views, users.displayname AS last_poster FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = 'Computer Game Datasets' GROUP BY users.displayname ORDER BY posts.lasteditdate DESC LIMIT 1;
SELECT COUNT(*) FROM posts WHERE ViewCount > (SELECT AVG(ViewCount) FROM posts);
SELECT COUNT(comments.id) FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.score = (SELECT MAX(score) FROM posts)
SELECT COUNT(*) AS num_posts_no_comments FROM posts WHERE ViewCount > 35000 AND CommentCount = 0;
SELECT users.displayname, users.location FROM posts JOIN users ON posts.lasteditoruserid = users.id WHERE posts.id = 183;
SELECT name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = 'Emmett' ORDER BY badges.date DESC LIMIT 1;
SELECT COUNT(DISTINCT users.id) FROM     users JOIN     votes ON users.id = votes.userid WHERE     users.age BETWEEN 19 AND 65     AND votes.upvotes > 5000;
SELECT strftime('%Y-%m-%d %H:%M:%S', datetime(stats_badges.date, 'unixepoch')) - strftime('%Y-%m-%d %H:%M:%S', datetime(users.creationdate, 'unixepoch')) AS badge_duration FROM badges INNER JOIN users ON badges.userid = users.id WHERE users.displayname = 'Zolomon';
SELECT COUNT(DISTINCT posts.id) AS num_posts, COUNT(comments.id) AS num_comments FROM     users JOIN posts ON posts.owneruserid = users.id JOIN comments ON comments.userid = users.id WHERE     users.creationdate = (SELECT MAX(creationdate) FROM users);
SELECT comments.text, users.displayname FROM     comments JOIN     posts ON comments.postid = posts.id JOIN     users ON comments.userid = users.id WHERE     posts.title = 'Analysing wind data with R' ORDER BY     comments.creationdate DESC LIMIT 1;
SELECT COUNT(DISTINCT users.id) FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = 'Citizen Patrol';
SELECT COUNT(*) FROM     posts JOIN     tags ON posts.id = tags.excerptpostid WHERE     tags.tagname = 'careers';
SELECT users.reputation, users.views FROM users WHERE users.displayname = 'Jarrod Dixon';
SELECT COUNT(DISTINCT comments.id) AS comment_count, COUNT(DISTINCT posts.id) AS answer_count FROM posts LEFT JOIN comments ON posts.id = comments.postid WHERE posts.title = 'Clustering 1D data';
SELECT users.creationdate FROM users WHERE users.displayname = 'IrishStat'; 
SELECT COUNT(DISTINCT posts.id) FROM     posts JOIN     votes ON posts.id = votes.postid WHERE     votes.bountyamount >= 30;
SELECT COUNT(p.id) * 100.0 / (     SELECT COUNT(p2.id)     FROM posts p2     JOIN users u ON p2.owneruserid = u.id     WHERE u.reputation = (         SELECT MAX(reputation)         FROM users     ) ) AS percentage FROM posts p JOIN users u ON p.owneruserid = u.id WHERE u.reputation = (     SELECT MAX(reputation)     FROM users ) AND p.score > 50;
SELECT COUNT(*) FROM     posts WHERE     score < 20;
SELECT COUNT(*) FROM tags WHERE id < 15 AND count <= 20;
SELECT tags.excerptpostid, tags.wikipostid FROM tags WHERE tags.tagname = 'sample'; 
SELECT users.reputation, SUM(CASE WHEN votes.votetypeid = 2 THEN 1 ELSE 0 END) AS upvote_number FROM comments JOIN users ON comments.userid = users.id JOIN votes ON comments.postid = votes.postid AND comments.userid = votes.userid WHERE comments.text = 'fine, you win :)';
SELECT comments.text FROM     comments JOIN     posts ON comments.postid = posts.id WHERE     posts.title = 'How can I adapt ANOVA for binary data?';
SELECT MAX(comments.text) FROM     comments JOIN     posts ON comments.postid = posts.id WHERE     posts.viewcount BETWEEN 100 AND 150;
SELECT users.creationdate, users.age FROM comments JOIN users ON comments.userid = users.id WHERE comments.text LIKE '%http://%' 
SELECT COUNT(DISTINCT posts.id) FROM     comments JOIN     posts ON comments.postid = posts.id WHERE     comments.score = 0 AND     posts.viewcount < 5;
SELECT COUNT(comments.id) AS "Number of Comments with 0 Score" FROM     posts JOIN     comments ON posts.id = comments.postid WHERE     posts.commentcount = 1 AND     comments.score = 0;
SELECT COUNT(DISTINCT u.id) FROM     users u JOIN     comments c ON u.id = c.userid WHERE     c.score = 0 AND     u.age = 40;
SELECT posts.id AS "Post ID", comments.text AS "Comment" FROM posts JOIN comments ON posts.id = comments.postid WHERE posts.title = 'Group differences on a five point Likert item';
SELECT SUM(votes.votetypeid = 2) AS upvote_number FROM comments JOIN votes ON comments.postid = votes.postid JOIN users ON comments.userid = users.id WHERE comments.text = "R is also lazy evaluated."
SELECT comments.text FROM comments JOIN users ON comments.userid = users.id WHERE users.displayname = 'Harvey Motulsky';
SELECT users.displayname FROM comments JOIN users ON comments.userid = users.id WHERE comments.score BETWEEN 1 AND 5 AND comments.downvotes = 0;
SELECT COUNT(DISTINCT comments.userid) * 100.0 / COUNT(comments.userid) AS percentage FROM comments JOIN votes ON comments.userid = votes.userid WHERE comments.score BETWEEN 5 AND 10 AND votes.votetypeid = 2 AND votes.bountyamount = 0;
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = '3-D Man';
SELECT COUNT(DISTINCT superhero.id) FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Super Strength';
SELECT COUNT(DISTINCT superhero.id) FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Super Strength' AND superhero.height_cm > 200;
SELECT superhero.full_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id GROUP BY superhero.full_name HAVING COUNT(*) > 15; 
SELECT COUNT(*) AS blue_eyed_superheroes FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE colour.colour = 'Blue';
SELECT colour.colour FROM superhero INNER JOIN colour ON superhero.skin_colour_id = colour.id WHERE superhero.superhero_name = 'Apocalypse';
SELECT COUNT(DISTINCT superhero.id) AS count_of_superheroes_with_agility FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE colour.colour = 'Blue' AND superpower.power_name = 'Agility';
SELECT superhero.superhero_name FROM superhero JOIN colour AS eye_color_table ON superhero.eye_colour_id = eye_color_table.id JOIN colour AS hair_color_table ON superhero.hair_colour_id = hair_color_table.id WHERE eye_color_table.colour = 'Blue' AND hair_color_table.colour = 'Blond'; 
SELECT COUNT(superhero.id) FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Marvel Comics';
SELECT superhero.full_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Marvel Comics' ORDER BY superhero.height_cm DESC LIMIT 1;
SELECT publisher.publisher_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.superhero_name = 'Sauron'; 
SELECT COUNT(superhero.id) FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Marvel Comics' AND colour.colour = 'Blue';
SELECT AVG(superhero.height_cm) AS average_height FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Marvel Comics';
SELECT 100.0 * (     SELECT COUNT(*)      FROM superhero      WHERE publisher_id = (         SELECT id          FROM publisher          WHERE publisher_name = 'Marvel Comics'     )     AND id IN (         SELECT hero_id          FROM hero_power          WHERE power_id = (             SELECT id              FROM superpower              WHERE power_name = 'Super Strength'         )     ) ) / (     SELECT COUNT(*)      FROM superhero      WHERE publisher_id = (         SELECT id          FROM publisher          WHERE publisher_name = 'Marvel Comics'     ) ) AS percentage_super_strength;
SELECT COUNT(superhero.id) FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'DC Comics';
SELECT publisher.publisher_name FROM publisher JOIN superhero ON publisher.id = superhero.publisher_id JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Speed' AND hero_attribute.attribute_value = (     SELECT MIN(attribute_value)     FROM hero_attribute     WHERE attribute_id = (         SELECT id         FROM attribute         WHERE attribute_name = 'Speed'     ) )
SELECT COUNT(superhero.id) FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE colour.colour = 'Gold' AND publisher.publisher_name = 'Marvel Comics';
SELECT publisher.publisher_name FROM superhero INNER JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.superhero_name = 'Blue Beetle II';
SELECT COUNT(superhero.id) FROM superhero JOIN colour ON superhero.hair_colour_id = colour.id WHERE colour.colour = 'Blond';
SELECT superhero.superhero_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Intelligence' ORDER BY hero_attribute.attribute_value LIMIT 1;
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.superhero_name = 'Copycat';
SELECT COUNT(DISTINCT superhero.id) FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Durability' AND hero_attribute.attribute_value < 50;
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Death Touch';
SELECT COUNT(DISTINCT superhero.id) FROM superhero JOIN gender ON superhero.gender_id = gender.id JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE gender.gender = 'Female' AND attribute.attribute_name = 'Strength' AND hero_attribute.attribute_value = 100;
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id GROUP BY superhero.id ORDER BY COUNT(hero_power.power_id) DESC LIMIT 1;
SELECT COUNT(superhero.id) FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Vampire';
SELECT 100.0 * (     SELECT        COUNT(DISTINCT superhero.id)     FROM         superhero     INNER JOIN         alignment ON superhero.alignment_id = alignment.id     WHERE         alignment.alignment = 'Bad' ) / (     SELECT        COUNT(DISTINCT superhero.id)     FROM         superhero ) as percentage_bad_superheroes_published_by_marvel_comics
SELECT ABS(   (SELECT COUNT(*) FROM superhero WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'Marvel Comics')) -   (SELECT COUNT(*) FROM superhero WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'DC Comics')) ) AS superhero_difference 
SELECT publisher.id FROM publisher WHERE publisher.publisher_name = 'Star Trek';
SELECT AVG(attribute_value) FROM hero_attribute;
SELECT COUNT(*) FROM superhero WHERE full_name IS NULL;
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.id = 75;
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Deathlok';
SELECT AVG(weight_kg) AS average_weight FROM superhero WHERE gender_id = 2;
SELECT power_name FROM superpower JOIN hero_power ON superpower.id = hero_power.power_id JOIN superhero ON hero_power.hero_id = superhero.id JOIN gender ON superhero.gender_id = gender.id WHERE gender.gender = 'Male' LIMIT 5; 
SELECT superhero.superhero_name FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Alien';
SELECT superhero.superhero_name FROM superhero LEFT JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.height_cm BETWEEN 170 AND 190 AND colour.id IS NULL;
SELECT superpower.power_name FROM superpower INNER JOIN hero_power ON superpower.id = hero_power.power_id WHERE hero_power.hero_id = 56;
SELECT superhero.full_name FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Demi-God';
SELECT COUNT(superhero.id) FROM superhero JOIN alignment ON superhero.alignment_id = alignment.id WHERE alignment.alignment = 'Bad';
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.weight_kg = 169;
SELECT colour.colour FROM superhero JOIN colour ON superhero.hair_colour_id = colour.id JOIN race ON superhero.race_id = race.id WHERE superhero.height_cm = 185 AND race.race = 'Human';
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.weight_kg = (     SELECT MAX(weight_kg)     FROM superhero );
SELECT (SELECT (COUNT(superhero.id) * 100.0 / (SELECT COUNT(*) FROM superhero WHERE height_cm BETWEEN 150 AND 180)) AS percentage_published_by_marvel FROM superhero INNER JOIN publisher ON superhero.publisher_id = publisher.id WHERE height_cm BETWEEN 150 AND 180 AND publisher.id = 13) 
SELECT superhero.full_name FROM superhero JOIN gender ON superhero.gender_id = gender.id WHERE gender.gender = 'Male' AND superhero.weight_kg > 0.79 * (SELECT AVG(weight_kg) FROM superhero);
SELECT power_name, COUNT(*) AS power_count FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id GROUP BY power_name ORDER BY power_count DESC LIMIT 1;
SELECT attribute.attribute_name, hero_attribute.attribute_value FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE superhero.superhero_name = 'Abomination';
SELECT superpower.power_name FROM hero_power INNER JOIN superpower ON hero_power.power_id = superpower.id WHERE hero_power.hero_id = 1;
SELECT COUNT(DISTINCT superhero.id) FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Stealth';
SELECT superhero.full_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Strength' ORDER BY hero_attribute.attribute_value DESC LIMIT 1;
SELECT AVG(CASE WHEN superhero.skin_colour_id = 1 THEN 1 ELSE 0 END) FROM superhero;
SELECT COUNT(superhero.id) FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Dark Horse Comics';
SELECT superhero.superhero_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE publisher.publisher_name = 'Dark Horse Comics' AND attribute.attribute_name = 'Durability' AND hero_attribute.attribute_value = (     SELECT MAX(attribute_value)     FROM hero_attribute     JOIN attribute ON hero_attribute.attribute_id = attribute.id     WHERE attribute.attribute_name = 'Durability' ) 
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.full_name = 'Abraham Sapien';
SELECT superhero.superhero_name FROM superhero INNER JOIN hero_power ON superhero.id = hero_power.hero_id INNER JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Flight';
SELECT colour.colour AS eye_colour, hair.colour AS hair_colour, skin.colour AS skin_colour FROM superhero INNER JOIN colour AS eye ON superhero.eye_colour_id = eye.id INNER JOIN colour AS hair ON superhero.hair_colour_id = hair.id INNER JOIN colour AS skin ON superhero.skin_colour_id = skin.id INNER JOIN gender ON superhero.gender_id = gender.id INNER JOIN publisher ON superhero.publisher_id = publisher.id WHERE gender.gender = 'Female' AND publisher.publisher_name = 'Dark Horse Comics';
SELECT superhero.superhero_name, publisher.publisher_name FROM superhero INNER JOIN colour AS hair_color ON superhero.hair_colour_id = hair_color.id INNER JOIN colour AS skin_color ON superhero.skin_colour_id = skin_color.id INNER JOIN colour AS eye_color ON superhero.eye_colour_id = eye_color.id INNER JOIN publisher ON superhero.publisher_id = publisher.id WHERE hair_color.colour = skin_color.colour AND hair_color.colour = eye_color.colour;
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.superhero_name = 'A-Bomb';
SELECT 100.0 * (     SELECT         CAST(COUNT(*) AS REAL) / (             SELECT                 COUNT(*)              FROM                  superhero              WHERE                  gender_id = (                     SELECT                         id                      FROM                          gender                      WHERE                          gender = 'Female'                 )         )     FROM          superhero      WHERE          skin_colour_id = (             SELECT                 id              FROM                  colour              WHERE                  colour = 'Blue'         )          AND gender_id = (             SELECT                 id              FROM                  gender              WHERE                  gender = 'Female'         ) );
SELECT superhero.superhero_name, race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.full_name = 'Charles Chandler';
SELECT gender.gender FROM superhero JOIN gender ON superhero.gender_id = gender.id WHERE superhero.superhero_name = 'Agent 13';
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Adaptation';
SELECT COUNT(hero_power.power_id) FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id WHERE superhero.superhero_name = 'Amazo';
SELECT hero_power.power_id FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id WHERE superhero.full_name = 'Hunter Zolomon';
SELECT superhero.height_cm FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE colour.colour = 'Amber';
SELECT superhero.superhero_name FROM superhero JOIN colour AS eye_colour ON superhero.eye_colour_id = eye_colour.id JOIN colour AS hair_colour ON superhero.hair_colour_id = hair_colour.id WHERE eye_colour.colour = 'Black' AND hair_colour.colour = 'Black';
SELECT colour.colour AS eye_colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.skin_colour_id = (     SELECT id FROM colour WHERE colour = 'Gold' );
SELECT superhero.full_name FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Vampire'; 
SELECT superhero.superhero_name FROM superhero JOIN alignment ON superhero.alignment_id = alignment.id WHERE alignment.alignment = 'Neutral';
SELECT COUNT(DISTINCT superhero.id) FROM     superhero JOIN     hero_attribute ON superhero.id = hero_attribute.hero_id JOIN     attribute ON hero_attribute.attribute_id = attribute.id WHERE     attribute.attribute_name = 'Strength'     AND hero_attribute.attribute_value = (SELECT MAX(attribute_value) FROM hero_attribute WHERE attribute_id = (SELECT id FROM attribute WHERE attribute_name = 'Strength'));
SELECT race.race, alignment.alignment FROM superhero JOIN race ON superhero.race_id = race.id JOIN alignment ON superhero.alignment_id = alignment.id WHERE superhero.superhero_name = 'Cameron Hicks';
SELECT 100 * (     SELECT COUNT(*)      FROM superhero      WHERE gender_id = (SELECT id FROM gender WHERE gender = 'Female')      AND publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'Marvel Comics') ) / (     SELECT COUNT(*)      FROM superhero      WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'Marvel Comics') );
SELECT AVG(superhero.weight_kg) FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Alien';
SELECT ABS((     SELECT SUM(weight_kg)      FROM superhero      WHERE full_name = 'Emil Blonsky' ) - (     SELECT SUM(weight_kg)      FROM superhero      WHERE full_name = 'Charles Chandler' )) AS weight_difference; 
SELECT AVG(height_cm) AS average_height, superhero_id FROM superhero GROUP BY superhero_id;
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Abomination';
SELECT COUNT(superhero.id) FROM superhero WHERE superhero.race_id = 21 AND superhero.gender_id = 1;
SELECT superhero.superhero_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Speed' ORDER BY hero_attribute.attribute_value DESC LIMIT 1;
SELECT COUNT(*) FROM superhero WHERE alignment_id = 3;
SELECT attribute.attribute_name, hero_attribute.attribute_value FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE superhero.superhero_name = '3-D Man';
SELECT superhero.superhero_name FROM superhero JOIN colour AS eye_colour ON superhero.eye_colour_id = eye_colour.id JOIN colour AS hair_colour ON superhero.hair_colour_id = hair_colour.id WHERE eye_colour.colour = 'Blue' AND hair_colour.colour = 'Brown';
SELECT publisher.publisher_name FROM publisher JOIN superhero ON superhero.publisher_id = publisher.id WHERE superhero.superhero_name IN ('Hawkman', 'Karate Kid', 'Speedy');
SELECT COUNT(*) AS num_superheroes_without_publisher FROM superhero WHERE publisher_id = 1;
SELECT ROUND((COUNT(superhero.superhero_name) * 100.0) / (SELECT COUNT(*) FROM superhero), 2) FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE colour.colour = 'Blue';
SELECT CAST(SUM(CASE WHEN gender_id = 1 THEN 1 ELSE 0 END) AS FLOAT) / NULLIF(CAST(SUM(CASE WHEN gender_id = 2 THEN 1 ELSE 0 END) AS FLOAT), 0) AS male_to_female_ratio FROM superhero; 
SELECT MAX(superhero.superhero_name) AS tallest_superhero FROM superhero WHERE superhero.height_cm = (SELECT MAX(height_cm) FROM superhero);
SELECT id FROM superpower WHERE power_name = 'Cryokinesis';
SELECT superhero_name FROM superhero WHERE id = 294; 
SELECT superhero.full_name FROM superhero WHERE superhero.weight_kg = 0 OR superhero.weight_kg IS NULL;
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.full_name = 'Karen Beecher-Duncan';
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.full_name = 'Helen Parr';
SELECT race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.weight_kg = 108 AND superhero.height_cm = 188;
SELECT publisher.publisher_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.id = 38;
SELECT race.race FROM (     SELECT        hero_attribute.hero_id,         MAX(hero_attribute.attribute_value) AS max_attribute_value     FROM         hero_attribute     GROUP BY         hero_attribute.hero_id ) AS max_attribute JOIN superhero ON max_attribute.hero_id = superhero.id JOIN race ON superhero.race_id = race.id WHERE     hero_attribute.attribute_value = max_attribute.max_attribute_value;
SELECT alignment.alignment, superpower.power_name FROM superhero JOIN alignment ON superhero.alignment_id = alignment.id JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Atom IV'; 
SELECT superhero.full_name FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE colour.colour = 'Blue';
SELECT AVG(attribute_value) FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN alignment ON superhero.alignment_id = alignment.id WHERE alignment.alignment = 'Neutral';
SELECT colour.colour FROM superhero JOIN colour ON superhero.skin_colour_id = colour.id JOIN hero_attribute ON superhero.id = hero_attribute.hero_id AND hero_attribute.attribute_value = 100;
SELECT COUNT(*) FROM superhero WHERE alignment_id = 1 AND gender_id = 2;
SELECT superhero.superhero_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id WHERE hero_attribute.attribute_value BETWEEN 75 AND 80; 
SELECT race.race FROM superhero JOIN colour ON superhero.hair_colour_id = colour.id JOIN race ON superhero.race_id = race.id JOIN gender ON superhero.gender_id = gender.id WHERE colour.colour = 'Blue' AND gender.gender = 'Male';
SELECT ROUND((COUNT(superhero.id) * 100.0) / (SELECT COUNT(superhero.id) FROM superhero WHERE alignment_id = 2 AND gender_id = 2), 2) AS percentage_female_bad_superheroes FROM superhero WHERE alignment_id = 2 AND gender_id = 2; 
SELECT COUNT(CASE WHEN superhero.weight_kg = 0 OR superhero.weight_kg IS NULL THEN CASE WHEN superhero.eye_colour_id = 7 THEN 1 ELSE 0 END ELSE 0 END) - COUNT(CASE WHEN superhero.eye_colour_id = 1 THEN 1 ELSE 0 END) AS difference FROM superhero;
SELECT MAX(hero_attribute.attribute_value) AS strength FROM hero_attribute JOIN superhero ON hero_attribute.hero_id = superhero.id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE superhero.superhero_name = 'Hulk' AND attribute.attribute_name = 'Strength';
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Ajax';
SELECT COUNT(superhero.id) FROM superhero JOIN colour ON superhero.skin_colour_id = colour.id JOIN alignment ON superhero.alignment_id = alignment.id WHERE colour.colour = 'Green' AND alignment.alignment = 'Bad';
SELECT COUNT(superhero.id) FROM superhero JOIN gender ON superhero.gender_id = gender.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE gender.gender = 'Female' AND publisher.publisher_name = 'Marvel Comics';
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Wind Control' ORDER BY superhero.superhero_name ASC;
SELECT gender.gender FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id JOIN gender ON superhero.gender_id = gender.id WHERE superpower.power_name = 'Phoenix Force'; 
SELECT MAX(weight_kg) AS heaviest_superhero FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'DC Comics'
SELECT AVG(superhero.height_cm) AS average_height FROM superhero JOIN race ON superhero.race_id = race.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE race.race <> 'Human' AND publisher.publisher_name = 'Dark Horse Comics';
SELECT COUNT(superhero.id) FROM superhero INNER JOIN hero_attribute ON superhero.id = hero_attribute.hero_id INNER JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Speed' AND hero_attribute.attribute_value = 100;
SELECT SUM(CASE WHEN publisher_name = 'DC Comics' THEN 1 ELSE 0 END) - SUM(CASE WHEN publisher_name = 'Marvel Comics' THEN 1 ELSE 0 END) AS difference FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id;
SELECT attribute.attribute_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE superhero.superhero_name = 'Black Panther' ORDER BY hero_attribute.attribute_value ASC LIMIT 1; 
SELECT colour.colour FROM superhero INNER JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.superhero_name = 'Abomination';
SELECT superhero.superhero_name FROM superhero WHERE superhero.height_cm = (     SELECT        MAX(height_cm)     FROM         superhero );
SELECT superhero.superhero_name FROM superhero WHERE superhero.full_name = 'Charles Chandler';
SELECT 100.0 * SUM(CASE WHEN gender.gender = 'Female' THEN 1 ELSE 0 END) / COUNT(*) FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id JOIN gender ON superhero.gender_id = gender.id WHERE publisher.publisher_name = 'George Lucas';
SELECT ROUND((COUNT(superhero.id) * 1.0 / (SELECT COUNT(superhero.id) FROM superhero INNER JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Marvel Comics')) * 100.0, 2) AS percentage_of_good_superheroes FROM superhero INNER JOIN publisher ON superhero.publisher_id = publisher.id INNER JOIN alignment ON superhero.alignment_id = alignment.id WHERE publisher.publisher_name = 'Marvel Comics' AND alignment.alignment = 'Good';
SELECT COUNT(superhero.id) FROM superhero WHERE full_name LIKE 'John%'
SELECT MIN(hero_attribute.attribute_value) AS min_attribute_value FROM hero_attribute;
SELECT superhero.full_name FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Alien'; 
SELECT superhero.full_name FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.weight_kg < 100 AND colour.colour = 'Brown';
SELECT attribute_value FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE superhero.superhero_name = 'Aquababy';
SELECT weight_kg, race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.id = 40;
SELECT AVG(height_cm) FROM superhero JOIN alignment ON superhero.alignment_id = alignment.id WHERE alignment.alignment = 'Neutral'; 
SELECT hero_id FROM hero_power JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Intelligence';
SELECT colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.superhero_name = 'Blackwulf';
SELECT DISTINCT superpower.power_name FROM     superhero JOIN     hero_power ON superhero.id = hero_power.hero_id JOIN     superpower ON hero_power.power_id = superpower.id WHERE     superhero.height_cm > (         SELECT            AVG(height_cm) * 0.8         FROM             superhero     );
SELECT drivers.driverref FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid WHERE qualifying.raceid = 18 ORDER BY qualifying.q1 DESC LIMIT 5; 
SELECT drivers.surname FROM     drivers JOIN     laptimes ON drivers.driverid = laptimes.driverid JOIN     races ON laptimes.raceid = races.raceid JOIN     qualifying ON qualifying.raceid = races.raceid WHERE     races.raceid = 19     AND qualifying.q2 = (SELECT MIN(q2) FROM qualifying WHERE raceid = 19)
SELECT DISTINCT races.year FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.location = 'Shanghai'; 
SELECT races.name, races.date, races.time, races.url FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Circuit de Barcelona-Catalunya'; 
SELECT races.name FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.country = 'Germany';
SELECT positions FROM circuits INNER JOIN races ON circuits.circuitid = races.circuitid INNER JOIN constructorresults ON races.raceid = constructorresults.raceid INNER JOIN constructors ON constructorresults.constructorid = constructors.constructorid WHERE constructors.name = 'Renault'
SELECT COUNT(races.raceid) AS races_outside_asia_europe FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE races.year = 2010 AND circuits.country NOT IN ('Asia', 'Europe');
SELECT races.name FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.country = 'Spain';
SELECT `circuits.lat`, `circuits.lng` FROM `circuits` JOIN `races` ON `races.circuitid` = `circuits.circuitid` WHERE `races.name` = 'Australian Grand Prix';
SELECT races.name, races.date, races.time, circuits.location, circuits.country, races.url FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Sepang International Circuit';
SELECT races.time FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Sepang International Circuit'; 
SELECT circuits.lat, circuits.lng FROM circuits JOIN races ON circuits.circuitid = races.circuitid WHERE races.name = 'Abu Dhabi Grand Prix';
SELECT country FROM     races JOIN     constructorresults ON races.raceid = constructorresults.raceid JOIN     constructors ON constructorresults.constructorid = constructors.constructorid WHERE     races.raceid = 24     AND constructorresults.points = 1;
SELECT q1 FROM     qualifying WHERE     driverid = (         SELECT            driverid         FROM             drivers         WHERE             forename = 'Bruno'             AND surname = 'Senna'     )     AND raceid = 354;
SELECT drivers.nationality FROM     drivers JOIN     qualifying ON drivers.driverid = qualifying.driverid WHERE     qualifying.q2 = '0:01:40'     AND qualifying.raceid = 355;
SELECT drivers.number FROM     drivers JOIN     qualifying ON drivers.driverid = qualifying.driverid WHERE     qualifying.raceid = 903     AND qualifying.q3 = '0:01:54';
SELECT COUNT(*) AS "Drivers_Not_Finished" FROM     results WHERE     raceid = (         SELECT raceid         FROM races         WHERE name = 'Bahrain Grand Prix'         AND year = 2007     )     AND (time IS NULL OR time = '');
SELECT seasons.url FROM races JOIN seasons ON races.year = seasons.year WHERE races.raceid = 901;
SELECT COUNT(DISTINCT results.driverid) FROM results JOIN races ON results.raceid = races.raceid WHERE races.date = '2015-11-29' AND results.time IS NOT NULL;
SELECT drivers.forename, drivers.surname, drivers.dob FROM results JOIN drivers ON results.driverid = drivers.driverid WHERE results.raceid = 592 AND results.time IS NOT NULL ORDER BY drivers.dob ASC LIMIT 1;
SELECT drivers.forename || ' ' || drivers.surname AS player_name, drivers.url AS introduction_website FROM laptimes JOIN races ON laptimes.raceid = races.raceid JOIN drivers ON laptimes.driverid = drivers.driverid WHERE races.raceid = 161 AND laptimes.time = '0:01:27';
SELECT drivers.nationality FROM     drivers JOIN     results ON results.driverid = drivers.driverid JOIN     races ON results.raceid = races.raceid WHERE     races.raceid = 933 ORDER BY     results.fastestlapspeed DESC LIMIT 1;
SELECT circuits.location, circuits.lat, circuits.lng FROM circuits JOIN races ON circuits.circuitid = races.circuitid WHERE races.name = 'Malaysian Grand Prix';
SELECT constructors.url FROM constructorstandings JOIN constructors ON constructorstandings.constructorid = constructors.constructorid WHERE constructorstandings.raceid = 9 ORDER BY constructorstandings.points DESC LIMIT 1;
SELECT q1 FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid JOIN races ON qualifying.raceid = races.raceid WHERE drivers.forename = 'Lucas' AND drivers.surname = 'di Grassi' AND races.raceid = 345; 
SELECT drivers.nationality FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid WHERE qualifying.q2 = '0:01:15' AND qualifying.raceid = 347;
SELECT drivers.code FROM qualifying JOIN races ON qualifying.raceid = races.raceid JOIN drivers ON qualifying.driverid = drivers.driverid WHERE races.raceid = 45 AND qualifying.q3 = '0:01:33';
SELECT time FROM     results WHERE     raceid = 743     AND     driverid = (SELECT driverid FROM drivers WHERE forename = 'Bruce' AND surname = 'McLaren');
SELECT results.positiontext, drivers.forename, drivers.surname FROM     results JOIN     races ON results.raceid = races.raceid JOIN     drivers ON results.driverid = drivers.driverid WHERE     races.name = 'San Marino Grand Prix' AND races.year = 2006 AND results.position = 2;
SELECT seasons.url FROM races JOIN seasons ON races.year = seasons.year WHERE races.raceid = 901;
SELECT COUNT(results.position) AS finished_drivers FROM races JOIN results ON races.raceid = results.raceid WHERE races.date = '2015-11-29' AND results.statusid = (SELECT statusid FROM status WHERE status = 'Finished');
SELECT drivers.forename, drivers.surname, MAX(drivers.dob) AS youngest_driver_dob FROM results JOIN drivers ON results.driverid = drivers.driverid WHERE results.raceid = 872 AND results.time IS NOT NULL;
SELECT drivers.forename || ' ' || drivers.surname AS best_lap_driver FROM results JOIN drivers ON results.driverid = drivers.driverid WHERE results.raceid = 348 AND results.time = (     SELECT MIN(time)      FROM results      WHERE raceid = 348 )
SELECT drivers.nationality FROM results JOIN drivers ON results.driverid = drivers.driverid WHERE results.raceid = 348 AND results.fastestlapspeed = (     SELECT MAX(fastestlapspeed)     FROM results     WHERE raceid = 348 ) 
SELECT 100 * (1 - (     SELECT fastestlapspeed     FROM results     WHERE raceid = 854 ) / (     SELECT fastestlapspeed     FROM results     WHERE raceid = 853 )) as percentage 
SELECT COUNT(DISTINCT results.driverid) * 100.0 / (SELECT COUNT(DISTINCT driverid) FROM results WHERE raceid IN (SELECT raceid FROM races WHERE date = '1983-07-16')) AS percentage
SELECT MIN(year) FROM races WHERE name = 'Singapore Grand Prix';
SELECT COUNT(races.raceid) AS race_count, races.name FROM races WHERE races.year = 2005 ORDER BY races.name DESC;
SELECT races.name FROM races WHERE strftime('%Y-%m', races.date) = (     SELECT strftime('%Y-%m', MIN(date))     FROM races ) ORDER BY races.date;
SELECT races.name, races.date FROM races JOIN seasons ON races.year = seasons.year WHERE races.year = 1999 AND races.round = (     SELECT MAX(round) FROM races WHERE year = 1999 );
SELECT year, COUNT(*) AS num_races FROM races GROUP BY year ORDER BY num_races DESC LIMIT 1; 
SELECT races.name FROM races JOIN seasons ON races.year = seasons.year WHERE races.year = 2017 AND races.year != 2000;
SELECT circuits.country, circuits.name, circuits.location FROM   circuits JOIN   races ON circuits.circuitid = races.circuitid WHERE   races.name = 'European Grand Prix' AND   races.year = (SELECT MIN(year) FROM races WHERE name = 'European Grand Prix');
SELECT MAX(year) FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Brands Hatch' AND races.name = 'British Grand Prix';
SELECT COUNT(DISTINCT seasons.year) FROM circuits JOIN races ON circuits.circuitid = races.circuitid JOIN seasons ON races.year = seasons.year WHERE circuits.name = 'Silverstone Circuit' AND races.name LIKE '%British Grand Prix%';
SELECT drivers.forename, drivers.surname FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE races.name = 'Singapore Grand Prix' AND races.year = 2010 ORDER BY driverstandings.position ASC; 
SELECT drivers.forename || ' ' || drivers.surname AS full_name FROM     driverstandings JOIN     drivers ON driverstandings.driverid = drivers.driverid WHERE     driverstandings.points = (SELECT MAX(points) FROM driverstandings);
SELECT drivers.forename || ' ' || drivers.surname AS driver_name, SUM(driverstandings.points) AS total_points FROM driverstandings JOIN races ON driverstandings.raceid = races.raceid JOIN drivers ON driverstandings.driverid = drivers.driverid JOIN seasons ON races.year = seasons.year WHERE races.name = 'Chinese Grand Prix' AND seasons.year = 2017 GROUP BY drivers.driverid ORDER BY total_points DESC LIMIT 3;
SELECT MIN(laptimes.time) AS best_lap_time, drivers.forename AS driver_forename, drivers.surname AS driver_surname, races.name AS race_name FROM laptimes INNER JOIN drivers ON laptimes.driverid = drivers.driverid INNER JOIN races ON laptimes.raceid = races.raceid GROUP BY laptimes.time ORDER BY best_lap_time LIMIT 1;
SELECT AVG(laptimes.time) AS average_lap_time FROM     laptimes JOIN     drivers ON laptimes.driverid = drivers.driverid JOIN     races ON laptimes.raceid = races.raceid WHERE     drivers.forename = 'Sebastian' AND     drivers.surname = 'Vettel' AND     races.year = 2009 AND     races.name = 'Chinese Grand Prix';
SELECT ROUND(     (1.0 * (         SELECT COUNT(raceid)          FROM results          JOIN drivers ON results.driverid = drivers.driverid          JOIN races ON results.raceid = races.raceid          JOIN circuits ON races.circuitid = circuits.circuitid          WHERE surname = 'Hamilton'          AND year >= 2010          AND position > 1     )) / (         SELECT COUNT(raceid)          FROM results          JOIN drivers ON results.driverid = drivers.driverid          WHERE surname = 'Hamilton'          AND year >= 2010     ) * 100, 2 ) AS percentage; 
SELECT drivers.forename || ' ' || drivers.surname AS driver_name, drivers.nationality, AVG(driverstandings.points) AS average_points FROM driverstandings JOIN drivers ON driverstandings.driverid = drivers.driverid GROUP BY drivers.forename, drivers.surname, drivers.nationality ORDER BY COUNT(driverstandings.wins) DESC LIMIT 1;
SELECT MIN(2022 - strftime('%Y', dob) + 1) AS age, forename || ' ' || surname AS name FROM drivers WHERE nationality = 'Japanese'
SELECT circuits.name FROM circuits JOIN races ON circuits.circuitid = races.circuitid JOIN seasons ON races.year = seasons.year GROUP BY circuits.circuitid HAVING COUNT(DISTINCT races.raceid) = 4 AND seasons.year BETWEEN 1990 AND 2000; 
SELECT circuits.name AS circuit_name, circuits.location AS circuit_location, races.name AS race_name FROM circuits JOIN races ON circuits.circuitid = races.circuitid JOIN seasons ON races.year = seasons.year WHERE seasons.year = 2006 AND circuits.country = 'USA'; 
SELECT races.name AS race_name, circuits.name AS circuit_name, circuits.location AS circuit_location FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE strftime('%m', races.date) = '09' AND races.year = 2005;
SELECT races.name FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Alex' AND drivers.surname = 'Yoong' AND results.position < 10;
SELECT COUNT(*) AS "Number of Wins" FROM     results JOIN     races ON results.raceid = races.raceid JOIN     circuits ON races.circuitid = circuits.circuitid JOIN     drivers ON results.driverid = drivers.driverid WHERE     drivers.forename = 'Michael' AND drivers.surname = 'Schumacher'     AND circuits.name = 'Sepang International Circuit'     AND results.position = 1;
SELECT races.name, races.year FROM     results JOIN     races ON results.raceid = races.raceid JOIN     drivers ON results.driverid = drivers.driverid WHERE     drivers.forename = 'Michael' AND drivers.surname = 'Schumacher' ORDER BY     results.milliseconds ASC LIMIT 1;
SELECT AVG(results.points) AS average_points FROM     results JOIN     drivers ON results.driverid = drivers.driverid JOIN     races ON results.raceid = races.raceid WHERE     drivers.forename = 'Eddie' AND drivers.surname = 'Irvine'     AND races.year = 2000;
SELECT MIN(races.year) AS first_race_year, results.points AS points_recorded FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton';
SELECT races.name, circuits.country FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE races.year = 2017 ORDER BY races.date; 
SELECT races.name AS race_name, races.year, circuits.location AS circuit_location FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE races.laps = (SELECT MAX(laps) FROM races); 
SELECT (CAST((COUNT(CASE WHEN races.country = 'Germany' AND races.name = 'European Grand Prix' THEN 1 END) * 100.0) / COUNT(CASE WHEN races.name = 'European Grand Prix' THEN 1 END) AS DECIMAL(5,2))) AS percentage FROM races;
SELECT `lat`, `lng` FROM circuits WHERE circuitref = 'silverstone';
SELECT MAX(lat) AS max_latitude FROM circuits WHERE circuitref IN ('silverstone', 'hockenheimring', 'hungaroring');
SELECT circuitref FROM circuits WHERE name = 'Marina Bay Street Circuit';
SELECT country FROM circuits WHERE alt = (     SELECT MAX(alt)      FROM circuits )
SELECT COUNT(*) FROM drivers WHERE code IS NULL;
SELECT MIN(drivers.dob) as oldest_dob, drivers.nationality as oldest_driver_country FROM drivers;
SELECT surname FROM drivers WHERE nationality = 'Italian';
SELECT drivers.url FROM     drivers WHERE     drivers.forename = 'Anthony' AND drivers.surname = 'Davidson';
SELECT driverref FROM drivers WHERE forename = 'Lewis' AND surname = 'Hamilton';
SELECT circuits.name FROM   circuits JOIN   races ON races.circuitid = circuits.circuitid JOIN   seasons ON races.year = seasons.year WHERE   races.name = 'Spanish Grand Prix' AND seasons.year = 2009;
SELECT DISTINCT races.year FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Silverstone Circuit'; 
SELECT races.name, races.date, races.time, races.url FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Silverstone Circuit';
SELECT races.time FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE circuits.name = 'Abu Dhabi Grand Prix' AND seasons.year BETWEEN 2010 AND 2019; 
SELECT COUNT(*) AS num_races FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.country = 'Italy';
SELECT races.date FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Circuit de Barcelona-Catalunya'; 
SELECT circuits.url FROM     circuits JOIN     races ON circuits.circuitid = races.circuitid JOIN     seasons ON races.year = seasons.year WHERE     races.name = 'Spanish Grand Prix'     AND seasons.year = 2009;
SELECT MIN(results.fastestlaptime) AS fastest_lap_time FROM results JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton';
SELECT drivers.forename, drivers.surname FROM results JOIN drivers ON results.driverid = drivers.driverid WHERE fastestlapspeed = (     SELECT MAX(fastestlapspeed)     FROM results     WHERE fastestlapspeed <> 0 );
SELECT drivers.driverref FROM     races     JOIN results ON races.raceid = results.raceid     JOIN drivers ON results.driverid = drivers.driverid WHERE     races.name = 'Australian Grand Prix'     AND races.year = 2008     AND results.position = 1;
SELECT races.name FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton';
SELECT races.name AS race_name FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' ORDER BY results.positionorder ASC LIMIT 1;
SELECT MAX(results.fastestlapspeed) AS fastest_lap_speed FROM     results JOIN races ON results.raceid = races.raceid WHERE     races.name = 'Spanish Grand Prix'     AND races.year = 2009;
SELECT DISTINCT races.year FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton';
SELECT results.positionorder FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND races.name = 'Australian Grand Prix' AND races.year = 2008;
SELECT drivers.forename, drivers.surname FROM     results JOIN     drivers ON results.driverid = drivers.driverid JOIN     races ON results.raceid = races.raceid WHERE     races.name = 'Australian Grand Prix' AND races.year = 2008 AND results.grid = 4;
SELECT COUNT(DISTINCT results.driverid) FROM results JOIN races ON results.raceid = races.raceid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND results.time IS NOT NULL;
SELECT laptimes.time FROM laptimes JOIN races ON laptimes.raceid = races.raceid JOIN drivers ON laptimes.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND races.name = 'Australian Grand Prix' AND races.year = 2008 ORDER BY laptimes.milliseconds ASC LIMIT 1;
SELECT time FROM     results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE     races.name = 'Australian Grand Prix'     AND races.year = 2008     AND results.positionorder = 2;
SELECT drivers.forename || ' ' || drivers.surname AS champion, circuits.name AS circuit_name, races.date AS race_date, results.time AS finish_time, drivers.url AS champion_url FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid JOIN circuits ON races.circuitid = circuits.circuitid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND results.position = 1;
SELECT COUNT(DISTINCT drivers.driverid) AS usa_drivers_count FROM     drivers JOIN     results ON drivers.driverid = results.driverid JOIN     races ON results.raceid = races.raceid WHERE     races.year = 2008     AND races.name = 'Australian Grand Prix'     AND drivers.nationality = 'American';
SELECT COUNT(DISTINCT drivers.driverid) FROM     drivers JOIN     results ON drivers.driverid = results.driverid JOIN     races ON results.raceid = races.raceid WHERE     races.name = 'Australian Grand Prix'     AND races.year = 2008     AND results.time IS NOT NULL;
SELECT SUM(results.points) AS total_points FROM     results JOIN     drivers ON results.driverid = drivers.driverid WHERE     drivers.forename = 'Lewis'     AND drivers.surname = 'Hamilton';
SELECT AVG(SUBSTR(results.fastestlaptime, 1, 2) * 60 + SUBSTR(results.fastestlaptime, 4, 2) + SUBSTR(results.fastestlaptime, 7) / 1000) FROM     drivers JOIN     results ON drivers.driverid = results.driverid WHERE     drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton';
SELECT COUNT(results.raceid) * 1.0 / COUNT(races.raceid) FROM results JOIN races ON results.raceid = races.raceid WHERE races.year = 2008 AND races.name = 'Australian Grand Prix' AND results.time IS NOT NULL;
SELECT ((MAX(results.time) - (SELECT MIN(results.time) FROM results JOIN races ON results.raceid = races.raceid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND results.positionorder = (SELECT MAX(results.positionorder) FROM results JOIN races ON results.raceid = races.raceid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008))) / (SELECT MIN(results.time) FROM results JOIN races ON results.raceid = races.raceid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND results.positionorder = (SELECT MAX(results.positionorder) FROM results JOIN races ON results.raceid = races.raceid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008))) * 100 AS percentage_faster_than_last FROM results JOIN races ON results.raceid = races.raceid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND results.positionorder = 1;
SELECT COUNT(*) FROM circuits WHERE location = 'Melbourne' AND country = 'Australia';
SELECT circuits.lat, circuits.lng FROM circuits WHERE circuits.country = 'USA'; 
SELECT COUNT(*) FROM drivers WHERE nationality = 'British' AND strftime('%Y', dob) > '1980';
SELECT AVG(constructorstandings.points) AS average_points FROM constructorstandings JOIN constructors ON constructorstandings.constructorid = constructors.constructorid WHERE constructors.nationality = 'British';
SELECT MAX(points) AS highest_points, constructorid FROM constructorstandings;
SELECT constructors.name FROM constructorstandings INNER JOIN constructors ON constructorstandings.constructorid = constructors.constructorid WHERE constructorstandings.raceid = 291 AND constructorstandings.points = 0 
SELECT COUNT(DISTINCT constructors.constructorid) AS japanese_constructors_with_zero_points FROM constructorstandings JOIN constructors ON constructorstandings.constructorid = constructors.constructorid JOIN races ON constructorstandings.raceid = races.raceid JOIN circuits ON races.circuitid = circuits.circuitid WHERE constructors.nationality = 'Japanese' AND constructorstandings.points = 0 GROUP BY constructors.nationality HAVING COUNT(DISTINCT races.raceid) = 2;
SELECT constructors.name FROM constructorstandings INNER JOIN constructors ON constructorstandings.constructorid = constructors.constructorid WHERE constructorstandings.position = 1 
SELECT COUNT(DISTINCT constructors.constructorid) AS french_constructors_with_lap_over_50 FROM constructors JOIN constructorresults ON constructors.constructorid = constructorresults.constructorid JOIN races ON constructorresults.raceid = races.raceid JOIN circuits ON races.circuitid = circuits.circuitid WHERE constructors.nationality = 'French' AND races.laps > 50;
SELECT ROUND((COUNT(results.driverid) * 1.0 / (SELECT COUNT(driverid) FROM driverstandings WHERE raceid IN (SELECT raceid FROM races WHERE year BETWEEN 2007 AND 2009))) * 100, 2) AS race_completion_percentage FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid JOIN driverstandings ON results.driverid = driverstandings.driverid AND results.raceid = driverstandings.raceid WHERE races.year BETWEEN 2007 AND 2009 AND results.time IS NOT NULL AND drivers.nationality = 'Japanese'; 
SELECT AVG(strftime('%s', results.time)) AS average_time_seconds FROM results JOIN races ON races.raceid = results.raceid JOIN seasons ON seasons.year = races.year WHERE results.position = 1 AND results.time IS NOT NULL GROUP BY seasons.year;
SELECT forename, surname FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid WHERE dob > '1975-01-01' AND position = 2;
SELECT COUNT(DISTINCT drivers.driverid) FROM     drivers JOIN     results ON drivers.driverid = results.driverid JOIN     races ON results.raceid = races.raceid WHERE     drivers.nationality = 'Italian' AND     results.time IS NULL;
SELECT drivers.forename, drivers.surname FROM     drivers INNER JOIN     laptimes ON drivers.driverid = laptimes.driverid INNER JOIN     races ON laptimes.raceid = races.raceid WHERE     laptimes.time = (         SELECT            MIN(time)         FROM             laptimes     );
SELECT MAX(results.fastestlap) FROM     results JOIN     driverstandings ON results.raceid = driverstandings.raceid AND results.driverid = driverstandings.driverid JOIN     races ON results.raceid = races.raceid WHERE     races.year = 2009 AND driverstandings.position = 1;
SELECT AVG(fastestlapspeed) FROM     results JOIN     races ON results.raceid = races.raceid WHERE     races.name = 'Spanish Grand Prix'     AND races.year = 2009;
SELECT races.name, races.year FROM races JOIN results ON races.raceid = results.raceid WHERE results.milliseconds IS NOT NULL ORDER BY results.milliseconds ASC LIMIT 1;
SELECT (CAST(COUNT(CASE WHEN strftime('%Y', drivers.dob) < '1985' AND races.year BETWEEN '2000' AND '2005' AND laptimes.lap > 50 THEN drivers.driverid END) AS REAL) / COUNT(CASE WHEN races.year BETWEEN '2000' AND '2005' THEN drivers.driverid END)) * 100 FROM     drivers JOIN     driverstandings ON drivers.driverid = driverstandings.driverid JOIN     races ON driverstandings.raceid = races.raceid JOIN     laptimes ON drivers.driverid = laptimes.driverid AND races.raceid = laptimes.raceid;
SELECT COUNT(DISTINCT drivers.driverid) FROM drivers JOIN laptimes ON drivers.driverid = laptimes.driverid JOIN races ON laptimes.raceid = races.raceid WHERE laptimes.time < '02:00.00' AND drivers.nationality = 'French';
SELECT drivers.driverid, drivers.driverref, drivers.number, drivers.code, drivers.forename, drivers.surname, drivers.dob, drivers.nationality, drivers.url FROM drivers WHERE drivers.nationality = 'American'; 
SELECT raceid FROM races WHERE year = 2009; 
SELECT COUNT(DISTINCT driverid) AS num_participants FROM results WHERE raceid = 18;
SELECT DISTINCT drivers.driverid, drivers.forename, drivers.surname, drivers.dob, drivers.nationality FROM drivers ORDER BY (2024 - strftime('%Y', drivers.dob)) ASC LIMIT 3;
SELECT `driverref` FROM drivers WHERE forename = 'Robert' AND surname = 'Kubica';
SELECT COUNT(*) FROM drivers WHERE nationality = 'Australian' AND strftime('%Y', dob) = '1980';
SELECT drivers.forename, drivers.surname, MIN(laptimes.time) AS earliest_lap_time FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid JOIN laptimes ON drivers.driverid = laptimes.driverid AND races.raceid = laptimes.raceid WHERE drivers.nationality = 'German' AND drivers.dob BETWEEN '1980-01-01' AND '1990-12-31' GROUP BY drivers.driverid ORDER BY earliest_lap_time LIMIT 3; 
SELECT drivers.driverref FROM     drivers WHERE     drivers.nationality = 'German' AND     drivers.dob = (         SELECT MIN(year(dob))         FROM drivers         WHERE nationality = 'German'     );
SELECT drivers.driverid, drivers.code FROM     drivers JOIN     driverstandings ON drivers.driverid = driverstandings.driverid JOIN     races ON driverstandings.raceid = races.raceid JOIN     results ON drivers.driverid = results.driverid AND races.raceid = results.raceid WHERE     drivers.dob = '1971' AND     results.fastestlaptime IS NOT NULL ORDER BY     results.fastestlaptime ASC;
SELECT drivers.forename, drivers.surname FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON races.raceid = driverstandings.raceid JOIN laptimes ON laptimes.driverid = drivers.driverid AND laptimes.raceid = races.raceid WHERE drivers.nationality = 'Spanish' AND drivers.dob < '1982-01-01' GROUP BY drivers.driverid ORDER BY MAX(laptimes.time) DESC LIMIT 10;
SELECT MAX(races.year) AS "Year with Fastest Lap Time" FROM races JOIN results ON races.raceid = results.raceid WHERE results.fastestlaptime IS NOT NULL;
SELECT MIN(substr(time, 1, 2) || substr(time, 4, 2) || substr(time, 7)) AS "Year with lowest lap time speed" FROM laptimes
SELECT drivers.driverid FROM results JOIN races ON results.raceid = races.raceid JOIN laptimes ON laptimes.raceid = races.raceid AND laptimes.driverid = results.driverid WHERE laptimes.lap = 1 ORDER BY laptimes.time ASC LIMIT 5;
SELECT COUNT(results.resultid) AS disqualified_finishers FROM     results JOIN races ON results.raceid = races.raceid WHERE     results.statusid = 2     AND races.raceid BETWEEN 50 AND 100
SELECT COUNT(circuits.circuitid) AS times_held, circuits.location, circuits.lat, circuits.lng FROM circuits JOIN races ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE circuits.country = 'Austria' GROUP BY circuits.circuitid;
SELECT COUNT(results.resultid) AS finishers_count, races.round AS race_number FROM races JOIN results ON races.raceid = results.raceid WHERE results.time IS NOT NULL GROUP BY races.round ORDER BY finishers_count DESC LIMIT 1;
SELECT drivers.driverref, drivers.nationality, drivers.dob FROM qualifying INNER JOIN drivers ON qualifying.driverid = drivers.driverid WHERE qualifying.raceid = 23 AND qualifying.q2 IS NOT NULL;
SELECT races.year AS year, races.name AS race_name, races.date AS race_date, races.time AS race_time FROM races JOIN qualifying ON races.raceid = qualifying.raceid JOIN drivers ON qualifying.driverid = drivers.driverid WHERE drivers.dob = (SELECT MIN(dob) FROM drivers)
SELECT COUNT(*) AS American_Disqualified FROM     drivers JOIN     results ON drivers.driverid = results.driverid JOIN     status ON results.statusid = status.statusid WHERE     drivers.nationality = 'American'     AND status.statusid = 2;
SELECT constructorref, MAX(points) AS highest_points, constructors.url AS introduction_website FROM constructorresults JOIN constructors ON constructorresults.constructorid = constructors.constructorid WHERE constructors.nationality = 'Italian';
SELECT constructors.name, constructors.url FROM (     SELECT        constructorid,         COUNT(*) AS total_wins     FROM         results     WHERE         positionorder = 1     GROUP BY         constructorid     ORDER BY         total_wins DESC     LIMIT 1 ) AS most_wins_constructor JOIN constructors ON constructors.constructorid = most_wins_constructor.constructorid;
SELECT drivers.forename,     drivers.surname,     laptimes.time FROM     drivers JOIN     races ON laptimes.raceid = races.raceid JOIN     circuits ON races.circuitid = circuits.circuitid JOIN     laptimes ON laptimes.driverid = drivers.driverid WHERE     races.name = 'French Grand Prix'     AND laptimes.lap = 3 ORDER BY     laptimes.time DESC LIMIT     1;
SELECT races.name AS race_name, races.year AS race_year, circuits.name AS circuit_name, MIN(laptimes.milliseconds) AS fastest_lap_time_milliseconds FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN laptimes ON races.raceid = laptimes.raceid AND laptimes.lap = 1 GROUP BY races.name ORDER BY fastest_lap_time_milliseconds ASC LIMIT 1;
SELECT AVG(results.fastestlaptime) AS average_fastest_lap_time FROM results JOIN races ON results.raceid = races.raceid WHERE races.name = 'United States Grand Prix' AND races.year = 2006 AND results.rank < 11;
SELECT drivers.forename || ' ' || drivers.surname AS driver_name, AVG(pitstops.duration) AS avg_pitstop_duration FROM drivers JOIN pitstops ON drivers.driverid = pitstops.driverid WHERE drivers.nationality = 'German' AND drivers.dob BETWEEN '1980-01-01' AND '1985-12-31' GROUP BY drivers.driverid ORDER BY avg_pitstop_duration LIMIT 5; 
SELECT drivers.forename || ' ' || drivers.surname AS champion, results.time AS finish_time FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE races.name = 'Canadian Grand Prix' AND races.year = 2008 AND results.position = 1;
SELECT constructors.constructorref, constructors.url FROM     constructors JOIN     constructorstandings ON constructors.constructorid = constructorstandings.constructorid JOIN     races ON constructorstandings.raceid = races.raceid WHERE     races.name = 'Singapore Grand Prix'     AND races.year = 2009     AND constructorstandings.position = 1;
SELECT drivers.forename || ' ' || drivers.surname AS full_name, drivers.dob AS date_of_birth FROM drivers WHERE drivers.nationality = 'Austrian' AND strftime('%Y', drivers.dob) BETWEEN '1981' AND '1991';
SELECT drivers.forename || ' ' || drivers.surname AS full_name, drivers.url AS wikipedia_page_link, drivers.dob AS date_of_birth FROM drivers WHERE drivers.nationality = 'German' AND year(drivers.dob) BETWEEN '1971' AND '1985' ORDER BY drivers.dob DESC;
SELECT location, country, lat, lng FROM circuits WHERE circuitref = 'hungaroring';
SELECT  constructorid, SUM(points) AS total_points FROM constructorresults INNER JOIN races ON constructorresults.raceid = races.raceid INNER JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Monaco Grand Prix' AND races.year BETWEEN 1980 AND 2010 GROUP BY constructorid ORDER BY total_points DESC LIMIT 1;
SELECT AVG(results.points) FROM     results JOIN     races ON results.raceid = races.raceid JOIN     drivers ON results.driverid = drivers.driverid WHERE     drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'     AND races.name = 'Turkish Grand Prix';
SELECT AVG(COUNT(races.raceid)) FROM races JOIN seasons ON races.year = seasons.year WHERE seasons.year BETWEEN 2000 AND 2009;
SELECT MAX(nationality) FROM drivers;
SELECT COUNT(driverstandings.wins) FROM driverstandings WHERE driverstandings.position = 91
SELECT races.name FROM     races WHERE     races.fastestlapspeed = (         SELECT            MIN(results.fastestlapspeed)         FROM             results     );
SELECT circuits.name || ', ' || circuits.location || ', ' || circuits.country AS recent_race_location FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE races.date = (SELECT MAX(date) FROM races);
SELECT drivers.forename || ' ' || drivers.surname AS full_name FROM     drivers JOIN     qualifying ON drivers.driverid = qualifying.driverid JOIN     races ON qualifying.raceid = races.raceid JOIN     circuits ON races.circuitid = circuits.circuitid WHERE     circuits.name = 'Marina Bay Street Circuit'     AND races.year = 2008     AND qualifying.position = 1     AND qualifying.q3 = (SELECT MIN(q3) FROM qualifying WHERE raceid = races.raceid);
SELECT drivers.forename || ' ' || drivers.surname AS full_name, drivers.nationality, races.name AS first_race_joined FROM drivers JOIN (     SELECT    driverid,     MIN(dob) AS min_dob     FROM     drivers ) AS youngest_driver_dob ON drivers.dob = youngest_driver_dob.min_dob JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid ORDER BY races.year ASC LIMIT 1;
SELECT COUNT(results.resultid) AS accidents FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE races.name = 'Canadian Grand Prix' AND results.statusid = 3 GROUP BY drivers.driverid ORDER BY accidents DESC LIMIT 1;
SELECT COUNT(driverstandings.wins), drivers.forename || ' ' || drivers.surname AS oldest_racer_name FROM driverstandings JOIN drivers ON driverstandings.driverid = drivers.driverid WHERE drivers.dob = (SELECT MIN(dob) FROM drivers)
SELECT MAX(duration) FROM pitstops;
SELECT MIN(time) AS fastest_lap_time FROM laptimes;
SELECT MAX(duration) FROM pitstops JOIN drivers ON pitstops.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton';
SELECT raceid, lap FROM pitstops JOIN drivers ON pitstops.driverid = drivers.driverid JOIN races ON pitstops.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND races.name = 'Australian Grand Prix' AND races.year = 2011;
SELECT pitstops.time FROM pitstops JOIN races ON pitstops.raceid = races.raceid JOIN drivers ON pitstops.driverid = drivers.driverid JOIN constructors ON pitstops.driverid = constructors.constructorid WHERE races.name = 'Australian Grand Prix' AND races.year = 2011;
SELECT MIN(laptimes.time) FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'
SELECT drivers.forename || ' ' || drivers.surname AS shortest_lap_time_driver FROM laptimes JOIN races ON laptimes.raceid = races.raceid JOIN drivers ON laptimes.driverid = drivers.driverid WHERE time = (SELECT MIN(time) FROM laptimes)
SELECT races.name AS race_name, circuits.name AS circuit_name, results.position AS position FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND results.fastestlap = 1;
SELECT MIN(milliseconds) AS lap_record FROM laptimes JOIN circuits ON laptimes.circuitid = circuits.circuitid WHERE circuits.name = 'Austrian Grand Prix' GROUP BY circuits.name;
SELECT races.name AS circuit_name, circuits.location AS circuit_location, circuits.country AS circuit_country, MAX(laptimes.time) AS lap_record FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN laptimes ON races.raceid = laptimes.raceid WHERE circuits.country = 'Italy' GROUP BY races.name;
SELECT races.name AS race_name, races.date AS race_date, circuits.name AS circuit_name, MAX(laptimes.time) AS lap_record_time FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN laptimes ON races.raceid = laptimes.raceid WHERE circuits.name = 'Austrian Grand Prix Circuit' GROUP BY races.name;
SELECT pitstops.duration FROM     pitstops JOIN     races ON pitstops.raceid = races.raceid JOIN     circuits ON races.circuitid = circuits.circuitid JOIN     results ON races.raceid = results.raceid JOIN     drivers ON results.driverid = drivers.driverid WHERE     circuits.name = 'Austrian Grand Prix' AND     results.fastestlap = 1
SELECT circuits.lat, circuits.lng FROM     circuits JOIN races ON circuits.circuitid = races.circuitid JOIN results ON races.raceid = results.raceid WHERE     results.fastestlaptime = '1:29.488';
SELECT AVG(pitstops.duration) AS average_pitstop_time_milliseconds FROM pitstops JOIN drivers ON pitstops.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton';
SELECT AVG(laptimes.milliseconds) AS average_lap_time FROM     laptimes     JOIN races ON laptimes.raceid = races.raceid     JOIN circuits ON races.circuitid = circuits.circuitid WHERE     circuits.country = 'Italy';
SELECT player_api_id FROM player_attributes ORDER BY overall_rating DESC LIMIT 1;
SELECT MAX(player.height) AS tallest_height, player.player_name AS tallest_player_name FROM player;
SELECT preferred_foot FROM player_attributes WHERE potential = (     SELECT MIN(potential)     FROM player_attributes );
SELECT COUNT(DISTINCT player_attributes.player_api_id) FROM     player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE     player_attributes.overall_rating >= 60     AND player_attributes.overall_rating < 65     AND player_attributes.defensive_work_rate = 'low';
SELECT player_attributes.player_api_id, MAX(crossing) AS max_crossing FROM player_attributes GROUP BY player_attributes.player_api_id ORDER BY max_crossing DESC LIMIT 5;
SELECT league.name FROM     match JOIN     league ON match.league_id = league.id WHERE     match.season = '2015/2016' GROUP BY     match.league_id ORDER BY     SUM(match.home_team_goal + match.away_team_goal) DESC LIMIT 1;
SELECT team.team_long_name FROM     match JOIN     team ON match.home_team_api_id = team.team_api_id WHERE     match.season = '2015/2016' GROUP BY     match.home_team_api_id ORDER BY     COUNT(CASE WHEN match.home_team_goal < match.away_team_goal THEN 1 END) LIMIT 1;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id GROUP BY player.player_name ORDER BY MAX(player_attributes.penalties) DESC LIMIT 10;
SELECT team.team_long_name AS away_team_name, COUNT(*) AS num_wins FROM match JOIN team ON match.away_team_api_id = team.team_api_id JOIN league ON match.league_id = league.id WHERE league.name = 'Scotland Premier League' AND season = '2009/2010' AND (away_team_goal - home_team_goal) > 0 GROUP BY away_team_name ORDER BY num_wins DESC LIMIT 1;
SELECT team.team_long_name, team_attributes.buildupplayspeed AS build_up_play_speed FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id ORDER BY team_attributes.buildupplayspeed DESC LIMIT 4;
SELECT league.name FROM     match JOIN     league ON match.league_id = league.id WHERE     match.season = '2015/2016' GROUP BY     match.league_id ORDER BY     SUM(CASE WHEN match.home_team_goal = match.away_team_goal THEN 1 ELSE 0 END) DESC LIMIT 1;
SELECT strftime('%Y', 'now') - strftime('%Y', p.birthday) - (strftime('%m-%d', 'now') < strftime('%m-%d', p.birthday)) AS age FROM player AS p JOIN player_attributes AS pa ON p.player_api_id = pa.player_api_id WHERE pa.sprint_speed >= 97 AND pa.date BETWEEN '2013-01-01 00:00:00' AND '2015-12-31 00:00:00';
SELECT League.name, COUNT(match.id) AS matches_played FROM match JOIN league ON match.league_id = league.id GROUP BY league.name ORDER BY matches_played DESC LIMIT 1;
SELECT ROUND(AVG(player.height), 2) FROM player WHERE birthday >= '1990-01-01 00:00:00' AND birthday < '1996-01-01 00:00:00'; 
SELECT player_attributes.player_api_id FROM player_attributes WHERE substr(date,1,4) = '2010' AND overall_rating > (SELECT AVG(overall_rating) FROM player_attributes WHERE substr(date,1,4) = '2010')
SELECT team_fifa_api_id FROM team_attributes WHERE buildupplayspeed BETWEEN 51 AND 59; 
SELECT team.team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.date BETWEEN '2012-01-01 00:00:00' AND '2012-12-31 23:59:59' AND team_attributes.buildupplaypassing >   (SELECT AVG(buildupplaypassing)    FROM team_attributes    WHERE buildupplaypassing IS NOT NULL    AND strftime('%Y', date) = '2012'   ); 
SELECT ROUND((COUNT(CASE WHEN preferred_foot = 'left' THEN 1 END) * 100.0) / COUNT(player_fifa_api_id), 2) AS percentage_left_foot_players FROM player WHERE birthday BETWEEN '1987-01-01 00:00:00' AND '1992-12-31 00:00:00';
SELECT league.name AS league_name, COUNT(match.home_team_goal + match.away_team_goal) AS total_goals FROM match JOIN league ON match.league_id = league.id GROUP BY league_name ORDER BY total_goals ASC LIMIT 5; 
SELECT AVG(long_shots) AS avg_long_shots FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Ahmed Samir Farag';
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.height > 180 GROUP BY player.player_name ORDER BY AVG(player_attributes.heading_accuracy) DESC LIMIT 10; 
SELECT team.team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildupplaydribblingclass = 'Normal' AND team_attributes.date BETWEEN '2014-01-01 00:00:00' AND '2014-01-31 00:00:00' GROUP BY team.team_long_name HAVING AVG(team_attributes.chancecreationpassing) < (SELECT AVG(chanceCreationPassing) FROM team_attributes) ORDER BY AVG(team_attributes.chancecreationpassing) DESC; 
SELECT League.name FROM     match JOIN     league ON match.league_id = league.id GROUP BY     match.league_id HAVING     AVG(match.home_team_goal) > AVG(match.away_team_goal)     AND     match.season = '2009/2010';
SELECT team_short_name FROM team WHERE team_long_name = 'Queens Park Rangers';
SELECT player.player_name FROM player WHERE strftime('%Y', player.birthday) = '1970' AND strftime('%m', player.birthday) = '10';
SELECT player_attributes.attacking_work_rate FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Franco Zennaro';
SELECT buildupplaypositioningclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'ADO Den Haag';
SELECT player_attributes.heading_accuracy FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Francois Affolter' AND player.birthday = '1980-09-27 00:00:00' AND player_attributes.date = '2014-09-18 00:00:00'; 
SELECT player_attributes.overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Gabriel Tamas' AND strftime('%Y', player_attributes.date) = '2011';
SELECT COUNT(match.id) FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Scotland Premier League' AND match.season = '2015/2016';
SELECT preferred_foot FROM player ORDER BY birthday DESC LIMIT 1;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.potential = (     SELECT MAX(potential) FROM player_attributes );
SELECT COUNT(*)  FROM player_attributes  WHERE weight < 130 AND preferred_foot = 'left';
SELECT team.team_short_name FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_attributes.chancecreationpassingclass = 'Risky';
SELECT pa.defensive_work_rate FROM player_attributes AS pa JOIN player AS p ON pa.player_api_id = p.player_api_id WHERE p.player_name = 'David Wilson'; 
SELECT MAX(player.birthday) AS highest_rated_player_birthday FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.overall_rating = (     SELECT MAX(overall_rating) FROM player_attributes );
SELECT League.name FROM league JOIN country ON league.country_id = country.id WHERE country.name = 'Netherlands';
SELECT AVG(home_team_goal) AS average_home_team_goal FROM match JOIN league ON match.league_id = league.id JOIN country ON league.country_id = country.id WHERE country.name = 'Poland' AND match.season = '2010/2011';
SELECT MAX(finishing) AS highest_average_finishing_rate FROM player_attributes WHERE player_api_id IN (     SELECT player_api_id     FROM player     WHERE height = (         SELECT MAX(height)         FROM player     ) )
SELECT player.player_name FROM player WHERE player.height > 180;
SELECT COUNT(*) FROM player WHERE strftime('%Y', birthday) > '1990';
SELECT COUNT(player.id) FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.player_name LIKE 'Adam%' AND player_attributes.weight > 170;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.overall_rating > 80 AND strftime('%Y', player_attributes.date) BETWEEN '2008' AND '2010';
SELECT player_attributes.potential FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Aaron Doran';
SELECT player.player_name FROM player INNER JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.preferred_foot = 'left';
SELECT team.team_long_name FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_attributes.buildupplayspeedclass = 'Fast';
SELECT team_attributes.buildupplaypassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_short_name = 'CLB';
SELECT team.team_short_name FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_attributes.buildupplaypassing > 70;
SELECT AVG(overall_rating) AS average_overall_rating FROM player_attributes WHERE strftime('%Y', date) BETWEEN '2010' AND '2015' AND height > 170; 
SELECT player_name FROM player ORDER BY height LIMIT 1;
SELECT country.name FROM league JOIN country ON league.country_id = country.id WHERE league.name = 'Italy Serie A';
SELECT team.team_short_name FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_attributes.buildupplayspeed = 31 AND team_attributes.buildupplaydribbling = 53 AND team_attributes.buildupplaypassing = 32;
SELECT AVG(player_attributes.overall_rating) AS average_overall_rating FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.player_name = 'Aaron Doran';
SELECT COUNT(match.id) FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Germany 1. Bundesliga' AND strftime('%Y-%m', match.date) BETWEEN '2008-08' AND '2008-10';
SELECT team.team_short_name FROM match JOIN team ON match.home_team_api_id = team.team_api_id WHERE match.home_team_goal = 10;
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.balance = (SELECT MAX(balance) FROM player_attributes WHERE potential = 61) AND player_attributes.potential = 61; 
SELECT AVG(CASE WHEN player.player_name = 'Abdou Diallo' THEN player_attributes.ball_control ELSE 0 END) - AVG(CASE WHEN player.player_name = 'Aaron Appindangoye' THEN player_attributes.ball_control ELSE 0 END) FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id;
SELECT team_long_name FROM team WHERE team_short_name = 'GEN';
SELECT MIN(player.birthday) AS oldest_birthday FROM player WHERE player.player_name IN ('Aaron Lennon', 'Abdelaziz Barrada');
SELECT player.player_name FROM player ORDER BY player.height DESC LIMIT 1;
SELECT COUNT(*)  FROM player_attributes  WHERE preferred_foot = 'left'  AND attacking_work_rate = 'low';
SELECT country.name FROM league JOIN country ON league.country_id = country.id WHERE league.name = 'Belgium Jupiler League';
SELECT league.name FROM league JOIN country ON league.country_id = country.id WHERE country.name = 'Germany';
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.overall_rating = (     SELECT MAX(overall_rating)     FROM player_attributes )
SELECT COUNT(*)  FROM player_attributes  JOIN player ON player_attributes.player_api_id = player.player_api_id  WHERE strftime('%Y', player.birthday) < '1986'  AND player_attributes.defensive_work_rate = 'high';
SELECT MAX(player_attributes.crossing) AS max_crossing FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name IN ('Alexis', 'Ariel Borysiuk', 'Arouna Kone');
SELECT player_attributes.heading_accuracy FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Ariel Borysiuk'; 
SELECT COUNT(player_attributes.id) FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.height > 180 AND player_attributes.volleys > 70;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.volleys > 70 AND player_attributes.dribbling > 70;
SELECT COUNT(match.id) FROM match JOIN league ON match.league_id = league.id JOIN country ON league.country_id = country.id WHERE match.season = '2008/2009' AND country.name = 'Belgium';
SELECT MAX(long_passing) AS long_passing_score FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE birthday = (SELECT MIN(birthday) FROM player);
SELECT COUNT(*) FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Belgium Jupiler League' AND strftime('%Y', match.date) = '2009' AND strftime('%m', match.date) = '04';
SELECT MAX(league_id) AS league_id FROM match WHERE season = '2008/2009';
SELECT AVG(overall_rating) FROM player_attributes WHERE strftime('%Y', birthday) < '1986';
SELECT ((player_attributes.overall_rating  WHERE player.player_name = 'Ariel Borysiuk') -  (player_attributes.overall_rating  WHERE player.player_name = 'Paulin Puel')) / (player_attributes.overall_rating  WHERE player.player_name = 'Paulin Puel') * 100;
SELECT AVG(buildupplayspeed) AS average_build_up_play_speed FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Heart of Midlothian';
SELECT AVG(T1.overall_rating) AS average_overall_rating FROM player_attributes AS T1 JOIN player AS T2 ON T1.player_api_id = T2.player_api_id WHERE T2.player_name = 'Pietro Marino';
SELECT SUM(player_attributes.crossing) AS total_crossing_score FROM     player_attributes JOIN     player ON player_attributes.player_api_id = player.player_api_id WHERE     player.player_name = 'Aaron Lennox';
SELECT MAX(chancecreationpassing) AS highest_chance_creation_passing_score, chancecreationpassingclass AS chance_creation_passing_classification FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_long_name = 'Ajax';
SELECT preferred_foot FROM player WHERE player_name = 'Abdou Diallo';
SELECT MAX(overall_rating) AS highest_overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Dorlan Pabon';
SELECT AVG(away_team_goal) FROM match JOIN team ON match.away_team_api_id = team.team_api_id JOIN league ON match.country_id = league.country_id WHERE team.team_long_name = 'Parma' AND league.name LIKE '%Italy%';
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.overall_rating = 77 AND player_attributes.date = '2016-06-23' ORDER BY player.birthday ASC LIMIT 1;
SELECT player_attributes.overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Aaron Mooy' AND player_attributes.date = '2016-02-04 00:00:00';
SELECT potential FROM     player_attributes JOIN     player ON player_attributes.player_api_id = player.player_api_id WHERE     player.player_name = 'Francesco Parravicini'     AND player_attributes.date = '2010-08-30 00:00:00';
SELECT attacking_work_rate FROM     player_attributes JOIN     player ON player_attributes.player_api_id = player.player_api_id WHERE     player.player_name = 'Francesco Migliore'     AND player_attributes.date = '2015-05-01 00:00:00';
SELECT player_attributes.defensive_work_rate FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Kevin Berigaud' AND player_attributes.date = '2013-02-22 00:00:00';
SELECT MIN(date) FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_name = 'Kevin Constant' AND crossing = (SELECT MAX(crossing) FROM player_attributes WHERE player_name = 'Kevin Constant');
SELECT team_attributes.buildupplayspeedclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Willem II' AND team_attributes.date = '2012-02-22 00:00:00';
SELECT buildupplaydribblingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id JOIN match ON match.home_team_api_id = team.team_api_id JOIN league ON match.country_id = league.country_id WHERE team.team_short_name = 'LEI' AND match.date = '2015-09-10 00:00:00';
SELECT team_attributes.buildupplaypassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'FC Lorient' AND team_attributes.date = '2010-02-22';
SELECT chancecreationpassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id JOIN match ON (match.home_team_api_id = team.team_api_id OR match.away_team_api_id = team.team_api_id) WHERE team.team_long_name = 'PEC Zwolle' AND date = '2013-09-20 00:00:00';
SELECT team_attributes.chancecreationcrossingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Hull City' AND team_attributes.date = '2010-02-22 00:00:00'; 
SELECT team_attributes.defenceaggressionclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Hannover 96' AND team_attributes.date = '2015-09-10 00:00:00';
SELECT AVG(player_attributes.overall_rating) AS average_overall_rating FROM     player_attributes JOIN     player ON player_attributes.player_api_id = player.player_api_id WHERE     player.player_name = 'Marko Arnautovic'     AND player_attributes.date BETWEEN '2007-02-22 00:00:00' AND '2016-04-21 00:00:00';
SELECT ROUND(((SELECT overall_rating FROM player_attributes WHERE player_api_id = (SELECT player_api_id FROM player WHERE player_name = 'Landon Donovan') AND date = '2013-07-12') - (SELECT overall_rating FROM player_attributes WHERE player_api_id = (SELECT player_api_id FROM player WHERE player_name = 'Jordan Bowery') AND date = '2013-07-12')) / (SELECT overall_rating FROM player_attributes WHERE player_name = 'Landon Donovan' AND date = '2013-07-12') * 100, 2) AS rating_difference_percentage;
SELECT player.player_name FROM player ORDER BY player.height DESC LIMIT 5;
SELECT player_api_id FROM player ORDER BY weight DESC LIMIT 10;
SELECT player.player_name FROM player WHERE strftime('%Y', 'now') - strftime('%Y', player.birthday) > 34;
SELECT COUNT(match.home_team_goal) AS home_goals FROM     match JOIN     player AS p ON match.home_player_1 = p.player_api_id     OR match.home_player_2 = p.player_api_id     OR match.home_player_3 = p.player_api_id     OR match.home_player_4 = p.player_api_id     OR match.home_player_5 = p.player_api_id     OR match.home_player_6 = p.player_api_id     OR match.home_player_7 = p.player_api_id     OR match.home_player_8 = p.player_api_id     OR match.home_player_9 = p.player_api_id     OR match.home_player_10 = p.player_api_id     OR match.home_player_11 = p.player_api_id WHERE     p.player_name = 'Aaron Lennon';
SELECT SUM(match.away_team_goal) FROM match JOIN player ON match.away_player_1 = player.player_api_id OR match.away_player_2 = player.player_api_id OR match.away_player_3 = player.player_api_id OR match.away_player_4 = player.player_api_id OR match.away_player_5 = player.player_api_id OR match.away_player_6 = player.player_api_id OR match.away_player_7 = player.player_api_id OR match.away_player_8 = player.player_api_id OR match.away_player_9 = player.player_api_id OR match.away_player_10 = player.player_api_id OR match.away_player_11 = player.player_api_id WHERE player.player_name = 'Daan Smith' OR player.player_name = 'Filipe Ferreira';
SELECT SUM(home_team_goal) AS total_home_team_goals FROM match JOIN player AS home_players ON match.home_player_1 = home_players.player_api_id OR match.home_player_2 = home_players.player_api_id OR match.home_player_3 = home_players.player_api_id OR match.home_player_4 = home_players.player_api_id OR match.home_player_5 = home_players.player_api_id OR match.home_player_6 = home_players.player_api_id OR match.home_player_7 = home_players.player_api_id OR match.home_player_8 = home_players.player_api_id OR match.home_player_9 = home_players.player_api_id OR match.home_player_10 = home_players.player_api_id OR match.home_player_11 = home_players.player_api_id WHERE strftime('%Y', 'now') - strftime('%Y', home_players.birthday) <= 30;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.overall_rating = (     SELECT MAX(overall_rating)     FROM player_attributes ) LIMIT 10;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.potential = (     SELECT MAX(potential) FROM player_attributes )
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.attacking_work_rate = 'high';
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.finishing = 1 ORDER BY (date('now') - date(player.birthday)) DESC LIMIT 1;
SELECT player.player_name FROM player JOIN country ON player.country_id = country.id WHERE country.name = 'Belgium';
SELECT player.player_name,     country.name AS country FROM     player     JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id     JOIN country ON player.player_fifa_api_id = country.id WHERE     player_attributes.vision > 89;
SELECT country.name FROM country JOIN player ON country.id = player.country_id GROUP BY country.name ORDER BY AVG(player.weight) DESC LIMIT 1;
SELECT team.team_long_name FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team_attributes.buildupplayspeedclass = 'Slow';
SELECT team.team_short_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.chancecreationpassingclass = 'Safe';
SELECT AVG(player.height) AS avg_height FROM player JOIN country ON player.country_id = country.id WHERE country.name = 'Italy';
SELECT player.player_name FROM player WHERE player.height > 180 ORDER BY player.player_name ASC LIMIT 3;
SELECT COUNT(*) FROM player WHERE player_name LIKE 'Aaron%' AND birthday > '1990-01-01';
SELECT ABS((SELECT jumping FROM player_attributes WHERE id = 6) - (SELECT jumping FROM player_attributes WHERE id = 23)) AS jumping_difference;
SELECT player_attributes.player_api_id FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.potential = (SELECT MIN(potential) FROM player_attributes) AND player_attributes.preferred_foot = 'right' LIMIT 3;
SELECT COUNT(*) AS num_players FROM player_attributes WHERE crossing = (SELECT MAX(crossing) FROM player_attributes) AND preferred_foot = 'left';
SELECT 100.0 * (     SELECT COUNT(*)      FROM player_attributes      WHERE stamina > 80 AND strength > 80 ) / (     SELECT COUNT(*)      FROM player_attributes );
SELECT country.name FROM country JOIN league ON country.id = league.country_id WHERE league.name = 'Poland Ekstraklasa';
SELECT home_team_goal, away_team_goal FROM match JOIN league ON match.league_id = league.id JOIN country ON league.country_id = country.id WHERE country.name = 'Belgium' AND league.name = 'Belgium Jupiler League' AND match.date LIKE '2008-09-24%' LIMIT 1;
SELECT player_attributes.sprint_speed, player_attributes.agility, player_attributes.acceleration FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Alexis Blin';
SELECT MAX(team_attributes.buildupplayspeedclass) AS speed_class FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'KSV Cercle Brugge';
SELECT COUNT(match.id) FROM     match JOIN     league ON match.league_id = league.id WHERE     league.name = 'Italy Serie A'     AND match.season = '2015/2016';
SELECT MAX(home_team_goal) FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Netherlands Eredivisie';
SELECT MAX(weight), finishing, curve FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE weight = (SELECT MAX(weight) FROM player);
SELECT league.name AS league_name, COUNT(match.id) AS num_games FROM match JOIN league ON match.league_id = league.id WHERE match.season = '2015/2016' GROUP BY league_name ORDER BY num_games DESC LIMIT 1;
SELECT team.team_long_name FROM     team JOIN     match ON match.away_team_api_id = team.team_api_id WHERE     match.away_team_goal = (         SELECT            MAX(away_team_goal)         FROM             match     );
SELECT player.player_name FROM player INNER JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.strength = (SELECT MAX(strength) FROM player_attributes);
SELECT (COUNT(*) * 100) / (     SELECT COUNT(*)     FROM player     WHERE height < 180 ) AS percentage FROM player_attributes WHERE overall_rating > 70;
SELECT      (SELECT COUNT(id) FROM patient WHERE sex = 'M' AND admission = '+') - (SELECT COUNT(id) FROM patient WHERE sex = 'M' AND admission = '-') AS deviation,     (CAST((SELECT COUNT(id) FROM patient WHERE sex = 'M' AND admission = '+') AS FLOAT) / (SELECT COUNT(id) FROM patient WHERE admission = '+') * 100) AS percentage_in_patient 
SELECT (CAST(COUNT(CASE WHEN Sex = 'F' AND strftime('%Y', Birthday) > '1930' THEN id END) AS FLOAT) / CAST(COUNT(CASE WHEN Sex = 'F' THEN id END) AS FLOAT)) * 100 AS percentage_of_female_born_after_1930
SELECT COUNT(patient.id) * 100.0 / (SELECT COUNT(*) FROM patient WHERE strftime('%Y', birthday) BETWEEN '1930' AND '1940') AS percentage_inpatient FROM patient WHERE strftime('%Y', birthday) BETWEEN '1930' AND '1940' AND admission LIKE '+%';
SELECT COUNT(CASE WHEN patient.diagnosis = 'SLE' AND patient.admission = '+' THEN patient.id END) * 1.0 / COUNT(CASE WHEN patient.diagnosis = 'SLE' AND patient.admission = '-' THEN patient.id END) FROM patient
SELECT diagnosis FROM patient WHERE id = '30609';
SELECT patient.sex, patient.birthday, examination."Examination Date", examination.symptoms FROM patient JOIN examination ON patient.id = examination.id WHERE patient.id = '163109';
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.ldh > 500; 
SELECT patient.id, strftime('%Y', 'now') - strftime('%Y', patient.birthday) AS age FROM patient JOIN examination ON patient.id = examination.id WHERE examination.rvvt = '+';
SELECT examination.id, patient.sex, patient.diagnosis FROM examination JOIN patient ON examination.id = patient.id WHERE examination.thrombosis = 2; 
SELECT patient.id, patient.birthday, laboratory.t-cho FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE YEAR(patient.birthday) = '1937' AND laboratory.t-cho >= '250'; 
SELECT patient.id, patient.sex, patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.alb < 3.5; 
SELECT ROUND((CAST(COUNT(CASE WHEN patient.sex = 'F' AND (laboratory.tp < 6.0 OR laboratory.tp > 8.5) THEN patient.id END) AS FLOAT) / COUNT(patient.id)) * 100, 2) AS percentage_female_abnormal_tp FROM patient JOIN laboratory ON patient.id = laboratory.id;
SELECT AVG(examination."acl igg") FROM examination JOIN patient ON examination.id = patient.id WHERE patient.admission = '+' AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) >= 50;
SELECT COUNT(DISTINCT patient.id) FROM     patient WHERE     sex = 'F'     AND strftime('%Y', first_date) = '1997'     AND admission = '-';
SELECT MIN(STRFTIME('%Y', First Date) - STRFTIME('%Y', Birthday)) AS "Age of Youngest Patient at Initial Arrival" FROM patient;
SELECT COUNT(DISTINCT patient.id) FROM     examination JOIN     patient ON examination.id = patient.id WHERE     examination.thrombosis = '1'     AND examination.examination_date LIKE '1997%'     AND patient.sex = 'F';
SELECT MAX(strftime('%Y', p1.birthday)) - MIN(strftime('%Y', p1.birthday)) AS age_gap FROM     patient p1     JOIN laboratory l ON p1.id = l.id WHERE     l.tg >= 200     AND p1.diagnosis = 'Normal';
SELECT symptoms, diagnosis FROM examination JOIN patient ON examination.id = patient.id WHERE birthday = (SELECT MIN(birthday) FROM patient);
SELECT COUNT(DISTINCT laboratory.id) / 12 AS average_male_patients_per_month FROM     laboratory JOIN     patient ON laboratory.id = patient.id WHERE     patient.sex = 'M' AND     laboratory.date BETWEEN '1998-01-01' AND '1998-12-31';
SELECT MAX(laboratory.date) AS "Oldest SJS Patient Laboratory Work Completion Date", (SUBTRACT(year(patient.first_date), year(patient.birthday))) AS "Age at Initial Hospital Arrival" FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE patient.diagnosis = 'SJS';
SELECT SUM(CASE WHEN laboratory.ua <= 8.0 AND patient.sex = 'M' THEN 1 ELSE 0 END) / SUM(CASE WHEN laboratory.ua <= 6.5 AND patient.sex = 'F' THEN 1 ELSE 0 END) as male_to_female_ratio_abnormal_uric_acid FROM laboratory JOIN patient ON laboratory.id = patient.id;
SELECT COUNT(DISTINCT patient.id) FROM patient LEFT JOIN examination ON patient.id = examination.id WHERE strftime('%Y', examination.date) - strftime('%Y', patient.first_date) >= 1 OR examination.date IS NULL;
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id WHERE strftime('%Y', birthday) > '1975' AND strftime('%Y', examination_date) BETWEEN '1990' AND '1993';
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     laboratory ON patient.id = laboratory.id WHERE     patient.sex = 'M'     AND laboratory.t_bil > 2.0;
SELECT MAX(COUNT(diagnosis)) AS most_common_illness FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE examination_date BETWEEN '1985-01-01' AND '1995-12-31' GROUP BY diagnosis;
SELECT AVG(SUBTRACT('1991', year(Birthday))) FROM patient WHERE substr(date, 1, 4) = '1991' AND substr(date, 6, 2) = '10'
SELECT MAX(HGB) AS max_hemoglobin, (EXTRACT(YEAR FROM examination_date) - EXTRACT(YEAR FROM birthday)) AS age, diagnosis FROM examination JOIN patient ON examination.id = patient.id WHERE hgb = (SELECT MAX(hgb) FROM examination) GROUP BY examination.id;
SELECT ANA FROM examination WHERE id = '3605340' AND "Examination Date" = '1996-12-02';
SELECT CASE     WHEN laboratory.t_cho < 250 THEN 'Normal'     ELSE 'Abnormal' END AS total_cholesterol_status FROM     laboratory JOIN     patient ON laboratory.id = patient.id WHERE     patient.id = '2927464'     AND laboratory.date = '1995-09-04';
SELECT `patient.sex` FROM patient WHERE patient.diagnosis = 'AORTITIS' ORDER BY patient.first_date LIMIT 1;
SELECT examination.acl_igm FROM examination JOIN patient ON examination.id = patient.id WHERE patient.diagnosis = 'SLE' AND patient.description = '1994-02-19' AND examination.examination_date = '1993-11-12';
SELECT sex FROM     patient     JOIN laboratory ON patient.id = laboratory.id WHERE     sex = 'M'     AND gpt = '9'     AND date = '1992-06-12';
SELECT ROUND((julianday('1991-10-21') - julianday(substr(p.birthday, 1, 5) || '-01-01')) / 365.25) AS age FROM patient p JOIN laboratory l ON p.id = l.id WHERE l.date = '1991-10-21' AND l.ua = '8.4';
SELECT COUNT(laboratory.id) FROM laboratory JOIN patient ON laboratory.id = patient.id WHERE patient.first_date = '1991-06-13' AND patient.diagnosis = 'SJS' AND strftime('%Y', laboratory.date) = '1995';
SELECT diagnosis FROM patient WHERE id IN (     SELECT id     FROM examination     WHERE diagnosis = 'SLE'         AND "Examination Date" = '1997-01-27' ) AND "First Date" = (     SELECT MIN("First Date")     FROM patient     WHERE id IN (         SELECT id         FROM examination         WHERE diagnosis = 'SLE'             AND "Examination Date" = '1997-01-27'     ) );
SELECT symptoms FROM examination JOIN patient ON examination.id = patient.id WHERE patient.birthday = '1959-03-01' AND examination."examination date" = '1993-09-27';
SELECT (B.t_cho - A.t_cho) / A.t_cho * 100 AS decrease_rate FROM (     SELECT SUM(t_cho) AS t_cho     FROM laboratory     WHERE id IN (         SELECT id         FROM patient         WHERE birthday = '1959-02-18'     ) AND date LIKE '1981-11-%' ) AS A, (     SELECT SUM(t_cho) AS t_cho     FROM laboratory     WHERE id IN (         SELECT id         FROM patient         WHERE birthday = '1959-02-18'     ) AND date LIKE '1981-12-%' ) AS B; 
SELECT examination.id FROM examination JOIN patient ON examination.id = patient.id WHERE patient.diagnosis LIKE '%Behcet%' AND examination_date BETWEEN '1977-01-01' AND '1998-12-31';
SELECT COUNT(DISTINCT patient.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE examination.date BETWEEN '1987-07-06' AND '1996-01-31' AND laboratory.gpt > 30 AND laboratory.alb < 4; 
SELECT COUNT(patient.id) AS female_patients_admitted_1964, GROUP_CONCAT(patient.id) AS patient_ids FROM patient WHERE sex = 'F' AND strftime('%Y', birthday) = '1964' AND admission LIKE '+%';
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE thrombosis = 2 AND ana_pattern = 'S' AND acl_igm > (SELECT AVG(acl_igm) * 1.2 FROM examination)
SELECT 100.0 * COUNT(DISTINCT CASE WHEN ua <= 6.5 AND u_pro > 0 AND u_pro < 30 THEN patient.id END) / COUNT(DISTINCT CASE WHEN u_pro > 0 AND u_pro < 30 THEN patient.id END) FROM laboratory INNER JOIN patient ON laboratory.id = patient.id;
SELECT ROUND((COUNT(CASE WHEN patient.sex = 'M' AND patient.first_date LIKE '1981%' THEN patient.id END) * 100.0) / COUNT(CASE WHEN patient.first_date LIKE '1981%' THEN patient.id END), 2) AS "Percentage of Male Patients Diagnosed with BEHCET in 1981" FROM patient LEFT JOIN examination ON examination.id = patient.id WHERE patient.diagnosis LIKE 'BEHCET' AND patient.first_date LIKE '1981%'; 
SELECT  patient.id FROM patient INNER JOIN laboratory ON patient.id = laboratory.id WHERE patient.admission = '-' AND laboratory.date LIKE '1991-10%' AND laboratory.t_bil < 2.0;
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     examination ON examination.id = patient.id JOIN     laboratory ON laboratory.id = patient.id WHERE     examination.ana_pattern != 'P'     AND patient.sex = 'F'     AND substr(patient.birthday, 1, 4) BETWEEN '1980' AND '1989';
SELECT patient.sex FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE examination.diagnosis = 'PSS' AND laboratory.crp = '2+' AND laboratory.cre = '1' AND laboratory.ldh = '123';
SELECT AVG(laboratory.alb) AS average_blood_albumin_level FROM     patient JOIN     examination ON patient.id = examination.id JOIN     laboratory ON patient.id = laboratory.id WHERE     patient.sex = 'F'     AND laboratory.plt > 400     AND patient.diagnosis LIKE '%SLE%';
SELECT MAX(symptoms) FROM examination WHERE diagnosis = 'SLE';
SELECT MIN(patient.description) AS first_documented, patient.diagnosis AS disease FROM patient WHERE patient.id = 48473;
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN examination ON patient.id = examination.id WHERE patient.sex = 'F' AND patient.diagnosis LIKE '%APS%';
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE strftime('%Y', examination_date) = '1997' AND (tp <= 6 OR tp >= 8.5);
SELECT 100 * SUM(CASE WHEN symptoms LIKE '%thrombocytopenia%' THEN 1 ELSE 0 END AND diagnosis LIKE '%SLE%') / SUM(CASE WHEN symptoms LIKE '%thrombocytopenia%' THEN 1 ELSE 0 END) FROM examination WHERE diagnosis LIKE '%SLE%' OR diagnosis LIKE '%ITP%';
SELECT ROUND((CAST((SELECT COUNT(*) FROM patient WHERE YEAR(birthday) = '1980' AND diagnosis = 'RA' AND sex = 'F') AS FLOAT) / CAST((SELECT COUNT(*) FROM patient WHERE YEAR(birthday) = '1980' AND diagnosis = 'RA') AS FLOAT)) * 100, 2) AS "Percentage of female patients born in 1980 diagnosed with RA" 
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     examination ON patient.id = examination.id WHERE     patient.sex = 'M'     AND examination.examination_date BETWEEN '1995-01-01' AND '1997-12-31'     AND UPPER(patient.diagnosis) = 'BEHCET'     AND patient.admission = '-'
SELECT COUNT(DISTINCT examination.id) AS Female_Patients_With_Low_WBC FROM     examination JOIN     patient ON examination.id = patient.id JOIN     laboratory ON patient.id = laboratory.id WHERE     patient.sex = 'F'     AND laboratory.wbc < 3.5;
SELECT DATEDIFF(examination.examination_date, patient.first_date) AS evaluation_delay FROM examination JOIN patient ON examination.id = patient.id WHERE patient.id = '821298';
SELECT MAX(laboratory.ua) AS max_ua FROM   patient JOIN   examination ON patient.id = examination.id JOIN   laboratory ON patient.id = laboratory.id WHERE   patient.id = '57266';
SELECT  laboratory.date FROM laboratory JOIN patient ON laboratory.id = patient.id WHERE patient.id = '48473' AND laboratory.got >= 60; 
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.got < 60 AND strftime('%Y', laboratory.date) = '1994';
SELECT examination.id FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE patient.sex = 'M' AND laboratory.gpt >= 60;
SELECT diagnosis FROM     patient WHERE     id IN (         SELECT            id         FROM             laboratory         WHERE             gpt > 60     ) ORDER BY     birthday ASC;
SELECT AVG(ldh) AS average_ldh FROM laboratory WHERE ldh < 500;
SELECT  patient.id,  year(current_timestamp) - year(patient.birthday) as age  FROM  patient  JOIN  laboratory ON patient.id = laboratory.id  WHERE  ldh BETWEEN 600 AND 800; 
SELECT patient.id, CASE      WHEN laboratory.alp < 300 THEN 'outpatient'     ELSE 'inpatient' END AS treatment_status FROM patient INNER JOIN laboratory ON patient.id = laboratory.id;
SELECT patient.id FROM patient WHERE birthday = '1982-04-01' AND (   SELECT  alp   FROM   laboratory   WHERE   laboratory.id = patient.id   ORDER BY   date DESC   LIMIT 1 ) < 300; 
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tp < 6.0; 
SELECT  examination.id, examination.total_protein - 8.5 AS tp_deviation FROM examination JOIN patient ON examination.id = patient.id WHERE patient.sex = 'F' AND examination.total_protein > 8.5;
SELECT patient.id, patient.sex, patient.birthday, patient.description FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND (laboratory.alb < 3.5 OR laboratory.alb > 5.5) ORDER BY patient.birthday DESC; 
SELECT  SELECT patient.id,        CASE WHEN laboratory.alb BETWEEN 3.5 AND 5.5 THEN 'Within normal range'             ELSE 'Not within normal range' END AS albumin_status FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE strftime('%Y', patient.birthday) = '1982'; 
SELECT 100.0 * SUM(CASE WHEN p.sex = 'F' AND (l.ua > 6.5) THEN 1 ELSE 0 END) / COUNT(*) FROM patient p JOIN laboratory l ON p.id = l.id;
SELECT AVG(ua) AS average_ua_index FROM (     SELECT        patient.id,         ua,         sex,         MAX(laboratory.date) AS latest_lab_date     FROM         patient     JOIN         laboratory ON patient.id = laboratory.id     WHERE         (ua < 8.0 AND sex = 'M') OR (ua < 6.5 AND sex = 'F')     GROUP BY         patient.id ) AS latest_lab_results WHERE     ua IS NOT NULL;
SELECT patient.id, patient.sex, patient.birthday FROM patient INNER JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.un = 29 
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.diagnosis = 'RA' AND laboratory.un < 30; 
SELECT COUNT(DISTINCT examination.id) FROM     examination JOIN     patient ON examination.id = patient.id JOIN     laboratory ON examination.id = laboratory.id WHERE     patient.sex = 'M'     AND laboratory.cre >= 1.5;
SELECT CASE     WHEN (SELECT COUNT(*) FROM examination            JOIN patient ON examination.id = patient.id            JOIN laboratory ON laboratory.id = patient.id            WHERE patient.sex = 'M' AND laboratory.cre >= 1.5) >          (SELECT COUNT(*) FROM examination            JOIN patient ON examination.id = patient.id            JOIN laboratory ON laboratory.id = patient.id            WHERE patient.sex = 'F' AND laboratory.cre >= 1.5)     THEN 'True'     ELSE 'False' END;
SELECT MAX(t_bil) AS max_total_bilirubin, patient.id AS patient_id, patient.sex, patient.birthday FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id GROUP BY patient_id ORDER BY max_total_bilirubin DESC LIMIT 1; 
SELECT patient.sex, COUNT(*) AS patient_count FROM patient INNER JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.t-bil >= 2.0 GROUP BY patient.sex; 
SELECT MIN(patient.id) AS oldest_patient_id, MAX(laboratory.t-cho) AS highest_t_cho_index FROM patient JOIN laboratory ON patient.id = laboratory.id ORDER BY patient.birthday ASC, laboratory.t-cho DESC LIMIT 1;
SELECT AVG(YEAR(NOW()) - YEAR(birthday)) AS average_age FROM     patient WHERE     sex = 'M'     AND id IN (         SELECT id         FROM laboratory         WHERE t_cho >= 250     );
SELECT patient.id, patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tg > 300; 
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tg >= 200 AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) > 50;
SELECT DISTINCT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.admission = '-' AND laboratory.cpk < 250;
SELECT COUNT(*) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE YEAR(birthday) BETWEEN 1936 AND 1956 AND sex = 'M' AND cpk >= 250;
SELECT   patient.id, patient.sex, strftime('%Y', 'now') - strftime('%Y', patient.birthday) AS age FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.glu >= 180 AND laboratory.t_cho < 250; 
SELECT patient.id, laboratory.glu AS "Blood Glucose (GLU)" FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE strftime('%Y', patient.description) >= '1991' AND laboratory.glu < 180; 
SELECT patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.wbc <= 3.5 OR laboratory.wbc >= 9.0 GROUP BY patient.sex, patient.id ORDER BY date(patient.birthday) ASC; 
SELECT patient.id,  (SUBSTR(CAST((strftime('%Y', 'now') - strftime('%Y', patient.birthday)) AS TEXT), 1, 3)) - 1 - (substr(patient.birthday, 6, 2) > substr(strftime('%Y-%m-%d', 'now'), 6, 2)) AS age FROM patient INNER JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.rbc < 3.5;
SELECT examination.id, admission FROM examination JOIN patient ON examination.id = patient.id WHERE patient.sex = 'F' AND year(current_timestamp) - year(patient.birthday) >= 50 AND (examination.rbc <= 3.5 OR examination.rbc >= 6.0)
SELECT patient.id, patient.sex FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.admission = '-' AND laboratory.hgb < 10; 
SELECT  patient.id, patient.sex FROM patient JOIN examination ON patient.id = examination.id WHERE patient.diagnosis = 'SLE' AND examination.hgb > 10 AND examination.hgb < 17 ORDER BY patient.birthday ASC LIMIT 1;
SELECT patient.id, (SUBTRACT(year(current_timestamp), year(Birthday))) AS age FROM patient JOIN laboratory ON patient.id = laboratory.id GROUP BY patient.id HAVING COUNT(laboratory.id) > 2 AND MAX(hct) >= 52;
SELECT AVG(hct) AS average_hematoclit FROM laboratory WHERE date LIKE '1991%' AND hct < 29;
SELECT COUNT(CASE WHEN plt < 100 THEN 1 END) AS lower_than_normal, COUNT(CASE WHEN plt > 400 THEN 1 END) AS higher_than_normal FROM laboratory;
SELECT examination.id, examination_date, birthday, plt FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON examination.id = laboratory.id WHERE date LIKE '1984%' AND (strftime('%Y', 'now') - strftime('%Y', birthday)) < 50 AND plt BETWEEN 100 AND 400;
SELECT (SELECT    CAST(COUNT(CASE WHEN p.sex = 'F' AND l.pt >= 14 THEN 1 END) AS REAL) / COUNT(CASE WHEN p.age > 55 THEN 1 END) * 100  FROM     patient p  JOIN     laboratory l ON p.id = l.id  WHERE     p.age > 55) 
SELECT   patient.id FROM patient INNER JOIN examination ON patient.id = examination.id INNER JOIN laboratory ON patient.id = laboratory.id WHERE strftime('%Y', patient."First Date") > '1992' AND laboratory.pt < 14; 
SELECT COUNT(*) FROM examination WHERE examination_date > '1997-01-01' AND aptt >= 45;
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN laboratory ON examination.id = laboratory.id WHERE aptt > 45 AND thrombosis = 3;
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.fg NOT BETWEEN 150 AND 450 AND laboratory.wbc BETWEEN 3.5 AND 9.0;
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     laboratory ON patient.id = laboratory.id WHERE     patient.birthday > '1980-01-01'     AND laboratory.fg NOT BETWEEN 150 AND 450;
SELECT patient.diagnosis FROM patient INNER JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.u_pro >= 30 
SELECT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.diagnosis = 'SLE' AND laboratory.u_pro > 0 AND laboratory.u_pro < 30; 
SELECT COUNT(DISTINCT patient.id) FROM examination JOIN patient ON examination.id = patient.id WHERE igg < 900 AND symptoms = 'abortion';
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN examination ON patient.id = examination.id JOIN laboratory ON patient.id = laboratory.id WHERE     examination.igg BETWEEN 900 AND 2000     AND examination.symptoms IS NOT NULL;
SELECT diagnosis FROM     patient WHERE     id IN (         SELECT            id         FROM             laboratory         WHERE             iga BETWEEN 80 AND 500         ORDER BY             iga DESC         LIMIT 1     ); 
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id WHERE examination.iga BETWEEN 80 AND 500 AND strftime('%Y', patient."First Date") >= '1990';
SELECT MAX(diagnosis) FROM patient JOIN examination ON patient.id = examination.id JOIN laboratory ON patient.id = laboratory.id WHERE igm NOT BETWEEN 40 AND 400;
SELECT COUNT(DISTINCT examination.id) FROM examination LEFT JOIN patient ON examination.id = patient.id LEFT JOIN laboratory ON examination.id = laboratory.id WHERE (examination.diagnosis = 'Normal' OR examination.diagnosis IS NULL) AND (examination.crp = '+' OR examination.crp = '-' OR CAST(examination.crp AS REAL) < 1.0) AND patient.description IS NULL;
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE crp NOT IN ('+-', '-') AND crp >= 1.0 AND (strftime('%Y', 'now') - strftime('%Y', birthday)) < 18;
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id WHERE patient.diagnosis NOT LIKE '%RA%' AND patient.diagnosis NOT LIKE '%+-%' AND examination.kct = '+';
SELECT diagnosis FROM     patient JOIN     examination ON patient.id = examination.id WHERE     strftime('%Y', patient.birthday) >= '1995'     AND ra = '-'
SELECT patient.id FROM patient INNER JOIN examination ON patient.id = examination.id WHERE patient.rf < 20 AND (YEAR('now') - YEAR(patient.birthday)) > 60; 
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN laboratory ON examination.id = laboratory.id WHERE examination.rf < 20 AND examination.thrombosis = '0';
SELECT COUNT(DISTINCT patient.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE examination.ana_pattern = 'P' AND laboratory.c3 > 35;
SELECT MAX(e.acl_iga) AS max_acl_iga FROM examination AS e JOIN patient AS p ON e.id = p.id JOIN laboratory AS l ON e.id = l.id WHERE l.hct NOT BETWEEN 29 AND 52;
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE thrombosis > 0 AND c4 > 10;
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id WHERE examination.rnp IN ('-', '+-') AND patient.admission = '+';
SELECT MAX(Birthday) AS "Date of Birth" FROM patient WHERE id IN (     SELECT id     FROM examination     WHERE rnp NOT IN ('-', '+-') );
SELECT COUNT(*) AS severe_thrombosis_count FROM     examination JOIN     patient ON examination.id = patient.id WHERE     sm = 'negative' AND     thrombosis = '1';
SELECT examination.id FROM examination JOIN patient ON examination.id = patient.id WHERE sm NOT IN ('-', '+-') ORDER BY birthday DESC LIMIT 3;
SELECT examination.id FROM examination INNER JOIN patient ON examination.id = patient.id WHERE examination."Examination Date" >= '1997-01-01' AND examination.sc170 = '-';
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     examination ON patient.id = examination.id WHERE     patient.sex = 'M'     AND examination.ssc170 = 'negative'     AND examination.symptoms LIKE '%vertigo%'
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN examination ON examination.id = patient.id WHERE examination.ssa IN ('-', '+-') AND strftime('%Y', patient."First Date") < '1990';
SELECT MIN(patient.id) FROM patient JOIN examination ON patient.id = examination.id WHERE examination.ssa NOT IN ('-', '+-')
SELECT COUNT(DISTINCT patient.id) FROM     examination JOIN     patient ON examination.id = patient.id WHERE     examination.diagnosis = 'SLE'     AND (examination.ssb = 'negative' OR examination.ssb = '0');
SELECT COUNT(DISTINCT examination.id) FROM     examination JOIN     patient ON examination.id = patient.id WHERE     ssb = 'negative'     AND symptoms IS NOT NULL;
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE centromea IN ('-', '+-')  AND ssb IN ('-', '+-') AND patient.sex = 'M';
SELECT patient.diagnosis FROM patient INNER JOIN examination ON patient.id = examination.id INNER JOIN laboratory ON patient.id = laboratory.id WHERE (laboratory.dna >= 8) 
SELECT COUNT(DISTINCT patient.id) FROM patient LEFT JOIN laboratory ON patient.id = laboratory.id LEFT JOIN examination ON patient.id = examination.id WHERE dna < 8 AND description IS NULL;
SELECT COUNT(DISTINCT patient.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE examination."dna-ii" > 8 AND patient.admission LIKE '+%';
SELECT 100.0 * COUNT(DISTINCT patient.id) / (SELECT COUNT(DISTINCT patient.id) FROM patient INNER JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.got >= 60 AND patient.diagnosis = 'SLE') AS percentage_abnormal_got_with_sle FROM patient INNER JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.got >= 60 AND patient.diagnosis = 'SLE';
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.got < 60;
SELECT MIN(patient.birthday) FROM     patient JOIN     laboratory ON patient.id = laboratory.id WHERE     laboratory.got >= 60;
SELECT  SELECT patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.gpt < 60 ORDER BY laboratory.gpt DESC LIMIT 3;
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.gpt < 60 AND patient.sex = 'M';
SELECT MIN(First Date) AS "First Recorded Date" FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE ldh < 500;
SELECT MAX(patient.first_date) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.ldh >= 500;
SELECT COUNT(patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE alp >= 300 AND admission = '+';
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.admission = '-' AND laboratory.alp < 300;
SELECT patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tp < 6.0; 
SELECT COUNT(*) FROM patient JOIN examination ON patient.id = examination.id JOIN laboratory ON patient.id = laboratory.id WHERE patient.diagnosis = 'SJS' AND laboratory.tp > 6.0 AND laboratory.tp < 8.5;
SELECT MAX(examination."examination date") AS "Examination Date" FROM examination JOIN laboratory ON examination.id = laboratory.id WHERE laboratory.alb > 3.5 AND laboratory.alb < 5.5;
SELECT COUNT(DISTINCT patient.id) AS Male_Patients_With_Normal_Albumin_And_Total_Protein FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.alb > 3.5 AND laboratory.alb < 5.5 AND laboratory.tp BETWEEN 6.0 AND 8.5;
SELECT MAX(acl_igg) AS "Highest ACL IgG Concentration", MAX(acl_igm) AS "Highest ACL IgM Concentration", MAX(acl_iga) AS "Highest ACL IgA Concentration" FROM examination WHERE examination.id IN (     SELECT patient.id     FROM patient     INNER JOIN laboratory ON patient.id = laboratory.id     WHERE patient.sex = 'F'     AND laboratory.ua <= 6.50 )
SELECT MAX(ana)  FROM examination  JOIN laboratory ON examination.id = laboratory.id  WHERE cre < 1.5 AND ana IS NOT NULL;
SELECT patient.id FROM patient JOIN examination ON patient.id = examination.id WHERE examination.acl_iga = (SELECT MAX(acl_iga) FROM examination) AND laboratory.cre < 1.5;
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE t_bil >= 2.0 AND ana_pattern LIKE '%P%';
SELECT MAX(ana) AS "Anti-Nucleus Antibody Concentration" FROM examination JOIN laboratory ON examination.id = laboratory.id WHERE t_bil < 2.0
SELECT COUNT(*) FROM patient JOIN laboratory ON patient.id = laboratory.id JOIN examination ON patient.id = examination.id WHERE laboratory.t_cho >= 250 AND examination.kct = '-';
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON examination.id = laboratory.id WHERE laboratory.t_cho < 250 AND examination.ana_pattern LIKE '%P%';
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE tg < 200 AND symptoms IS NOT NULL;
SELECT patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tg < 200 ORDER BY laboratory.tg DESC LIMIT 1; 
SELECT patient.id FROM patient LEFT JOIN examination ON patient.id = examination.id LEFT JOIN laboratory ON patient.id = laboratory.id WHERE examination.thrombosis = 0 AND laboratory.cpk < 250; 
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.cpk < 250 AND (examination.kct = '+' OR examination.rvvt = '+' OR examination.lac = '+');
SELECT MIN(patient.birthday) FROM     patient JOIN     laboratory ON patient.id = laboratory.id WHERE     laboratory.glu > 180;
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE glu < 180 AND thrombosis = 0;
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.admission LIKE '%+%' AND laboratory.wbc BETWEEN 3.5 AND 9.0;
SELECT COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE patient.diagnosis = 'SLE' AND laboratory.wbc BETWEEN 3.5 AND 9.0;
SELECT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE (laboratory.rbc < 3.5 OR laboratory.rbc > 6.0) AND patient.admission = '-'; 
SELECT COUNT(DISTINCT patient.id) FROM     patient JOIN     examination ON examination.id = patient.id WHERE     examination.plt > 100 AND examination.plt < 400     AND examination.symptoms IS NOT NULL;
SELECT platelet FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE patient.diagnosis = 'MCTD' AND laboratory.plt > 100 AND laboratory.plt < 400; 
SELECT AVG(pt) FROM     examination INNER JOIN     patient ON examination.id = patient.id INNER JOIN     laboratory ON patient.id = laboratory.id WHERE     patient.sex = 'M' AND     examination.pt < 14;
SELECT COUNT(DISTINCT patient.id) FROM patient JOIN examination ON patient.id = examination.id WHERE examination.thrombosis IN (1, 2) AND laboratory.pt < 14;
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Angela' AND member.last_name = 'Sanders';
SELECT COUNT(member.member_id) FROM member JOIN major ON member.link_to_major = major.major_id JOIN zip_code ON member.zip = zip_code.zip_code WHERE major.college = 'College of Engineering'
SELECT member.first_name || ' ' || member.last_name AS full_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.department = 'Art and Design Department';
SELECT COUNT(DISTINCT member.member_id) AS attended_students FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id WHERE event.event_name = 'Women\'s Soccer';
SELECT member.phone FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'Women\'s Soccer';
SELECT COUNT(member.member_id) FROM     event JOIN     attendance ON event.event_id = attendance.link_to_event JOIN     member ON attendance.link_to_member = member.member_id JOIN     major ON member.link_to_major = major.major_id JOIN     zip_code ON member.zip = zip_code.zip_code WHERE     event.event_name = 'Women\'s Soccer'     AND member.position = 'Student'     AND member.t_shirt_size = 'Medium';
SELECT event.event_name FROM event JOIN attendance ON event.event_id = attendance.link_to_event WHERE event.status = 'Open' GROUP BY event.event_id ORDER BY COUNT(attendance.link_to_member) DESC LIMIT 1;
SELECT college FROM member WHERE position = 'Vice President'
SELECT event.event_name FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id WHERE member.first_name = 'Maya' AND member.last_name = 'Mclean';
SELECT COUNT(DISTINCT event.event_id) FROM     event JOIN     attendance ON event.event_id = attendance.link_to_event JOIN     member ON attendance.link_to_member = member.member_id WHERE     member.first_name = 'Sacha' AND member.last_name = 'Harrison'     AND strftime('%Y', event.event_date) = '2019';
SELECT COUNT(event.event_id) FROM     event JOIN     attendance ON event.event_id = attendance.link_to_event WHERE     event.type = 'Meeting' GROUP BY     event.event_id HAVING     COUNT(attendance.link_to_member) > 10;
SELECT event.event_name FROM event JOIN attendance ON event.event_id = attendance.link_to_event GROUP BY event.event_id HAVING COUNT(attendance.link_to_member) > 20;
SELECT AVG(attendance) FROM (     SELECT COUNT(event.event_id) as total_meetings, COUNT(DISTINCT event.event_name) as unique_meetings     FROM event     WHERE type = 'Meeting' AND STRFTIME('%Y', event_date) = '2020' ) AS meeting_counts;
SELECT MAX(cost) AS most_expensive_item_spent FROM expense
SELECT COUNT(*) FROM     member JOIN     major ON member.link_to_major = major.major_id WHERE     major.major_name = 'Environmental Engineering';
SELECT member.first_name || ' ' || member.last_name AS full_name FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'Laugh Out Loud';
SELECT member.last_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Law and Constitutional Studies';
SELECT county FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE first_name = 'Sherri' AND last_name = 'Ramsey';
SELECT college.college FROM college INNER JOIN major ON college.college_id = major.college INNER JOIN member ON member.link_to_major = major.major_id WHERE member.first_name = 'Tyler' AND member.last_name = 'Hewitt';
SELECT SUM(income.amount) AS vice_president_funds FROM     income JOIN     member ON income.link_to_member = member.member_id WHERE     member.position = 'Vice President';
SELECT SUM(expense.cost) AS total_food_spent FROM   expense JOIN   budget ON expense.link_to_budget = budget.budget_id JOIN   event ON budget.link_to_event = event.event_id WHERE   event.event_name = 'September Meeting'   AND budget.category = 'Food';
SELECT zip_code.city, zip_code.state FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.position = 'President'
SELECT member.first_name || ' ' || member.last_name AS full_name FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE zip_code.state = 'Illinois';
SELECT SUM(expense.cost) AS total_spent_on_advertisement FROM     expense     JOIN member ON expense.link_to_member = member.member_id     JOIN event ON member.zip = event.location     JOIN budget ON budget.link_to_event = event.event_id WHERE     event.event_name = 'September Meeting'     AND budget.category = 'Advertisement';
SELECT major.department FROM major JOIN member ON member.link_to_major = major.major_id WHERE member.last_name = 'Pierce' AND member.first_name = 'Guidi'; 
SELECT SUM(amount) FROM budget INNER JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'October Speaker';
SELECT CASE      WHEN EXISTS (         SELECT 1         FROM expense         JOIN event ON expense.expense_date = event.event_date         WHERE event.event_name = 'October Meeting'         AND expense.expense_date = '2019-10-08'         AND expense.approved = 'false'     ) THEN 'No'     ELSE 'Yes' END AS expenses_approval_status; 
SELECT AVG(expense.cost) AS total_average_cost FROM expense JOIN member ON expense.link_to_member = member.member_id JOIN event ON expense.link_to_event = event.event_id WHERE member.first_name = 'Elijah' AND member.last_name = 'Allen' AND (strftime('%m', expense.expense_date) = '09' OR strftime('%m', expense.expense_date) = '10');
SELECT SUM(CASE WHEN strftime('%Y', event.event_date) = '2019' THEN budget.spent ELSE 0 END) - SUM(CASE WHEN strftime('%Y', event.event_date) = '2020' THEN budget.spent ELSE 0 END) AS difference_total_spent FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE strftime('%Y', event.event_date) IN ('2019', '2020')
SELECT event.location FROM event WHERE event.event_name = 'Spring Budget Review';
SELECT SUM(expense.cost) AS total_cost FROM     expense     JOIN budget ON expense.link_to_budget = budget.budget_id     JOIN event ON budget.link_to_event = event.event_id WHERE     expense.expense_description = 'Posters'     AND event.event_date = '2019-09-04' 
SELECT MAX(budget.remaining) FROM budget WHERE category = 'Food'
SELECT notes FROM income WHERE source = 'Fundraising' AND date_received = '2019-09-14';
SELECT COUNT(DISTINCT major_id)  FROM major  WHERE college = 'College of Humanities and Social Sciences'; 
SELECT member.phone FROM member WHERE member.first_name = 'Carlo' AND member.last_name = 'Jacobs'; 
SELECT county FROM     zip_code JOIN     member ON zip_code.zip_code = member.zip WHERE     member.first_name = 'Adela' AND member.last_name = 'O\'Gallagher';
SELECT COUNT(*)  FROM budget  JOIN event ON budget.link_to_event = event.event_id  WHERE event.event_name = 'November Meeting' AND budget.remaining < 0;
SELECT SUM(amount) FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event_name = 'September Speaker';
SELECT event.status FROM event JOIN expense ON event.event_id = expense.link_to_budget WHERE expense.expense_description = 'Post Cards, Posters' AND expense.expense_date = '2019-08-20';
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Brent' AND member.last_name = 'Thomason';
SELECT COUNT(member.member_id) FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Human Development and Family Studies' AND member.t_shirt_size = 'Large';
SELECT zip_code.type FROM     member JOIN     zip_code ON member.zip = zip_code.zip_code WHERE     member.first_name = 'Christof'     AND member.last_name = 'Nielson';
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'Vice President'
SELECT zip_code.short_state FROM     member JOIN     zip_code ON member.zip = zip_code.zip_code WHERE     member.first_name = 'Sacha' AND member.last_name = 'Harrison';
SELECT major.department FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'President';
SELECT income.date_received FROM income JOIN member ON income.link_to_member = member.member_id WHERE member.first_name = 'Connor' AND member.last_name = 'Hilton' AND income.source = 'Dues';
SELECT MIN(member.first_name || ' ' || member.last_name) FROM income JOIN member ON income.link_to_member = member.member_id WHERE income.source = 'Dues'
SELECT COUNT(b1.category)  FROM budget AS b1 JOIN event AS e1 ON b1.link_to_event = e1.event_id JOIN budget AS b2 ON b2.link_to_event = e1.event_id JOIN event AS e2 ON b2.link_to_event = e2.event_id WHERE e1.event_name = 'Yearly Kickoff' AND e2.event_name = 'October Meeting'  AND b1.category = 'Advertisement' AND b2.category = 'Advertisement'  AND b1.amount > b2.amount;
SELECT 100 * (SELECT SUM(b.amount) / (SELECT SUM(b2.amount) FROM budget b2 JOIN event e ON b2.link_to_event = e.event_id WHERE e.event_name = 'November Speaker') FROM budget b JOIN event e ON b.link_to_event = e.event_id WHERE b.category = 'Parking' AND e.event_name = 'November Speaker');
SELECT SUM(cost) AS total_pizza_cost FROM expense WHERE expense_description = 'Pizza';
SELECT COUNT(DISTINCT city) FROM zip_code WHERE county = 'Orange County' AND state = 'Virginia';
SELECT department FROM major WHERE college = 'College of Humanities and Social Sciences'; 
SELECT zip_code.city, zip_code.county, zip_code.state FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Amy' AND member.last_name = 'Firth';
SELECT expense.expense_description FROM   expense JOIN   budget ON expense.link_to_budget = budget.budget_id WHERE   budget.remaining = (     SELECT      MIN(remaining)     FROM       budget   );
SELECT member.first_name, member.last_name FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'October Meeting'; 
SELECT MAX(COUNT(major.college)) FROM member JOIN major ON member.link_to_major = major.major_id GROUP BY major.college
SELECT major.major_name FROM member JOIN zip_code ON member.zip = zip_code.zip_code JOIN major ON member.link_to_major = major.major_id WHERE member.phone = '809-555-3360';
SELECT event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event ORDER BY budget.amount DESC LIMIT 1;
SELECT expense.* FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.position = 'Vice President';
SELECT COUNT(DISTINCT member.member_id) AS attendance_count FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id WHERE event.event_name = 'Women\'s Soccer';
SELECT event_date FROM income JOIN member ON income.link_to_member = member.member_id WHERE member.first_name = 'Casey' AND member.last_name = 'Mason';
SELECT COUNT(DISTINCT member.member_id) FROM     member JOIN     zip_code ON member.zip = zip_code.zip_code WHERE     zip_code.state = 'Maryland';
SELECT COUNT(DISTINCT event.event_id) AS attended_events FROM attendance JOIN event ON attendance.link_to_event = event.event_id JOIN member ON attendance.link_to_member = member.member_id WHERE member.phone = '954-555-6240';
SELECT member.first_name || ' ' || member.last_name AS full_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.department = 'School of Applied Sciences, Technology and Education'; 
SELECT event.event_id, event.event_name, MAX(expense.cost / budget.amount) AS spend_to_budget_ratio FROM event INNER JOIN budget ON event.event_id = budget.link_to_event INNER JOIN expense ON budget.budget_id = expense.link_to_budget WHERE event.status = 'Closed' GROUP BY event.event_id ORDER BY spend_to_budget_ratio DESC LIMIT 1;
SELECT COUNT(member.member_id) FROM     member WHERE     member.position = 'President';
SELECT MAX(spent) AS highest_budget_spend FROM budget;
SELECT COUNT(*)  FROM event  WHERE type = 'Meeting' AND strftime('%Y', event_date) = '2020';
SELECT SUM(spent) AS total_food_spent FROM budget WHERE category = 'Food';
SELECT first_name || ' ' || last_name AS student_name FROM member JOIN attendance ON member.member_id = attendance.link_to_member GROUP BY member.member_id HAVING COUNT(attendance.link_to_event) > 7; 
SELECT member.first_name, member.last_name, member.email FROM member INNER JOIN attendance ON member.member_id = attendance.link_to_member INNER JOIN event ON attendance.link_to_event = event.event_id INNER JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Interior Design' AND event.event_name = 'Community Theater';
SELECT member.first_name, member.last_name FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE zip_code.city = 'Georgetown' AND zip_code.state = 'South Carolina';
SELECT COUNT(income.income_id) FROM     income JOIN     member ON income.link_to_member = member.member_id WHERE     member.first_name = 'Grant' AND member.last_name = 'Gilmour';
SELECT member.first_name || ' ' || member.last_name AS student_name FROM income JOIN member ON income.link_to_member = member.member_id WHERE income.amount > 40;
SELECT SUM(expense.cost) AS total_expense FROM expense JOIN event ON expense.link_to_budget = event.event_id WHERE event.event_name = 'Yearly Kickoff';
SELECT member.first_name, member.last_name FROM member JOIN budget ON member.member_id = budget.link_to_event JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'Yearly Kickoff';
SELECT member.first_name || ' ' || member.last_name AS student_name, income.source AS income_source FROM income JOIN member ON income.link_to_member = member.member_id WHERE income.amount = (SELECT MAX(amount) FROM income)
SELECT event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event GROUP BY event.event_name ORDER BY MIN(budget.amount) LIMIT 1;
SELECT (DIVIDE((SELECT SUM(expense.cost)  FROM expense  JOIN budget ON expense.link_to_budget = budget.budget_id  JOIN event ON budget.link_to_event = event.event_id  WHERE event.event_name = 'Yearly Kickoff'),  (SELECT SUM(expense.cost)  FROM expense  JOIN budget ON expense.link_to_budget = budget.budget_id))) * 100 as percentage_cost_yearly_kickoff;
SELECT CAST((SELECT COUNT(*) FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Finance') AS FLOAT) / CAST((SELECT COUNT(*) FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Physics') AS FLOAT); 
SELECT MAX(source) FROM income WHERE date_received BETWEEN '2019-09-01' AND '2019-09-30'
SELECT member.first_name || ' ' || member.last_name AS full_name, member.email FROM member WHERE member.position = 'Secretary';
SELECT COUNT(member.member_id) FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Physics Teaching';
SELECT COUNT(DISTINCT member.member_id) AS attended_members FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id WHERE event.event_name = 'Community Theater' AND strftime('%Y', event.event_date) = '2019';
SELECT COUNT(DISTINCT event.event_id) AS events_attended, major.major_name AS major FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Luisa' AND member.last_name = 'Guidi';
SELECT ROUND(DIVIDE(SUM(expense.cost), COUNT(DISTINCT event.event_id)), 2) AS average_food_expense FROM     expense JOIN     budget ON expense.link_to_budget = budget.budget_id JOIN     event ON budget.link_to_event = event.event_id WHERE     budget.category = 'Food'     AND event.status = 'Closed';
SELECT event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.category = 'Advertisement' ORDER BY budget.spent DESC LIMIT 1;
SELECT CASE      WHEN EXISTS (         SELECT 1         FROM member         JOIN attendance ON member.member_id = attendance.link_to_member         JOIN event ON attendance.link_to_event = event.event_id         WHERE member.first_name = 'Maya'          AND member.last_name = 'Mclean'          AND event.event_name = 'Women\'s Soccer'     )     THEN 'Yes'     ELSE 'No' END;
SELECT ((SELECT COUNT(*) FROM event WHERE type = 'Community Service' AND event_date BETWEEN '2019-01-01' AND '2019-12-31') * 100.0) / (SELECT COUNT(*) FROM event WHERE event_date BETWEEN '2019-01-01' AND '2019-12-31') AS percentage_share_community_service;
SELECT SUM(expense.cost) FROM     expense JOIN     event ON expense.link_to_event = event.event_id WHERE     event.event_name = 'September Speaker'     AND expense.expense_description = 'Posters';
SELECT MAX(t_shirt_size) AS most_popular_t_shirt_size FROM   member
SELECT event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE event.status = 'Closed' AND budget.remaining < 0 ORDER BY budget.remaining LIMIT 1;
SELECT expense.expense_description, SUM(expense.cost) AS total_approved_value FROM expense JOIN budget ON expense.link_to_budget = budget.budget_id JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'October Meeting' GROUP BY expense.expense_description; 
SELECT category, SUM(amount) AS total_budget FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'April Speaker' GROUP BY category ORDER BY total_budget ASC; 
SELECT MAX(amount) FROM budget WHERE category = 'Food'
SELECT budget_id, category, MAX(amount) AS max_budget_amount FROM budget WHERE category = 'Advertising' GROUP BY budget_id ORDER BY max_budget_amount DESC LIMIT 3;
SELECT SUM(cost) FROM expense WHERE expense_description = 'Parking';
SELECT SUM(cost) AS total_expense FROM expense WHERE expense_date = '2019-08-20';
SELECT member.first_name || ' ' || member.last_name AS full_name, SUM(expense.cost) AS total_cost FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE member.member_id = 'rec4BLdZHS2Blfp4v';
SELECT expense.expense_description FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.first_name = 'Sacha' AND member.last_name = 'Harrison';
SELECT expense.expense_description FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.t_shirt_size = 'X-Large';
SELECT member.zip FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE expense.cost < 50;
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Phillip' AND member.last_name = 'Cullen';
SELECT member.position FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Business';
SELECT COUNT(member.member_id) FROM     member JOIN     major ON member.link_to_major = major.major_id WHERE     major.major_name = 'Business'     AND member.t_shirt_size = 'Medium';
SELECT event.type FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.remaining > 30;
SELECT budget.category FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE event.location = 'MU 215';
SELECT budget.category FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE event.event_date = '2020-03-24T12:00:00';
SELECT major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'Vice President';
SELECT DIVIDE(SUM(CASE WHEN member.position = 'Member' AND major.major_name = 'Mathematics' THEN 1 ELSE 0 END), COUNT(member.member_id)) * 100 AS percentage_mathematics_members
SELECT budget.category FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.location = 'MU 215';
SELECT COUNT(*) FROM income WHERE amount = 50;
SELECT COUNT(*) FROM     member WHERE     position = 'Member'     AND t_shirt_size = 'X-Large';
SELECT COUNT(major_id)  FROM major  WHERE department = 'School of Applied Sciences, Technology and Education'  AND college = 'College of Agriculture and Applied Sciences'; 
SELECT member.last_name, major.department, major.college FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Environmental Engineering';
SELECT budget.category FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE event.location = 'MU 215' AND event.type = 'Guest Speaker' AND budget.spent = 0;
SELECT zip_code.city, zip_code.state FROM member JOIN major ON member.link_to_major = major.major_id JOIN zip_code ON member.zip = zip_code.zip_code WHERE major.department = 'Electrical and Computer Engineering Department' AND member.position = 'Member'; 
SELECT event.event_name FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id WHERE event.type = 'Social' AND member.position = 'Vice President' AND event.location = '900 E. Washington St.';
SELECT member.last_name, member.position FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE expense.expense_description = 'Pizza' AND expense.expense_date = '2019-09-10';
SELECT member.last_name FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'Women\'s Soccer' AND member.position = 'Member';
SELECT 100 * COUNT(CASE WHEN m.t_shirt_size = 'Medium' AND i.amount = 50 THEN 1 END) / COUNT(m.member_id) FROM member m JOIN income i ON m.member_id = i.link_to_member WHERE m.position = 'Member';
SELECT DISTINCT state FROM zip_code WHERE type = 'PO Box';
SELECT zip_code FROM zip_code WHERE county = 'San Juan Municipio' AND state = 'Puerto Rico' AND type = 'PO Box';
SELECT event.event_name FROM event WHERE event.type = 'Game' AND event.status = 'Closed' AND event.event_date BETWEEN '2019-03-15' AND '2020-03-20';
SELECT event.event_id, event.event_name FROM expense JOIN member ON expense.link_to_member = member.member_id JOIN event ON expense.link_to_budget = event.event_id WHERE expense.cost > 50;
SELECT member.first_name, member.last_name, event.event_name AS attended_event, attendance.link_to_event AS event_link FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id JOIN expense ON member.member_id = expense.link_to_member WHERE expense.approved = 'true' AND expense.expense_date BETWEEN '2019-01-10' AND '2019-11-19'; 
SELECT major.college FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Katy' AND member.link_to_major = 'rec1N0upiVLy5esTO'; 
SELECT member.phone FROM member JOIN major ON member.link_to_major = major.major_id JOIN zip_code ON member.zip = zip_code.zip_code WHERE major.major_name = 'Business' AND major.college = 'College of Agriculture and Applied Sciences';
SELECT member.email FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE expense_date BETWEEN '2019-09-10' AND '2019-11-19' AND cost > 20;
SELECT COUNT(member.member_id) FROM member JOIN major ON member.link_to_major = major.major_id JOIN zip_code ON member.zip = zip_code.zip_code WHERE major.major_name = 'Education' AND major.college = 'College of Education & Human Services';
SELECT 100 * SUM(CASE WHEN budget.remaining < 0 THEN 1 ELSE 0 END) / COUNT(DISTINCT event.event_id) AS percentage_of_events_over_budget FROM budget JOIN event ON budget.link_to_event = event.event_id;
SELECT event.event_id, event.location, event.status FROM event WHERE event.event_date BETWEEN '2019-11-01' AND '2020-03-31';
SELECT expense_description FROM expense GROUP BY expense_description HAVING AVG(cost) > 50; 
SELECT member.first_name || ' ' || member.last_name AS full_name FROM member WHERE member.t_shirt_size = 'X-Large';
SELECT 100 * (SELECT COUNT(*) FROM zip_code WHERE type = 'PO Box') / (SELECT COUNT(*) FROM zip_code) AS percentage_of_po_boxes;
SELECT event.event_name, event.location FROM event INNER JOIN budget ON event.event_id = budget.link_to_event WHERE budget.remaining > 0;
SELECT event.event_name, event.event_date FROM event JOIN expense ON event.event_id = expense.link_to_budget WHERE expense.expense_description = 'Pizza' AND expense.cost > 50 AND expense.cost < 100;
SELECT member.first_name, member.last_name, major.major_name FROM member JOIN major ON member.link_to_major = major.major_id JOIN expense ON member.member_id = expense.link_to_member WHERE expense.cost > 100;
SELECT event.location, zip_code.city, zip_code.state, zip_code.country FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN income ON attendance.link_to_member = income.link_to_member JOIN zip_code ON event.location = zip_code.zip_code GROUP BY event.event_id HAVING COUNT(DISTINCT income.income_id) > 40;
SELECT member.first_name, member.last_name, MAX(expense.cost) AS max_expense_amount FROM member JOIN expense ON member.member_id = expense.link_to_member GROUP BY member.member_id HAVING COUNT(DISTINCT expense.link_to_event) > 1;
SELECT DIVIDE(SUM(expense.cost), COUNT(DISTINCT expense.link_to_event)) FROM     expense JOIN     member ON expense.link_to_member = member.member_id WHERE     member.position != 'Member';
SELECT event.event_name FROM event INNER JOIN budget ON event.event_id = budget.link_to_event INNER JOIN expense ON budget.budget_id = expense.link_to_budget WHERE expense.category = 'Parking' GROUP BY event.event_id HAVING expense.cost < (     SELECT        AVG(parking_cost)     FROM         (             SELECT                event.event_id,                 SUM(expense.cost) AS parking_cost             FROM                 event             INNER JOIN budget ON event.event_id = budget.link_to_event             INNER JOIN expense ON budget.budget_id = expense.link_to_budget             WHERE                 expense.category = 'Parking'             GROUP BY                 event.event_id         ) );
SELECT ROUND(   (     SUM(CASE WHEN event.type = 'Game' THEN expense.cost ELSE 0 END) /     COUNT(CASE WHEN event.type = 'Game' THEN event.event_id ELSE NULL END)   ) * 100,    2 ) AS percentage_cost_game_events
SELECT budget.budget_id, MAX(expense.cost) AS max_expense FROM budget JOIN expense ON budget.budget_id = expense.link_to_budget WHERE expense.expense_description = 'Water, chips, cookies' GROUP BY budget.budget_id;
SELECT member.first_name || ' ' || member.last_name AS full_name FROM     member JOIN     expense ON member.member_id = expense.link_to_member GROUP BY     member.member_id ORDER BY     MAX(expense.cost) DESC LIMIT 5;
SELECT member.first_name || ' ' || member.last_name AS full_name, member.phone AS contact_number FROM member INNER JOIN expense ON member.member_id = expense.link_to_member WHERE expense.cost > (SELECT AVG(cost) FROM expense)
SELECT 100 * (     (         (SELECT COUNT(*) FROM member WHERE zip IN (SELECT zip_code FROM zip_code WHERE state = 'Maine')) /         (SELECT COUNT(*) FROM member WHERE position = 'Member')     ) -     (         (SELECT COUNT(*) FROM member WHERE zip IN (SELECT zip_code FROM zip_code WHERE state = 'Vermont')) /         (SELECT COUNT(*) FROM member WHERE position = 'Member')     ) ) AS percentage_difference;
SELECT major.major_name, major.department FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Garrett' AND member.last_name = 'Gerke';
SELECT member.first_name || ' ' || member.last_name AS full_name, expense.cost AS spent_amount FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE expense.expense_description = 'Water, Veggie tray, supplies';
SELECT member.last_name, member.phone FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Elementary Education';
SELECT budget.category, budget.amount FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'January Speaker'; 
SELECT event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.category = 'Food'; 
SELECT member.first_name || ' ' || member.last_name AS full_name, income.amount AS received_funds FROM income JOIN member ON income.link_to_member = member.member_id WHERE income.date_received = '2019-09-09';
SELECT budget.category FROM expense JOIN budget ON expense.link_to_budget = budget.budget_id WHERE expense.expense_description = 'Posters';
SELECT member.first_name || ' ' || member.last_name AS full_name, major.college FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'Secretary';
SELECT event.event_name, SUM(budget.spent) AS total_amount_spent FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE budget.category = 'Speaker Gifts' GROUP BY event.event_name; 
SELECT city FROM     member JOIN     zip_code ON member.zip = zip_code.zip_code WHERE     member.first_name = 'Garrett' AND member.last_name = 'Girke';
SELECT member.first_name, member.last_name, member.position FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE zip_code.city = 'Lincolnton' AND zip_code.state = 'North Carolina' AND zip_code.zip_code = '28092';
SELECT COUNT(DISTINCT gasstationid) FROM gasstations WHERE country = 'CZE' AND segment = 'Premium';
SELECT COUNT(CASE WHEN currency = 'EUR' THEN customerid END) * 1.0 / COUNT(CASE WHEN currency = 'CZK' THEN customerid END) as ratio FROM customers;
SELECT customers.customerid, SUM(yearmonth.consumption) AS total_consumption FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.segment = 'LAM' AND yearmonth.date BETWEEN '201201' AND '201212' GROUP BY customers.customerid ORDER BY total_consumption ASC LIMIT 1;
SELECT AVG(consumption) / 12 AS average_monthly_consumption FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE segment = 'SME' AND date BETWEEN 201301 AND 201312;
SELECT customers.customerid, SUM(transactions_1k.amount) AS total_consumption FROM customers JOIN transactions_1k ON customers.customerid = transactions_1k.customerid JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE customers.currency = 'CZK' AND transactions_1k.date BETWEEN '201101' AND '201112' GROUP BY customers.customerid ORDER BY total_consumption DESC;
SELECT COUNT(DISTINCT customers.customerid) FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.segment = 'KAM' AND yearmonth.date BETWEEN 201201 AND 201212 AND yearmonth.consumption < 30000;
SELECT SUM(CASE WHEN customers.currency = 'CZK' THEN yearmonth.consumption ELSE 0 END) - SUM(CASE WHEN customers.currency = 'EUR' THEN yearmonth.consumption ELSE 0 END) AS consumption_difference FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE yearmonth.date BETWEEN '201201' AND '201212';
SELECT MAX(strftime('%Y', date)) AS year FROM transactions_1k WHERE currency = 'EUR'
SELECT segment, SUM(consumption) AS total_consumption FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid GROUP BY segment ORDER BY total_consumption ASC LIMIT 1; 
SELECT MAX(substr(date, 1, 4)) AS year FROM yearmonth JOIN transactions_1k ON yearmonth.customerid = transactions_1k.customerid JOIN customers ON transactions_1k.customerid = customers.customerid WHERE currency = 'CZK'
SELECT MAX(yearmonth.consumption) AS max_consumption, SUBSTR(yearmonth.date, 5, 2) AS month FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE customers.segment = 'SME' AND SUBSTR(yearmonth.date, 1, 4) = '2013' GROUP BY SUBSTR(yearmonth.date, 5, 2)
SELECT AVG((SELECT SUM(consumption) FROM yearmonth WHERE customerid IN (SELECT customerid FROM yearmonth WHERE substr(date, 1, 4) = '2013' GROUP BY segment ORDER BY MIN(consumption) LIMIT 1) AND substr(date, 1, 4) = '2013')) - AVG((SELECT SUM(consumption) FROM yearmonth WHERE customerid IN (SELECT customerid FROM yearmonth WHERE substr(date, 1, 4) = '2013' AND segment = 'LAM' GROUP BY segment ORDER BY MIN(consumption) LIMIT 1) AND substr(date, 1, 4) = '2013')),  AVG((SELECT SUM(consumption) FROM yearmonth WHERE customerid IN (SELECT customerid FROM yearmonth WHERE substr(date, 1, 4) = '2013' AND segment = 'LAM' GROUP BY segment ORDER BY MIN(consumption) LIMIT 1) AND substr(date, 1, 4) = '2013')) - AVG((SELECT SUM(consumption) FROM yearmonth WHERE customerid IN (SELECT customerid FROM yearmonth WHERE substr(date, 1, 4) = '2013' AND segment = 'KAM' GROUP BY segment ORDER BY MIN(consumption) LIMIT 1) AND substr(date, 1, 4) = '2013')),  AVG((SELECT SUM(consumption) FROM yearmonth WHERE customerid IN (SELECT customerid FROM yearmonth WHERE substr(date, 1, 4) = '2013' AND segment = 'KAM' GROUP BY segment ORDER BY MIN(consumption) LIMIT 1) AND substr(date, 1, 4) = '2013')) - AVG((SELECT SUM(consumption) FROM yearmonth WHERE customerid IN (SELECT customerid FROM yearmonth WHERE substr(date, 1, 4) = '2013' AND segment = 'SME' GROUP BY segment ORDER BY MIN(consumption) LIMIT 1) AND substr(date, 1, 4) = '2013'))   FROM yearmonth;
SELECT MAX((yearmonth_2013.consumption - yearmonth_2012.consumption) / yearmonth_2013.consumption * 100) AS max_increase_percentage, MIN((yearmonth_2013.consumption - yearmonth_2012.consumption) / yearmonth_2013.consumption * 100) AS min_increase_percentage, CASE     WHEN segment = 'SME' THEN 'SME'     WHEN segment = 'LAM' THEN 'LAM'     ELSE 'KAM' END AS segment FROM (     SELECT        customers.segment AS segment,         SUM(CASE WHEN yearmonth.date LIKE '2012%' THEN yearmonth.consumption ELSE 0 END) AS consumption_2012,         SUM(CASE WHEN yearmonth.date LIKE '2013%' THEN yearmonth.consumption ELSE 0 END) AS consumption_2013     FROM customers     JOIN yearmonth ON customers.customerid = yearmonth.customerid     WHERE customers.currency = 'EUR'     GROUP BY customers.segment ) AS segment_consumption JOIN yearmonth AS yearmonth_2012 ON yearmonth_2012.customerid = segment_consumption.customerid JOIN yearmonth AS yearmonth_2013 ON yearmonth_2013.customerid = segment_consumption.customerid WHERE yearmonth_2012.date LIKE '2012%' AND yearmonth_2013.date LIKE '2013%';
SELECT SUM(amount) FROM transactions_1k WHERE customerid = 6 AND date BETWEEN '201308' AND '201311';
SELECT COUNT(DISTINCT CASE     WHEN g.country = 'CZE' AND g.segment = 'Discount' THEN g.gasstationid     ELSE NULL END) - COUNT(DISTINCT CASE     WHEN g.country = 'SVK' AND g.segment = 'Discount' THEN g.gasstationid     ELSE NULL END) AS more_discount_gas_stations FROM gasstations g;
SELECT SUM(yearmonth.consumption) AS consumption_difference FROM     yearmonth JOIN     customers ON yearmonth.customerid = customers.customerid WHERE     customers.customerid = 7     AND yearmonth.date = 201304 UNION ALL SELECT    SUM(yearmonth.consumption) AS consumption_difference FROM     yearmonth JOIN     customers ON yearmonth.customerid = customers.customerid WHERE     customers.customerid = 5     AND yearmonth.date = 201304;
SELECT COUNT(DISTINCT CASE WHEN segment = 'SME' AND currency = 'CZK' THEN customerid END) - COUNT(DISTINCT CASE WHEN segment = 'SME' AND currency = 'EUR' THEN customerid END) AS difference FROM customers;
SELECT MAX(consumption) FROM     yearmonth JOIN     customers ON yearmonth.customerid = customers.customerid WHERE     segment = 'LAM'     AND currency = 'EUR'     AND date = '201310';
SELECT customers.customerid, SUM(yearmonth.consumption) AS total_consumption FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.segment = 'KAM' GROUP BY customers.customerid ORDER BY total_consumption DESC LIMIT 1; 
SELECT SUM(yearmonth.consumption) AS total_consumption FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE customers.segment = 'KAM' AND yearmonth.date = '201305'; 
SELECT 100.0 * (     SELECT COUNT(*)     FROM yearmonth     JOIN customers ON yearmonth.customerid = customers.customerid     WHERE customers.segment = 'LAM' AND yearmonth.consumption > 46.73 ) / (     SELECT COUNT(*)     FROM customers     WHERE segment = 'LAM' ) AS percentage;
SELECT gasstations.country, COUNT(gasstations.gasstationid) AS num_value_for_money_gas_stations FROM gasstations WHERE gasstations.segment = 'Value for money' GROUP BY gasstations.country; 
SELECT (CAST((SELECT COUNT(*) FROM customers WHERE segment = 'KAM' AND currency = 'EUR') AS REAL) / CAST((SELECT COUNT(*) FROM customers WHERE segment = 'KAM') AS REAL)) * 100 AS percentage_KAM_EUR;
SELECT ROUND(     (COUNT(DISTINCT yearmonth.customerid) * 1.0 / (SELECT COUNT(DISTINCT customerid) FROM yearmonth WHERE date LIKE '201202')) * 100, 2 ) AS percentage_consumers FROM yearmonth WHERE date = '201202' AND consumption > 528.3;
SELECT ROUND((COUNT(CASE WHEN gasstations.segment = 'Premium' AND gasstations.country = 'SVK' THEN 1 END) * 1.0 / COUNT(CASE WHEN gasstations.country = 'SVK' THEN 1 END)) * 100, 2) AS percentage_of_premium_gas_stations_in_Slovakia FROM gasstations WHERE gasstations.country = 'SVK';
SELECT customers.customerid FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE yearmonth.date = '201309' ORDER BY yearmonth.consumption DESC LIMIT 1;
SELECT segment, SUM(consumption) AS total_consumption FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE date = '201309' GROUP BY segment ORDER BY total_consumption LIMIT 1;
SELECT customers.customerid, MIN(yearmonth.consumption) AS min_consumption FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.segment = 'SME' AND yearmonth.date = '201206' GROUP BY customers.customerid ORDER BY min_consumption LIMIT 1;
SELECT MAX(consumption) AS highest_monthly_consumption FROM yearmonth WHERE date LIKE '2012%'
SELECT MAX(total_monthly_consumption) AS biggest_monthly_consumption FROM (     SELECT        SUM(y.consumption) / 12 AS total_monthly_consumption     FROM         yearmonth y     JOIN         customers c ON y.customerid = c.customerid     WHERE         c.currency = 'EUR'     GROUP BY         y.customerid ) AS monthly_consumptions;
SELECT products.description FROM transactions_1k JOIN products ON transactions_1k.productid = products.productid WHERE transactions_1k.date LIKE '201309%'
SELECT DISTINCT gasstations.country FROM     transactions_1k JOIN     gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE     substr(transactions_1k.date, 1, 6) = '201306';
SELECT DISTINCT gasstations.chainid FROM   gasstations JOIN   transactions_1k ON gasstations.gasstationid = transactions_1k.gasstationid JOIN   customers ON transactions_1k.customerid = customers.customerid WHERE   customers.currency = 'EUR'; 
SELECT products.description FROM transactions_1k JOIN products ON transactions_1k.productid = products.productid JOIN customers ON transactions_1k.customerid = customers.customerid WHERE customers.currency = 'EUR';
SELECT AVG(price * amount) AS average_total_price FROM transactions_1k WHERE date LIKE '2012-01%'
SELECT COUNT(DISTINCT customers.customerid) FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.currency = 'EUR' AND yearmonth.consumption > 1000;
SELECT products.description FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid JOIN products ON transactions_1k.productid = products.productid WHERE gasstations.country = 'CZE';
SELECT DISTINCT time FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE chainid = 11; 
SELECT COUNT(*) FROM     transactions_1k JOIN     gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE     gasstations.country = 'CZE' AND transactions_1k.price > 1000;
SELECT COUNT(*) FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE gasstations.country = 'CZE' AND date > '2012-01-01';
SELECT AVG(price * amount) AS average_total_price FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE gasstations.country = 'CZE';
SELECT AVG(total_price) AS average_total_price FROM (     SELECT SUM(price) AS total_price     FROM transactions_1k     WHERE customerid IN (SELECT customerid FROM customers WHERE currency = 'EUR')     GROUP BY customerid ) euro_transactions; 
SELECT customers.customerid FROM transactions_1k JOIN customers ON transactions_1k.customerid = customers.customerid WHERE transactions_1k.date = '2012-08-25' ORDER BY transactions_1k.price DESC LIMIT 1;
SELECT gasstations.country FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE transactions_1k.date = '2012-08-25' ORDER BY transactions_1k.time LIMIT 1;
SELECT currency FROM     customers     JOIN transactions_1k ON customers.customerid = transactions_1k.customerid WHERE     transactions_1k.date = '2012-08-24'     AND transactions_1k.time = '16:25:00';
SELECT customers.segment FROM customers JOIN transactions_1k AS T1 ON customers.customerid = T1.customerid WHERE T1.date = '2012-08-23' AND T1.time = '21:20:00';
SELECT COUNT(*) FROM transactions_1k WHERE date = '2012-08-26' AND time < '13:00:00' AND currency = 'EUR';
SELECT segment FROM customers ORDER BY customerid ASC LIMIT 1; 
SELECT gasstations.country FROM transactions_1k AS T1 INNER JOIN gasstations ON T1.gasstationid = gasstations.gasstationid WHERE T1.date = '2012-08-24' AND T1.time = '12:42:00';
SELECT products.productid FROM transactions_1k AS T1 JOIN products ON T1.productid = products.productid WHERE T1.date = '2012-08-23' AND T1.time = '21:20:00';
SELECT SUM(transactions_1k.amount) AS january_expense,     yearmonth.date AS date,     yearmonth.consumption AS expenses FROM     transactions_1k JOIN     yearmonth ON transactions_1k.customerid = yearmonth.customerid WHERE     transactions_1k.customerid = (         SELECT            customerid         FROM             transactions_1k         WHERE             date = '2012-08-24'             AND amount = 124.05         LIMIT 1     )     AND yearmonth.date LIKE '201201%' GROUP BY     transactions_1k.customerid;
SELECT COUNT(*) FROM transactions_1k AS t JOIN gasstations AS g ON t.gasstationid = g.gasstationid WHERE t.date = '2012-08-26' AND t.time BETWEEN '08:00:00' AND '09:00:00' AND g.country = 'CZE';
SELECT currency FROM     customers WHERE     customerid = (         SELECT            customerid         FROM             yearmonth         WHERE             date = '201306'             AND consumption = 214582.17     )
SELECT gasstations.country FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE transactions_1k.cardid = 667467 LIMIT 1;
SELECT customers.country FROM customers JOIN transactions_1k ON customers.customerid = transactions_1k.customerid WHERE transactions_1k.date = '2012-08-24' AND transactions_1k.amount = 548.4;
SELECT ROUND((COUNT(DISTINCT customers.customerid) * 100.0) / (SELECT COUNT(DISTINCT customers.customerid) FROM customers INNER JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE yearmonth.date = '201208'), 2) AS percentage FROM customers INNER JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE yearmonth.date = '201208' AND customers.currency = 'EUR';
SELECT ROUND((y2012.consumption - y2013.consumption) / y2012.consumption, 2) AS decrease_rate FROM (     SELECT        c.customerid,         y.consumption     FROM         yearmonth y     JOIN         customers c ON y.customerid = c.customerid     WHERE         y.date LIKE '2012%'         AND c.customerid = (             SELECT                customerid             FROM                 transactions_1k             WHERE                 date = '2012-08-25'                 AND price = 634.8             LIMIT 1         ) ) y2012 JOIN (     SELECT        c.customerid,         y.consumption     FROM         yearmonth y     JOIN         customers c ON y.customerid = c.customerid     WHERE         y.date LIKE '2013%'         AND c.customerid = (             SELECT                customerid             FROM                 transactions_1k             WHERE                 date = '2012-08-25'                 AND price = 634.8             LIMIT 1         ) ) y2013 ON y2012.customerid = y2013.customerid;
SELECT gasstationid, SUM(amount * price) AS revenue FROM transactions_1k GROUP BY gasstationid ORDER BY revenue DESC LIMIT 1; 
SELECT ROUND(     (SELECT COUNT(*)      FROM transactions_1k AS t     JOIN gasstations AS g ON t.gasstationid = g.gasstationid     WHERE g.segment = 'Premium' AND g.country = 'SVK'     ) * 100.0 /     (SELECT COUNT(*)      FROM transactions_1k AS t     JOIN gasstations AS g ON t.gasstationid = g.gasstationid     WHERE g.country = 'SVK') , 2) AS percentage; 
SELECT SUM(transactions_1k.amount) AS total_spent FROM transactions_1k JOIN customers ON transactions_1k.customerid = customers.customerid WHERE customers.customerid = '38508' AND transactions_1k.date LIKE '201201%'
SELECT products.description, SUM(transactions_1k.amount) AS total_amount_sold FROM transactions_1k INNER JOIN products ON transactions_1k.productid = products.productid GROUP BY transactions_1k.productid ORDER BY total_amount_sold DESC LIMIT 5; 
SELECT customers.customerid, SUM(transactions_1k.price) AS total_spending, AVG(transactions_1k.price / transactions_1k.amount) AS average_price_per_item, customers.currency FROM customers JOIN transactions_1k ON customers.customerid = transactions_1k.customerid GROUP BY customers.customerid ORDER BY total_spending DESC LIMIT 1; 
SELECT country FROM gasstations WHERE gasstationid = (     SELECT gasstationid     FROM transactions_1k     WHERE productid = 2     ORDER BY price DESC     LIMIT 1 ) 
SELECT yearmonth.consumption FROM     yearmonth JOIN     transactions_1k ON yearmonth.customerid = transactions_1k.customerid WHERE     transactions_1k.date LIKE '201208%'     AND transactions_1k.price / transactions_1k.amount > 29.00     AND transactions_1k.productid = 5;
