SELECT  MAX(frpm."percent (%) eligible free (k-12)") FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.county = 'Alameda';
SELECT  percent (%) eligible free (ages 5-17) FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.edopsname = 'Continuation School' ORDER BY percent (%) eligible free (ages 5-17) LIMIT 3; 
SELECT  DISTINCT schools.zip FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE frpm.charter_school = 1 AND schools.district = 'Fresno County Office of Education'; 
SELECT  schools.mailstreet || ' ' || schools.mailcity || ', ' || schools.mailstate || ' ' || schools.mailzip AS mailing_address FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE frpm.enrollment_k_12 = (     SELECT MAX(enrollment_k_12)      FROM frpm ) 
SELECT  phone FROM schools INNER JOIN frpm ON schools.cdscode = frpm.cdscode WHERE frpm.charter = '1' AND schools.opendate > '2000-01-01' AND schools.fundingtype = 'Directly funded'; 
SELECT  COUNT(DISTINCT schools.cdscode) FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE satscores.avgscrmath < 400 AND schools.virtual = 'F' 
SELECT  schools.school FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.numtsttakr > 500 AND schools.magnet = 1; 
SELECT  phone FROM schools WHERE cdscode = (     SELECT cds     FROM satscores     WHERE numge1500 = (         SELECT MAX(numge1500)         FROM satscores         WHERE avgscrread + avgscrmath + avgscrwrite > 1500     ) ); 
SELECT  satscores.numtsttakr FROM satscores JOIN frpm ON satscores.cds = frpm.cdscode JOIN schools ON frpm.cdscode = schools.cdscode WHERE frpm.frpmcount = (     SELECT MAX(frpmcount)     FROM frpm ) AND schools.gsoffered = 'K-12'; 
SELECT  COUNT(*) FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.avgscrmath > 560 AND schools.fundingtype = 'Charter funded'; 
SELECT  frpm."frpm count (ages 5-17)" FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE satscores.avgscrread = (     SELECT MAX(avgscrread) FROM satscores ) 
SELECT  schools.cdscode FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode WHERE (frpm.enrollment + frpm.enrollment_ages_5_17) > 500 
SELECT MAX(percent_eligible_free_5_17) FROM (     SELECT percent_eligible_free_5_17     FROM frpm     JOIN schools ON frpm.cdscode = schools.cdscode     JOIN satscores ON satscores.cds = schools.cdscode     WHERE satscores.numge1500 / satscores.numtsttakr > 0.3 ); 
SELECT  schools.phone FROM     schools JOIN     satscores ON schools.cdscode = satscores.cds ORDER BY     CAST(satscores.numge1500 AS FLOAT) / CAST(satscores.numtsttakr AS FLOAT) DESC LIMIT 3;
SELECT  schools.ncesschool FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode ORDER BY frpm.enrollment DESC LIMIT 5; 
SELECT  schools.district, AVG(satscores.avgscrread) AS avg_reading_score FROM schools JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.statustype = 'Active' GROUP BY schools.district ORDER BY avg_reading_score DESC LIMIT 1; 
SELECT  COUNT(*) FROM schools WHERE schools.county = 'Alameda' AND schools.statustype = 'Merged' AND schools.cdscode IN (     SELECT satscores.cds     FROM satscores     WHERE satscores.numtsttakr < 100 ); 
SELECT  schools.charternum FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.avgscrwrite = 499; 
SELECT  COUNT(*)  FROM schools  WHERE county = 'Contra Costa'  AND fundingtype = 'Directly funded'  AND numtsttakr <= 250; 
SELECT  schools.phone FROM schools JOIN satscores ON schools.cdscode = satscores.cdscode WHERE satscores.avgscrmath = (     SELECT MAX(avgscrmath)     FROM satscores ); 
SELECT  COUNT(*)  FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.county = 'Amador' AND frpm.low_grade = '9' AND frpm.high_grade = '12'; 
SELECT  COUNT(*)  FROM schools  JOIN frpm ON schools.cdscode = frpm.cdscode  WHERE county = 'Los Angeles'  AND free_meal_count_k_12 > 500  AND free_meal_count_k_12 < 700; 
SELECT  sname FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE cname = 'Contra Costa' ORDER BY numtsttakr DESC LIMIT 1; 
SELECT  schools.school, schools.street || ', ' || schools.city || ', ' || schools.state || ', ' || schools.zip AS full_address FROM schools WHERE ABS(schools.enrollment - schools.enrollment_ages_5_17) > 30; 
SELECT  schools.school FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE frpm.percent_eligible_free > 0.1 AND satscores.numge1500 > 0; 
SELECT  schools.school, schools.fundingtype FROM schools JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.county = 'Riverside' GROUP BY schools.school HAVING AVG(satscores.avgscrmath) > 400; 
SELECT  school.school, school.mailstreet || ', ' || school.mailcity || ', ' || school.mailstate || ', ' || school.mailzip AS full_address FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode WHERE frpm.percent_eligible_frpm_ages_5_17 > 0.800 AND frpm.free_meal_count_ages_5_17 > 800 AND schools.county = 'Monterey' AND schools.gsserved LIKE '%12%'
SELECT  schools.school, satscores.avgscrwrite, schools.phone FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE (schools.opendate > '1991-01-01' OR schools.closeddate < '2000-01-01')  AND satscores.avgscrwrite IS NOT NULL; 
SELECT  schools.school, schools.doctype FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.fundingtype = 'Locally funded' GROUP BY schools.school, schools.doctype HAVING AVG(schools.enrollment) - AVG(schools.enrollment_ages_5_17) > (     SELECT AVG(enrollment_difference)     FROM (         SELECT AVG(schools.enrollment) - AVG(schools.enrollment_ages_5_17) AS enrollment_difference         FROM schools         WHERE schools.fundingtype = 'Locally funded'         GROUP BY schools.school     ) ); 
SELECT  MIN(schools.opendate) FROM schools WHERE gsserved LIKE '%12%' ORDER BY CAST(enroll12 AS INTEGER) DESC LIMIT 1; 
SELECT  DISTINCT city FROM schools ORDER BY enroll12 LIMIT 5; 
SELECT (SELECT (frpm."free meal count (k-12)" / frpm."enrollment (k-12)") AS "eligible free rate" FROM frpm INNER JOIN schools ON frpm.cdscode = schools.cdscode ORDER BY schools.enrollment DESC LIMIT 2 OFFSET 9) UNION (SELECT (frpm."free meal count (k-12)" / frpm."enrollment (k-12)") AS "eligible free rate" FROM frpm INNER JOIN schools ON frpm.cdscode = schools.cdscode ORDER BY schools.enrollment DESC LIMIT 2 OFFSET 10) 
SELECT  schools.school,         (frpm.frpm_count / frpm.enrollment) AS eligible_free_reduced_meal_rate FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode WHERE schools.charternum = '66' ORDER BY frpm.frpm_count DESC LIMIT 5; 
SELECT  schools.school, schools.website FROM schools INNER JOIN frpm ON frpm.cdscode = schools.cdscode WHERE frpm.free_meal_count >= 1900 AND frpm.free_meal_count <= 2000 AND frpm.low_grade <= 5 AND frpm.high_grade >= 17; 
SELECT  ROUND(schools."free meal count (ages 5-17)" / schools."enrollment (ages 5-17)", 2) AS "Free Rate for Students (Ages 5-17)" FROM schools WHERE schools.admfname1 = 'Kacey' AND schools.admlname1 = 'Gibson'; 
SELECT  schools.admemail1 FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE frpm.charter = 1 ORDER BY schools.enrollment LIMIT 1; 
SELECT  schools.admfname1 || ' ' || schools.admlname1 AS full_name FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE satscores.numge1500 = (     SELECT MAX(numge1500)      FROM satscores ) 
SELECT schools.street || ', ' || schools.city || ', ' || schools.state || ', ' || schools.zip AS complete_address FROM schools JOIN satscores ON satscores.cds = schools.cdscode WHERE satscores.numtsttakr > 0 ORDER BY CAST(satscores.numge1500 AS REAL) / satscores.numtsttakr ASC LIMIT 1; 
SELECT  website FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.county = 'Los Angeles' AND satscores.numtsttakr BETWEEN 2000 AND 3000; 
SELECT  AVG(numtsttakr) FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE schools.city = 'Fresno' AND schools.opendate BETWEEN '1980-01-01' AND '1980-12-31' 
SELECT  schools.phone FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.district = 'Fresno Unified' ORDER BY satscores.avgscrread ASC LIMIT 1;
SELECT  schools.school, AVG(satscores.avgscrread) AS avg_reading_score FROM schools JOIN satscores ON schools.cdscode = satscores.cds WHERE schools.virtual = 'F' GROUP BY schools.school ORDER BY avg_reading_score DESC LIMIT 5; 
SELECT  DISTINCT schools.edopsname FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE satscores.avgscrmath = (     SELECT MAX(avgscrmath) FROM satscores ); 
SELECT  MIN((s.avgscrmath + s.avgscrread + s.avgscrwrite) / 3) AS average_math_score, sc.county FROM satscores s JOIN schools sc ON s.cds = sc.cdscode 
SELECT  AVG(satscores.avgscrwrite) AS average_writing_score, schools.city FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE satscores.numge1500 >= (SELECT MAX(numge1500) FROM satscores) GROUP BY schools.city; 
SELECT  schools.school, AVG(satscores.avgscrwrite) AS avg_writing_score FROM schools JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.admfname1 = 'Ricci' AND schools.admlname1 = 'Ulrich' GROUP BY schools.school;
SELECT  district, school, enrollment FROM schools WHERE soctype = 'State Special Schools' AND gsoffered = 'K-12' ORDER BY enrollment DESC; 
SELECT  ROUND(CAST(COUNT(schools.school) / 12 AS REAL), 2) AS monthly_avg_opened_schools FROM schools INNER JOIN frpm ON frpm.cdscode = schools.cdscode WHERE schools.county = 'Alameda' AND schools.opendate BETWEEN '1980-01-01' AND '1980-12-31' AND schools.doctype = 'Elementary School District' AND schools.doc = 52;
SELECT      CAST(COUNT(CASE WHEN schools.statustype = 'Merged' AND schools.doctype = 'Unified School District' THEN 1 END) AS FLOAT) /     CAST(COUNT(CASE WHEN schools.statustype = 'Merged' AND schools.doctype = 'Elementary School District' THEN 1 END) AS FLOAT) AS ratio_merged_USD_to_ESD FROM     schools WHERE     schools.county = 'Orange'; 
SELECT  COUNT(schools.school), schools.county, schools.school, schools.closeddate FROM schools WHERE schools.statustype = 'Closed' GROUP BY schools.county ORDER BY COUNT(schools.school) DESC LIMIT 1;
SELECT  schools.street || ', ' || schools.city || ', ' || schools.state || ' ' || schools.zip AS postal_street_address, schools.school AS school_name FROM schools JOIN satscores ON schools.cdscode = satscores.cds ORDER BY satscores.avgscrmath DESC LIMIT 1 OFFSET 5; 
SELECT  schools.mailstreet, schools.school FROM schools JOIN satscores ON satscores.cds = schools.cdscode WHERE satscores.avgscrread = (     SELECT MIN(avgscrread)     FROM satscores ); 
SELECT  COUNT(DISTINCT schools.cdscode) AS Total_Schools FROM satscores JOIN schools ON satscores.cds = schools.cdscode WHERE satscores.avgscrread + satscores.avgscrmath + satscores.avgscrwrite >= 1500 AND schools.mailcity = 'Lakeport'; 
SELECT  SUM(numtsttakr)  FROM schools  INNER JOIN satscores ON schools.cdscode = satscores.cds  WHERE mailcity = 'Fresno'; 
SELECT  schools.school, schools.mailzip FROM schools WHERE schools.admfname2 = 'Avetik' AND schools.admlname2 = 'Atoian'; 
SELECT  COUNT(CASE WHEN schools.county = 'Colusa' THEN 1 END) * 1.0 / COUNT(CASE WHEN schools.county = 'Humboldt' THEN 1 END) FROM schools WHERE schools.mailstate = 'CA';
SELECT  COUNT(*) FROM schools WHERE state = 'CA' AND county = 'San Joaquin' AND statustype = 'Active'; 
SELECT  schools.phone, schools.ext FROM satscores JOIN schools ON satscores.cds = schools.cdscode ORDER BY satscores.avgscrwrite DESC LIMIT 1 OFFSET 332; 
SELECT  schools.school, schools.phone, schools.ext FROM schools WHERE schools.zip = '95203-3704'; 
SELECT  website FROM schools WHERE (admfname1 = 'Mike' AND admlname1 = 'Larson')    OR (admfname1 = 'Dante' AND admlname1 = 'Alvarez')    OR (admfname2 = 'Mike' AND admlname2 = 'Larson')    OR (admfname2 = 'Dante' AND admlname2 = 'Alvarez')    OR (admfname3 = 'Mike' AND admlname3 = 'Larson')    OR (admfname3 = 'Dante' AND admlname3 = 'Alvarez'); 
SELECT  website FROM schools WHERE charter = 1 AND virtual = 'P' AND county = 'San Joaquin'; 
SELECT  COUNT(*)  FROM schools  WHERE city = 'Hickman'  AND charter = 1  AND doc = 52; 
SELECT  COUNT(*) AS total_non_chartered_schools FROM schools WHERE county = 'Los Angeles' AND charter = 0 AND (free_meal_count * 100 / enrollment) < 0.18; 
SELECT  schools.school, schools.city, schools.admfname1 || ' ' || schools.admlname1 AS administrator1, schools.admfname2 || ' ' || schools.admlname2 AS administrator2, schools.admfname3 || ' ' || schools.admlname3 AS administrator3 FROM schools WHERE schools.charter = 1 AND schools.charternum = '00D2';
SELECT  COUNT(*)  FROM schools  WHERE mailcity = 'Hickman'  AND charternum = '00D4'; 
SELECT (COUNT(CASE WHEN schools.county = 'Santa Clara' AND schools.fundingtype = 'Locally funded' THEN 1 END) / COUNT(CASE WHEN schools.county = 'Santa Clara' THEN 1 END)) * 100 AS locally_funded_ratio 
SELECT  COUNT(DISTINCT schools.cdscode) FROM schools WHERE schools.opendate BETWEEN '2000-01-01' AND '2005-12-31' AND schools.county = 'Stanislaus' AND schools.fundingtype = 'Directly funded';
SELECT  COUNT(*) AS total_community_college_district_closure_1989 FROM schools WHERE city = 'San Francisco' AND closeddate LIKE '1989%'; 
SELECT  COUNT(schools.county) AS closure_count, schools.county FROM schools WHERE schools.opendate BETWEEN '1980-01-01' AND '1989-12-31' AND schools.soctype = 'Youth Authority Facilities' GROUP BY schools.county ORDER BY closure_count DESC LIMIT 1;
SELECT  schools.ncesdist FROM schools JOIN frpm ON schools.cdscode = frpm.cdscode WHERE schools.soctype = 'State Special Schools' AND schools.soc = '31'; 
SELECT  COUNT(*)  FROM schools  WHERE county = 'Alpine'  AND statustype IN ('Active', 'Closed')  AND soctype = 'District Community Day Schools'; 
SELECT schools.district code FROM schools JOIN frpm ON frpm.cdscode = schools.cdscode JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.city = 'Fresno' AND schools.magnet = 0 
SELECT  SUM(enrollment) AS enrolled_students_ages_5_to_17 FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.city = 'Fremont' AND frpm.academic_year = '2014-2015' AND schools.edopscode = 'SSS'; 
SELECT  frpm."free meal count (ages 5-17)" FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.edopsname = 'Youth Authority School' AND schools.mailstreet = 'PO Box 1040'; 
SELECT  lowgrade FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.edopscode = 'SPECON' AND schools.ncesdist = '613360' ORDER BY lowgrade LIMIT 1;
SELECT  DISTINCT schools.school, frpm.educational_option_type FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE frpm.nslp_provision_status = 'Breakfast Provision 2' AND frpm.county_code = '37'; 
SELECT  schools.city FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE frpm.lowgrade = 9 AND frpm.highgrade = 12 AND frpm.nslpprovisionstatus = 'Lunch Provision 2' AND frpm.countyname = 'Merced' AND schools.eilcode = 'HS'; 
SELECT schools.school, schools.eilname, (schools.free_meal_count_ages_5_17 / schools.enrollment_ages_5_17) * 100 AS "Percent (%) Eligible FRPM (Ages 5-17)" FROM schools WHERE schools.county = 'Los Angeles' AND schools.gsoffered = 'K-9' 
SELECT  schools.city, schools.gsserved, COUNT(*) AS count_grade_span FROM schools WHERE schools.city = 'Adelanto' GROUP BY schools.gsserved ORDER BY count_grade_span DESC LIMIT 1; 
SELECT  COUNT(schools.cdscode) AS num_schools FROM schools WHERE schools.county IN ('San Diego', 'Santa Barbara') AND schools.virtual = 'F'; 
SELECT  schools.school_type, schools.school_name, schools.latitude FROM schools ORDER BY schools.latitude DESC LIMIT 1; 
SELECT  schools.city, schools.school, schools.lowgrade FROM schools WHERE schools.latitude = (     SELECT MIN(latitude)     FROM schools     WHERE state = 'CA' ); 
SELECT  schools.gsoffered FROM schools WHERE schools.longitude = (     SELECT MAX(schools.longitude)     FROM schools ); 
SELECT COUNT(DISTINCT frpm.cdscode) AS num_schools_multiple_provision, COUNT(DISTINCT schools.city) AS num_cities, COUNT(DISTINCT schools.cdscode) AS num_schools_per_city FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode WHERE schools.gsoffered = 'K-8' AND schools.magnet = '1' AND frpm.nslp_provision_status = 'Multiple Provision Types'; 
SELECT  WITH admin_names AS (     SELECT DISTINCT admfname1 AS admin_first_name, admlname1 AS admin_last_name, dname AS district     FROM schools     UNION ALL     SELECT DISTINCT admfname2 AS admin_first_name, admlname2 AS admin_last_name, dname AS district     FROM schools     UNION ALL     SELECT DISTINCT admfname3 AS admin_first_name, admlname3 AS admin_last_name, dname AS district     FROM schools ) SELECT admin_first_name, district, COUNT(*) AS count FROM admin_names WHERE admin_first_name <> '' GROUP BY admin_first_name, district ORDER BY count DESC LIMIT 2; 
SELECT schools.districtcode FROM frpm JOIN schools ON frpm.cdscode = schools.cdscode JOIN schools AS s ON s.cdscode = satscores.cds WHERE schools.admfname1 = 'Alusine' 
SELECT  schools.admlname1, schools.district, schools.county, schools.school FROM schools WHERE schools.charternum = '40'; 
SELECT  schools.admemail1 FROM schools INNER JOIN frpm ON frpm.cdscode = schools.cdscode INNER JOIN satscores ON satscores.cds = schools.cdscode WHERE schools.county = 'San Bernardino' AND schools.district = 'San Bernardino City Unified' AND schools.opendate BETWEEN '2009-01-01' AND '2010-12-31' AND schools.soctype = 'Intermediate/Middle Schools (Public)' AND schools.doctype = 'Unified School District'
SELECT  schools.admemail1, schools.school FROM schools JOIN satscores ON satscores.cds = schools.cdscode WHERE satscores.numge1500 = (     SELECT MAX(numge1500)     FROM satscores ) AND satscores.numtsttakr = (     SELECT MAX(numtsttakr)     FROM satscores     WHERE numge1500 > 0 ); 
SELECT  COUNT(account.account_id) AS num_accounts FROM account JOIN district ON account.district_id = district.district_id JOIN trans ON account.account_id = trans.account_id WHERE district.a3 = 'east Bohemia' AND account.frequency = 'POPLATEK PO OBRATU';
SELECT  COUNT(DISTINCT account.account_id) FROM account JOIN district ON account.district_id = district.district_id WHERE district.a3 = 'Prague' 
SELECT  AVG(a12) AS avg_unemployment_1995, AVG(a13) AS avg_unemployment_1996,        CASE            WHEN AVG(a12) > AVG(a13) THEN '1995'            WHEN AVG(a12) < AVG(a13) THEN '1996'            ELSE 'Equal'        END AS higher_unemployment_year FROM district WHERE a12 IS NOT NULL AND a13 IS NOT NULL; 
SELECT  COUNT(DISTINCT district_id) FROM client JOIN account ON client.client_id = disp.client_id JOIN district ON client.district_id = district.district_id WHERE gender = 'F' GROUP BY client.district_id HAVING AVG(a11) > 6000 AND AVG(a11) < 10000;
SELECT  COUNT(DISTINCT client.client_id) FROM client JOIN district ON client.district_id = district.district_id JOIN account ON client.client_id = account.account_id JOIN trans ON account.account_id = trans.account_id WHERE client.gender = 'M' AND district.a3 = 'north Bohemia' AND trans.type = 'PRIJEM' AND trans.amount > 8000;
SELECT  account.account_id FROM account JOIN client ON account.district_id = client.district_id WHERE client.gender = 'F' GROUP BY client.birth_date HAVING client.birth_date = (SELECT MIN(birth_date) FROM client WHERE gender = 'F') AND AVG((SELECT a11 FROM district WHERE district.district_id = client.district_id)) = (SELECT MIN(AVG(a11)) FROM client JOIN district ON client.district_id = district.district_id WHERE gender = 'F');
SELECT  account.account_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id GROUP BY account.account_id ORDER BY client.birth_date DESC, AVG(trans.amount) DESC LIMIT 1;
SELECT  COUNT(DISTINCT client.client_id) AS owner_weekly_customers FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id WHERE account.frequency = 'POPLATEK TYDNE' AND disp.type = 'OWNER'; 
SELECT  DISTINCT c.client_id FROM client c JOIN disp d ON c.client_id = d.client_id JOIN account a ON d.account_id = a.account_id WHERE d.type = 'DISPONENT' AND a.frequency = 'POPLATEK PO OBRATU'; 
SELECT account_id FROM account JOIN loan ON account.account_id = loan.account_id WHERE loan.date LIKE '1997%' AND account.frequency = 'POPLATEK TYDNE' GROUP BY account.account_id HAVING loan.amount = MIN(loan.amount); 
SELECT account_id FROM loan JOIN account ON loan.account_id = account.account_id WHERE duration > 12 AND amount = (     SELECT MAX(amount)     FROM loan     WHERE duration > 12 ) AND account.date LIKE '1993%' 
SELECT  COUNT(DISTINCT client.client_id) FROM client JOIN district ON client.district_id = district.district_id WHERE client.gender = 'F' AND client.birth_date < '1950-01-01' AND district.a2 = 'Slokolov'; 
SELECT  account_id FROM trans WHERE date = (SELECT MIN(date) FROM trans WHERE strftime('%Y', date) = '1995'); 
SELECT  account_id FROM account WHERE date < '1997-01-01' AND account_id IN (     SELECT account_id     FROM trans     GROUP BY account_id     HAVING SUM(amount) > 3000 ); 
SELECT  client_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id WHERE card.issued = '1994-03-03'; 
SELECT  MIN(date) AS account_opened_date FROM account WHERE account_id IN (     SELECT account_id     FROM trans     WHERE amount = 840 AND date = '1998-10-14' ); 
SELECT  district.district_id FROM loan JOIN account ON loan.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE loan.date = '1994-08-25'; 
SELECT  MAX(amount) FROM trans WHERE account_id IN (     SELECT account_id     FROM disp     JOIN card ON disp.disp_id = card.disp_id     WHERE card.issued = '1996-10-21' ); 
SELECT  client.gender FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE account.date = (SELECT MIN(date) FROM account) AND district.a11 = (SELECT MAX(a11) FROM district);
SELECT  trans.amount FROM trans JOIN (     SELECT account_id, MAX(amount) AS max_loan     FROM loan     GROUP BY account_id ) AS max_loan_amounts ON trans.account_id = max_loan_amounts.account_id WHERE trans.date = (     SELECT MIN(date)     FROM trans     WHERE trans.account_id = max_loan_amounts.account_id ) 
SELECT  COUNT(client.client_id) FROM client JOIN account ON client.client_id = disp.client_id JOIN district ON client.district_id = district.district_id WHERE district.a2 = 'Jesenik' AND client.gender = 'F';
SELECT  disp_id FROM trans WHERE amount = 5100 AND date = '1998-09-02'; 
SELECT  COUNT(account.account_id) FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Litomerice' AND strftime('%Y', account.date) = '1996';
SELECT  district.a2 FROM client JOIN account ON client.client_id = disp.client_id JOIN district ON account.district_id = district.district_id WHERE client.gender = 'F' AND client.birth_date = '1976-01-29';
SELECT  client.birth_date FROM client JOIN account ON client.client_id = disp.client_id JOIN loan ON account.account_id = loan.account_id WHERE loan.amount = 98832 AND loan.date = '1996-01-03'; 
SELECT  account.account_id FROM client JOIN district ON client.district_id = district.district_id JOIN account ON client.client_id = disp.client_id WHERE district.a3 = 'Prague' ORDER BY account.date LIMIT 1;
SELECT  ROUND((COUNT(CASE WHEN c.gender = 'M' THEN 1 END) * 100.0) / COUNT(c.client_id), 2) AS percentage_of_male_clients FROM client c JOIN district d ON c.district_id = d.district_id WHERE d.a3 = 'south Bohemia' GROUP BY d.a3 ORDER BY COUNT(c.client_id) DESC LIMIT 1; 
SELECT  ROUND(     (         (             MAX(trans.balance) - MIN(trans.balance)         ) / MIN(trans.balance)     ) * 100 , 2) AS increase_rate FROM trans JOIN account ON trans.account_id = account.account_id WHERE trans.date BETWEEN '1993-03-22' AND '1998-12-27' AND account.account_id IN (     SELECT DISTINCT account_id     FROM loan     WHERE loan.date >= '1993-07-05' )
SELECT  ((SELECT SUM(amount) FROM loan WHERE status = 'A') / (SELECT SUM(amount) FROM loan)) * 100 AS percentage_paid_without_issue;
SELECT      (COUNT(DISTINCT loan.account_id) * 1.0 / (SELECT COUNT(DISTINCT account_id) FROM loan)) * 100 AS percentage_running FROM     loan WHERE     loan.amount < 100000     AND loan.status = 'C'; 
SELECT  account.account_id, district.a2 AS district_name, district.a3 AS district_region FROM account JOIN district ON account.district_id = district.district_id JOIN card ON account.account_id = card.disp_id JOIN disp ON card.disp_id = disp.disp_id WHERE account.account_id = 1993 AND card.issued > (     SELECT MAX(date)     FROM trans     WHERE trans.account_id = account.account_id ) 
SELECT  DISTINCT account.account_id, account.frequency FROM account JOIN district ON account.district_id = district.district_id WHERE district.a3 = 'east Bohemia' AND account.date BETWEEN '1995-01-01' AND '2000-12-31'; 
SELECT  account_id, date FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Prachatice'; 
SELECT  district.a2 AS district, district.a3 AS region FROM loan JOIN account ON loan.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE loan.loan_id = '4990'; 
SELECT  account.account_id, district.a2 AS district, district.a3 AS region FROM account JOIN district ON account.district_id = district.district_id JOIN loan ON account.account_id = loan.account_id WHERE loan.amount > 300000; 
SELECT  loan.loan_id, district.a3 AS district, AVG(district.a11) AS average_salary FROM loan JOIN account ON loan.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE loan.duration = 60 GROUP BY loan.loan_id, district.a3;
SELECT district.a2, ((district.a13 - district.a12) / district.a12) * 100 AS unemployment_rate_increment_percentage FROM district JOIN client ON district.district_id = client.district_id JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id JOIN loan ON account.account_id = loan.account_id WHERE loan.status = 'D' 
SELECT  COUNT(*) * 100.0 / (SELECT COUNT(*) FROM account WHERE strftime('%Y', date) = '1993') AS percentage FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Decin' AND strftime('%Y', account.date) = '1993'; 
SELECT  account_id FROM account WHERE frequency = 'POPLATEK MESICNE'; 
SELECT a2 AS district, COUNT(DISTINCT client_id) AS female_account_holders FROM client WHERE gender = 'F' GROUP BY district ORDER BY female_account_holders DESC LIMIT 10; 
SELECT district.a2 AS district_name, SUM(trans.amount) AS total_withdrawals FROM trans JOIN account ON trans.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE trans.type = 'VYDAJ' AND trans.date LIKE '1996-01%' GROUP BY district_name ORDER BY total_withdrawals DESC LIMIT 10; 
SELECT  COUNT(DISTINCT client.client_id) FROM client JOIN district ON client.district_id = district.district_id LEFT JOIN disp ON client.client_id = disp.client_id LEFT JOIN card ON disp.disp_id = card.disp_id WHERE district.a3 = 'south Bohemia' AND card.card_id IS NULL;
SELECT  d.a3 AS district_name FROM district d JOIN account a ON d.district_id = a.district_id JOIN loan l ON a.account_id = l.account_id WHERE l.status = 'C' GROUP BY d.a3 ORDER BY COUNT(*) DESC LIMIT 1; 
SELECT  AVG(loan.amount) AS average_loan_amount FROM loan JOIN account ON loan.account_id = account.account_id JOIN client ON account.account_id = client.client_id WHERE client.gender = 'M'; 
SELECT  d.a2 AS branch_location, d.a3 AS district_name FROM district d WHERE d.a13 = (     SELECT MAX(a13)     FROM district     WHERE a13 IS NOT NULL     AND a13 <> ''     AND a13 <> '0'     AND a10 IS NOT NULL     AND a10 <> ''     AND a10 <> '0'     AND a13 <> 0     AND a10 <> 0     AND CAST(a13 AS FLOAT) / CAST(a10 AS FLOAT) = (         SELECT MAX(CAST(a13 AS FLOAT) / CAST(a10 AS FLOAT))         FROM district         WHERE a13 IS NOT NULL         AND a13 <> ''         AND a13 <> '0'         AND a10 IS NOT NULL         AND a10 <> ''         AND a10 <> '0'         AND a13 <> 0         AND a10 <> 0         AND a15 = 1996     )     AND a15 = 1996 ); 
SELECT  COUNT(DISTINCT account.account_id) AS num_of_accounts_opened FROM account JOIN district ON account.district_id = district.district_id WHERE district.a16 = (     SELECT MAX(a16)     FROM district     WHERE a16 <> '' );
SELECT  COUNT(DISTINCT account.account_id) FROM trans JOIN account ON trans.account_id = account.account_id JOIN card ON trans.account_id = card.disp_id WHERE trans.operation = 'VYBER KARTOU' AND trans.balance < 0 AND account.frequency = 'POPLATEK MESICNE';
SELECT  COUNT(DISTINCT loan.account_id) AS approved_loans FROM loan JOIN account ON loan.account_id = account.account_id WHERE loan.date BETWEEN '1995-01-01' AND '1997-12-31' AND loan.amount >= 250000 AND account.frequency = 'POPLATEK MESICNE' AND loan.status = 'A'; 
SELECT  COUNT(DISTINCT account.account_id) AS num_running_contracts FROM account JOIN district ON account.district_id = district.district_id JOIN loan ON account.account_id = loan.account_id WHERE district.district_id = 1 AND loan.status = 'C'; 
SELECT  COUNT(client.client_id) AS male_clients FROM client JOIN district ON client.district_id = district.district_id WHERE district.district_id = (     SELECT district_id     FROM (         SELECT district_id, ROW_NUMBER() OVER (ORDER BY a15 DESC) AS row_num         FROM district     ) AS district_rank     WHERE row_num = 2 ) AND client.gender = 'M';
SELECT  COUNT(card.card_id) FROM card JOIN disp ON card.disp_id = disp.disp_id WHERE card.type = 'gold' AND disp.type = 'DISPONENT';
SELECT  COUNT(account.account_id) FROM account JOIN district ON account.district_id = district.district_id WHERE district.a2 = 'Pisek';
SELECT  DISTINCT district.a2 FROM district JOIN account ON account.district_id = district.district_id JOIN trans ON trans.account_id = account.account_id WHERE trans.amount > 10000 AND trans.date BETWEEN '1997-01-01' AND '1997-12-31' 
SELECT  DISTINCT account.account_id FROM account JOIN district ON account.district_id = district.district_id JOIN `order` ON account.account_id = `order`.account_id WHERE district.a2 = 'Pisek' AND `order`.k_symbol = 'SIPO'; 
SELECT  DISTINCT a.account_id FROM account a JOIN disp d ON a.account_id = d.account_id JOIN card c ON d.disp_id = c.disp_id WHERE c.type = 'gold' AND EXISTS (     SELECT 1     FROM disp d2     JOIN card c2 ON d2.disp_id = c2.disp_id     WHERE d2.account_id = a.account_id     AND c2.type = 'junior' ); 
SELECT  AVG(amount) AS average_credit_card_amount FROM trans JOIN card ON trans.account_id = card.disp_id WHERE type = 'VYBER KARTOU' AND date BETWEEN '2021-01-01' AND '2021-12-31';
SELECT  DISTINCT disp.client_id FROM disp JOIN card ON disp.disp_id = card.disp_id JOIN trans ON card.card_id = trans.account WHERE trans.operation = 'VYBER KARTOU'   AND strftime('%Y', trans.date) = '1998' GROUP BY disp.client_id HAVING SUM(trans.amount) / (SELECT COUNT(DISTINCT strftime('%m', trans.date)) FROM trans WHERE strftime('%Y', trans.date) = '1998') < (SELECT AVG(amount) FROM trans WHERE strftime('%Y', date) = '1998'); 
SELECT  DISTINCT client.client_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id JOIN account ON disp.account_id = account.account_id JOIN loan ON account.account_id = loan.account_id WHERE client.gender = 'F' AND card.type = 'classic' 
SELECT  COUNT(DISTINCT account.account_id)  FROM client  JOIN account ON client.client_id = account.account_id  JOIN district ON client.district_id = district.district_id  WHERE client.gender = 'F' AND district.a3 = 'south Bohemia';
SELECT  account.account_id FROM account JOIN district ON account.district_id = district.district_id JOIN disp ON disp.account_id = account.account_id WHERE district.a2 = 'Tabor' AND disp.type = 'OWNER'; 
SELECT type FROM account JOIN district ON account.district_id = district.district_id JOIN disp ON disp.account_id = account.account_id JOIN client ON disp.client_id = client.client_id JOIN (     SELECT district_id, AVG(a11) AS avg_income     FROM district     GROUP BY district_id     HAVING avg_income > 8000 AND avg_income <= 9000 ) AS avg_income_district ON avg_income_district.district_id = district.district_id WHERE type != 'OWNER' 
SELECT  COUNT(DISTINCT account.account_id) FROM account JOIN district ON account.district_id = district.district_id JOIN trans ON account.account_id = trans.account_id WHERE district.a3 = 'North Bohemia' AND trans.bank = 'AB';
SELECT  district.a2 FROM district JOIN account ON account.district_id = district.district_id JOIN trans ON trans.account_id = account.account_id WHERE trans.type = 'VYDAJ' GROUP BY district.a2;
SELECT  AVG(district.a15) AS average_crimes_1995 FROM district JOIN account ON account.district_id = district.district_id WHERE district.a15 > 4000 AND account.date >= '1997-01-01'; 
SELECT  COUNT(DISTINCT card.card_id) FROM card JOIN disp ON card.disp_id = disp.disp_id JOIN account ON disp.account_id = account.account_id WHERE card.type = 'classic' AND disp.type = 'OWNER';
SELECT  COUNT(client.client_id) FROM client JOIN district ON client.district_id = district.district_id WHERE district.a2 = 'Hl.m. Praha' AND client.gender = 'M';
SELECT  ROUND((SELECT COUNT(*) FROM card WHERE type = 'gold' AND strftime('%Y', issued) < '1998') * 100.0 / (SELECT COUNT(*) FROM card), 2) AS percent_gold_prior_to_1998; 
SELECT  client.client_id, client.gender, client.birth_date, district.a2 AS district_name FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id JOIN loan ON account.account_id = loan.account_id JOIN district ON client.district_id = district.district_id WHERE loan.amount = (SELECT MAX(amount) FROM loan); 
SELECT  COUNT(district.a15) AS number_of_committed_crimes_1995 FROM account JOIN district ON account.district_id = district.district_id WHERE account.account_id = 532;
SELECT  district.a3 FROM account JOIN `order` ON account.account_id = `order`.account_id JOIN district ON account.district_id = district.district_id WHERE `order`.order_id = 33333;
SELECT  trans.amount, trans.date FROM trans JOIN disp ON trans.account_id = disp.account_id WHERE disp.client_id = 3356 AND trans.operation = 'VYBER';
SELECT  COUNT(DISTINCT account.account_id)  FROM account JOIN loan ON account.account_id = loan.account_id WHERE account.frequency = 'POPLATEK TYDNE' AND loan.amount < 200000; 
SELECT  card.type FROM card JOIN disp ON card.disp_id = disp.disp_id JOIN client ON disp.client_id = client.client_id WHERE client.client_id = 13539; 
SELECT  district.a3 FROM client JOIN district ON client.district_id = district.district_id WHERE client.client_id = 3541;
SELECT  d.a2 AS district_name, COUNT(*) AS loan_accounts FROM district d JOIN account a ON d.district_id = a.district_id JOIN loan l ON a.account_id = l.account_id WHERE l.status = 'A' GROUP BY d.a2 ORDER BY loan_accounts DESC LIMIT 1; 
SELECT  client_id FROM order WHERE order_id = 32423; 
SELECT  * FROM trans JOIN account ON trans.account_id = account.account_id JOIN district ON account.district_id = district.district_id WHERE district.a8 = '5'; 
SELECT  COUNT(*)  FROM account  JOIN district ON account.district_id = district.district_id  WHERE district.a2 = 'Jesenik'; 
SELECT  client.client_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id WHERE card.type = 'junior' AND card.issued > '1996-01-01';
SELECT  ROUND(CAST((SELECT COUNT(DISTINCT c.client_id)                    FROM client c                    JOIN account a ON c.client_id = a.account_id                    JOIN district d ON a.district_id = d.district_id                    WHERE d.a11 > 10000 AND c.gender = 'F') AS FLOAT) /              (SELECT COUNT(DISTINCT c.client_id)               FROM client c               JOIN account a ON c.client_id = a.account_id               JOIN district d ON a.district_id = d.district_id               WHERE d.a11 > 10000) * 100, 2) AS percentage_female_clients; 
SELECT ((SELECT SUM(loan.amount)  FROM loan  JOIN account ON loan.account_id = account.account_id  JOIN client ON account.account_id = client.client_id  WHERE client.gender = 'M' AND loan.date BETWEEN '1996-01-01' AND '1996-12-31') - (SELECT SUM(loan.amount)  FROM loan  JOIN account ON loan.account_id = account.account_id  JOIN client ON account.account_id = client.client_id  WHERE client.gender = 'M' AND loan.date BETWEEN '1997-01-01' AND '1997-12-31')) /  (SELECT SUM(loan.amount)  FROM loan  JOIN account ON loan.account_id = account.account_id  JOIN client ON account.account_id = client.client_id  WHERE client.gender = 'M' AND loan.date BETWEEN '1996-01-01' AND '1996-12-31') * 100; 
SELECT  COUNT(*) FROM trans JOIN card ON trans.account_id = card.disp_id WHERE trans.date > '1995-01-01' AND trans.operation = 'VYBER KARTOU';
SELECT  SUM(CASE WHEN district.a3 = 'north Bohemia' AND strftime('%Y', trans.date) = '1996' THEN district.a16 ELSE 0 END) - SUM(CASE WHEN district.a3 = 'east Bohemia' AND strftime('%Y', trans.date) = '1996' THEN district.a16 ELSE 0 END) AS crime_difference_1996 FROM district JOIN account ON account.district_id = district.district_id JOIN trans ON trans.account_id = account.account_id;
SELECT  COUNT(*) AS disposition_count FROM disp WHERE account_id BETWEEN 1 AND 10 AND type IN ('OWNER', 'DISPONENT'); 
SELECT  COUNT(*) FROM trans WHERE account_id = 3 AND type = 'VYBER';
SELECT  client.birth_date FROM client JOIN disp ON client.client_id = disp.client_id WHERE disp.type = 'OWNER' AND disp.account_id = 130; 
SELECT  COUNT(*)  FROM disp  WHERE type = 'OWNER'  AND account_id IN (     SELECT account_id      FROM account      WHERE frequency = 'POPLATEK PO OBRATU' ); 
SELECT  SUM(loan.amount) AS total_debt, loan.status AS payment_status FROM loan JOIN account ON loan.account_id = account.account_id JOIN disp ON account.account_id = disp.account_id JOIN client ON disp.client_id = client.client_id WHERE client.client_id = 992; 
SELECT  SUM(trans.amount), client.gender FROM trans JOIN account ON trans.account_id = account.account_id JOIN disp ON account.account_id = disp.account_id JOIN client ON disp.client_id = client.client_id WHERE client.client_id = 4 AND trans.trans_id > 851 
SELECT  card.type FROM card JOIN disp ON card.disp_id = disp.disp_id JOIN client ON disp.client_id = client.client_id WHERE client.client_id = 9; 
SELECT  SUM(amount) AS total_payments FROM trans WHERE account_id IN (     SELECT account_id     FROM disp     WHERE client_id = 617 ) AND date BETWEEN '1998-01-01' AND '1998-12-31'; 
SELECT  client.client_id FROM client JOIN district ON client.district_id = district.district_id WHERE client.birth_date BETWEEN '1983-01-01' AND '1987-12-31' AND district.a3 = 'east Bohemia'; 
SELECT  client_id FROM client WHERE gender = 'F' ORDER BY (     SELECT SUM(amount)     FROM loan     WHERE loan.account_id = account.account_id ) DESC LIMIT 3;
SELECT  COUNT(DISTINCT client.client_id)  FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id JOIN trans ON account.account_id = trans.account_id WHERE client.gender = 'M' AND client.birth_date BETWEEN '1974-01-01' AND '1976-12-31' AND trans.k_symbol = 'SIPO' AND trans.amount > 4000;
SELECT  COUNT(account_id)  FROM account  JOIN district ON account.district_id = district.district_id  WHERE a2 = 'Beroun' AND date > '1996-01-01'; 
SELECT  COUNT(client.client_id) FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id WHERE client.gender = 'F' AND card.type = 'junior';
SELECT  COUNT(DISTINCT client.client_id) * 100.0 / COUNT(DISTINCT account.account_id) FROM client JOIN account ON client.client_id = disp.client_id JOIN district ON client.district_id = district.district_id WHERE client.gender = 'F' AND district.a3 = 'Prague'; 
SELECT  100 * (     SELECT COUNT(client.client_id)      FROM client      JOIN account ON client.client_id = disp.client_id      WHERE client.gender = 'M'      AND account.frequency = 'POPLATEK TYDNE' ) / (     SELECT COUNT(client.client_id)      FROM client      JOIN account ON client.client_id = disp.client_id      WHERE account.frequency = 'POPLATEK TYDNE' ) AS percentage_of_male_clients_requesting_weekly_statements;
SELECT  COUNT(DISTINCT client_id)  FROM client  JOIN disp ON client.client_id = disp.client_id  JOIN account ON disp.account_id = account.account_id  WHERE account.frequency = 'POPLATEK TYDNE' AND client.gender = 'M'; 
SELECT  account_id FROM loan JOIN account ON loan.account_id = account.account_id WHERE duration > 24 AND amount = (     SELECT MIN(amount)     FROM loan     WHERE duration > 24 ) AND date < '1997-01-01'; 
SELECT  DISTINCT account.account_id FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id WHERE client.gender = 'F' ORDER BY client.birth_date ASC, district.a11 ASC LIMIT 1; 
SELECT  COUNT(DISTINCT client.client_id) FROM client JOIN district ON client.district_id = district.district_id WHERE client.birth_date LIKE '1920%' AND district.a3 = 'east Bohemia';
SELECT  COUNT(*) AS loan_count FROM loan JOIN account ON loan.account_id = account.account_id WHERE loan.duration = 24 AND account.frequency = 'POPLATEK TYDNE'; 
SELECT  AVG(loan.amount) AS average_loan_amount FROM loan INNER JOIN account ON loan.account_id = account.account_id INNER JOIN trans ON account.account_id = trans.account_id WHERE loan.status = 'C' AND account.frequency = 'POPLATEK PO OBRATU'
SELECT  DISTINCT client.client_id, district.a2 FROM client JOIN disp ON client.client_id = disp.client_id JOIN account ON disp.account_id = account.account_id JOIN district ON client.district_id = district.district_id LEFT JOIN loan ON account.account_id = loan.account_id LEFT JOIN order ON account.account_id = order.account_id WHERE loan.account_id IS NULL AND order.account_id IS NULL 
SELECT  client.client_id,         strftime('%Y', 'now') - strftime('%Y', client.birth_date) - (strftime('%m-%d', 'now') < strftime('%m-%d', client.birth_date)) AS age FROM client JOIN disp ON client.client_id = disp.client_id JOIN card ON disp.disp_id = card.disp_id JOIN account ON disp.account_id = account.account_id JOIN loan ON account.account_id = loan.account_id WHERE card.type = 'gold'; 
SELECT  bond_type FROM bond GROUP BY bond_type ORDER BY COUNT(*) DESC LIMIT 1; 
SELECT  COUNT(DISTINCT molecule_id) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '-' AND atom.element = 'cl'; 
SELECT  AVG(CASE WHEN bond.bond_type = '-' AND atom.element = 'o' THEN 1 ELSE 0 END) AS average_oxygen_atoms FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.bond_id = bond.bond_id WHERE atom.element = 'o'; 
SELECT  AVG(CASE WHEN molecule.label = '+' AND bond.bond_type = '-' THEN 1 ELSE 0 END) FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id; 
SELECT  COUNT(DISTINCT atom.atom_id) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'na' AND molecule.label = '-'
SELECT  molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '#' AND molecule.label = '+'; 
SELECT  100 * SUM(CASE WHEN element = 'c' THEN 1 ELSE 0 END) / COUNT(DISTINCT atom_id) FROM atom WHERE molecule_id IN (     SELECT molecule_id     FROM bond     WHERE bond_type = '=' );
SELECT  COUNT(*) FROM bond WHERE bond_type = '#';
SELECT  COUNT(DISTINCT atom.atom_id)  FROM atom  LEFT JOIN connected ON atom.atom_id = connected.atom_id  LEFT JOIN bond ON connected.bond_id = bond.bond_id  LEFT JOIN molecule ON atom.molecule_id = molecule.molecule_id  WHERE atom.element != 'br';
SELECT  COUNT(DISTINCT molecule.molecule_id) FROM molecule WHERE molecule.molecule_id BETWEEN 'TR000' AND 'TR099' AND molecule.label = '+';
SELECT  DISTINCT molecule.molecule_id FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'si'; 
SELECT  atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR004_8_9'; 
SELECT  DISTINCT atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '='; 
SELECT  label FROM molecule WHERE molecule_id IN (     SELECT DISTINCT molecule_id     FROM atom     WHERE element = 'h' ) GROUP BY label ORDER BY COUNT(*) DESC LIMIT 1; 
SELECT  bond.bond_type FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element = 'te';
SELECT  DISTINCT a1.element AS atom1, a2.element AS atom2 FROM connected AS c JOIN atom AS a1 ON c.atom_id = a1.atom_id JOIN atom AS a2 ON c.atom_id2 = a2.atom_id JOIN bond AS b ON c.bond_id = b.bond_id WHERE b.bond_type = '-'; 
SELECT  DISTINCT atom_id, atom_id2 FROM connected JOIN atom ON connected.atom_id = atom.atom_id JOIN bond ON connected.bond_id = bond.bond_id JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '-'; 
SELECT  element, COUNT(*) AS num_molecules FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '-' GROUP BY element ORDER BY num_molecules ASC LIMIT 1; 
SELECT  bond.bond_type FROM connected JOIN bond ON connected.bond_id = bond.bond_id WHERE (connected.atom_id = 'TR004_8' AND connected.atom_id2 = 'TR004_20')    OR (connected.atom_id = 'TR004_20' AND connected.atom_id2 = 'TR004_8'); 
SELECT  DISTINCT label FROM molecule WHERE molecule_id IN (     SELECT molecule_id     FROM atom     WHERE element != 'sn' ); 
SELECT  COUNT(DISTINCT atom_id) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN bond ON bond.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id AND connected.bond_id = bond.bond_id WHERE element IN ('i', 's') AND bond_type = '-'; 
SELECT  atom_id, atom_id2 FROM connected JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '#'; 
SELECT  atom.atom_id FROM atom JOIN connected ON atom.atom_id = connected.atom_id2 JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR181';
SELECT  (1.0 - (CAST(SUM(CASE WHEN element = 'f' THEN 1 ELSE 0 END) AS REAL) / CAST(COUNT(DISTINCT molecule_id) AS REAL))) * 100 AS percentage FROM molecule WHERE label = '+'; 
SELECT  ROUND(     (CAST(         SUM(CASE WHEN bond.bond_type = '#' THEN 1 ELSE 0 END) AS FLOAT) /         COUNT(bond.bond_id)     ) * 100, 2 ) AS percent FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.label = '+'; 
SELECT  element FROM atom WHERE molecule_id = 'TR000' ORDER BY element LIMIT 3; 
SELECT  atom.atom_id  FROM atom  JOIN connected ON atom.atom_id = connected.atom_id  JOIN bond ON connected.bond_id = bond.bond_id  JOIN molecule ON atom.molecule_id = molecule.molecule_id  WHERE molecule.molecule_id = 'TR001' AND bond.bond_id = 'TR001_2_6'; 
SELECT (SELECT COUNT(DISTINCT molecule_id) FROM molecule WHERE label = '+') - (SELECT COUNT(DISTINCT molecule_id) FROM molecule WHERE label = '-') 
SELECT  atom_id FROM connected WHERE bond_id = 'TR_000_2_5'; 
SELECT  bond_id FROM connected WHERE atom_id2 = 'TR000_2'; 
SELECT  molecule_id FROM bond WHERE bond_type = '=' GROUP BY molecule_id ORDER BY molecule_id LIMIT 5; 
SELECT  (COUNT(CASE WHEN bond_type = '=' THEN 1 END) * 100.0) / COUNT(*) AS percent FROM bond WHERE molecule_id = 'TR008'; 
SELECT  (CAST(SUM(CASE WHEN m.label = '+' THEN 1 ELSE 0 END) AS REAL) / CAST(COUNT(m.molecule_id) AS REAL)) * 100 AS percent FROM molecule m; 
SELECT  ROUND((SUM(CASE WHEN atom.element = 'h' THEN 1 ELSE 0 END) * 100.0) / COUNT(atom.atom_id), 2) AS percent FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR206'; 
SELECT bond_type FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR000'; 
SELECT  atom.element, molecule.label FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR060'; 
SELECT  MAX(bond.bond_type) AS majority_bond_type,      CASE          WHEN molecule.label = '+' THEN 'Carcinogenic'         WHEN molecule.label = '-' THEN 'Non-carcinogenic'         ELSE 'Unknown'     END AS carcinogenicity FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id JOIN connected ON bond.bond_id = connected.bond_id WHERE molecule.molecule_id = 'TR018' GROUP BY molecule.label;
SELECT  molecule_id FROM molecule WHERE label = '-' AND molecule_id IN (     SELECT DISTINCT molecule_id     FROM bond     WHERE bond_type = '-' ) AND molecule_id IN (     SELECT molecule_id     FROM connected     JOIN bond ON connected.bond_id = bond.bond_id     WHERE bond.bond_type = '-'     GROUP BY molecule_id     HAVING COUNT(DISTINCT connected.atom_id) = 2 ) ORDER BY molecule_id LIMIT 3; 
SELECT  bond_id FROM bond WHERE molecule_id = 'TR006' ORDER BY bond_id ASC LIMIT 2; 
SELECT  COUNT(*) FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id OR connected.atom_id2 = atom.atom_id WHERE molecule.molecule_id = 'TR009' AND (atom.atom_id = 'TR009_12' OR connected.atom_id2 = 'TR009_12');
SELECT  COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id WHERE molecule.label = '+' AND atom.element = 'br';
SELECT  bond_type, atom_id, atom_id2 FROM bond JOIN connected ON bond.bond_id = connected.bond_id WHERE bond.bond_id = 'TR001_6_9';
SELECT  molecule.molecule_id, molecule.label FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.atom_id = 'TR001_10'; 
SELECT  COUNT(DISTINCT molecule_id) AS triple_bond_molecules FROM bond WHERE bond_type = '#'; 
SELECT  COUNT(connected.bond_id) FROM connected WHERE connected.atom_id LIKE 'TR%_19';
SELECT  atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR004'; 
SELECT  COUNT(DISTINCT molecule_id)  FROM molecule  WHERE label = '-'; 
SELECT  DISTINCT molecule.molecule_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE SUBSTRING(atom.atom_id, 7, 2) BETWEEN '21' AND '25' AND molecule.label = '+'; 
SELECT  bond.bond_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id JOIN atom ON bond.molecule_id = atom.molecule_id JOIN connected ON bond.bond_id = connected.bond_id WHERE (atom.element = 'p' OR atom.element = 'n'); 
SELECT  molecule_id FROM (     SELECT molecule_id, COUNT(*) AS double_bonds     FROM bond     WHERE bond_type = '='     GROUP BY molecule_id ) AS double_bond_counts JOIN molecule ON molecule.molecule_id = double_bond_counts.molecule_id WHERE label = '+' ORDER BY double_bonds DESC LIMIT 1; 
SELECT AVG(bond_count) FROM (     SELECT COUNT(b.bond_id) AS bond_count     FROM atom a     JOIN connected c ON a.atom_id = c.atom_id     JOIN bond b ON c.bond_id = b.bond_id     WHERE a.element = 'i'     GROUP BY a.atom_id ) AS subquery; 
SELECT  bond.bond_type, bond.bond_id FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE substr(atom.atom_id, 7, 2) + 0 = 45; 
SELECT  DISTINCT element FROM atom WHERE atom_id NOT IN (SELECT atom_id FROM connected); 
SELECT  atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '#' AND bond.molecule_id = 'TR447'; 
SELECT  atom.element  FROM atom  JOIN connected ON atom.atom_id = connected.atom_id  JOIN bond ON connected.bond_id = bond.bond_id  WHERE bond.bond_id = 'TR144_8_19'; 
SELECT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE molecule.label = '+' AND bond.bond_type = '=' GROUP BY molecule.molecule_id ORDER BY COUNT(*) DESC LIMIT 1; 
SELECT  element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE label = '+' GROUP BY element ORDER BY COUNT(*) ASC LIMIT 1; 
SELECT  DISTINCT atom2.atom_id FROM atom AS atom1 JOIN connected ON connected.atom_id = atom1.atom_id JOIN bond ON bond.bond_id = connected.bond_id JOIN atom AS atom2 ON atom2.atom_id = connected.atom_id2 WHERE atom1.element = 'pb'; 
SELECT  DISTINCT atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '#'; 
SELECT ROUND((SELECT COUNT(*) * 100.0 /        (SELECT COUNT(*) FROM bond         WHERE atom_id IN (SELECT atom_id                           FROM (SELECT atom_id, COUNT(*) AS count                                 FROM connected                                 GROUP BY atom_id                                 ORDER BY count DESC                                 LIMIT 1))))        , 2) AS percentage 
SELECT SUM(CASE WHEN bond.bond_type = '-' AND molecule.label = '+' THEN 1 ELSE 0 END) / COUNT(DISTINCT bond.bond_id) AS proportion_of_carcinogenic_single_bonds FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id 
SELECT  COUNT(DISTINCT atom.atom_id) AS total_atoms FROM atom WHERE atom.element IN ('c', 'h'); 
SELECT atom_id2 FROM connected JOIN atom ON connected.atom_id = atom.atom_id WHERE atom.element = 's'; 
SELECT bond.bond_type FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element = 'sn' 
SELECT  COUNT(DISTINCT atom.element) AS num_elements FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '-'; 
SELECT  COUNT(DISTINCT atom_id) FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '#'  AND (atom.element = 'p' OR atom.element = 'br'); 
SELECT bond.bond_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.label = '+'; 
SELECT  DISTINCT molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '-' AND molecule.label = '-'; 
SELECT  SUM(CASE WHEN atom.element = 'cl' THEN 1 ELSE 0 END) * 100.0 / COUNT(DISTINCT connected.atom_id) FROM atom JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '-'
SELECT  molecule.molecule_id, molecule.label FROM molecule WHERE molecule.molecule_id IN ('TR000', 'TR001', 'TR002'); 
SELECT  molecule_id FROM molecule WHERE label = '-'; 
SELECT  COUNT(DISTINCT molecule.molecule_id) FROM molecule WHERE molecule.molecule_id BETWEEN 'TR000' AND 'TR030' AND molecule.label = '+'; 
SELECT  bond.bond_type FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE molecule.molecule_id BETWEEN 'TR000' AND 'TR050';
SELECT  atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR001_10_11'; 
SELECT  COUNT(DISTINCT bond.bond_id) FROM bond JOIN atom ON bond.molecule_id = atom.molecule_id JOIN connected ON bond.bond_id = connected.bond_id WHERE atom.element = 'i';
SELECT  m.label, COUNT(*) AS count FROM molecule m JOIN atom a ON m.molecule_id = a.molecule_id WHERE a.element = 'ca' GROUP BY m.label; 
SELECT  COUNT(*) AS count FROM connected JOIN bond ON connected.bond_id = bond.bond_id JOIN atom ON connected.atom_id = atom.atom_id WHERE bond.bond_id = 'TR001_1_8' AND (atom.element = 'cl' OR atom.element = 'c') GROUP BY bond.bond_id HAVING COUNT(DISTINCT atom.element) = 2; 
SELECT  DISTINCT molecule.molecule_id FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id2 = atom.atom_id WHERE bond.bond_type = '#' AND atom.element = 'c' AND molecule.label = '-'; 
SELECT (SELECT (CAST(SUM(CASE WHEN a.element = 'cl' THEN 1 ELSE 0 END) AS REAL) / COUNT(DISTINCT m.molecule_id)) * 100 AS percentage FROM atom AS a JOIN molecule AS m ON a.molecule_id = m.molecule_id WHERE m.label = '+') AS percentage_cl; 
SELECT  DISTINCT atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR001'; 
SELECT  DISTINCT molecule_id FROM bond WHERE bond_type = '='; 
SELECT  atom_id, atom_id2 FROM connected JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_type = '#'; 
SELECT  atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR005_16_26'; 
SELECT  COUNT(DISTINCT molecule_id) FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond_type = '-' AND label = '-'; 
SELECT  m.label FROM bond AS b JOIN molecule AS m ON b.molecule_id = m.molecule_id WHERE b.bond_id = 'TR001_10_11'; 
SELECT  DISTINCT bond.bond_id,                  CASE                      WHEN molecule.label = '+' THEN 'carcinogenic'                      WHEN molecule.label = '-' THEN 'non-carcinogenic'                      ELSE 'unknown'                  END AS carcinogenicity FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '#'  
SELECT  atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE molecule.label = '+' AND substr(atom.atom_id, 7, 1) = '4'; 
SELECT  (SUM(CASE WHEN atom.element = 'h' THEN 1 ELSE 0 END) * 1.0 / COUNT(*)), molecule.label FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR006';
SELECT  DISTINCT molecule.label FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element = 'ca'; 
SELECT bond.bond_type FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id JOIN atom ON bond.molecule_id = atom.molecule_id WHERE atom.element = 'te'; 
SELECT  element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR001_10_11'; 
SELECT  (COUNT(DISTINCT molecule.molecule_id) * 100.0 / (SELECT COUNT(DISTINCT molecule.molecule_id) FROM molecule)) FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '#'; 
SELECT  (COUNT(bond_id) * 100.0 / (SELECT COUNT(bond_id) FROM bond WHERE molecule_id = 'TR047')) AS percent FROM bond WHERE molecule_id = 'TR047' AND bond_type = '=' 
SELECT  m.label FROM molecule m JOIN atom a ON m.molecule_id = a.molecule_id WHERE a.atom_id = 'TR001_1' AND m.label = '+'; 
SELECT  DISTINCT molecule.label FROM molecule WHERE molecule.molecule_id = 'TR151' AND molecule.label = '+'; 
SELECT  DISTINCT atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR151'; 
SELECT  COUNT(DISTINCT molecule_id)  FROM molecule  WHERE label = '+'; 
SELECT  atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id BETWEEN 'TR010' AND 'TR050' AND atom.element = 'c'; 
SELECT  COUNT(atom.atom_id) AS num_atoms FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = '+';
SELECT  bond.bond_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '=' AND molecule.label = '+'; 
SELECT  COUNT(DISTINCT atom.atom_id) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.element = 'h' AND molecule.label = '+'; 
SELECT  molecule_id FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id WHERE bond.bond_id = 'TR00_1_2' AND atom.atom_id = 'TR00_1'; 
SELECT  atom_id FROM atom WHERE element = 'c' AND atom_id NOT IN (     SELECT atom_id     FROM atom     JOIN connected ON atom.atom_id = connected.atom_id     JOIN bond ON connected.bond_id = bond.bond_id     JOIN molecule ON atom.molecule_id = molecule.molecule_id     WHERE molecule.label = '-' ); 
SELECT  (COUNT(DISTINCT molecule.molecule_id) * 1.0 / (SELECT COUNT(DISTINCT molecule_id) FROM molecule WHERE label = '+')) * 100.0 AS percentage FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id WHERE atom.element = 'h' AND molecule.label = '+'; 
SELECT  label FROM molecule WHERE molecule_id = 'TR124' AND label = '+'; 
SELECT  atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR186';
SELECT  bond.bond_type FROM bond JOIN connected ON bond.bond_id = connected.bond_id WHERE connected.atom_id = 'TR007_4_19' OR connected.atom_id2 = 'TR007_4_19';
SELECT  atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR001_2_4'; 
SELECT  COUNT(*) FROM bond WHERE molecule_id = 'TR006' AND bond_type = '=';
SELECT  molecule.molecule_id, atom.element FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id WHERE molecule.label = '+'; 
SELECT  bond.bond_id, atom.atom_id, connected.atom_id2 FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id WHERE bond.bond_type = '-'; 
SELECT  molecule.molecule_id, GROUP_CONCAT(DISTINCT atom.element) AS elements FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id WHERE bond.bond_type = '#' GROUP BY molecule.molecule_id; 
SELECT  atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR000_2_3'; 
SELECT  COUNT(bond.bond_id) FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id2 = atom.atom_id WHERE atom.element = 'cl';
SELECT  atom_id, COUNT(DISTINCT bond_type) AS num_bond_types FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE molecule.label = 'TR346' GROUP BY atom_id; 
SELECT  COUNT(DISTINCT molecule.molecule_id) FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_type = '=' AND molecule.label = '+'; 
SELECT  COUNT(DISTINCT molecule.molecule_id) FROM molecule LEFT JOIN atom ON molecule.molecule_id = atom.molecule_id LEFT JOIN connected ON atom.atom_id = connected.atom_id LEFT JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element != 's' OR (atom.element = 's' AND bond.bond_type != '=') 
SELECT  molecule.label FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_id = 'TR001_2_4' AND molecule.label = '+'; 
SELECT  COUNT(*) AS atom_count FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR005'; 
SELECT  COUNT(*) FROM bond WHERE bond_type = '-'; 
SELECT  DISTINCT molecule_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE element = 'cl' AND label = '+'; 
SELECT  DISTINCT molecule_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE element = 'c' AND label = '-'; 
SELECT  (CAST(SUM(CASE WHEN molecule.label = '+' AND atom.element = 'cl' THEN 1 ELSE 0 END) AS FLOAT) / COUNT(DISTINCT molecule.molecule_id)) * 100 AS percentage FROM molecule JOIN atom ON atom.molecule_id = molecule.molecule_id; 
SELECT  molecule.molecule_id FROM bond JOIN molecule ON bond.molecule_id = molecule.molecule_id WHERE bond.bond_id = 'TR001_1_7'; 
SELECT  COUNT(DISTINCT element) FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE bond.bond_id = 'TR001_3_4'; 
SELECT  bond.bond_type FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id JOIN atom AS atom2 ON connected.atom_id2 = atom2.atom_id WHERE atom.atom_id = 'TR000_1' AND atom2.atom_id = 'TR000_2';
SELECT  molecule.label FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id JOIN connected ON atom.atom_id = connected.atom_id JOIN atom AS atom2 ON connected.atom_id2 = atom2.atom_id WHERE atom.atom_id = 'TR000_2' AND atom2.atom_id = 'TR000_4'; 
SELECT  atom.element  FROM atom  WHERE atom.atom_id = 'TR000_1'; 
SELECT  label FROM molecule WHERE molecule_id = 'TR000'; 
SELECT  ((SELECT COUNT(*) FROM bond WHERE bond_type = '-') * 100.0) / (SELECT COUNT(*) FROM bond);
SELECT  COUNT(DISTINCT molecule_id) FROM molecule WHERE label = '+' AND molecule_id IN (     SELECT molecule_id     FROM atom     WHERE element = 'n' )
SELECT  molecule.molecule_id FROM molecule JOIN atom ON molecule.molecule_id = atom.molecule_id JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element = 's' AND bond.bond_type = '='; 
SELECT  molecule_id FROM molecule WHERE label = '-'  GROUP BY molecule_id HAVING COUNT(atom_id) > 5; 
SELECT  DISTINCT atom.element FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.molecule_id = 'TR024' AND bond.bond_type = '='; 
SELECT  molecule_id, COUNT(atom_id) AS num_atoms FROM atom WHERE molecule_id IN (SELECT molecule_id FROM molecule WHERE label = '+') GROUP BY molecule_id ORDER BY num_atoms DESC LIMIT 1; 
SELECT  (COUNT(DISTINCT molecule_id) * 100.0) / (SELECT COUNT(DISTINCT molecule_id) FROM molecule WHERE label = '+') AS percentage_carcinogenic FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE element = 'h' AND bond_type = '#' 
SELECT  COUNT(DISTINCT molecule_id) FROM molecule WHERE label = '+'; 
SELECT  COUNT(DISTINCT molecule.molecule_id) AS num_single_bond_molecules FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE molecule.molecule_id BETWEEN 'TR004' AND 'TR010' AND bond.bond_type = '-'; 
SELECT  COUNT(*) FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE molecule.label = 'TR008' AND atom.element = 'c'; 
SELECT  atom.element FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id WHERE atom.atom_id = 'TR004_7' AND molecule.label = '-'; 
SELECT  COUNT(DISTINCT molecule_id) FROM bond JOIN connected ON bond.bond_id = connected.bond_id JOIN atom ON connected.atom_id = atom.atom_id WHERE atom.element = 'o' AND bond.bond_type = '=' 
SELECT  COUNT(DISTINCT molecule.molecule_id) FROM molecule JOIN bond ON molecule.molecule_id = bond.molecule_id WHERE bond.bond_type = '#'  AND molecule.label = '-'; 
SELECT  atom.element, bond.bond_type FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN connected ON connected.atom_id = atom.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE molecule.molecule_id = 'TR016'; 
SELECT  atom.atom_id FROM atom JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE atom.element = 'c' AND bond.bond_type = '=' AND atom.molecule_id = 'TR012';
SELECT atom.atom_id FROM atom JOIN molecule ON atom.molecule_id = molecule.molecule_id JOIN connected ON atom.atom_id = connected.atom_id JOIN bond ON connected.bond_id = bond.bond_id WHERE molecule.label = '+' AND atom.element = 'o'; 
SELECT  * FROM cards WHERE cardkingdomfoilid = cardkingdomid AND cardkingdomid IS NOT NULL; 
SELECT  name FROM cards WHERE bordercolor = 'borderless' AND hasfoil = 1 AND hasnonfoil = 1 AND cardkingdomfoilid IS NULL AND cardkingdomid IS NULL; 
SELECT  name FROM cards WHERE faceconvertedmanacost > convertedmanacost; 
SELECT  name FROM cards WHERE frameversion = '2015' AND edhrecrank < 100; 
SELECT  cards.name FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.rarity = 'mythic' AND legalities.format = 'gladiator' AND legalities.status = 'Banned'; 
SELECT  cards.name, legalities.status FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.type = 'Artifact' AND cards.side IS NULL AND legalities.format = 'vintage'; 
SELECT  cards.id, cards.artist FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.power IS NULL OR cards.power = '*' AND legalities.format = 'commander' AND legalities.status = 'Legal'; 
SELECT  cards.name, rulings.text, cards.hasContentWarning FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.artist = 'Stephen Daniele'; 
SELECT  rulings.text FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.name = 'Sublime Epiphany' AND cards.number = '74s'; 
SELECT  c.name, c.artist, CASE WHEN c.ispromo = 1 THEN 'Yes' ELSE 'No' END AS is_promotional FROM cards c JOIN rulings r ON c.uuid = r.uuid GROUP BY c.name, c.artist ORDER BY COUNT(r.uuid) DESC LIMIT 1; 
SELECT  foreign_data.language FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.name = 'Annul' AND cards.number = '29'; 
SELECT  DISTINCT cards.name FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Japanese'; 
SELECT  (SELECT COUNT(*) FROM foreign_data WHERE language = 'Chinese Simplified') * 100.0 / (SELECT COUNT(*) FROM cards) AS percentage_of_chinese_simplified_cards; 
SELECT  sets.name AS set_name, sets.totalsetsize AS total_cards FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language = 'Italian'; 
SELECT  COUNT(DISTINCT cards.type)  FROM cards  WHERE cards.artist = 'Aaron Boyd';
SELECT  keywords FROM cards WHERE name = 'Angel of Mercy'; 
SELECT  COUNT(*)  FROM cards  WHERE power = '*'; 
SELECT  cards.promoTypes FROM cards WHERE cards.name = 'Duress'; 
SELECT  bordercolor FROM cards WHERE name = 'Ancestor\'s Chosen';
SELECT  originaltype FROM cards WHERE name = 'Ancestor''s Chosen'; 
SELECT  DISTINCT foreign_data.language FROM cards JOIN sets ON cards.setcode = sets.code JOIN foreign_data ON sets.id = foreign_data.id WHERE cards.name = 'Angel of Mercy'; 
SELECT  COUNT(*)  FROM cards  JOIN legalities ON cards.uuid = legalities.uuid  WHERE legalities.status = 'Restricted' AND cards.istextless = '0'; 
SELECT  rulings.text  FROM rulings  JOIN cards ON rulings.uuid = cards.uuid  WHERE cards.name = 'Condemn'; 
SELECT  COUNT(*)  FROM cards  JOIN legalities ON cards.uuid = legalities.uuid  WHERE legalities.status = 'Restricted'  AND cards.isstarter = 1; 
SELECT  l.status FROM cards c JOIN legalities l ON c.uuid = l.uuid WHERE c.name = "Cloudchaser Eagle"; 
SELECT  type FROM cards WHERE name = 'Benalish Knight'; 
SELECT  legalities.status  FROM cards  JOIN legalities ON cards.uuid = legalities.uuid  WHERE cards.name = 'Benalish Knight'; 
SELECT  artist FROM cards INNER JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Phyrexian';
SELECT  (COUNT(id) * 100.0 / (SELECT COUNT(id) FROM cards)) AS percentage_borderless FROM cards WHERE bordercolor = 'borderless'; 
SELECT  COUNT(DISTINCT cards.id) FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'German' AND cards.isreprint = 1; 
SELECT  COUNT(cards.id) FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.bordercolor = 'borderless' AND foreign_data.language = 'Russian';
SELECT  (COUNT(DISTINCT cards.id) * 100.0 / (SELECT COUNT(DISTINCT cards.id) FROM cards WHERE cards.isstoryspotlight = 1)) AS percentage FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.isstoryspotlight = 1 AND foreign_data.language = 'French'; 
SELECT  COUNT(*) FROM cards WHERE toughness = 99; 
SELECT  name FROM cards WHERE artist = 'Aaron Boyd';
SELECT  COUNT(*)  FROM cards  WHERE bordercolor = 'black' AND availability = 'mtgo';
SELECT  id FROM cards WHERE convertedmanacost = 0; 
SELECT  layout FROM cards WHERE keywords LIKE '%Flying%'; 
SELECT  COUNT(DISTINCT cards.id) FROM cards WHERE originaltype = "Summon - Angel" AND subtypes NOT LIKE "%Angel%";
SELECT  cards.id FROM cards WHERE cards.cardkingdomfoilid IS NOT NULL   AND cards.cardkingdomid IS NOT NULL; 
SELECT  id FROM cards WHERE dueldeck = 'a'; 
SELECT  edhrecrank FROM cards WHERE frameversion = '2015'; 
SELECT  cards.artist FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Chinese Simplified'; 
SELECT  * FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.availability = 'paper' AND foreign_data.language = 'Japanese'; 
SELECT  COUNT(*)  FROM cards  JOIN legalities ON cards.uuid = legalities.uuid  WHERE status = 'Banned' AND bordercolor = 'white'; 
SELECT  cards.uuid, foreign_data.language FROM cards JOIN legalities ON cards.uuid = legalities.uuid JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE legalities.format = 'legacy'; 
SELECT  rulings.text FROM cards JOIN rulings ON rulings.uuid = cards.uuid WHERE cards.name = 'Beacon of Immortality'; 
SELECT  COUNT(*) AS future_frame_count, legalities.status  FROM cards  JOIN legalities ON cards.uuid = legalities.uuid  WHERE cards.frameversion = 'future'  GROUP BY legalities.status; 
SELECT  name, colors FROM cards WHERE setcode = 'OGW'; 
SELECT  DISTINCT cards.name AS card_name, set_translations.language AS translation_language FROM cards JOIN set_translations ON cards.setcode = set_translations.setcode WHERE cards.convertedmanacost = 5 AND cards.setcode = '10E'; 
SELECT  cards.name, rulings.date FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.originaltype LIKE 'Creature - Elf%' 
SELECT  colors, format FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.id BETWEEN 1 AND 20; 
SELECT  c.name FROM cards c JOIN foreign_data fd ON c.uuid = fd.uuid WHERE c.types LIKE '%Artifact%' AND c.colors LIKE '%B%' 
SELECT  c.name FROM cards c JOIN rulings r ON c.uuid = r.uuid WHERE c.rarity = 'uncommon' ORDER BY r.date ASC LIMIT 3; 
SELECT  COUNT(DISTINCT cards.id) FROM cards WHERE cards.artist = 'John Avon' AND cards.hasfoil = 1 AND cards.cardkingdomid IS NULL AND cards.cardkingdomfoilid IS NULL;
SELECT  COUNT(*)  FROM cards  WHERE bordercolor = 'white'  AND cardkingdomfoilid = cardkingdomid  AND cardkingdomid IS NOT NULL
SELECT  COUNT(*) FROM cards WHERE artist = 'UDON' AND availability LIKE '%mtgo%' AND hand = -1;
SELECT  COUNT(*)  FROM cards  WHERE frameversion = '1993'  AND availability LIKE '%paper%'  AND hascontentwarning = 1; 
SELECT  manacost  FROM cards  WHERE layout = 'normal'  AND frameversion = '2003'  AND bordercolor = 'black'  AND availability IN ('paper', 'mtgo'); 
SELECT  SUM(cards.convertedmanacost) AS total_unconverted_mana FROM cards WHERE cards.artist = 'Rob Alexander';
SELECT  DISTINCT types FROM cards WHERE availability LIKE '%arena%'; 
SELECT  sets.code FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language = 'Spanish' 
SELECT  (COUNT(CASE WHEN hand = '+3' THEN 1 END) * 100.0 / COUNT(id)) AS percentage FROM cards WHERE frameeffects LIKE '%legendary%'; 
SELECT  cards.id FROM cards WHERE cards.isstoryspotlight = 1 AND cards.istextless = 0  
SELECT  name FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Spanish' 
SELECT  DISTINCT language FROM set_translations WHERE setcode = (     SELECT code     FROM sets     WHERE basesetsize = 309 ); 
SELECT  COUNT(DISTINCT set_translations.setcode) AS num_translated_sets FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.block = 'Commander' AND set_translations.language = 'Portuguese (Brazil)';
SELECT  cards.id FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.types LIKE '%Creature%' AND legalities.status = 'Legal'; 
SELECT  DISTINCT foreign_data.type FROM foreign_data JOIN cards ON foreign_data.uuid = cards.uuid WHERE foreign_data.language = 'German' AND cards.subtypes IS NOT NULL AND cards.supertypes IS NOT NULL; 
SELECT  COUNT(*)  FROM cards  WHERE power IS NULL  AND originaltext LIKE '%triggered ability%'; 
SELECT  COUNT(*)  FROM cards  JOIN legalities ON cards.uuid = legalities.uuid  JOIN rulings ON cards.uuid = rulings.uuid  WHERE format = 'pre-modern'  AND text LIKE '%This is a triggered mana ability%'  AND side IS NULL; 
SELECT  cards.id FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid JOIN legalities ON cards.uuid = legalities.uuid JOIN sets ON cards.setcode = sets.code JOIN set_translations ON sets.code = set_translations.setcode WHERE cards.artist = 'Erica Yang' AND legalities.format = 'pauper' AND cards.availability LIKE '%paper%'; 
SELECT  cards.artist FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.text = 'Das perfekte Gegenmittel zu einer dichten Formation'; 
SELECT  foreign_data.name FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.artist = 'Matthew D. Wilson' AND cards.layout = 'normal' AND cards.bordercolor = 'black' AND cards.type LIKE '%Creature%' AND foreign_data.language = 'French';
SELECT  COUNT(cards.id) FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.rarity = 'rare' AND rulings.date = '2009-01-10';
SELECT  set_translations.language FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.block = 'Ravnica' AND sets.basesetsize = 180 
SELECT  100 * COUNT(CASE WHEN legalities.format = 'commander' AND legalities.status = 'Legal' AND cards.hascontentwarning = 0 THEN 1 END) / COUNT(cards.id) FROM cards JOIN legalities ON cards.uuid = legalities.uuid;
SELECT  ((SELECT COUNT(*) FROM cards WHERE (language = 'French' AND (power IS NULL OR power = '*'))) * 100) / (SELECT COUNT(*) FROM cards WHERE (power IS NULL OR power = '*')) AS percentage;
SELECT       (COUNT(DISTINCT set_translations.setcode) * 100.0) / COUNT(DISTINCT sets.code) AS percentage_expansion_sets_in_japanese FROM      set_translations  JOIN      sets ON set_translations.setcode = sets.code WHERE      set_translations.language = 'Japanese'      AND sets.type = 'expansion'; 
SELECT  cards.availability FROM cards WHERE cards.artist = 'Daren Bader'; 
SELECT  COUNT(*)  FROM cards  WHERE borderColor = 'borderless' AND edhrecRank > 12000 
SELECT  COUNT(*)  FROM cards  WHERE isoversized = 1  AND isreprint = 1  AND ispromo = 1; 
SELECT  name FROM cards WHERE (power IS NULL OR power = '*') AND cardkingdomid IS NULL AND promotypes LIKE '%arenaleague%' ORDER BY name ASC LIMIT 3; 
SELECT  language FROM foreign_data WHERE multiverseid = 149934;
SELECT  cards.cardkingdomfoilid, cards.cardkingdomid FROM cards WHERE cards.cardkingdomfoilid IS NOT NULL AND cards.cardkingdomid IS NOT NULL ORDER BY cards.cardkingdomfoilid ASC LIMIT 3; 
SELECT  (CAST(COUNT(CASE WHEN cards.istextless = 1 AND cards.layout = 'normal' THEN 1 END) AS REAL) / COUNT(cards.istextless)) * 100 AS proportion_of_textless_normal_cards FROM cards;
SELECT  cards.number FROM cards LEFT JOIN cards AS other_face ON cards.uuid = other_face.uuid AND other_face.side IS NOT NULL WHERE cards.subtypes LIKE '%Angel%' AND cards.subtypes LIKE '%Wizard%' AND other_face.uuid IS NULL 
SELECT  sets.name FROM sets LEFT JOIN cards ON sets.code = cards.setcode WHERE cards.mtgoCode IS NULL OR cards.mtgoCode = '' ORDER BY sets.name ASC LIMIT 3; 
SELECT  DISTINCT language FROM foreign_data JOIN cards ON foreign_data.uuid = cards.uuid JOIN sets ON cards.setcode = sets.code WHERE sets.name = 'Archenemy' AND sets.code = 'ARC'; 
SELECT  sets.name, set_translations.translation  FROM sets  JOIN set_translations ON sets.code = set_translations.setcode  WHERE sets.id = 5; 
SELECT  set_translations.language, sets.type FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.id = 206; 
SELECT  sets.name AS set_name, sets.id AS set_id FROM sets JOIN set_translations ON sets.code = set_translations.setcode JOIN cards ON cards.uuid = set_translations.uuid JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Italian' AND sets.block = 'Shadowmoor' ORDER BY sets.name ASC LIMIT 2; 
SELECT  sets.id FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.isforeignonly = 1 AND sets.isfoilonly = 1 AND set_translations.language = 'Japanese';
SELECT  sets.name FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language = 'Russian' ORDER BY sets.basesetsize DESC LIMIT 1; 
SELECT  (COUNT(cards.id) * 100.0) / (SELECT COUNT(*) FROM cards) AS percentage FROM cards INNER JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Chinese Simplified' AND cards.isonlineonly = 1; 
SELECT  COUNT(DISTINCT sets.id) FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language = 'Japanese' AND (sets.mtgocode IS NULL OR sets.mtgocode = '')
SELECT  id FROM cards WHERE bordercolor = 'black'; 
SELECT  id FROM cards WHERE frameeffects = 'extendedart'; 
SELECT  name FROM cards WHERE bordercolor = 'black' AND isfullart = 1; 
SELECT  foreign_data.language FROM sets JOIN set_translations ON sets.code = set_translations.setcode JOIN foreign_data ON foreign_data.uuid = sets.id WHERE sets.id = 174; 
SELECT  sets.name FROM sets WHERE sets.code = "ALL"; 
SELECT  language FROM foreign_data WHERE name = 'A Pedra Fellwar'; 
SELECT  code  FROM sets  WHERE releasedate = '2007-07-13'; 
SELECT  basesetsize, code FROM sets WHERE block IN ('Masques', 'Mirage'); 
SELECT  sets.code FROM sets WHERE sets.type = 'expansion'; 
SELECT  foreign_data.name, cards.type FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid JOIN sets ON cards.setcode = sets.code WHERE cards.watermark = 'boros'; 
SELECT  foreign_data.language, foreign_data.flavortext, cards.type FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.watermark = 'colorpie'; 
SELECT  COUNT(*) * 100.0 / (SELECT COUNT(*) FROM cards WHERE name = 'Abyssal Horror')  FROM cards  WHERE name = 'Abyssal Horror' AND convertedmanacost = 10; 
SELECT  sets.code FROM sets WHERE sets.type = 'expansion' AND sets.block = 'Commander'; 
SELECT  foreign_data.name AS foreign_name, cards.type AS card_type FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid JOIN sets ON cards.setcode = sets.code WHERE cards.watermark = 'abzan'; 
SELECT  foreign_data.language, cards.type FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.watermark = 'azorius'; 
SELECT  COUNT(*)  FROM cards  WHERE artist = 'Aaron Miller'  AND cardkingdomfoilid = cardkingdomid  AND cardkingdomid IS NOT NULL; 
SELECT  COUNT(*)  FROM cards  WHERE availability LIKE '%paper%'  AND hand LIKE '+%'; 
SELECT  name FROM cards WHERE istextless = 0; 
SELECT  convertedmanacost FROM cards WHERE name = 'Ancestor`s Chosen'; 
SELECT  COUNT(*) FROM cards WHERE bordercolor = 'white' AND (power = '*' OR power IS NULL); 
SELECT  DISTINCT cards.name FROM cards WHERE cards.ispromo = 1 AND cards.side IS NOT NULL; 
SELECT  types FROM cards WHERE name = 'Molimo, Maro-Sorcerer'; 
SELECT purchaseurls FROM cards WHERE promotypes LIKE '%bundle%'; 
SELECT  COUNT(DISTINCT artist) FROM cards WHERE bordercolor = 'black' AND availability LIKE '%arena,mtgo%'; 
SELECT      name,     convertedmanacost FROM     cards WHERE     name IN ('Serra Angel', 'Shrine Keeper') ORDER BY     convertedmanacost DESC LIMIT 1;
SELECT  artist FROM cards WHERE flavornam='Battra, Dark Destroyer';
SELECT  name FROM cards WHERE frameversion = '2003' ORDER BY convertedmanacost DESC LIMIT 3; 
SELECT  set_translations.translation FROM cards JOIN set_translations ON cards.setcode = set_translations.setcode WHERE cards.name = 'Ancestor\'s Chosen' AND set_translations.language = 'Italian'; 
SELECT  COUNT(DISTINCT set_translations.translation) AS translation_count FROM cards JOIN set_translations ON cards.setcode = set_translations.setcode WHERE cards.name = 'Angel of Mercy';
SELECT  cards.name FROM cards JOIN set_translations ON cards.setcode = set_translations.setcode WHERE set_translations.translation = 'Hauptset Zehnte Edition'; 
SELECT  DISTINCT foreign_data.name FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.name = 'Ancestor''s Chosen' AND foreign_data.language = 'Korean'; 
SELECT  COUNT(*)  FROM cards  JOIN set_translations ON cards.setcode = set_translations.setcode  WHERE set_translations.translation = 'Hauptset Zehnte Edition'  AND cards.artist = 'Adam Rex';
SELECT  COUNT(*)  FROM cards  JOIN sets ON cards.setcode = sets.code  JOIN set_translations ON sets.code = set_translations.setcode  WHERE set_translations.translation = 'Hauptset Zehnte Edition';
SELECT  set_translations.translation FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.name = 'Eighth Edition' AND set_translations.language = 'Chinese Simplified'; 
SELECT  COUNT(*) FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.name = 'Angel of Mercy' AND sets.mtgocode IS NOT NULL; 
SELECT  sets.releasedate FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.name = 'Ancestor''s Chosen'; 
SELECT  sets.type FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Hauptset Zehnte Edition'; 
SELECT  COUNT(sets.code) FROM sets INNER JOIN set_translations ON sets.code = set_translations.setcode WHERE sets.block = 'Ice Age' AND set_translations.language = 'Italian';
SELECT  COUNT(*) AS num_cards_outside_US FROM cards WHERE name = 'Adarkar Valkyrie' AND isForeignOnly = 1; 
SELECT  COUNT(*)  FROM sets  WHERE sets.id IN (SELECT DISTINCT sets.id                    FROM sets                    JOIN set_translations ON sets.code = set_translations.setcode                    WHERE set_translations.language = 'Italian' AND set_translations.translation IS NOT NULL)  AND sets.basesetsize < 10; 
SELECT  COUNT(*)  FROM cards  JOIN sets ON cards.setcode = sets.code  WHERE sets.name = 'Coldsnap'  AND cards.bordercolor = 'black'; 
SELECT  c.name FROM cards c JOIN sets s ON c.setcode = s.code WHERE s.name = 'Coldsnap' ORDER BY c.convertedmanacost DESC LIMIT 1; 
SELECT  DISTINCT artist FROM cards INNER JOIN sets ON cards.setcode = sets.code WHERE sets.name = 'Coldsnap' AND artist IN ('Jeremy Jarvis', 'Aaron Miller', 'Chippy'); 
SELECT  * FROM cards WHERE setcode = (         SELECT code         FROM sets         WHERE name = 'Coldsnap'     )     AND number = '4'; 
SELECT  COUNT(*)  FROM cards  JOIN sets ON cards.uuid = sets.uuid  WHERE sets.name = 'Coldsnap'  AND cards.convertedmanacost > 5  AND (cards.power = '*' OR cards.power IS NULL); 
SELECT  foreign_data.flavortext FROM cards JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE cards.name = 'Ancestor''s Chosen' AND foreign_data.language = 'Italian'; 
SELECT  DISTINCT language FROM foreign_data WHERE uuid IN (SELECT uuid FROM cards WHERE name = 'Ancestor''s Chosen' AND flavorText IS NOT NULL); 
SELECT  `foreign_data`.`type`  FROM `foreign_data` JOIN `cards` ON `foreign_data`.`uuid` = `cards`.`uuid` WHERE `foreign_data`.`language` = 'German'  AND `cards`.`name` = 'Ancestor''s Chosen';
SELECT  foreign_data.text FROM cards JOIN sets ON cards.setcode = sets.code JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE sets.name = 'Coldsnap' AND foreign_data.language = 'Italian'; 
SELECT  foreign_data.name FROM foreign_data JOIN cards ON foreign_data.uuid = cards.uuid JOIN sets ON cards.setcode = sets.code WHERE sets.name = 'Coldsnap' AND cards.convertedmanacost = (     SELECT MAX(convertedmanacost)     FROM cards     WHERE cards.setcode = 'Coldsnap' ); 
SELECT  rulings.date FROM rulings JOIN cards ON rulings.uuid = cards.uuid WHERE cards.name = 'Reminisce'; 
SELECT  ((SELECT COUNT(*) FROM cards WHERE convertedmanacost = 7 AND setcode = (SELECT code FROM sets WHERE name = 'Coldsnap')) * 100.0) / (SELECT COUNT(*) FROM cards WHERE setcode = (SELECT code FROM sets WHERE name = 'Coldsnap')); 
SELECT  ((SELECT COUNT(*) FROM cards WHERE setcode = (SELECT code FROM sets WHERE name = 'Coldsnap') AND cardkingdomfoilid IS NOT NULL AND cardkingdomid IS NOT NULL) * 100.0 / (SELECT COUNT(*) FROM cards WHERE setcode = (SELECT code FROM sets WHERE name = 'Coldsnap'))) AS percentage_incredibly_powerful
SELECT  sets.code FROM sets WHERE sets.releasedate = '2017-07-14';
SELECT  sets.keyrunecode FROM sets WHERE sets.code = 'PKHC';
SELECT  sets.mcmid FROM sets WHERE sets.code = 'SS2'; 
SELECT  sets.mcmname FROM sets WHERE sets.releasedate = '2017-06-09';
SELECT  sets.type FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation LIKE '%From the Vault: Lore%'; 
SELECT  sets.parentcode FROM sets WHERE sets.name = 'Commander 2014 Oversized'; 
SELECT  cards.name, rulings.text, cards.hascontentwarning FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.artist = 'Jim Pavelec'; 
SELECT  sets.releasedate FROM cards JOIN sets ON cards.setcode = sets.code WHERE cards.name = 'Evacuation'; 
SELECT  sets.basesetsize FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Rinascita di Alara'; 
SELECT  sets.type FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Huitième édition'; 
SELECT  set_translations.translation FROM cards JOIN set_translations ON cards.setcode = set_translations.setcode WHERE cards.name = "Tendo Ice Bridge" AND set_translations.language = 'French';
SELECT  COUNT(set_translations.translation) FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.name = 'Salvat 2011';
SELECT  set_translations.translation FROM cards JOIN set_translations ON cards.setcode = set_translations.setcode WHERE cards.name = 'Fellwar Stone' AND set_translations.language = 'Japanese'; 
SELECT  name FROM cards WHERE setcode = (     SELECT code     FROM sets     WHERE name = 'Journey into Nyx Hero''s Path' ) ORDER BY convertedmanacost DESC LIMIT 1; 
SELECT  sets.releasedate FROM sets JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.translation = 'Ola de frío'; 
SELECT  sets.type  FROM cards  JOIN sets ON cards.setcode = sets.code  WHERE cards.name = 'Samite Pilgrim'; 
SELECT  COUNT(*) FROM cards JOIN sets ON cards.setcode = sets.code WHERE sets.name = 'World Championship Decks 2004' AND cards.convertedmanacost = 3 
SELECT  set_translations.translation FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE set_translations.language = 'Chinese Simplified' AND sets.name = 'Mirrodin'; 
SELECT       (SUM(cards.isnonfoilonly = 1) / SUM(foreign_data.language = 'Japanese')) * 100 AS percentage_of_nonfoil_only_japanese_cards  FROM      cards  JOIN      foreign_data ON cards.uuid = foreign_data.uuid  WHERE      foreign_data.language = 'Japanese'; 
SELECT (SELECT COUNT(*) FROM cards INNER JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Portuguese (Brazil)' AND cards.isonlineonly = 1) * 100.0 / (SELECT COUNT(*) FROM cards INNER JOIN foreign_data ON cards.uuid = foreign_data.uuid WHERE foreign_data.language = 'Portuguese (Brazil)') AS percentage_online_only; 
SELECT DISTINCT availability FROM cards WHERE artist = 'Aleksi Briclot' AND istextless = 1; 
SELECT  id FROM sets ORDER BY basesetsize DESC LIMIT 1; 
SELECT  artist FROM cards WHERE side IS NULL ORDER BY convertedmanacost DESC LIMIT 1; 
SELECT  MAX(frameeffects) FROM cards WHERE hasfoil = 1 AND cardkingdomfoilid IS NOT NULL AND cardkingdomid IS NOT NULL;
SELECT  COUNT(*) FROM cards WHERE (power IS NULL OR power = '*') AND hasfoil = 0 AND dueldeck = 'a';
SELECT  sets.id FROM sets WHERE sets.type = 'commander' AND sets.totalsetsize = (     SELECT MAX(sets.totalsetsize)     FROM sets     WHERE sets.type = 'commander'     AND sets.code NOT LIKE '%A%' );
SELECT  name, convertedmanacost FROM cards WHERE dueldeck = 'duel' ORDER BY convertedmanacost DESC LIMIT 10; 
SELECT  MIN(c.originalreleasedate) AS oldest_release_date, l.format AS legal_play_format FROM cards c JOIN legalities l ON c.uuid = l.uuid WHERE c.rarity = 'mythic' AND l.status = 'Legal'
SELECT  COUNT(*)  FROM cards  JOIN foreign_data ON cards.uuid = foreign_data.uuid  WHERE artist = 'Volkan Baga' AND language = 'French'; 
SELECT  COUNT(*)  FROM cards  JOIN legalities ON cards.uuid = legalities.uuid  WHERE cards.name = 'Abundance'  AND cards.rarity = 'rare'  AND cards.types LIKE '%Enchantment%'  AND legalities.format = 'brawl'  AND legalities.status = 'Legal'; 
SELECT  legalities.format, cards.name FROM legalities JOIN cards ON legalities.uuid = cards.uuid WHERE legalities.status = 'Banned' GROUP BY legalities.format ORDER BY COUNT(legalities.status = 'Banned') DESC LIMIT 1; 
SELECT  set_translations.language FROM set_translations JOIN sets ON set_translations.setcode = sets.code WHERE sets.name = 'Battlebond'; 
SELECT  artist, GROUP_CONCAT(DISTINCT legalities.format) AS formats_of_play FROM cards LEFT JOIN legalities ON cards.uuid = legalities.uuid GROUP BY artist ORDER BY COUNT(*) ASC LIMIT 1; 
SELECT  legalities.status FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE cards.frameversion = '1997' AND cards.artist = 'D. Alexander Gregory' AND legalities.format = 'legacy' AND (cards.hascontentwarning = 1 OR cards.artist = 'Wizards of the Coast'); 
SELECT  name, format FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE legalities.status = 'Banned' AND legalities.format = 'commander' AND cards.edhrecrank = 1;
SELECT  AVG(sets.id), MAX(COUNT(foreign_data.language)) FROM sets JOIN set_translations ON sets.code = set_translations.setcode JOIN foreign_data ON foreign_data.uuid = cards.uuid WHERE sets.releasedate BETWEEN '2012-01-01' AND '2015-12-31'; 
SELECT  DISTINCT artist FROM cards WHERE bordercolor = 'black' AND availability = 'arena'; 
SELECT  cards.uuid FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE legalities.format = 'oldschool' AND (legalities.status = 'banned' OR legalities.status = 'restricted');
SELECT  COUNT(*) FROM cards WHERE artist = 'Matthew D. Wilson' AND availability = 'paper';
SELECT  rulings.text FROM cards JOIN rulings ON cards.uuid = rulings.uuid WHERE cards.artist = 'Kev Walker' ORDER BY rulings.date DESC; 
SELECT  cards.name, legalities.format FROM cards JOIN sets ON cards.setcode = sets.code JOIN legalities ON cards.uuid = legalities.uuid WHERE sets.name = 'Hour of Devastation' AND legalities.status = 'Legal'; 
SELECT  DISTINCT sets.name FROM sets LEFT JOIN set_translations ON sets.code = set_translations.setcode WHERE set_translations.language NOT LIKE '%Japanese%' AND set_translations.language = 'Korean'; 
SELECT  frameversion, name FROM cards WHERE artist = 'Allen Williams' AND frameversion IS NOT NULL UNION SELECT DISTINCT frameversion, name FROM cards JOIN legalities ON cards.uuid = legalities.uuid WHERE artist = 'Allen Williams' AND status = 'Banned';
SELECT  MAX(reputation) AS highest_reputation FROM users WHERE displayname = 'Harlan' OR displayname = 'Jarrod Dixon';
SELECT  displayname FROM users WHERE strftime('%Y', creationdate) = '2014'; 
SELECT  COUNT(DISTINCT users.id) FROM users WHERE LastAccessDate > '2014-09-01 00:00:00';
SELECT  users.displayname FROM users JOIN posts ON users.id = posts.owneruserid ORDER BY posts.viewcount DESC LIMIT 1;
SELECT COUNT(DISTINCT users.id) FROM users WHERE users.upvotes > 100 AND users.downvotes > 1 
SELECT  COUNT(DISTINCT users.id) FROM users JOIN posts ON users.id = posts.owneruserid WHERE users.creationdate > '2013-01-01' AND posts.viewcount > 10; 
SELECT  COUNT(*)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = 'csgillespie';
SELECT  title FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie'; 
SELECT posts.ownerdisplayname FROM posts WHERE posts.title = 'Eliciting priors from experts'; 
SELECT  posts.title FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie' ORDER BY posts.viewcount DESC LIMIT 1;
SELECT  users.displayname FROM posts JOIN users ON posts.owneruserid = users.id ORDER BY posts.favoritecount DESC LIMIT 1;
SELECT  SUM(posts.commentcount) AS total_comments FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie';
SELECT  MAX(posts.answercount) AS max_answer_count FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie';
SELECT  users.displayname FROM posts JOIN users ON posts.lasteditoruserid = users.id WHERE posts.title = 'Examples for teaching: Correlation does not mean causation'
SELECT  COUNT(*)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = 'csgillespie' AND posts.parentid IS NULL;
SELECT  DISTINCT u.displayname FROM users u JOIN posts p ON u.id = p.owneruserid WHERE p.closeddate IS NOT NULL; 
SELECT  COUNT(DISTINCT posts.id) FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.age > 65 AND posts.score >= 20;
SELECT  users.location FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = 'Eliciting priors from experts';
SELECT  p.body FROM posts p JOIN tags t ON p.id = t.excerptpostid WHERE t.tagname = 'bayesian'; 
SELECT  p.body FROM posts p JOIN tags t ON t.excerptpostid = p.id WHERE t.count = (SELECT MAX(count) FROM tags); 
SELECT  COUNT(badges.id) FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = 'csgillespie';
SELECT  badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = 'csgillespie';
SELECT  COUNT(*) FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = 'csgillespie' AND strftime('%Y', badges.date) = '2011';
SELECT  users.displayname FROM users JOIN badges ON users.id = badges.userid GROUP BY users.id ORDER BY COUNT(badges.id) DESC LIMIT 1;
SELECT  AVG(posts.score) AS average_score FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'csgillespie';
SELECT  ROUND(CAST(COUNT(badges.id) AS FLOAT) / COUNT(DISTINCT users.displayname), 2) AS average_badges FROM badges JOIN users ON badges.userid = users.id JOIN posts ON users.id = posts.owneruserid WHERE users.views > 200;
SELECT       (COUNT(DISTINCT posts.id) FILTER (WHERE users.age > 65 AND posts.score > 20) * 100.0) / COUNT(DISTINCT posts.id) AS percentage FROM      posts JOIN      users ON posts.owneruserid = users.id WHERE      posts.score > 20; 
SELECT  COUNT(*)  FROM votes  WHERE userid = 58  AND creationdate LIKE '2010-07-19%'
SELECT  MAX(creationdate) AS max_creation_date FROM (     SELECT COUNT(id) AS vote_count, creationdate     FROM votes     GROUP BY creationdate ) AS vote_counts;
SELECT  COUNT(*) FROM badges WHERE name = 'Revival';
SELECT  posts.title FROM posts JOIN comments ON posts.id = comments.postid WHERE comments.score = (SELECT MAX(score) FROM comments);
SELECT  COUNT(*) AS comment_count FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.viewcount = 1910; 
SELECT  COUNT(posts.favoritecount) FROM posts JOIN comments ON posts.id = comments.postid WHERE comments.userid = 3025 AND comments.creationdate = '2014-04-23 20:29:39.0';
SELECT  comments.text FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.parentid = 107829 LIMIT 1;
SELECT  CASE WHEN posts.closeddate IS NULL THEN 'Well-finished' ELSE 'Not well-finished' END AS post_status FROM comments JOIN posts ON comments.postid = posts.id WHERE comments.userid = 23853 AND comments.creationdate = '2013-07-12 09:08:18.0' 
SELECT  u.reputation FROM posts p JOIN users u ON p.owneruserid = u.id WHERE p.id = 65041; 
SELECT  COUNT(posts.id) FROM users JOIN posts ON users.id = posts.owneruserid WHERE users.displayname = "Tiago Pasqualini";
SELECT  users.displayname FROM votes JOIN users ON votes.userid = users.id WHERE votes.id = 381800;
SELECT  COUNT(votes.id)  FROM votes  JOIN posts ON votes.postid = posts.id  WHERE posts.title LIKE '%data visualization%';
SELECT  badges.name FROM users JOIN badges ON badges.userid = users.id WHERE users.displayname = "DatEpicCoderGuyWhoPrograms";
SELECT  COUNT(posts.id) / COUNT(votes.id) FROM posts LEFT JOIN votes ON posts.id = votes.postid WHERE posts.owneruserid = 24;
SELECT  viewcount FROM posts WHERE title = 'Integration of Weka and/or RapidMiner into Informatica PowerCenter/Developer'; 
SELECT  text FROM comments WHERE score = 17; 
SELECT  displayname FROM users WHERE websiteurl = 'http://stackoverflow.com'; 
SELECT  badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = 'SilentGhost'; 
SELECT  users.displayname FROM comments JOIN users ON comments.userid = users.id WHERE comments.text = 'thank you user93!';
SELECT  comments.text FROM comments JOIN users ON comments.userid = users.id WHERE users.displayname = 'A Lion'; 
SELECT  users.displayname, users.reputation FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = 'Understanding what Dassault iSight is doing?';
SELECT  comments.text FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.title = 'How does gentle boosting differ from AdaBoost?';
SELECT  DISTINCT users.displayname FROM users JOIN badges ON users.id = badges.userid WHERE badges.name = 'Necromancer' LIMIT 10; 
SELECT  users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.title = 'Open source tools for visualizing multi-dimensional data?';
SELECT  posts.title FROM posts JOIN users ON posts.lasteditoruserid = users.id WHERE users.displayname = 'Vebjorn Ljosa';
SELECT  SUM(posts.score) FROM posts JOIN users ON posts.lasteditoruserid = users.id WHERE users.displayname = 'Yevgeny' AND users.websiteurl IS NOT NULL;
SELECT  comments.text FROM comments JOIN posts ON comments.postid = posts.id JOIN posthistory ON posts.id = posthistory.postid JOIN users ON comments.userid = users.id WHERE posthistory.posthistorytypeid = 5 AND posts.title = 'Why square the difference instead of taking the absolute value in standard deviation?'; 
SELECT  SUM(votes.bountyamount) AS total_bounty_amount FROM posts JOIN votes ON posts.id = votes.postid WHERE posts.title LIKE '%data%';
SELECT  users.displayname FROM users JOIN votes ON users.id = votes.userid JOIN posts ON votes.postid = posts.id WHERE posts.title LIKE '%variance%' AND votes.bountyamount = 50;
SELECT    AVG(posts.viewcount) AS average_view_count, posts.title, comments.text, posts.score FROM posts JOIN posttags ON posts.id = posttags.postid JOIN tags ON posttags.tagid = tags.id LEFT JOIN comments ON posts.id = comments.postid WHERE tags.tagname = 'humor' GROUP BY posts.id; 
SELECT  COUNT(*)  FROM comments  WHERE userid = 13; 
SELECT  MAX(id) AS highest_reputation_user_id FROM users WHERE reputation = (SELECT MAX(reputation) FROM users);
SELECT  MIN(users.id) AS LowestUserID FROM users WHERE views = (SELECT MIN(views) FROM users);
SELECT  COUNT(DISTINCT users.id) FROM badges JOIN users ON badges.userid = users.id WHERE badges.name = 'Supporter' AND strftime('%Y', badges.date) = '2011'
SELECT  COUNT(userid) AS Total_Users_With_More_Than_5_Badges FROM (     SELECT userid, COUNT(name) AS Badge_Count     FROM badges     GROUP BY userid     HAVING Badge_Count > 5 ) AS Users_With_More_Than_5_Badges; 
SELECT  COUNT(DISTINCT users.id) AS "Number of users from New York with Teacher and Supporter badges" FROM users JOIN badges ON users.id = badges.userid WHERE users.location = 'New York' AND badges.name IN ('Teacher', 'Supporter');
SELECT  users.id, users.reputation FROM users JOIN posts ON posts.owneruserid = users.id WHERE posts.id = 1; 
SELECT  DISTINCT ph.userid FROM posthistory ph JOIN posts p ON ph.postid = p.id WHERE p.viewcount >= 1000 GROUP BY ph.userid, ph.postid HAVING COUNT(*) = 1; 
SELECT  users.id, users.displayname, badges.name FROM users JOIN comments ON users.id = comments.userid LEFT JOIN badges ON users.id = badges.userid GROUP BY users.id ORDER BY COUNT(comments.id) DESC LIMIT 1; 
SELECT  COUNT(DISTINCT users.id) FROM users JOIN badges ON badges.userid = users.id WHERE users.location = 'India' AND badges.name = 'Teacher'; 
SELECT  ((SELECT COUNT(*) FROM badges WHERE name = 'Student' AND strftime('%Y', date) = '2010') -  (SELECT COUNT(*) FROM badges WHERE name = 'Student' AND strftime('%Y', date) = '2011')) * 100 /  (SELECT COUNT(*) FROM badges WHERE name = 'Student' AND strftime('%Y', date) = '2011') AS percentage_difference;
SELECT  DISTINCT posthistorytypeid, COUNT(DISTINCT comments.userid) AS unique_commenters FROM posthistory LEFT JOIN comments ON posthistory.postid = comments.postid WHERE posthistory.postid = 3720 GROUP BY posthistorytypeid; 
SELECT posts.id, posts.title, posts.viewcount AS popularity FROM posts JOIN postlinks ON posts.id = postlinks.postid WHERE postlinks.relatedpostid = 61217; 
SELECT  posts.score, postlinks.linktypeid FROM posts JOIN postlinks ON posts.id = postlinks.postid WHERE posts.id = 395; 
SELECT posts.id, posts.owneruserid FROM posts WHERE posts.score > 60 
SELECT  SUM(posts.favoritecount) AS total_favorite_count FROM posts WHERE posts.owneruserid = 686 AND substr(posts.creationdate, 1, 4) = '2011';
SELECT  AVG(posts.upvotes) AS average_upvotes, AVG(users.age) AS average_age FROM users JOIN posts ON users.id = posts.owneruserid GROUP BY posts.owneruserid HAVING COUNT(posts.owneruserid) > 10; 
SELECT  COUNT(DISTINCT badges.userid) AS "Number of Users Obtained Announcer Badge" FROM badges WHERE badges.name = 'Announcer';
SELECT  badges.name FROM badges JOIN users ON badges.userid = users.id WHERE strftime('%Y-%m-%d %H:%M:%S', badges.date) = '2010-07-19 19:39:08'
SELECT  COUNT(*)  FROM comments  WHERE score > 60;
SELECT  text FROM comments WHERE creationdate = '2010-07-19 19:25:47.0'; 
SELECT  COUNT(*) FROM posts WHERE score = 10;
SELECT  badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.reputation = (SELECT MAX(reputation) FROM users);
SELECT  users.reputation FROM users INNER JOIN badges ON users.id = badges.userid WHERE badges.date = '2010-07-19 19:39:08.0'; 
SELECT  badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = "Pierre"; 
SELECT  DISTINCT badges.date FROM badges JOIN users ON badges.userid = users.id WHERE users.location = 'Rochester, NY'; 
SELECT  COUNT(DISTINCT b.userid) * 100 / (SELECT COUNT(DISTINCT userid) FROM badges) AS Percentage FROM badges b WHERE b.name = 'Teacher'; 
SELECT  100.0 * (     SELECT COUNT(DISTINCT u.id)      FROM users u     JOIN badges b ON u.id = b.userid      WHERE b.name = 'Organizer' ) / (     SELECT COUNT(DISTINCT u.id)      FROM users u     JOIN badges b ON u.id = b.userid      WHERE b.name = 'Organizer' )
SELECT  c.score FROM comments c JOIN posts p ON c.postid = p.id WHERE p.creationdate = '2010-07-19 19:19:56.0'; 
SELECT  comments.text FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.creationdate = '2010-07-19 19:37:33.0' 
SELECT  users.age FROM users JOIN badges ON badges.userid = users.id WHERE users.location = 'Vienna, Austria';
SELECT  COUNT(DISTINCT users.id) FROM users JOIN badges ON users.id = badges.userid WHERE badges.name = 'Supporter' AND users.age BETWEEN 19 AND 65;
SELECT  SUM(posts.viewcount) AS total_views FROM posts JOIN badges ON badges.userid = posts.owneruserid WHERE badges.date = '2010-07-19 19:39:08.0' 
SELECT  badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.reputation = (SELECT MIN(reputation) FROM users)
SELECT  badges.name FROM badges JOIN users ON badges.userid = users.id WHERE users.displayname = "Sharpie"; 
SELECT  COUNT(DISTINCT users.id) FROM users JOIN badges ON users.id = badges.userid WHERE badges.name = 'Supporter' AND users.age > 65;
SELECT  displayname  FROM users  WHERE id = 30; 
SELECT  COUNT(DISTINCT users.id) FROM users WHERE users.location = 'New York';
SELECT  COUNT(*)  FROM votes  WHERE strftime('%Y', creationdate) = '2010';
SELECT  COUNT(DISTINCT users.id)  FROM users  WHERE age BETWEEN 19 AND 65;
SELECT  displayname FROM users WHERE views = (SELECT MAX(views) FROM users); 
SELECT  DIVIDE(     (SELECT COUNT(id) FROM votes WHERE strftime('%Y', creationdate) = '2010'),     (SELECT COUNT(id) FROM votes WHERE strftime('%Y', creationdate) = '2011') ) FROM votes;
SELECT  tags.tagname FROM tags JOIN posts ON tags.excerptpostid = posts.id JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'John Stauffer'; 
SELECT  COUNT(*) FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'Daniel Vassallo';
SELECT  COUNT(*) AS "Total Votes Made by Harlan" FROM votes JOIN users ON votes.userid = users.id WHERE users.displayname = 'Harlan';
SELECT  id  FROM posts  WHERE owneruserid = (SELECT id FROM users WHERE displayname = 'slashnick')  ORDER BY answercount DESC  LIMIT 1; 
SELECT  MAX(SUM(viewcount)) AS max_view_count FROM (     SELECT SUM(p.viewcount) AS viewcount     FROM posts p     JOIN users u ON p.owneruserid = u.id     WHERE u.displayname IN ('Harvey Motulsky', 'Noah Snyder')     GROUP BY u.displayname ) AS popularity;
SELECT  COUNT(*) FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'Matt Parker' AND posts.score > 4; 
SELECT  COUNT(comments.id) FROM comments JOIN users ON comments.userid = users.id JOIN posts ON comments.postid = posts.id WHERE users.displayname = 'Neil McGuigan' AND comments.score < 60;
SELECT  DISTINCT tags.tagname FROM users JOIN posts ON users.id = posts.owneruserid JOIN tags ON posts.tags LIKE '%' || tags.tagname || '%' LEFT JOIN comments ON posts.id = comments.postid WHERE users.displayname = 'Mark Meckes' AND comments.id IS NULL; 
SELECT users.displayname FROM users JOIN badges ON users.id = badges.userid WHERE badges.name = 'Organizer'; 
SELECT  (CAST((SELECT COUNT(posts.id)  FROM posts  JOIN tags ON tags.excerptpostid = posts.id  JOIN users ON posts.owneruserid = users.id  WHERE tags.tagname = 'r' AND users.displayname = 'Community') AS REAL) /  CAST((SELECT COUNT(posts.id)  FROM posts  JOIN users ON posts.owneruserid = users.id  WHERE users.displayname = 'Community') AS REAL)) * 100 AS percentage;
SELECT  SUM(CASE WHEN u.displayname = 'mornington' THEN p.viewcount ELSE 0 END) - SUM(CASE WHEN u.displayname = 'Amos' THEN p.viewcount ELSE 0 END) FROM posts p JOIN users u ON p.owneruserid = u.id WHERE u.displayname IN ('mornington', 'Amos');
SELECT  COUNT(DISTINCT badges.userid)  FROM badges  WHERE badges.name = 'Commentator'  AND strftime('%Y', badges.date) = '2014';
SELECT  COUNT(*)  FROM posts WHERE CreationDate BETWEEN '2010-07-21 00:00:00' AND '2010-07-21 23:59:59';
SELECT  users.displayname, users.age  FROM users  JOIN posts ON users.id = posts.owneruserid  ORDER BY posts.viewcount DESC  LIMIT 1; 
SELECT  lasteditdate, lasteditoruserid FROM posts WHERE title = 'Detecting a given face in a database of facial images'; 
SELECT  COUNT(comments.id) AS negative_comments_count FROM comments WHERE comments.userid = 13 AND comments.score < 60;
SELECT  DISTINCT p.title, c.userdisplayname FROM posts p JOIN comments c ON p.id = c.postid WHERE c.score > 60; 
SELECT  badges.name FROM badges JOIN users ON badges.userid = users.id WHERE strftime('%Y', badges.date) = '2011' AND users.location = 'North Pole'; 
SELECT  DISTINCT users.displayname, users.websiteurl FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.favoritecount > 150; 
SELECT  COUNT(posthistory.id) AS post_history_counts, MAX(posts.lasteditdate) AS last_edit_date FROM posts JOIN posthistory ON posts.id = posthistory.postid WHERE posts.title = "What is the best introductory Bayesian statistics textbook?"; 
SELECT  users.lastaccessdate, users.location FROM users JOIN badges ON users.id = badges.userid WHERE badges.name = 'outliers'; 
SELECT  related.title FROM posts AS main JOIN postlinks ON main.id = postlinks.relatedpostid JOIN posts AS related ON postlinks.postid = related.id WHERE main.title = 'How to tell if something happened in a data set which monitors a value over time'; 
SELECT posts.id, badges.name FROM users JOIN posts ON posts.owneruserid = users.id JOIN badges ON badges.userid = users.id WHERE users.displayname = 'Samuel' AND strftime('%Y', posts.creationdate) = '2013' AND strftime('%Y', badges.date) = '2013' 
SELECT  users.displayname AS owner_display_name FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.viewcount = (SELECT MAX(viewcount) FROM posts) LIMIT 1; 
SELECT  users.displayname, users.location FROM users JOIN posts ON users.id = posts.owneruserid JOIN tags ON posts.id = tags.excerptpostid WHERE tags.tagname = 'hypothesis-testing';
SELECT  posts.title, postlinks.linktypeid FROM posts JOIN postlinks ON posts.id = postlinks.relatedpostid WHERE posts.title = 'What are principal component scores?'; 
SELECT  posts.displayname FROM posts WHERE id = (     SELECT parentid     FROM posts     WHERE id = (         SELECT postid         FROM posts         WHERE posttypeid = 2         ORDER BY score DESC         LIMIT 1     ) )
SELECT   users.displayname, users.websiteurl FROM users JOIN votes ON users.id = votes.userid WHERE votes.votetypeid = 8 AND votes.bountyamount = (     SELECT MAX(bountyamount) FROM votes WHERE votetypeid = 8 ); 
SELECT title FROM posts ORDER BY viewcount DESC LIMIT 5; 
SELECT  COUNT(tags.tagname) AS tag_count FROM tags JOIN (     SELECT tags.id, COUNT(posts.id) AS post_count     FROM tags     JOIN posts ON tags.excerptpostid = posts.id     GROUP BY tags.id     HAVING post_count BETWEEN 5000 AND 7000 ) AS tagged_posts ON tags.id = tagged_posts.id;
SELECT posts.owneruserid FROM posts WHERE favoritecount = (SELECT MAX(favoritecount) FROM posts); 
SELECT  MAX(age) AS "Oldest User Age" FROM users WHERE reputation = (SELECT MAX(reputation) FROM users);
SELECT  COUNT(DISTINCT posts.id) FROM posts JOIN votes ON posts.id = votes.postid WHERE strftime('%Y', posts.creationdate) = '2011' AND votes.bountyamount = 50;
SELECT  MIN(id) FROM users WHERE age = (SELECT MIN(age) FROM users);
SELECT  MAX(p.score) AS score FROM posts p JOIN posttags pt ON p.id = pt.postid JOIN tags t ON pt.tagid = t.id GROUP BY t.tagname ORDER BY COUNT(*) DESC LIMIT 1;
SELECT  AVG(links_per_month) FROM (     SELECT COUNT(pl.id) AS links_per_month     FROM postlinks pl     JOIN posts p ON pl.postid = p.id     WHERE strftime('%Y', p.creationdate) = '2010'     AND p.answercount <= 2     GROUP BY strftime('%m', p.creationdate) ) subquery;
SELECT  MAX(posts.id) AS most_valuable_post_id FROM posts JOIN votes ON posts.id = votes.postid WHERE votes.userid = 1465;
SELECT  p.title FROM posts p JOIN postlinks pl ON p.id = pl.postid WHERE pl.creationdate = (SELECT MIN(creationdate) FROM postlinks); 
SELECT  u.displayname FROM users u JOIN badges b ON u.id = b.userid GROUP BY u.id ORDER BY COUNT(b.name) DESC LIMIT 1; 
SELECT MIN(votes.creationdate) AS first_vote_cast FROM votes JOIN users ON votes.userid = users.id WHERE users.displayname = 'chl'; 
SELECT  MIN(posts.creationdate) AS "First Post Date" FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.age = (SELECT MIN(age) FROM users);
SELECT  users.displayname FROM users JOIN badges ON users.id = badges.userid WHERE badges.name = 'Autobiographer' ORDER BY badges.date LIMIT 1;
SELECT  COUNT(DISTINCT users.id) FROM users JOIN posts ON posts.owneruserid = users.id WHERE users.location = 'United Kingdom' AND posts.favoritecount >= 4;
SELECT  AVG(PostId) FROM votes WHERE userid IN (SELECT id FROM users WHERE Age = (SELECT MAX(Age) FROM users));
SELECT  displayname FROM users ORDER BY reputation DESC LIMIT 1; 
SELECT  COUNT(DISTINCT users.id) FROM users JOIN posts ON posts.owneruserid = users.id WHERE users.reputation > 2000 AND posts.viewcount > 1000;
SELECT  displayname FROM users WHERE age BETWEEN 19 AND 65; 
SELECT  COUNT(posts.id) AS "Number of Posts" FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'Jay Stevens' AND strftime('%Y', posts.creationdate) = '2010';
SELECT  posts.id, posts.title FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'Harvey Motulsky' ORDER BY posts.viewcount DESC LIMIT 1;
SELECT posts.id, posts.title FROM posts ORDER BY posts.score DESC LIMIT 1; 
SELECT  AVG(posts.score) AS average_score FROM posts JOIN users ON posts.owneruserid = users.id WHERE users.displayname = 'Stephen Turner'; 
SELECT  DISTINCT users.displayname FROM posts JOIN users ON posts.owneruserid = users.id WHERE posts.viewcount > 20000 AND strftime('%Y', posts.creaiondate) = '2011'; 
SELECT  p.id AS post_id, u.displayname AS owner_displayname FROM posts p JOIN users u ON p.owneruserid = u.id WHERE p.favoritecount = (     SELECT MAX(favoritecount)     FROM posts     WHERE strftime('%Y', creationdate) = '2010' ); 
SELECT  (CAST((SELECT COUNT(p.id) FROM posts p JOIN users u ON p.owneruserid = u.id WHERE u.reputation > 1000 AND strftime('%Y', p.creationdate) = '2011') AS FLOAT) / (SELECT COUNT(id) FROM posts WHERE strftime('%Y', creationdate) = '2011')) * 100 AS percentage;
SELECT  ROUND((CAST((SELECT COUNT(id) FROM users WHERE age BETWEEN 13 AND 18) AS REAL) / CAST((SELECT COUNT(id) FROM users) AS REAL)) * 100, 2) AS percentage; 
SELECT  p.viewcount AS total_views, u.displayname AS last_poster FROM posts p JOIN users u ON p.owneruserid = u.id WHERE p.title = 'Computer Game Datasets' AND p.posttypeid = 1; 
SELECT  COUNT(*) FROM posts WHERE ViewCount > (SELECT AVG(ViewCount) FROM posts); 
SELECT  COUNT(comments.id) AS comment_count FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.score = (SELECT MAX(score) FROM posts)
SELECT  COUNT(*)  FROM posts  WHERE viewcount > 35000  AND commentcount = 0;
SELECT  users.displayname, users.location FROM posts JOIN users ON posts.lasteditoruserid = users.id WHERE posts.id = 183;
SELECT  name FROM badges WHERE userid = (     SELECT id FROM users     WHERE displayname = 'Emmett' ) ORDER BY date DESC LIMIT 1;
SELECT  COUNT(DISTINCT users.id) AS num_adult_users FROM users JOIN votes ON users.id = votes.userid WHERE users.age BETWEEN 19 AND 65 AND users.upvotes > 5000; 
SELECT  julianday(b.creationdate) - julianday(u.creationdate) AS days_to_badge FROM badges b JOIN users u ON b.userid = u.id WHERE u.displayname = 'Zolomon'; 
SELECT  COUNT(posts.id) AS num_posts, COUNT(comments.id) AS num_comments FROM users JOIN posts ON posts.owneruserid = users.id JOIN comments ON comments.userid = users.id WHERE users.creationdate = (SELECT MAX(creationdate) FROM users);
SELECT  comments.text, users.displayname FROM comments JOIN posts ON comments.postid = posts.id JOIN users ON comments.userid = users.id WHERE posts.title = 'Analysing wind data with R' ORDER BY comments.creationdate DESC LIMIT 1;
SELECT  COUNT(DISTINCT badges.userid) FROM badges WHERE badges.name = 'Citizen Patrol';
SELECT  COUNT(*) FROM posts WHERE tags LIKE '%<careers>%'; 
SELECT  u.reputation, p.viewcount FROM users u JOIN posts p ON u.id = p.owneruserid WHERE u.displayname = 'Jarrod Dixon'; 
SELECT  COUNT(DISTINCT comments.id) AS comment_count, COUNT(DISTINCT posts.id) AS answer_count FROM posts LEFT JOIN comments ON posts.id = comments.postid WHERE posts.title = 'Clustering 1D data' AND comments.userid IS NOT NULL; 
SELECT  creationdate FROM users WHERE displayname = 'IrishStat';
SELECT  COUNT(DISTINCT posts.id) FROM posts JOIN votes ON posts.id = votes.postid WHERE votes.bountyamount >= 30;
SELECT  (SELECT COUNT(posts.id) * 1.0 / (SELECT COUNT(posts.id) FROM posts INNER JOIN users ON posts.owneruserid = users.id WHERE users.reputation = (SELECT MAX(reputation) FROM users)) * 100 AS percentage  FROM posts  INNER JOIN users ON posts.owneruserid = users.id  WHERE users.reputation = (SELECT MAX(reputation) FROM users) AND posts.score > 50);
SELECT  COUNT(*) FROM posts WHERE score < 20;
SELECT  COUNT(*)  FROM tags  WHERE id < 15 AND count <= 20;
SELECT  excerptpostid, wikipostid FROM tags WHERE tagname = 'sample'; 
SELECT  users.reputation, users.upvotes FROM users JOIN comments ON comments.userid = users.id WHERE comments.text = 'fine, you win :)'; 
SELECT  comments.text FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.title = 'How can I adapt ANOVA for binary data?'; 
SELECT  MAX(comments.score) AS highest_score_comment FROM comments JOIN posts ON comments.postid = posts.id WHERE posts.viewcount BETWEEN 100 AND 150;
SELECT  creationdate, age FROM comments JOIN users ON comments.userid = users.id WHERE comments.text LIKE '%http://%'
SELECT  COUNT(DISTINCT c.postid) FROM comments c JOIN posts p ON c.postid = p.id WHERE c.score = 0 AND p.viewcount < 5; 
SELECT  COUNT(*) AS ZeroScoreComments FROM posts JOIN comments ON posts.id = comments.postid WHERE posts.commentcount = 1 AND comments.score = 0; 
SELECT  COUNT(DISTINCT users.id) AS total_users_age_40 FROM comments JOIN users ON comments.userid = users.id WHERE comments.score = 0 AND users.age = 40; 
SELECT  posts.id AS post_id, comments.id AS comment_id, comments.text AS comment_text FROM posts JOIN comments ON posts.id = comments.postid WHERE posts.title = 'Group differences on a five point Likert item'; 
SELECT  users.upvotes FROM users JOIN comments ON users.id = comments.userid WHERE comments.text = "R is also lazy evaluated.";
SELECT  comments.text FROM comments JOIN users ON comments.userid = users.id WHERE users.displayname = 'Harvey Motulsky'; 
SELECT  users.displayname FROM comments JOIN users ON comments.userid = users.id WHERE comments.score BETWEEN 1 AND 5 AND users.downvotes = 0;
SELECT  ROUND(     (CAST(         (SELECT COUNT(DISTINCT c.userid)         FROM comments c         WHERE c.score BETWEEN 5 AND 10         AND c.userid NOT IN (             SELECT userid             FROM users             WHERE upvotes > 0         )) AS REAL) /     CAST(         (SELECT COUNT(DISTINCT c.userid)         FROM comments c         WHERE c.score BETWEEN 5 AND 10) AS REAL)) * 100, 2) AS percentage; 
SELECT  superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = '3-D Man';
SELECT  COUNT(DISTINCT superhero.id) FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Super Strength';
SELECT  COUNT(DISTINCT superhero.id) FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Super Strength' AND superhero.height_cm > 200; 
SELECT  superhero.full_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id GROUP BY superhero.id HAVING COUNT(superpower.id) > 15; 
SELECT  COUNT(*)  FROM superhero  WHERE eye_colour_id = (SELECT id FROM colour WHERE colour = 'Blue'); 
SELECT  colour.colour FROM superhero JOIN colour ON superhero.skin_colour_id = colour.id WHERE superhero.superhero_name = 'Apocalypse';
SELECT  COUNT(DISTINCT superhero.id) FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE colour.colour = 'Blue' AND superpower.power_name = 'Agility';
SELECT  superhero.superhero_name FROM superhero JOIN colour AS eye_colour ON superhero.eye_colour_id = eye_colour.id JOIN colour AS hair_colour ON superhero.hair_colour_id = hair_colour.id WHERE eye_colour.colour = 'Blue' AND hair_colour.colour = 'Blond'; 
SELECT  COUNT(*) FROM superhero WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'Marvel Comics');
SELECT  superhero.full_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Marvel Comics' ORDER BY superhero.height_cm DESC LIMIT 1; 
SELECT publisher.publisher_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.superhero_name = 'Sauron'; 
SELECT  COUNT(superhero.id) FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id JOIN colour ON superhero.eye_colour_id = colour.id WHERE publisher.publisher_name = 'Marvel Comics' AND colour.colour = 'Blue';
SELECT  AVG(height_cm) AS average_height FROM superhero WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'Marvel Comics'); 
SELECT       (COUNT(DISTINCT superhero.id) * 1.0 / (SELECT COUNT(*) FROM superhero WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'Marvel Comics'))) * 100 FROM      superhero JOIN      hero_power ON superhero.id = hero_power.hero_id JOIN      superpower ON hero_power.power_id = superpower.id JOIN      publisher ON superhero.publisher_id = publisher.id WHERE      superpower.power_name = 'Super Strength'     AND publisher.publisher_name = 'Marvel Comics'; 
SELECT  COUNT(*) FROM superhero WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'DC Comics');
SELECT  publisher.publisher_name FROM publisher JOIN superhero ON superhero.publisher_id = publisher.id JOIN hero_attribute ON hero_attribute.hero_id = superhero.id JOIN attribute ON attribute.id = hero_attribute.attribute_id WHERE attribute.attribute_name = 'Speed' ORDER BY hero_attribute.attribute_value ASC LIMIT 1; 
SELECT  COUNT(superhero.id) FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE colour.colour = 'Gold' AND publisher.publisher_name = 'Marvel Comics';
SELECT  publisher.publisher_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.superhero_name = 'Blue Beetle II'; 
SELECT  COUNT(*) FROM superhero WHERE hair_colour_id = (SELECT id FROM colour WHERE colour = 'Blond'); 
SELECT  superhero.superhero_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Intelligence' ORDER BY hero_attribute.attribute_value LIMIT 1; 
SELECT  race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.superhero_name = 'Copycat'; 
SELECT  COUNT(DISTINCT superhero.id) FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Durability' AND hero_attribute.attribute_value < 50; 
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Death Touch'; 
SELECT  COUNT(DISTINCT superhero.id) FROM superhero JOIN gender ON superhero.gender_id = gender.id JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE gender.gender = 'Female' AND attribute.attribute_name = 'Strength' AND hero_attribute.attribute_value = 100; 
SELECT superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id GROUP BY superhero.id ORDER BY COUNT(hero_power.power_id) DESC LIMIT 1; 
SELECT  COUNT(superhero.id) FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Vampire'; 
SELECT ROUND((COUNT(CASE WHEN alignment.alignment = 'Bad' THEN superhero.id END) * 1.0 / COUNT(superhero.id)) * 100, 2) AS Percentage_Bad_Superheroes, COUNT(CASE WHEN alignment.alignment = 'Bad' AND publisher.publisher_name = 'Marvel Comics' THEN superhero.id END) AS Marvel_Bad_Superheroes FROM superhero LEFT JOIN alignment ON superhero.alignment_id = alignment.id LEFT JOIN publisher ON superhero.publisher_id = publisher.id; 
SELECT  ABS(   (SELECT COUNT(*) FROM superhero WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'Marvel Comics')) -   (SELECT COUNT(*) FROM superhero WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'DC Comics')) ) AS difference 
SELECT  id FROM publisher WHERE publisher_name = 'Star Trek'; 
SELECT  AVG(attribute_value) AS average_attribute_value FROM hero_attribute; 
SELECT  COUNT(*) FROM superhero WHERE full_name IS NULL;
SELECT  colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.id = 75;
SELECT  superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Deathlok'; 
SELECT  AVG(weight_kg) FROM superhero WHERE gender_id = 2; 
SELECT  DISTINCT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id JOIN gender ON superhero.gender_id = gender.id WHERE gender.gender = 'Male' LIMIT 5; 
SELECT  superhero_name FROM superhero WHERE race_id = (SELECT id FROM race WHERE race = 'Alien'); 
SELECT superhero.superhero_name FROM superhero LEFT JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.height_cm BETWEEN 170 AND 190 AND colour.id IS NULL; 
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.id = 56; 
SELECT  superhero.full_name FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Demi-God'; 
SELECT  COUNT(*)  FROM superhero  WHERE alignment_id = (SELECT id FROM alignment WHERE alignment = 'Bad'); 
SELECT  race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.weight_kg = 169; 
SELECT  colour.colour FROM superhero JOIN colour ON superhero.hair_colour_id = colour.id JOIN race ON superhero.race_id = race.id WHERE superhero.height_cm = 185 AND race.race = 'Human';
SELECT  MAX(weight_kg) FROM superhero;
SELECT  (COUNT(superhero.id) * 100.0 / (SELECT COUNT(superhero.id) FROM superhero WHERE height_cm BETWEEN 150 AND 180)) AS percentage_published_by_marvel FROM superhero INNER JOIN publisher ON superhero.publisher_id = publisher.id WHERE height_cm BETWEEN 150 AND 180 AND publisher.id = 25; 
SELECT  superhero.full_name FROM superhero JOIN gender ON superhero.gender_id = gender.id WHERE gender.gender = 'Male' AND superhero.weight_kg > 0.79 * (SELECT AVG(weight_kg) FROM superhero); 
SELECT  power_name FROM superpower JOIN hero_power ON superpower.id = hero_power.power_id GROUP BY power_name ORDER BY COUNT(*) DESC LIMIT 1; 
SELECT  attribute.attribute_value FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE superhero.superhero_name = 'Abomination'; 
SELECT  superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.id = 1; 
SELECT  COUNT(DISTINCT superhero.id) AS stealth_heroes FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Stealth'; 
SELECT  superhero.full_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Strength' ORDER BY hero_attribute.attribute_value DESC LIMIT 1; 
SELECT  AVG(CASE WHEN superhero.skin_colour_id IS NULL THEN 1 ELSE 0 END) AS average_no_skin_colour FROM superhero LEFT JOIN colour ON superhero.skin_colour_id = colour.id WHERE colour.id = 1; 
SELECT COUNT(superhero.id) FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Dark Horse Comics'; 
SELECT  superhero.superhero_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE publisher.publisher_name = 'Dark Horse Comics' AND attribute.attribute_name = 'Durability' AND hero_attribute.attribute_value = (     SELECT MAX(attribute_value)     FROM hero_attribute     JOIN attribute ON hero_attribute.attribute_id = attribute.id     WHERE attribute.attribute_name = 'Durability' ) 
SELECT  colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.full_name = 'Abraham Sapien';
SELECT  superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Flight'; 
SELECT colour.colour AS eye_colour, colour.colour AS hair_colour, colour.colour AS skin_colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.gender_id = (     SELECT id FROM gender WHERE gender = 'Female' ) AND publisher.publisher_name = 'Dark Horse Comics'; 
SELECT  superhero.superhero_name, publisher.publisher_name FROM superhero JOIN colour AS eye_color ON superhero.eye_colour_id = eye_color.id JOIN colour AS hair_color ON superhero.hair_colour_id = hair_color.id JOIN colour AS skin_color ON superhero.skin_colour_id = skin_color.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE hair_color.colour = skin_color.colour AND hair_color.colour = eye_color.colour;
SELECT  race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.superhero_name = 'A-Bomb'; 
SELECT  ROUND((CAST(SUM(CASE WHEN superhero.gender_id = gender.id AND gender.gender = 'Female' AND superhero.skin_colour_id = colour.id AND colour.colour = 'Blue' THEN 1 ELSE 0 END) AS FLOAT) / CAST(COUNT(CASE WHEN superhero.gender_id = gender.id AND gender.gender = 'Female' THEN 1 END) AS FLOAT)) * 100, 2) AS percentage_of_blue_female_superheroes FROM superhero INNER JOIN gender ON superhero.gender_id = gender.id INNER JOIN colour ON superhero.skin_colour_id = colour.id; 
SELECT  superhero.superhero_name, race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.full_name = 'Charles Chandler'; 
SELECT  gender.gender FROM superhero JOIN gender ON superhero.gender_id = gender.id WHERE superhero.superhero_name = 'Agent 13';
SELECT  superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Adaptation'; 
SELECT  COUNT(*) AS num_powers FROM hero_power JOIN superhero ON hero_power.hero_id = superhero.id WHERE superhero.superhero_name = 'Amazo'; 
SELECT  superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.full_name = 'Hunter Zolomon'; 
SELECT  superhero.height_cm FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE colour.colour = 'Amber'; 
SELECT  superhero.superhero_name FROM superhero JOIN colour AS eye_color ON superhero.eye_colour_id = eye_color.id JOIN colour AS hair_color ON superhero.hair_colour_id = hair_color.id WHERE eye_color.colour = 'Black' AND hair_color.colour = 'Black';
SELECT  colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.skin_colour_id = (SELECT id FROM colour WHERE colour = 'Gold');
SELECT  superhero.full_name FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Vampire'; 
SELECT  superhero.superhero_name FROM superhero JOIN alignment ON superhero.alignment_id = alignment.id WHERE alignment.alignment = 'Neutral'; 
SELECT  COUNT(DISTINCT superhero.id) AS num_heroes_highest_strength FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Strength' AND hero_attribute.attribute_value = (     SELECT MAX(attribute_value)     FROM hero_attribute     JOIN attribute ON hero_attribute.attribute_id = attribute.id     WHERE attribute.attribute_name = 'Strength' ); 
SELECT  race.race, alignment.alignment FROM superhero JOIN race ON superhero.race_id = race.id JOIN alignment ON superhero.alignment_id = alignment.id WHERE superhero.superhero_name = 'Cameron Hicks'; 
SELECT  ((COUNT(*) * 100.0) / (SELECT COUNT(*) FROM superhero WHERE gender_id = (SELECT id FROM gender WHERE gender = 'Female'))) FROM superhero WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'Marvel Comics') AND gender_id = (SELECT id FROM gender WHERE gender = 'Female');
SELECT  AVG(weight_kg) AS average_weight FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Alien'; 
SELECT  (     (SELECT weight_kg FROM superhero WHERE full_name = 'Emil Blonsky') -     (SELECT weight_kg FROM superhero WHERE full_name = 'Charles Chandler') ) AS weight_difference; 
SELECT  superhero.superhero_name, AVG(superhero.height_cm) AS average_height FROM superhero GROUP BY superhero.superhero_name; 
SELECT  superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Abomination'; 
SELECT  COUNT(superhero.id)  FROM superhero  WHERE superhero.race_id = 21  AND superhero.gender_id = 1; 
SELECT  superhero.superhero_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Speed' ORDER BY hero_attribute.attribute_value DESC LIMIT 1; 
SELECT  COUNT(*) FROM superhero WHERE alignment_id = 3; 
SELECT  attribute.attribute_name, hero_attribute.attribute_value FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE superhero.superhero_name = '3-D Man'; 
SELECT  superhero.superhero_name FROM superhero JOIN colour AS eye_color ON superhero.eye_colour_id = eye_color.id JOIN colour AS hair_color ON superhero.hair_colour_id = hair_color.id WHERE eye_color.colour = 'Blue' AND hair_color.colour = 'Brown'; 
SELECT  superhero.superhero_name, publisher.publisher_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.superhero_name IN ('Hawkman', 'Karate Kid', 'Speedy'); 
SELECT  COUNT(*)  FROM superhero  WHERE publisher_id = 1; 
SELECT  (COUNT(superhero_name) * 100.0 / (SELECT COUNT(*) FROM superhero)) AS percentage_of_blue_eyes FROM superhero WHERE eye_colour_id = 7; 
SELECT CAST(SUM(CASE WHEN gender_id = 1 THEN 1 ELSE 0 END) AS REAL) / CAST(SUM(CASE WHEN gender_id = 2 THEN 1 ELSE 0 END) AS REAL) 
SELECT  superhero_name FROM superhero ORDER BY height_cm DESC LIMIT 1; 
SELECT  superpower.id FROM superpower WHERE power_name = 'Cryokinesis';
SELECT  superhero_name FROM superhero WHERE id = 294; 
SELECT  superhero.full_name FROM superhero WHERE superhero.weight_kg = 0 OR superhero.weight_kg IS NULL; 
SELECT  colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.full_name = 'Karen Beecher-Duncan';
SELECT  superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.full_name = 'Helen Parr'; 
SELECT  race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.weight_kg = 108 AND superhero.height_cm = 188;
SELECT  publisher.publisher_name FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id WHERE superhero.id = 38; 
SELECT  race.race FROM superhero JOIN race ON superhero.race_id = race.id JOIN hero_attribute ON superhero.id = hero_attribute.hero_id WHERE hero_attribute.attribute_value = (     SELECT MAX(attribute_value)     FROM hero_attribute ); 
SELECT  alignment.alignment, superpower.power_name FROM superhero JOIN alignment ON superhero.alignment_id = alignment.id JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Atom IV'; 
SELECT  superhero.full_name FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE colour.colour = 'Blue'; 
SELECT  AVG(attribute_value) AS average_attribute_value FROM hero_attribute JOIN superhero ON hero_attribute.hero_id = superhero.id WHERE superhero.alignment_id = 3; 
SELECT  colour.colour FROM superhero JOIN colour ON superhero.skin_colour_id = colour.id JOIN hero_attribute ON hero_attribute.hero_id = superhero.id WHERE hero_attribute.attribute_value = 100; 
SELECT  COUNT(*)  FROM superhero  WHERE alignment_id = 1 AND gender_id = 2; 
SELECT  superhero.superhero_name FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id WHERE hero_attribute.attribute_value BETWEEN 75 AND 80; 
SELECT  race.race FROM superhero JOIN colour AS hair_color ON superhero.hair_colour_id = hair_color.id JOIN gender ON superhero.gender_id = gender.id JOIN race ON superhero.race_id = race.id WHERE hair_color.colour = 'Blue' AND gender.gender = 'Male'; 
SELECT MULTIPLY(     DIVIDE(         SUM(CASE WHEN alignment_id = 2 AND gender_id = 2 THEN 1 ELSE 0 END),         COUNT(CASE WHEN alignment_id = 2 THEN 1 ELSE NULL END)     ),     100.0 ) FROM superhero; 
SELECT COUNT(CASE WHEN superhero.weight_kg = 0 OR superhero.weight_kg IS NULL THEN 1 END) - COUNT(CASE WHEN superhero.eye_colour_id = 7 THEN 1 END) - COUNT(CASE WHEN superhero.eye_colour_id = 1 THEN 1 END) AS difference FROM superhero LEFT JOIN colour ON superhero.eye_colour_id = colour.id; 
SELECT  hero_attribute.attribute_value FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE superhero.superhero_name = 'Hulk' AND attribute.attribute_name = 'Strength'; 
SELECT superpower.power_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superhero.superhero_name = 'Ajax'; 
SELECT  COUNT(superhero.id) FROM superhero JOIN colour ON superhero.skin_colour_id = colour.id JOIN alignment ON superhero.alignment_id = alignment.id WHERE colour.colour = 'Green' AND alignment.alignment = 'Bad'; 
SELECT  COUNT(superhero.id) FROM superhero JOIN gender ON superhero.gender_id = gender.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE gender.gender = 'Female' AND publisher.publisher_name = 'Marvel Comics'; 
SELECT  superhero.superhero_name FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Wind Control' ORDER BY superhero.superhero_name ASC; 
SELECT  gender.gender FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id JOIN gender ON superhero.gender_id = gender.id WHERE superpower.power_name = 'Phoenix Force'; 
SELECT  superhero_name FROM superhero WHERE publisher_id = (     SELECT id     FROM publisher     WHERE publisher_name = 'DC Comics' ) ORDER BY weight_kg DESC LIMIT 1; 
SELECT  AVG(superhero.height_cm) AS average_height FROM superhero JOIN publisher ON superhero.publisher_id = publisher.id JOIN race ON superhero.race_id = race.id WHERE publisher.publisher_name = 'Dark Horse Comics' AND race.race <> 'Human'; 
SELECT  COUNT(*) AS fastest_superheroes_count FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id JOIN attribute ON hero_attribute.attribute_id = attribute.id WHERE attribute.attribute_name = 'Speed' AND hero_attribute.attribute_value = 100; 
SELECT ABS(     (SELECT COUNT(*) FROM superhero WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'DC Comics'))      -      (SELECT COUNT(*) FROM superhero WHERE publisher_id = (SELECT id FROM publisher WHERE publisher_name = 'Marvel Comics')) ) AS difference 
SELECT  attribute.attribute_name FROM hero_attribute JOIN attribute ON hero_attribute.attribute_id = attribute.id JOIN superhero ON hero_attribute.hero_id = superhero.id WHERE superhero.superhero_name = 'Black Panther' ORDER BY hero_attribute.attribute_value ASC LIMIT 1; 
SELECT  colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.superhero_name = 'Abomination';
SELECT  superhero.superhero_name FROM superhero ORDER BY superhero.height_cm DESC LIMIT 1;
SELECT  superhero_name FROM superhero WHERE full_name = 'Charles Chandler'; 
SELECT ROUND(     (         (             SELECT COUNT(*)             FROM superhero             WHERE gender_id = (                 SELECT id                 FROM gender                 WHERE gender = 'Female'             )             AND publisher_id = (                 SELECT id                 FROM publisher                 WHERE publisher_name = 'George Lucas'             )         )         /         (             SELECT COUNT(*)             FROM superhero             WHERE publisher_id = (                 SELECT id                 FROM publisher                 WHERE publisher_name = 'George Lucas'             )         )     ) * 100.0 , 2) AS percentage_female_george_lucas_superheroes; 
SELECT  (COUNT(CASE WHEN alignment.alignment = 'Good' THEN 1 END) * 1.0 / COUNT(*)) * 100.0 AS percentage FROM superhero JOIN alignment ON superhero.alignment_id = alignment.id JOIN publisher ON superhero.publisher_id = publisher.id WHERE publisher.publisher_name = 'Marvel Comics'; 
SELECT  COUNT(*)  FROM superhero  WHERE full_name LIKE 'John%'; 
SELECT  hero_id FROM hero_attribute GROUP BY hero_id HAVING MIN(attribute_value) = (SELECT MIN(attribute_value) FROM hero_attribute); 
SELECT  superhero.full_name FROM superhero JOIN race ON superhero.race_id = race.id WHERE race.race = 'Alien' AND superhero.superhero_name = 'Alien'; 
SELECT  superhero.full_name FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.weight_kg < 100 AND colour.colour = 'Brown'; 
SELECT  hero_attribute.attribute_value FROM superhero JOIN hero_attribute ON superhero.id = hero_attribute.hero_id WHERE superhero.superhero_name = 'Aquababy'; 
SELECT  superhero.weight_kg, race.race FROM superhero JOIN race ON superhero.race_id = race.id WHERE superhero.id = 40; 
SELECT  AVG(height_cm) AS average_height FROM superhero JOIN alignment ON superhero.alignment_id = alignment.id WHERE alignment.alignment = 'Neutral'; 
SELECT  superhero.id FROM superhero JOIN hero_power ON superhero.id = hero_power.hero_id JOIN superpower ON hero_power.power_id = superpower.id WHERE superpower.power_name = 'Intelligence'; 
SELECT  colour.colour FROM superhero JOIN colour ON superhero.eye_colour_id = colour.id WHERE superhero.superhero_name = 'Blackwulf';
SELECT power_name FROM superpower WHERE id IN (     SELECT power_id     FROM hero_power     WHERE hero_id IN (         SELECT id         FROM superhero         WHERE height_cm > (SELECT AVG(height_cm) * 0.8 FROM superhero)     ) ) 
SELECT  driverref FROM qualifying WHERE raceid = 18 ORDER BY q1 DESC LIMIT 5;
SELECT  drivers.surname FROM     drivers JOIN     laptimes ON drivers.driverid = laptimes.driverid JOIN     races ON races.raceid = laptimes.raceid JOIN     qualifying ON qualifying.raceid = races.raceid AND qualifying.driverid = laptimes.driverid WHERE     races.raceid = 19     AND qualifying.q2 = (SELECT MIN(q2) FROM qualifying WHERE raceid = 19);
SELECT  DISTINCT races.year FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.location = 'Shanghai'; 
SELECT  races.url FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Circuit de Barcelona-Catalunya'; 
SELECT  races.name FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.country = 'Germany';
SELECT  circuits.name, constructorresults.position FROM circuits JOIN races ON races.circuitid = circuits.circuitid JOIN constructorresults ON constructorresults.raceid = races.raceid JOIN constructors ON constructors.constructorid = constructorresults.constructorid WHERE constructors.name = 'Renault'; 
SELECT  COUNT(*) FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE races.year = 2010 AND circuits.country NOT IN ('Asia', 'Europe'); 
SELECT  races.name FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.country = 'Spain'; 
SELECT  circuitid, lat, lng FROM circuits WHERE circuitid IN (SELECT circuitid FROM races WHERE name = 'Australian Grand Prix');
SELECT  url FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Sepang International Circuit';
SELECT  races.time FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Sepang International Circuit'; 
SELECT  lat, lng FROM circuits JOIN races ON races.circuitid = circuits.circuitid WHERE races.name = 'Abu Dhabi Grand Prix';
SELECT  circuits.country FROM circuits JOIN races ON races.circuitid = circuits.circuitid JOIN constructorresults ON constructorresults.raceid = races.raceid JOIN constructors ON constructors.constructorid = constructorresults.constructorid WHERE races.raceid = 24 AND constructorresults.points = 1; 
SELECT  qualifying.q1 FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid JOIN races ON qualifying.raceid = races.raceid WHERE drivers.forename = 'Bruno' AND drivers.surname = 'Senna' AND races.raceid = 354; 
SELECT  drivers.nationality FROM drivers JOIN qualifying ON drivers.driverid = qualifying.driverid WHERE qualifying.q2 = '0:01:40' AND qualifying.raceid = 355;
SELECT  number FROM qualifying WHERE raceid = 903 AND q3 = '0:01:54';
SELECT  COUNT(*) AS "Number of drivers not finished the Bahrain Grand Prix in 2007"  FROM results  WHERE raceid = (     SELECT raceid      FROM races      WHERE name = 'Bahrain Grand Prix' AND year = 2007 )  AND time = ''
SELECT  seasons.url FROM seasons JOIN races ON seasons.year = races.year WHERE races.raceid = 901; 
SELECT  COUNT(DISTINCT results.driverid) FROM results JOIN races ON results.raceid = races.raceid WHERE races.date = '2015-11-29' AND results.time IS NOT NULL;
SELECT  drivers.forename, drivers.surname FROM results JOIN drivers ON results.driverid = drivers.driverid WHERE results.raceid = 592 AND results.time IS NOT NULL ORDER BY drivers.dob ASC LIMIT 1; 
SELECT  drivers.forename, drivers.surname, drivers.url FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid WHERE laptimes.time = '0:01:27' AND laptimes.raceid = 161;
SELECT  drivers.nationality FROM drivers JOIN results ON drivers.driverid = results.driverid WHERE results.raceid = 933 AND results.fastestlapspeed = (     SELECT MAX(fastestlapspeed)     FROM results     WHERE raceid = 933 );
SELECT circuits.lat, circuits.lng FROM circuits JOIN races ON circuits.circuitid = races.circuitid WHERE races.name = 'Malaysian Grand Prix'; 
SELECT  constructors.url FROM constructorresults JOIN constructors ON constructorresults.constructorid = constructors.constructorid WHERE constructorresults.points = (     SELECT MAX(points)     FROM constructorresults     WHERE raceid = 9 ) AND constructorresults.raceid = 9; 
SELECT  qualifying.q1 FROM drivers JOIN qualifying ON drivers.driverid = qualifying.driverid JOIN races ON qualifying.raceid = races.raceid WHERE drivers.forename = 'Lucas' AND drivers.surname = 'di Grassi' AND races.raceid = 345; 
SELECT  country FROM drivers JOIN qualifying ON drivers.driverid = qualifying.driverid WHERE qualifying.q2 = '0:01:15' AND qualifying.raceid = 347;
SELECT  drivers.code FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid WHERE qualifying.q3 = '0:01:33' AND qualifying.raceid = 45;
SELECT  time FROM results WHERE raceid = 743 AND driverid = (     SELECT driverid FROM drivers WHERE forename = 'Bruce' AND surname = 'McLaren' );
SELECT  drivers.forename, drivers.surname FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE races.name = 'San Marino Grand Prix' AND races.year = 2006 AND results.position = 2;
SELECT  `url` FROM `seasons` WHERE `year` = (SELECT `year` FROM `races` WHERE `raceid` = 901);
SELECT  COUNT(results.resultid) AS num_finished_drivers FROM results JOIN races ON results.raceid = races.raceid WHERE races.date = '2015-11-29' AND results.statusid = (     SELECT statusid FROM status WHERE status = 'Finished' ); 
SELECT  drivers.forename, drivers.surname FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE results.raceid = 872 AND results.time IS NOT NULL ORDER BY drivers.dob DESC LIMIT 1;
SELECT  drivers.forename || ' ' || drivers.surname AS "Driver Name" FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid WHERE laptimes.raceid = 348 AND laptimes.time = (     SELECT MIN(time) FROM laptimes WHERE raceid = 348 )
SELECT  drivers.nationality FROM drivers JOIN results ON drivers.driverid = results.driverid WHERE results.fastestlapspeed = (     SELECT MAX(results.fastestlapspeed)     FROM results ) LIMIT 1; 
SELECT  ROUND(((SELECT fastestlapspeed FROM results WHERE raceid = 853 AND driverid = (SELECT driverid FROM drivers WHERE forename = 'Paul' AND surname = 'di Resta')) - (SELECT fastestlapspeed FROM results WHERE raceid = 854 AND fastestlapspeed > 0) / (SELECT fastestlapspeed FROM results WHERE raceid = 853 AND driverid = (SELECT driverid FROM drivers WHERE forename = 'Paul' AND surname = 'di Resta'))) * 100, 2) AS percentage
SELECT  (CAST(COUNT(results.driverid) AS FLOAT) / COUNT(DISTINCT driverid)) * 100 AS completion_rate FROM results JOIN races ON results.raceid = races.raceid WHERE races.date = '1983-07-16' AND results.time IS NOT NULL; 
SELECT  MIN(year) AS First_Singapore_Grand_Prix_Year FROM races WHERE name = 'Singapore Grand Prix'; 
SELECT  COUNT(*), name FROM races WHERE year = 2005 GROUP BY name ORDER BY COUNT(*) DESC; 
SELECT  r1.name FROM races AS r1 WHERE r1.date = (         SELECT MIN(date)         FROM races     ); 
SELECT  name, date FROM races WHERE year = 1999 AND round = (SELECT MAX(round) FROM races WHERE year = 1999);
SELECT  year, COUNT(*) AS num_races FROM races GROUP BY year ORDER BY num_races DESC LIMIT 1; 
SELECT  name  FROM races  WHERE year = 2017  AND name NOT IN (SELECT name FROM races WHERE year = 2000); 
SELECT  circuits.country, circuits.name, circuits.location FROM circuits JOIN races ON races.circuitid = circuits.circuitid WHERE races.name = 'European Grand Prix' ORDER BY races.year LIMIT 1; 
SELECT  MAX(seasons.year) AS last_season FROM circuits JOIN races ON circuits.circuitid = races.circuitid JOIN seasons ON races.year = seasons.year WHERE circuits.name = 'Brands Hatch' AND races.name = 'British Grand Prix'; 
SELECT  COUNT(DISTINCT seasons.year) FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE circuits.name = 'Silverstone Circuit' AND races.name LIKE '%British Grand Prix%'; 
SELECT  drivers.forename, drivers.surname FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE races.name = 'Singapore Grand Prix' AND races.year = 2010 ORDER BY driverstandings.position; 
SELECT  drivers.forename || ' ' || drivers.surname AS full_name FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid WHERE driverstandings.points = (SELECT MAX(points) FROM driverstandings)
SELECT  drivers.forename || ' ' || drivers.surname AS driver_name, driverstandings.points FROM driverstandings JOIN drivers ON driverstandings.driverid = drivers.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE races.name = 'Chinese Grand Prix' AND races.year = 2017 ORDER BY driverstandings.points DESC LIMIT 3; 
SELECT  MIN(laptimes.time) AS best_lap_time,        drivers.forename || ' ' || drivers.surname AS driver_name,        races.name AS race_name FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid JOIN races ON laptimes.raceid = races.raceid GROUP BY laptimes.time ORDER BY laptimes.time LIMIT 1;
SELECT  AVG(laptimes.time) AS average_lap_time FROM laptimes JOIN races ON laptimes.raceid = races.raceid JOIN drivers ON laptimes.driverid = drivers.driverid WHERE drivers.forename = 'Sebastian'  AND drivers.surname = 'Vettel' AND races.name = 'Chinese Grand Prix' AND races.year = 2009;
SELECT  (SELECT (COUNT(r.raceid) * 100.0) / (SELECT COUNT(r2.raceid) FROM races AS r2 JOIN circuits AS c ON r2.circuitid = c.circuitid WHERE c.name = 'Circuit of the Americas' AND r2.year >= 2010) FROM races AS r JOIN drivers AS d ON r.driverid = d.driverid JOIN circuits AS c ON r.circuitid = c.circuitid WHERE d.surname = 'Hamilton' AND r.year >= 2010 AND r.position > 1);
SELECT  drivers.forename || ' ' || drivers.surname AS driver_name,        drivers.nationality AS nationality,        AVG(driverstandings.points) AS average_points FROM driverstandings JOIN drivers ON driverstandings.driverid = drivers.driverid GROUP BY drivers.forename, drivers.surname, drivers.nationality ORDER BY COUNT(driverstandings.wins) DESC LIMIT 1; 
SELECT  MAX(2022 - year(dob) + 1) AS age, forename, surname FROM drivers WHERE nationality = 'Japanese'
SELECT  circuits.name FROM circuits JOIN races ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE seasons.year BETWEEN 1990 AND 2000 GROUP BY circuits.name HAVING COUNT(DISTINCT races.raceid) = 4; 
SELECT  circuits.name, circuits.location, races.name FROM circuits JOIN races ON circuits.circuitid = races.circuitid JOIN seasons ON races.year = seasons.year WHERE circuits.country = 'USA' AND seasons.year = 2006; 
SELECT  races.name AS race_name, circuits.name AS circuit_name, circuits.location FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE strftime('%m', races.date) = '09' AND races.year = '2005'; 
SELECT  races.name FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Alex' AND drivers.surname = 'Yoong' AND results.position < 10;
SELECT  COUNT(results.position)  FROM results JOIN races ON results.raceid = races.raceid JOIN circuits ON races.circuitid = circuits.circuitid JOIN drivers ON results.driverid = drivers.driverid WHERE circuits.name = 'Sepang International Circuit' AND drivers.forename = 'Michael' AND drivers.surname = 'Schumacher' AND results.position = 1
SELECT  races.name, races.year FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Michael' AND drivers.surname = 'Schumacher' ORDER BY results.milliseconds ASC LIMIT 1;
SELECT  AVG(results.points) AS average_points FROM results JOIN drivers ON results.driverid = drivers.driverid JOIN races ON results.raceid = races.raceid WHERE drivers.forename = 'Eddie' AND drivers.surname = 'Irvine' AND races.year = 2000;
SELECT  MIN(races.year) AS first_race_year,        results.points AS points_recorded FROM drivers JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton';
SELECT  races.name, circuits.country FROM races JOIN circuits ON races.circuitid = circuits.circuitid JOIN seasons ON races.year = seasons.year WHERE seasons.year = 2017 ORDER BY races.date; 
SELECT  races.name, races.year, circuits.location FROM races JOIN circuits ON races.circuitid = circuits.circuitid ORDER BY races.laps DESC LIMIT 1; 
SELECT  (CAST(COUNT(*) AS FLOAT) / (SELECT COUNT(*) FROM races WHERE name = 'European Grand Prix')) * 100 FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE races.name = 'European Grand Prix' AND circuits.country = 'Germany'; 
SELECT  lat, lng FROM circuits WHERE circuitref = 'silverstone';
SELECT  MAX(lat) FROM circuits WHERE circuitref IN ('silverstone', 'hockenheimring', 'hungaroring');
SELECT  circuitref FROM circuits WHERE name = 'Marina Bay Street Circuit';
SELECT  country FROM circuits WHERE alt = (SELECT MAX(alt) FROM circuits); 
SELECT  COUNT(*)  FROM drivers  WHERE code IS NULL;
SELECT  nationality FROM drivers WHERE dob = (SELECT MIN(dob) FROM drivers); 
SELECT  surname FROM drivers WHERE nationality = 'Italian';
SELECT  drivers.url FROM drivers WHERE drivers.forename = 'Anthony' AND drivers.surname = 'Davidson';
SELECT  driverref FROM drivers WHERE forename = 'Lewis' AND surname = 'Hamilton';
SELECT  circuits.name FROM circuits JOIN races ON circuits.circuitid = races.circuitid WHERE races.year = 2009 AND races.name = 'Spanish Grand Prix'; 
SELECT  DISTINCT races.year FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.circuitref = 'silverstone'; 
SELECT  races.name, races.date, races.url FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.circuitref = 'silverstone';
SELECT  races.time FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE races.year BETWEEN 2010 AND 2019 AND circuits.name = 'Abu Dhabi Circuit'; 
SELECT  COUNT(*)  FROM races  JOIN circuits ON races.circuitid = circuits.circuitid  WHERE circuits.country = 'Italy'; 
SELECT  races.date FROM races JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.circuitref = 'catalunya' 
SELECT  url FROM circuits INNER JOIN races ON circuits.circuitid = races.circuitid WHERE races.name = 'Spanish Grand Prix' AND races.year = 2009;
SELECT  MIN(results.fastestlaptime) AS fastest_lap_time FROM results JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton';
SELECT  drivers.forename, drivers.surname FROM drivers JOIN laptimes ON drivers.driverid = laptimes.driverid JOIN races ON laptimes.raceid = races.raceid JOIN circuits ON races.circuitid = circuits.circuitid WHERE laptimes.rank = 1 ORDER BY laptimes.fastestlapspeed DESC LIMIT 1; 
SELECT  drivers.driverref FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND driverstandings.position = 1;
SELECT  races.name FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'; 
SELECT  races.name AS race_name FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' ORDER BY results.positionorder ASC LIMIT 1;
SELECT  MAX(fastestlapspeed)  FROM results  JOIN races ON results.raceid = races.raceid  WHERE races.name = 'Spanish Grand Prix' AND races.year = 2009;
SELECT  DISTINCT races.year FROM races JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'; 
SELECT  results.positionorder FROM results JOIN drivers ON results.driverid = drivers.driverid JOIN races ON results.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND races.name = 'Australian Grand Prix' AND races.year = 2008; 
SELECT  drivers.forename, drivers.surname FROM drivers JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid WHERE races.year = 2008 AND races.name = 'Australian Grand Prix' AND results.grid = 4;
SELECT  COUNT(DISTINCT results.driverid) FROM results JOIN races ON results.raceid = races.raceid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND results.time IS NOT NULL;
SELECT  laptimes.time FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid JOIN races ON laptimes.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND races.name = 'Australian Grand Prix' AND races.year = 2008 ORDER BY laptimes.milliseconds ASC LIMIT 1; 
SELECT  time FROM results JOIN races ON results.raceid = races.raceid WHERE races.year = 2008 AND races.name = 'Australian Grand Prix' AND results.position = 2;
SELECT  drivers.forename, drivers.surname, drivers.url FROM driverstandings JOIN drivers ON driverstandings.driverid = drivers.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE races.year = 2008 AND races.name = 'Australian Grand Prix' AND driverstandings.position = 1;
SELECT  COUNT(DISTINCT drivers.driverid)  FROM drivers  JOIN results ON drivers.driverid = results.driverid  JOIN races ON results.raceid = races.raceid  WHERE races.year = 2008  AND races.name = 'Australian Grand Prix'  AND drivers.nationality = 'American';
SELECT  COUNT(DISTINCT drivers.driverid) AS participating_drivers FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE races.name = 'Australian Grand Prix' AND races.year = 2008 AND results.time IS NOT NULL;
SELECT  SUM(results.points) AS total_points FROM results JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'; 
SELECT  AVG(strftime('%s', fastestlaptime) - strftime('%s', '00:00:00')) FROM results JOIN drivers ON results.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'
SELECT  COUNT(results.raceid) * 1.0 / COUNT(races.raceid) FROM results JOIN races ON results.raceid = races.raceid WHERE races.year = 2008 AND races.name = 'Australian Grand Prix' AND results.time IS NOT NULL;
SELECT  ((SELECT ((MAX(milliseconds) - MIN(milliseconds)) * 1.0) /          (SELECT (milliseconds + MAX(milliseconds))              FROM results              WHERE raceid = (SELECT raceid                                  FROM races                                  WHERE name = 'Australian Grand Prix'                                  AND year = 2008)              AND position = 1)      FROM results      WHERE raceid = (SELECT raceid                          FROM races                          WHERE name = 'Australian Grand Prix'                          AND year = 2008)      AND position = (SELECT MAX(position)                          FROM results                          WHERE raceid = (SELECT raceid                                              FROM races                                              WHERE name = 'Australian Grand Prix'                                              AND year = 2008)));
SELECT  COUNT(circuits.circuitid) AS Melbourne_circuits_count FROM circuits WHERE circuits.location = 'Melbourne' AND circuits.country = 'Australia';
SELECT  lat, lng FROM circuits WHERE country = 'USA'; 
SELECT  COUNT(*) FROM drivers WHERE nationality = 'British' AND strftime('%Y', dob) > '1980';
SELECT  AVG(constructorstandings.points) AS average_points FROM constructorstandings JOIN constructors ON constructorstandings.constructorid = constructors.constructorid WHERE constructors.nationality = 'British'; 
SELECT  constructors.name FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid GROUP BY constructors.name ORDER BY SUM(constructorstandings.points) DESC LIMIT 1; 
SELECT  constructors.name FROM constructors LEFT JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid WHERE constructorstandings.points IS NULL OR constructorstandings.points = 0 AND constructorstandings.raceid = 291; 
SELECT  COUNT(DISTINCT constructors.constructorid) FROM constructorstandings JOIN constructors ON constructors.constructorid = constructorstandings.constructorid WHERE constructors.nationality = 'Japanese' AND constructorstandings.points = 0 GROUP BY constructors.constructorid HAVING COUNT(DISTINCT constructorstandings.raceid) = 2;
SELECT  constructors.name FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid WHERE constructorstandings.position = 1 
SELECT  COUNT(DISTINCT constructors.constructorid)  FROM constructors  JOIN constructorresults ON constructors.constructorid = constructorresults.constructorid  JOIN races ON constructorresults.raceid = races.raceid  JOIN results ON results.constructorid = constructors.constructorid  JOIN status ON results.statusid = status.statusid  WHERE nationality = 'French' AND laps > 50;
SELECT  (COUNT(results.driverid) * 100.0) / (         SELECT COUNT(driverid) FROM results         WHERE raceid IN (             SELECT raceid FROM races WHERE year BETWEEN 2007 AND 2009         )     ) FROM results WHERE raceid IN (         SELECT raceid FROM races WHERE year BETWEEN 2007 AND 2009     ) AND time IS NOT NULL AND driverid IN (         SELECT driverid FROM drivers WHERE nationality = 'Japanese'     ); 
SELECT AVG(     strftime('%s', results.time) - strftime('%s', '00:00:00') ) AS average_champion_time_seconds FROM results JOIN races ON results.raceid = races.raceid JOIN seasons ON races.year = seasons.year WHERE driverid IN (     SELECT driverid     FROM driverstandings     WHERE position = 1 ) AND results.time IS NOT NULL GROUP BY races.year; 
SELECT  drivers.forename, drivers.surname FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE drivers.dob > '1975-01-01' AND driverstandings.position = 2; 
SELECT  COUNT(DISTINCT drivers.driverid) FROM drivers JOIN results ON drivers.driverid = results.driverid JOIN races ON results.raceid = races.raceid WHERE drivers.nationality = 'Italian' AND results.time IS NULL;
SELECT  forename, surname FROM drivers WHERE driverid IN (     SELECT driverid     FROM results     WHERE fastestlaptime = (         SELECT MIN(fastestlaptime)         FROM results         WHERE fastestlaptime NOT NULL     ) ) 
SELECT  MAX(results.fastestlap) FROM results JOIN races ON results.raceid = races.raceid JOIN seasons ON races.year = seasons.year WHERE seasons.year = 2009 AND results.position = 1;
SELECT  ROUND(AVG(results.fastestlapspeed), 3) AS average_fastest_lap_speed FROM races JOIN results ON races.raceid = results.raceid WHERE races.name = 'Spanish Grand Prix' AND races.year = 2009
SELECT  races.name, races.year FROM races INNER JOIN results ON races.raceid = results.raceid WHERE results.milliseconds IS NOT NULL ORDER BY results.milliseconds ASC LIMIT 1; 
SELECT  (COUNT(DISTINCT driverstandings.driverid) * 100.0 / (SELECT COUNT(DISTINCT driverstandings.driverid) FROM driverstandings JOIN drivers ON driverstandings.driverid = drivers.driverid JOIN races ON driverstandings.raceid = races.raceid JOIN seasons ON races.year = seasons.year WHERE drivers.dob < '1985' AND races.year BETWEEN '2000' AND '2005')) AS percentage FROM driverstandings JOIN drivers ON driverstandings.driverid = drivers.driverid JOIN races ON driverstandings.raceid = races.raceid JOIN seasons ON races.year = seasons.year WHERE drivers.dob < '1985' AND races.year BETWEEN '2000' AND '2005' AND laps > 50; 
SELECT  COUNT(DISTINCT drivers.driverid) FROM drivers JOIN laptimes ON drivers.driverid = laptimes.driverid JOIN races ON laptimes.raceid = races.raceid WHERE laptimes.time < '2:00.00' AND drivers.nationality = 'French';
SELECT  `forename`, `surname`, `dob`, `url` FROM `drivers` WHERE `nationality` = 'American';
SELECT  raceid  FROM races  WHERE year = 2009; 
SELECT  COUNT(DISTINCT driverid) AS total_participants FROM results WHERE raceid = 18; 
SELECT  driverid, MIN(year(dob)) AS min_dob FROM drivers GROUP BY driverid ORDER BY min_dob LIMIT 3; 
SELECT  `driverref` FROM `drivers` WHERE `forename` = 'Robert' AND `surname` = 'Kubica';
SELECT  COUNT(*) FROM drivers WHERE nationality = 'Australian' AND strftime('%Y', dob) = '1980';
SELECT  drivers.forename, drivers.surname FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid JOIN laptimes ON drivers.driverid = laptimes.driverid AND races.raceid = laptimes.raceid WHERE drivers.nationality = 'German' AND drivers.dob BETWEEN '1980-01-01' AND '1990-12-31' GROUP BY drivers.driverid ORDER BY MIN(laptimes.time) LIMIT 3;
SELECT  drivers.driverref FROM drivers WHERE drivers.nationality = 'German' AND drivers.dob = (SELECT MIN(year(dob)) FROM drivers WHERE nationality = 'German');
SELECT  drivers.driverid, drivers.code FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid JOIN laptimes ON drivers.driverid = laptimes.driverid AND races.raceid = laptimes.raceid WHERE strftime('%Y', drivers.dob) = '1971' ORDER BY laptimes.time ASC LIMIT 1; 
SELECT drivers.forename, drivers.surname FROM drivers WHERE drivers.nationality = 'Spanish' AND strftime('%Y', drivers.dob) < '1982' ORDER BY (SELECT MAX(laptimes.time) FROM laptimes WHERE laptimes.driverid = drivers.driverid) LIMIT 10; 
SELECT  year FROM races WHERE fastestlaptime IS NOT NULL ORDER BY CAST(fastestlaptime AS DECIMAL) ASC LIMIT 1; 
SELECT  MIN(substr(time, 1, 2) * 3600 + substr(time, 4, 2) * 60 + substr(time, 7)) AS min_speed_year FROM laptimes JOIN races ON laptimes.raceid = races.raceid JOIN seasons ON races.year = seasons.year; 
SELECT  driverid FROM laptimes WHERE lap = 1 ORDER BY time ASC LIMIT 5;
SELECT  COUNT(results.resultid) AS disqualified_finishers FROM results JOIN races ON results.raceid = races.raceid WHERE races.raceid BETWEEN 50 AND 100 AND results.statusid = 2 AND results.time IS NOT NULL;
SELECT  COUNT(*), location, lat, lng FROM circuits WHERE country = 'Austria';
SELECT  COUNT(raceid) AS finisher_count, raceid FROM results WHERE time IS NOT NULL GROUP BY raceid ORDER BY finisher_count DESC LIMIT 1;
SELECT  drivers.driverref, drivers.nationality, drivers.dob FROM drivers JOIN qualifying ON drivers.driverid = qualifying.driverid WHERE qualifying.q2 IS NOT NULL AND qualifying.raceid = 23;
SELECT  MIN(year) AS "Year", races.name AS "Race Name", races.date AS "Race Date", races.time AS "Race Time" FROM qualifying JOIN drivers ON qualifying.driverid = drivers.driverid JOIN races ON qualifying.raceid = races.raceid WHERE drivers.dob = (SELECT MIN(year(dob)) FROM drivers) 
SELECT  COUNT(results.driverid) FROM results JOIN drivers ON results.driverid = drivers.driverid JOIN status ON results.statusid = status.statusid WHERE drivers.nationality = 'American' AND status.status = 'Disqualified'; 
SELECT  constructors.name, constructors.url FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid WHERE constructors.nationality = 'Italian' ORDER BY constructorstandings.points DESC LIMIT 1; 
SELECT  constructors.url FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid GROUP BY constructors.constructorid ORDER BY SUM(constructorstandings.wins) DESC LIMIT 1; 
SELECT  drivers.forename, drivers.surname FROM drivers JOIN races ON drivers.driverid = results.driverid JOIN results ON results.raceid = races.raceid WHERE races.name = 'French Grand Prix' AND laptimes.lap = 3 ORDER BY laptimes.time DESC LIMIT 1; 
SELECT  raceid, MIN(milliseconds) AS fastest_1st_lap_time FROM laptimes WHERE lap = 1 GROUP BY raceid ORDER BY fastest_1st_lap_time LIMIT 1;
SELECT  AVG(fastestlaptime) AS average_fastest_lap_time FROM results WHERE raceid = (         SELECT raceid         FROM races         WHERE name = 'United States Grand Prix' AND year = 2006     )     AND rank < 11; 
SELECT drivers.forename, drivers.surname, AVG(pitstops.duration) AS avg_pitstop_duration FROM drivers JOIN pitstops ON drivers.driverid = pitstops.driverid WHERE drivers.nationality = 'German' AND drivers.dob BETWEEN '1980-01-01' AND '1985-12-31' GROUP BY drivers.driverid ORDER BY avg_pitstop_duration ASC LIMIT 5; 
SELECT  drivers.forename || ' ' || drivers.surname AS champion, results.time FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE races.name = 'Canadian Grand Prix' AND races.year = 2008 AND results.position = 1;
SELECT  constructors.constructorref, constructors.url FROM constructors JOIN constructorstandings ON constructors.constructorid = constructorstandings.constructorid JOIN races ON constructorstandings.raceid = races.raceid WHERE races.name = 'Singapore Grand Prix' AND races.year = 2009 ORDER BY constructorstandings.position ASC LIMIT 1;
SELECT  forename || ' ' || surname AS full_name, dob FROM drivers WHERE nationality = 'Austrian' AND strftime('%Y', dob) BETWEEN '1981' AND '1991'; 
SELECT drivers.forename || ' ' || drivers.surname AS full_name, drivers.url AS wikipedia_page_link, drivers.dob AS date_of_birth FROM drivers WHERE drivers.nationality = 'German' AND strftime('%Y', drivers.dob) BETWEEN '1971' AND '1985' ORDER BY drivers.dob DESC; 
SELECT circuits.location, circuits.country, circuits.lat, circuits.lng FROM circuits WHERE circuits.name = 'Hungaroring'; 
SELECT  constructors.name, constructors.nationality, SUM(constructorresults.points) AS total_points FROM constructors JOIN constructorresults ON constructors.constructorid = constructorresults.constructorid JOIN races ON constructorresults.raceid = races.raceid WHERE races.name = 'Monaco Grand Prix' AND races.year BETWEEN 1980 AND 2010 GROUP BY constructors.name, constructors.nationality ORDER BY total_points DESC LIMIT 1; 
SELECT  AVG(results.points) FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE races.name = 'Turkish Grand Prix' AND drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton';
SELECT  AVG(COUNT(races.raceid)) FROM races JOIN seasons ON races.year = seasons.year WHERE races.date BETWEEN '2000-01-01' AND '2010-12-31' GROUP BY seasons.year LIMIT 10;
SELECT  MAX(nationality) FROM drivers;
SELECT  COUNT(driverstandings.wins) AS victories FROM driverstandings WHERE driverstandings.position = 91;
SELECT  races.name FROM races JOIN results ON races.raceid = results.raceid WHERE results.fastestlapspeed = (     SELECT MIN(fastestlapspeed) FROM results WHERE fastestlapspeed > 0 );
SELECT  circuits.name || ', ' || circuits.location || ', ' || circuits.country AS recent_race_location FROM circuits JOIN races ON circuits.circuitid = races.circuitid WHERE races.date = (SELECT MAX(date) FROM races)
SELECT  drivers.forename || ' ' || drivers.surname AS "Full Name" FROM drivers JOIN qualifying ON drivers.driverid = qualifying.driverid JOIN races ON qualifying.raceid = races.raceid JOIN circuits ON races.circuitid = circuits.circuitid WHERE races.year = 2008 AND circuits.name = 'Marina Bay Street Circuit' AND qualifying.q3 = (SELECT MIN(q3) FROM qualifying WHERE raceid = races.raceid) AND qualifying.position = 1;
SELECT  drivers.forename || ' ' || drivers.surname AS full_name, drivers.nationality, races.name AS first_race FROM drivers JOIN driverstandings ON drivers.driverid = driverstandings.driverid JOIN races ON driverstandings.raceid = races.raceid WHERE drivers.dob = (SELECT MAX(dob) FROM drivers)
SELECT  COUNT(*) FROM results JOIN races ON results.raceid = races.raceid JOIN drivers ON results.driverid = drivers.driverid JOIN status ON results.statusid = status.statusid WHERE races.name = 'Canadian Grand Prix' AND status.status = 'Accident';
SELECT  COUNT(driverstandings.wins), drivers.forename, drivers.surname FROM driverstandings JOIN drivers ON driverstandings.driverid = drivers.driverid WHERE drivers.dob = (SELECT MIN(dob) FROM drivers)
SELECT  MAX(duration) FROM pitstops;
SELECT  MIN(milliseconds) AS fastest_lap_time FROM laptimes; 
SELECT  MAX(duration) FROM pitstops JOIN drivers ON pitstops.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton';
SELECT  pitstops.lap FROM pitstops JOIN races ON pitstops.raceid = races.raceid JOIN drivers ON pitstops.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND races.name = 'Australian Grand Prix' AND races.year = 2011; 
SELECT  pitstops.time FROM pitstops JOIN races ON pitstops.raceid = races.raceid JOIN drivers ON pitstops.driverid = drivers.driverid WHERE races.year = 2011 AND races.name = 'Australian Grand Prix';
SELECT  MIN(time) AS lap_record FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton'
SELECT  drivers.forename || ' ' || drivers.surname AS shortest_lap_time_driver FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid WHERE laptimes.time = (     SELECT MIN(time)     FROM laptimes )
SELECT  position FROM laptimes JOIN drivers ON laptimes.driverid = drivers.driverid JOIN races ON laptimes.raceid = races.raceid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' AND laptimes.time = (     SELECT MIN(time)     FROM laptimes     JOIN drivers ON laptimes.driverid = drivers.driverid     WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton' );
SELECT  MIN(time) AS lap_record FROM laptimes JOIN races ON laptimes.raceid = races.raceid JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.name = 'Austrian Grand Prix';
SELECT  circuits.name AS circuit_name,        circuits.location AS circuit_location,        circuits.country AS circuit_country,        circuits.url AS circuit_url,        races.year AS race_year,        races.name AS race_name,        laptimes.time AS lap_record_time FROM circuits JOIN races ON races.circuitid = circuits.circuitid JOIN laptimes ON laptimes.raceid = races.raceid JOIN (     SELECT circuits.circuitid,            MIN(laptimes.milliseconds) AS min_milliseconds     FROM circuits     JOIN races ON races.circuitid = circuits.circuitid     JOIN laptimes ON laptimes.raceid = races.raceid     WHERE circuits.country = 'Italy'     GROUP BY circuits.circuitid ) AS min_times ON min_times.circuitid = circuits.circuitid AND min_times.min_milliseconds = laptimes.milliseconds; 
SELECT  races.name FROM races INNER JOIN laptimes ON races.raceid = laptimes.raceid WHERE races.name = 'Austrian Grand Prix' ORDER BY laptimes.time ASC LIMIT 1;
SELECT  SUM(pitstops.duration) FROM pitstops JOIN races ON pitstops.raceid = races.raceid JOIN circuits ON races.circuitid = circuits.circuitid JOIN results ON races.raceid = results.raceid JOIN drivers ON results.driverid = drivers.driverid WHERE circuits.name = 'Austrian Grand Prix Circuit' AND results.fastestlap = 1
SELECT circuits.lat, circuits.lng FROM circuits INNER JOIN races ON circuits.circuitid = races.circuitid INNER JOIN results ON races.raceid = results.raceid WHERE results.fastestlaptime = '1:29.488' 
SELECT  AVG(pitstops.duration) FROM pitstops JOIN drivers ON pitstops.driverid = drivers.driverid WHERE drivers.forename = 'Lewis' AND drivers.surname = 'Hamilton';
SELECT  AVG(milliseconds) AS average_lap_time FROM laptimes JOIN races ON laptimes.raceid = races.raceid JOIN circuits ON races.circuitid = circuits.circuitid WHERE circuits.country = 'Italy';
SELECT  MAX(overall_rating), player_api_id FROM player_attributes;
SELECT  player.player_name, MAX(player.height) AS tallest_height FROM player; 
SELECT  preferred_foot  FROM player_attributes  WHERE potential = (SELECT MIN(potential) FROM player_attributes); 
SELECT  COUNT(DISTINCT player_api_id) FROM player_attributes WHERE overall_rating >= 60 AND overall_rating < 65 AND defensive_work_rate = 'low';
SELECT  player_attributes.player_api_id FROM player_attributes ORDER BY crossing DESC LIMIT 5;
SELECT league.name FROM match JOIN league ON match.league_id = league.id WHERE match.season = '2015/2016' GROUP BY match.league_id ORDER BY SUM(match.home_team_goal + match.away_team_goal) DESC LIMIT 1; 
SELECT  team.team_long_name AS home_team, COUNT(*) AS lost_matches FROM match JOIN team ON match.home_team_api_id = team.team_api_id WHERE season = '2015/2016' AND (home_team_goal - away_team_goal) < 0 GROUP BY home_team ORDER BY lost_matches ASC LIMIT 1; 
SELECT  player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.penalties = (     SELECT MAX(penalties)     FROM player_attributes ) ORDER BY player_attributes.penalties DESC LIMIT 10; 
SELECT  team.team_long_name AS away_team_name, COUNT(*) AS wins FROM match JOIN team ON match.away_team_api_id = team.team_api_id WHERE match.league_id = (SELECT id FROM league WHERE name = 'Scotland Premier League')     AND match.season = '2009/2010'     AND (match.away_team_goal - match.home_team_goal) > 0 GROUP BY away_team_name ORDER BY wins DESC LIMIT 1; 
SELECT  MAX(team_attributes.buildupplayspeed) AS build_up_play_speed FROM team_attributes ORDER BY buildupplayspeed DESC LIMIT 4;
SELECT  league.name FROM match JOIN league ON match.league_id = league.id WHERE match.season = '2015/2016' GROUP BY match.league_id ORDER BY SUM(CASE WHEN match.home_team_goal = match.away_team_goal THEN 1 ELSE 0 END) DESC LIMIT 1; 
SELECT ROUND((JulianDay('now') - JulianDay(player.birthday)) / 365.25, 2) AS player_age FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.sprint_speed >= 97 AND player_attributes.date BETWEEN '2013-01-01 00:00:00' AND '2015-12-31 00:00:00'; 
SELECT  league.name, COUNT(match.id) AS match_count FROM match JOIN league ON match.league_id = league.id GROUP BY league.name ORDER BY match_count DESC LIMIT 1; 
SELECT  ROUND(AVG(height), 2) AS average_height FROM player WHERE birthday >= '1990-01-01 00:00:00' AND birthday < '1996-01-01 00:00:00';
SELECT  MAX(pa.player_api_id) AS player_api_id FROM player_attributes AS pa JOIN (     SELECT AVG(overall_rating) AS avg_rating     FROM player_attributes     WHERE SUBSTR(date, 1, 4) = '2010' ) AS avg_table WHERE SUBSTR(pa.date, 1, 4) = '2010' AND pa.overall_rating > avg_table.avg_rating;
SELECT  team_fifa_api_id FROM team_attributes WHERE buildupplayspeed BETWEEN 51 AND 59; 
SELECT  team.team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildupplaypassing > (         SELECT AVG(buildupplaypassing)         FROM team_attributes         WHERE buildupplaypassing IS NOT NULL     ) AND strftime('%Y', team_attributes.date) = '2012'; 
SELECT ROUND((COUNT(CASE WHEN preferred_foot = 'left' THEN 1 END) * 1.0) / COUNT(player_fifa_api_id) * 100, 2) AS percentage_left_foot_players FROM player WHERE birthday BETWEEN '1987-01-01 00:00:00' AND '1992-12-31 00:00:00'; 
SELECT  league.name AS league_name, SUM(home_team_goal + away_team_goal) AS total_goals FROM match JOIN league ON match.league_id = league.id GROUP BY league.name ORDER BY total_goals ASC LIMIT 5; 
SELECT  ROUND(AVG(long_shots), 2) AS average_long_shots FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Ahmed Samir Farag';
SELECT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.height > 180 GROUP BY player.player_name ORDER BY AVG(player_attributes.heading_accuracy) DESC LIMIT 10; 
SELECT  team.team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildupplaydribblingclass = 'Normal' AND team_attributes.date BETWEEN '2014-01-01 00:00:00' AND '2014-01-31 00:00:00' GROUP BY team.team_long_name HAVING AVG(chancecreationpassing) < (     SELECT AVG(chancecreationpassing)     FROM team_attributes     WHERE buildupplaydribblingclass = 'Normal'     AND date BETWEEN '2014-01-01 00:00:00' AND '2014-01-31 00:00:00' ) ORDER BY AVG(chancecreationpassing) DESC; 
SELECT league.name FROM match JOIN league ON match.league_id = league.id WHERE match.season = '2009/2010' GROUP BY match.league_id HAVING AVG(match.home_team_goal) > AVG(match.away_team_goal); 
SELECT  team_short_name  FROM team  WHERE team_long_name = 'Queens Park Rangers'; 
SELECT  player_name FROM player WHERE strftime('%Y', birthday) = '1970' AND strftime('%m', birthday) = '10'; 
SELECT  player_attributes.attacking_work_rate FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.player_name = 'Franco Zennaro'; 
SELECT  team.team_long_name, team_attributes.buildupplaypositioningclass FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team.team_long_name = 'ADO Den Haag'; 
SELECT  pa.heading_accuracy FROM player_attributes AS pa JOIN player AS p ON pa.player_api_id = p.player_api_id WHERE p.player_name = 'Francois Affolter' AND pa.date = '2014-09-18 00:00:00'; 
SELECT  player_attributes.overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Gabriel Tamas' AND strftime('%Y', player_attributes.date) = '2011'; 
SELECT  COUNT(match.id) FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Scotland Premier League' AND match.season = '2015/2016';
SELECT  preferred_foot FROM player ORDER BY birthday DESC LIMIT 1;
SELECT  player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.potential = (     SELECT MAX(potential)     FROM player_attributes ); 
SELECT  COUNT(*)  FROM player_attributes  JOIN player ON player_attributes.player_api_id = player.player_api_id  WHERE player.weight < 130 AND player_attributes.attacking_work_rate = 'left';
SELECT team.team_short_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.chancecreationpassingclass = 'Risky'; 
SELECT  player_attributes.defensive_work_rate FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.player_name = 'David Wilson'; 
SELECT  birthday FROM player WHERE player_api_id = (     SELECT player_api_id     FROM player_attributes     WHERE overall_rating = (         SELECT MAX(overall_rating)         FROM player_attributes     ) ); 
SELECT  league.name FROM league JOIN country ON league.country_id = country.id WHERE country.name = 'Netherlands'; 
SELECT  AVG(home_team_goal) AS average_home_team_goal FROM match JOIN league ON match.country_id = league.country_id JOIN country ON league.country_id = country.id WHERE country.name = 'Poland' AND match.season = '2010/2011'; 
SELECT  MAX(player.height) AS max_height, MIN(player.height) AS min_height, AVG(player_attributes.finishing) AS avg_finishing_rate, player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.height = (     SELECT MAX(height) FROM player ) OR player.height = (     SELECT MIN(height) FROM player ) GROUP BY player.player_name ORDER BY avg_finishing_rate DESC LIMIT 1;
SELECT  player_name FROM player WHERE height > 180; 
SELECT  COUNT(*) FROM player WHERE strftime('%Y', birthday) > '1990';
SELECT  COUNT(*) AS total_players FROM player WHERE player_name LIKE 'Adam%' AND weight > 170;
SELECT  DISTINCT player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.overall_rating > 80 AND strftime('%Y', player_attributes.date) BETWEEN '2008' AND '2010'; 
SELECT  potential FROM player_attributes WHERE player_api_id = (     SELECT player_api_id     FROM player     WHERE player_name = 'Aaron Doran' );
SELECT  player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.preferred_foot = 'left'; 
SELECT  team.team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildupplayspeedclass = 'Fast';
SELECT  buildupplaypassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_short_name = 'CLB';
SELECT  team.team_short_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildupplaypassing > 70;
SELECT  AVG(overall_rating) AS average_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE strftime('%Y', player_attributes.date) BETWEEN '2010' AND '2015' AND player.height > 170; 
SELECT  player_name FROM player ORDER BY height ASC LIMIT 1; 
SELECT  country.name FROM league JOIN country ON league.country_id = country.id WHERE league.name = 'Italy Serie A';
SELECT  team_short_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildupplayspeed = 31 AND team_attributes.buildupplaydribbling = 53 AND team_attributes.buildupplaypassing = 32; 
SELECT  AVG(player_attributes.overall_rating) AS average_overall_rating FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.player_name = 'Aaron Doran';
SELECT  COUNT(*) AS match_count FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Germany 1. Bundesliga' AND strftime('%Y-%m', match.date) BETWEEN '2008-08' AND '2008-10';
SELECT  team.team_short_name FROM team JOIN match ON match.home_team_api_id = team.team_api_id WHERE match.home_team_goal = 10;
SELECT player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.balance = (SELECT MAX(balance) FROM player_attributes WHERE potential = 61) AND player_attributes.potential = 61; 
SELECT  AVG(player_attributes.ball_control) AS avg_ball_control FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Abdou Diallo' OR player.player_name = 'Aaron Appindangoye';
SELECT  team_long_name FROM team WHERE team_short_name = 'GEN'; 
SELECT  `player_name` FROM player WHERE player_name IN ('Aaron Lennon', 'Abdelaziz Barrada') ORDER BY birthday ASC LIMIT 1;
SELECT  player_name FROM player ORDER BY height DESC LIMIT 1; 
SELECT  COUNT(*) FROM player_attributes WHERE preferred_foot = 'left' AND attacking_work_rate = 'low';
SELECT  country.name FROM country JOIN league ON league.country_id = country.id WHERE league.name = 'Belgium Jupiler League';
SELECT  league.name FROM league JOIN country ON league.country_id = country.id WHERE country.name = 'Germany'; 
SELECT  MAX(player_attributes.overall_rating) AS strongest_overall_strength FROM player_attributes;
SELECT  COUNT(*)  FROM player_attributes  JOIN player ON player_attributes.player_api_id = player.player_api_id AND player_attributes.player_fifa_api_id = player.player_fifa_api_id  WHERE strftime('%Y', player.birthday) < '1986' AND player_attributes.defensive_work_rate = 'high';
SELECT  MAX(crossing) AS max_crossing,     player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_name IN ('Alexis', 'Ariel Borysiuk', 'Arouna Kone');
SELECT  pa.heading_accuracy FROM player_attributes AS pa JOIN player AS p ON pa.player_api_id = p.player_api_id WHERE p.player_name = 'Ariel Borysiuk'; 
SELECT  COUNT(*)  FROM player_attributes  WHERE height > 180 AND volleys > 70;
SELECT  player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.volleys > 70 AND player_attributes.dribbling > 70;
SELECT  COUNT(*) AS matches_in_belgium FROM match JOIN league ON match.league_id = league.id JOIN country ON league.country_id = country.id WHERE match.season = '2008/2009' AND country.name = 'Belgium';
SELECT  MAX(long_passing) AS long_passing_score FROM player_attributes WHERE birthday = (     SELECT MIN(birthday)     FROM player )
SELECT  COUNT(*) FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Belgium Jupiler League' AND strftime('%Y', match.date) = '2009' AND strftime('%m', match.date) = '04';
SELECT  MAX(league_id) AS league_id FROM match WHERE season = '2008/2009' GROUP BY league_id ORDER BY COUNT(*) DESC LIMIT 1;
SELECT  AVG(overall_rating) AS average_overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE strftime('%Y', player.birthday) < '1986'; 
SELECT  ((SELECT overall_rating FROM player_attributes WHERE player_api_id = (SELECT player_api_id FROM player WHERE player_name = 'Ariel Borysiuk')) - (SELECT overall_rating FROM player_attributes WHERE player_api_id = (SELECT player_api_id FROM player WHERE player_name = 'Paulin Puel'))) / (SELECT overall_rating FROM player_attributes WHERE player_api_id = (SELECT player_api_id FROM player WHERE player_name = 'Paulin Puel')) * 100;
SELECT  AVG(buildupplayspeed) AS average_build_up_play_speed FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Heart of Midlothian';
SELECT  AVG(T1.overall_rating) AS average_overall_rating FROM player_attributes AS T1 JOIN player AS T2 ON T1.player_api_id = T2.player_api_id WHERE T2.player_name = 'Pietro Marino'; 
SELECT  SUM(player_attributes.crossing) AS total_crossing_score FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Aaron Lennox';
SELECT  MAX(chancecreationpassing), chancecreationpassingclass FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team.team_long_name = 'Ajax';
SELECT  preferred_foot FROM player WHERE player_name = 'Abdou Diallo';
SELECT  MAX(player_attributes.overall_rating) AS highest_overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Dorlan Pabon';
SELECT  AVG(away_team_goal) AS average_goals FROM match JOIN team ON match.away_team_api_id = team.team_api_id JOIN country ON match.country_id = country.id WHERE team.team_long_name = 'Parma' AND country.name = 'Italy';
SELECT  player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.overall_rating = 77 AND player_attributes.date = '2016-06-23' ORDER BY player.birthday ASC LIMIT 1; 
SELECT  pa.overall_rating FROM player_attributes AS pa JOIN player AS p ON pa.player_api_id = p.player_api_id WHERE p.player_name = 'Aaron Mooy' AND date = '2016-02-04 00:00:00'; 
SELECT  potential FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Francesco Parravicini' AND player_attributes.date = '2010-08-30';
SELECT  attacking_work_rate FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id AND player_attributes.player_fifa_api_id = player.player_fifa_api_id WHERE player.player_name = 'Francesco Migliore' AND player_attributes.date = '2015-05-01 00:00:00';
SELECT  defensive_work_rate FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Kevin Berigaud' AND player_attributes.date = '2013-02-22 00:00:00';
SELECT MIN(date) AS first_highest_crossing_date FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player.player_name = 'Kevin Constant' AND player_attributes.crossing = (     SELECT MAX(crossing)      FROM player_attributes      WHERE player_attributes.player_api_id = player.player_api_id ) 
SELECT  team_attributes.buildupplayspeedclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Willem II' AND team_attributes.date = '2012-02-22 00:00:00'; 
SELECT  buildupplaydribblingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id JOIN match ON match.home_team_api_id = team.team_api_id JOIN league ON match.country_id = league.country_id WHERE team.team_short_name = 'LEI' AND match.date = '2015-09-10 00:00:00'
SELECT  team_attributes.buildupplaypassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id JOIN match ON match.home_team_api_id = team.team_api_id OR match.away_team_api_id = team.team_api_id WHERE team.team_long_name = 'FC Lorient' AND date = '2010-02-22'; 
SELECT  team_attributes.chancecreationpassingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'PEC Zwolle' AND team_attributes.date = '2013-09-20 00:00:00'; 
SELECT  team_attributes.chancecreationcrossingclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id JOIN match ON match.home_team_api_id = team.team_api_id OR match.away_team_api_id = team.team_api_id WHERE team.team_long_name = 'Hull City' AND match.date = '2010-02-22 00:00:00'; 
SELECT  team_attributes.defenceaggressionclass FROM team_attributes JOIN team ON team_attributes.team_api_id = team.team_api_id WHERE team.team_long_name = 'Hannover 96' AND team_attributes.date = '2015-09-10 00:00:00';
SELECT  AVG(overall_rating) AS average_overall_rating FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Marko Arnautovic' AND player_attributes.date BETWEEN '2007-02-22 00:00:00' AND '2016-04-21 00:00:00'; 
SELECT  ((Landon_Donovan.overall_rating - Jordan_Bowery.overall_rating) / Jordan_Bowery.overall_rating) * 100 as percentage_higher FROM player_attributes as Landon_Donovan JOIN player_attributes as Jordan_Bowery ON Landon_Donovan.player_api_id = Jordan_Bowery.player_api_id JOIN player ON Landon_Donovan.player_api_id = player.player_api_id JOIN match ON Landon_Donovan.date = match.date WHERE Landon_Donovan.player_name = 'Landon Donovan' AND Jordan_Bowery.player_name = 'Jordan Bowery' AND DATE(match.date) = '2013-07-12';
SELECT player_name FROM player ORDER BY height DESC LIMIT 5; 
SELECT  player_api_id FROM player ORDER BY weight DESC LIMIT 10; 
SELECT  player.player_name FROM player WHERE strftime('%Y', 'now') - strftime('%Y', player.birthday) > 34; 
SELECT  COUNT(match.home_team_goal) FROM match JOIN player ON match.home_player_1 = player.player_api_id WHERE player.player_name = 'Aaron Lennon';
SELECT  SUM(match.away_team_goal) AS total_away_goals FROM match JOIN player AS p1 ON match.away_player_1 = p1.player_api_id JOIN player AS p2 ON match.away_player_2 = p2.player_api_id WHERE (p1.player_name = 'Daan Smith' OR p1.player_name = 'Filipe Ferreira') AND (p2.player_name = 'Daan Smith' OR p2.player_name = 'Filipe Ferreira'); 
SELECT  SUM(match.home_team_goal) AS total_home_team_goals FROM match JOIN player ON match.home_player_1 = player.player_api_id              OR match.home_player_2 = player.player_api_id              OR match.home_player_3 = player.player_api_id              OR match.home_player_4 = player.player_api_id              OR match.home_player_5 = player.player_api_id              OR match.home_player_6 = player.player_api_id              OR match.home_player_7 = player.player_api_id              OR match.home_player_8 = player.player_api_id              OR match.home_player_9 = player.player_api_id              OR match.home_player_10 = player.player_api_id              OR match.home_player_11 = player.player_api_id  WHERE strftime('%Y', 'now') - strftime('%Y', player.birthday) <= 30 
SELECT  player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.overall_rating = (     SELECT MAX(overall_rating)     FROM player_attributes ) LIMIT 10; 
SELECT  player.player_name FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player_attributes.potential = (SELECT MAX(potential) FROM player_attributes)
SELECT  DISTINCT p.player_name FROM player AS p JOIN player_attributes AS pa ON p.player_api_id = pa.player_api_id AND p.player_fifa_api_id = pa.player_fifa_api_id JOIN match AS m ON (m.away_player_11 = p.player_api_id OR m.away_player_10 = p.player_api_id OR m.away_player_9 = p.player_api_id OR m.away_player_8 = p.player_api_id OR m.away_player_7 = p.player_api_id OR m.away_player_6 = p.player_api_id OR m.away_player_5 = p.player_api_id OR m.away_player_4 = p.player_api_id OR m.away_player_3 = p.player_api_id OR m.away_player_2 = p.player_api_id OR m.away_player_1 = p.player_api_id OR m.home_player_11 = p.player_api_id OR m.home_player_10 = p.player_api_id OR m.home_player_9 = p.player_api_id OR m.home_player_8 = p.player_api_id OR m.home_player_7 = p.player_api_id OR m.home_player_6 = p.player_api_id OR m.home_player_5 = p.player_api_id OR m.home_player_4 = p.player_api_id OR m.home_player_3 = p.player_api_id OR m.home_player_2 = p.player_api_id OR m.home_player_1 = p.player_api_id) JOIN team AS t ON (m.away_team_api_id = t.team_api_id OR m.home_team_api_id = t.team_api_id) JOIN team_attributes AS ta ON t.team_api_id = ta.team_api_id AND t.team_fifa_api_id = ta.team_fifa_api_id WHERE pa.attacking_work_rate = 'high'; 
SELECT  player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.finishing = 1 ORDER BY strftime('%Y-%m-%d', 'now') - strftime('%Y-%m-%d', player.birthday) DESC LIMIT 1; 
SELECT  player.player_name FROM player JOIN country ON player.country_id = country.id WHERE country.name = 'Belgium';
SELECT  DISTINCT country.name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id JOIN country ON player.country_id = country.id WHERE player_attributes.vision > 89; 
SELECT  country.name FROM country JOIN player ON player.country_id = country.id GROUP BY country.name ORDER BY AVG(player.weight) DESC LIMIT 1; 
SELECT  team_long_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.buildupplayspeedclass = 'Slow'; 
SELECT  team_short_name FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_attributes.chancecreationpassingclass = 'Safe';
SELECT  AVG(height) AS average_height FROM player JOIN country ON player.country_id = country.id WHERE country.name = 'Italy'; 
SELECT  player.player_name FROM player WHERE player.height > 180 ORDER BY player.player_name LIMIT 3; 
SELECT  COUNT(*)  FROM player  WHERE player_name LIKE 'Aaron%'  AND birthday > '1990-01-01 00:00:00';
SELECT  ABS((SELECT jumping FROM player_attributes WHERE id = 6) - (SELECT jumping FROM player_attributes WHERE id = 23)) AS jumping_difference;
SELECT  player_api_id FROM player_attributes WHERE preferred_foot = 'right' ORDER BY potential ASC LIMIT 3;
SELECT  COUNT(*)  FROM player_attributes  WHERE crossing = (SELECT MAX(crossing) FROM player_attributes)  AND preferred_foot = 'left';
SELECT  COUNT(*) * 100.0 / (SELECT COUNT(*) FROM player_attributes WHERE stamina > 80 AND strength > 80) AS percentage FROM player_attributes WHERE stamina > 80 AND strength > 80; 
SELECT  country.name FROM country JOIN league ON country.id = league.country_id WHERE league.name = 'Poland Ekstraklasa';
SELECT  home_team_goal, away_team_goal  FROM match  JOIN league ON match.league_id = league.id  JOIN country ON league.country_id = country.id  WHERE country.name = 'Belgium'  AND league.name = 'Belgium Jupiler League'  AND match.date LIKE '2008-09-24%' 
SELECT  sprint_speed, agility, acceleration FROM player_attributes JOIN player ON player_attributes.player_api_id = player.player_api_id WHERE player.player_name = 'Alexis Blin';
SELECT  team_long_name, buildupplayspeedclass FROM team JOIN team_attributes ON team.team_api_id = team_attributes.team_api_id WHERE team_long_name = 'KSV Cercle Brugge'; 
SELECT  COUNT(match.id) AS games_played FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Italy Serie A' AND match.season = '2015/2016';
SELECT  MAX(home_team_goal) AS highest_score FROM match JOIN league ON match.league_id = league.id WHERE league.name = 'Netherlands Eredivisie';
SELECT  MAX(player.weight), player_attributes.finishing, player_attributes.curve FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id;
SELECT  league.name FROM match JOIN league ON match.league_id = league.id WHERE match.season = '2015/2016' GROUP BY league.name ORDER BY COUNT(match.id) DESC LIMIT 1; 
SELECT  team.team_long_name FROM match JOIN team ON match.away_team_api_id = team.team_api_id WHERE match.away_team_goal = (     SELECT MAX(away_team_goal)     FROM match );
SELECT  player.player_name FROM player JOIN player_attributes ON player.player_api_id = player_attributes.player_api_id WHERE player_attributes.overall_rating = (     SELECT MAX(overall_rating)     FROM player_attributes )
SELECT  COUNT(*) * 100.0 / (SELECT COUNT(*) FROM player WHERE height < 180) FROM player_attributes WHERE height < 180 AND overall_rating > 70;
SELECT  ( (SELECT COUNT(patient.id) FROM patient WHERE patient.sex = 'M' AND patient.admission = '+') - (SELECT COUNT(patient.id) FROM patient WHERE patient.sex = 'M' AND patient.admission = '-') ) * 100.0 / (SELECT COUNT(patient.id) FROM patient WHERE patient.sex = 'M') 
SELECT  COUNT(patient.id) * 100.0 / (SELECT COUNT(patient.id) FROM patient WHERE sex = 'F') AS percentage_female_born_after_1930  FROM patient  WHERE sex = 'F' AND strftime('%Y', birthday) > '1930'; 
SELECT  ROUND((CAST(COUNT(CASE WHEN p.admission = '+' THEN 1 END) AS FLOAT) / COUNT(*)) * 100, 2) AS percentage_inpatient FROM patient p WHERE strftime('%Y', p.birthday) BETWEEN '1930' AND '1940'; 
SELECT       CAST(         (SELECT COUNT(patient.id) FROM patient WHERE patient.diagnosis = 'SLE' AND patient.admission = '+')         AS REAL) /      CAST(         (SELECT COUNT(patient.id) FROM patient WHERE patient.diagnosis = 'SLE' AND patient.admission = '-')         AS REAL) AS "Outpatient to Inpatient Ratio" 
SELECT  diagnosis, date FROM patient JOIN examination ON patient.id = examination.id JOIN laboratory ON patient.id = laboratory.id WHERE patient.id = '30609';
SELECT  patient.sex, patient.birthday, examination.examination_date, examination.symptoms FROM patient JOIN examination ON patient.id = examination.id WHERE patient.id = '163109'; 
SELECT  patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.ldh > 500; 
SELECT  patient.id,         strftime('%Y', 'now') - strftime('%Y', patient.birthday) AS age  FROM patient  INNER JOIN examination ON examination.id = patient.id  WHERE examination.rvvt = '+'; 
SELECT  patient.id, patient.sex, patient.diagnosis FROM patient JOIN examination ON patient.id = examination.id WHERE examination.thrombosis = 2; 
SELECT  *  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE year(birthday) = '1937' AND t_cho >= '250'; 
SELECT  patient.id, patient.sex, patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.alb < 3.5; 
SELECT  100 * (     SELECT COUNT(*)      FROM patient      WHERE sex = 'F'      AND (tp < 6.0 OR tp > 8.5) ) / (     SELECT COUNT(*)      FROM patient      WHERE sex = 'F' ) AS percentage_female_abnormal_tp;
SELECT  AVG(examination.acl_igg) AS avg_acl_igg FROM examination JOIN patient ON examination.id = patient.id WHERE patient.admission = '+' AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) >= 50; 
SELECT  COUNT(patient.id) FROM patient WHERE sex = 'F' AND strftime('%Y', description) = '1997' AND admission = '-'
SELECT  MIN(STRFTIME('%Y', patient.birthday, '-1 year', '-1 day') - STRFTIME('%Y', patient."first date")) FROM patient;
SELECT  COUNT(patient.id) FROM examination JOIN patient ON examination.id = patient.id WHERE examination.examination_date LIKE '1997-%' AND patient.sex = 'F' AND examination.thrombosis = '1'
SELECT  MAX(strftime('%Y', p.birthday)) - MIN(strftime('%Y', p.birthday)) AS age_gap FROM patient p JOIN laboratory l ON p.id = l.id WHERE l.tg >= 200 AND p.diagnosis = 'Normal'; 
SELECT  symptoms, diagnosis FROM examination JOIN patient ON examination.id = patient.id WHERE birthday = (SELECT MIN(birthday) FROM patient); 
SELECT  COUNT(DISTINCT patient.id) / 12 AS average_male_patients_per_month FROM patient INNER JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.date BETWEEN '1998-01-01' AND '1998-12-31';
SELECT  MAX(laboratory.date) AS "Medical Laboratory Work Completion Date",     strftime('%Y', MAX(laboratory.date)) - strftime('%Y', patient.birthday) AS "Age at Initial Hospital Arrival" FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE patient.diagnosis LIKE '%SJS%';
SELECT  CAST(SUM(CASE WHEN sex = 'M' AND ua <= '8.0' THEN 1 ELSE 0 END) AS REAL) / CAST(SUM(CASE WHEN sex = 'F' AND ua <= '6.5' THEN 1 ELSE 0 END) AS REAL) AS "Male to Female Ratio" FROM patient 
SELECT  COUNT(DISTINCT patient.id) FROM patient LEFT JOIN examination ON patient.id = examination.id WHERE strftime('%Y', examination.date) - strftime('%Y', patient.first_date) >= 1 AND examination.date IS NULL;
SELECT  COUNT(DISTINCT patient.id) FROM patient JOIN examination ON patient.id = examination.id WHERE strftime('%Y', patient.birthday) BETWEEN '1977' AND '1993'
SELECT  COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.t_bil > 2.0;
SELECT  diagnosis FROM examination JOIN patient ON examination.id = patient.id WHERE examination_date BETWEEN '1985-01-01' AND '1995-12-31' GROUP BY diagnosis ORDER BY COUNT(diagnosis) DESC LIMIT 1; 
SELECT  AVG((julianday('1991-10-30') - julianday(substr(patient.birthday, 1, 4) || '-' || substr(patient.birthday, 6, 2) || '-' || substr(patient.birthday, 9, 2))) / 365.25) AS avg_age FROM patient WHERE substr(patient.first_date, 1, 4) = '1991' AND substr(patient.first_date, 6, 2) = '10'
SELECT  MAX(HGB) AS max_hgb,         (strftime('%Y', examination_date) - strftime('%Y', birthday)) AS age_at_examination,        diagnosis FROM examination JOIN patient ON examination.id = patient.id WHERE hgb = (SELECT MAX(hgb) FROM examination) 
SELECT  ana FROM examination WHERE id = '3605340' AND examination_date = '1996-12-02'; 
SELECT  COUNT(*)  FROM laboratory  WHERE id = '2927464'  AND date = '1995-09-04'  AND t_cho < 250;
SELECT  patient.sex FROM patient WHERE patient.diagnosis = 'AORTITIS' ORDER BY patient.first_date LIMIT 1; 
SELECT  acl_igm FROM examination JOIN patient ON examination.id = patient.id WHERE patient.diagnosis = 'SLE' AND patient.description = '1994-02-19' AND examination.examination_date = '1993-11-12';
SELECT  patient.sex FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.gpt = '9' AND laboratory.date = '1992-06-12'; 
SELECT  DATEDIFF('1992', strftime('%Y', p.birthday)) AS age_at_test FROM patient p JOIN laboratory l ON p.id = l.id WHERE l.ua = '8.4' AND l.date = '1991-10-21';
SELECT  COUNT(laboratory.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.first_date = '1991-06-13' AND patient.diagnosis = 'SJS' AND strftime('%Y', laboratory.date) = '1995';
SELECT  patient.diagnosis FROM patient JOIN examination ON patient.id = examination.id WHERE examination.examination_date = '1997-01-27' 
SELECT  examination.symptoms FROM examination JOIN patient ON examination.id = patient.id WHERE patient.birthday = '1959-03-01' AND examination.examination_date = '1993-09-27'; 
SELECT  (SUM(CASE WHEN substr(l.date, 1, 7) = '1981-11' THEN l.t_cho ELSE 0 END) - SUM(CASE WHEN substr(l.date, 1, 7) = '1981-12' THEN l.t_cho ELSE 0 END)) /        SUM(CASE WHEN substr(l.date, 1, 7) = '1981-11' THEN 1 ELSE 0 END) AS decrease_rate FROM patient p JOIN laboratory l ON p.id = l.id WHERE p.birthday = '1959-02-18'; 
SELECT  DISTINCT patient.id FROM patient JOIN examination ON patient.id = examination.id WHERE patient.diagnosis LIKE '%Behcet%' AND examination."examination date" BETWEEN '1997-01-01' AND '1997-12-31'; 
SELECT  patient.id FROM patient JOIN examination ON patient.id = examination.id JOIN laboratory ON patient.id = laboratory.id WHERE examination.date BETWEEN '1987-07-06' AND '1996-01-31' AND laboratory.gpt > 30 AND laboratory.alb < 4; 
SELECT  COUNT(patient.id) AS "Number of Female Patients Born in 1964 Admitted to the Hospital", patient.id FROM patient WHERE patient.sex = 'F' AND strftime('%Y', patient.birthday) = '1964' AND patient.admission = '+' GROUP BY patient.id;
SELECT  COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE thrombosis = 2 AND ana_pattern = 'S' AND acl_igm > (AVG(acl_igm) * 1.2);
SELECT       (COUNT(DISTINCT p.id) * 1.0 / (SELECT COUNT(DISTINCT p.id) FROM patient p JOIN laboratory l ON p.id = l.id WHERE l.ua <= 6.5 AND l.ua IS NOT NULL AND l.got > 0 AND l.got < 30)) * 100 FROM      patient p JOIN      laboratory l ON p.id = l.id WHERE      l.ua <= 6.5 AND l.ua IS NOT NULL AND l.got > 0 AND l.got < 30; 
SELECT  (SELECT (COUNT(CASE WHEN p.sex = 'M' AND substr(p.first_date, 1, 4) = '1981' THEN 1 END) * 100.0) /  COUNT(CASE WHEN substr(p.first_date, 1, 4) = '1981' THEN 1 END)  FROM patient p  JOIN examination e ON p.id = e.id  WHERE p.diagnosis = 'BEHCET' AND substr(p.first_date, 1, 4) = '1981') 
SELECT  * FROM patient WHERE admission = '-'  AND EXISTS (     SELECT *     FROM laboratory     WHERE laboratory.id = patient.id     AND date LIKE '1991-10%'     AND t_bil < 2.0 ); 
SELECT  COUNT(DISTINCT patient.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE ana_pattern != 'P' AND sex = 'F' AND birthday BETWEEN '1980-01-01' AND '1989-12-31';
SELECT  patient.sex FROM patient JOIN examination ON patient.id = examination.id JOIN laboratory ON patient.id = laboratory.id WHERE examination.diagnosis = 'PSS' AND laboratory.crp = '2+' AND laboratory.cre = '1' AND laboratory.ldh = '123';
SELECT  AVG(laboratory.alb) AS avg_albumin_level FROM laboratory JOIN patient ON laboratory.id = patient.id JOIN examination ON examination.id = patient.id WHERE patient.sex = 'F' AND laboratory.plt > 400 AND patient.diagnosis = 'SLE';
SELECT  MAX(symptoms) FROM examination WHERE diagnosis = 'SLE';
SELECT  patient.first_date, patient.diagnosis FROM patient WHERE patient.id = '48473'; 
SELECT  COUNT(DISTINCT patient.id) FROM patient WHERE patient.sex = 'F' AND patient.diagnosis LIKE '%APS%'; 
SELECT  COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE strftime('%Y', examination.date) = '1997' AND (tp < 6 OR tp > 8.5);
SELECT  100 * SUM(CASE WHEN examination.symptoms LIKE '%thrombocytopenia%' THEN 1 ELSE 0 END) / COUNT(DISTINCT patient.id) as "Proportion of patients with signs of thrombocytopenia diagnosed with SLE" FROM examination JOIN patient ON examination.id = patient.id WHERE patient.diagnosis LIKE '%SLE%';
SELECT  (COUNT(CASE WHEN p.sex = 'F' THEN 1 END) * 100) / COUNT(*) AS percentage_of_women_with_RA FROM patient p JOIN examination e ON p.id = e.id WHERE strftime('%Y', p.birthday) = '1980' AND p.diagnosis = 'RA'; 
SELECT  COUNT(DISTINCT patient.id) FROM patient JOIN examination ON examination.id = patient.id WHERE patient.sex = 'M' AND examination.examination_date BETWEEN '1995-01-01' AND '1997-12-31' AND patient.diagnosis LIKE '%BEHCET%' AND patient.admission = '-'
SELECT  COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'F' AND laboratory.wbc < 3.5; 
SELECT  DATEDIFF('examination.examination date', 'patient.first date') AS evaluation_duration FROM examination JOIN patient ON examination.id = patient.id WHERE patient.id = '821298' 
SELECT  ua FROM laboratory JOIN patient ON laboratory.id = patient.id WHERE patient.id = 57266 
SELECT  date FROM laboratory WHERE id = '48473' AND got >= 60; 
SELECT  patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.got < 60 AND strftime('%Y', laboratory.date) = '1994'; 
SELECT  DISTINCT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.gpt >= 60 
SELECT  patient.diagnosis FROM patient INNER JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.gpt > 60 ORDER BY patient.birthday ASC; 
SELECT  AVG(ldh) AS average_ldh_index FROM laboratory WHERE ldh < 500; 
SELECT  patient.id, (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) AS age FROM patient INNER JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.ldh BETWEEN 600 AND 800; 
SELECT  DISTINCT patient.id,        patient.admission FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.alp < 300; 
SELECT patient.id FROM patient WHERE birthday = '1982-04-01' AND       (SELECT alp FROM laboratory WHERE laboratory.id = patient.id) < 300; 
SELECT  patient.id, patient.sex, patient.birthday FROM patient INNER JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tp < 6.0; 
SELECT  patient.id, (laboratory.tp - 8.5) AS tp_deviation FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'F' AND laboratory.tp > 8.5; 
SELECT  * FROM patient WHERE sex = 'M' AND (alb <= 3.5 OR alb >= 5.5) ORDER BY birthday DESC; 
SELECT  patient.id,        patient.birthday,        CASE WHEN laboratory.alb BETWEEN 3.5 AND 5.5 THEN 'Yes' ELSE 'No' END AS albumin_within_normal_range FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE strftime('%Y', patient.birthday) = '1982'; 
SELECT  COUNT(DISTINCT p.id) * 100.0 / (SELECT COUNT(DISTINCT id) FROM patient WHERE sex = 'F') AS percentage_female_high_ua FROM patient p JOIN laboratory l ON p.id = l.id WHERE p.sex = 'F' AND ((p.sex = 'M' AND l.ua > 8.0) OR (p.sex = 'F' AND l.ua > 6.5)); 
SELECT  AVG(ua) AS average_ua_index FROM (     SELECT ua     FROM laboratory     JOIN (         SELECT id, MAX(date) AS latest_date         FROM laboratory         GROUP BY id     ) AS latest_laboratory     ON laboratory.id = latest_laboratory.id AND laboratory.date = latest_laboratory.latest_date     JOIN patient     ON laboratory.id = patient.id     WHERE (ua < 8.0 AND sex = 'M') OR (ua < 6.5 AND sex = 'F') ) AS normal_ua_patients; 
SELECT  patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.un = 29 
SELECT  patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.diagnosis = 'RA' AND laboratory.un < 30; 
SELECT  COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.cre >= 1.5;
SELECT      CASE         WHEN             (                 SELECT COUNT(*)                 FROM examination                 WHERE diagnosis = 'Normal'                 AND cre >= 1.5                 AND EXISTS (                     SELECT 1                     FROM patient                     WHERE examination.id = patient.id                     AND sex = 'M'                 )             )             >             (                 SELECT COUNT(*)                 FROM examination                 WHERE diagnosis = 'Normal'                 AND cre >= 1.5                 AND EXISTS (                     SELECT 1                     FROM patient                     WHERE examination.id = patient.id                     AND sex = 'F'                 )             )         THEN 'True'         ELSE 'False'     END AS result; 
SELECT  patient.id, patient.sex, patient.birthday FROM patient INNER JOIN laboratory ON patient.id = laboratory.id ORDER BY laboratory.t-bil DESC LIMIT 1; 
SELECT  p.sex, COUNT(*) AS total_patients FROM patient p JOIN laboratory l ON p.id = l.id WHERE l."t-bil" >= 2.0 GROUP BY p.sex; 
SELECT  patient.id, MAX(laboratory."t-cho") AS "T-CHO" FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.birthday = (SELECT MIN(birthday) FROM patient) 
SELECT  AVG(YEAR(NOW()) - YEAR(p.birthday)) AS average_age FROM patient p JOIN laboratory l ON p.id = l.id WHERE p.sex = 'M' AND l."t-cho" >= 250; 
SELECT  DISTINCT patient.id, patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tg > 300; 
SELECT  COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tg >= 200 AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) > 50;
SELECT  DISTINCT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.admission = '-' AND laboratory.cpk < 250; 
SELECT  COUNT(*) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE year(birthday) BETWEEN '1936' AND '1956' AND sex = 'M' AND cpk >= 250;
SELECT  patient.id, patient.sex, (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) AS age FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.glu >= 180 AND laboratory.t_cho < 250;
SELECT  patient.id, laboratory.glu  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE substr(patient.description, 1, 4) >= '1991'  AND laboratory.glu < 180; 
SELECT  patient.id, patient.sex, patient.birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.wbc <= 3.5 OR laboratory.wbc >= 9.0 ORDER BY patient.sex, strftime('%Y-%m-%d', patient.birthday); 
SELECT  patient.id, STRFTIME('%Y', 'now') - STRFTIME('%Y', patient.birthday) AS age FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.rbc < 3.5 
SELECT  p.id, p.admission FROM patient p JOIN examination e ON p.id = e.id JOIN laboratory l ON p.id = l.id WHERE p.sex = 'F' AND strftime('%Y', 'now') - strftime('%Y', p.birthday) >= 50 AND (l.rbc <= 3.5 OR l.rbc >= 6.0); 
SELECT  patient.id, patient.sex FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE patient.admission = '-' AND laboratory.hgb < 10; 
SELECT patient.id, patient.sex FROM patient JOIN examination ON patient.id = examination.id WHERE patient.diagnosis = 'SLE' AND hgb BETWEEN 10 AND 17 ORDER BY patient.birthday ASC LIMIT 1; 
SELECT  patient.id,         (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) AS age  FROM patient  JOIN laboratory ON patient.id = laboratory.id  GROUP BY patient.id  HAVING COUNT(laboratory.id) > 2  AND SUM(CASE WHEN laboratory.hct >= 52 THEN 1 ELSE 0 END) >= 2; 
SELECT  AVG(hct) AS average_hematocrit FROM laboratory WHERE date LIKE '1991%' AND hct < 29; 
SELECT  COUNT(CASE WHEN plt < 100 THEN 1 END) AS lower_than_normal, COUNT(CASE WHEN plt > 400 THEN 1 END) AS higher_than_normal FROM examination INNER JOIN laboratory ON examination.id = laboratory.id WHERE plt < 100 OR plt > 400;
SELECT  * FROM patient WHERE SUBTRACT(year(current_timestamp), year(birthday)) < 50 AND id IN (     SELECT id     FROM laboratory     WHERE date LIKE '1984%'     AND plt BETWEEN 100 AND 400 ); 
SELECT  (COUNT(CASE WHEN Sex = 'F' AND (pt >= 14) THEN 1 END) * 1.0 / COUNT(CASE WHEN age > 55 THEN 1 END)) * 100 AS percentage FROM patient WHERE age > 55; 
SELECT  patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.first_date > '1992-01-01' AND laboratory.pt < 14; 
SELECT  COUNT(*) FROM examination WHERE examination_date > '1997-01-01' AND aptt >= 45;
SELECT  COUNT(DISTINCT examination.id) FROM examination JOIN laboratory ON examination.id = laboratory.id WHERE examination.thrombosis = 3 AND laboratory.aptt > 45;
SELECT  COUNT(DISTINCT patient.id) FROM patient JOIN examination ON patient.id = examination.id JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.fg < 150 OR laboratory.fg > 450 AND laboratory.wbc BETWEEN 3.5 AND 9.0;
SELECT  COUNT(DISTINCT patient.id) FROM patient JOIN examination ON patient.id = examination.id JOIN laboratory ON patient.id = laboratory.id WHERE patient.birthday > '1980-01-01' AND laboratory.fg NOT BETWEEN 150 AND 450;
SELECT  diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE u_pro >= 30;
SELECT  patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.diagnosis = 'SLE' AND laboratory.u_pro > 0 AND laboratory.u_pro < 30;
SELECT  COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id WHERE examination.acl_igg < 900 AND examination.symptoms = 'abortion'; 
SELECT  COUNT(DISTINCT examination.id) FROM examination JOIN laboratory ON examination.id = laboratory.id WHERE laboratory.igg BETWEEN 900 AND 2000 AND examination.symptoms IS NOT NULL;
SELECT  patient.diagnosis FROM patient INNER JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.iga > 80 AND laboratory.iga < 500 ORDER BY laboratory.iga DESC LIMIT 1; 
SELECT  COUNT(patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE igA BETWEEN 80 AND 500 AND YEAR(patient."First Date") >= 1990;
SELECT  diagnosis FROM patient WHERE id IN (     SELECT id     FROM laboratory     WHERE igm NOT BETWEEN 40 AND 400 ) GROUP BY diagnosis ORDER BY COUNT(*) DESC LIMIT 1; 
SELECT  COUNT(DISTINCT patient.id) FROM patient LEFT JOIN examination ON examination.id = patient.id LEFT JOIN laboratory ON laboratory.id = patient.id WHERE (crp LIKE '+' OR crp LIKE '-' OR crp < 1.0 OR crp IS NULL) AND description IS NULL;
SELECT  COUNT(DISTINCT patient.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE crp NOT IN ('+-', '-') AND crp >= 1.0 AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) < 18;
SELECT  COUNT(DISTINCT patient.id) FROM patient JOIN examination ON patient.id = examination.id WHERE examination.kct = '+' AND laboratory.rf = '-'
SELECT  DISTINCT patient.id, patient.diagnosis FROM patient JOIN examination ON patient.id = examination.id WHERE DATE(patient.birthday) >= '1995-01-01' AND patient.rf = '-' 
SELECT  patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE rf < 20 AND (strftime('%Y', 'now') - strftime('%Y', patient.birthday)) > 60; 
SELECT  COUNT(DISTINCT patient.id) FROM patient LEFT JOIN examination ON patient.id = examination.id WHERE patient.id NOT IN (     SELECT DISTINCT patient.id     FROM patient     LEFT JOIN examination ON patient.id = examination.id     WHERE rf < 20 AND thrombosis = '0' ) AND rf < 20; 
SELECT  COUNT(DISTINCT patient.id) AS "Patients with Normal C3 and ANA Pattern P" FROM patient JOIN examination ON examination.id = patient.id WHERE examination.ana_pattern = 'P' AND laboratory.c3 > 35; 
SELECT  MAX(examination."acl iga") AS max_acl_iga FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE laboratory.hct NOT BETWEEN 29 AND 52;
SELECT  COUNT(DISTINCT patient.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE thrombosis > 0 AND c4 > 10;
SELECT  COUNT(DISTINCT examination.id) AS num_patients FROM examination INNER JOIN patient ON examination.id = patient.id WHERE patient.admission = '+(' AND (patient.rnp = 'negative' OR patient.rnp = '+-'); 
SELECT  p.birthday FROM patient p JOIN laboratory l ON p.id = l.id WHERE l.rnp NOT IN ('-', '+-') ORDER BY p.birthday DESC LIMIT 1; 
SELECT  COUNT(*)  FROM examination  JOIN laboratory ON examination.id = laboratory.id  JOIN patient ON examination.id = patient.id  WHERE sm = 'negative' AND thrombosis = '1';
SELECT  patient.id FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE examination.sm NOT IN ('-', '+-') ORDER BY patient.birthday DESC LIMIT 3; 
SELECT  patient.id FROM examination JOIN patient ON examination.id = patient.id WHERE examination_date >= '1997-01-01' AND sc170 = 'negative'; 
SELECT  COUNT(DISTINCT patient.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND examination.symptoms = 'vertigo' AND laboratory.sc170 IN ('-', '+-');
SELECT  COUNT(DISTINCT patient.id)  FROM examination  JOIN patient ON examination.id = patient.id  WHERE examination.examination_date < '1990-01-01'  AND patient.id NOT IN (     SELECT id FROM laboratory WHERE ssa IN ('-', '+-') ); 
SELECT  patient.id FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE ssa NOT IN ('-', '+-') ORDER BY patient.first_date LIMIT 1; 
SELECT  COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id WHERE examination.diagnosis = 'SLE' AND laboratory.ssb IN ('negative', '0') 
SELECT  COUNT(DISTINCT patient.id)  FROM patient  JOIN examination ON patient.id = examination.id  WHERE ssb = 'negative' AND symptoms IS NOT NULL; 
SELECT  COUNT(DISTINCT patient.id) FROM patient JOIN examination ON patient.id = examination.id JOIN laboratory ON patient.id = laboratory.id WHERE centromea IN ('-', '+-') AND ssb IN ('-', '+-') AND sex = 'M';
SELECT  DISTINCT patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.dna >= 8; 
SELECT  COUNT(DISTINCT patient.id) FROM patient LEFT JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.dna < 8 AND patient.description IS NULL;
SELECT  COUNT(patient.id)  FROM examination  JOIN patient ON examination.id = patient.id  JOIN laboratory ON laboratory.id = patient.id  WHERE laboratory.dna_ii >= 8 AND patient.admission = '+' 
SELECT       (CAST((SELECT COUNT(patient.id)             FROM examination             JOIN patient ON examination.id = patient.id             JOIN laboratory ON examination.id = laboratory.id             WHERE laboratory.got >= 60 AND patient.diagnosis = 'SLE') AS FLOAT) /      CAST((SELECT COUNT(patient.id)             FROM examination             JOIN patient ON examination.id = patient.id             JOIN laboratory ON examination.id = laboratory.id             WHERE laboratory.got >= 60) AS FLOAT)) * 100.0 AS percentage; 
SELECT  COUNT(DISTINCT patient.id)  FROM patient  JOIN laboratory ON patient.id = laboratory.id  WHERE patient.sex = 'M' AND laboratory.got < 60;
SELECT MIN(patient.birthday) AS youngest_birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.got >= 60; 
SELECT  patient.birthday FROM patient INNER JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.gpt < 60 ORDER BY laboratory.gpt DESC LIMIT 3; 
SELECT  COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.got < 60 AND patient.sex = 'M';
SELECT  MIN(patient.first_date) AS first_recorded_date FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.ldh < 500 ORDER BY laboratory.ldh DESC LIMIT 1;
SELECT  MAX(patient.first_date) AS latest_medical_data_recorded FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.ldh >= 500; 
SELECT  COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE alp >= 300 AND admission = '+';
SELECT  COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.admission = '-' AND laboratory.alp < 300;
SELECT  patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tp < 6.0; 
SELECT  COUNT(*) AS "Patients with SJS and Normal Total Protein" FROM patient JOIN examination ON patient.id = examination.id JOIN laboratory ON patient.id = laboratory.id WHERE patient.diagnosis = 'SJS' AND laboratory.tp > 6.0 AND laboratory.tp < 8.5; 
SELECT  examination.date FROM examination JOIN laboratory ON examination.id = laboratory.id WHERE alb > 3.5 AND alb < 5.5 ORDER BY alb DESC LIMIT 1;
SELECT  COUNT(DISTINCT patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.alb > 3.5 AND laboratory.alb < 5.5 AND laboratory.tp BETWEEN 6.0 AND 8.5;
SELECT  MAX(acl_igg) AS highest_acl_igg, MAX(acl_igm) AS highest_acl_igm, MAX(acl_iga) AS highest_acl_iga FROM examination JOIN patient ON examination.id = patient.id WHERE patient.sex = 'F' AND ua <= 6.50;
SELECT  MAX(ana) AS highest_anti_nucleus_antibody_concentration FROM examination JOIN patient ON examination.id = patient.id WHERE cre < 1.5;
SELECT  patient.id FROM patient JOIN examination ON examination.id = patient.id JOIN laboratory ON laboratory.id = patient.id WHERE laboratory.cre < 1.5 ORDER BY examination.acl_iga DESC LIMIT 1; 
SELECT  COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE t_bil >= 2.0 AND ana_pattern LIKE '%P%';
SELECT ana FROM examination WHERE id IN (     SELECT id     FROM laboratory     WHERE t-bil = (         SELECT MAX(t-bil)         FROM laboratory         WHERE t-bil < 2.0     ) ); 
SELECT  COUNT(*) FROM examination JOIN laboratory ON examination.id = laboratory.id JOIN patient ON examination.id = patient.id WHERE laboratory.t_cho >= 250 AND examination.kct = '-';
SELECT  COUNT(DISTINCT examination.id) FROM examination JOIN laboratory ON examination.id = laboratory.id WHERE t_cho < 250 AND ana_pattern = 'P';
SELECT  COUNT(DISTINCT examination.id) FROM examination JOIN laboratory ON examination.id = laboratory.id WHERE laboratory.tg < 200 AND examination.symptoms IS NOT NULL;
SELECT  patient.diagnosis FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.tg < 200 ORDER BY laboratory.tg DESC LIMIT 1; 
SELECT  patient.id  FROM patient  LEFT JOIN examination ON examination.id = patient.id  LEFT JOIN laboratory ON laboratory.id = patient.id  WHERE examination.thrombosis = 0  AND laboratory.cpk < 250; 
SELECT  COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.cpk < 250 AND (examination.kct = '+' OR examination.rvvt = '+' OR examination.lac = '+');
SELECT  MIN(patient.birthday) AS oldest_birthday FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE laboratory.glu > 180; 
SELECT  COUNT(DISTINCT patient.id) FROM patient INNER JOIN laboratory ON patient.id = laboratory.id INNER JOIN examination ON patient.id = examination.id WHERE laboratory.glu < 180 AND examination.thrombosis = 0;
SELECT  COUNT(patient.id) FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE patient.admission = '+' AND laboratory.wbc BETWEEN 3.5 AND 9.0;
SELECT  COUNT(DISTINCT patient.id) AS "Patients with SLE and Normal WBC" FROM patient JOIN examination ON patient.id = examination.id JOIN laboratory ON patient.id = laboratory.id WHERE patient.diagnosis = 'SLE' AND laboratory.wbc BETWEEN 3.5 AND 9.0;
SELECT  DISTINCT patient.id FROM patient JOIN laboratory ON patient.id = laboratory.id WHERE (laboratory.rbc < 3.5 OR laboratory.rbc >= 6.0) AND patient.admission = '-'; 
SELECT  COUNT(DISTINCT examination.id) FROM examination JOIN patient ON examination.id = patient.id WHERE plt > 100 AND plt < 400 AND diagnosis IS NOT NULL;
SELECT  laboratory.plt FROM laboratory JOIN patient ON laboratory.id = patient.id JOIN examination ON patient.id = examination.id WHERE laboratory.plt > 100 AND laboratory.plt < 400 AND patient.diagnosis = 'MCTD'; 
SELECT  AVG(pt) AS average_prothrombin_time FROM examination JOIN patient ON examination.id = patient.id JOIN laboratory ON patient.id = laboratory.id WHERE patient.sex = 'M' AND laboratory.pt < 14; 
SELECT  COUNT(DISTINCT patient.id) FROM examination JOIN patient ON examination.id = patient.id WHERE thrombosis IN (1, 2) AND pt < 14;
SELECT  major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Angela' AND member.last_name = 'Sanders';
SELECT  COUNT(DISTINCT member.member_id) AS student_count FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.college = 'College of Engineering'; 
SELECT  DISTINCT first_name || ' ' || last_name AS full_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.department = 'Art and Design Department'; 
SELECT  COUNT(DISTINCT member.member_id) FROM attendance JOIN event ON attendance.link_to_event = event.event_id JOIN member ON attendance.link_to_member = member.member_id WHERE event.event_name = 'Women\'s Soccer';
SELECT  member.phone FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'Women\'s Soccer'; 
SELECT  COUNT(DISTINCT member.member_id) FROM attendance JOIN event ON attendance.link_to_event = event.event_id JOIN member ON attendance.link_to_member = member.member_id JOIN major ON member.link_to_major = major.major_id WHERE event.event_name = 'Women\'s Soccer' AND major.department = 'Student_Club' AND member.t_shirt_size = 'Medium';
SELECT  event.event_name FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id WHERE member.position = 'Student_Club' GROUP BY event.event_id ORDER BY COUNT(attendance.link_to_event) DESC LIMIT 1;
SELECT  major.college FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'Vice President'; 
SELECT  event.event_name FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id WHERE member.first_name = 'Maya' AND member.last_name = 'Mclean'; 
SELECT  COUNT(DISTINCT event.event_id) FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id WHERE member.first_name = 'Sacha' AND member.last_name = 'Harrison' AND strftime('%Y', event.event_date) = '2019';
SELECT  COUNT(*)  FROM event  WHERE event_id IN (     SELECT link_to_event      FROM attendance      GROUP BY link_to_event      HAVING COUNT(link_to_member) > 10 ) AND type = 'Meeting'; 
SELECT  event.event_name FROM event JOIN attendance ON event.event_id = attendance.link_to_event GROUP BY event.event_name HAVING COUNT(attendance.link_to_member) > 20;
SELECT AVG(attendance) AS average_attendance FROM event WHERE type = 'Meeting' AND strftime('%Y', event_date) = '2020'; 
SELECT  MAX(cost) AS most_expensive_item_spent FROM expense WHERE link_to_budget IN (     SELECT budget_id     FROM budget     WHERE event_status = 'Open' )
SELECT  COUNT(member.member_id) AS environmental_engineering_major_count FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Environmental Engineering';
SELECT  member.first_name || ' ' || member.last_name AS full_name FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'Laugh Out Loud'; 
SELECT  last_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE major_name = 'Law and Constitutional Studies'; 
SELECT  zip_code.county FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Sherri' AND member.last_name = 'Ramsey'; 
SELECT  DISTINCT major.college FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Tyler' AND member.last_name = 'Hewitt'; 
SELECT  SUM(income.amount) AS funds_received FROM income JOIN member ON income.link_to_member = member.member_id WHERE member.position = 'Vice President';
SELECT  SUM(expense.cost) AS total_spent_on_food FROM expense JOIN member ON expense.link_to_member = member.member_id JOIN budget ON expense.link_to_budget = budget.budget_id JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'September Meeting' AND budget.category = 'Food'; 
SELECT  zip_code.city, zip_code.state FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.position = 'President'; 
SELECT  first_name || ' ' || last_name AS full_name FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE zip_code.state = 'Illinois'; 
SELECT  SUM(expense.cost) AS total_advertisement_spending FROM expense JOIN budget ON expense.link_to_budget = budget.budget_id JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'September Meeting' AND budget.category = 'Advertisement';
SELECT  department FROM major JOIN member ON member.link_to_major = major.major_id WHERE member.last_name = 'Pierce' AND member.first_name = 'Guidi'; 
SELECT  SUM(amount) AS total_budgeted_amount FROM budget WHERE link_to_event = (SELECT event_id FROM event WHERE event_name = 'October Speaker'); 
SELECT  expense_id, expense_description, expense_date, approved FROM expense JOIN budget ON expense.link_to_budget = budget.budget_id JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'October Meeting' AND event.event_date = '2019-10-08' 
SELECT  AVG(expense.cost) AS average_cost FROM expense JOIN member ON expense.link_to_member = member.member_id JOIN event ON expense.link_to_event = event.event_id WHERE member.first_name = 'Elijah'    AND member.last_name = 'Allen'    AND (strftime('%m', expense.expense_date) = '09' OR strftime('%m', expense.expense_date) = '10'); 
SELECT  SUM(CASE WHEN strftime('%Y', event.event_date) = '2019' THEN budget.spent ELSE 0 END) - SUM(CASE WHEN strftime('%Y', event.event_date) = '2020' THEN budget.spent ELSE 0 END) FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.event_date BETWEEN '2019-01-01' AND '2019-12-31' OR event.event_date BETWEEN '2020-01-01' AND '2020-12-31';
SELECT  location FROM event WHERE event_name = 'Spring Budget Review';
SELECT  expense.cost  FROM expense  JOIN budget ON expense.link_to_budget = budget.budget_id  JOIN event ON budget.link_to_event = event.event_id  WHERE expense.expense_description = 'Posters'  AND event.event_date = '2019-09-04'; 
SELECT  MAX(b.remaining) FROM budget b WHERE b.category = 'Food'
SELECT  notes  FROM income  WHERE source = 'Fundraising' AND date_received = '2019-09-14'; 
SELECT  COUNT(*)  FROM major  WHERE college = 'College of Humanities and Social Sciences'; 
SELECT  phone FROM member WHERE first_name = 'Carlo' AND last_name = 'Jacobs'; 
SELECT  county FROM zip_code JOIN member ON member.zip = zip_code.zip_code WHERE member.first_name = 'Adela' AND member.last_name = 'O\'Gallagher';
SELECT  COUNT(*)  FROM budget  JOIN event ON budget.link_to_event = event.event_id  WHERE event.event_name = 'November Meeting'  AND budget.remaining < 0; 
SELECT  SUM(amount) AS total_budget_amount FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'September Speaker'; 
SELECT  event.status FROM event JOIN budget ON event.event_id = budget.link_to_event JOIN expense ON budget.budget_id = expense.link_to_budget WHERE expense.expense_description = 'Post Cards, Posters' AND expense.expense_date = '2019-08-20'; 
SELECT  major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Brent' AND member.last_name = 'Thomason'; 
SELECT  COUNT(*) FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Human Development and Family Studies' AND member.t_shirt_size = 'Large';
SELECT  zip_code.type FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Christof' AND member.last_name = 'Nielson'; 
SELECT  major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'Vice President'; 
SELECT  zip_code.state FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Sacha' AND member.last_name = 'Harrison';
SELECT  major.department FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'President' 
SELECT  income.date_received FROM income JOIN member ON income.link_to_member = member.member_id WHERE member.first_name = 'Connor' AND member.last_name = 'Hilton' AND income.source = 'Dues'; 
SELECT  first_name, last_name FROM member INNER JOIN income ON member.member_id = income.link_to_member WHERE source = 'Dues' ORDER BY date_received LIMIT 1; 
SELECT  COUNT(*) AS budget_difference FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'Yearly Kickoff' AND budget.category = 'Advertisement' HAVING (     SUM(budget.amount) /     (         SELECT SUM(b.amount)         FROM budget AS b         JOIN event AS e ON b.link_to_event = e.event_id         WHERE e.event_name = 'October Meeting' AND b.category = 'Advertisement'     ) ) > 1;
SELECT  ((SELECT SUM(amount) FROM budget WHERE category = 'Parking' AND link_to_event = (SELECT event_id FROM event WHERE event_name = 'November Speaker')) / (SELECT SUM(amount) FROM budget WHERE link_to_event = (SELECT event_id FROM event WHERE event_name = 'November Speaker'))) * 100;
SELECT  SUM(cost) AS total_pizza_cost FROM expense WHERE expense_description = 'Pizza'; 
SELECT  COUNT(DISTINCT zip_code.city) FROM zip_code WHERE zip_code.county = 'Orange County' AND zip_code.state = 'Virginia';
SELECT  department FROM major WHERE college = 'College of Humanities and Social Sciences'; 
SELECT  zip_code.city, zip_code.county, zip_code.state FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Amy' AND member.last_name = 'Firth'; 
SELECT  expense.expense_description FROM expense JOIN budget ON expense.link_to_budget = budget.budget_id WHERE budget.remaining = (     SELECT MIN(remaining)     FROM budget ) 
SELECT  member.first_name, member.last_name FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'October Meeting'; 
SELECT  major.college FROM member JOIN major ON member.link_to_major = major.major_id GROUP BY major.college ORDER BY COUNT(*) DESC LIMIT 1; 
SELECT  major.major_name FROM member JOIN zip_code ON member.zip = zip_code.zip_code JOIN major ON member.link_to_major = major.major_id WHERE member.phone = '809-555-3360';
SELECT  event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event ORDER BY budget.amount DESC LIMIT 1; 
SELECT  expense.expense_description FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.position = 'Vice President';
SELECT  COUNT(DISTINCT member.member_id) FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id WHERE event.event_name = 'Women\'s Soccer'; 
SELECT  income.date_received FROM income JOIN member ON income.link_to_member = member.member_id WHERE member.first_name = 'Casey' AND member.last_name = 'Mason'; 
SELECT  COUNT(DISTINCT member.member_id) AS maryland_hometowns FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE zip_code.state = 'Maryland'; 
SELECT  COUNT(*)  FROM attendance  WHERE link_to_member = (     SELECT member_id      FROM member      WHERE phone = '954-555-6240' ); 
SELECT  first_name, last_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.department = 'School of Applied Sciences, Technology and Education'; 
SELECT  event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE event.status = 'Closed' ORDER BY (budget.spent / budget.amount) DESC LIMIT 1;
SELECT  COUNT(*) AS president_count FROM member WHERE position = 'President'; 
SELECT  MAX(spent) AS highest_budget_spend FROM budget;
SELECT  COUNT(*)  FROM event  WHERE type = 'Meeting' AND strftime('%Y', event_date) = '2020'; 
SELECT  SUM(spent) AS total_spent_on_food FROM budget WHERE category = 'Food'; 
SELECT  member.first_name || ' ' || member.last_name AS full_name FROM member JOIN attendance ON member.member_id = attendance.link_to_member GROUP BY member.member_id HAVING COUNT(attendance.link_to_event) > 7; 
SELECT  member.first_name, member.last_name FROM member JOIN major ON member.link_to_major = major.major_id JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id WHERE major.major_name = 'Interior Design' AND event.event_name = 'Community Theater'; 
SELECT  first_name, last_name FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE city = 'Georgetown' AND state = 'South Carolina'; 
SELECT  COUNT(*) AS income_generated FROM income JOIN member ON income.link_to_member = member.member_id WHERE member.first_name = 'Grant' AND member.last_name = 'Gilmour';
SELECT  member.first_name || ' ' || member.last_name AS student_name FROM income JOIN member ON income.link_to_member = member.member_id WHERE income.amount > 40;
SELECT  SUM(expense.cost) AS total_expense FROM expense JOIN event ON expense.link_to_budget = event.event_id WHERE event.event_name = 'Yearly Kickoff'; 
SELECT  member.first_name, member.last_name FROM member JOIN budget ON budget.link_to_event = (SELECT event_id FROM event WHERE event_name = 'Yearly Kickoff') WHERE member.position = 'Budget Manager'; 
SELECT  member.first_name || ' ' || member.last_name AS full_name, income.source FROM member JOIN income ON member.member_id = income.link_to_member WHERE income.amount = (SELECT MAX(amount) FROM income)
SELECT  event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event GROUP BY event.event_id ORDER BY SUM(budget.amount) ASC LIMIT 1; 
SELECT  (SELECT      (SELECT SUM(expense.cost) FROM expense JOIN budget ON expense.link_to_budget = budget.budget_id JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'Yearly Kickoff') /      (SELECT SUM(expense.cost) FROM expense JOIN budget ON expense.link_to_budget = budget.budget_id) * 100 ) as percentage_cost_yearly_kickoff;
SELECT  DIVIDE(     (SELECT COUNT(*) FROM member       WHERE link_to_major = (SELECT major_id FROM major WHERE major_name = 'Finance')),     (SELECT COUNT(*) FROM member       WHERE link_to_major = (SELECT major_id FROM major WHERE major_name = 'Physics')) ) AS ratio_students_finance_to_physics;
SELECT  MAX(source) AS top_source_of_funds FROM income WHERE date_received BETWEEN '2019-09-01' AND '2019-09-30' GROUP BY source ORDER BY amount DESC LIMIT 1;
SELECT  first_name || ' ' || last_name AS full_name, email FROM member WHERE position = 'Secretary'; 
SELECT  COUNT(*) AS Physics_Teaching_Major_Members FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Physics Teaching'; 
SELECT  COUNT(DISTINCT attendance.link_to_member) AS total_attendees FROM attendance JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'Community Theater' AND strftime('%Y', event.event_date) = '2019'; 
SELECT  COUNT(DISTINCT attendance.link_to_event) AS events_attended, major.major_name AS major FROM attendance JOIN member ON attendance.link_to_member = member.member_id JOIN event ON attendance.link_to_event = event.event_id JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Luisa' AND member.last_name = 'Guidi';
SELECT  AVG(expense.cost) FROM expense JOIN budget ON expense.link_to_budget = budget.budget_id JOIN event ON budget.link_to_event = event.event_id WHERE budget.category = 'Food' AND event.event_status = 'Closed';
SELECT  event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.category = 'Advertisement' ORDER BY budget.spent DESC LIMIT 1;
SELECT  COUNT(*)  FROM attendance  JOIN member ON attendance.link_to_member = member.member_id  JOIN event ON attendance.link_to_event = event.event_id  WHERE member.first_name = 'Maya'  AND member.last_name = 'Mclean'  AND event.event_name = 'Women\'s Soccer'; 
SELECT  (SELECT (COUNT(CASE WHEN event.type = 'Community Service' THEN 1 END) * 100.0 / COUNT(event.event_id)) AS percentage_share  FROM event  WHERE event.event_date BETWEEN '2019-01-01' AND '2019-12-31') AS percentage_share_of_community_service_events 
SELECT  expense.cost FROM expense JOIN event ON expense.link_to_event = event.event_id WHERE event.event_name = 'September Speaker' AND expense.expense_description = 'Posters'; 
SELECT  t_shirt_size FROM member GROUP BY t_shirt_size ORDER BY COUNT(*) DESC LIMIT 1; 
SELECT event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE event.status = 'Closed' AND budget.remaining < 0 ORDER BY budget.remaining LIMIT 1; 
SELECT  expense_description, SUM(cost) AS total_approved_value FROM expense JOIN budget ON expense.link_to_budget = budget.budget_id JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'October Meeting' AND expense.approved = 'true' GROUP BY expense_description; 
SELECT  category, amount FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'April Speaker' ORDER BY amount ASC; 
SELECT  MAX(amount) AS highest_budgeted_amount FROM budget WHERE category = 'Food'
SELECT  budget_id, amount  FROM budget  WHERE category = 'Advertisement'  ORDER BY amount DESC  LIMIT 3; 
SELECT  SUM(cost) AS total_cost_spent_for_parking FROM expense WHERE expense_description = 'Parking'; 
SELECT  SUM(cost) AS total_expense FROM expense WHERE expense_date = '2019-08-20'; 
SELECT  member.first_name || ' ' || member.last_name AS full_name, SUM(expense.cost) AS total_cost FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE member.member_id = 'rec4BLdZHS2Blfp4v'; 
SELECT  expense.expense_description FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.first_name = 'Sacha' AND member.last_name = 'Harrison';
SELECT  expense_description FROM expense JOIN member ON expense.link_to_member = member.member_id WHERE member.t_shirt_size = 'X-Large'; 
SELECT  zip_code FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE expense.cost < 50; 
SELECT  major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Phillip' AND member.last_name = 'Cullen'; 
SELECT  member.position FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Business'; 
SELECT  COUNT(member.member_id) FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Business' AND member.t_shirt_size = 'Medium'; 
SELECT  DISTINCT event.type FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.remaining > 30 
SELECT  DISTINCT event.type FROM event WHERE event.location = 'MU 215'; 
SELECT  event.type AS category FROM event WHERE event.event_date = '2020-03-24T12:00:00'; 
SELECT  major.major_name FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.position = 'Vice President'; 
SELECT  ROUND((COUNT(CASE WHEN member.position = 'Member' AND major.major_name = 'Mathematics' THEN 1 END) * 100.0) / COUNT(member.member_id), 2) AS percentage_mathematics_members FROM member JOIN major ON member.link_to_major = major.major_id;
SELECT  category FROM event WHERE location = 'MU 215';
SELECT  COUNT(*) FROM income WHERE amount = 50;
SELECT  COUNT(*) FROM member WHERE position = 'Member' AND t_shirt_size = 'X-Large';
SELECT  COUNT(*)  FROM major  WHERE college = 'College of Agriculture and Applied Sciences'  AND department = 'School of Applied Sciences, Technology and Education'; 
SELECT  member.last_name, major.department, major.college FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Environmental Engineering'; 
SELECT  budget.category FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE event.location = 'MU 215' AND event.type = 'Guest Speaker' AND budget.spent = 0;
SELECT zip_code.city, zip_code.state FROM member JOIN major ON member.link_to_major = major.major_id JOIN zip_code ON member.zip = zip_code.zip_code WHERE major.department = 'Electrical and Computer Engineering Department' AND member.position = 'Member'; 
SELECT  event.event_name FROM event JOIN attendance ON event.event_id = attendance.link_to_event JOIN member ON attendance.link_to_member = member.member_id WHERE event.type = 'Social'  AND member.position = 'Vice President' AND event.location = '900 E. Washington St.';
SELECT  member.last_name, member.position FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE expense.expense_description = 'Pizza' AND expense.expense_date = '2019-09-10'; 
SELECT  member.last_name FROM member JOIN attendance ON member.member_id = attendance.link_to_member JOIN event ON attendance.link_to_event = event.event_id WHERE event.event_name = 'Women''s Soccer' AND member.position = 'Member'; 
SELECT  (SELECT COUNT(income.amount) * 100 / COUNT(DISTINCT member.member_id) FROM income JOIN member ON income.link_to_member = member.member_id WHERE member.t_shirt_size = 'Medium' AND member.position = 'Member' AND income.amount = 50)
SELECT  DISTINCT state FROM zip_code WHERE type = 'PO Box'; 
SELECT  DISTINCT zip_code.zip_code FROM zip_code INNER JOIN member ON zip_code.zip_code = member.zip WHERE zip_code.type = 'PO Box' AND zip_code.county = 'San Juan Municipio' AND zip_code.state = 'Puerto Rico';
SELECT  event.event_name FROM event WHERE event.type = 'Game' AND event.status = 'Closed' AND event.event_date BETWEEN '2019-03-15' AND '2020-03-20';
SELECT  event.event_id, event.event_name FROM event INNER JOIN attendance ON event.event_id = attendance.link_to_event INNER JOIN member ON attendance.link_to_member = member.member_id INNER JOIN expense ON member.member_id = expense.link_to_member WHERE expense.cost > 50; 
SELECT  member.first_name, member.last_name, event.event_name, attendance.link_to_event FROM member JOIN attendance ON attendance.link_to_member = member.member_id JOIN event ON attendance.link_to_event = event.event_id JOIN expense ON expense.link_to_member = member.member_id WHERE expense.approved = 'true' AND expense.expense_date BETWEEN '2019-01-10' AND '2019-11-19'; 
SELECT  major.college FROM member JOIN major ON member.link_to_major = major.major_id WHERE member.first_name = 'Katy' AND member.link_to_major = 'rec1N0upiVLy5esTO'; 
SELECT  phone FROM member JOIN major ON member.link_to_major = major.major_id JOIN zip_code ON member.zip = zip_code.zip_code WHERE major.major_name = 'Business' AND zip_code.college = 'College of Agriculture and Applied Sciences';
SELECT  email FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE expense_date BETWEEN '2019-09-10' AND '2019-11-19' AND cost > 20; 
SELECT  COUNT(member.member_id) FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Education' AND major.college = 'College of Education & Human Services';
SELECT  ROUND((CAST(SUM(CASE WHEN budget.remaining < 0 THEN 1 ELSE 0 END) AS FLOAT) / COUNT(DISTINCT event.event_id)) * 100, 2) AS percentage_of_events_over_budget FROM event LEFT JOIN budget ON event.event_id = budget.link_to_event;
SELECT  event.event_id, event.location, event.status FROM event WHERE event.event_date BETWEEN '2019-11-01' AND '2020-03-31';
SELECT  expense_description FROM expense GROUP BY expense_description HAVING AVG(cost) > 50; 
SELECT  first_name || ' ' || last_name AS full_name FROM member WHERE t_shirt_size = 'X-Large'; 
SELECT  (COUNT(CASE WHEN type = 'PO Box' THEN 1 END) * 100.0) / COUNT(zip_code) AS percentage_of_po_boxes FROM zip_code; 
SELECT  event_name, location FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.remaining > 0; 
SELECT  event.event_name, event.event_date FROM event JOIN expense ON event.event_id = expense.link_to_budget WHERE expense.expense_description = 'Pizza' AND expense.cost > 50 AND expense.cost < 100;
SELECT  member.first_name, member.last_name, major.major_name FROM member JOIN major ON member.link_to_major = major.major_id JOIN expense ON member.member_id = expense.link_to_member WHERE expense.cost > 100; 
SELECT event.location FROM event JOIN income ON event.event_id = income.link_to_event GROUP BY event.event_id HAVING COUNT(income.income_id) > 40; 
SELECT  MAX(cost) AS max_amount_paid FROM (     SELECT link_to_member, SUM(cost) AS total_cost     FROM expense     GROUP BY link_to_member     HAVING COUNT(DISTINCT link_to_event) > 1 ) AS expenses_total;
SELECT  ROUND(     SUM(e.cost) / COUNT(DISTINCT e.link_to_event),     2 ) AS average_amount_paid FROM expense AS e JOIN member AS m ON e.link_to_member = m.member_id WHERE m.position != 'Member';
SELECT  event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event JOIN expense ON budget.budget_id = expense.link_to_budget WHERE budget.category = 'Parking' GROUP BY event.event_name HAVING expense.cost < (SELECT SUM(expense.cost) / COUNT(DISTINCT event.event_id) FROM expense WHERE budget.category = 'Parking');
SELECT  (SUM(expense.cost) / COUNT(DISTINCT event.event_id)) * 100 AS percentage_of_cost_for_game_events FROM event LEFT JOIN expense ON event.event_id = expense.link_to_budget WHERE event.type = 'Game'; 
SELECT  budget.budget_id FROM budget JOIN expense ON budget.budget_id = expense.link_to_budget WHERE expense.expense_description = 'Water, chips, cookies' ORDER BY expense.cost DESC LIMIT 1;
SELECT  member.first_name || ' ' || member.last_name AS full_name FROM member JOIN expense ON member.member_id = expense.link_to_member GROUP BY member.first_name, member.last_name ORDER BY MAX(expense.cost) DESC LIMIT 5;
SELECT  m.first_name || ' ' || m.last_name AS full_name, m.phone AS contact_number FROM member m JOIN expense e ON m.member_id = e.link_to_member WHERE e.cost > (SELECT AVG(cost) FROM expense); 
SELECT  ( ( SELECT ( (          ( SELECT COUNT(*) FROM member WHERE zip IN (SELECT zip_code FROM zip_code WHERE state = 'Maine') AND position = 'Member' ) * 1.0 /          ( SELECT COUNT(*) FROM member WHERE position = 'Member' )     ) -      (          ( SELECT COUNT(*) FROM member WHERE zip IN (SELECT zip_code FROM zip_code WHERE state = 'Vermont') AND position = 'Member' ) * 1.0 /          ( SELECT COUNT(*) FROM member WHERE position = 'Member' )     ) ) * 100 ) ) AS percentage_difference;
SELECT  major_name, department FROM member JOIN major ON member.link_to_major = major.major_id WHERE first_name = 'Garrett' AND last_name = 'Gerke'; 
SELECT  member.first_name || ' ' || member.last_name AS full_name, expense.cost FROM member JOIN expense ON member.member_id = expense.link_to_member WHERE expense.expense_description = 'Water, Veggie tray, supplies'; 
SELECT  member.last_name, member.phone FROM member JOIN major ON member.link_to_major = major.major_id WHERE major.major_name = 'Elementary Education'; 
SELECT  budget.category, budget.amount FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE event.event_name = 'January Speaker'; 
SELECT  event.event_name FROM event JOIN budget ON event.event_id = budget.link_to_event WHERE budget.category = 'Food'; 
SELECT  member.first_name || ' ' || member.last_name AS full_name, income.amount AS amount_received FROM member JOIN income ON member.member_id = income.link_to_member WHERE income.date_received = '2019-09-09';
SELECT  budget.category FROM expense JOIN budget ON expense.link_to_budget = budget.budget_id WHERE expense.expense_description = 'Posters';
SELECT  first_name || ' ' || last_name AS full_name, college FROM member JOIN major ON member.link_to_major = major.major_id WHERE position = 'Secretary'; 
SELECT  event.event_name, SUM(budget.spent) AS total_spent FROM budget JOIN event ON budget.link_to_event = event.event_id WHERE budget.category = 'Speaker Gifts' GROUP BY event.event_name; 
SELECT  zip_code.city FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE member.first_name = 'Garrett' AND member.last_name = 'Girke';
SELECT  member.first_name, member.last_name, member.position FROM member JOIN zip_code ON member.zip = zip_code.zip_code WHERE zip_code.city = 'Lincolnton' AND zip_code.state = 'North Carolina' AND zip_code.zip_code = '28092';
SELECT  COUNT(*)  FROM gasstations  WHERE country = 'CZE' AND segment = 'Premium'; 
SELECT  COUNT(CASE WHEN currency = 'EUR' THEN customerid END) * 1.0 / COUNT(CASE WHEN currency = 'CZK' THEN customerid END) AS ratio_of_customers_currency
SELECT  customers.customerid, MIN(yearmonth.consumption) AS min_consumption FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE segment = 'LAM' AND date BETWEEN '201201' AND '201212' GROUP BY customers.customerid ORDER BY min_consumption LIMIT 1; 
SELECT  AVG(consumption) / 12 AS average_monthly_consumption FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE customers.segment = 'SME' AND yearmonth.date BETWEEN '201301' AND '201312'; 
SELECT  customers.customerid FROM customers JOIN transactions_1k ON customers.customerid = transactions_1k.customerid JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid JOIN products ON transactions_1k.productid = products.productid JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE yearmonth.date BETWEEN 201101 AND 201112 AND customers.currency = 'CZK' GROUP BY customers.customerid ORDER BY SUM(transactions_1k.amount) DESC; 
SELECT  COUNT(DISTINCT c.customerid) FROM customers c JOIN yearmonth y ON c.customerid = y.customerid WHERE c.segment = 'KAM' AND y.date BETWEEN '201201' AND '201212' AND y.consumption < 30000; 
SELECT      SUM(CASE WHEN c.currency = 'CZK' THEN y.consumption ELSE 0 END) -     SUM(CASE WHEN c.currency = 'EUR' THEN y.consumption ELSE 0 END) AS difference_in_consumption FROM     yearmonth y JOIN     customers c ON y.customerid = c.customerid WHERE     y.date BETWEEN '201201' AND '201212'; 
SELECT  strftime('%Y', date) AS year, SUM(amount * price) AS total_paid FROM transactions_1k JOIN customers ON transactions_1k.customerid = customers.customerid JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE currency = 'EUR' GROUP BY year ORDER BY total_paid DESC LIMIT 1; 
SELECT  segment FROM gasstations GROUP BY segment ORDER BY SUM(consumption) ASC LIMIT 1; 
SELECT  substr(date, 1, 4) AS year, sum(consumption) AS total_consumption FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid JOIN transactions_1k ON yearmonth.customerid = transactions_1k.customerid JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE customers.currency = 'CZK' GROUP BY year ORDER BY total_consumption DESC LIMIT 1; 
SELECT  MAX(strftime('%m', date)) AS peak_month FROM yearmonth WHERE strftime('%Y', date) = '2013' AND customerid IN (SELECT customerid FROM customers WHERE segment = 'SME') GROUP BY customerid;
SELECT  AVG(CASE         WHEN segment = 'SME' THEN consumption         ELSE 0     END) -     AVG(CASE         WHEN segment = 'LAM' THEN consumption         ELSE 0     END) AS SME_LAM_diff,          AVG(CASE         WHEN segment = 'LAM' THEN consumption         ELSE 0     END) -     AVG(CASE         WHEN segment = 'KAM' THEN consumption         ELSE 0     END) AS LAM_KAM_diff,          AVG(CASE         WHEN segment = 'KAM' THEN consumption         ELSE 0     END) -     AVG(CASE         WHEN segment = 'SME' THEN consumption         ELSE 0     END) AS KAM_SME_diff      FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE substr(yearmonth.date, 1, 4) = '2013'
SELECT  WITH total_consumption AS (     SELECT         ym.customerid,         c.segment,         SUM(CASE WHEN ym.date LIKE '2012%' THEN ym.consumption ELSE 0 END) AS consumption_2012,         SUM(CASE WHEN ym.date LIKE '2013%' THEN ym.consumption ELSE 0 END) AS consumption_2013     FROM         yearmonth AS ym     JOIN         customers AS c ON ym.customerid = c.customerid     WHERE         c.currency = 'EUR'     GROUP BY         ym.customerid, c.segment ) SELECT     segment,     ((SUM(consumption_2013) - SUM(consumption_2012)) / NULLIF(SUM(consumption_2013), 0)) * 100 AS percentage_increase FROM     total_consumption GROUP BY     segment ORDER BY     percentage_increase DESC LIMIT 1  UNION ALL  SELECT     segment,     ((SUM(consumption_2013) - SUM(consumption_2012)) / NULLIF(SUM(consumption_2013), 0)) * 100 AS percentage_increase FROM     total_consumption GROUP BY     segment ORDER BY     percentage_increase ASC LIMIT 1; 
SELECT SUM(consumption) FROM yearmonth WHERE customerid = '6' AND date BETWEEN '201308' AND '201311'; 
SELECT  COUNT(*) FROM gasstations WHERE country = 'CZE' AND segment = 'Discount' - SELECT COUNT(*) FROM gasstations WHERE country = 'SVK' AND segment = 'Discount';
SELECT  SUM(y.consumption) AS consumption_difference FROM yearmonth y JOIN customers c ON y.customerid = c.customerid WHERE c.customerid IN (7, 5) AND y.date = '201304';
SELECT (SELECT COUNT(DISTINCT customerid) FROM customers WHERE segment = 'SME' AND currency = 'CZK') - (SELECT COUNT(DISTINCT customerid) FROM customers WHERE segment = 'SME' AND currency = 'EUR') AS "More SMEs paying in Czech Koruna than in Euro" 
SELECT  customers.customerid FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.segment = 'LAM' AND customers.currency = 'EUR' AND yearmonth.date = '201310' ORDER BY yearmonth.consumption DESC LIMIT 1; 
SELECT  customers.customerid, MAX(yearmonth.consumption) AS max_consumption FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.segment = 'KAM' GROUP BY customers.customerid ORDER BY max_consumption DESC LIMIT 1; 
SELECT  SUM(transactions_1k.amount) FROM transactions_1k JOIN customers ON transactions_1k.customerid = customers.customerid JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE yearmonth.date = '201305' AND customers.segment = 'KAM'; 
SELECT  ROUND((CAST((SELECT COUNT(*) FROM transactions_1k              JOIN customers ON transactions_1k.customerid = customers.customerid              WHERE segment = 'LAM' AND amount > 46.73) AS REAL) /        CAST((SELECT COUNT(*) FROM customers WHERE segment = 'LAM') AS REAL)) * 100, 2) AS percentage 
SELECT  gasstations.country, COUNT(*) AS total_value_for_money_gas_stations FROM gasstations WHERE gasstations.segment = 'Value for money' GROUP BY gasstations.country; 
SELECT       (CAST((SELECT COUNT(*) FROM customers WHERE segment = 'KAM' AND currency = 'EUR') AS REAL) / CAST((SELECT COUNT(*) FROM customers WHERE segment = 'KAM') AS REAL)) * 100 AS percentage_of_KAM_using_euro; 
SELECT  COUNT(DISTINCT yearmonth.customerid) * 100.0 / (SELECT COUNT(DISTINCT customerid) FROM yearmonth) AS percentage FROM yearmonth WHERE date = '201202' AND consumption > 528.3; 
SELECT ROUND((SELECT COUNT(*) FROM gasstations WHERE segment = 'Premium' AND country = 'SVK') * 100.0 / (SELECT COUNT(*) FROM gasstations WHERE country = 'SVK'), 2) AS percentage_premium_in_Slovakia; 
SELECT  customerid FROM yearmonth WHERE date = '201309' ORDER BY consumption DESC LIMIT 1; 
SELECT  c.segment FROM customers c JOIN yearmonth y ON c.customerid = y.customerid WHERE y.date = '201309' ORDER BY y.consumption LIMIT 1; 
SELECT  customers.customerid, MIN(yearmonth.consumption) AS min_consumption FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE customers.segment = 'SME' AND yearmonth.date = '201206' GROUP BY customers.customerid ORDER BY min_consumption LIMIT 1; 
SELECT  MAX(consumption) AS highest_monthly_consumption FROM yearmonth WHERE date LIKE '2012%'
SELECT  customerid, MAX(consumption) AS biggest_monthly_consumption FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE customers.currency = 'EUR' GROUP BY customerid; 
SELECT  products.description FROM transactions_1k JOIN products ON transactions_1k.productid = products.productid WHERE strftime('%Y-%m', transactions_1k.date) = '2013-09'
SELECT  DISTINCT gasstations.country FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE transactions_1k.date LIKE '201306%' 
SELECT  DISTINCT gasstations.chainid FROM gasstations JOIN transactions_1k ON gasstations.gasstationid = transactions_1k.gasstationid JOIN customers ON transactions_1k.customerid = customers.customerid WHERE customers.currency = 'EUR'; 
SELECT  p.description FROM transactions_1k AS t JOIN products AS p ON t.productid = p.productid JOIN customers AS c ON t.customerid = c.customerid WHERE c.currency = 'EUR'; 
SELECT AVG(total_price) FROM (     SELECT SUM(price) AS total_price     FROM transactions_1k     WHERE date LIKE '2012-01%'     GROUP BY transactionid ) 
SELECT  COUNT(DISTINCT yc.customerid) FROM yearmonth yc JOIN customers c ON yc.customerid = c.customerid WHERE c.currency = 'EUR' AND yc.consumption > 1000; 
SELECT  products.description FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid JOIN products ON transactions_1k.productid = products.productid WHERE gasstations.country = 'CZE';
SELECT  DISTINCT time FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE chainid = 11; 
SELECT  COUNT(*) FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE gasstations.country = 'CZE' AND transactions_1k.price > 1000;
SELECT  COUNT(*) FROM transactions_1k WHERE gasstationid IN (SELECT gasstationid FROM gasstations WHERE country = 'CZE') AND date > '2012-01-01';
SELECT  AVG(amount * price) AS average_total_price FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE gasstations.country = 'CZE'; 
SELECT  AVG(total_price) FROM (     SELECT SUM(price) AS total_price     FROM transactions_1k     JOIN customers ON transactions_1k.customerid = customers.customerid     WHERE customers.currency = 'EUR'     GROUP BY transactions_1k.customerid ); 
SELECT customers.customerid FROM transactions_1k JOIN customers ON transactions_1k.customerid = customers.customerid WHERE transactions_1k.date = '2012-08-25' ORDER BY transactions_1k.amount * transactions_1k.price DESC LIMIT 1; 
SELECT  gasstations.country FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE transactions_1k.date = '2012-08-25' ORDER BY transactions_1k.time LIMIT 1;
SELECT  currency FROM transactions_1k JOIN customers ON transactions_1k.customerid = customers.customerid WHERE transactions_1k.date = '2012-08-24' AND transactions_1k.time = '16:25:00';
SELECT  customers.segment FROM transactions_1k AS T1 JOIN customers ON T1.customerid = customers.customerid WHERE T1.date = '2012-08-23' AND T1.time = '21:20:00' LIMIT 1; 
SELECT  COUNT(transactionid) FROM transactions_1k WHERE date = '2012-08-26' AND time < '13:00:00' AND currency = 'EUR';
SELECT  customers.segment FROM customers ORDER BY customers.customerid ASC LIMIT 1; 
SELECT  gasstations.country FROM transactions_1k AS T1 JOIN gasstations ON T1.gasstationid = gasstations.gasstationid WHERE T1.date = '2012-08-24' AND T1.time = '12:42:00'; 
SELECT  products.productid FROM transactions_1k AS T1 WHERE T1.date = '2012-08-23' AND T1.time = '21:20:00';
SELECT  SUM(price) AS total_expenses, date FROM transactions_1k WHERE customerid = (         SELECT customerid         FROM transactions_1k         WHERE date = '2012-08-24' AND price = 124.05     )     AND date LIKE '2012-01%' GROUP BY date; 
SELECT  COUNT(*) FROM transactions_1k WHERE date = '2012-08-26' AND time BETWEEN '08:00:00' AND '09:00:00' AND gasstationid IN (SELECT gasstationid FROM gasstations WHERE country = 'CZE');
SELECT  currency FROM customers JOIN yearmonth ON customers.customerid = yearmonth.customerid WHERE yearmonth.date = '201306' AND yearmonth.consumption = 214582.17;
SELECT  gasstations.country FROM transactions_1k JOIN gasstations ON transactions_1k.gasstationid = gasstations.gasstationid WHERE transactions_1k.cardid = '667467' LIMIT 1; 
SELECT  country FROM transactions_1k t JOIN customers c ON t.customerid = c.customerid WHERE t.date = '2012-08-24' AND t.amount = 548.4;
SELECT  ROUND(CAST(COUNT(DISTINCT yearmonth.customerid) AS FLOAT) / CAST(COUNT(DISTINCT customers.customerid) AS FLOAT) * 100, 2) AS percentage FROM yearmonth JOIN customers ON yearmonth.customerid = customers.customerid WHERE strftime('%Y-%m-%d', yearmonth.date || '-01') = '2012-08-25' AND customers.currency = 'EUR'; 
SELECT (SELECT ((ym_2012.consumption - ym_2013.consumption) / ym_2012.consumption) AS consumption_decrease_rate FROM yearmonth AS ym_2012 JOIN yearmonth AS ym_2013 ON ym_2012.customerid = ym_2013.customerid WHERE ym_2012.date = '2012' AND ym_2013.date = '2013') 
SELECT  gasstationid, SUM(amount * price) AS revenue FROM transactions_1k GROUP BY gasstationid ORDER BY revenue DESC LIMIT 1; 
SELECT  WITH premium_transactions AS (     SELECT t.customerid     FROM transactions_1k AS t     JOIN products AS p ON t.productid = p.productid     JOIN gasstations AS g ON t.gasstationid = g.gasstationid     WHERE g.segment = 'Premium' AND g.country = 'SVK' ) SELECT      COUNT(DISTINCT c.customerid) * 100.0 / (SELECT COUNT(DISTINCT customerid) FROM customers WHERE segment = 'SME') AS percentage FROM customers AS c JOIN premium_transactions AS pt ON c.customerid = pt.customerid WHERE c.segment = 'SME'; 
SELECT  SUM(amount) FROM transactions_1k WHERE customerid = '38508' AND strftime('%Y%m', date) = '201201';
SELECT  p.description AS full_name FROM products p JOIN transactions_1k t ON p.productid = t.productid GROUP BY p.productid ORDER BY SUM(t.amount) DESC LIMIT 5; 
SELECT  customers.customerid, MAX(total_spent) AS top_spending_customer, AVG(price / amount) AS average_price_per_item, customers.currency FROM customers JOIN (     SELECT customerid, SUM(price) AS total_spent     FROM transactions_1k     GROUP BY customerid ) AS customer_spending ON customers.customerid = customer_spending.customerid ORDER BY total_spent DESC LIMIT 1; 
SELECT  country FROM gasstations WHERE gasstationid = (     SELECT gasstationid     FROM transactions_1k     WHERE productid = 2     ORDER BY price DESC     LIMIT 1 ); 
SELECT  yearmonth.consumption FROM transactions_1k JOIN yearmonth ON transactions_1k.customerid = yearmonth.customerid WHERE transactions_1k.date LIKE '201208%' AND transactions_1k.productid = '5' AND transactions_1k.price / transactions_1k.amount > 29.00; 
